/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.operations.trains;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import jmri.InstanceManager;
import jmri.jmrit.operations.OperationsFrame;
import jmri.jmrit.operations.OperationsPanel;
import jmri.jmrit.operations.OperationsXml;
import jmri.jmrit.operations.locations.Location;
import jmri.jmrit.operations.locations.LocationManager;
import jmri.jmrit.operations.rollingstock.RollingStock;
import jmri.jmrit.operations.rollingstock.cars.CarManager;
import jmri.jmrit.operations.rollingstock.cars.CarRoads;
import jmri.jmrit.operations.rollingstock.cars.CarTypes;
import jmri.jmrit.operations.rollingstock.engines.EngineManager;
import jmri.jmrit.operations.rollingstock.engines.EngineModels;
import jmri.jmrit.operations.rollingstock.engines.EngineTypes;
import jmri.jmrit.operations.routes.Route;
import jmri.jmrit.operations.routes.RouteEditFrame;
import jmri.jmrit.operations.routes.RouteLocation;
import jmri.jmrit.operations.routes.RouteManager;
import jmri.jmrit.operations.setup.Control;
import jmri.jmrit.operations.setup.Setup;
import jmri.jmrit.operations.trains.Bundle;
import jmri.jmrit.operations.trains.Train;
import jmri.jmrit.operations.trains.TrainCommon;
import jmri.jmrit.operations.trains.TrainConductorAction;
import jmri.jmrit.operations.trains.TrainEditBuildOptionsAction;
import jmri.jmrit.operations.trains.TrainLoadOptionsAction;
import jmri.jmrit.operations.trains.TrainManager;
import jmri.jmrit.operations.trains.TrainRoadOptionsAction;
import jmri.jmrit.operations.trains.tools.PrintSavedTrainManifestAction;
import jmri.jmrit.operations.trains.tools.PrintTrainAction;
import jmri.jmrit.operations.trains.tools.PrintTrainBuildReportAction;
import jmri.jmrit.operations.trains.tools.PrintTrainManifestAction;
import jmri.jmrit.operations.trains.tools.TrainByCarTypeAction;
import jmri.jmrit.operations.trains.tools.TrainCopyAction;
import jmri.jmrit.operations.trains.tools.TrainManifestOptionAction;
import jmri.jmrit.operations.trains.tools.TrainScriptAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TrainEditFrame
extends OperationsFrame
implements PropertyChangeListener {
    TrainManager trainManager = InstanceManager.getDefault(TrainManager.class);
    RouteManager routeManager = InstanceManager.getDefault(RouteManager.class);
    public Train _train = null;
    List<JCheckBox> typeCarCheckBoxes = new ArrayList<JCheckBox>();
    List<JCheckBox> typeEngineCheckBoxes = new ArrayList<JCheckBox>();
    List<JCheckBox> locationCheckBoxes = new ArrayList<JCheckBox>();
    JPanel typeCarPanelCheckBoxes = new JPanel();
    JPanel typeEnginePanelCheckBoxes = new JPanel();
    JPanel roadAndLoadStatusPanel = new JPanel();
    JPanel locationPanelCheckBoxes = new JPanel();
    JScrollPane typeCarPane;
    JScrollPane typeEnginePane;
    JScrollPane locationsPane;
    JLabel textRouteStatus = new JLabel();
    JLabel textModel = new JLabel(Bundle.getMessage("Model"));
    JLabel textRoad2 = new JLabel(Bundle.getMessage("Road"));
    JLabel textRoad3 = new JLabel(Bundle.getMessage("Road"));
    JLabel textEngine = new JLabel(Bundle.getMessage("Engines"));
    JButton editButton = new JButton(Bundle.getMessage("ButtonEdit"));
    JButton clearButton = new JButton(Bundle.getMessage("ClearAll"));
    JButton setButton = new JButton(Bundle.getMessage("SelectAll"));
    JButton resetButton = new JButton(Bundle.getMessage("ResetTrain"));
    JButton saveTrainButton = new JButton(Bundle.getMessage("SaveTrain"));
    JButton deleteTrainButton = new JButton(Bundle.getMessage("DeleteTrain"));
    JButton addTrainButton = new JButton(Bundle.getMessage("AddTrain"));
    JButton loadOptionButton = new JButton(Bundle.getMessage("AcceptAll"));
    JButton roadOptionButton = new JButton(Bundle.getMessage("AcceptAll"));
    JRadioButton noneRadioButton = new JRadioButton(Bundle.getMessage("None"));
    JRadioButton cabooseRadioButton = new JRadioButton(Bundle.getMessage("Caboose"));
    JRadioButton fredRadioButton = new JRadioButton(Bundle.getMessage("FRED"));
    ButtonGroup group = new ButtonGroup();
    JTextField trainNameTextField = new JTextField(Control.max_len_string_train_name - 5);
    JTextField trainDescriptionTextField = new JTextField(30);
    JTextArea commentTextArea = new JTextArea(2, 70);
    JScrollPane commentScroller = new JScrollPane(this.commentTextArea);
    JColorChooser commentColorChooser = new JColorChooser(Color.black);
    JLabel space1 = new JLabel(" ");
    JLabel space2 = new JLabel(" ");
    JLabel space3 = new JLabel(" ");
    JLabel space4 = new JLabel(" ");
    JLabel space5 = new JLabel(" ");
    JComboBox<String> hourBox = new JComboBox();
    JComboBox<String> minuteBox = new JComboBox();
    JComboBox<Route> routeBox = this.routeManager.getComboBox();
    JComboBox<String> roadCabooseBox = new JComboBox();
    JComboBox<String> roadEngineBox = new JComboBox();
    JComboBox<String> modelEngineBox = InstanceManager.getDefault(EngineModels.class).getComboBox();
    JComboBox<String> numEnginesBox = new JComboBox();
    JMenu toolMenu = new JMenu(Bundle.getMessage("MenuTools"));
    public static final String DISPOSE = "dispose";
    RouteEditFrame ref;
    protected static final String NEW_LINE = "\n";
    List<Frame> children = new ArrayList<Frame>();
    private static final Logger log = LoggerFactory.getLogger(TrainEditFrame.class);

    public TrainEditFrame(Train train) {
        super(Bundle.getMessage("TitleTrainEdit"));
        this.locationsPane = new JScrollPane(this.locationPanelCheckBoxes);
        this.locationsPane.setVerticalScrollBarPolicy(20);
        this.locationsPane.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("Stops")));
        this.typeCarPane = new JScrollPane(this.typeCarPanelCheckBoxes);
        this.typeCarPane.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("TypesCar")));
        this.typeCarPane.setVerticalScrollBarPolicy(20);
        this.typeEnginePane = new JScrollPane(this.typeEnginePanelCheckBoxes);
        this.typeEnginePane.setVerticalScrollBarPolicy(20);
        this.typeEnginePane.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("TypesEngine")));
        this._train = train;
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 1));
        JScrollPane pPane = new JScrollPane(p);
        pPane.setMinimumSize(new Dimension(300, 5 * this.trainNameTextField.getPreferredSize().height));
        pPane.setBorder(BorderFactory.createTitledBorder(""));
        JPanel p1 = new JPanel();
        p1.setLayout(new BoxLayout(p1, 0));
        JPanel pName = new JPanel();
        pName.setLayout(new GridBagLayout());
        pName.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("Name")));
        this.addItem(pName, this.trainNameTextField, 0, 0);
        JPanel pDesc = new JPanel();
        pDesc.setLayout(new GridBagLayout());
        pDesc.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("Description")));
        this.trainDescriptionTextField.setToolTipText(Bundle.getMessage("TipTrainDescription"));
        this.addItem(pDesc, this.trainDescriptionTextField, 0, 0);
        p1.add(pName);
        p1.add(pDesc);
        JPanel p2 = new JPanel();
        p2.setLayout(new BoxLayout(p2, 0));
        JPanel pdt = new JPanel();
        pdt.setLayout(new GridBagLayout());
        pdt.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("DepartTime")));
        this.hourBox.setPrototypeDisplayValue("000");
        this.minuteBox.setPrototypeDisplayValue("000");
        int i = 0;
        while (i < 24) {
            if (i < 10) {
                this.hourBox.addItem("0" + Integer.toString(i));
            } else {
                this.hourBox.addItem(Integer.toString(i));
            }
            ++i;
        }
        i = 0;
        while (i < 60) {
            if (i < 10) {
                this.minuteBox.addItem("0" + Integer.toString(i));
            } else {
                this.minuteBox.addItem(Integer.toString(i));
            }
            ++i;
        }
        this.addItem(pdt, this.space1, 0, 5);
        this.addItem(pdt, this.hourBox, 1, 5);
        this.addItem(pdt, this.space2, 2, 5);
        this.addItem(pdt, this.minuteBox, 3, 5);
        this.addItem(pdt, this.space3, 4, 5);
        JPanel pr = new JPanel();
        pr.setLayout(new GridBagLayout());
        pr.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("Route")));
        this.addItem(pr, this.routeBox, 0, 5);
        this.addItem(pr, this.space4, 1, 5);
        this.addItem(pr, this.editButton, 2, 5);
        this.addItem(pr, this.space5, 3, 5);
        this.addItem(pr, this.textRouteStatus, 4, 5);
        p2.add(pdt);
        p2.add(pr);
        p.add(p1);
        p.add(p2);
        this.locationPanelCheckBoxes.setLayout(new GridBagLayout());
        this.typeCarPanelCheckBoxes.setLayout(new GridBagLayout());
        this.typeEnginePanelCheckBoxes.setLayout(new GridBagLayout());
        this.roadAndLoadStatusPanel.setLayout(new BoxLayout(this.roadAndLoadStatusPanel, 0));
        JPanel pRoadOption = new JPanel();
        pRoadOption.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("RoadOption")));
        pRoadOption.add(this.roadOptionButton);
        this.roadOptionButton.addActionListener(new TrainRoadOptionsAction(this));
        JPanel pLoadOption = new JPanel();
        pLoadOption.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("LoadOption")));
        pLoadOption.add(this.loadOptionButton);
        this.loadOptionButton.addActionListener(new TrainLoadOptionsAction(this));
        this.roadAndLoadStatusPanel.add(pRoadOption);
        this.roadAndLoadStatusPanel.add(pLoadOption);
        this.roadAndLoadStatusPanel.setVisible(false);
        JPanel trainReq = new JPanel();
        trainReq.setLayout(new GridBagLayout());
        trainReq.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("TrainRequires")));
        int i2 = 0;
        while (i2 < Setup.getMaxNumberEngines() + 1) {
            this.numEnginesBox.addItem(Integer.toString(i2));
            ++i2;
        }
        this.numEnginesBox.addItem(Train.AUTO);
        this.numEnginesBox.setMinimumSize(new Dimension(100, 20));
        this.numEnginesBox.setToolTipText(Bundle.getMessage("TipNumberOfLocos"));
        this.addItem(trainReq, this.textEngine, 1, 1);
        this.addItem(trainReq, this.numEnginesBox, 2, 1);
        this.addItem(trainReq, this.textModel, 3, 1);
        this.modelEngineBox.insertItemAt("", 0);
        this.modelEngineBox.setSelectedIndex(0);
        this.modelEngineBox.setMinimumSize(new Dimension(120, 20));
        this.modelEngineBox.setToolTipText(Bundle.getMessage("ModelEngineTip"));
        this.addItem(trainReq, this.modelEngineBox, 4, 1);
        this.addItem(trainReq, this.textRoad2, 5, 1);
        this.roadEngineBox.insertItemAt("", 0);
        this.roadEngineBox.setSelectedIndex(0);
        this.roadEngineBox.setMinimumSize(new Dimension(120, 20));
        this.roadEngineBox.setToolTipText(Bundle.getMessage("RoadEngineTip"));
        this.addItem(trainReq, this.roadEngineBox, 6, 1);
        JPanel trainLastCar = new JPanel();
        trainLastCar.setLayout(new GridBagLayout());
        trainLastCar.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("TrainLastCar")));
        this.addItem(trainLastCar, this.noneRadioButton, 2, 2);
        this.noneRadioButton.setToolTipText(Bundle.getMessage("TipNoCabooseOrFRED"));
        this.addItem(trainLastCar, this.fredRadioButton, 3, 2);
        this.fredRadioButton.setToolTipText(Bundle.getMessage("TipFRED"));
        this.addItem(trainLastCar, this.cabooseRadioButton, 4, 2);
        this.cabooseRadioButton.setToolTipText(Bundle.getMessage("TipCaboose"));
        this.addItem(trainLastCar, this.textRoad3, 5, 2);
        this.roadCabooseBox.setMinimumSize(new Dimension(120, 20));
        this.roadCabooseBox.setToolTipText(Bundle.getMessage("RoadCabooseTip"));
        this.addItem(trainLastCar, this.roadCabooseBox, 6, 2);
        this.group.add(this.noneRadioButton);
        this.group.add(this.cabooseRadioButton);
        this.group.add(this.fredRadioButton);
        this.noneRadioButton.setSelected(true);
        JPanel pC = new JPanel();
        pC.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("Comment")));
        pC.setLayout(new GridBagLayout());
        this.addItem(pC, this.commentScroller, 1, 0);
        if (this._train != null) {
            this.addItem(pC, OperationsPanel.getColorChooserPanel(this._train.getComment(), this.commentColorChooser), 2, 0);
        } else {
            this.addItem(pC, OperationsPanel.getColorChooserPanel("", this.commentColorChooser), 2, 0);
        }
        Dimension d = new Dimension(this.getPreferredSize().width - 100, this.getPreferredSize().height);
        this.adjustTextAreaColumnWidth(this.commentScroller, this.commentTextArea, d);
        JPanel pB = new JPanel();
        pB.setLayout(new GridBagLayout());
        this.addItem(pB, this.deleteTrainButton, 0, 0);
        this.addItem(pB, this.resetButton, 1, 0);
        this.addItem(pB, this.addTrainButton, 2, 0);
        this.addItem(pB, this.saveTrainButton, 3, 0);
        this.getContentPane().add(pPane);
        this.getContentPane().add(this.locationsPane);
        this.getContentPane().add(this.typeCarPane);
        this.getContentPane().add(this.typeEnginePane);
        this.getContentPane().add(this.roadAndLoadStatusPanel);
        this.getContentPane().add(trainReq);
        this.getContentPane().add(trainLastCar);
        this.getContentPane().add(pC);
        this.getContentPane().add(pB);
        this.addButtonAction(this.editButton);
        this.addButtonAction(this.setButton);
        this.addButtonAction(this.clearButton);
        this.addButtonAction(this.resetButton);
        this.addButtonAction(this.deleteTrainButton);
        this.addButtonAction(this.addTrainButton);
        this.addButtonAction(this.saveTrainButton);
        this.addRadioButtonAction(this.noneRadioButton);
        this.addRadioButtonAction(this.cabooseRadioButton);
        this.addRadioButtonAction(this.fredRadioButton);
        this.resetButton.setToolTipText(Bundle.getMessage("TipTrainReset"));
        JMenuBar menuBar = new JMenuBar();
        menuBar.add(this.toolMenu);
        this.loadToolMenu(this.toolMenu);
        this.setJMenuBar(menuBar);
        this.addHelpMenu("package.jmri.jmrit.operations.Operations_TrainEdit", true);
        if (this._train != null) {
            this.trainNameTextField.setText(this._train.getName());
            this.trainDescriptionTextField.setText(this._train.getRawDescription());
            this.routeBox.setSelectedItem(this._train.getRoute());
            this.modelEngineBox.setSelectedItem(this._train.getEngineModel());
            this.commentTextArea.setText(TrainCommon.getTextColorString(this._train.getComment()));
            this.cabooseRadioButton.setSelected(this._train.isCabooseNeeded());
            this.fredRadioButton.setSelected(this._train.isFredNeeded());
            this.updateDepartureTime();
            this.enableButtons(true);
            this._train.addPropertyChangeListener(this);
            Route route = this._train.getRoute();
            if (route != null && this._train.getTrainDepartsRouteLocation() != null && this._train.getTrainDepartsRouteLocation().getLocation() != null && !this._train.getTrainDepartsRouteLocation().getLocation().isStaging()) {
                this.numEnginesBox.addItem(Train.AUTO_HPT);
            }
            this.numEnginesBox.setSelectedItem(this._train.getNumberEngines());
        } else {
            this.setTitle(Bundle.getMessage("TitleTrainAdd"));
            this.enableButtons(false);
        }
        this.modelEngineBox.setEnabled(!this.numEnginesBox.getSelectedItem().equals("0"));
        this.roadEngineBox.setEnabled(!this.numEnginesBox.getSelectedItem().equals("0"));
        this.updateLocationCheckboxes();
        this.updateCarTypeCheckboxes();
        this.updateEngineTypeCheckboxes();
        this.updateRoadAndLoadStatus();
        this.updateCabooseRoadComboBox();
        this.updateEngineRoadComboBox();
        this.addComboBoxAction(this.numEnginesBox);
        this.addComboBoxAction(this.routeBox);
        this.addComboBoxAction(this.modelEngineBox);
        this.routeManager.addPropertyChangeListener(this);
        InstanceManager.getDefault(CarTypes.class).addPropertyChangeListener(this);
        InstanceManager.getDefault(CarRoads.class).addPropertyChangeListener(this);
        InstanceManager.getDefault(EngineTypes.class).addPropertyChangeListener(this);
        InstanceManager.getDefault(EngineModels.class).addPropertyChangeListener(this);
        InstanceManager.getDefault(LocationManager.class).addPropertyChangeListener(this);
        this.initMinimumSize(new Dimension(600, 600));
    }

    private void loadToolMenu(JMenu toolMenu) {
        toolMenu.removeAll();
        toolMenu.add(new TrainEditBuildOptionsAction(this));
        toolMenu.add(new TrainLoadOptionsAction(this));
        toolMenu.add(new TrainRoadOptionsAction(this));
        toolMenu.add(new TrainManifestOptionAction(this));
        toolMenu.add(new TrainScriptAction(this));
        toolMenu.add(new TrainCopyAction(this._train));
        toolMenu.add(new TrainByCarTypeAction(this._train));
        toolMenu.add(new TrainConductorAction(this._train));
        toolMenu.addSeparator();
        toolMenu.add(new PrintTrainAction(false, this));
        toolMenu.add(new PrintTrainAction(true, this));
        toolMenu.add(new PrintTrainManifestAction(false, this._train));
        toolMenu.add(new PrintTrainManifestAction(true, this._train));
        toolMenu.add(new PrintTrainBuildReportAction(false, this._train));
        toolMenu.add(new PrintTrainBuildReportAction(true, this._train));
        toolMenu.add(new PrintSavedTrainManifestAction(false, this._train));
        toolMenu.add(new PrintSavedTrainManifestAction(true, this._train));
    }

    @Override
    public void buttonActionPerformed(ActionEvent ae) {
        Train train = this.trainManager.getTrainByName(this.trainNameTextField.getText().trim());
        if (ae.getSource() == this.saveTrainButton) {
            log.debug("train save button activated");
            if (this._train == null && train == null) {
                this.saveNewTrain();
            } else {
                if (train != null && train != this._train) {
                    this.reportTrainExists(Bundle.getMessage("save"));
                    return;
                }
                this.checkRoute();
                this.saveTrain();
            }
            if (Setup.isCloseWindowOnSaveEnabled()) {
                this.dispose();
            }
        }
        if (ae.getSource() == this.deleteTrainButton) {
            log.debug("train delete button activated");
            if (train == null) {
                return;
            }
            if (!this._train.reset()) {
                JOptionPane.showMessageDialog(this, MessageFormat.format(Bundle.getMessage("TrainIsInRoute"), train.getTrainTerminatesName()), Bundle.getMessage("CanNotDeleteTrain"), 0);
                return;
            }
            if (JOptionPane.showConfirmDialog(this, MessageFormat.format(Bundle.getMessage("deleteMsg"), train.getName()), Bundle.getMessage("deleteTrain"), 0) != 0) {
                return;
            }
            this.routeBox.setSelectedItem(null);
            this.trainManager.deregister(train);
            for (Frame frame : this.children) {
                frame.dispose();
            }
            this._train = null;
            this.enableButtons(false);
            OperationsXml.save();
        }
        if (ae.getSource() == this.addTrainButton) {
            if (train != null) {
                this.reportTrainExists(Bundle.getMessage("add"));
                return;
            }
            this.saveNewTrain();
        }
        if (ae.getSource() == this.editButton) {
            this.editAddRoute();
        }
        if (ae.getSource() == this.setButton) {
            this.selectCheckboxes(true);
        }
        if (ae.getSource() == this.clearButton) {
            this.selectCheckboxes(false);
        }
        if (ae.getSource() == this.resetButton && this._train != null && !this._train.reset()) {
            JOptionPane.showMessageDialog(this, MessageFormat.format(Bundle.getMessage("TrainIsInRoute"), this._train.getTrainTerminatesName()), Bundle.getMessage("CanNotResetTrain"), 0);
        }
    }

    @Override
    public void radioButtonActionPerformed(ActionEvent ae) {
        log.debug("radio button activated");
        if (this._train != null && (ae.getSource() == this.noneRadioButton || ae.getSource() == this.cabooseRadioButton || ae.getSource() == this.fredRadioButton)) {
            this.updateCabooseRoadComboBox();
        }
    }

    private void saveNewTrain() {
        Train train;
        if (!this.checkName(Bundle.getMessage("add"))) {
            return;
        }
        this._train = train = this.trainManager.newTrain(this.trainNameTextField.getText());
        this._train.addPropertyChangeListener(this);
        this.updateCarTypeCheckboxes();
        this.updateEngineTypeCheckboxes();
        this.enableButtons(true);
        this.saveTrain();
        this.loadToolMenu(this.toolMenu);
    }

    private void saveTrain() {
        if (!this.checkName(Bundle.getMessage("save"))) {
            return;
        }
        if (!this.checkModel() || !this.checkEngineRoad()) {
            return;
        }
        if (!(this._train.getName().equals(this.trainNameTextField.getText().trim()) && this._train.getRawDescription().equals(this.trainDescriptionTextField.getText()) && this._train.getComment().equals(TrainCommon.formatColorString(this.commentTextArea.getText(), this.commentColorChooser.getColor())))) {
            this._train.setModified(true);
        }
        this._train.setDepartureTime(this.hourBox.getSelectedItem().toString(), this.minuteBox.getSelectedItem().toString());
        this._train.setNumberEngines((String)this.numEnginesBox.getSelectedItem());
        if (this._train.getNumberEngines().equals("0")) {
            this.modelEngineBox.setSelectedIndex(0);
            this.roadEngineBox.setSelectedIndex(0);
        }
        this._train.setEngineRoad((String)this.roadEngineBox.getSelectedItem());
        this._train.setEngineModel((String)this.modelEngineBox.getSelectedItem());
        if (this.cabooseRadioButton.isSelected()) {
            this._train.setRequirements(1);
        }
        if (this.fredRadioButton.isSelected()) {
            this._train.setRequirements(2);
        }
        if (this.noneRadioButton.isSelected()) {
            this._train.setRequirements(0);
        }
        this._train.setCabooseRoad((String)this.roadCabooseBox.getSelectedItem());
        this._train.setName(this.trainNameTextField.getText().trim());
        this._train.setDescription(this.trainDescriptionTextField.getText());
        this._train.setComment(TrainCommon.formatColorString(this.commentTextArea.getText(), this.commentColorChooser.getColor()));
        OperationsXml.save();
    }

    private boolean checkName(String s) {
        String trainName = this.trainNameTextField.getText().trim();
        if (trainName.isEmpty()) {
            log.debug("Must enter a train name");
            JOptionPane.showMessageDialog(this, Bundle.getMessage("MustEnterName"), MessageFormat.format(Bundle.getMessage("CanNot"), s), 0);
            return false;
        }
        if (trainName.length() > Control.max_len_string_train_name) {
            JOptionPane.showMessageDialog(this, MessageFormat.format(Bundle.getMessage("TrainNameLess"), Control.max_len_string_train_name + 1), MessageFormat.format(Bundle.getMessage("CanNot"), s), 0);
            return false;
        }
        if (!OperationsXml.checkFileName(trainName)) {
            log.error("Train name must not contain reserved characters");
            JOptionPane.showMessageDialog(this, String.valueOf(Bundle.getMessage("NameResChar")) + NEW_LINE + Bundle.getMessage("ReservedChar"), MessageFormat.format(Bundle.getMessage("CanNot"), s), 0);
            return false;
        }
        return true;
    }

    private boolean checkModel() {
        String model = (String)this.modelEngineBox.getSelectedItem();
        if (this.numEnginesBox.getSelectedItem().equals("0") || model.equals("")) {
            return true;
        }
        String type = InstanceManager.getDefault(EngineModels.class).getModelType(model);
        if (!this._train.isTypeNameAccepted(type)) {
            JOptionPane.showMessageDialog(this, MessageFormat.format(Bundle.getMessage("TrainModelService"), model, type), MessageFormat.format(Bundle.getMessage("CanNot"), Bundle.getMessage("save")), 0);
            return false;
        }
        if (this.roadEngineBox.getItemCount() == 1) {
            log.debug("No locos available that match the model selected!");
            JOptionPane.showMessageDialog(this, MessageFormat.format(Bundle.getMessage("NoLocosModel"), model), MessageFormat.format(Bundle.getMessage("TrainWillNotBuild"), this._train.getName()), 2);
        }
        return true;
    }

    private boolean checkEngineRoad() {
        String road = (String)this.roadEngineBox.getSelectedItem();
        String model = (String)this.modelEngineBox.getSelectedItem();
        if (this.numEnginesBox.getSelectedItem().equals("0") || road.equals("") || !model.equals("")) {
            return true;
        }
        for (RollingStock rs : InstanceManager.getDefault(EngineManager.class).getList()) {
            if (!this._train.isTypeNameAccepted(rs.getTypeName()) || !rs.getRoadName().equals(road)) continue;
            return true;
        }
        JOptionPane.showMessageDialog(this, MessageFormat.format(Bundle.getMessage("NoLocoRoad"), road), MessageFormat.format(Bundle.getMessage("TrainWillNotBuild"), this._train.getName()), 2);
        return false;
    }

    private boolean checkRoute() {
        if (this._train.getRoute() == null) {
            JOptionPane.showMessageDialog(this, Bundle.getMessage("TrainNeedsRoute"), Bundle.getMessage("TrainNoRoute"), 2);
            return false;
        }
        return true;
    }

    private void reportTrainExists(String s) {
        log.debug("Can not {}, train already exists", (Object)s);
        JOptionPane.showMessageDialog(this, Bundle.getMessage("TrainNameExists"), MessageFormat.format(Bundle.getMessage("CanNot"), s), 0);
    }

    private void enableButtons(boolean enabled) {
        this.toolMenu.setEnabled(enabled);
        this.editButton.setEnabled(enabled);
        this.routeBox.setEnabled(enabled && this._train != null && !this._train.isBuilt());
        this.clearButton.setEnabled(enabled);
        this.resetButton.setEnabled(enabled);
        this.setButton.setEnabled(enabled);
        this.saveTrainButton.setEnabled(enabled);
        this.deleteTrainButton.setEnabled(enabled);
        this.numEnginesBox.setEnabled(enabled);
        this.enableCheckboxes(enabled);
        this.noneRadioButton.setEnabled(enabled);
        this.fredRadioButton.setEnabled(enabled);
        this.cabooseRadioButton.setEnabled(enabled);
        this.roadOptionButton.setEnabled(enabled);
        this.loadOptionButton.setEnabled(enabled);
        this.addTrainButton.setEnabled(!enabled);
    }

    private void selectCheckboxes(boolean enable) {
        int i = 0;
        while (i < this.typeCarCheckBoxes.size()) {
            JCheckBox checkBox = this.typeCarCheckBoxes.get(i);
            checkBox.setSelected(enable);
            if (this._train != null) {
                this._train.removePropertyChangeListener(this);
                if (enable) {
                    this._train.addTypeName(checkBox.getText());
                } else {
                    this._train.deleteTypeName(checkBox.getText());
                }
                this._train.addPropertyChangeListener(this);
            }
            ++i;
        }
    }

    @Override
    public void comboBoxActionPerformed(ActionEvent ae) {
        if (this._train == null) {
            return;
        }
        if (ae.getSource() == this.numEnginesBox) {
            this.modelEngineBox.setEnabled(!this.numEnginesBox.getSelectedItem().equals("0"));
            this.roadEngineBox.setEnabled(!this.numEnginesBox.getSelectedItem().equals("0"));
        }
        if (ae.getSource() == this.modelEngineBox) {
            this.updateEngineRoadComboBox();
        }
        if (ae.getSource() == this.routeBox && this.routeBox.isEnabled()) {
            Object selected;
            Route route = this._train.getRoute();
            if (route != null) {
                route.removePropertyChangeListener(this);
            }
            if ((selected = this.routeBox.getSelectedItem()) != null) {
                route = (Route)selected;
                this._train.setRoute(route);
                route.addPropertyChangeListener(this);
            } else {
                this._train.setRoute(null);
            }
            this.updateLocationCheckboxes();
            this.pack();
            this.repaint();
        }
    }

    private void enableCheckboxes(boolean enable) {
        int i = 0;
        while (i < this.typeCarCheckBoxes.size()) {
            this.typeCarCheckBoxes.get(i).setEnabled(enable);
            ++i;
        }
        i = 0;
        while (i < this.typeEngineCheckBoxes.size()) {
            this.typeEngineCheckBoxes.get(i).setEnabled(enable);
            ++i;
        }
    }

    private void addLocationCheckBoxAction(JCheckBox b) {
        b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TrainEditFrame.this.locationCheckBoxActionPerformed(e);
            }
        });
    }

    public void locationCheckBoxActionPerformed(ActionEvent ae) {
        JCheckBox b = (JCheckBox)ae.getSource();
        log.debug("checkbox change {}", (Object)b.getText());
        if (this._train == null) {
            return;
        }
        String id = b.getName();
        if (b.isSelected()) {
            this._train.deleteTrainSkipsLocation(id);
        } else {
            int result;
            if (this._train.getRoute().getLocationById(id).getLocation().isStaging() && (result = JOptionPane.showConfirmDialog(this, MessageFormat.format(Bundle.getMessage("TrainRouteStaging"), this._train.getName(), this._train.getRoute().getLocationById(id).getName()), Bundle.getMessage("TrainRouteNotStaging"), 2)) == 2) {
                b.setSelected(true);
                return;
            }
            this._train.addTrainSkipsLocation(id);
        }
    }

    private void updateRouteComboBox() {
        this.routeBox.setEnabled(false);
        this.routeManager.updateComboBox(this.routeBox);
        if (this._train != null) {
            this.routeBox.setSelectedItem(this._train.getRoute());
        }
        this.routeBox.setEnabled(true);
    }

    private void updateCarTypeCheckboxes() {
        this.typeCarCheckBoxes.clear();
        this.typeCarPanelCheckBoxes.removeAll();
        this.loadCarTypes();
        this.enableCheckboxes(this._train != null);
        this.typeCarPanelCheckBoxes.revalidate();
        this.repaint();
    }

    private void loadCarTypes() {
        int numberOfCheckboxes = this.getNumberOfCheckboxesPerLine();
        int x = 0;
        int y = 1;
        String[] stringArray = InstanceManager.getDefault(CarTypes.class).getNames();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String type = stringArray[n2];
            JCheckBox checkBox = new JCheckBox();
            this.typeCarCheckBoxes.add(checkBox);
            checkBox.setText(type);
            this.addTypeCheckBoxAction(checkBox);
            this.addItemLeft(this.typeCarPanelCheckBoxes, checkBox, x++, y);
            if (this._train != null && this._train.isTypeNameAccepted(type)) {
                checkBox.setSelected(true);
            }
            if (x > numberOfCheckboxes) {
                ++y;
                x = 0;
            }
            ++n2;
        }
        JPanel p = new JPanel();
        p.add(this.clearButton);
        p.add(this.setButton);
        GridBagConstraints gc = new GridBagConstraints();
        gc.gridwidth = this.getNumberOfCheckboxesPerLine() + 1;
        gc.gridy = ++y;
        this.typeCarPanelCheckBoxes.add((Component)p, gc);
    }

    private void updateEngineTypeCheckboxes() {
        this.typeEngineCheckBoxes.clear();
        this.typeEnginePanelCheckBoxes.removeAll();
        this.loadEngineTypes();
        this.enableCheckboxes(this._train != null);
        this.typeEnginePanelCheckBoxes.revalidate();
        this.repaint();
    }

    private void loadEngineTypes() {
        int numberOfCheckboxes = this.getNumberOfCheckboxesPerLine();
        int x = 0;
        int y = 1;
        String[] stringArray = InstanceManager.getDefault(EngineTypes.class).getNames();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String type = stringArray[n2];
            JCheckBox checkBox = new JCheckBox();
            this.typeEngineCheckBoxes.add(checkBox);
            checkBox.setText(type);
            this.addTypeCheckBoxAction(checkBox);
            this.addItemLeft(this.typeEnginePanelCheckBoxes, checkBox, x++, y);
            if (this._train != null && this._train.isTypeNameAccepted(type)) {
                checkBox.setSelected(true);
            }
            if (x > numberOfCheckboxes) {
                ++y;
                x = 0;
            }
            ++n2;
        }
    }

    private void updateRoadComboBoxes() {
        this.updateCabooseRoadComboBox();
        this.updateEngineRoadComboBox();
    }

    private void updateCabooseRoadComboBox() {
        this.roadCabooseBox.removeAllItems();
        this.roadCabooseBox.addItem("");
        if (this.noneRadioButton.isSelected()) {
            this.roadCabooseBox.setEnabled(false);
            return;
        }
        this.roadCabooseBox.setEnabled(true);
        List<String> roads = this.cabooseRadioButton.isSelected() ? InstanceManager.getDefault(CarManager.class).getCabooseRoadNames() : InstanceManager.getDefault(CarManager.class).getFredRoadNames();
        for (String road : roads) {
            this.roadCabooseBox.addItem(road);
        }
        if (this._train != null) {
            this.roadCabooseBox.setSelectedItem(this._train.getCabooseRoad());
        }
    }

    private void updateEngineRoadComboBox() {
        String engineModel = (String)this.modelEngineBox.getSelectedItem();
        if (engineModel == null) {
            return;
        }
        this.roadEngineBox.removeAllItems();
        this.roadEngineBox.addItem("");
        List<String> roads = InstanceManager.getDefault(EngineManager.class).getEngineRoadNames(engineModel);
        for (String roadName : roads) {
            this.roadEngineBox.addItem(roadName);
        }
        if (this._train != null) {
            this.roadEngineBox.setSelectedItem(this._train.getEngineRoad());
        }
    }

    private void addTypeCheckBoxAction(JCheckBox b) {
        b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TrainEditFrame.this.typeCheckBoxActionPerformed(e);
            }
        });
    }

    public void typeCheckBoxActionPerformed(ActionEvent ae) {
        JCheckBox b = (JCheckBox)ae.getSource();
        log.debug("checkbox change {}", (Object)b.getText());
        if (this._train == null) {
            return;
        }
        if (b.isSelected()) {
            this._train.addTypeName(b.getText());
        } else {
            this._train.deleteTypeName(b.getText());
        }
    }

    private void updateLocationCheckboxes() {
        this.updateRouteStatus();
        this.locationCheckBoxes.clear();
        this.locationPanelCheckBoxes.removeAll();
        int y = 0;
        Route route = null;
        if (this._train != null) {
            route = this._train.getRoute();
        }
        if (route != null) {
            List<RouteLocation> routeList = route.getLocationsBySequenceList();
            for (RouteLocation rl : routeList) {
                JCheckBox checkBox = new JCheckBox();
                this.locationCheckBoxes.add(checkBox);
                checkBox.setText(rl.toString());
                checkBox.setName(rl.getId());
                this.addItemLeft(this.locationPanelCheckBoxes, checkBox, 0, y++);
                Location loc = InstanceManager.getDefault(LocationManager.class).getLocationByName(rl.getName());
                if (loc != null) {
                    loc.removePropertyChangeListener(this);
                    loc.addPropertyChangeListener(this);
                    boolean services = false;
                    if ((rl.getTrainDirection() & loc.getTrainDirections()) != 0) {
                        services = true;
                    } else if (this._train.isLocalSwitcher() || rl == this._train.getTrainTerminatesRouteLocation()) {
                        services = true;
                    }
                    if (services && (rl.isDropAllowed() || rl.isPickUpAllowed()) && rl.getMaxCarMoves() > 0) {
                        checkBox.setSelected(!this._train.isLocationSkipped(rl.getId()));
                    } else {
                        checkBox.setEnabled(false);
                    }
                    this.addLocationCheckBoxAction(checkBox);
                    continue;
                }
                checkBox.setEnabled(false);
            }
        }
        this.locationPanelCheckBoxes.revalidate();
    }

    private void updateRouteStatus() {
        Route route = null;
        this.textRouteStatus.setText("");
        if (this._train != null) {
            route = this._train.getRoute();
        }
        if (route != null && !route.getStatus().equals(Route.OKAY)) {
            this.textRouteStatus.setText(route.getStatus());
            this.textRouteStatus.setForeground(Color.RED);
        }
    }

    private void editAddRoute() {
        log.debug("Edit/add route");
        if (this.ref != null) {
            this.ref.dispose();
        }
        this.ref = new RouteEditFrame();
        this.setChildFrame(this.ref);
        Route route = null;
        Object selected = this.routeBox.getSelectedItem();
        if (selected != null) {
            route = (Route)selected;
        }
        if (route != null && route.getStatus().equals(Route.TRAIN_BUILT)) {
            StringBuffer buf = new StringBuffer(Bundle.getMessage("DoNotModifyRoute"));
            for (Train train : InstanceManager.getDefault(TrainManager.class).getTrainsByIdList()) {
                if (train.getRoute() != route || !train.isBuilt()) continue;
                buf.append(NEW_LINE + MessageFormat.format(Bundle.getMessage("TrainIsBuilt"), train.getName(), route.getName()));
            }
            JOptionPane.showMessageDialog(this, buf.toString(), Bundle.getMessage("BuiltTrain"), 2);
        }
        this.ref.initComponents(route, this._train);
    }

    private void updateDepartureTime() {
        this.hourBox.setSelectedItem(this._train.getDepartureTimeHour());
        this.minuteBox.setSelectedItem(this._train.getDepartureTimeMinute());
        RouteLocation rl = this._train.getTrainDepartsRouteLocation();
        if (rl != null && !rl.getDepartureTime().equals("")) {
            this.hourBox.setEnabled(false);
            this.minuteBox.setEnabled(false);
        } else {
            this.hourBox.setEnabled(true);
            this.minuteBox.setEnabled(true);
        }
    }

    private void updateRoadAndLoadStatus() {
        if (this._train != null) {
            if (this._train.getRoadOption().equals(Train.ALL_ROADS)) {
                this.roadOptionButton.setText(Bundle.getMessage("AcceptAll"));
            } else if (this._train.getRoadOption().equals(Train.INCLUDE_ROADS)) {
                this.roadOptionButton.setText(String.valueOf(Bundle.getMessage("AcceptOnly")) + " " + this._train.getRoadNames().length + " " + Bundle.getMessage("Roads"));
            } else {
                this.roadOptionButton.setText(String.valueOf(Bundle.getMessage("Exclude")) + " " + this._train.getRoadNames().length + " " + Bundle.getMessage("Roads"));
            }
            if (this._train.getLoadOption().equals(Train.ALL_LOADS)) {
                this.loadOptionButton.setText(Bundle.getMessage("AcceptAll"));
            } else if (this._train.getLoadOption().equals(Train.INCLUDE_LOADS)) {
                this.loadOptionButton.setText(String.valueOf(Bundle.getMessage("AcceptOnly")) + " " + this._train.getLoadNames().length + " " + Bundle.getMessage("Loads"));
            } else {
                this.loadOptionButton.setText(String.valueOf(Bundle.getMessage("Exclude")) + " " + this._train.getLoadNames().length + " " + Bundle.getMessage("Loads"));
            }
            if (!this._train.getRoadOption().equals(Train.ALL_ROADS) || !this._train.getLoadOption().equals(Train.ALL_LOADS)) {
                this.roadAndLoadStatusPanel.setVisible(true);
            }
        }
    }

    public void setChildFrame(Frame frame) {
        if (this.children.contains(frame)) {
            return;
        }
        this.children.add(frame);
    }

    @Override
    public void dispose() {
        InstanceManager.getDefault(LocationManager.class).removePropertyChangeListener(this);
        InstanceManager.getDefault(EngineTypes.class).removePropertyChangeListener(this);
        InstanceManager.getDefault(EngineModels.class).removePropertyChangeListener(this);
        InstanceManager.getDefault(CarTypes.class).removePropertyChangeListener(this);
        InstanceManager.getDefault(CarRoads.class).removePropertyChangeListener(this);
        this.routeManager.removePropertyChangeListener(this);
        for (Frame frame : this.children) {
            frame.dispose();
        }
        if (this._train != null) {
            this._train.removePropertyChangeListener(this);
            Route route = this._train.getRoute();
            if (route != null) {
                for (RouteLocation rl : route.getLocationsBySequenceList()) {
                    Location loc = rl.getLocation();
                    if (loc == null) continue;
                    loc.removePropertyChangeListener(this);
                }
            }
        }
        super.dispose();
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        if (e.getPropertyName().equals("CarTypes Length") || e.getPropertyName().equals("TrainTypes")) {
            this.updateCarTypeCheckboxes();
        }
        if (e.getPropertyName().equals("EngineTypesLength")) {
            this.updateEngineTypeCheckboxes();
        }
        if (e.getPropertyName().equals("routesListLengthChanged")) {
            this.updateRouteComboBox();
        }
        if (e.getPropertyName().equals("routeListChange") || e.getPropertyName().equals("locationsListLength") || e.getPropertyName().equals("locationName") || e.getPropertyName().equals("locationTrainDirection")) {
            this.updateLocationCheckboxes();
            this.pack();
            this.repaint();
        }
        if (e.getPropertyName().equals("CarRoads Length")) {
            this.updateRoadComboBoxes();
        }
        if (e.getPropertyName().equals("EngineModels")) {
            InstanceManager.getDefault(EngineModels.class).updateComboBox(this.modelEngineBox);
            this.modelEngineBox.insertItemAt("", 0);
            this.modelEngineBox.setSelectedIndex(0);
            if (this._train != null) {
                this.modelEngineBox.setSelectedItem(this._train.getEngineModel());
            }
        }
        if (e.getPropertyName().equals("TrainDepartureTime")) {
            this.updateDepartureTime();
        }
        if (e.getPropertyName().equals("TrainRoute") && this._train != null) {
            this.routeBox.setSelectedItem(this._train.getRoute());
        }
        if (e.getPropertyName().equals("routeStatusChange")) {
            this.enableButtons(this._train != null);
            this.updateRouteStatus();
        }
        if (e.getPropertyName().equals("TrainRoads") || e.getPropertyName().equals("TrainLoads")) {
            this.updateRoadAndLoadStatus();
        }
    }
}

