/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.operations.trains;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import jmri.InstanceManager;
import jmri.beans.PropertyChangeSupport;
import jmri.jmrit.operations.locations.Location;
import jmri.jmrit.operations.rollingstock.cars.Car;
import jmri.jmrit.operations.rollingstock.engines.Engine;
import jmri.jmrit.operations.routes.RouteLocation;
import jmri.jmrit.operations.setup.Setup;
import jmri.jmrit.operations.trains.Bundle;
import jmri.jmrit.operations.trains.Train;
import jmri.jmrit.operations.trains.TrainCsvCommon;
import jmri.jmrit.operations.trains.TrainManagerXml;
import jmri.util.FileUtil;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TrainCsvManifest
extends TrainCsvCommon {
    private static final Logger log = LoggerFactory.getLogger(TrainCsvManifest.class);

    public TrainCsvManifest(Train train) {
        if (!Setup.isGenerateCsvManifestEnabled()) {
            return;
        }
        File file = InstanceManager.getDefault(TrainManagerXml.class).createTrainCsvManifestFile(train.getName());
        try {
            Throwable throwable = null;
            Object var4_5 = null;
            try (CSVPrinter fileOut = new CSVPrinter((Appendable)new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), StandardCharsets.UTF_8)), CSVFormat.DEFAULT);){
                this.printHeader(fileOut);
                this.printRailroadName(fileOut, train.getRailroadName().isEmpty() ? Setup.getRailroadName() : train.getRailroadName());
                this.printTrainName(fileOut, train.getName());
                this.printTrainDescription(fileOut, train.getDescription());
                this.printPrinterName(fileOut, this.locationManager.getLocationByName(train.getTrainDepartsName()).getDefaultPrinterName());
                String logoURL = FileUtil.getExternalFilename(Setup.getManifestLogoURL());
                if (!train.getManifestLogoPathName().equals("")) {
                    logoURL = FileUtil.getExternalFilename(train.getManifestLogoPathName());
                }
                if (!logoURL.isEmpty()) {
                    fileOut.printRecord(new Object[]{"LOGO", Bundle.getMessage("csvLogoFilePath"), logoURL});
                }
                this.printValidity(fileOut, TrainCsvManifest.getDate(true));
                if (!train.getComment().equals("")) {
                    String[] comments;
                    String[] stringArray = comments = train.getComment().split("\n");
                    int n = comments.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String comment = stringArray[n2];
                        fileOut.printRecord(new Object[]{"TC", Bundle.getMessage("csvTrainComment"), comment});
                        ++n2;
                    }
                }
                if (Setup.isPrintRouteCommentsEnabled()) {
                    fileOut.printRecord(new Object[]{"RC", Bundle.getMessage("csvRouteComment"), train.getRoute().getComment()});
                }
                List<Engine> engineList = this.engineManager.getByTrainBlockingList(train);
                List<Car> carList = this.carManager.getByTrainDestinationList(train);
                boolean newWork = false;
                String previousRouteLocationName = null;
                List<RouteLocation> routeList = train.getRoute().getLocationsBySequenceList();
                for (RouteLocation rl : routeList) {
                    int count;
                    Iterator<PropertyChangeSupport> comments;
                    String routeLocationName;
                    String locationName = routeLocationName = TrainCsvManifest.splitString(rl.getName());
                    if (!routeLocationName.equals(previousRouteLocationName)) {
                        this.printLocationName(fileOut, locationName);
                        if (rl != train.getTrainDepartsRouteLocation()) {
                            fileOut.printRecord(new Object[]{"AT", Bundle.getMessage("csvArrivalTime"), train.getExpectedArrivalTime(rl)});
                        }
                        if (rl == train.getTrainDepartsRouteLocation()) {
                            fileOut.printRecord(new Object[]{"DT", Bundle.getMessage("csvDepartureTime"), train.getFormatedDepartureTime()});
                        } else if (!rl.getDepartureTime().equals("")) {
                            fileOut.printRecord(new Object[]{"DTR", Bundle.getMessage("csvDepartureTimeRoute"), rl.getFormatedDepartureTime()});
                        } else {
                            fileOut.printRecord(new Object[]{"EDT", Bundle.getMessage("csvEstimatedDepartureTime"), train.getExpectedDepartureTime(rl)});
                        }
                        Location location = rl.getLocation();
                        if (Setup.isPrintLocationCommentsEnabled() && !location.getComment().equals("")) {
                            Iterator<PropertyChangeSupport> iterator = comments = location.getComment().split("\n");
                            int n = ((Iterator<PropertyChangeSupport>)iterator).length;
                            int n3 = 0;
                            while (n3 < n) {
                                Iterator<PropertyChangeSupport> comment = iterator[n3];
                                this.printLocationComment(fileOut, (String)((Object)comment));
                                ++n3;
                            }
                        }
                        if (Setup.isPrintTruncateManifestEnabled() && location.isSwitchListEnabled()) {
                            fileOut.printRecord(new Object[]{"TRUN", Bundle.getMessage("csvTruncate")});
                        }
                    }
                    if (!rl.getComment().equals("")) {
                        this.printRouteLocationComment(fileOut, rl.getComment());
                    }
                    this.printTrackComments(fileOut, rl, carList);
                    this.checkForEngineOrCabooseChange(fileOut, train, rl);
                    for (Engine engine : engineList) {
                        if (engine.getRouteLocation() != rl) continue;
                        this.printEngine(fileOut, engine, "PL", Bundle.getMessage("csvPickUpLoco"));
                    }
                    for (Engine engine : engineList) {
                        if (engine.getRouteDestination() != rl) continue;
                        this.printEngine(fileOut, engine, "SL", Bundle.getMessage("csvSetOutLoco"));
                    }
                    for (RouteLocation rld : train.getTrainBlockingOrder()) {
                        for (Car car : carList) {
                            if (car.getRouteLocation() != rl || car.getRouteDestination() != rld) continue;
                            newWork = true;
                            count = 0;
                            if (car.isUtility() && (count = this.countPickupUtilityCars(carList, car, true)) == 0) continue;
                            this.printCar(fileOut, car, "PC", Bundle.getMessage("csvPickUpCar"), count);
                        }
                    }
                    comments = carList.iterator();
                    while (comments.hasNext()) {
                        Car car = (Car)comments.next();
                        if (car.getRouteDestination() != rl) continue;
                        newWork = true;
                        int count2 = 0;
                        if (car.isUtility() && (count2 = this.countSetoutUtilityCars(carList, car, false, true)) == 0) continue;
                        this.printCar(fileOut, car, "SC", Bundle.getMessage("csvSetOutCar"), count2);
                    }
                    List<Car> rsByLocation = this.carManager.getByLocationList();
                    ArrayList<Car> cList = new ArrayList<Car>();
                    for (Car rs : rsByLocation) {
                        if (rs.getLocation() != rl.getLocation() || rs.getRouteLocation() != null || rs.getTrack() == null) continue;
                        cList.add(rs);
                    }
                    this.clearUtilityCarTypes();
                    for (Car car : cList) {
                        if (car.getTrack().getLocation().isStaging() || !car.getTrack().isPickupTrainAccepted(train) || car.getTrack().getPickupIds().length != 1 || !car.getTrack().getPickupOption().equals("trains")) continue;
                        count = 0;
                        if (car.isUtility() && (count = this.countPickupUtilityCars(cList, car, false)) == 0) continue;
                        this.printCar(fileOut, car, "HOLD", Bundle.getMessage("csvHoldCar"), count);
                    }
                    if (rl != train.getTrainTerminatesRouteLocation()) {
                        RouteLocation rlNext = train.getRoute().getNextRouteLocation(rl);
                        String nextRouteLocationName = TrainCsvManifest.splitString(rlNext.getName());
                        if (!routeLocationName.equals(nextRouteLocationName)) {
                            if (newWork) {
                                this.printTrainDeparts(fileOut, locationName, rl.getTrainDirectionString());
                                this.printTrainLength(fileOut, train.getTrainLength(rl), train.getNumberEmptyCarsInTrain(rl), train.getNumberCarsInTrain(rl));
                                this.printTrainWeight(fileOut, train.getTrainWeight(rl));
                                newWork = false;
                            } else {
                                fileOut.printRecord(new Object[]{"NW", Bundle.getMessage("csvNoWork")});
                            }
                        }
                    } else {
                        this.printTrainTerminates(fileOut, locationName);
                    }
                    previousRouteLocationName = routeLocationName;
                }
                this.listCarsLocationUnknown(fileOut);
                fileOut.flush();
                fileOut.close();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException iOException) {
            log.error("Can not open CSV manifest file: {}", (Object)file.getName());
        }
    }
}

