/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.operations.trains;

import java.io.IOException;
import java.util.List;
import jmri.InstanceManager;
import jmri.jmrit.operations.locations.Location;
import jmri.jmrit.operations.locations.Track;
import jmri.jmrit.operations.rollingstock.cars.Car;
import jmri.jmrit.operations.rollingstock.cars.CarManager;
import jmri.jmrit.operations.rollingstock.engines.Engine;
import jmri.jmrit.operations.routes.RouteLocation;
import jmri.jmrit.operations.setup.Setup;
import jmri.jmrit.operations.trains.Bundle;
import jmri.jmrit.operations.trains.Train;
import jmri.jmrit.operations.trains.TrainCommon;
import org.apache.commons.csv.CSVPrinter;

public class TrainCsvCommon
extends TrainCommon {
    protected final void printDepartureTime(CSVPrinter printer, String time) throws IOException {
        printer.printRecord(new Object[]{"DT", Bundle.getMessage("csvDepartureTime"), time});
    }

    protected final void printHeader(CSVPrinter printer) throws IOException {
        printer.printRecord(new Object[]{Bundle.getMessage("csvOperator"), Bundle.getMessage("csvDescription"), Bundle.getMessage("csvParameters")});
    }

    protected final void printLocationComment(CSVPrinter printer, String comment) throws IOException {
        printer.printRecord(new Object[]{"LC", Bundle.getMessage("csvLocationComment"), comment});
    }

    protected final void printLocationName(CSVPrinter printer, String name) throws IOException {
        printer.printRecord(new Object[]{"LN", Bundle.getMessage("csvLocationName"), name});
    }

    protected final void printPrinterName(CSVPrinter printer, String name) throws IOException {
        printer.printRecord(new Object[]{"PRNTR", Bundle.getMessage("csvPrinterName"), name});
    }

    protected final void printRailroadName(CSVPrinter printer, String name) throws IOException {
        printer.printRecord(new Object[]{"RN", Bundle.getMessage("csvRailroadName"), name});
    }

    protected final void printRemoveHelpers(CSVPrinter printer) throws IOException {
        printer.printRecord(new Object[]{"RH", Bundle.getMessage("csvRemoveHelpers")});
    }

    protected final void printRouteLocationComment(CSVPrinter printer, String comment) throws IOException {
        printer.printRecord(new Object[]{"RLC", Bundle.getMessage("csvRouteLocationComment"), comment});
    }

    protected final void printTrainDeparts(CSVPrinter printer, String name, String direction) throws IOException {
        printer.printRecord(new Object[]{"TD", Bundle.getMessage("csvTrainDeparts"), name, direction});
    }

    protected final void printTrainDescription(CSVPrinter printer, String description) throws IOException {
        printer.printRecord(new Object[]{"TM", Bundle.getMessage("csvTrainManifestDescription"), description});
    }

    protected final void printTrainLength(CSVPrinter printer, int length, int empty, int total) throws IOException {
        printer.printRecord(new Object[]{"TL", Bundle.getMessage("csvTrainLengthEmptiesCars"), length, empty, total});
    }

    protected final void printTrainName(CSVPrinter printer, String name) throws IOException {
        printer.printRecord(new Object[]{"TN", Bundle.getMessage("csvTrainName"), name});
    }

    protected final void printTrainTerminates(CSVPrinter printer, String name) throws IOException {
        printer.printRecord(new Object[]{"TT", Bundle.getMessage("csvTrainTerminates"), name});
    }

    protected final void printTrainWeight(CSVPrinter printer, int weight) throws IOException {
        printer.printRecord(new Object[]{"TW", Bundle.getMessage("csvTrainWeight"), weight});
    }

    protected final void printValidity(CSVPrinter printer, String date) throws IOException {
        printer.printRecord(new Object[]{"VT", Bundle.getMessage("csvValid"), date});
    }

    protected void printCar(CSVPrinter fileOut, Car car, String code, String message, int count) throws IOException {
        fileOut.printRecord(new Object[]{code, message, car.getRoadName(), car.getNumber(), car.getTypeName(), car.getLength(), car.getLoadName(), car.getColor(), car.getLocationName(), car.getTrackName(), car.getDestinationName(), car.getDestinationTrackName(), car.getOwner(), car.getKernelName(), car.getComment(), car.getPickupComment(), car.getDropComment(), car.isCaboose() ? "C" : "", car.hasFred() ? "F" : "", car.isHazardous() ? "H" : "", car.getRfid(), car.getReturnWhenEmptyDestinationName(), car.getReturnWhenEmptyDestTrackName(), car.isUtility() ? "U" : "", count, car.getFinalDestinationName(), car.getFinalDestinationTrackName(), car.getLoadType()});
    }

    protected void printEngine(CSVPrinter fileOut, Engine engine, String code, String message) throws IOException {
        fileOut.printRecord(new Object[]{code, message, engine.getRoadName(), engine.getNumber(), engine.getModel(), engine.getLength(), engine.getTypeName(), engine.getHp(), engine.getLocationName(), engine.getTrackName(), engine.getDestinationName(), engine.getDestinationTrackName(), engine.getOwner(), engine.getConsistName(), engine.isLead() ? "Lead loco" : "", engine.getComment(), engine.getRfid()});
    }

    protected final void checkForEngineOrCabooseChange(CSVPrinter fileOut, Train train, RouteLocation rl) throws IOException {
        if (train.getSecondLegOptions() != 0) {
            if (rl == train.getSecondLegStartRouteLocation()) {
                this.engineCsvChange(fileOut, rl, train.getSecondLegOptions());
            }
            if (rl == train.getSecondLegEndRouteLocation()) {
                this.printRemoveHelpers(fileOut);
            }
        }
        if (train.getThirdLegOptions() != 0) {
            if (rl == train.getThirdLegStartRouteLocation()) {
                this.engineCsvChange(fileOut, rl, train.getThirdLegOptions());
            }
            if (rl == train.getThirdLegEndRouteLocation()) {
                this.printRemoveHelpers(fileOut);
            }
        }
    }

    protected void engineCsvChange(CSVPrinter fileOut, RouteLocation rl, int legOptions) throws IOException {
        if ((legOptions & 2) == 2) {
            fileOut.printRecord(new Object[]{"AH", Bundle.getMessage("csvAddHelpers")});
        }
        if ((legOptions & 8) == 8 || (legOptions & 4) == 4) {
            fileOut.printRecord(new Object[]{"CC", Bundle.getMessage("csvChangeCaboose")});
        }
        if ((legOptions & 1) == 1) {
            fileOut.printRecord(new Object[]{"CL", Bundle.getMessage("csvChangeLocos")});
        }
    }

    protected void printTrackComments(CSVPrinter fileOut, RouteLocation rl, List<Car> carList) throws IOException {
        Location location = rl.getLocation();
        if (location != null) {
            List<Track> tracks = location.getTracksByNameList(null);
            for (Track track : tracks) {
                String comment;
                int n;
                int n2;
                String[] stringArray;
                String[] comments;
                boolean pickup = false;
                boolean setout = false;
                for (Car car : carList) {
                    if (car.getRouteLocation() == rl && car.getTrack() != null && car.getTrack() == track) {
                        pickup = true;
                    }
                    if (car.getRouteDestination() != rl || car.getDestinationTrack() == null || car.getDestinationTrack() != track) continue;
                    setout = true;
                }
                if (pickup && setout && !track.getCommentBoth().equals("")) {
                    stringArray = comments = track.getCommentBoth().split("\n");
                    n2 = comments.length;
                    n = 0;
                    while (n < n2) {
                        comment = stringArray[n];
                        fileOut.printRecord(new Object[]{"TKCB", Bundle.getMessage("csvTrackCommentBoth"), comment});
                        ++n;
                    }
                    continue;
                }
                if (pickup && !setout && !track.getCommentPickup().equals("")) {
                    stringArray = comments = track.getCommentPickup().split("\n");
                    n2 = comments.length;
                    n = 0;
                    while (n < n2) {
                        comment = stringArray[n];
                        fileOut.printRecord(new Object[]{"TKCP", Bundle.getMessage("csvTrackCommentPickUp"), comment});
                        ++n;
                    }
                    continue;
                }
                if (pickup || !setout || track.getCommentSetout().equals("")) continue;
                stringArray = comments = track.getCommentSetout().split("\n");
                n2 = comments.length;
                n = 0;
                while (n < n2) {
                    comment = stringArray[n];
                    fileOut.printRecord(new Object[]{"TKCS", Bundle.getMessage("csvTrackCommentSetOut"), comment});
                    ++n;
                }
            }
        }
    }

    protected void listCarsLocationUnknown(CSVPrinter fileOut) throws IOException {
        List<Car> cars = InstanceManager.getDefault(CarManager.class).getCarsLocationUnknown();
        if (cars.isEmpty()) {
            return;
        }
        fileOut.printRecord(new Object[]{"SMCM", Bundle.getMessage("csvSearchMiaMessage"), Setup.getMiaComment()});
        for (Car car : cars) {
            this.printCar(fileOut, car, "SMC", Bundle.getMessage("csvSearchMissingCar"), 0);
        }
    }
}

