/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.operations.trains;

import com.fasterxml.jackson.databind.util.StdDateFormat;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.io.PrintWriter;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import javax.swing.JLabel;
import jmri.InstanceManager;
import jmri.Timebase;
import jmri.jmrit.operations.locations.Location;
import jmri.jmrit.operations.locations.LocationManager;
import jmri.jmrit.operations.locations.Track;
import jmri.jmrit.operations.rollingstock.RollingStock;
import jmri.jmrit.operations.rollingstock.cars.Car;
import jmri.jmrit.operations.rollingstock.cars.CarColors;
import jmri.jmrit.operations.rollingstock.cars.CarLengths;
import jmri.jmrit.operations.rollingstock.cars.CarLoads;
import jmri.jmrit.operations.rollingstock.cars.CarManager;
import jmri.jmrit.operations.rollingstock.cars.CarOwners;
import jmri.jmrit.operations.rollingstock.cars.CarRoads;
import jmri.jmrit.operations.rollingstock.cars.CarTypes;
import jmri.jmrit.operations.rollingstock.cars.KernelManager;
import jmri.jmrit.operations.rollingstock.engines.ConsistManager;
import jmri.jmrit.operations.rollingstock.engines.Engine;
import jmri.jmrit.operations.rollingstock.engines.EngineManager;
import jmri.jmrit.operations.rollingstock.engines.EngineModels;
import jmri.jmrit.operations.routes.RouteLocation;
import jmri.jmrit.operations.setup.Control;
import jmri.jmrit.operations.setup.Setup;
import jmri.jmrit.operations.trains.Bundle;
import jmri.jmrit.operations.trains.Train;
import jmri.jmrit.operations.trains.TrainManifestHeaderText;
import jmri.jmrit.operations.trains.TrainManifestText;
import jmri.util.ColorUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TrainCommon {
    protected static final String TAB = "    ";
    protected static final String NEW_LINE = "\n";
    protected static final String SPACE = " ";
    protected static final String BLANK_LINE = " ";
    protected static final String HORIZONTAL_LINE_CHAR = "-";
    protected static final String BUILD_REPORT_CHAR = "-";
    public static final String HYPHEN = "-";
    protected static final String VERTICAL_LINE_CHAR = "|";
    protected static final String TEXT_COLOR_START = "<FONT color=\"";
    protected static final String TEXT_COLOR_END = "</FONT>";
    protected static final boolean PICKUP = true;
    protected static final boolean IS_MANIFEST = true;
    public static final boolean LOCAL = true;
    protected static final boolean ENGINE = true;
    public static final boolean IS_TWO_COLUMN_TRACK = true;
    CarManager carManager = InstanceManager.getDefault(CarManager.class);
    EngineManager engineManager = InstanceManager.getDefault(EngineManager.class);
    LocationManager locationManager = InstanceManager.getDefault(LocationManager.class);
    protected boolean pickupCars;
    protected boolean dropCars;
    boolean printPickupHeader = true;
    boolean printSetoutHeader = true;
    boolean printLocalMoveHeader = true;
    List<Car> doneCars = new ArrayList<Car>();
    int index = 0;
    List<String> utilityCarTypes = new ArrayList<String>();
    private static final int UTILITY_CAR_COUNT_FIELD_SIZE = 3;
    protected static final Dimension PAPER_MARGINS = new Dimension(84, 72);
    private static final Logger log = LoggerFactory.getLogger(TrainCommon.class);

    protected void blockLocosTwoColumn(PrintWriter file, List<Engine> engineList, RouteLocation rl, boolean isManifest) {
        if (this.isThereWorkAtLocation(null, engineList, rl)) {
            this.printEngineHeader(file, isManifest);
        }
        int lineLength = TrainCommon.getLineLength(isManifest);
        for (Engine engine : engineList) {
            String s;
            if (engine.getRouteLocation() == rl && !engine.getTrackName().equals("")) {
                String pullText = TrainCommon.padAndTruncate(this.pickupEngine(engine).trim(), lineLength / 2);
                pullText = TrainCommon.formatColorString(pullText, Setup.getPickupColor());
                s = String.valueOf(pullText) + VERTICAL_LINE_CHAR + TrainCommon.tabString("", lineLength / 2 - 1);
                this.addLine(file, s);
            }
            if (engine.getRouteDestination() != rl) continue;
            String dropText = TrainCommon.padAndTruncate(this.dropEngine(engine).trim(), lineLength / 2 - 1);
            dropText = TrainCommon.formatColorString(dropText, Setup.getDropColor());
            s = String.valueOf(TrainCommon.tabString("", lineLength / 2)) + VERTICAL_LINE_CHAR + dropText;
            this.addLine(file, s);
        }
    }

    protected void pickupEngines(PrintWriter file, List<Engine> engineList, RouteLocation rl, boolean isManifest) {
        boolean printHeader = Setup.isPrintHeadersEnabled();
        for (Engine engine : engineList) {
            if (engine.getRouteLocation() != rl || engine.getTrackName().equals("")) continue;
            if (printHeader) {
                this.printPickupEngineHeader(file, isManifest);
                printHeader = false;
            }
            this.pickupEngine(file, engine, isManifest);
        }
    }

    private void pickupEngine(PrintWriter file, Engine engine, boolean isManifest) {
        String[] format;
        StringBuffer buf = new StringBuffer(TrainCommon.padAndTruncateIfNeeded(Setup.getPickupEnginePrefix(), isManifest ? Setup.getManifestPrefixLength() : Setup.getSwitchListPrefixLength()));
        String[] stringArray = format = Setup.getPickupEngineMessageFormat();
        int n = format.length;
        int n2 = 0;
        while (n2 < n) {
            String attribute = stringArray[n2];
            String s = this.getEngineAttribute(engine, attribute, true);
            if (!this.checkStringLength(String.valueOf(buf.toString()) + s, isManifest)) {
                this.addLine(file, buf.toString());
                buf = new StringBuffer(TAB);
            }
            buf.append(s);
            ++n2;
        }
        this.addLine(file, buf.toString());
    }

    protected void dropEngines(PrintWriter file, List<Engine> engineList, RouteLocation rl, boolean isManifest) {
        boolean printHeader = Setup.isPrintHeadersEnabled();
        for (Engine engine : engineList) {
            if (engine.getRouteDestination() != rl) continue;
            if (printHeader) {
                this.printDropEngineHeader(file, isManifest);
                printHeader = false;
            }
            this.dropEngine(file, engine, isManifest);
        }
    }

    private void dropEngine(PrintWriter file, Engine engine, boolean isManifest) {
        String[] format;
        StringBuffer buf = new StringBuffer(TrainCommon.padAndTruncateIfNeeded(Setup.getDropEnginePrefix(), isManifest ? Setup.getManifestPrefixLength() : Setup.getSwitchListPrefixLength()));
        String[] stringArray = format = Setup.getDropEngineMessageFormat();
        int n = format.length;
        int n2 = 0;
        while (n2 < n) {
            String attribute = stringArray[n2];
            String s = this.getEngineAttribute(engine, attribute, false);
            if (!this.checkStringLength(String.valueOf(buf.toString()) + s, isManifest)) {
                this.addLine(file, buf.toString());
                buf = new StringBuffer(TAB);
            }
            buf.append(s);
            ++n2;
        }
        this.addLine(file, buf.toString());
    }

    public String pickupEngine(Engine engine) {
        StringBuilder builder = new StringBuilder();
        String[] stringArray = Setup.getPickupEngineMessageFormat();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String attribute = stringArray[n2];
            builder.append(this.getEngineAttribute(engine, attribute, true));
            ++n2;
        }
        return builder.toString();
    }

    public String dropEngine(Engine engine) {
        StringBuilder builder = new StringBuilder();
        String[] stringArray = Setup.getDropEngineMessageFormat();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String attribute = stringArray[n2];
            builder.append(this.getEngineAttribute(engine, attribute, false));
            ++n2;
        }
        return builder.toString();
    }

    protected void blockCarsByTrack(PrintWriter file, Train train, List<Car> carList, RouteLocation rl, boolean printHeader, boolean isManifest) {
        if (printHeader) {
            this.printPickupHeader = true;
            this.printSetoutHeader = true;
            this.printLocalMoveHeader = true;
        }
        List<Track> tracks = rl.getLocation().getTracksByNameList(null);
        ArrayList<String> trackNames = new ArrayList<String>();
        this.clearUtilityCarTypes();
        boolean isOnlyPassenger = train.isOnlyPassengerCars();
        for (Track track : tracks) {
            if (trackNames.contains(TrainCommon.splitString(track.getName()))) continue;
            trackNames.add(TrainCommon.splitString(track.getName()));
            for (RouteLocation rld : train.getTrainBlockingOrder()) {
                for (Car car : carList) {
                    boolean isTruncate;
                    if (Setup.isSortByTrackNameEnabled() && !TrainCommon.splitString(track.getName()).equals(TrainCommon.splitString(car.getTrackName())) || car.getRouteLocation() != rl || car.getTrack() == null || (car.getRouteDestination() != rld || car.isCaboose() || car.hasFred()) && (rld != train.getTrainTerminatesRouteLocation() || !car.isCaboose() && !car.hasFred()) && (!car.isPassenger() || !isOnlyPassenger)) continue;
                    if (this.printPickupHeader && !car.isLocalMove()) {
                        this.printPickupCarHeader(file, isManifest, false);
                        this.printPickupHeader = false;
                        if (this.getPickupCarHeader(isManifest, false).equals(this.getDropCarHeader(isManifest, false))) {
                            this.printSetoutHeader = false;
                        }
                        if (this.getPickupCarHeader(isManifest, false).equals(this.getLocalMoveHeader(isManifest))) {
                            this.printLocalMoveHeader = false;
                        }
                    }
                    boolean bl = isTruncate = Setup.isPrintTruncateManifestEnabled() && rl.getLocation().isSwitchListEnabled();
                    if (car.isUtility()) {
                        this.pickupUtilityCars(file, carList, car, isTruncate, isManifest);
                    } else if (isManifest && isTruncate) {
                        this.pickUpCarTruncated(file, car, isManifest);
                    } else {
                        this.pickUpCar(file, car, isManifest);
                    }
                    this.pickupCars = true;
                }
                if (isOnlyPassenger) break;
            }
            for (Car car : carList) {
                boolean isTruncate;
                if (Setup.isSortByTrackNameEnabled() && car.getRouteLocation() != null && car.getRouteDestination() == rl && !TrainCommon.splitString(track.getName()).equals(TrainCommon.splitString(car.getDestinationTrackName())) || car.getRouteDestination() != rl || car.getDestinationTrack() == null) continue;
                if (this.printSetoutHeader && !car.isLocalMove()) {
                    this.printDropCarHeader(file, isManifest, false);
                    this.printSetoutHeader = false;
                    if (this.getPickupCarHeader(isManifest, false).equals(this.getDropCarHeader(isManifest, false))) {
                        this.printPickupHeader = false;
                    }
                    if (this.getDropCarHeader(isManifest, false).equals(this.getLocalMoveHeader(isManifest))) {
                        this.printLocalMoveHeader = false;
                    }
                }
                if (this.printLocalMoveHeader && car.isLocalMove()) {
                    this.printLocalCarMoveHeader(file, isManifest);
                    this.printLocalMoveHeader = false;
                    if (this.getPickupCarHeader(isManifest, false).equals(this.getLocalMoveHeader(isManifest))) {
                        this.printPickupHeader = false;
                    }
                    if (this.getDropCarHeader(isManifest, false).equals(this.getLocalMoveHeader(isManifest))) {
                        this.printSetoutHeader = false;
                    }
                }
                boolean bl = isTruncate = Setup.isPrintTruncateManifestEnabled() && rl.getLocation().isSwitchListEnabled() && !train.isLocalSwitcher();
                if (car.isUtility()) {
                    this.setoutUtilityCars(file, carList, car, isTruncate, isManifest);
                } else if (isManifest && isTruncate) {
                    this.truncatedDropCar(file, car, isManifest);
                } else {
                    this.dropCar(file, car, isManifest);
                }
                this.dropCars = true;
            }
            if (!Setup.isSortByTrackNameEnabled()) break;
        }
    }

    protected void blockCarsTwoColumn(PrintWriter file, Train train, List<Car> carList, RouteLocation rl, boolean printHeader, boolean isManifest) {
        this.index = 0;
        int lineLength = TrainCommon.getLineLength(isManifest);
        List<Track> tracks = rl.getLocation().getTracksByNameList(null);
        ArrayList<String> trackNames = new ArrayList<String>();
        this.clearUtilityCarTypes();
        if (printHeader) {
            this.printCarHeader(file, isManifest, false);
        }
        for (Track track : tracks) {
            if (trackNames.contains(TrainCommon.splitString(track.getName()))) continue;
            trackNames.add(TrainCommon.splitString(track.getName()));
            for (RouteLocation rld : train.getTrainBlockingOrder()) {
                int k = 0;
                while (k < carList.size()) {
                    block9: {
                        String s;
                        Car car;
                        block11: {
                            block10: {
                                car = carList.get(k);
                                if (car.getTrack() == null || car.getRouteLocation() != rl || (car.getRouteDestination() != rld || car.isCaboose() || car.hasFred()) && (rld != train.getTrainTerminatesRouteLocation() || !car.isCaboose() && !car.hasFred()) || Setup.isSortByTrackNameEnabled() && !TrainCommon.splitString(track.getName()).equals(TrainCommon.splitString(car.getTrackName()))) break block9;
                                this.pickupCars = true;
                                if (!car.isUtility()) break block10;
                                s = this.pickupUtilityCars(carList, car, isManifest, false);
                                if (s == null) break block9;
                                s = s.trim();
                                break block11;
                            }
                            s = this.pickupCar(car, isManifest, false).trim();
                        }
                        s = TrainCommon.padAndTruncate(s, lineLength / 2);
                        if (car.isLocalMove()) {
                            String sl = this.appendSetoutString(s = TrainCommon.formatColorString(s, Setup.getLocalColor()), carList, car.getRouteDestination(), car, isManifest, false);
                            if (!sl.equals(s)) {
                                s = sl;
                                carList.remove(car);
                                --k;
                            } else {
                                s = TrainCommon.padAndTruncate(String.valueOf(s) + VERTICAL_LINE_CHAR, TrainCommon.getLineLength(isManifest));
                            }
                        } else {
                            s = TrainCommon.formatColorString(s, Setup.getPickupColor());
                            s = this.appendSetoutString(s, carList, rl, true, isManifest, false);
                        }
                        this.addLine(file, s);
                    }
                    ++k;
                }
            }
            if (!Setup.isSortByTrackNameEnabled()) break;
        }
        while (this.index < carList.size()) {
            String s = TrainCommon.padString("", lineLength / 2);
            String test = (s = this.appendSetoutString(s, carList, rl, false, isManifest, false)).trim();
            if (test.length() <= 1) continue;
            this.addLine(file, s);
        }
    }

    protected void blockCarsByTrackNameTwoColumn(PrintWriter file, Train train, List<Car> carList, RouteLocation rl, boolean printHeader, boolean isManifest) {
        this.index = 0;
        List<Track> tracks = rl.getLocation().getTracksByNameList(null);
        ArrayList<String> trackNames = new ArrayList<String>();
        this.doneCars.clear();
        this.clearUtilityCarTypes();
        if (printHeader) {
            this.printCarHeader(file, isManifest, true);
        }
        for (Track track : tracks) {
            String trackName = TrainCommon.splitString(track.getName());
            if (trackNames.contains(trackName)) continue;
            for (RouteLocation rld : train.getTrainBlockingOrder()) {
                for (Car car : carList) {
                    String s;
                    if (car.getTrack() == null || car.getRouteLocation() != rl || !trackName.equals(TrainCommon.splitString(car.getTrackName())) || (car.getRouteDestination() != rld || car.isCaboose() || car.hasFred()) && (rld != train.getTrainTerminatesRouteLocation() || !car.isCaboose() && !car.hasFred())) continue;
                    if (!trackNames.contains(trackName)) {
                        this.printTrackNameHeader(file, trackName, isManifest);
                    }
                    trackNames.add(trackName);
                    this.pickupCars = true;
                    if (car.isUtility()) {
                        s = this.pickupUtilityCars(carList, car, isManifest, true);
                        if (s == null) continue;
                        s = s.trim();
                    } else {
                        s = this.pickupCar(car, isManifest, true).trim();
                    }
                    s = TrainCommon.padAndTruncate(s, TrainCommon.getLineLength(isManifest) / 2);
                    s = TrainCommon.formatColorString(s, car.isLocalMove() ? Setup.getLocalColor() : Setup.getPickupColor());
                    s = this.appendSetoutString(s, trackName, carList, rl, isManifest, true);
                    this.addLine(file, s);
                }
            }
            for (Car car : carList) {
                String test;
                if (this.doneCars.contains(car) || car.getRouteDestination() != rl || !trackName.equals(TrainCommon.splitString(car.getDestinationTrackName()))) continue;
                if (!trackNames.contains(trackName)) {
                    this.printTrackNameHeader(file, trackName, isManifest);
                }
                trackNames.add(trackName);
                String s = TrainCommon.padString("", TrainCommon.getLineLength(isManifest) / 2);
                String so = this.appendSetoutString(s, carList, rl, car, isManifest, true);
                if (so.equals(s) || (test = so.trim()).length() <= 1) continue;
                this.addLine(file, so);
            }
        }
    }

    protected void printTrackComments(PrintWriter file, RouteLocation rl, List<Car> carList, boolean isManifest) {
        Location location = rl.getLocation();
        if (location != null) {
            List<Track> tracks = location.getTracksByNameList(null);
            for (Track track : tracks) {
                if (isManifest && !track.isPrintManifestCommentEnabled() || !isManifest && !track.isPrintSwitchListCommentEnabled()) continue;
                boolean pickup = false;
                boolean setout = false;
                for (Car car : carList) {
                    if (car.getRouteLocation() == rl && car.getTrack() != null && car.getTrack() == track) {
                        pickup = true;
                    }
                    if (car.getRouteDestination() != rl || car.getDestinationTrack() == null || car.getDestinationTrack() != track) continue;
                    setout = true;
                }
                if (pickup && setout && !track.getCommentBoth().equals("")) {
                    this.newLine(file, track.getCommentBoth(), isManifest);
                    continue;
                }
                if (pickup && !setout && !track.getCommentPickup().equals("")) {
                    this.newLine(file, track.getCommentPickup(), isManifest);
                    continue;
                }
                if (pickup || !setout || track.getCommentSetout().equals("")) continue;
                this.newLine(file, track.getCommentSetout(), isManifest);
            }
        }
    }

    private String appendSetoutString(String s, List<Car> carList, RouteLocation rl, boolean local, boolean isManifest, boolean isTwoColumnTrack) {
        while (this.index < carList.size()) {
            String so;
            Car car = carList.get(this.index++);
            if (local && car.isLocalMove() || car.getRouteDestination() != rl || (so = this.appendSetoutString(s, carList, rl, car, isManifest, isTwoColumnTrack)).equals(s)) continue;
            return so;
        }
        return String.valueOf(s) + VERTICAL_LINE_CHAR + TrainCommon.padAndTruncate("", TrainCommon.getLineLength(isManifest) / 2 - 1);
    }

    private String appendSetoutString(String s, String trackName, List<Car> carList, RouteLocation rl, boolean isManifest, boolean isTwoColumnTrack) {
        for (Car car : carList) {
            if (this.doneCars.contains(car) || car.getRouteDestination() != rl || !trackName.equals(TrainCommon.splitString(car.getDestinationTrackName()))) continue;
            this.doneCars.add(car);
            String so = this.appendSetoutString(s, carList, rl, car, isManifest, isTwoColumnTrack);
            if (so.equals(s)) continue;
            return so;
        }
        return String.valueOf(s) + VERTICAL_LINE_CHAR + TrainCommon.padAndTruncate("", TrainCommon.getLineLength(isManifest) / 2 - 1);
    }

    private String appendSetoutString(String s, List<Car> carList, RouteLocation rl, Car car, boolean isManifest, boolean isTwoColumnTrack) {
        String dropText;
        this.dropCars = true;
        if (car.isUtility()) {
            dropText = this.setoutUtilityCars(carList, car, false, isManifest, isTwoColumnTrack);
            if (dropText == null) {
                return s;
            }
        } else {
            dropText = this.dropCar(car, isManifest, isTwoColumnTrack).trim();
        }
        dropText = TrainCommon.padAndTruncate(dropText.trim(), TrainCommon.getLineLength(isManifest) / 2 - 1);
        dropText = TrainCommon.formatColorString(dropText, car.isLocalMove() ? Setup.getLocalColor() : Setup.getDropColor());
        return String.valueOf(s) + VERTICAL_LINE_CHAR + dropText;
    }

    protected void pickUpCarTruncated(PrintWriter file, Car car, boolean isManifest) {
        this.pickUpCar(file, car, new StringBuffer(TrainCommon.padAndTruncateIfNeeded(Setup.getPickupCarPrefix(), Setup.getManifestPrefixLength())), Setup.getPickupTruncatedManifestMessageFormat(), isManifest);
    }

    protected void pickUpCar(PrintWriter file, Car car, boolean isManifest) {
        if (isManifest) {
            this.pickUpCar(file, car, new StringBuffer(TrainCommon.padAndTruncateIfNeeded(Setup.getPickupCarPrefix(), Setup.getManifestPrefixLength())), Setup.getPickupManifestMessageFormat(), isManifest);
        } else {
            this.pickUpCar(file, car, new StringBuffer(TrainCommon.padAndTruncateIfNeeded(Setup.getSwitchListPickupCarPrefix(), Setup.getSwitchListPrefixLength())), Setup.getPickupSwitchListMessageFormat(), isManifest);
        }
    }

    private void pickUpCar(PrintWriter file, Car car, StringBuffer buf, String[] format, boolean isManifest) {
        if (car.isLocalMove()) {
            return;
        }
        String[] stringArray = format;
        int n = format.length;
        int n2 = 0;
        while (n2 < n) {
            String attribute = stringArray[n2];
            String s = this.getCarAttribute(car, attribute, true, false);
            if (!this.checkStringLength(String.valueOf(buf.toString()) + s, isManifest)) {
                this.addLine(file, buf.toString());
                buf = new StringBuffer(TAB);
            }
            buf.append(s);
            ++n2;
        }
        String s = buf.toString();
        if (s.trim().length() != 0) {
            this.addLine(file, s);
        }
    }

    public String pickupCar(Car car, boolean isManifest, boolean isTwoColumnTrack) {
        StringBuffer buf = new StringBuffer();
        String[] format = isManifest && !isTwoColumnTrack ? Setup.getPickupManifestMessageFormat() : (!isManifest && !isTwoColumnTrack ? Setup.getPickupSwitchListMessageFormat() : (isManifest && isTwoColumnTrack ? Setup.getPickupTwoColumnByTrackManifestMessageFormat() : Setup.getPickupTwoColumnByTrackSwitchListMessageFormat()));
        String[] stringArray = format;
        int n = format.length;
        int n2 = 0;
        while (n2 < n) {
            String attribute = stringArray[n2];
            String s = this.getCarAttribute(car, attribute, true, false);
            buf.append(s);
            ++n2;
        }
        return buf.toString();
    }

    protected void truncatedDropCar(PrintWriter file, Car car, boolean isManifest) {
        if (car.isLocalMove()) {
            return;
        }
        this.dropCar(file, car, new StringBuffer(Setup.getDropCarPrefix()), Setup.getDropTruncatedManifestMessageFormat(), false, isManifest);
    }

    protected void dropCar(PrintWriter file, Car car, boolean isManifest) {
        boolean isLocal = car.isLocalMove();
        if (isManifest) {
            StringBuffer buf = new StringBuffer(TrainCommon.padAndTruncateIfNeeded(Setup.getDropCarPrefix(), Setup.getManifestPrefixLength()));
            String[] format = Setup.getDropManifestMessageFormat();
            if (isLocal) {
                buf = new StringBuffer(TrainCommon.padAndTruncateIfNeeded(Setup.getLocalPrefix(), Setup.getManifestPrefixLength()));
                format = Setup.getLocalManifestMessageFormat();
            }
            this.dropCar(file, car, buf, format, isLocal, isManifest);
        } else {
            StringBuffer buf = new StringBuffer(TrainCommon.padAndTruncateIfNeeded(Setup.getSwitchListDropCarPrefix(), Setup.getSwitchListPrefixLength()));
            String[] format = Setup.getDropSwitchListMessageFormat();
            if (isLocal) {
                buf = new StringBuffer(TrainCommon.padAndTruncateIfNeeded(Setup.getSwitchListLocalPrefix(), Setup.getSwitchListPrefixLength()));
                format = Setup.getLocalSwitchListMessageFormat();
            }
            this.dropCar(file, car, buf, format, isLocal, isManifest);
        }
    }

    private void dropCar(PrintWriter file, Car car, StringBuffer buf, String[] format, boolean isLocal, boolean isManifest) {
        String[] stringArray = format;
        int n = format.length;
        int n2 = 0;
        while (n2 < n) {
            String attribute = stringArray[n2];
            String s = this.getCarAttribute(car, attribute, false, isLocal);
            if (!this.checkStringLength(String.valueOf(buf.toString()) + s, isManifest)) {
                this.addLine(file, buf.toString());
                buf = new StringBuffer(TAB);
            }
            buf.append(s);
            ++n2;
        }
        String s = buf.toString();
        if (s.trim().length() != 0) {
            this.addLine(file, s);
        }
    }

    public String dropCar(Car car, boolean isManifest, boolean isTwoColumnTrack) {
        StringBuffer buf = new StringBuffer();
        String[] format = isManifest && !isTwoColumnTrack ? Setup.getDropManifestMessageFormat() : (!isManifest && !isTwoColumnTrack ? Setup.getDropSwitchListMessageFormat() : (isManifest && isTwoColumnTrack ? Setup.getDropTwoColumnByTrackManifestMessageFormat() : Setup.getDropTwoColumnByTrackSwitchListMessageFormat()));
        boolean local = false;
        if (car.getTrack() == null) {
            local = true;
        }
        String[] stringArray = format;
        int n = format.length;
        int n2 = 0;
        while (n2 < n) {
            String attribute = stringArray[n2];
            String s = this.getCarAttribute(car, attribute, false, local);
            buf.append(s);
            ++n2;
        }
        return buf.toString();
    }

    public String localMoveCar(Car car, boolean isManifest) {
        StringBuffer buf = new StringBuffer();
        String[] format = isManifest ? Setup.getLocalManifestMessageFormat() : Setup.getLocalSwitchListMessageFormat();
        String[] stringArray = format;
        int n = format.length;
        int n2 = 0;
        while (n2 < n) {
            String attribute = stringArray[n2];
            String s = this.getCarAttribute(car, attribute, false, true);
            buf.append(s);
            ++n2;
        }
        return buf.toString();
    }

    protected void pickupUtilityCars(PrintWriter file, List<Car> carList, Car car, boolean isTruncate, boolean isManifest) {
        int count;
        String[] format = isManifest ? Setup.getPickupUtilityManifestMessageFormat() : Setup.getPickupUtilitySwitchListMessageFormat();
        if (isTruncate && isManifest) {
            format = Setup.createTruncatedManifestMessageFormat(format);
        }
        if ((count = this.countUtilityCars(format, carList, car, true)) == 0) {
            return;
        }
        this.pickUpCar(file, car, new StringBuffer(String.valueOf(TrainCommon.padAndTruncateIfNeeded(Setup.getPickupCarPrefix(), isManifest ? Setup.getManifestPrefixLength() : Setup.getSwitchListPrefixLength())) + " " + TrainCommon.padString(Integer.toString(count), 3)), format, isManifest);
    }

    protected void setoutUtilityCars(PrintWriter file, List<Car> carList, Car car, boolean isTruncate, boolean isManifest) {
        int count;
        String[] format;
        StringBuffer buf;
        boolean isLocal = car.isLocalMove();
        if (isLocal && isManifest) {
            buf = new StringBuffer(TrainCommon.padAndTruncateIfNeeded(Setup.getLocalPrefix(), Setup.getManifestPrefixLength()));
            format = Setup.getLocalUtilityManifestMessageFormat();
        } else if (!isLocal && isManifest) {
            buf = new StringBuffer(TrainCommon.padAndTruncateIfNeeded(Setup.getDropCarPrefix(), Setup.getManifestPrefixLength()));
            format = Setup.getDropUtilityManifestMessageFormat();
        } else if (isLocal && !isManifest) {
            buf = new StringBuffer(TrainCommon.padAndTruncateIfNeeded(Setup.getSwitchListLocalPrefix(), Setup.getSwitchListPrefixLength()));
            format = Setup.getLocalUtilitySwitchListMessageFormat();
        } else {
            buf = new StringBuffer(TrainCommon.padAndTruncateIfNeeded(Setup.getSwitchListDropCarPrefix(), Setup.getSwitchListPrefixLength()));
            format = Setup.getDropUtilitySwitchListMessageFormat();
        }
        if (isTruncate && isManifest) {
            format = Setup.createTruncatedManifestMessageFormat(format);
        }
        if ((count = this.countUtilityCars(format, carList, car, false)) == 0) {
            return;
        }
        buf.append(" " + TrainCommon.padString(Integer.toString(count), 3));
        this.dropCar(file, car, buf, format, isLocal, isManifest);
    }

    public String pickupUtilityCars(List<Car> carList, Car car, boolean isManifest, boolean isTwoColumnTrack) {
        int count = this.countPickupUtilityCars(carList, car, isManifest);
        if (count == 0) {
            return null;
        }
        String[] format = isManifest && !isTwoColumnTrack ? Setup.getPickupUtilityManifestMessageFormat() : (!isManifest && !isTwoColumnTrack ? Setup.getPickupUtilitySwitchListMessageFormat() : (isManifest && isTwoColumnTrack ? Setup.getPickupTwoColumnByTrackUtilityManifestMessageFormat() : Setup.getPickupTwoColumnByTrackUtilitySwitchListMessageFormat()));
        StringBuffer buf = new StringBuffer(" " + TrainCommon.padString(Integer.toString(count), 3));
        String[] stringArray = format;
        int n = format.length;
        int n2 = 0;
        while (n2 < n) {
            String attribute = stringArray[n2];
            String s = this.getCarAttribute(car, attribute, true, false);
            buf.append(s);
            ++n2;
        }
        return buf.toString();
    }

    public int countPickupUtilityCars(List<Car> carList, Car car, boolean isManifest) {
        String[] format = isManifest ? Setup.getPickupUtilityManifestMessageFormat() : Setup.getPickupUtilitySwitchListMessageFormat();
        return this.countUtilityCars(format, carList, car, true);
    }

    public String setoutUtilityCars(List<Car> carList, Car car, boolean isLocal, boolean isManifest) {
        return this.setoutUtilityCars(carList, car, isLocal, isManifest, false);
    }

    protected String setoutUtilityCars(List<Car> carList, Car car, boolean isLocal, boolean isManifest, boolean isTwoColumnTrack) {
        int count = this.countSetoutUtilityCars(carList, car, isLocal, isManifest);
        if (count == 0) {
            return null;
        }
        String[] format = isLocal && isManifest && !isTwoColumnTrack ? Setup.getLocalUtilityManifestMessageFormat() : (isLocal && !isManifest && !isTwoColumnTrack ? Setup.getLocalUtilitySwitchListMessageFormat() : (!isLocal && !isManifest && !isTwoColumnTrack ? Setup.getDropUtilitySwitchListMessageFormat() : (!isLocal && isManifest && !isTwoColumnTrack ? Setup.getDropUtilityManifestMessageFormat() : (isManifest && isTwoColumnTrack ? Setup.getDropTwoColumnByTrackUtilityManifestMessageFormat() : Setup.getDropTwoColumnByTrackUtilitySwitchListMessageFormat()))));
        StringBuffer buf = new StringBuffer(" " + TrainCommon.padString(Integer.toString(count), 3));
        if (car.getTrack() == null) {
            isLocal = true;
        }
        String[] stringArray = format;
        int n = format.length;
        int n2 = 0;
        while (n2 < n) {
            String attribute = stringArray[n2];
            String s = this.getCarAttribute(car, attribute, false, isLocal);
            buf.append(s);
            ++n2;
        }
        return buf.toString();
    }

    public int countSetoutUtilityCars(List<Car> carList, Car car, boolean isLocal, boolean isManifest) {
        String[] format = isLocal && isManifest ? Setup.getLocalUtilityManifestMessageFormat() : (isLocal && !isManifest ? Setup.getLocalUtilitySwitchListMessageFormat() : (!isLocal && !isManifest ? Setup.getDropUtilitySwitchListMessageFormat() : Setup.getDropUtilityManifestMessageFormat()));
        return this.countUtilityCars(format, carList, car, false);
    }

    protected int countUtilityCars(String[] format, List<Car> carList, Car car, boolean isPickup) {
        String carAttributes;
        int count = 0;
        boolean showLength = this.showUtilityCarLength(format);
        boolean showLoad = this.showUtilityCarLoad(format);
        boolean showLocation = false;
        boolean showDestination = false;
        String carType = car.getTypeName().split("-")[0];
        if (isPickup) {
            carAttributes = String.valueOf(carType) + car.getRouteLocationId() + TrainCommon.splitString(car.getTrackName());
            showDestination = this.showUtilityCarDestination(format);
            if (showDestination) {
                carAttributes = String.valueOf(carAttributes) + car.getRouteDestinationId();
            }
        } else {
            carAttributes = String.valueOf(carType) + TrainCommon.splitString(car.getDestinationTrackName()) + car.getRouteDestinationId();
            showLocation = this.showUtilityCarLocation(format);
            if (showLocation && car.getTrack() != null) {
                carAttributes = String.valueOf(carAttributes) + car.getRouteLocationId();
            }
            if (car.isLocalMove()) {
                carAttributes = String.valueOf(carAttributes) + TrainCommon.splitString(car.getTrackName());
            }
        }
        if (showLength) {
            carAttributes = String.valueOf(carAttributes) + car.getLength();
        }
        if (showLoad) {
            carAttributes = String.valueOf(carAttributes) + car.getLoadName();
        }
        if (!this.utilityCarTypes.contains(carAttributes)) {
            this.utilityCarTypes.add(carAttributes);
            for (Car c : carList) {
                String cType;
                if (!c.isUtility() || !(cType = c.getTypeName().split("-")[0]).equals(carType) || showLength && !c.getLength().equals(car.getLength()) || showLoad && !c.getLoadName().equals(car.getLoadName()) || showLocation && !c.getRouteLocationId().equals(car.getRouteLocationId()) || showDestination && !c.getRouteDestinationId().equals(car.getRouteDestinationId()) || car.isLocalMove() ^ c.isLocalMove()) continue;
                if (isPickup && c.getRouteLocation() == car.getRouteLocation() && TrainCommon.splitString(c.getTrackName()).equals(TrainCommon.splitString(car.getTrackName()))) {
                    ++count;
                }
                if (isPickup || c.getRouteDestination() != car.getRouteDestination() || !TrainCommon.splitString(c.getDestinationTrackName()).equals(TrainCommon.splitString(car.getDestinationTrackName())) || !TrainCommon.splitString(c.getTrackName()).equals(TrainCommon.splitString(car.getTrackName())) && c.isLocalMove()) continue;
                ++count;
            }
        }
        return count;
    }

    public void clearUtilityCarTypes() {
        this.utilityCarTypes.clear();
    }

    private boolean showUtilityCarLength(String[] mFormat) {
        return this.showUtilityCarAttribute(Setup.LENGTH, mFormat);
    }

    private boolean showUtilityCarLoad(String[] mFormat) {
        return this.showUtilityCarAttribute(Setup.LOAD, mFormat);
    }

    private boolean showUtilityCarLocation(String[] mFormat) {
        return this.showUtilityCarAttribute(Setup.LOCATION, mFormat);
    }

    private boolean showUtilityCarDestination(String[] mFormat) {
        return this.showUtilityCarAttribute(Setup.DESTINATION, mFormat);
    }

    private boolean showUtilityCarAttribute(String string, String[] mFormat) {
        String[] stringArray = mFormat;
        int n = mFormat.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            if (s.equals(string)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    protected static void addLine(PrintWriter file, String level, String string) {
        log.debug(string);
        if (file != null) {
            String[] lines;
            String[] stringArray = lines = string.split(NEW_LINE);
            int n = lines.length;
            int n2 = 0;
            while (n2 < n) {
                String line = stringArray[n2];
                TrainCommon.printLine(file, level, line);
                ++n2;
            }
        }
    }

    private static void printLine(PrintWriter file, String level, String string) {
        int lineLengthMax = TrainCommon.getLineLength(Setup.PORTRAIT, Setup.MONOSPACED, 0, Setup.getBuildReportFontSize());
        if (string.length() > lineLengthMax) {
            String[] words = string.split(" ");
            StringBuffer sb = new StringBuffer();
            String[] stringArray = words;
            int n = words.length;
            int n2 = 0;
            while (n2 < n) {
                String word = stringArray[n2];
                if (sb.length() + word.length() < lineLengthMax) {
                    sb.append(String.valueOf(word) + " ");
                } else {
                    file.println(String.valueOf(level) + "-" + " " + sb.toString());
                    sb = new StringBuffer(String.valueOf(word) + " ");
                }
                ++n2;
            }
            string = sb.toString();
        }
        file.println(String.valueOf(level) + "-" + " " + string);
    }

    protected void addLine(PrintWriter file, String string) {
        log.debug(string);
        if (file != null) {
            file.println(string);
        }
    }

    protected void newLine(PrintWriter file, String string, boolean isManifest) {
        String[] lines;
        String[] stringArray = lines = string.split(NEW_LINE);
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            String[] words = line.split(" ");
            StringBuffer sb = new StringBuffer();
            String[] stringArray2 = words;
            int n3 = words.length;
            int n4 = 0;
            while (n4 < n3) {
                String word = stringArray2[n4];
                if (this.checkStringLength(String.valueOf(sb.toString()) + word, isManifest)) {
                    sb.append(String.valueOf(word) + " ");
                } else {
                    sb.setLength(sb.length() - 1);
                    this.addLine(file, sb.toString());
                    sb = new StringBuffer(String.valueOf(word) + " ");
                }
                ++n4;
            }
            if (sb.length() > 0) {
                sb.setLength(sb.length() - 1);
            }
            this.addLine(file, sb.toString());
            ++n2;
        }
    }

    protected void newLine(PrintWriter file) {
        file.println(" ");
    }

    public static String splitString(String name) {
        String[] splitname = name.split("-");
        if (splitname.length > 1 && !splitname[1].startsWith("(")) {
            try {
                Integer.parseInt(splitname[1]);
            }
            catch (NumberFormatException numberFormatException) {
                return name.trim();
            }
        }
        return splitname[0].trim();
    }

    private static String splitStringLeftParenthesis(String name) {
        String[] splitname = name.split("-");
        if (splitname.length > 1 && splitname[1].startsWith("(")) {
            return splitname[0].trim();
        }
        return name.trim();
    }

    protected boolean isThereWorkAtLocation(List<Car> carList, List<Engine> engList, RouteLocation rl) {
        if (carList != null) {
            for (Car car : carList) {
                if (car.getRouteLocation() != rl && car.getRouteDestination() != rl) continue;
                return true;
            }
        }
        if (engList != null) {
            for (Engine eng : engList) {
                if (eng.getRouteLocation() != rl && eng.getRouteDestination() != rl) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isThereWorkAtLocation(Train train, Location location) {
        if (TrainCommon.isThereWorkAtLocation(train, location, InstanceManager.getDefault(CarManager.class).getList(train))) {
            return true;
        }
        return TrainCommon.isThereWorkAtLocation(train, location, InstanceManager.getDefault(EngineManager.class).getList(train));
    }

    private static boolean isThereWorkAtLocation(Train train, Location location, List<? extends RollingStock> list) {
        for (RollingStock rollingStock : list) {
            if ((rollingStock.getRouteLocation() == null || rollingStock.getTrack() == null || !TrainCommon.splitString(rollingStock.getRouteLocation().getName()).equals(TrainCommon.splitString(location.getName()))) && (rollingStock.getRouteDestination() == null || !TrainCommon.splitString(rollingStock.getRouteDestination().getName()).equals(TrainCommon.splitString(location.getName())))) continue;
            return true;
        }
        return false;
    }

    protected void addCarsLocationUnknown(PrintWriter file, boolean isManifest) {
        CarManager carManager = InstanceManager.getDefault(CarManager.class);
        List<Car> cars = carManager.getCarsLocationUnknown();
        if (cars.size() == 0) {
            return;
        }
        this.newLine(file);
        this.newLine(file, Setup.getMiaComment(), isManifest);
        for (Car car : cars) {
            this.addSearchForCar(file, car);
        }
    }

    private void addSearchForCar(PrintWriter file, Car car) {
        String[] format;
        StringBuffer buf = new StringBuffer();
        String[] stringArray = format = Setup.getMissingCarMessageFormat();
        int n = format.length;
        int n2 = 0;
        while (n2 < n) {
            String attribute = stringArray[n2];
            buf.append(this.getCarAttribute(car, attribute, false, false));
            ++n2;
        }
        this.addLine(file, buf.toString());
    }

    private String getEngineAttribute(Engine engine, String attribute, boolean isPickup) {
        if (attribute.equals(Setup.MODEL)) {
            return " " + TrainCommon.padAndTruncateIfNeeded(TrainCommon.splitStringLeftParenthesis(engine.getModel()), InstanceManager.getDefault(EngineModels.class).getMaxNameLength());
        }
        if (attribute.equals(Setup.CONSIST)) {
            return " " + TrainCommon.padAndTruncateIfNeeded(engine.getConsistName(), InstanceManager.getDefault(ConsistManager.class).getMaxNameLength());
        }
        return this.getRollingStockAttribute(engine, attribute, isPickup, false);
    }

    private String getCarAttribute(Car car, String attribute, boolean isPickup, boolean isLocal) {
        if (attribute.equals(Setup.LOAD)) {
            return car.isCaboose() && !Setup.isPrintCabooseLoadEnabled() || car.isPassenger() && !Setup.isPrintPassengerLoadEnabled() ? TrainCommon.padAndTruncateIfNeeded("", InstanceManager.getDefault(CarLoads.class).getMaxNameLength() + 1) : " " + TrainCommon.padAndTruncateIfNeeded(car.getLoadName().split("-")[0], InstanceManager.getDefault(CarLoads.class).getMaxNameLength());
        }
        if (attribute.equals(Setup.LOAD_TYPE)) {
            return " " + TrainCommon.padAndTruncateIfNeeded(car.getLoadType(), TrainManifestHeaderText.getStringHeader_Load_Type().length());
        }
        if (attribute.equals(Setup.HAZARDOUS)) {
            return car.isHazardous() ? " " + Setup.getHazardousMsg() : TrainCommon.padAndTruncateIfNeeded("", Setup.getHazardousMsg().length() + 1);
        }
        if (attribute.equals(Setup.DROP_COMMENT)) {
            return " " + car.getDropComment();
        }
        if (attribute.equals(Setup.PICKUP_COMMENT)) {
            return " " + car.getPickupComment();
        }
        if (attribute.equals(Setup.KERNEL)) {
            return " " + TrainCommon.padAndTruncateIfNeeded(car.getKernelName(), InstanceManager.getDefault(KernelManager.class).getMaxNameLength());
        }
        if (attribute.equals(Setup.KERNEL_SIZE)) {
            if (car.isLead()) {
                return " " + TrainCommon.padAndTruncateIfNeeded(Integer.toString(car.getKernel().getSize()), 2);
            }
            return "   ";
        }
        if (attribute.equals(Setup.RWE)) {
            if (!car.getReturnWhenEmptyDestName().equals("")) {
                return " " + TrainCommon.padAndTruncateIfNeeded(String.valueOf(TrainManifestHeaderText.getStringHeader_RWE()) + " " + TrainCommon.splitString(car.getReturnWhenEmptyDestinationName()) + " ," + TrainCommon.splitString(car.getReturnWhenEmptyDestTrackName()), this.locationManager.getMaxLocationAndTrackNameLength() + TrainManifestHeaderText.getStringHeader_RWE().length() + 3);
            }
            return "";
        }
        if (attribute.equals(Setup.FINAL_DEST)) {
            if (!car.getFinalDestinationName().equals("")) {
                return Setup.isPrintHeadersEnabled() ? " " + TrainCommon.padAndTruncateIfNeeded(TrainCommon.splitString(car.getFinalDestinationName()), this.locationManager.getMaxLocationNameLength()) : " " + TrainCommon.padAndTruncateIfNeeded(String.valueOf(TrainManifestText.getStringFinalDestination()) + " " + TrainCommon.splitString(car.getFinalDestinationName()), this.locationManager.getMaxLocationNameLength() + TrainManifestText.getStringFinalDestination().length() + 1);
            }
            return "";
        }
        if (attribute.equals(Setup.FINAL_DEST_TRACK)) {
            if (!car.getFinalDestinationName().equals("")) {
                return Setup.isPrintHeadersEnabled() ? " " + TrainCommon.padAndTruncateIfNeeded(String.valueOf(TrainCommon.splitString(car.getFinalDestinationName())) + ", " + TrainCommon.splitString(car.getFinalDestinationTrackName()), this.locationManager.getMaxLocationAndTrackNameLength() + 2) : " " + TrainCommon.padAndTruncateIfNeeded(String.valueOf(TrainManifestText.getStringFinalDestination()) + " " + TrainCommon.splitString(car.getFinalDestinationName()) + ", " + TrainCommon.splitString(car.getFinalDestinationTrackName()), this.locationManager.getMaxLocationAndTrackNameLength() + TrainManifestText.getStringFinalDestination().length() + 3);
            }
            return "";
        }
        return this.getRollingStockAttribute(car, attribute, isPickup, isLocal);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getRollingStockAttribute(RollingStock rs, String attribute, boolean isPickup, boolean isLocal) {
        try {
            if (attribute.equals(Setup.NUMBER)) {
                return " " + TrainCommon.padAndTruncateIfNeeded(TrainCommon.splitString(rs.getNumber()), Control.max_len_string_print_road_number);
            }
            if (attribute.equals(Setup.ROAD)) {
                String road = rs.getRoadName().split("-")[0];
                return " " + TrainCommon.padAndTruncateIfNeeded(road, InstanceManager.getDefault(CarRoads.class).getMaxNameLength());
            }
            if (attribute.equals(Setup.TYPE)) {
                String type = rs.getTypeName().split("-")[0];
                return " " + TrainCommon.padAndTruncateIfNeeded(type, InstanceManager.getDefault(CarTypes.class).getMaxNameLength());
            }
            if (attribute.equals(Setup.LENGTH)) {
                return " " + TrainCommon.padAndTruncateIfNeeded(String.valueOf(rs.getLength()) + Setup.getLengthUnitAbv(), InstanceManager.getDefault(CarLengths.class).getMaxNameLength());
            }
            if (attribute.equals(Setup.WEIGHT)) {
                return " " + TrainCommon.padAndTruncateIfNeeded(Integer.toString(rs.getAdjustedWeightTons()), Control.max_len_string_weight_name);
            }
            if (attribute.equals(Setup.COLOR)) {
                return " " + TrainCommon.padAndTruncateIfNeeded(rs.getColor(), InstanceManager.getDefault(CarColors.class).getMaxNameLength());
            }
            if (attribute.equals(Setup.LOCATION) && (isPickup || isLocal) || attribute.equals(Setup.TRACK) && isPickup) {
                String string;
                if (rs.getTrack() == null) return "";
                if (Setup.isPrintHeadersEnabled()) {
                    string = " " + TrainCommon.padAndTruncateIfNeeded(TrainCommon.splitString(rs.getTrackName()), this.locationManager.getMaxTrackNameLength());
                    return string;
                }
                string = " " + TrainCommon.padAndTruncateIfNeeded(String.valueOf(TrainManifestText.getStringFrom()) + " " + TrainCommon.splitString(rs.getTrackName()), TrainManifestText.getStringFrom().length() + this.locationManager.getMaxTrackNameLength() + 1);
                return string;
            }
            if (attribute.equals(Setup.LOCATION) && !isPickup && !isLocal) {
                String string;
                if (Setup.isPrintHeadersEnabled()) {
                    string = " " + TrainCommon.padAndTruncateIfNeeded(TrainCommon.splitString(rs.getLocationName()), this.locationManager.getMaxLocationNameLength());
                    return string;
                }
                string = " " + TrainCommon.padAndTruncateIfNeeded(String.valueOf(TrainManifestText.getStringFrom()) + " " + TrainCommon.splitString(rs.getLocationName()), this.locationManager.getMaxLocationNameLength() + TrainManifestText.getStringFrom().length() + 1);
                return string;
            }
            if (attribute.equals(Setup.DESTINATION) && isPickup) {
                if (rs.getDestination() == null) {
                    return "";
                }
                if (Setup.isPrintHeadersEnabled()) {
                    return " " + TrainCommon.padAndTruncateIfNeeded(TrainCommon.splitString(rs.getDestinationName()), this.locationManager.getMaxLocationNameLength());
                }
                if (!Setup.isTabEnabled()) return " " + TrainManifestText.getStringDestination() + " " + TrainCommon.splitString(rs.getDestinationName());
                return " " + TrainCommon.padAndTruncateIfNeeded(String.valueOf(TrainManifestText.getStringDest()) + " " + TrainCommon.splitString(rs.getDestinationName()), TrainManifestText.getStringDest().length() + this.locationManager.getMaxLocationNameLength() + 1);
            }
            if ((attribute.equals(Setup.DESTINATION) || attribute.equals(Setup.TRACK)) && !isPickup) {
                String string;
                if (Setup.isPrintHeadersEnabled()) {
                    string = " " + TrainCommon.padAndTruncateIfNeeded(TrainCommon.splitString(rs.getDestinationTrackName()), this.locationManager.getMaxTrackNameLength());
                    return string;
                }
                string = " " + TrainCommon.padAndTruncateIfNeeded(String.valueOf(TrainManifestText.getStringTo()) + " " + TrainCommon.splitString(rs.getDestinationTrackName()), this.locationManager.getMaxTrackNameLength() + TrainManifestText.getStringTo().length() + 1);
                return string;
            }
            if (attribute.equals(Setup.DEST_TRACK)) {
                String string;
                if (Setup.isPrintHeadersEnabled()) {
                    string = " " + TrainCommon.padAndTruncateIfNeeded(String.valueOf(TrainCommon.splitString(rs.getDestinationName())) + ", " + TrainCommon.splitString(rs.getDestinationTrackName()), this.locationManager.getMaxLocationAndTrackNameLength() + 2);
                    return string;
                }
                string = " " + TrainCommon.padAndTruncateIfNeeded(String.valueOf(TrainManifestText.getStringDest()) + " " + TrainCommon.splitString(rs.getDestinationName()) + ", " + TrainCommon.splitString(rs.getDestinationTrackName()), this.locationManager.getMaxLocationAndTrackNameLength() + TrainManifestText.getStringDest().length() + 3);
                return string;
            }
            if (attribute.equals(Setup.OWNER)) {
                return " " + TrainCommon.padAndTruncateIfNeeded(rs.getOwner(), InstanceManager.getDefault(CarOwners.class).getMaxNameLength());
            }
            if (attribute.equals(Setup.COMMENT)) {
                return " " + rs.getComment();
            }
            if (attribute.equals(" ")) {
                return "";
            }
            if (attribute.equals("NO_NUMBER")) {
                return " " + TrainCommon.padAndTruncateIfNeeded("", Control.max_len_string_print_road_number - 4);
            }
            if (attribute.equals("NO_ROAD")) {
                return " " + TrainCommon.padAndTruncateIfNeeded("", InstanceManager.getDefault(CarRoads.class).getMaxNameLength());
            }
            if (attribute.equals("NO_COLOR")) {
                return " " + TrainCommon.padAndTruncateIfNeeded("", InstanceManager.getDefault(CarColors.class).getMaxNameLength());
            }
            if (attribute.equals("NO_DEST_TRACK")) {
                if (!Setup.isPrintHeadersEnabled()) return "";
                String string = TrainCommon.padAndTruncateIfNeeded("", this.locationManager.getMaxLocationAndTrackNameLength() + 2);
                return string;
            }
            if (attribute.equals("NO_LOCATION") && !isPickup || attribute.equals("NO_DESTINATION") && isPickup) {
                if (!Setup.isPrintHeadersEnabled()) return "";
                String string = TrainCommon.padAndTruncateIfNeeded("", this.locationManager.getMaxLocationNameLength() + 1);
                return string;
            }
            if (attribute.equals("NO_TRACK") || attribute.equals("NO_LOCATION") || attribute.equals("NO_DESTINATION")) {
                if (!Setup.isPrintHeadersEnabled()) return "";
                String string = TrainCommon.padAndTruncateIfNeeded("", this.locationManager.getMaxTrackNameLength() + 1);
                return string;
            }
            if (attribute.equals(Setup.TAB)) {
                return TrainCommon.createTabIfNeeded(Setup.getTab1Length());
            }
            if (attribute.equals(Setup.TAB2)) {
                return TrainCommon.createTabIfNeeded(Setup.getTab2Length());
            }
            if (attribute.equals(Setup.TAB3)) {
                return TrainCommon.createTabIfNeeded(Setup.getTab3Length());
            }
            return MessageFormat.format(Bundle.getMessage("ErrorPrintOptions"), attribute);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            if (attribute.equals(Setup.ROAD)) {
                return " " + TrainCommon.padAndTruncateIfNeeded("", InstanceManager.getDefault(CarRoads.class).getMaxNameLength());
            }
            if (attribute.equals(Setup.TYPE)) {
                return " " + TrainCommon.padAndTruncateIfNeeded("", InstanceManager.getDefault(CarTypes.class).getMaxNameLength());
            }
            return MessageFormat.format(Bundle.getMessage("ErrorPrintOptions"), attribute);
        }
    }

    public void printEngineHeader(PrintWriter file, boolean isManifest) {
        String s;
        int lineLength = TrainCommon.getLineLength(isManifest);
        this.printHorizontalLine(file, 0, lineLength);
        if (!Setup.isPrintHeadersEnabled()) {
            return;
        }
        if (!Setup.getPickupEnginePrefix().trim().isEmpty() || !Setup.getDropEnginePrefix().trim().isEmpty()) {
            s = String.valueOf(TrainCommon.padAndTruncate(TrainCommon.tabString(Setup.getPickupEnginePrefix().trim(), lineLength / 4 - Setup.getPickupEnginePrefix().length() / 2), lineLength / 2)) + VERTICAL_LINE_CHAR + TrainCommon.tabString(Setup.getDropEnginePrefix(), lineLength / 4 - Setup.getDropEnginePrefix().length() / 2);
            s = TrainCommon.padAndTruncate(s, lineLength);
            this.addLine(file, s);
            this.printHorizontalLine(file, 0, lineLength);
        }
        s = TrainCommon.padAndTruncate(this.getPickupEngineHeader(), lineLength / 2);
        s = TrainCommon.padAndTruncate(String.valueOf(s) + VERTICAL_LINE_CHAR + this.getDropEngineHeader(), lineLength);
        this.addLine(file, s);
        this.printHorizontalLine(file, 0, lineLength);
    }

    public void printPickupEngineHeader(PrintWriter file, boolean isManifest) {
        int lineLength = TrainCommon.getLineLength(isManifest);
        this.printHorizontalLine(file, 0, lineLength);
        String s = TrainCommon.padAndTruncate(String.valueOf(TrainCommon.createTabIfNeeded(Setup.getManifestPrefixLength() + 1)) + this.getPickupEngineHeader(), lineLength);
        this.addLine(file, s);
        this.printHorizontalLine(file, 0, lineLength);
    }

    public void printDropEngineHeader(PrintWriter file, boolean isManifest) {
        int lineLength = TrainCommon.getLineLength(isManifest);
        this.printHorizontalLine(file, 0, lineLength);
        String s = TrainCommon.padAndTruncate(String.valueOf(TrainCommon.createTabIfNeeded(Setup.getManifestPrefixLength() + 1)) + this.getDropEngineHeader(), lineLength);
        this.addLine(file, s);
        this.printHorizontalLine(file, 0, lineLength);
    }

    public void printCarHeader(PrintWriter file, boolean isManifest, boolean isTwoColumnTrack) {
        int lineLength = TrainCommon.getLineLength(isManifest);
        this.printHorizontalLine(file, 0, lineLength);
        if (!Setup.isPrintHeadersEnabled()) {
            return;
        }
        String s = String.valueOf(TrainCommon.padAndTruncate(TrainCommon.tabString(Setup.getPickupCarPrefix(), lineLength / 4 - Setup.getPickupCarPrefix().length() / 2), lineLength / 2)) + VERTICAL_LINE_CHAR + TrainCommon.tabString(Setup.getDropCarPrefix(), lineLength / 4 - Setup.getDropCarPrefix().length() / 2);
        s = TrainCommon.padAndTruncate(s, lineLength);
        this.addLine(file, s);
        this.printHorizontalLine(file, 0, lineLength);
        s = TrainCommon.padAndTruncate(this.getPickupCarHeader(isManifest, isTwoColumnTrack), lineLength / 2);
        s = TrainCommon.padAndTruncate(String.valueOf(s) + VERTICAL_LINE_CHAR + this.getDropCarHeader(isManifest, isTwoColumnTrack), lineLength);
        this.addLine(file, s);
        this.printHorizontalLine(file, 0, lineLength);
    }

    public void printPickupCarHeader(PrintWriter file, boolean isManifest, boolean isTwoColumnTrack) {
        if (!Setup.isPrintHeadersEnabled()) {
            return;
        }
        this.printHorizontalLine(file, isManifest);
        String s = TrainCommon.padAndTruncate(String.valueOf(TrainCommon.createTabIfNeeded(Setup.getManifestPrefixLength() + 1)) + this.getPickupCarHeader(isManifest, isTwoColumnTrack), TrainCommon.getLineLength(isManifest));
        this.addLine(file, s);
        this.printHorizontalLine(file, isManifest);
    }

    public void printDropCarHeader(PrintWriter file, boolean isManifest, boolean isTwoColumnTrack) {
        if (!Setup.isPrintHeadersEnabled() || this.getDropCarHeader(isManifest, isTwoColumnTrack).trim().isEmpty()) {
            return;
        }
        this.printHorizontalLine(file, isManifest);
        String s = TrainCommon.padAndTruncate(String.valueOf(TrainCommon.createTabIfNeeded(Setup.getManifestPrefixLength() + 1)) + this.getDropCarHeader(isManifest, isTwoColumnTrack), TrainCommon.getLineLength(isManifest));
        this.addLine(file, s);
        this.printHorizontalLine(file, isManifest);
    }

    public void printLocalCarMoveHeader(PrintWriter file, boolean isManifest) {
        if (!Setup.isPrintHeadersEnabled()) {
            return;
        }
        this.printHorizontalLine(file, isManifest);
        String s = TrainCommon.padAndTruncate(String.valueOf(TrainCommon.createTabIfNeeded(Setup.getManifestPrefixLength() + 1)) + this.getLocalMoveHeader(isManifest), TrainCommon.getLineLength(isManifest));
        this.addLine(file, s);
        this.printHorizontalLine(file, isManifest);
    }

    public String getPickupEngineHeader() {
        return this.getHeader(Setup.getPickupEngineMessageFormat(), true, false, true);
    }

    public String getDropEngineHeader() {
        return this.getHeader(Setup.getDropEngineMessageFormat(), false, false, true);
    }

    public String getPickupCarHeader(boolean isManifest, boolean isTwoColumnTrack) {
        if (isManifest && !isTwoColumnTrack) {
            return this.getHeader(Setup.getPickupManifestMessageFormat(), true, false, false);
        }
        if (!isManifest && !isTwoColumnTrack) {
            return this.getHeader(Setup.getPickupSwitchListMessageFormat(), true, false, false);
        }
        if (isManifest && isTwoColumnTrack) {
            return this.getHeader(Setup.getPickupTwoColumnByTrackManifestMessageFormat(), true, false, false);
        }
        return this.getHeader(Setup.getPickupTwoColumnByTrackSwitchListMessageFormat(), true, false, false);
    }

    public String getDropCarHeader(boolean isManifest, boolean isTwoColumnTrack) {
        if (isManifest && !isTwoColumnTrack) {
            return this.getHeader(Setup.getDropManifestMessageFormat(), false, false, false);
        }
        if (!isManifest && !isTwoColumnTrack) {
            return this.getHeader(Setup.getDropSwitchListMessageFormat(), false, false, false);
        }
        if (isManifest && isTwoColumnTrack) {
            return this.getHeader(Setup.getDropTwoColumnByTrackManifestMessageFormat(), false, false, false);
        }
        return this.getHeader(Setup.getDropTwoColumnByTrackSwitchListMessageFormat(), false, false, false);
    }

    public String getLocalMoveHeader(boolean isManifest) {
        if (isManifest) {
            return this.getHeader(Setup.getLocalManifestMessageFormat(), false, true, false);
        }
        return this.getHeader(Setup.getLocalSwitchListMessageFormat(), false, true, false);
    }

    private String getHeader(String[] format, boolean isPickup, boolean isLocal, boolean isEngine) {
        StringBuffer buf = new StringBuffer();
        String[] stringArray = format;
        int n = format.length;
        int n2 = 0;
        while (n2 < n) {
            String attribute = stringArray[n2];
            if (!attribute.equals(" ")) {
                if (attribute.equals(Setup.ROAD)) {
                    buf.append(String.valueOf(TrainCommon.padAndTruncateIfNeeded(TrainManifestHeaderText.getStringHeader_Road(), InstanceManager.getDefault(CarRoads.class).getMaxNameLength())) + " ");
                } else if (attribute.equals(Setup.NUMBER) && !isEngine) {
                    buf.append(String.valueOf(TrainCommon.padAndTruncateIfNeeded(TrainManifestHeaderText.getStringHeader_Number(), Control.max_len_string_print_road_number)) + " ");
                } else if (attribute.equals(Setup.NUMBER) && isEngine) {
                    buf.append(String.valueOf(TrainCommon.padAndTruncateIfNeeded(TrainManifestHeaderText.getStringHeader_EngineNumber(), Control.max_len_string_print_road_number)) + " ");
                } else if (attribute.equals(Setup.TYPE)) {
                    buf.append(String.valueOf(TrainCommon.padAndTruncateIfNeeded(TrainManifestHeaderText.getStringHeader_Type(), InstanceManager.getDefault(CarTypes.class).getMaxNameLength())) + " ");
                } else if (attribute.equals(Setup.MODEL)) {
                    buf.append(String.valueOf(TrainCommon.padAndTruncateIfNeeded(TrainManifestHeaderText.getStringHeader_Model(), InstanceManager.getDefault(EngineModels.class).getMaxNameLength())) + " ");
                } else if (attribute.equals(Setup.CONSIST)) {
                    buf.append(String.valueOf(TrainCommon.padAndTruncateIfNeeded(TrainManifestHeaderText.getStringHeader_Consist(), InstanceManager.getDefault(ConsistManager.class).getMaxNameLength())) + " ");
                } else if (attribute.equals(Setup.KERNEL)) {
                    buf.append(String.valueOf(TrainCommon.padAndTruncateIfNeeded(TrainManifestHeaderText.getStringHeader_Kernel(), InstanceManager.getDefault(KernelManager.class).getMaxNameLength())) + " ");
                } else if (attribute.equals(Setup.KERNEL_SIZE)) {
                    buf.append("   ");
                } else if (attribute.equals(Setup.LOAD)) {
                    buf.append(String.valueOf(TrainCommon.padAndTruncateIfNeeded(TrainManifestHeaderText.getStringHeader_Load(), InstanceManager.getDefault(CarLoads.class).getMaxNameLength())) + " ");
                } else if (attribute.equals(Setup.LOAD_TYPE)) {
                    buf.append(String.valueOf(TrainCommon.padAndTruncateIfNeeded(TrainManifestHeaderText.getStringHeader_Load_Type(), TrainManifestHeaderText.getStringHeader_Load_Type().length())) + " ");
                } else if (attribute.equals(Setup.COLOR)) {
                    buf.append(String.valueOf(TrainCommon.padAndTruncateIfNeeded(TrainManifestHeaderText.getStringHeader_Color(), InstanceManager.getDefault(CarColors.class).getMaxNameLength())) + " ");
                } else if (attribute.equals(Setup.OWNER)) {
                    buf.append(String.valueOf(TrainCommon.padAndTruncateIfNeeded(TrainManifestHeaderText.getStringHeader_Owner(), InstanceManager.getDefault(CarOwners.class).getMaxNameLength())) + " ");
                } else if (attribute.equals(Setup.LENGTH)) {
                    buf.append(String.valueOf(TrainCommon.padAndTruncateIfNeeded(TrainManifestHeaderText.getStringHeader_Length(), InstanceManager.getDefault(CarLengths.class).getMaxNameLength())) + " ");
                } else if (attribute.equals(Setup.WEIGHT)) {
                    buf.append(String.valueOf(TrainCommon.padAndTruncateIfNeeded(TrainManifestHeaderText.getStringHeader_Weight(), Control.max_len_string_weight_name)) + " ");
                } else if (attribute.equals(Setup.TRACK)) {
                    buf.append(String.valueOf(TrainCommon.padAndTruncateIfNeeded(TrainManifestHeaderText.getStringHeader_Track(), this.locationManager.getMaxTrackNameLength())) + " ");
                } else if (attribute.equals(Setup.LOCATION) && (isPickup || isLocal)) {
                    buf.append(String.valueOf(TrainCommon.padAndTruncateIfNeeded(TrainManifestHeaderText.getStringHeader_Location(), this.locationManager.getMaxTrackNameLength())) + " ");
                } else if (attribute.equals(Setup.LOCATION) && !isPickup) {
                    buf.append(String.valueOf(TrainCommon.padAndTruncateIfNeeded(TrainManifestHeaderText.getStringHeader_Location(), this.locationManager.getMaxLocationNameLength())) + " ");
                } else if (attribute.equals(Setup.DESTINATION) && !isPickup) {
                    buf.append(String.valueOf(TrainCommon.padAndTruncateIfNeeded(TrainManifestHeaderText.getStringHeader_Destination(), this.locationManager.getMaxTrackNameLength())) + " ");
                } else if (attribute.equals(Setup.DESTINATION) && isPickup) {
                    buf.append(String.valueOf(TrainCommon.padAndTruncateIfNeeded(TrainManifestHeaderText.getStringHeader_Destination(), this.locationManager.getMaxLocationNameLength())) + " ");
                } else if (attribute.equals(Setup.DEST_TRACK)) {
                    buf.append(String.valueOf(TrainCommon.padAndTruncateIfNeeded(TrainManifestHeaderText.getStringHeader_Dest_Track(), this.locationManager.getMaxLocationAndTrackNameLength() + 2)) + " ");
                } else if (attribute.equals(Setup.FINAL_DEST)) {
                    buf.append(String.valueOf(TrainCommon.padAndTruncateIfNeeded(TrainManifestHeaderText.getStringHeader_Final_Dest(), this.locationManager.getMaxLocationNameLength())) + " ");
                } else if (attribute.equals(Setup.FINAL_DEST_TRACK)) {
                    buf.append(String.valueOf(TrainCommon.padAndTruncateIfNeeded(TrainManifestHeaderText.getStringHeader_Final_Dest_Track(), this.locationManager.getMaxLocationAndTrackNameLength() + 2)) + " ");
                } else if (attribute.equals(Setup.HAZARDOUS)) {
                    buf.append(String.valueOf(TrainCommon.padAndTruncateIfNeeded(TrainManifestHeaderText.getStringHeader_Hazardous(), Setup.getHazardousMsg().length())) + " ");
                } else if (attribute.equals(Setup.RWE)) {
                    buf.append(String.valueOf(TrainManifestHeaderText.getStringHeader_RWE()) + " ");
                } else if (attribute.equals(Setup.COMMENT)) {
                    buf.append(String.valueOf(TrainManifestHeaderText.getStringHeader_Comment()) + " ");
                } else if (attribute.equals(Setup.DROP_COMMENT)) {
                    buf.append(String.valueOf(TrainManifestHeaderText.getStringHeader_Drop_Comment()) + " ");
                } else if (attribute.equals(Setup.PICKUP_COMMENT)) {
                    buf.append(String.valueOf(TrainManifestHeaderText.getStringHeader_Pickup_Comment()) + " ");
                } else if (attribute.equals(Setup.TAB)) {
                    buf.append(TrainCommon.createTabIfNeeded(Setup.getTab1Length()));
                } else if (attribute.equals(Setup.TAB2)) {
                    buf.append(TrainCommon.createTabIfNeeded(Setup.getTab2Length()));
                } else if (attribute.equals(Setup.TAB3)) {
                    buf.append(TrainCommon.createTabIfNeeded(Setup.getTab3Length()));
                } else {
                    buf.append(String.valueOf(attribute) + " ");
                }
            }
            ++n2;
        }
        return buf.toString().trim();
    }

    protected void printTrackNameHeader(PrintWriter file, String trackName, boolean isManifest) {
        this.printHorizontalLine(file, isManifest);
        int lineLength = TrainCommon.getLineLength(isManifest);
        String s = String.valueOf(TrainCommon.padAndTruncate(TrainCommon.tabString(trackName.trim(), lineLength / 4 - trackName.trim().length() / 2), lineLength / 2)) + VERTICAL_LINE_CHAR + TrainCommon.tabString(trackName.trim(), lineLength / 4 - trackName.trim().length() / 2);
        s = TrainCommon.padAndTruncate(s, lineLength);
        this.addLine(file, s);
        this.printHorizontalLine(file, isManifest);
    }

    public void printHorizontalLine(PrintWriter file, boolean isManifest) {
        this.printHorizontalLine(file, 0, TrainCommon.getLineLength(isManifest));
    }

    public void printHorizontalLine(PrintWriter file, int start, int end) {
        StringBuffer sb = new StringBuffer();
        while (start-- > 0) {
            sb.append(" ");
        }
        while (end-- > 0) {
            sb.append("-");
        }
        this.addLine(file, sb.toString());
    }

    public static String getISO8601Date(boolean isModelYear) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(InstanceManager.getDefault(Timebase.class).getTime());
        if (isModelYear && !Setup.getYearModeled().isEmpty()) {
            try {
                calendar.set(1, Integer.parseInt(Setup.getYearModeled().trim()));
            }
            catch (NumberFormatException numberFormatException) {
                return Setup.getYearModeled();
            }
        }
        return new StdDateFormat().format(calendar.getTime());
    }

    public static String getDate(Date date) {
        SimpleDateFormat format = new SimpleDateFormat("M/dd/yyyy HH:mm");
        if (Setup.is12hrFormatEnabled()) {
            format = new SimpleDateFormat("M/dd/yyyy hh:mm a");
        }
        return format.format(date);
    }

    public static String getDate(boolean isModelYear) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(InstanceManager.getDefault(Timebase.class).getTime());
        if (isModelYear && !Setup.getYearModeled().equals("")) {
            try {
                calendar.set(1, Integer.parseInt(Setup.getYearModeled().trim()));
            }
            catch (NumberFormatException numberFormatException) {
                return Setup.getYearModeled();
            }
        }
        return TrainCommon.getDate(calendar.getTime());
    }

    public static String padAndTruncateIfNeeded(String s, int fieldSize) {
        if (Setup.isTabEnabled()) {
            return TrainCommon.padAndTruncate(s, fieldSize);
        }
        return s;
    }

    public static String padAndTruncate(String s, int fieldSize) {
        if ((s = TrainCommon.padString(s, fieldSize)).length() > fieldSize) {
            s = s.substring(0, fieldSize);
        }
        return s;
    }

    public static String padString(String s, int fieldSize) {
        StringBuffer buf = new StringBuffer(s);
        while (buf.length() < fieldSize) {
            buf.append(" ");
        }
        return buf.toString();
    }

    public static String createTabIfNeeded(int tabSize) {
        if (Setup.isTabEnabled()) {
            return TrainCommon.tabString("", tabSize);
        }
        return "";
    }

    protected static String tabString(String s, int tabSize) {
        StringBuffer buf = new StringBuffer();
        while (buf.length() < tabSize) {
            buf.append(" ");
        }
        buf.append(s);
        return buf.toString();
    }

    public static int getLineLength(boolean isManifest) {
        return TrainCommon.getLineLength(isManifest ? Setup.getManifestOrientation() : Setup.getSwitchListOrientation(), Setup.getFontName(), 0, Setup.getManifestFontSize());
    }

    public static int getManifestHeaderLineLength() {
        return TrainCommon.getLineLength(Setup.getManifestOrientation(), "SansSerif", 2, Setup.getManifestFontSize());
    }

    private static int getLineLength(String orientation, String fontName, int fontStyle, int fontSize) {
        int charLength;
        JLabel label = new JLabel();
        Font font = new Font(fontName, fontStyle, fontSize);
        FontMetrics metrics = label.getFontMetrics(font);
        int charwidth = metrics.charWidth('m');
        if (charwidth == 0) {
            log.error("Line length charater width equal to zero. font size: {}, fontName: {}", (Object)fontSize, (Object)fontName);
            charwidth = fontSize / 2;
        }
        if ((charLength = TrainCommon.getPageSize((String)orientation).width / charwidth) % 2 != 0) {
            --charLength;
        }
        return charLength;
    }

    private boolean checkStringLength(String string, boolean isManifest) {
        return this.checkStringLength(string, isManifest ? Setup.getManifestOrientation() : Setup.getSwitchListOrientation(), Setup.getFontName(), Setup.getManifestFontSize());
    }

    private boolean checkStringLength(String string, String orientation, String fontName, int fontSize) {
        JLabel label = new JLabel();
        Font font = new Font(fontName, 0, fontSize);
        FontMetrics metrics = label.getFontMetrics(font);
        int stringWidth = metrics.stringWidth(string);
        return stringWidth <= TrainCommon.getPageSize((String)orientation).width;
    }

    protected static Dimension getPageSize(String orientation) {
        Dimension pagesize = new Dimension(523, 720);
        if (orientation.equals(Setup.LANDSCAPE)) {
            pagesize = new Dimension(702, 523);
        }
        if (orientation.equals(Setup.HALFPAGE)) {
            pagesize = new Dimension(261, 720);
        }
        if (orientation.equals(Setup.HANDHELD)) {
            pagesize = new Dimension(206, 720);
        }
        return pagesize;
    }

    public static String formatStringToCommaSeparated(String[] array) {
        StringBuffer sbuf = new StringBuffer("");
        String[] stringArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            if (s != null) {
                sbuf = sbuf.append(String.valueOf(s) + ", ");
            }
            ++n2;
        }
        if (sbuf.length() > 2) {
            sbuf.setLength(sbuf.length() - 2);
        }
        return sbuf.toString();
    }

    public static String formatColorString(String text, Color color) {
        String s = text;
        if (!color.equals(Color.black)) {
            s = TEXT_COLOR_START + ColorUtil.colorToColorName(color) + "\">" + text + TEXT_COLOR_END;
        }
        return s;
    }

    public static String getTextColorString(String string) {
        String text = string;
        if (string.contains(TEXT_COLOR_START)) {
            text = String.valueOf(string.substring(0, string.indexOf(TEXT_COLOR_START))) + string.substring(string.indexOf(">") + 1);
        }
        if (text.contains(TEXT_COLOR_END)) {
            text = String.valueOf(text.substring(0, text.indexOf(TEXT_COLOR_END))) + string.substring(string.indexOf(TEXT_COLOR_END) + TEXT_COLOR_END.length());
        }
        return text;
    }

    public static Color getTextColor(String string) {
        Color color = Color.black;
        if (string.contains(TEXT_COLOR_START)) {
            String c = string.substring(string.indexOf("\"") + 1);
            c = c.substring(0, c.indexOf("\""));
            color = ColorUtil.stringToColor(c);
        }
        return color;
    }
}

