/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.operations.trains;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.JOptionPane;
import jmri.InstanceManager;
import jmri.Version;
import jmri.jmrit.operations.locations.Location;
import jmri.jmrit.operations.locations.LocationManager;
import jmri.jmrit.operations.locations.Track;
import jmri.jmrit.operations.locations.schedules.ScheduleItem;
import jmri.jmrit.operations.rollingstock.RollingStock;
import jmri.jmrit.operations.rollingstock.cars.Car;
import jmri.jmrit.operations.rollingstock.cars.CarLoad;
import jmri.jmrit.operations.rollingstock.cars.CarLoads;
import jmri.jmrit.operations.rollingstock.cars.CarManager;
import jmri.jmrit.operations.rollingstock.cars.CarRoads;
import jmri.jmrit.operations.rollingstock.engines.Engine;
import jmri.jmrit.operations.rollingstock.engines.EngineManager;
import jmri.jmrit.operations.router.Router;
import jmri.jmrit.operations.routes.RouteLocation;
import jmri.jmrit.operations.setup.Control;
import jmri.jmrit.operations.setup.Setup;
import jmri.jmrit.operations.trains.BuildFailedException;
import jmri.jmrit.operations.trains.Bundle;
import jmri.jmrit.operations.trains.Train;
import jmri.jmrit.operations.trains.TrainCommon;
import jmri.jmrit.operations.trains.TrainManager;
import jmri.jmrit.operations.trains.TrainManagerXml;
import jmri.jmrit.operations.trains.schedules.TrainSchedule;
import jmri.jmrit.operations.trains.schedules.TrainScheduleManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TrainBuilderBase
extends TrainCommon {
    protected static final String ONE = "1";
    protected static final String THREE = "3";
    protected static final String FIVE = "5";
    protected static final String SEVEN = "7";
    protected static final int DISPLAY_CAR_LIMIT_20 = 20;
    protected static final int DISPLAY_CAR_LIMIT_50 = 50;
    protected static final int DISPLAY_CAR_LIMIT_100 = 100;
    protected static final int PERCENT_100 = 100;
    protected static final boolean USE_BUNIT = true;
    Date _startTime;
    Train _train;
    int _numberCars = 0;
    List<Engine> _engineList;
    Engine _lastEngine;
    Engine _secondLeadEngine;
    Engine _thirdLeadEngine;
    int _carIndex;
    List<Car> _carList;
    List<RouteLocation> _routeList;
    Hashtable<String, Integer> _numOfBlocks;
    int _completedMoves;
    int _reqNumOfMoves;
    Location _departLocation;
    Track _departStageTrack;
    Location _terminateLocation;
    Track _terminateStageTrack;
    boolean _success;
    PrintWriter _buildReport;
    List<Car> _notRoutable = new ArrayList<Car>();
    List<Location> _modifiedLocations = new ArrayList<Location>();
    int _warnings = 0;
    CarManager carManager = InstanceManager.getDefault(CarManager.class);
    LocationManager locationManager = InstanceManager.getDefault(LocationManager.class);
    EngineManager engineManager = InstanceManager.getDefault(EngineManager.class);
    TrainManager trainManager = InstanceManager.getDefault(TrainManager.class);
    TrainScheduleManager trainScheduleManager = InstanceManager.getDefault(TrainScheduleManager.class);
    CarLoads carLoads = InstanceManager.getDefault(CarLoads.class);
    Router router = InstanceManager.getDefault(Router.class);
    boolean routeToTrackFound;
    private static final Logger log = LoggerFactory.getLogger(TrainBuilderBase.class);

    protected void createBuildReportFile() {
        InstanceManager.getDefault(TrainManagerXml.class).savePreviousBuildStatusFile(this._train.getName());
        File file = InstanceManager.getDefault(TrainManagerXml.class).createTrainBuildReportFile(this._train.getName());
        try {
            this._buildReport = new PrintWriter((Writer)new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), StandardCharsets.UTF_8)), true);
        }
        catch (IOException iOException) {
            log.error("Can not open build report file: {}", (Object)file.getName());
            return;
        }
    }

    protected void addBuildReportInfo() {
        TrainBuilderBase.addLine(this._buildReport, ONE, MessageFormat.format(Bundle.getMessage("BuildReportMsg"), this._train.getName(), this._startTime));
        TrainBuilderBase.addLine(this._buildReport, ONE, MessageFormat.format(Bundle.getMessage("BuildReportVersion"), Version.name()));
        if (!this.trainScheduleManager.getTrainScheduleActiveId().equals("")) {
            if (this.trainScheduleManager.getTrainScheduleActiveId().equals("ANY")) {
                TrainBuilderBase.addLine(this._buildReport, ONE, MessageFormat.format(Bundle.getMessage("buildActiveSchedule"), Bundle.getMessage("Any")));
            } else {
                TrainSchedule sch = this.trainScheduleManager.getActiveSchedule();
                if (sch != null) {
                    TrainBuilderBase.addLine(this._buildReport, ONE, MessageFormat.format(Bundle.getMessage("buildActiveSchedule"), sch.getName()));
                }
            }
        }
        TrainBuilderBase.addLine(this._buildReport, THREE, Bundle.getMessage("buildReportLevelThree"));
        TrainBuilderBase.addLine(this._buildReport, FIVE, Bundle.getMessage("buildReportLevelFive"));
        TrainBuilderBase.addLine(this._buildReport, SEVEN, Bundle.getMessage("buildReportLevelSeven"));
        if (Setup.getRouterBuildReportLevel().equals(FIVE)) {
            TrainBuilderBase.addLine(this._buildReport, SEVEN, Bundle.getMessage("buildRouterReportLevelDetailed"));
        } else if (Setup.getRouterBuildReportLevel().equals(SEVEN)) {
            TrainBuilderBase.addLine(this._buildReport, SEVEN, Bundle.getMessage("buildRouterReportLevelVeryDetailed"));
        }
        if (!Setup.getComment().trim().isEmpty()) {
            TrainBuilderBase.addLine(this._buildReport, ONE, " ");
            TrainBuilderBase.addLine(this._buildReport, ONE, Setup.getComment());
        }
        TrainBuilderBase.addLine(this._buildReport, ONE, " ");
    }

    protected void setUpRoute() throws BuildFailedException {
        if (this._train.getRoute() == null) {
            throw new BuildFailedException(MessageFormat.format(Bundle.getMessage("buildErrorRoute"), this._train.getName()));
        }
        this._routeList = this._train.getRoute().getLocationsBySequenceList();
        if (this._routeList.size() < 1) {
            throw new BuildFailedException(MessageFormat.format(Bundle.getMessage("buildErrorNeedRoute"), this._train.getName()));
        }
        this._departLocation = this.locationManager.getLocationByName(this._train.getTrainDepartsName());
        if (this._departLocation == null) {
            throw new BuildFailedException(MessageFormat.format(Bundle.getMessage("buildErrorNeedDepLoc"), this._train.getName()));
        }
        this._terminateLocation = this.locationManager.getLocationByName(this._train.getTrainTerminatesName());
        if (this._terminateLocation == null) {
            throw new BuildFailedException(MessageFormat.format(Bundle.getMessage("buildErrorNeedTermLoc"), this._train.getName()));
        }
    }

    protected void showTrainBuildOptions() {
        ResourceBundle rb = ResourceBundle.getBundle("jmri.jmrit.operations.setup.JmritOperationsSetupBundle");
        TrainBuilderBase.addLine(this._buildReport, FIVE, String.valueOf(Bundle.getMessage("MenuItemBuildOptions")) + ":");
        if (Setup.isBuildAggressive()) {
            TrainBuilderBase.addLine(this._buildReport, FIVE, Bundle.getMessage("BuildModeAggressive"));
            TrainBuilderBase.addLine(this._buildReport, FIVE, MessageFormat.format(Bundle.getMessage("BuildNumberPasses"), Setup.getNumberPasses()));
            if (Setup.isStagingTrackImmediatelyAvail() && this._departLocation.isStaging()) {
                TrainBuilderBase.addLine(this._buildReport, FIVE, Bundle.getMessage("BuildStagingTrackAvail"));
            }
        } else {
            TrainBuilderBase.addLine(this._buildReport, FIVE, Bundle.getMessage("BuildModeNormal"));
        }
        if (this._train.isLocalSwitcher()) {
            TrainBuilderBase.addLine(this._buildReport, FIVE, " ");
            TrainBuilderBase.addLine(this._buildReport, FIVE, String.valueOf(rb.getString("BorderLayoutSwitcherService")) + ":");
            if (Setup.isLocalInterchangeMovesEnabled()) {
                TrainBuilderBase.addLine(this._buildReport, FIVE, rb.getString("AllowLocalInterchange"));
            } else {
                TrainBuilderBase.addLine(this._buildReport, FIVE, rb.getString("NoAllowLocalInterchange"));
            }
            if (Setup.isLocalSpurMovesEnabled()) {
                TrainBuilderBase.addLine(this._buildReport, FIVE, rb.getString("AllowLocalSpur"));
            } else {
                TrainBuilderBase.addLine(this._buildReport, FIVE, rb.getString("NoAllowLocalSpur"));
            }
            if (Setup.isLocalYardMovesEnabled()) {
                TrainBuilderBase.addLine(this._buildReport, FIVE, rb.getString("AllowLocalYard"));
            } else {
                TrainBuilderBase.addLine(this._buildReport, FIVE, rb.getString("NoAllowLocalYard"));
            }
        }
        if (this._departLocation.isStaging() || this._terminateLocation.isStaging()) {
            TrainBuilderBase.addLine(this._buildReport, FIVE, " ");
            TrainBuilderBase.addLine(this._buildReport, FIVE, Bundle.getMessage("buildStagingOptions"));
            if (Setup.isStagingTrainCheckEnabled() && this._terminateLocation.isStaging()) {
                TrainBuilderBase.addLine(this._buildReport, FIVE, Bundle.getMessage("buildOptionRestrictStaging"));
            }
            if (Setup.isStagingTrackImmediatelyAvail() && this._terminateLocation.isStaging()) {
                TrainBuilderBase.addLine(this._buildReport, FIVE, rb.getString("StagingAvailable"));
            }
            if (Setup.isStagingAllowReturnEnabled() && this._departLocation.isStaging() && this._terminateLocation.isStaging() && this._departLocation == this._terminateLocation) {
                TrainBuilderBase.addLine(this._buildReport, FIVE, rb.getString("AllowCarsToReturn"));
            }
            if (Setup.isStagingPromptFromEnabled() && this._departLocation.isStaging()) {
                TrainBuilderBase.addLine(this._buildReport, FIVE, rb.getString("PromptFromStaging"));
            }
            if (Setup.isStagingPromptToEnabled() && this._terminateLocation.isStaging()) {
                TrainBuilderBase.addLine(this._buildReport, FIVE, rb.getString("PromptToStaging"));
            }
            if (Setup.isStagingTryNormalBuildEnabled() && this._departLocation.isStaging()) {
                TrainBuilderBase.addLine(this._buildReport, FIVE, rb.getString("TryNormalStaging"));
            }
        }
        TrainBuilderBase.addLine(this._buildReport, FIVE, " ");
        TrainBuilderBase.addLine(this._buildReport, FIVE, Bundle.getMessage("buildCarRoutingOptions"));
        if (!Setup.isCarRoutingEnabled()) {
            TrainBuilderBase.addLine(this._buildReport, FIVE, Bundle.getMessage("RoutingDisabled"));
            ++this._warnings;
        } else {
            if (Setup.isCarRoutingViaYardsEnabled()) {
                TrainBuilderBase.addLine(this._buildReport, FIVE, Bundle.getMessage("RoutingViaYardsEnabled"));
            }
            if (Setup.isCarRoutingViaStagingEnabled()) {
                TrainBuilderBase.addLine(this._buildReport, FIVE, Bundle.getMessage("RoutingViaStagingEnabled"));
            }
            if (Setup.isOnlyActiveTrainsEnabled()) {
                TrainBuilderBase.addLine(this._buildReport, FIVE, Bundle.getMessage("OnlySelectedTrains"));
                ++this._warnings;
                for (Train train : this.trainManager.getTrainsByNameList()) {
                    if (!train.isBuildEnabled()) continue;
                    TrainBuilderBase.addLine(this._buildReport, SEVEN, MessageFormat.format(Bundle.getMessage("buildTrainNameAndDesc"), train.getName(), train.getDescription()));
                }
                if (!this._train.isBuildEnabled()) {
                    TrainBuilderBase.addLine(this._buildReport, FIVE, MessageFormat.format(Bundle.getMessage("buildTrainNotSelected"), this._train.getName()));
                }
            } else {
                TrainBuilderBase.addLine(this._buildReport, FIVE, rb.getString("AllTrains"));
            }
            if (Setup.isCheckCarDestinationEnabled()) {
                TrainBuilderBase.addLine(this._buildReport, FIVE, Bundle.getMessage("CheckCarDestination"));
            }
        }
        TrainBuilderBase.addLine(this._buildReport, FIVE, " ");
    }

    protected void showSpecificTrainBuildOptions() {
        TrainBuilderBase.addLine(this._buildReport, FIVE, MessageFormat.format(Bundle.getMessage("buildOptionsForTrain"), this._train.getName()));
        this.showSpecificTrainBuildOptions(true);
        TrainBuilderBase.addLine(this._buildReport, FIVE, MessageFormat.format(Bundle.getMessage("buildDisabledOptionsForTrain"), this._train.getName()));
        this.showSpecificTrainBuildOptions(false);
    }

    private void showSpecificTrainBuildOptions(boolean enabled) {
        if (this._train.isBuildTrainNormalEnabled() ^ !enabled) {
            TrainBuilderBase.addLine(this._buildReport, FIVE, Bundle.getMessage("NormalModeWhenBuilding"));
        }
        if (this._train.isSendCarsToTerminalEnabled() ^ !enabled) {
            TrainBuilderBase.addLine(this._buildReport, FIVE, MessageFormat.format(Bundle.getMessage("SendToTerminal"), this._terminateLocation.getName()));
        }
        if ((this._train.isAllowReturnToStagingEnabled() || Setup.isStagingAllowReturnEnabled()) ^ !enabled && this._departLocation.isStaging() && this._departLocation == this._terminateLocation) {
            TrainBuilderBase.addLine(this._buildReport, FIVE, Bundle.getMessage("AllowCarsToReturn"));
        }
        if (this._train.isAllowLocalMovesEnabled() ^ !enabled) {
            TrainBuilderBase.addLine(this._buildReport, FIVE, Bundle.getMessage("AllowLocalMoves"));
        }
        if (this._train.isAllowThroughCarsEnabled() ^ !enabled && this._departLocation != this._terminateLocation) {
            TrainBuilderBase.addLine(this._buildReport, FIVE, Bundle.getMessage("AllowThroughCars"));
        }
        if (this._train.isServiceAllCarsWithFinalDestinationsEnabled() ^ !enabled) {
            TrainBuilderBase.addLine(this._buildReport, FIVE, Bundle.getMessage("ServiceAllCars"));
        }
        if (this._train.isSendCarsWithCustomLoadsToStagingEnabled() ^ !enabled) {
            TrainBuilderBase.addLine(this._buildReport, FIVE, Bundle.getMessage("SendCustomToStaging"));
        }
        if (this._train.isBuildConsistEnabled() ^ !enabled) {
            TrainBuilderBase.addLine(this._buildReport, FIVE, Bundle.getMessage("BuildConsist"));
            if (enabled) {
                TrainBuilderBase.addLine(this._buildReport, FIVE, MessageFormat.format(Bundle.getMessage("BuildConsistHPT"), Setup.getHorsePowerPerTon()));
            }
        }
        TrainBuilderBase.addLine(this._buildReport, FIVE, " ");
    }

    protected void showTrainServices() {
        if (!this._train.getRoadOption().equals(Train.ALL_ROADS)) {
            TrainBuilderBase.addLine(this._buildReport, FIVE, MessageFormat.format(Bundle.getMessage("buildTrainRoads"), this._train.getName(), this._train.getRoadOption(), TrainBuilderBase.formatStringToCommaSeparated(this._train.getRoadNames())));
        }
        if (!this._train.getOwnerOption().equals(Train.ALL_OWNERS)) {
            TrainBuilderBase.addLine(this._buildReport, FIVE, MessageFormat.format(Bundle.getMessage("buildTrainOwners"), this._train.getName(), this._train.getOwnerOption(), TrainBuilderBase.formatStringToCommaSeparated(this._train.getOwnerNames())));
        }
        if (!this._train.getBuiltStartYear().equals("")) {
            TrainBuilderBase.addLine(this._buildReport, FIVE, MessageFormat.format(Bundle.getMessage("buildTrainBuiltAfter"), this._train.getName(), this._train.getBuiltStartYear()));
        }
        if (!this._train.getBuiltEndYear().equals("")) {
            TrainBuilderBase.addLine(this._buildReport, FIVE, MessageFormat.format(Bundle.getMessage("buildTrainBuiltBefore"), this._train.getName(), this._train.getBuiltEndYear()));
        }
        if (!this._train.getNumberEngines().equals("0")) {
            TrainBuilderBase.addLine(this._buildReport, FIVE, MessageFormat.format(Bundle.getMessage("buildTrainServicesEngineTypes"), this._train.getName()));
            TrainBuilderBase.addLine(this._buildReport, FIVE, TrainBuilderBase.formatStringToCommaSeparated(this._train.getLocoTypeNames()));
        }
    }

    protected void showAndInitializeTrainRoute() throws BuildFailedException {
        int requestedCarMoves = 0;
        if (this._train.getTrainDepartsRouteLocation().getMaxCarMoves() > this._departLocation.getNumberRS() && Control.fullTrainOnly) {
            throw new BuildFailedException(MessageFormat.format(Bundle.getMessage("buildErrorCars"), Integer.toString(this._departLocation.getNumberRS()), this._train.getTrainDepartsName(), this._train.getName()));
        }
        TrainBuilderBase.addLine(this._buildReport, THREE, MessageFormat.format(Bundle.getMessage("buildTrainRoute"), this._train.getName(), this._train.getRoute().getName()));
        for (RouteLocation rl : this._routeList) {
            Location location = this.locationManager.getLocationByName(rl.getName());
            if (location == null || rl.getLocation() == null) {
                throw new BuildFailedException(MessageFormat.format(Bundle.getMessage("buildErrorLocMissing"), this._train.getRoute().getName()));
            }
            if (location.isStaging() && rl != this._train.getTrainDepartsRouteLocation() && rl != this._train.getTrainTerminatesRouteLocation()) {
                TrainBuilderBase.addLine(this._buildReport, ONE, MessageFormat.format(Bundle.getMessage("buildLocStaging"), rl.getName()));
                rl.setCarMoves(rl.getMaxCarMoves());
            } else if (this._train.isLocationSkipped(rl.getId())) {
                TrainBuilderBase.addLine(this._buildReport, THREE, MessageFormat.format(Bundle.getMessage("buildLocSkippedMaxTrain"), rl.getId(), rl.getName(), this._train.getName(), rl.getMaxTrainLength(), Setup.getLengthUnit().toLowerCase()));
                rl.setCarMoves(rl.getMaxCarMoves());
            } else if (!rl.isDropAllowed() && !rl.isPickUpAllowed()) {
                TrainBuilderBase.addLine(this._buildReport, THREE, MessageFormat.format(Bundle.getMessage("buildLocNoDropsOrPickups"), rl.getId(), rl.getName(), rl.getMaxTrainLength(), Setup.getLengthUnit().toLowerCase()));
                rl.setCarMoves(rl.getMaxCarMoves());
            } else {
                rl.setCarMoves(0);
                requestedCarMoves += rl.getMaxCarMoves();
                if (location.isStaging() && rl.isPickUpAllowed() && rl == this._train.getTrainDepartsRouteLocation()) {
                    TrainBuilderBase.addLine(this._buildReport, THREE, MessageFormat.format(Bundle.getMessage("buildStagingDeparts"), rl.getId(), rl.getName(), rl.getMaxCarMoves(), rl.getMaxTrainLength(), Setup.getLengthUnit().toLowerCase()));
                } else if (location.isStaging() && rl.isDropAllowed() && rl == this._train.getTrainTerminatesRouteLocation()) {
                    TrainBuilderBase.addLine(this._buildReport, THREE, MessageFormat.format(Bundle.getMessage("buildStagingTerminates"), rl.getId(), rl.getName(), rl.getMaxCarMoves()));
                } else if (rl == this._train.getTrainTerminatesRouteLocation() && rl.isDropAllowed() && rl.isPickUpAllowed()) {
                    TrainBuilderBase.addLine(this._buildReport, THREE, MessageFormat.format(Bundle.getMessage("buildLocTerminatesMoves"), rl.getId(), rl.getName(), rl.getMaxCarMoves()));
                } else if (rl.isDropAllowed() && rl.isPickUpAllowed()) {
                    TrainBuilderBase.addLine(this._buildReport, THREE, MessageFormat.format(Bundle.getMessage("buildLocRequestMoves"), rl.getId(), rl.getName(), rl.getMaxCarMoves(), rl.getMaxTrainLength(), Setup.getLengthUnit().toLowerCase()));
                } else if (!rl.isDropAllowed()) {
                    TrainBuilderBase.addLine(this._buildReport, THREE, MessageFormat.format(Bundle.getMessage("buildLocRequestPickups"), rl.getId(), rl.getName(), rl.getMaxCarMoves(), rl.getMaxTrainLength(), Setup.getLengthUnit().toLowerCase()));
                } else if (rl == this._train.getTrainTerminatesRouteLocation()) {
                    TrainBuilderBase.addLine(this._buildReport, THREE, MessageFormat.format(Bundle.getMessage("buildLocTerminates"), rl.getId(), rl.getName(), rl.getMaxCarMoves()));
                } else {
                    TrainBuilderBase.addLine(this._buildReport, THREE, MessageFormat.format(Bundle.getMessage("buildLocRequestDrops"), rl.getId(), rl.getName(), rl.getMaxCarMoves(), rl.getMaxTrainLength(), Setup.getLengthUnit().toLowerCase()));
                }
            }
            rl.setTrainWeight(0);
            rl.setTrainLength(0);
        }
        for (RouteLocation rl : this._routeList) {
            if (rl.getRandomControl().equals("Off") || rl.getCarMoves() != 0 || rl.getMaxCarMoves() <= 0) continue;
            log.debug("Location ({}) has random control value {} and maximum moves {}", new Object[]{rl.getName(), rl.getRandomControl(), rl.getMaxCarMoves()});
            try {
                int value = Integer.parseInt(rl.getRandomControl());
                double random = Math.random();
                log.debug("random {}", (Object)random);
                int moves = (int)(random * (double)(rl.getMaxCarMoves() * value / 100 + 1));
                log.debug("Reducing number of moves for location ({}) by {}", (Object)rl.getName(), (Object)moves);
                rl.setCarMoves(moves);
                requestedCarMoves -= moves;
                TrainBuilderBase.addLine(this._buildReport, FIVE, MessageFormat.format(Bundle.getMessage("buildRouteRandomControl"), rl.getName(), rl.getId(), rl.getRandomControl(), rl.getMaxCarMoves(), rl.getMaxCarMoves() - moves));
            }
            catch (NumberFormatException numberFormatException) {
                throw new BuildFailedException(MessageFormat.format(Bundle.getMessage("buildErrorRandomControl"), this._train.getRoute().getName(), rl.getName(), rl.getRandomControl()));
            }
        }
        int numMoves = requestedCarMoves;
        if (!this._train.isLocalSwitcher()) {
            requestedCarMoves /= 2;
        }
        TrainBuilderBase.addLine(this._buildReport, ONE, MessageFormat.format(Bundle.getMessage("buildRouteRequest"), this._train.getRoute().getName(), Integer.toString(requestedCarMoves), Integer.toString(numMoves)));
        this._train.setNumberCarsRequested(requestedCarMoves);
        TrainBuilderBase.addLine(this._buildReport, ONE, " ");
    }

    protected void showIfLocalSwitcher() {
        if (this._train.isLocalSwitcher()) {
            TrainBuilderBase.addLine(this._buildReport, THREE, MessageFormat.format(Bundle.getMessage("buildTrainIsSwitcher"), this._train.getName(), TrainCommon.splitString(this._train.getTrainDepartsName())));
            TrainBuilderBase.addLine(this._buildReport, THREE, " ");
        }
    }

    protected void showTrainRequirements() {
        TrainBuilderBase.addLine(this._buildReport, ONE, Bundle.getMessage("TrainRequirements"));
        if (this._train.getNumberEngines().equals("0")) {
            TrainBuilderBase.addLine(this._buildReport, ONE, Bundle.getMessage("buildTrainReq0Engine"));
        } else if (this._train.getNumberEngines().equals(ONE)) {
            TrainBuilderBase.addLine(this._buildReport, ONE, MessageFormat.format(Bundle.getMessage("buildTrainReq1Engine"), this._train.getTrainDepartsName(), this._train.getEngineModel(), this._train.getEngineRoad()));
        } else {
            TrainBuilderBase.addLine(this._buildReport, ONE, MessageFormat.format(Bundle.getMessage("buildTrainReqEngine"), this._train.getTrainDepartsName(), this._train.getNumberEngines(), this._train.getEngineModel(), this._train.getEngineRoad()));
        }
        if ((this._train.getSecondLegOptions() & 1) == 1) {
            TrainBuilderBase.addLine(this._buildReport, ONE, MessageFormat.format(Bundle.getMessage("buildTrainEngineChange"), this._train.getSecondLegStartLocationName(), this._train.getSecondLegNumberEngines(), this._train.getSecondLegEngineModel(), this._train.getSecondLegEngineRoad()));
        }
        if ((this._train.getSecondLegOptions() & 2) == 2) {
            TrainBuilderBase.addLine(this._buildReport, ONE, MessageFormat.format(Bundle.getMessage("buildTrainHelperEngines"), this._train.getSecondLegNumberEngines(), this._train.getSecondLegStartLocationName(), this._train.getSecondLegEndLocationName(), this._train.getSecondLegEngineModel(), this._train.getSecondLegEngineRoad()));
        }
        if ((this._train.getThirdLegOptions() & 1) == 1) {
            TrainBuilderBase.addLine(this._buildReport, ONE, MessageFormat.format(Bundle.getMessage("buildTrainEngineChange"), this._train.getThirdLegStartLocationName(), this._train.getThirdLegNumberEngines(), this._train.getThirdLegEngineModel(), this._train.getThirdLegEngineRoad()));
        }
        if ((this._train.getThirdLegOptions() & 2) == 2) {
            TrainBuilderBase.addLine(this._buildReport, ONE, MessageFormat.format(Bundle.getMessage("buildTrainHelperEngines"), this._train.getThirdLegNumberEngines(), this._train.getThirdLegStartLocationName(), this._train.getThirdLegEndLocationName(), this._train.getThirdLegEngineModel(), this._train.getThirdLegEngineRoad()));
        }
        if (this._train.isCabooseNeeded()) {
            TrainBuilderBase.addLine(this._buildReport, ONE, MessageFormat.format(Bundle.getMessage("buildTrainRequiresCaboose"), this._train.getTrainDepartsName(), this._train.getCabooseRoad()));
        }
        if ((this._train.getSecondLegOptions() & 8) == 8 || (this._train.getSecondLegOptions() & 4) == 4) {
            TrainBuilderBase.addLine(this._buildReport, ONE, MessageFormat.format(Bundle.getMessage("buildCabooseChange"), this._train.getSecondLegStartRouteLocation()));
        }
        if ((this._train.getThirdLegOptions() & 8) == 8 || (this._train.getThirdLegOptions() & 4) == 4) {
            TrainBuilderBase.addLine(this._buildReport, ONE, MessageFormat.format(Bundle.getMessage("buildCabooseChange"), this._train.getThirdLegStartRouteLocation()));
        }
        if (this._train.isFredNeeded()) {
            TrainBuilderBase.addLine(this._buildReport, ONE, MessageFormat.format(Bundle.getMessage("buildTrainRequiresFRED"), this._train.getTrainDepartsName(), this._train.getCabooseRoad()));
        }
        TrainBuilderBase.addLine(this._buildReport, ONE, " ");
    }

    protected void getAndRemoveEnginesFromList() {
        this._engineList = this.engineManager.getAvailableTrainList(this._train);
        int indexEng = 0;
        while (indexEng < this._engineList.size()) {
            Engine engine = this._engineList.get(indexEng);
            if (!this._train.isTypeNameAccepted(engine.getTypeName())) {
                TrainBuilderBase.addLine(this._buildReport, SEVEN, MessageFormat.format(Bundle.getMessage("buildExcludeEngineType"), engine.toString(), engine.getTypeName()));
                this._engineList.remove(indexEng--);
            } else if (!this._train.isOwnerNameAccepted(engine.getOwner())) {
                TrainBuilderBase.addLine(this._buildReport, SEVEN, MessageFormat.format(Bundle.getMessage("buildExcludeEngineOwner"), engine.toString(), engine.getOwner()));
                this._engineList.remove(indexEng--);
            } else if (!this._train.isBuiltDateAccepted(engine.getBuilt())) {
                TrainBuilderBase.addLine(this._buildReport, SEVEN, MessageFormat.format(Bundle.getMessage("buildExcludeEngineBuilt"), engine.toString(), engine.getBuilt()));
                this._engineList.remove(indexEng--);
            } else if (engine.isOutOfService()) {
                TrainBuilderBase.addLine(this._buildReport, SEVEN, MessageFormat.format(Bundle.getMessage("buildExcludeEngineOutOfService"), engine.toString(), engine.getLocationName(), engine.getTrackName()));
                this._engineList.remove(indexEng--);
            }
            ++indexEng;
        }
    }

    protected void setDepartureTrack(Track departStageTrack) {
        if ((this._terminateStageTrack == null || this._terminateStageTrack == this._departStageTrack) && this._departLocation == this._terminateLocation && Setup.isBuildAggressive() && Setup.isStagingTrackImmediatelyAvail()) {
            this._terminateStageTrack = departStageTrack;
        }
        this._departStageTrack = departStageTrack;
    }

    protected boolean getConsist(String reqNumEngines, String model, String road, RouteLocation rl, RouteLocation rld) throws BuildFailedException {
        if (reqNumEngines.equals(Train.AUTO_HPT)) {
            int i = 2;
            while (i < Setup.getMaxNumberEngines()) {
                if (this.getEngines(Integer.toString(i), model, road, rl, rld)) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    protected void showTrainCarTypes() {
        TrainBuilderBase.addLine(this._buildReport, FIVE, " ");
        TrainBuilderBase.addLine(this._buildReport, FIVE, MessageFormat.format(Bundle.getMessage("buildTrainServicesCarTypes"), this._train.getName()));
        TrainBuilderBase.addLine(this._buildReport, FIVE, TrainBuilderBase.formatStringToCommaSeparated(this._train.getCarTypeNames()));
    }

    protected void showTrainLoadNames() {
        if (!this._train.getLoadOption().equals(Train.ALL_LOADS)) {
            TrainBuilderBase.addLine(this._buildReport, FIVE, MessageFormat.format(Bundle.getMessage("buildTrainLoads"), this._train.getName(), this._train.getLoadOption(), TrainBuilderBase.formatStringToCommaSeparated(this._train.getLoadNames())));
        }
    }

    protected Track promptFromStagingDialog() {
        List<Track> tracksIn = this._departLocation.getTracksByNameList(null);
        ArrayList<Track> validTracks = new ArrayList<Track>();
        for (Track track : tracksIn) {
            if (!this.checkDepartureStagingTrack(track)) continue;
            validTracks.add(track);
        }
        if (validTracks.size() > 1) {
            Object[] tracks = new Object[validTracks.size()];
            int i = 0;
            while (i < validTracks.size()) {
                tracks[i] = validTracks.get(i);
                ++i;
            }
            Track selected = (Track)JOptionPane.showInputDialog(null, MessageFormat.format(Bundle.getMessage("TrainDepartingStaging"), this._train.getName(), this._departLocation.getName()), Bundle.getMessage("SelectDepartureTrack"), 3, null, tracks, null);
            if (selected != null) {
                TrainBuilderBase.addLine(this._buildReport, FIVE, MessageFormat.format(Bundle.getMessage("buildUserSelectedDeparture"), selected.getName(), selected.getLocation().getName()));
            }
            return selected;
        }
        if (validTracks.size() == 1) {
            Track track;
            track = (Track)validTracks.get(0);
            TrainBuilderBase.addLine(this._buildReport, FIVE, MessageFormat.format(Bundle.getMessage("buildOnlyOneDepartureTrack"), track.getName(), track.getLocation().getName()));
            return track;
        }
        return null;
    }

    protected Track promptToStagingDialog() {
        List<Track> tracksIn = this._terminateLocation.getTracksByNameList(null);
        ArrayList<Track> validTracks = new ArrayList<Track>();
        for (Track track : tracksIn) {
            if (!this.checkTerminateStagingTrack(track)) continue;
            validTracks.add(track);
        }
        if (validTracks.size() > 1) {
            Object[] tracks = new Object[validTracks.size()];
            int i = 0;
            while (i < validTracks.size()) {
                tracks[i] = validTracks.get(i);
                ++i;
            }
            Track selected = (Track)JOptionPane.showInputDialog(null, MessageFormat.format(Bundle.getMessage("TrainTerminatingStaging"), this._train.getName(), this._terminateLocation.getName()), Bundle.getMessage("SelectArrivalTrack"), 3, null, tracks, null);
            if (selected != null) {
                TrainBuilderBase.addLine(this._buildReport, FIVE, MessageFormat.format(Bundle.getMessage("buildUserSelectedArrival"), selected.getName(), selected.getLocation().getName()));
            }
            return selected;
        }
        if (validTracks.size() == 1) {
            return (Track)validTracks.get(0);
        }
        return null;
    }

    protected boolean getEngines(String requestedEngines, String model, String road, RouteLocation rl, RouteLocation rld) throws BuildFailedException {
        return this.getEngines(requestedEngines, model, road, rl, rld, false);
    }

    /*
     * Unable to fully structure code
     */
    protected boolean getEngines(String requestedEngines, String model, String road, RouteLocation rl, RouteLocation rld, boolean useBunit) throws BuildFailedException {
        departStageTrack = null;
        if (rl == this._train.getTrainDepartsRouteLocation()) {
            departStageTrack = this._departStageTrack;
        }
        numberOfEngines = this.getNumberEngines(requestedEngines);
        if (departStageTrack == null && numberOfEngines == 0) {
            return true;
        }
        if (departStageTrack != null && numberOfEngines == 0 && departStageTrack.getNumberEngines() == 0) {
            return true;
        }
        if (departStageTrack != null && numberOfEngines != 0 && departStageTrack.getNumberEngines() != numberOfEngines) {
            throw new BuildFailedException(MessageFormat.format(Bundle.getMessage("buildStagingNotEngines"), new Object[]{departStageTrack.getName(), departStageTrack.getNumberEngines(), numberOfEngines}));
        }
        if (rl == null || rld == null) {
            throw new BuildFailedException(MessageFormat.format(Bundle.getMessage("buildErrorEngLocUnknown"), new Object[0]));
        }
        TrainBuilderBase.addLine(this._buildReport, "5", MessageFormat.format(Bundle.getMessage("buildBegineSearchEngines"), new Object[]{numberOfEngines, model, road, rl.getName(), rld.getName()}));
        foundLoco = false;
        singleLocos = new ArrayList<Engine>();
        indexEng = 0;
        while (indexEng < this._engineList.size()) {
            block22: {
                block32: {
                    block31: {
                        block30: {
                            block29: {
                                block28: {
                                    block27: {
                                        block26: {
                                            block25: {
                                                block24: {
                                                    block23: {
                                                        engine = this._engineList.get(indexEng);
                                                        TrainBuilderBase.log.debug("Engine ({}) at location ({}, {})", new Object[]{engine.toString(), engine.getLocationName(), engine.getTrackName()});
                                                        if (departStageTrack != null && !departStageTrack.equals(engine.getTrack())) break block22;
                                                        if (engine.getLocationName().equals(rl.getName())) break block23;
                                                        TrainBuilderBase.log.debug("Skipping engine ({}) at location ({})", (Object)engine.toString(), (Object)engine.getLocationName());
                                                        break block22;
                                                    }
                                                    if (model.equals("") || engine.getModel().equals(model)) break block24;
                                                    TrainBuilderBase.addLine(this._buildReport, "7", MessageFormat.format(Bundle.getMessage("buildExcludeEngineModel"), new Object[]{engine.toString(), engine.getModel(), engine.getLocationName()}));
                                                    break block22;
                                                }
                                                if (road.equals("") || engine.getRoadName().equals(road)) break block25;
                                                TrainBuilderBase.addLine(this._buildReport, "7", MessageFormat.format(Bundle.getMessage("buildExcludeEngineRoad"), new Object[]{engine.toString(), engine.getRoadName()}));
                                                break block22;
                                            }
                                            if (!road.equals("") || this._train.isRoadNameAccepted(engine.getRoadName())) break block26;
                                            TrainBuilderBase.addLine(this._buildReport, "7", MessageFormat.format(Bundle.getMessage("buildExcludeEngineRoad"), new Object[]{engine.toString(), engine.getRoadName()}));
                                            break block22;
                                        }
                                        if (!this.checkPickUpTrainDirection(engine, rl)) break block22;
                                        if (engine.getDestination() == null || engine.getDestinationName().equals(rld.getName())) break block27;
                                        TrainBuilderBase.addLine(this._buildReport, "7", MessageFormat.format(Bundle.getMessage("buildExcludeEngineDestination"), new Object[]{engine.toString(), engine.getDestinationName()}));
                                        break block22;
                                    }
                                    if (engine.getConsist() == null || engine.isLead()) break block28;
                                    TrainBuilderBase.addLine(this._buildReport, "7", MessageFormat.format(Bundle.getMessage("buildEnginePartConsist"), new Object[]{engine.toString(), engine.getConsist().getName(), engine.getConsist().getEngines().size()}));
                                    break block22;
                                }
                                if (departStageTrack == null) break block29;
                                if (!this.setLocoDestination(engine, rl, rld)) {
                                    return false;
                                }
                                this._engineList.remove(indexEng--);
                                foundLoco = true;
                                break block22;
                            }
                            if (useBunit || numberOfEngines != 1 || !engine.isBunit()) break block30;
                            TrainBuilderBase.addLine(this._buildReport, "7", MessageFormat.format(Bundle.getMessage("buildExcludeEngineBunit"), new Object[]{engine.toString(), engine.getModel()}));
                            break block22;
                        }
                        if (engine.getConsist() != null) break block31;
                        if (numberOfEngines <= 1) ** GOTO lbl-1000
                        TrainBuilderBase.addLine(this._buildReport, "7", MessageFormat.format(Bundle.getMessage("buildExcludeEngineSingle"), new Object[]{engine.toString(), numberOfEngines}));
                        singleLocos.add(engine);
                        break block22;
                    }
                    if (!engine.isLead()) ** GOTO lbl-1000
                    TrainBuilderBase.addLine(this._buildReport, "7", MessageFormat.format(Bundle.getMessage("buildEngineLeadConsist"), new Object[]{engine.toString(), engine.getConsist().getName(), engine.getConsist().getSize()}));
                    if (engine.getConsist().getSize() != numberOfEngines) break block32;
                    TrainBuilderBase.log.debug("Consist ({}) has the required number of engines", (Object)engine.getConsist().getName());
                    ** GOTO lbl-1000
                }
                if (numberOfEngines != 0) {
                    TrainBuilderBase.addLine(this._buildReport, "7", MessageFormat.format(Bundle.getMessage("buildExcludeEngConsistNumber"), new Object[]{engine.toString(), engine.getConsist().getName(), engine.getConsist().getSize()}));
                } else lbl-1000:
                // 4 sources

                {
                    foundLoco = true;
                    TrainBuilderBase.addLine(this._buildReport, "5", MessageFormat.format(Bundle.getMessage("buildEngineRoadModelType"), new Object[]{engine.toString(), engine.getRoadName(), engine.getModel(), engine.getTypeName(), engine.getLocationName(), engine.getTrackName(), rld.getName()}));
                    if (this.setLocoDestination(engine, rl, rld)) {
                        this._engineList.remove(indexEng--);
                        return true;
                    }
                }
            }
            ++indexEng;
        }
        if (!foundLoco && numberOfEngines > 1 && this._train.isBuildConsistEnabled()) {
            TrainBuilderBase.addLine(this._buildReport, "5", MessageFormat.format(Bundle.getMessage("buildOptionBuildConsist"), new Object[]{numberOfEngines, rl.getName()}));
            TrainBuilderBase.addLine(this._buildReport, "5", MessageFormat.format(Bundle.getMessage("buildOptionSingleLocos"), new Object[]{singleLocos.size(), rl.getName()}));
            if (singleLocos.size() >= numberOfEngines) {
                locos = 0;
                for (Engine engine : singleLocos) {
                    if (engine.isBunit() || !this.setLocoDestination(engine, rl, rld)) continue;
                    this._engineList.remove(engine);
                    singleLocos.remove(engine);
                    ++locos;
                    break;
                }
                if (locos > 0) {
                    for (Engine engine : singleLocos) {
                        if (this.setLocoDestination(engine, rl, rld)) {
                            this._engineList.remove(engine);
                            ++locos;
                        }
                        if (locos != numberOfEngines) continue;
                        return true;
                    }
                } else {
                    for (Engine engine : singleLocos) {
                        if (!engine.isBunit()) continue;
                        TrainBuilderBase.addLine(this._buildReport, "5", MessageFormat.format(Bundle.getMessage("BuildEngineBunit"), new Object[]{engine.toString(), engine.getLocationName(), engine.getTrackName()}));
                    }
                }
            }
        }
        if (!foundLoco) {
            locationName = rl.getName();
            if (departStageTrack != null) {
                locationName = String.valueOf(locationName) + ", " + departStageTrack.getName();
            }
            TrainBuilderBase.addLine(this._buildReport, "5", MessageFormat.format(Bundle.getMessage("buildNoLocosFoundAtLocation"), new Object[]{locationName}));
        } else if (departStageTrack != null) {
            return true;
        }
        return false;
    }

    private int getNumberEngines(String requestEngines) {
        int numberEngines = 0;
        numberEngines = requestEngines.equals(Train.AUTO) ? this.getAutoEngines() : (requestEngines.equals(Train.AUTO_HPT) ? 1 : Integer.parseInt(requestEngines));
        return numberEngines;
    }

    protected boolean setLocoDestination(Engine engine, RouteLocation rl, RouteLocation rld) {
        if (rld == this._train.getTrainTerminatesRouteLocation() && this._terminateStageTrack != null) {
            String status = engine.testDestination(this._terminateStageTrack.getLocation(), this._terminateStageTrack);
            if (status.equals(Track.OKAY)) {
                this.addEngineToTrain(engine, rl, rld, this._terminateStageTrack);
                return true;
            }
            TrainBuilderBase.addLine(this._buildReport, SEVEN, MessageFormat.format(Bundle.getMessage("buildCanNotDropEngineToTrack"), engine.toString(), this._terminateStageTrack.getName(), status, this._terminateStageTrack.getTrackTypeName()));
        } else {
            Location destination = rld.getLocation();
            List<Track> destTracks = destination.getTracksByMovesList(null);
            if (destTracks.size() == 0) {
                TrainBuilderBase.addLine(this._buildReport, THREE, MessageFormat.format(Bundle.getMessage("buildNoTracksAtDestination"), rld.getName()));
            }
            for (Track track : destTracks) {
                if (!this.checkDropTrainDirection(engine, rld, track)) continue;
                String status = engine.testDestination(destination, track);
                if (status.equals(Track.OKAY)) {
                    this.addEngineToTrain(engine, rl, rld, track);
                    return true;
                }
                TrainBuilderBase.addLine(this._buildReport, SEVEN, MessageFormat.format(Bundle.getMessage("buildCanNotDropEngineToTrack"), engine.toString(), track.getName(), status, track.getTrackTypeName()));
            }
            TrainBuilderBase.addLine(this._buildReport, FIVE, MessageFormat.format(Bundle.getMessage("buildCanNotDropEngToDest"), engine.toString(), rld.getName()));
        }
        return false;
    }

    private int getAutoEngines() {
        double numberEngines = 1.0;
        int moves = 0;
        int carLength = 40 + Car.COUPLERS;
        if (!Setup.getLengthUnit().equals(Setup.FEET)) {
            carLength = 12 + Car.COUPLERS;
        }
        for (RouteLocation rl : this._routeList) {
            if (!rl.isPickUpAllowed()) continue;
            moves += rl.getMaxCarMoves();
            double carDivisor = 16.0;
            if (rl.getGrade() > 1.0) {
                carDivisor /= rl.getGrade();
            }
            log.debug("Maximum train length {} for location ({})", (Object)rl.getMaxTrainLength(), (Object)rl.getName());
            if (!((double)rl.getMaxTrainLength() / (carDivisor * (double)carLength) > numberEngines)) continue;
            numberEngines = (double)rl.getMaxTrainLength() / (carDivisor * (double)carLength);
            if (!((numberEngines = Math.ceil(numberEngines)) > (double)moves / carDivisor)) continue;
            numberEngines = Math.ceil((double)moves / carDivisor);
        }
        int nE = (int)numberEngines;
        TrainBuilderBase.addLine(this._buildReport, ONE, MessageFormat.format(Bundle.getMessage("buildAutoBuildMsg"), Integer.toString(nE)));
        if (nE > Setup.getMaxNumberEngines()) {
            TrainBuilderBase.addLine(this._buildReport, THREE, MessageFormat.format(Bundle.getMessage("buildMaximumNumberEngines"), Setup.getMaxNumberEngines()));
            nE = Setup.getMaxNumberEngines();
        }
        return nE;
    }

    protected void removeCaboosesAndCarsWithFred() throws BuildFailedException {
        TrainBuilderBase.addLine(this._buildReport, SEVEN, " ");
        TrainBuilderBase.addLine(this._buildReport, SEVEN, Bundle.getMessage("buildRemoveCarsNotNeeded"));
        int i = 0;
        while (i < this._carList.size()) {
            Car car = this._carList.get(i);
            if (car.isCaboose() || car.hasFred()) {
                TrainBuilderBase.addLine(this._buildReport, SEVEN, MessageFormat.format(Bundle.getMessage("buildExcludeCarTypeAtLoc"), car.toString(), car.getTypeName(), String.valueOf(car.getLocationName()) + ", " + car.getTrackName()));
                if (car.getTrack() == this._departStageTrack) {
                    throw new BuildFailedException("ERROR: Attempt to removed car with FRED or Caboose from staging");
                }
                this._carList.remove(car);
                --i;
            }
            ++i;
        }
    }

    protected void saveCarFinalDestinations() {
        for (Car car : this._carList) {
            car.setPreviousFinalDestination(car.getFinalDestination());
            car.setPreviousFinalDestinationTrack(car.getFinalDestinationTrack());
            car.setPreviousScheduleId(car.getScheduleItemId());
        }
    }

    /*
     * Unable to fully structure code
     */
    protected void loadCarList() throws BuildFailedException {
        this._carList = this.carManager.getAvailableTrainList(this._train);
        if (this._train.getNumberCarsRequested() > this._carList.size() && Control.fullTrainOnly) {
            throw new BuildFailedException(MessageFormat.format(Bundle.getMessage("buildErrorNumReq"), new Object[]{Integer.toString(this._train.getNumberCarsRequested()), this._train.getName(), Integer.toString(this._carList.size())}));
        }
        TrainBuilderBase.addLine(this._buildReport, "7", " ");
        TrainBuilderBase.addLine(this._buildReport, "7", Bundle.getMessage("buildRemoveCars"));
        showCar = true;
        carListSize = this._carList.size();
        i = 0;
        while (i < this._carList.size()) {
            block32: {
                block39: {
                    block40: {
                        block38: {
                            block37: {
                                block36: {
                                    block35: {
                                        block34: {
                                            block33: {
                                                block31: {
                                                    car = this._carList.get(i);
                                                    if (showCar && carListSize - this._carList.size() == 100) {
                                                        showCar = false;
                                                        TrainBuilderBase.addLine(this._buildReport, "5", MessageFormat.format(Bundle.getMessage("buildOnlyFirstXXXCars"), new Object[]{100, Bundle.getMessage("Type")}));
                                                    }
                                                    if (car.getTrack() != null) break block31;
                                                    ++this._warnings;
                                                    TrainBuilderBase.addLine(this._buildReport, "1", MessageFormat.format(Bundle.getMessage("buildWarningRsNoTrack"), new Object[]{car.toString(), car.getLocationName()}));
                                                    this._carList.remove(car);
                                                    --i;
                                                    break block32;
                                                }
                                                if (!car.isLocationUnknown()) break block33;
                                                TrainBuilderBase.addLine(this._buildReport, "7", MessageFormat.format(Bundle.getMessage("buildExcludeCarLocUnknown"), new Object[]{car.toString(), car.getLocationName(), car.getTrackName()}));
                                                if (car.getTrack().equals(this._departStageTrack)) {
                                                    throw new BuildFailedException(MessageFormat.format(Bundle.getMessage("buildErrorLocationUnknown"), new Object[]{car.getLocationName(), car.getTrackName(), car.toString()}));
                                                }
                                                this._carList.remove(car);
                                                --i;
                                                break block32;
                                            }
                                            if (!car.isOutOfService()) break block34;
                                            TrainBuilderBase.addLine(this._buildReport, "7", MessageFormat.format(Bundle.getMessage("buildExcludeCarOutOfService"), new Object[]{car.toString(), car.getLocationName(), car.getTrackName()}));
                                            if (car.getTrack().equals(this._departStageTrack)) {
                                                throw new BuildFailedException(MessageFormat.format(Bundle.getMessage("buildErrorLocationOutOfService"), new Object[]{car.getLocationName(), car.getTrackName(), car.toString()}));
                                            }
                                            this._carList.remove(car);
                                            --i;
                                            break block32;
                                        }
                                        if (car.getDestination() == null) break block35;
                                        TrainBuilderBase.addLine(this._buildReport, "7", MessageFormat.format(Bundle.getMessage("buildCarHasAssignedDest"), new Object[]{car.toString(), car.getLoadName(), car.getDestinationName(), car.getDestinationTrackName()}));
                                        rld = this._train.getRoute().getLastLocationByName(car.getDestinationName());
                                        if (rld != null) break block35;
                                        TrainBuilderBase.addLine(this._buildReport, "7", MessageFormat.format(Bundle.getMessage("buildExcludeCarDestNotPartRoute"), new Object[]{car.toString(), car.getDestinationName(), this._train.getRoute().getName()}));
                                        if (car.getLocation().equals(this._departLocation) && this._departStageTrack != null) {
                                            throw new BuildFailedException(MessageFormat.format(Bundle.getMessage("buildErrorCarNotPartRoute"), new Object[]{car.toString()}));
                                        }
                                        this._carList.remove(car);
                                        --i;
                                        break block32;
                                    }
                                    if (!car.hasFred() || car.getDestination() == null || car.getDestination() == this._terminateLocation) break block36;
                                    TrainBuilderBase.addLine(this._buildReport, "5", MessageFormat.format(Bundle.getMessage("buildExcludeCarWrongDest"), new Object[]{car.toString(), car.getTypeName(), car.getTypeExtensions(), car.getDestinationName()}));
                                    this._carList.remove(car);
                                    --i;
                                    break block32;
                                }
                                if (!car.isCaboose() || car.getDestination() == null || car.getDestination() == this._terminateLocation || (this._train.getSecondLegOptions() & 12) != 0 || (this._train.getThirdLegOptions() & 12) != 0) break block37;
                                TrainBuilderBase.addLine(this._buildReport, "5", MessageFormat.format(Bundle.getMessage("buildExcludeCarWrongDest"), new Object[]{car.toString(), car.getTypeName(), car.getTypeExtensions(), car.getDestinationName()}));
                                this._carList.remove(car);
                                --i;
                                break block32;
                            }
                            if (!car.getTrack().isInterchange() || !car.getTrack().getPickupOption().equals("Any") || !car.getLastRouteId().equals(this._train.getRoute().getId())) break block38;
                            TrainBuilderBase.addLine(this._buildReport, "7", MessageFormat.format(Bundle.getMessage("buildExcludeCarDropByTrain"), new Object[]{car.toString(), this._train.getRoute().getName(), car.getLocationName(), car.getTrackName()}));
                            this._carList.remove(car);
                            --i;
                            break block32;
                        }
                        if (!car.getTrack().isInterchange() && !car.getTrack().isSpur()) ** GOTO lbl93
                        if (!car.getTrack().getPickupOption().equals("trains") && !car.getTrack().getPickupOption().equals("excludeTrains")) break block39;
                        if (!car.getTrack().isPickupTrainAccepted(this._train)) break block40;
                        TrainBuilderBase.log.debug("Car ({}) can be picked up by this train", (Object)car.toString());
                        ** GOTO lbl93
                    }
                    TrainBuilderBase.addLine(this._buildReport, "7", MessageFormat.format(Bundle.getMessage("buildExcludeCarByTrain"), new Object[]{car.toString(), car.getTrack().getTrackTypeName(), car.getLocationName(), car.getTrackName()}));
                    this._carList.remove(car);
                    --i;
                    break block32;
                }
                if (!car.getTrack().getPickupOption().equals("routes") && !car.getTrack().getPickupOption().equals("excludeRoutes")) ** GOTO lbl93
                if (!car.getTrack().isPickupRouteAccepted(this._train.getRoute())) {
                    TrainBuilderBase.addLine(this._buildReport, "7", MessageFormat.format(Bundle.getMessage("buildExcludeCarByRoute"), new Object[]{car.toString(), car.getTrack().getTrackTypeName(), car.getLocationName(), car.getTrackName()}));
                    this._carList.remove(car);
                    --i;
                } else {
                    TrainBuilderBase.log.debug("Car ({}) can be picked up by this route", (Object)car.toString());
lbl93:
                    // 4 sources

                    if (!this._train.isRoadNameAccepted(car.getRoadName())) {
                        TrainBuilderBase.addLine(this._buildReport, "7", MessageFormat.format(Bundle.getMessage("buildExcludeCarWrongRoad"), new Object[]{car.toString(), car.getTypeName(), car.getRoadName()}));
                        this._carList.remove(car);
                        --i;
                    } else if (!this._train.isTypeNameAccepted(car.getTypeName())) {
                        if (showCar) {
                            TrainBuilderBase.addLine(this._buildReport, "7", MessageFormat.format(Bundle.getMessage("buildExcludeCarWrongType"), new Object[]{car.toString(), car.getTypeName()}));
                        }
                        this._carList.remove(car);
                        --i;
                    } else if (!this._train.isOwnerNameAccepted(car.getOwner())) {
                        TrainBuilderBase.addLine(this._buildReport, "7", MessageFormat.format(Bundle.getMessage("buildExcludeCarOwnerAtLoc"), new Object[]{car.toString(), car.getOwner(), String.valueOf(car.getLocationName()) + ", " + car.getTrackName()}));
                        this._carList.remove(car);
                        --i;
                    } else if (!this._train.isBuiltDateAccepted(car.getBuilt())) {
                        TrainBuilderBase.addLine(this._buildReport, "7", MessageFormat.format(Bundle.getMessage("buildExcludeCarBuiltAtLoc"), new Object[]{car.toString(), car.getBuilt(), String.valueOf(car.getLocationName()) + ", " + car.getTrackName()}));
                        this._carList.remove(car);
                        --i;
                    } else if (this._departStageTrack == null || car.getTrack() != this._departStageTrack) {
                        if (!(car.isCaboose() || car.isPassenger() || this._train.isLoadNameAccepted(car.getLoadName(), car.getTypeName()))) {
                            TrainBuilderBase.addLine(this._buildReport, "7", MessageFormat.format(Bundle.getMessage("buildExcludeCarLoadAtLoc"), new Object[]{car.toString(), car.getTypeName(), car.getLoadName()}));
                            this._carList.remove(car);
                            --i;
                        } else if (car.hasFred() && !this._train.isFredNeeded()) {
                            TrainBuilderBase.addLine(this._buildReport, "7", MessageFormat.format(Bundle.getMessage("buildExcludeCarWithFredAtLoc"), new Object[]{car.toString(), car.getTypeName(), String.valueOf(car.getLocationName()) + ", " + car.getTrackName()}));
                            this._carList.remove(car);
                            --i;
                        } else if (car.getWait() > 0) {
                            TrainBuilderBase.addLine(this._buildReport, "7", MessageFormat.format(Bundle.getMessage("buildExcludeCarWait"), new Object[]{car.toString(), car.getTypeName(), car.getLocationName(), car.getTrackName(), car.getWait()}));
                            if (this._train.isServiceable(car)) {
                                TrainBuilderBase.addLine(this._buildReport, "7", MessageFormat.format(Bundle.getMessage("buildTrainCanServiceWait"), new Object[]{this._train.getName(), car.toString(), car.getWait() - 1}));
                                car.setWait(car.getWait() - 1);
                                oldLoad = car.getLoadName();
                                if (car.getTrack().isSpur()) {
                                    car.updateLoad();
                                }
                                if (!oldLoad.equals(newLoad = car.getLoadName())) {
                                    TrainBuilderBase.addLine(this._buildReport, "7", MessageFormat.format(Bundle.getMessage("buildCarLoadChangedWait"), new Object[]{car.toString(), car.getTypeName(), oldLoad, newLoad}));
                                }
                            }
                            this._carList.remove(car);
                            --i;
                        } else if (!car.getPickupScheduleId().equals("")) {
                            if (this.trainScheduleManager.getTrainScheduleActiveId().equals("ANY") || car.getPickupScheduleId().equals(this.trainScheduleManager.getTrainScheduleActiveId())) {
                                car.setPickupScheduleId("");
                            } else {
                                sch = this.trainScheduleManager.getScheduleById(car.getPickupScheduleId());
                                if (sch != null) {
                                    TrainBuilderBase.addLine(this._buildReport, "7", MessageFormat.format(Bundle.getMessage("buildExcludeCarSchedule"), new Object[]{car.toString(), car.getTypeName(), car.getLocationName(), car.getTrackName(), sch.getName()}));
                                    this._carList.remove(car);
                                    --i;
                                }
                            }
                        }
                    }
                }
            }
            ++i;
        }
    }

    protected void adjustCarsInStaging() throws BuildFailedException {
        if (this._departStageTrack == null) {
            return;
        }
        int numCarsFromStaging = 0;
        this._numOfBlocks = new Hashtable();
        TrainBuilderBase.addLine(this._buildReport, SEVEN, " ");
        TrainBuilderBase.addLine(this._buildReport, SEVEN, Bundle.getMessage("buildRemoveCarsStaging"));
        int i = 0;
        while (i < this._carList.size()) {
            Car car = this._carList.get(i);
            if (car.getLocationName().equals(this._departLocation.getName())) {
                if (car.getTrackName().equals(this._departStageTrack.getName())) {
                    ++numCarsFromStaging;
                    if (!(car.isCaboose() || car.hasFred() || car.isPassenger() || car.getKernel() != null && !car.isLead())) {
                        log.debug("Car {} last location id: {}", (Object)car.toString(), (Object)car.getLastLocationId());
                        Integer number = 1;
                        if (this._numOfBlocks.containsKey(car.getLastLocationId())) {
                            number = this._numOfBlocks.get(car.getLastLocationId()) + 1;
                            this._numOfBlocks.remove(car.getLastLocationId());
                        }
                        this._numOfBlocks.put(car.getLastLocationId(), number);
                    }
                } else {
                    TrainBuilderBase.addLine(this._buildReport, SEVEN, MessageFormat.format(Bundle.getMessage("buildExcludeCarAtLoc"), car.toString(), String.valueOf(car.getLocationName()) + ", " + car.getTrackName()));
                    this._carList.remove(car);
                    --i;
                }
            }
            ++i;
        }
        TrainBuilderBase.addLine(this._buildReport, FIVE, " ");
        TrainBuilderBase.addLine(this._buildReport, FIVE, MessageFormat.format(Bundle.getMessage("buildDepartingStagingCars"), this._departStageTrack.getLocation().getName(), this._departStageTrack.getName(), numCarsFromStaging));
        for (Car car : this._carList) {
            if (car.getTrack() != this._departStageTrack) continue;
            TrainBuilderBase.addLine(this._buildReport, SEVEN, MessageFormat.format(Bundle.getMessage("buildStagingCarAtLoc"), car.toString(), car.getTypeName(), car.getLoadName()));
        }
        if (numCarsFromStaging != this._departStageTrack.getNumberCars()) {
            throw new BuildFailedException(MessageFormat.format(Bundle.getMessage("buildErrorNotAllCars"), this._departStageTrack.getName(), Integer.toString(this._departStageTrack.getNumberCars() - numCarsFromStaging)));
        }
        log.debug("Staging departure track ({}) has {} cars and {} blocks", new Object[]{this._departStageTrack.getName(), numCarsFromStaging, this._numOfBlocks.size()});
    }

    /*
     * Unable to fully structure code
     */
    protected void listCarsByLocation() throws BuildFailedException {
        TrainBuilderBase.addLine(this._buildReport, "5", " ");
        TrainBuilderBase.addLine(this._buildReport, "1", MessageFormat.format(Bundle.getMessage("buildFoundCars"), new Object[]{Integer.toString(this._carList.size()), this._train.getName()}));
        locationNames = new ArrayList<String>();
        for (RouteLocation rl : this._train.getRoute().getLocationsBySequenceList()) {
            if (locationNames.contains(rl.getName())) continue;
            locationNames.add(rl.getName());
            if (rl.getLocation().isStaging()) {
                TrainBuilderBase.addLine(this._buildReport, "7", MessageFormat.format(Bundle.getMessage("buildCarsInStaging"), new Object[]{rl.getName()}));
            } else {
                TrainBuilderBase.addLine(this._buildReport, "7", MessageFormat.format(Bundle.getMessage("buildCarsAtLocation"), new Object[]{rl.getName()}));
            }
            carCount = 0;
            i = 0;
            while (i < this._carList.size()) {
                block13: {
                    car = this._carList.get(i);
                    if (!car.getLocationName().equals(rl.getName())) break block13;
                    if (carCount < 50 && (car.getKernel() == null || car.isLead())) {
                        if (car.getLoadPriority().equals(CarLoad.PRIORITY_LOW)) {
                            TrainBuilderBase.addLine(this._buildReport, "7", MessageFormat.format(Bundle.getMessage("buildCarAtLocWithMoves"), new Object[]{car.toString(), car.getTypeName(), car.getTypeExtensions(), car.getLocationName(), car.getTrackName(), car.getMoves()}));
                        } else {
                            TrainBuilderBase.addLine(this._buildReport, "7", MessageFormat.format(Bundle.getMessage("buildCarAtLocWithMovesPriority"), new Object[]{car.toString(), car.getTypeName(), car.getTypeExtensions(), car.getLocationName(), car.getTrackName(), car.getMoves(), car.getLoadName(), car.getLoadPriority()}));
                        }
                        if (car.isLead()) {
                            TrainBuilderBase.addLine(this._buildReport, "7", MessageFormat.format(Bundle.getMessage("buildCarLeadKernel"), new Object[]{car.toString(), car.getKernelName(), car.getKernel().getSize(), car.getKernel().getTotalLength(), Setup.getLengthUnit().toLowerCase()}));
                            for (Car k : car.getKernel().getCars()) {
                                if (k.isLead()) continue;
                                TrainBuilderBase.addLine(this._buildReport, "7", MessageFormat.format(Bundle.getMessage("buildCarPartOfKernel"), new Object[]{k.toString(), k.getKernelName(), k.getKernel().getSize(), k.getKernel().getTotalLength(), Setup.getLengthUnit().toLowerCase()}));
                            }
                        }
                        if (++carCount == 50) {
                            TrainBuilderBase.addLine(this._buildReport, "7", MessageFormat.format(Bundle.getMessage("buildOnlyFirstXXXCars"), new Object[]{carCount, rl.getName()}));
                        }
                    }
                    if (car.getKernel() == null) ** GOTO lbl-1000
                    this.checkKernel(car);
                    if (!car.isLead()) {
                        this._carList.remove(car);
                        --i;
                    } else if (this._train.equals(car.getTrain())) {
                        TrainBuilderBase.addLine(this._buildReport, "5", MessageFormat.format(Bundle.getMessage("buildCarAlreadyAssigned"), new Object[]{car.toString()}));
                    }
                }
                ++i;
            }
            TrainBuilderBase.addLine(this._buildReport, "7", " ");
        }
    }

    protected void sortCarsOnFifoLifoTracks() {
        TrainBuilderBase.addLine(this._buildReport, SEVEN, Bundle.getMessage("buildSortCarsByLastDate"));
        this._carIndex = 0;
        while (this._carIndex < this._carList.size()) {
            Car car = this._carList.get(this._carIndex);
            if (!car.getTrack().getServiceOrder().equals(Track.NORMAL)) {
                TrainBuilderBase.addLine(this._buildReport, SEVEN, MessageFormat.format(Bundle.getMessage("buildTrackModePriority"), car.toString(), car.getTrack().getTrackType(), car.getTrackName(), car.getTrack().getServiceOrder(), car.getLastDate()));
                Car bestCar = car;
                int i = this._carIndex + 1;
                while (i < this._carList.size()) {
                    Car testCar = this._carList.get(i);
                    if (testCar.getTrack() == car.getTrack()) {
                        log.debug("{} car ({}) last moved date: {}", new Object[]{car.getTrack().getTrackType(), testCar.toString(), testCar.getLastDate()});
                        if (car.getTrack().getServiceOrder().equals(Track.FIFO)) {
                            if (bestCar.getLastMoveDate().after(testCar.getLastMoveDate()) && bestCar.getLoadPriority().equals(testCar.getLoadPriority())) {
                                bestCar = testCar;
                                log.debug("New best car ({})", (Object)bestCar.toString());
                            }
                        } else if (car.getTrack().getServiceOrder().equals(Track.LIFO) && bestCar.getLastMoveDate().before(testCar.getLastMoveDate()) && bestCar.getLoadPriority().equals(testCar.getLoadPriority())) {
                            bestCar = testCar;
                            log.debug("New best car ({})", (Object)bestCar.toString());
                        }
                    }
                    ++i;
                }
                if (car != bestCar) {
                    TrainBuilderBase.addLine(this._buildReport, SEVEN, MessageFormat.format(Bundle.getMessage("buildTrackModeCarPriority"), car.getTrack().getTrackType(), car.getTrackName(), car.getTrack().getServiceOrder(), bestCar.toString(), bestCar.getLastDate(), car.toString(), car.getLastDate()));
                    this._carList.remove(bestCar);
                    this._carList.add(this._carIndex, bestCar);
                }
            }
            ++this._carIndex;
        }
        TrainBuilderBase.addLine(this._buildReport, SEVEN, " ");
    }

    private void checkKernel(Car car) throws BuildFailedException {
        boolean foundLeadCar = false;
        for (Car c : car.getKernel().getCars()) {
            if (c.isLead() && !c.isOutOfService()) {
                foundLeadCar = true;
            }
            if (car.getLocation() == c.getLocation() && car.getTrack() == c.getTrack()) continue;
            throw new BuildFailedException(MessageFormat.format(Bundle.getMessage("buildErrorCarKernelLocation"), c.toString(), car.getKernelName(), c.getLocationName(), c.getTrackName(), car.toString(), car.getLocationName(), car.getTrackName()));
        }
        if (!foundLeadCar) {
            throw new BuildFailedException(MessageFormat.format(Bundle.getMessage("buildErrorCarKernelNoLead"), car.getKernelName()));
        }
    }

    protected String getLargestBlock() {
        Enumeration<String> en = this._numOfBlocks.keys();
        String largestBlock = "";
        int maxCars = 0;
        while (en.hasMoreElements()) {
            String locId = en.nextElement();
            if (this._numOfBlocks.get(locId) <= maxCars) continue;
            largestBlock = locId;
            maxCars = this._numOfBlocks.get(locId);
        }
        return largestBlock;
    }

    protected RouteLocation getLocationWithMaximumMoves(List<RouteLocation> blockRouteList, String blockId) {
        RouteLocation rlMax = null;
        int maxMoves = 0;
        for (RouteLocation rl : blockRouteList) {
            if (rl == this._train.getTrainDepartsRouteLocation()) continue;
            if (rl.getMaxCarMoves() - rl.getCarMoves() > maxMoves) {
                maxMoves = rl.getMaxCarMoves() - rl.getCarMoves();
                rlMax = rl;
            }
            if (rl.getMaxCarMoves() - rl.getCarMoves() != maxMoves || rl.getLocation().getId().equals(blockId)) continue;
            rlMax = rl;
        }
        return rlMax;
    }

    protected void makeAdjustmentsIfDepartingStaging() {
        if (this._departStageTrack != null) {
            this._reqNumOfMoves = 0;
            if (this._departStageTrack == this._terminateStageTrack) {
                if (!this._train.isAllowReturnToStagingEnabled() && !Setup.isStagingAllowReturnEnabled()) {
                    for (Car car : this.carManager.getList()) {
                        if (car.getTrack() != this._departStageTrack || car.getRouteDestination() != null) continue;
                        car.setLocation(car.getLocation(), null);
                    }
                } else {
                    TrainBuilderBase.addLine(this._buildReport, THREE, " ");
                    TrainBuilderBase.addLine(this._buildReport, THREE, MessageFormat.format(Bundle.getMessage("buildWarnDepartStaging"), this._departStageTrack.getLocation().getName(), this._departStageTrack.getName()));
                    TrainBuilderBase.addLine(this._buildReport, THREE, " ");
                }
            }
            TrainBuilderBase.addLine(this._buildReport, THREE, MessageFormat.format(Bundle.getMessage("buildDepartStagingAggressive"), this._departStageTrack.getLocation().getName()));
        }
    }

    protected void restoreCarsIfDepartingStaging() {
        if (this._departStageTrack != null && this._departStageTrack == this._terminateStageTrack && !this._train.isAllowReturnToStagingEnabled() && !Setup.isStagingAllowReturnEnabled()) {
            for (Car car : this._carList) {
                if (car.getLocation() != this._departStageTrack.getLocation() || car.getTrack() != null) continue;
                car.setLocation(this._departStageTrack.getLocation(), this._departStageTrack, true);
                if (car.getKernel() == null) continue;
                for (Car k : car.getKernel().getCars()) {
                    k.setLocation(this._departStageTrack.getLocation(), this._departStageTrack, true);
                }
            }
        }
    }

    protected void showLoadGenerationOptionsStaging() {
        if (this._departStageTrack != null && this._reqNumOfMoves > 0 && (this._departStageTrack.isAddCustomLoadsEnabled() || this._departStageTrack.isAddCustomLoadsAnySpurEnabled() || this._departStageTrack.isAddCustomLoadsAnyStagingTrackEnabled())) {
            TrainBuilderBase.addLine(this._buildReport, FIVE, MessageFormat.format(Bundle.getMessage("buildCustomLoadOptions"), this._departStageTrack.getName()));
            if (this._departStageTrack.isAddCustomLoadsEnabled()) {
                TrainBuilderBase.addLine(this._buildReport, FIVE, Bundle.getMessage("buildLoadCarLoads"));
            }
            if (this._departStageTrack.isAddCustomLoadsAnySpurEnabled()) {
                TrainBuilderBase.addLine(this._buildReport, FIVE, Bundle.getMessage("buildLoadAnyCarLoads"));
            }
            if (this._departStageTrack.isAddCustomLoadsAnyStagingTrackEnabled()) {
                TrainBuilderBase.addLine(this._buildReport, FIVE, Bundle.getMessage("buildLoadsStaging"));
            }
            TrainBuilderBase.addLine(this._buildReport, FIVE, " ");
        }
    }

    protected void checkStuckCarsInStaging() throws BuildFailedException {
        if (this._departStageTrack == null) {
            return;
        }
        int carCount = 0;
        StringBuffer buf = new StringBuffer();
        for (Car car : this._carList) {
            if (car.getTrack() != this._departStageTrack || car.getDestination() != null && car.getDestinationTrack() != null && car.getTrain() != null) continue;
            if (car.getKernel() != null) {
                for (Car c : car.getKernel().getCars()) {
                    this.addCarToList(c, buf, ++carCount);
                }
                continue;
            }
            this.addCarToList(car, buf, ++carCount);
        }
        if (carCount > 0) {
            log.debug("{} cars stuck in staging", (Object)carCount);
            String msg = MessageFormat.format(Bundle.getMessage("buildStagingCouldNotFindDest"), carCount, this._departStageTrack.getLocation().getName(), this._departStageTrack.getName());
            throw new BuildFailedException(String.valueOf(msg) + buf.toString(), "staging");
        }
    }

    private void addCarToList(Car car, StringBuffer buf, int carCount) {
        if (carCount <= 20) {
            buf.append("\n " + car.toString());
        } else if (carCount == 21) {
            buf.append("\n" + MessageFormat.format(Bundle.getMessage("buildOnlyFirstXXXCars"), 20, this._departStageTrack.getName()));
        }
    }

    protected boolean isCarStuckStaging() {
        if (this._departStageTrack == null) {
            return false;
        }
        for (Car car : this._carList) {
            if (car.getTrack() != this._departStageTrack || car.getDestination() != null && car.getDestinationTrack() != null && car.getTrain() != null) continue;
            return true;
        }
        return false;
    }

    private void addEngineToTrain(Engine engine, RouteLocation rl, RouteLocation rld, Track track) {
        this._lastEngine = engine;
        if (this._train.getLeadEngine() == null) {
            this._train.setLeadEngine(engine);
        }
        TrainBuilderBase.addLine(this._buildReport, ONE, MessageFormat.format(Bundle.getMessage("buildEngineAssigned"), engine.toString(), rl.getName(), rld.getName(), track.getName()));
        engine.setDestination(track.getLocation(), track);
        int length = engine.getTotalLength();
        int weightTons = engine.getAdjustedWeightTons();
        if (engine.getConsist() != null) {
            length = engine.getConsist().getTotalLength();
            weightTons = engine.getConsist().getAdjustedWeightTons();
            for (Engine cEngine : engine.getConsist().getEngines()) {
                if (cEngine == engine) continue;
                TrainBuilderBase.addLine(this._buildReport, ONE, MessageFormat.format(Bundle.getMessage("buildEngineAssigned"), cEngine.toString(), rl.getName(), rld.getName(), track.getName()));
                cEngine.setTrain(this._train);
                cEngine.setRouteLocation(rl);
                cEngine.setRouteDestination(rld);
                cEngine.setDestination(track.getLocation(), track, true);
            }
        }
        this.finishAddRsToTrain(engine, rl, rld, length, weightTons);
    }

    protected void addCarToTrain(Car car, RouteLocation rl, RouteLocation rld, Track track) {
        TrainBuilderBase.addLine(this._buildReport, THREE, MessageFormat.format(Bundle.getMessage("buildCarAssignedDest"), car.toString(), rld.getName(), track.getName()));
        car.setDestination(track.getLocation(), track);
        int length = car.getTotalLength();
        int weightTons = car.getAdjustedWeightTons();
        if (car.getKernel() != null) {
            length = car.getKernel().getTotalLength();
            weightTons = car.getKernel().getAdjustedWeightTons();
            List<Car> kCars = car.getKernel().getCars();
            TrainBuilderBase.addLine(this._buildReport, THREE, MessageFormat.format(Bundle.getMessage("buildCarPartOfKernel"), car.toString(), car.getKernelName(), kCars.size(), car.getKernel().getTotalLength(), Setup.getLengthUnit().toLowerCase()));
            for (Car kCar : kCars) {
                if (kCar == car) continue;
                TrainBuilderBase.addLine(this._buildReport, THREE, MessageFormat.format(Bundle.getMessage("buildCarKernelAssignedDest"), kCar.toString(), kCar.getKernelName(), rld.getName(), track.getName()));
                kCar.setTrain(this._train);
                kCar.setRouteLocation(rl);
                kCar.setRouteDestination(rld);
                kCar.setDestination(track.getLocation(), track, true);
                kCar.setPreviousFinalDestination(car.getPreviousFinalDestination());
                kCar.setPreviousFinalDestinationTrack(car.getPreviousFinalDestinationTrack());
            }
            car.updateKernel();
        }
        if (!this._train.isLoadNameAccepted(car.getLoadName(), car.getTypeName())) {
            ++this._warnings;
            TrainBuilderBase.addLine(this._buildReport, SEVEN, MessageFormat.format(Bundle.getMessage("buildWarnCarDepartStaging"), car.toString(), car.getLoadName()));
        }
        TrainBuilderBase.addLine(this._buildReport, THREE, " ");
        ++this._numberCars;
        ++this._completedMoves;
        --this._reqNumOfMoves;
        if (this._reqNumOfMoves <= 0) {
            this._success = true;
        }
        this._carList.remove(car);
        --this._carIndex;
        rl.setCarMoves(rl.getCarMoves() + 1);
        if (rl != rld) {
            rld.setCarMoves(rld.getCarMoves() + 1);
        }
        this.finishAddRsToTrain(car, rl, rld, length, weightTons);
    }

    private void finishAddRsToTrain(RollingStock rs, RouteLocation rl, RouteLocation rld, int length, int weightTons) {
        if (!this._modifiedLocations.contains(rl.getLocation())) {
            this._modifiedLocations.add(rl.getLocation());
        }
        if (!this._modifiedLocations.contains(rld.getLocation())) {
            this._modifiedLocations.add(rld.getLocation());
        }
        rs.setTrain(this._train);
        rs.setRouteLocation(rl);
        rs.setRouteDestination(rld);
        boolean inTrain = false;
        for (RouteLocation routeLocation : this._routeList) {
            if (rl == routeLocation) {
                inTrain = true;
            }
            if (rld == routeLocation) break;
            if (!inTrain) continue;
            routeLocation.setTrainLength(routeLocation.getTrainLength() + length);
            routeLocation.setTrainWeight(routeLocation.getTrainWeight() + weightTons);
        }
    }

    protected boolean checkPickUpTrainDirection(RollingStock rs, RouteLocation rl) throws BuildFailedException {
        if (rs.getTrack() == null) {
            throw new BuildFailedException(MessageFormat.format(Bundle.getMessage("buildWarningRsNoTrack"), rs.toString(), rs.getLocationName()));
        }
        if (this._train.isLocalSwitcher()) {
            return true;
        }
        if ((rl.getTrainDirection() & rs.getLocation().getTrainDirections() & rs.getTrack().getTrainDirections()) != 0) {
            return true;
        }
        TrainBuilderBase.addLine(this._buildReport, SEVEN, MessageFormat.format(Bundle.getMessage("buildRsCanNotPickupUsingTrain"), rs.toString(), rl.getTrainDirectionString(), rs.getTrackName(), rs.getLocationName(), rl.getId()));
        return false;
    }

    protected boolean checkPickUpTrainDirection(RouteLocation rl) {
        if (this._train.isLocalSwitcher()) {
            return true;
        }
        if ((rl.getTrainDirection() & rl.getLocation().getTrainDirections()) != 0) {
            return true;
        }
        TrainBuilderBase.addLine(this._buildReport, ONE, MessageFormat.format(Bundle.getMessage("buildLocDirection"), rl.getName(), rl.getTrainDirectionString()));
        return false;
    }

    protected boolean checkTrainLength(Car car, RouteLocation rl, RouteLocation rld) {
        int length = car.getTotalLength();
        if (car.getKernel() != null) {
            length = car.getKernel().getTotalLength();
        }
        boolean carInTrain = false;
        for (RouteLocation rlt : this._routeList) {
            if (rl == rlt) {
                carInTrain = true;
            }
            if (rld == rlt) break;
            if (!carInTrain || rlt.getTrainLength() + length <= rlt.getMaxTrainLength()) continue;
            TrainBuilderBase.addLine(this._buildReport, FIVE, MessageFormat.format(Bundle.getMessage("buildCanNotPickupCarLength"), car.toString(), length, Setup.getLengthUnit().toLowerCase(), rlt.getMaxTrainLength(), Setup.getLengthUnit().toLowerCase(), rlt.getTrainLength() + length - rlt.getMaxTrainLength(), rlt.getName(), rlt.getId()));
            return false;
        }
        return true;
    }

    protected boolean checkDropTrainDirection(RollingStock rs, RouteLocation rld, Track track) {
        Car car;
        if (this._train.isLocalSwitcher()) {
            return true;
        }
        int serviceTrainDir = rld.getLocation().getTrainDirections();
        if (track != null) {
            serviceTrainDir &= track.getTrainDirections();
        }
        if ((rld.getTrainDirection() & serviceTrainDir) != 0 && rs != null && track != null && Car.class.isInstance(rs) && (car = (Car)rs).getFinalDestinationTrack() != null && track == car.getFinalDestinationTrack().getAlternateTrack() && (track.getTrainDirections() & car.getFinalDestinationTrack().getTrainDirections()) == 0) {
            TrainBuilderBase.addLine(this._buildReport, SEVEN, MessageFormat.format(Bundle.getMessage("buildCanNotDropRsUsingTrain4"), car.getFinalDestinationTrack().getName(), TrainBuilderBase.formatStringToCommaSeparated(Setup.getDirectionStrings(car.getFinalDestinationTrack().getTrainDirections())), car.getFinalDestinationTrack().getAlternateTrack().getName(), TrainBuilderBase.formatStringToCommaSeparated(Setup.getDirectionStrings(car.getFinalDestinationTrack().getAlternateTrack().getTrainDirections()))));
            return false;
        }
        if ((rld.getTrainDirection() & serviceTrainDir) != 0) {
            return true;
        }
        if (rs == null || track == null) {
            TrainBuilderBase.addLine(this._buildReport, SEVEN, MessageFormat.format(Bundle.getMessage("buildDestinationDoesNotService"), rld.getName(), rld.getTrainDirectionString()));
        } else {
            TrainBuilderBase.addLine(this._buildReport, SEVEN, MessageFormat.format(Bundle.getMessage("buildCanNotDropRsUsingTrain"), rs.toString(), rld.getTrainDirectionString(), track.getName()));
        }
        return false;
    }

    protected boolean checkDropTrainDirection(RouteLocation rld) {
        return this.checkDropTrainDirection(null, rld, null);
    }

    protected boolean checkTrainCanDrop(Car car, Track track) {
        if (track.isInterchange() || track.isSpur()) {
            if (track.getDropOption().equals("trains") || track.getDropOption().equals("excludeTrains")) {
                if (track.isDropTrainAccepted(this._train)) {
                    log.debug("Car ({}) can be droped by train to track ({})", (Object)car.toString(), (Object)track.getName());
                } else {
                    TrainBuilderBase.addLine(this._buildReport, SEVEN, MessageFormat.format(Bundle.getMessage("buildCanNotDropCarTrain"), car.toString(), this._train.getName(), track.getTrackTypeName(), track.getName()));
                    return false;
                }
            }
            if (track.getDropOption().equals("routes") || track.getDropOption().equals("excludeRoutes")) {
                if (track.isDropRouteAccepted(this._train.getRoute())) {
                    log.debug("Car ({}) can be droped by route to track ({})", (Object)car.toString(), (Object)track.getName());
                } else {
                    TrainBuilderBase.addLine(this._buildReport, SEVEN, MessageFormat.format(Bundle.getMessage("buildCanNotDropCarRoute"), car.toString(), this._train.getRoute().getName(), track.getTrackTypeName(), track.getName()));
                    return false;
                }
            }
        }
        return true;
    }

    protected boolean checkDepartureStagingTrack(Track departStageTrack) {
        if (!departStageTrack.isPickupTrainAccepted(this._train)) {
            TrainBuilderBase.addLine(this._buildReport, THREE, MessageFormat.format(Bundle.getMessage("buildStagingNotTrain"), departStageTrack.getName()));
            return false;
        }
        if (departStageTrack.getNumberRS() == 0 && this._train.getTrainDepartsRouteLocation().getMaxCarMoves() > 0) {
            TrainBuilderBase.addLine(this._buildReport, THREE, MessageFormat.format(Bundle.getMessage("buildStagingEmpty"), departStageTrack.getName()));
            return false;
        }
        if (departStageTrack.getUsedLength() > this._train.getTrainDepartsRouteLocation().getMaxTrainLength()) {
            TrainBuilderBase.addLine(this._buildReport, THREE, MessageFormat.format(Bundle.getMessage("buildStagingTrainTooLong"), departStageTrack.getName(), departStageTrack.getUsedLength(), Setup.getLengthUnit().toLowerCase(), this._train.getTrainDepartsRouteLocation().getMaxTrainLength()));
            return false;
        }
        if (departStageTrack.getNumberCars() > this._train.getTrainDepartsRouteLocation().getMaxCarMoves()) {
            TrainBuilderBase.addLine(this._buildReport, THREE, MessageFormat.format(Bundle.getMessage("buildStagingTooManyCars"), departStageTrack.getName(), departStageTrack.getNumberCars(), this._train.getTrainDepartsRouteLocation().getMaxCarMoves()));
            return false;
        }
        if (!this._train.getNumberEngines().equals("0") && this.getNumberEngines(this._train.getNumberEngines()) != departStageTrack.getNumberEngines()) {
            TrainBuilderBase.addLine(this._buildReport, THREE, MessageFormat.format(Bundle.getMessage("buildStagingNotEngines"), departStageTrack.getName(), departStageTrack.getNumberEngines(), this._train.getNumberEngines()));
            return false;
        }
        if ((departStageTrack.getTrainDirections() & this._train.getTrainDepartsRouteLocation().getTrainDirection()) == 0) {
            TrainBuilderBase.addLine(this._buildReport, THREE, MessageFormat.format(Bundle.getMessage("buildStagingNotDirection"), departStageTrack.getName()));
            return false;
        }
        if (departStageTrack.getNumberEngines() > 0) {
            for (Engine eng : this.engineManager.getList()) {
                if (eng.getTrack() != departStageTrack) continue;
                if (eng.getRouteLocation() != null) {
                    TrainBuilderBase.addLine(this._buildReport, THREE, MessageFormat.format(Bundle.getMessage("buildStagingDepart"), departStageTrack.getName(), eng.getTrainName()));
                    return false;
                }
                if (eng.getTrain() != null && eng.getTrain() != this._train) {
                    TrainBuilderBase.addLine(this._buildReport, THREE, MessageFormat.format(Bundle.getMessage("buildStagingDepartEngineTrain"), departStageTrack.getName(), eng.toString(), eng.getTrainName()));
                    return false;
                }
                if (!this._train.isTypeNameAccepted(eng.getTypeName())) {
                    TrainBuilderBase.addLine(this._buildReport, THREE, MessageFormat.format(Bundle.getMessage("buildStagingDepartEngineType"), departStageTrack.getName(), eng.toString(), eng.getTypeName(), this._train.getName()));
                    return false;
                }
                if (!this._train.getEngineModel().equals("") && !this._train.getEngineModel().equals(eng.getModel())) {
                    TrainBuilderBase.addLine(this._buildReport, THREE, MessageFormat.format(Bundle.getMessage("buildStagingDepartEngineModel"), departStageTrack.getName(), eng.toString(), eng.getModel(), this._train.getName()));
                    return false;
                }
                if (!(this._train.getRoadOption().equals(Train.ALL_LOADS) || this._train.getEngineRoad().equals("") || this._train.getEngineRoad().equals(eng.getRoadName()))) {
                    TrainBuilderBase.addLine(this._buildReport, THREE, MessageFormat.format(Bundle.getMessage("buildStagingDepartEngineRoad"), departStageTrack.getName(), eng.toString(), eng.getRoadName(), this._train.getName()));
                    return false;
                }
                if (this._train.getEngineRoad().equals("") && !this._train.isRoadNameAccepted(eng.getRoadName())) {
                    TrainBuilderBase.addLine(this._buildReport, THREE, MessageFormat.format(Bundle.getMessage("buildStagingDepartEngineRoad"), departStageTrack.getName(), eng.toString(), eng.getRoadName(), this._train.getName()));
                    return false;
                }
                if (!this._train.isOwnerNameAccepted(eng.getOwner())) {
                    TrainBuilderBase.addLine(this._buildReport, THREE, MessageFormat.format(Bundle.getMessage("buildStagingDepartEngineOwner"), departStageTrack.getName(), eng.toString(), eng.getOwner(), this._train.getName()));
                    return false;
                }
                if (this._train.isBuiltDateAccepted(eng.getBuilt())) continue;
                TrainBuilderBase.addLine(this._buildReport, THREE, MessageFormat.format(Bundle.getMessage("buildStagingDepartEngineBuilt"), departStageTrack.getName(), eng.toString(), eng.getBuilt(), this._train.getName()));
                return false;
            }
        }
        boolean foundCaboose = false;
        boolean foundFRED = false;
        if (departStageTrack.getNumberCars() > 0) {
            for (Car car : this.carManager.getList()) {
                if (car.getTrack() != departStageTrack || car.getKernel() != null && !car.isLead()) continue;
                if (car.getRouteLocation() != null) {
                    log.debug("Car ({}) has route location ({})", (Object)car.toString(), (Object)car.getRouteLocation().getName());
                    TrainBuilderBase.addLine(this._buildReport, THREE, MessageFormat.format(Bundle.getMessage("buildStagingDepart"), departStageTrack.getName(), car.getTrainName()));
                    return false;
                }
                if (car.getTrain() != null && car.getTrain() != this._train) {
                    TrainBuilderBase.addLine(this._buildReport, THREE, MessageFormat.format(Bundle.getMessage("buildStagingDepartCarTrain"), departStageTrack.getName(), car.toString(), car.getTrainName()));
                    return false;
                }
                if (!this._train.isTypeNameAccepted(car.getTypeName())) {
                    TrainBuilderBase.addLine(this._buildReport, THREE, MessageFormat.format(Bundle.getMessage("buildStagingDepartCarType"), departStageTrack.getName(), car.toString(), car.getTypeName(), this._train.getName()));
                    return false;
                }
                if (!this._train.isRoadNameAccepted(car.getRoadName())) {
                    TrainBuilderBase.addLine(this._buildReport, THREE, MessageFormat.format(Bundle.getMessage("buildStagingDepartCarRoad"), departStageTrack.getName(), car.toString(), car.getRoadName(), this._train.getName()));
                    return false;
                }
                if (!(car.isCaboose() || car.isPassenger() || car.getLoadName().equals(this.carLoads.getDefaultEmptyName()) && (departStageTrack.isAddCustomLoadsEnabled() || departStageTrack.isAddCustomLoadsAnySpurEnabled() || departStageTrack.isAddCustomLoadsAnyStagingTrackEnabled()) || this._train.isLoadNameAccepted(car.getLoadName(), car.getTypeName()))) {
                    TrainBuilderBase.addLine(this._buildReport, THREE, MessageFormat.format(Bundle.getMessage("buildStagingDepartCarLoad"), departStageTrack.getName(), car.toString(), car.getLoadName(), this._train.getName()));
                    return false;
                }
                if (!this._train.isOwnerNameAccepted(car.getOwner())) {
                    TrainBuilderBase.addLine(this._buildReport, THREE, MessageFormat.format(Bundle.getMessage("buildStagingDepartCarOwner"), departStageTrack.getName(), car.toString(), car.getOwner(), this._train.getName()));
                    return false;
                }
                if (!this._train.isBuiltDateAccepted(car.getBuilt())) {
                    TrainBuilderBase.addLine(this._buildReport, THREE, MessageFormat.format(Bundle.getMessage("buildStagingDepartCarBuilt"), departStageTrack.getName(), car.toString(), car.getBuilt(), this._train.getName()));
                    return false;
                }
                if (car.getDestination() != null) {
                    log.debug("Car ({}) has a destination ({}, {})", new Object[]{car.toString(), car.getDestinationName(), car.getDestinationTrackName()});
                    if (!this._train.isServiceable(car)) {
                        TrainBuilderBase.addLine(this._buildReport, THREE, MessageFormat.format(Bundle.getMessage("buildStagingDepartCarDestination"), departStageTrack.getName(), car.toString(), car.getDestinationName(), this._train.getName()));
                        return false;
                    }
                }
                if (car.isCaboose() && (this._train.getCabooseRoad().equals("") || this._train.getCabooseRoad().equals(car.getRoadName()))) {
                    foundCaboose = true;
                }
                if (!car.hasFred() || !this._train.getCabooseRoad().equals("") && !this._train.getCabooseRoad().equals(car.getRoadName())) continue;
                foundFRED = true;
            }
        }
        if (this._train.isCabooseNeeded() && !foundCaboose) {
            TrainBuilderBase.addLine(this._buildReport, THREE, MessageFormat.format(Bundle.getMessage("buildStagingNoCaboose"), departStageTrack.getName(), this._train.getCabooseRoad()));
            return false;
        }
        if (this._train.isFredNeeded() && !foundFRED) {
            TrainBuilderBase.addLine(this._buildReport, THREE, MessageFormat.format(Bundle.getMessage("buildStagingNoCarFRED"), departStageTrack.getName(), this._train.getCabooseRoad()));
            return false;
        }
        TrainBuilderBase.addLine(this._buildReport, SEVEN, MessageFormat.format(Bundle.getMessage("buildTrainCanDepartTrack"), this._train.getName(), departStageTrack.getName()));
        return true;
    }

    protected boolean checkTerminateStagingTrack(Track terminateStageTrack) {
        if (!terminateStageTrack.isDropTrainAccepted(this._train)) {
            TrainBuilderBase.addLine(this._buildReport, FIVE, MessageFormat.format(Bundle.getMessage("buildStagingNotTrain"), terminateStageTrack.getName()));
            return false;
        }
        if ((!Setup.isBuildAggressive() || !Setup.isStagingTrackImmediatelyAvail()) && terminateStageTrack.getNumberRS() != 0 || terminateStageTrack.getNumberRS() != terminateStageTrack.getPickupRS()) {
            TrainBuilderBase.addLine(this._buildReport, FIVE, MessageFormat.format(Bundle.getMessage("buildStagingTrackOccupied"), terminateStageTrack.getName(), terminateStageTrack.getNumberEngines(), terminateStageTrack.getNumberCars()));
            return false;
        }
        if (terminateStageTrack.getDropRS() != 0) {
            TrainBuilderBase.addLine(this._buildReport, FIVE, MessageFormat.format(Bundle.getMessage("buildStagingTrackReserved"), terminateStageTrack.getName(), terminateStageTrack.getDropRS()));
            return false;
        }
        if (terminateStageTrack.getPickupRS() > 0) {
            TrainBuilderBase.addLine(this._buildReport, FIVE, MessageFormat.format(Bundle.getMessage("buildStagingTrackDepart"), terminateStageTrack.getName()));
        }
        if (terminateStageTrack.getDropOption().equals("trains") || terminateStageTrack.getDropOption().equals("routes")) {
            TrainBuilderBase.addLine(this._buildReport, SEVEN, MessageFormat.format(Bundle.getMessage("buildTrainCanTerminateTrack"), this._train.getName(), terminateStageTrack.getName()));
            return true;
        }
        if (!Setup.isStagingTrainCheckEnabled()) {
            TrainBuilderBase.addLine(this._buildReport, SEVEN, MessageFormat.format(Bundle.getMessage("buildTrainCanTerminateTrack"), this._train.getName(), terminateStageTrack.getName()));
            return true;
        }
        if (!this.checkTerminateStagingTrackRestrictions(terminateStageTrack)) {
            TrainBuilderBase.addLine(this._buildReport, SEVEN, MessageFormat.format(Bundle.getMessage("buildStagingTrackRestriction"), terminateStageTrack.getName(), this._train.getName()));
            TrainBuilderBase.addLine(this._buildReport, SEVEN, Bundle.getMessage("buildOptionRestrictStaging"));
            return false;
        }
        return true;
    }

    private boolean checkTerminateStagingTrackRestrictions(Track terminateStageTrack) {
        String[] stringArray = this._train.getTypeNames();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            if (!this._terminateLocation.acceptsTypeName(name)) {
                TrainBuilderBase.addLine(this._buildReport, FIVE, MessageFormat.format(Bundle.getMessage("buildDestinationType"), this._terminateLocation.getName(), name));
                return false;
            }
            if (!terminateStageTrack.isTypeNameAccepted(name)) {
                TrainBuilderBase.addLine(this._buildReport, FIVE, MessageFormat.format(Bundle.getMessage("buildStagingTrackType"), terminateStageTrack.getName(), name));
                return false;
            }
            ++n2;
        }
        if (this._train.getRoadOption().equals(Train.ALL_ROADS) && !terminateStageTrack.getRoadOption().equals(Track.ALL_ROADS)) {
            TrainBuilderBase.addLine(this._buildReport, FIVE, MessageFormat.format(Bundle.getMessage("buildStagingTrackAllRoads"), terminateStageTrack.getName()));
            return false;
        }
        stringArray = InstanceManager.getDefault(CarRoads.class).getNames();
        n = stringArray.length;
        n2 = 0;
        while (n2 < n) {
            String road = stringArray[n2];
            if (this._train.isRoadNameAccepted(road) && !terminateStageTrack.isRoadNameAccepted(road)) {
                TrainBuilderBase.addLine(this._buildReport, FIVE, MessageFormat.format(Bundle.getMessage("buildStagingTrackRoad"), terminateStageTrack.getName(), road));
                return false;
            }
            ++n2;
        }
        if (this._train.getLoadOption().equals(Train.ALL_LOADS) && !terminateStageTrack.getLoadOption().equals(Track.ALL_LOADS)) {
            TrainBuilderBase.addLine(this._buildReport, FIVE, MessageFormat.format(Bundle.getMessage("buildStagingTrackAllLoads"), terminateStageTrack.getName()));
            return false;
        }
        stringArray = this._train.getTypeNames();
        n = stringArray.length;
        n2 = 0;
        while (n2 < n) {
            String type = stringArray[n2];
            for (String load : this.carLoads.getNames(type)) {
                if (!this._train.isLoadNameAccepted(load, type) || terminateStageTrack.isLoadNameAndCarTypeAccepted(load, type)) continue;
                TrainBuilderBase.addLine(this._buildReport, FIVE, MessageFormat.format(Bundle.getMessage("buildStagingTrackLoad"), terminateStageTrack.getName(), String.valueOf(type) + " & " + load));
                return false;
            }
            ++n2;
        }
        TrainBuilderBase.addLine(this._buildReport, SEVEN, MessageFormat.format(Bundle.getMessage("buildTrainCanTerminateTrack"), this._train.getName(), terminateStageTrack.getName()));
        return true;
    }

    protected boolean checkBasicMoves(Car car, Track track) {
        if (car.getTrack() == track) {
            return false;
        }
        if (TrainBuilderBase.splitString(car.getLocationName()).equals(TrainBuilderBase.splitString(track.getLocation().getName())) && TrainBuilderBase.splitString(car.getTrackName()).equals(TrainBuilderBase.splitString(track.getName()))) {
            return false;
        }
        if (track.isStaging() && car.getLocation() == track.getLocation()) {
            return false;
        }
        if (!this.checkThroughCarsAllowed(car, track.getLocation().getName())) {
            return false;
        }
        return this.checkLocalMovesAllowed(car, track);
    }

    protected ScheduleItem getScheduleItem(Car car, Track track) throws BuildFailedException {
        if (track.getSchedule() == null) {
            return null;
        }
        if (!track.isTypeNameAccepted(car.getTypeName())) {
            log.debug("Track ({}) doesn't service car type ({})", (Object)track.getName(), (Object)car.getTypeName());
            if (!Setup.getRouterBuildReportLevel().equals(THREE)) {
                TrainBuilderBase.addLine(this._buildReport, SEVEN, MessageFormat.format(Bundle.getMessage("buildSpurNotThisType"), track.getLocation().getName(), track.getName(), track.getScheduleName(), car.getTypeName()));
            }
            return null;
        }
        ScheduleItem si = null;
        if (track.getScheduleMode() == 0) {
            si = track.getCurrentScheduleItem();
            if (si == null) {
                throw new BuildFailedException(MessageFormat.format(Bundle.getMessage("buildErrorNoScheduleItem"), track.getScheduleItemId(), track.getScheduleName(), track.getName(), track.getLocation().getName()));
            }
            return this.checkScheduleItem(si, car, track);
        }
        log.debug("Track ({}) in match mode", (Object)track.getName());
        int i = 0;
        while (i < track.getSchedule().getSize()) {
            si = track.getNextScheduleItem();
            if (si == null) {
                throw new BuildFailedException(MessageFormat.format(Bundle.getMessage("buildErrorNoScheduleItem"), track.getScheduleItemId(), track.getScheduleName(), track.getName(), track.getLocation().getName()));
            }
            if ((si = this.checkScheduleItem(si, car, track)) != null) break;
            ++i;
        }
        return si;
    }

    private ScheduleItem checkScheduleItem(ScheduleItem si, Car car, Track track) {
        if (!car.getTypeName().equals(si.getTypeName()) || si.getReceiveLoadName().equals("") || si.getReceiveLoadName().equals(this.carLoads.getDefaultEmptyName()) || si.getReceiveLoadName().equals(this.carLoads.getDefaultLoadName())) {
            log.debug("Not using track ({}) schedule request type ({}) road ({}) load ({})", new Object[]{track.getName(), si.getTypeName(), si.getRoadName(), si.getReceiveLoadName()});
            if (!Setup.getRouterBuildReportLevel().equals(THREE)) {
                TrainBuilderBase.addLine(this._buildReport, SEVEN, MessageFormat.format(Bundle.getMessage("buildSpurScheduleNotUsed"), track.getLocation().getName(), track.getName(), track.getScheduleName(), si.getId(), track.getScheduleModeName().toLowerCase(), si.getTypeName(), si.getRoadName(), si.getReceiveLoadName()));
            }
            return null;
        }
        if (!si.getRoadName().equals("") && !car.getRoadName().equals(si.getRoadName())) {
            log.debug("Not using track ({}) schedule request type ({}) road ({}) load ({})", new Object[]{track.getName(), si.getTypeName(), si.getRoadName(), si.getReceiveLoadName()});
            if (!Setup.getRouterBuildReportLevel().equals(THREE)) {
                TrainBuilderBase.addLine(this._buildReport, SEVEN, MessageFormat.format(Bundle.getMessage("buildSpurScheduleNotUsed"), track.getLocation().getName(), track.getName(), track.getScheduleName(), si.getId(), track.getScheduleModeName().toLowerCase(), si.getTypeName(), si.getRoadName(), si.getReceiveLoadName()));
            }
            return null;
        }
        if (!this._train.isLoadNameAccepted(si.getReceiveLoadName(), si.getTypeName())) {
            TrainBuilderBase.addLine(this._buildReport, SEVEN, MessageFormat.format(Bundle.getMessage("buildTrainNotNewLoad"), this._train.getName(), si.getReceiveLoadName(), track.getLocation().getName(), track.getName()));
            return null;
        }
        if (!car.getTrack().isLoadNameAndCarTypeShipped(si.getReceiveLoadName(), car.getTypeName())) {
            TrainBuilderBase.addLine(this._buildReport, SEVEN, MessageFormat.format(Bundle.getMessage("buildTrackNotLoadSchedule"), car.getTrackName(), si.getReceiveLoadName(), track.getLocation().getName(), track.getName(), si.getId()));
            return null;
        }
        if (!si.getSetoutTrainScheduleId().equals("") && !this.trainScheduleManager.getTrainScheduleActiveId().equals(si.getSetoutTrainScheduleId())) {
            log.debug("Schedule item isn't active");
            TrainSchedule aSch = this.trainScheduleManager.getScheduleById(this.trainScheduleManager.getTrainScheduleActiveId());
            TrainSchedule tSch = this.trainScheduleManager.getScheduleById(si.getSetoutTrainScheduleId());
            String aName = "";
            String tName = "";
            if (aSch != null) {
                aName = aSch.getName();
            }
            if (tSch != null) {
                tName = tSch.getName();
            }
            TrainBuilderBase.addLine(this._buildReport, SEVEN, MessageFormat.format(Bundle.getMessage("buildScheduleNotActive"), track.getName(), si.getId(), tName, aName));
            return null;
        }
        if (!si.getRandom().equals("")) {
            try {
                int value = Integer.parseInt(si.getRandom());
                double random = 100.0 * Math.random();
                log.debug("Selected random {}, created random {}", (Object)si.getRandom(), (Object)random);
                if (random > (double)value) {
                    TrainBuilderBase.addLine(this._buildReport, SEVEN, MessageFormat.format(Bundle.getMessage("buildScheduleRandom"), track.getLocation().getName(), track.getName(), track.getScheduleName(), si.getId(), si.getReceiveLoadName(), value, random));
                    return null;
                }
            }
            catch (NumberFormatException numberFormatException) {
                log.error("Schedule item ({}) random value ({}) isn't a number", (Object)si.getId(), (Object)si.getRandom());
            }
        }
        log.debug("Found track ({}) schedule item id ({}) for car ({})", new Object[]{track.getName(), si.getId(), car.toString()});
        car.setScheduleItemId(si.getId());
        return si;
    }

    protected void showCarServiceOrder(Car car) {
        if (!car.getTrack().getServiceOrder().equals(Track.NORMAL)) {
            TrainBuilderBase.addLine(this._buildReport, SEVEN, MessageFormat.format(Bundle.getMessage("buildTrackModePriority"), car.toString(), car.getTrack().getTrackType(), car.getTrackName(), car.getTrack().getServiceOrder(), car.getLastDate()));
        }
    }

    protected List<Track> findTrackAtDestination(Car car, RouteLocation rld) {
        ArrayList<Track> tracks = new ArrayList<Track>();
        Location testDestination = rld.getLocation();
        for (Track track : testDestination.getTracksByNameList(null)) {
            if (!track.isAlternate()) continue;
            TrainBuilderBase.addLine(this._buildReport, SEVEN, MessageFormat.format(Bundle.getMessage("buildTrackIsAlternate"), car.toString(), track.getTrackTypeName(), track.getName()));
        }
        for (Track testTrack : testDestination.getTracksByMovesList(null)) {
            String status;
            if (TrainBuilderBase.splitString(car.getLocationName()).equals(TrainBuilderBase.splitString(testTrack.getLocation().getName())) && TrainBuilderBase.splitString(car.getTrackName()).equals(TrainBuilderBase.splitString(testTrack.getName())) && !car.isPassenger() && !car.isCaboose() && !car.hasFred()) {
                TrainBuilderBase.addLine(this._buildReport, SEVEN, MessageFormat.format(Bundle.getMessage("buildCanNotDropCarSameTrack"), car.toString(), testTrack.getName()));
                continue;
            }
            if (!this.checkDropTrainDirection(car, rld, testTrack) || !this.checkTrainCanDrop(car, testTrack)) continue;
            if (testTrack.getIgnoreUsedLengthPercentage() > 0) {
                TrainBuilderBase.addLine(this._buildReport, SEVEN, MessageFormat.format(Bundle.getMessage("buildTrackHasPlannedPickups"), testTrack.getName(), testTrack.getIgnoreUsedLengthPercentage(), testTrack.getLength(), Setup.getLengthUnit().toLowerCase(), testTrack.getUsedLength(), testTrack.getReserved(), testTrack.getReservedLengthDrops(), testTrack.getReservedLengthDrops() - testTrack.getReserved(), testTrack.getAvailableTrackSpace()));
            }
            if ((status = car.testDestination(testDestination, testTrack)).equals(Track.OKAY) && !testTrack.getScheduleId().equals("") && !car.getLoadName().equals(this.carLoads.getDefaultEmptyName()) && !car.getLoadName().equals(this.carLoads.getDefaultLoadName())) {
                TrainBuilderBase.addLine(this._buildReport, FIVE, MessageFormat.format(Bundle.getMessage("buildSpurScheduleLoad"), testTrack.getName(), car.getLoadName()));
            }
            if (status.startsWith(Track.LENGTH) && testTrack.getAlternateTrack() != null && car.getFinalDestination() == null && car.getTrack() != testTrack.getAlternateTrack() && this.checkTrainCanDrop(car, testTrack.getAlternateTrack())) {
                TrainBuilderBase.addLine(this._buildReport, SEVEN, MessageFormat.format(Bundle.getMessage("buildTrackFullHasAlternate"), testDestination.getName(), testTrack.getName(), testTrack.getAlternateTrack().getName()));
                status = car.testDestination(testDestination, testTrack.getAlternateTrack());
                if (!status.equals(Track.OKAY)) {
                    TrainBuilderBase.addLine(this._buildReport, SEVEN, MessageFormat.format(Bundle.getMessage("buildCanNotDropCarBecause"), car.toString(), testTrack.getAlternateTrack().getName(), status, testTrack.getAlternateTrack().getTrackTypeName()));
                    continue;
                }
                tracks.add(testTrack.getAlternateTrack());
                tracks.add(testTrack);
                break;
            }
            if (!status.equals(Track.OKAY)) {
                TrainBuilderBase.addLine(this._buildReport, SEVEN, MessageFormat.format(Bundle.getMessage("buildCanNotDropCarBecause"), car.toString(), testTrack.getName(), status, testTrack.getTrackTypeName()));
                continue;
            }
            if (!this.checkForLocalMove(car, testTrack)) continue;
            tracks.add(testTrack);
            tracks.add(null);
            break;
        }
        return tracks;
    }

    protected RouteLocation checkForEarlierDrop(Car car, Track trackTemp, RouteLocation rld, int start, int routeEnd) {
        int m = start;
        while (m < routeEnd) {
            RouteLocation rle = this._routeList.get(m);
            if (rle == rld) break;
            if (rle.getName().equals(rld.getName()) && rle.getCarMoves() < rle.getMaxCarMoves() && rle.isDropAllowed() && this.checkDropTrainDirection(car, rle, trackTemp)) {
                log.debug("Found an earlier drop for car ({}) destination ({})", (Object)car.toString(), (Object)rle.getName());
                return rle;
            }
            ++m;
        }
        return rld;
    }

    private boolean checkForLocalMove(Car car, Track testTrack) {
        if (this._train.isLocalSwitcher()) {
            if (!Setup.isLocalSpurMovesEnabled() && testTrack.isSpur() && car.getTrack().isSpur()) {
                TrainBuilderBase.addLine(this._buildReport, SEVEN, MessageFormat.format(Bundle.getMessage("buildNoSpurToSpurMove"), car.getTrackName(), testTrack.getName()));
                return false;
            }
            if (!Setup.isLocalYardMovesEnabled() && testTrack.isYard() && car.getTrack().isYard() && !car.isCaboose() && !car.hasFred()) {
                TrainBuilderBase.addLine(this._buildReport, SEVEN, MessageFormat.format(Bundle.getMessage("buildNoYardToYardMove"), car.getTrackName(), testTrack.getName()));
                return false;
            }
            if (!Setup.isLocalInterchangeMovesEnabled() && testTrack.isInterchange() && car.getTrack().isInterchange()) {
                TrainBuilderBase.addLine(this._buildReport, SEVEN, MessageFormat.format(Bundle.getMessage("buildNoInterchangeToInterchangeMove"), car.getTrackName(), testTrack.getName()));
                return false;
            }
        }
        return true;
    }

    protected Track tryStaging(Car car, RouteLocation rldSave) throws BuildFailedException {
        if (this._train.isLocalSwitcher() && !car.isPassenger() && !car.isCaboose() && !car.hasFred() && car.getTrack() == this._terminateStageTrack) {
            TrainBuilderBase.addLine(this._buildReport, SEVEN, MessageFormat.format(Bundle.getMessage("buildCanNotDropCarSameTrack"), car.toString(), car.getTrack().getName()));
            return null;
        }
        String status = car.testDestination(this._terminateStageTrack.getLocation(), this._terminateStageTrack);
        if (status.equals(Track.OKAY)) {
            return this._terminateStageTrack;
        }
        if (status.startsWith(Track.LOAD) && car.getTrack() == this._departStageTrack && car.getLoadName().equals(this.carLoads.getDefaultEmptyName()) && rldSave == null && (this._departStageTrack.isAddCustomLoadsAnyStagingTrackEnabled() || this._departStageTrack.isAddCustomLoadsEnabled() || this._departStageTrack.isAddCustomLoadsAnySpurEnabled()) && this.generateLoadCarDepartingAndTerminatingIntoStaging(car, this._terminateStageTrack)) {
            return this._terminateStageTrack;
        }
        TrainBuilderBase.addLine(this._buildReport, SEVEN, MessageFormat.format(Bundle.getMessage("buildCanNotDropCarBecause"), car.toString(), this._terminateStageTrack.getName(), status, this._terminateStageTrack.getTrackTypeName()));
        return null;
    }

    protected boolean checkForLaterPickUp(Car car, RouteLocation rl, RouteLocation rld) throws BuildFailedException {
        if (rl != rld && rld.getName().equals(car.getLocationName())) {
            if (car.isCaboose() || car.isPassenger() || car.hasFred()) {
                return false;
            }
            if (car.getLocation().isStaging()) {
                return false;
            }
            if (!this.checkPickUpTrainDirection(car, rld)) {
                TrainBuilderBase.addLine(this._buildReport, SEVEN, MessageFormat.format(Bundle.getMessage("buildNoPickupLaterDirection"), car.toString(), rld.getName(), rld.getId()));
                return false;
            }
            if (!rld.isPickUpAllowed()) {
                TrainBuilderBase.addLine(this._buildReport, SEVEN, MessageFormat.format(Bundle.getMessage("buildNoPickupLater"), car.toString(), rld.getName(), rld.getId()));
                return false;
            }
            if (rld.getCarMoves() >= rld.getMaxCarMoves()) {
                TrainBuilderBase.addLine(this._buildReport, SEVEN, MessageFormat.format(Bundle.getMessage("buildNoPickupLaterMoves"), car.toString(), rld.getName(), rld.getId()));
                return false;
            }
            TrainBuilderBase.addLine(this._buildReport, SEVEN, MessageFormat.format(Bundle.getMessage("buildPickupLaterOkay"), car.toString(), rld.getName(), rld.getId()));
            return true;
        }
        return false;
    }

    protected boolean checkThroughCarsAllowed(Car car, String destinationName) {
        if (!(this._train.isAllowThroughCarsEnabled() || this._train.isLocalSwitcher() || car.isCaboose() || car.hasFred() || car.isPassenger() || !TrainBuilderBase.splitString(car.getLocationName()).equals(TrainBuilderBase.splitString(this._departLocation.getName())) || !TrainBuilderBase.splitString(destinationName).equals(TrainBuilderBase.splitString(this._terminateLocation.getName())) || TrainBuilderBase.splitString(this._departLocation.getName()).equals(TrainBuilderBase.splitString(this._terminateLocation.getName())))) {
            TrainBuilderBase.addLine(this._buildReport, FIVE, MessageFormat.format(Bundle.getMessage("buildThroughTrafficNotAllow"), this._departLocation.getName(), this._terminateLocation.getName()));
            TrainBuilderBase.addLine(this._buildReport, FIVE, " ");
            return false;
        }
        return true;
    }

    private boolean checkLocalMovesAllowed(Car car, Track track) {
        if (!this._train.isAllowLocalMovesEnabled() && TrainBuilderBase.splitString(car.getLocationName()).equals(TrainBuilderBase.splitString(track.getLocation().getName()))) {
            TrainBuilderBase.addLine(this._buildReport, SEVEN, MessageFormat.format(Bundle.getMessage("buildNoLocalMoveToTrack"), car.getLocationName(), car.getTrackName(), track.getLocation().getName(), track.getName(), this._train.getName()));
            return false;
        }
        return true;
    }

    /*
     * Unable to fully structure code
     */
    protected boolean generateLoadCarDepartingAndTerminatingIntoStaging(Car car, Track stageTrack) throws BuildFailedException {
        if (stageTrack == null || !stageTrack.isStaging()) {
            throw new BuildFailedException("ERROR coding issue, staging track null or not staging");
        }
        if (!stageTrack.isTypeNameAccepted(car.getTypeName())) {
            TrainBuilderBase.addLine(this._buildReport, "7", MessageFormat.format(Bundle.getMessage("buildStagingTrackType"), new Object[]{stageTrack.getName(), car.getTypeName()}));
            return false;
        }
        if (!stageTrack.isRoadNameAccepted(car.getRoadName())) {
            TrainBuilderBase.addLine(this._buildReport, "7", MessageFormat.format(Bundle.getMessage("buildStagingTrackRoad"), new Object[]{stageTrack.getName(), car.getTypeName()}));
            return false;
        }
        if (!(this._train.isAllowReturnToStagingEnabled() || Setup.isStagingAllowReturnEnabled() || car.isCaboose() || car.hasFred() || car.isPassenger() || !TrainBuilderBase.splitString(car.getLocationName()).equals(TrainBuilderBase.splitString(stageTrack.getLocation().getName())))) {
            TrainBuilderBase.addLine(this._buildReport, "7", MessageFormat.format(Bundle.getMessage("buildNoReturnStaging"), new Object[]{car.toString(), stageTrack.getLocation().getName()}));
            return false;
        }
        loads = this.carLoads.getNames(car.getTypeName());
        loads.remove(this.carLoads.getDefaultEmptyName());
        loads.remove(this.carLoads.getDefaultLoadName());
        if (loads.size() == 0) {
            TrainBuilderBase.log.debug("No custom loads for car type ({}) ignoring staging track ({})", (Object)car.getTypeName(), (Object)stageTrack.getName());
            return false;
        }
        TrainBuilderBase.addLine(this._buildReport, "7", " ");
        TrainBuilderBase.addLine(this._buildReport, "7", MessageFormat.format(Bundle.getMessage("buildSearchTrackLoadStaging"), new Object[]{car.toString(), car.getTypeName(), car.getLoadName(), car.getLocationName(), car.getTrackName(), stageTrack.getLocation().getName(), stageTrack.getName()}));
        oldLoad = car.getLoadName();
        i = loads.size() - 1;
        while (i >= 0) {
            block17: {
                block16: {
                    load = loads.get(i);
                    TrainBuilderBase.log.debug("Try custom load ({}) for car ({})", (Object)load, (Object)car.toString());
                    if (car.getTrack().isLoadNameAndCarTypeShipped(load, car.getTypeName()) && stageTrack.isLoadNameAndCarTypeAccepted(load, car.getTypeName()) && this._train.isLoadNameAccepted(load, car.getTypeName())) break block16;
                    if (!car.getTrack().isLoadNameAndCarTypeShipped(load, car.getTypeName())) {
                        TrainBuilderBase.addLine(this._buildReport, "7", MessageFormat.format(Bundle.getMessage("buildTrackNotNewLoad"), new Object[]{car.getTrackName(), load, stageTrack.getLocation().getName(), stageTrack.getName()}));
                    }
                    if (!stageTrack.isLoadNameAndCarTypeAccepted(load, car.getTypeName())) {
                        TrainBuilderBase.addLine(this._buildReport, "7", MessageFormat.format(Bundle.getMessage("BuildDestTrackNoLoad"), new Object[]{stageTrack.getLocation().getName(), stageTrack.getName(), car.toString(), load}));
                    }
                    if (!this._train.isLoadNameAccepted(load, car.getTypeName())) {
                        TrainBuilderBase.addLine(this._buildReport, "7", MessageFormat.format(Bundle.getMessage("buildTrainNotNewLoad"), new Object[]{this._train.getName(), load, stageTrack.getLocation().getName(), stageTrack.getName()}));
                    }
                    loads.remove(i);
                    break block17;
                }
                car.setLoadName(load);
                if (car.getDivision() == null) ** GOTO lbl-1000
                TrainBuilderBase.addLine(this._buildReport, "7", MessageFormat.format(Bundle.getMessage("buildCarHasDivisionStaging"), new Object[]{car.toString(), car.getTypeName(), car.getLoadType().toLowerCase(), car.getLoadName(), car.getDivisionName(), car.getLocationName(), car.getTrackName(), car.getTrack().getDivisionName()}));
                if (car.getLoadType().equals(CarLoad.LOAD_TYPE_EMPTY) && car.getDivision() != stageTrack.getDivision() || car.getLoadType().equals(CarLoad.LOAD_TYPE_LOAD) && car.getTrack().getDivision() != car.getDivision() && car.getDivision() != stageTrack.getDivision()) {
                    TrainBuilderBase.addLine(this._buildReport, "7", MessageFormat.format(Bundle.getMessage("buildNoDivisionTrack"), new Object[]{stageTrack.getTrackTypeName(), stageTrack.getLocation().getName(), stageTrack.getName(), stageTrack.getDivisionName(), car.toString(), car.getLoadType().toLowerCase(), car.getLoadName()}));
                    loads.remove(i);
                } else if (!this.router.isCarRouteable(car, this._train, stageTrack, this._buildReport)) {
                    loads.remove(i);
                    TrainBuilderBase.addLine(this._buildReport, "7", MessageFormat.format(Bundle.getMessage("buildStagingTrackNotReachable"), new Object[]{stageTrack.getLocation().getName(), stageTrack.getName(), load}));
                }
            }
            --i;
        }
        if (loads.size() > 0) {
            rnd = (int)(Math.random() * (double)loads.size());
            car.setLoadName(loads.get(rnd));
            status = car.testDestination(stageTrack.getLocation(), stageTrack);
            if (status.equals(Track.OKAY) || status.startsWith(Track.LENGTH) && stageTrack != this._terminateStageTrack) {
                car.setLoadGeneratedFromStaging(true);
                car.setFinalDestination(stageTrack.getLocation());
                if (stageTrack == this._terminateStageTrack) {
                    car.setFinalDestinationTrack(stageTrack);
                } else {
                    car.setFinalDestinationTrack(null);
                }
                car.updateKernel();
                TrainBuilderBase.addLine(this._buildReport, "7", MessageFormat.format(Bundle.getMessage("buildAddingScheduleLoad"), new Object[]{car.getLoadName(), car.toString()}));
                return true;
            }
            TrainBuilderBase.addLine(this._buildReport, "7", MessageFormat.format(Bundle.getMessage("buildCanNotDropCarBecause"), new Object[]{car.toString(), stageTrack.getName(), status, stageTrack.getTrackTypeName()}));
        }
        car.setLoadName(oldLoad);
        TrainBuilderBase.addLine(this._buildReport, "7", MessageFormat.format(Bundle.getMessage("buildUnableNewLoadStaging"), new Object[]{car.toString(), car.getTrackName(), stageTrack.getLocation().getName(), stageTrack.getName()}));
        return false;
    }

    protected boolean redirectCarsFromAlternateTrack() throws BuildFailedException {
        if (!Setup.isBuildAggressive()) {
            throw new BuildFailedException("ERROR coding issue, should be using aggressive mode");
        }
        boolean redirected = false;
        List cars = this.carManager.getByTrainList(this._train);
        for (Car car : cars) {
            Track alternate;
            if (car.getFinalDestination() == null || car.getFinalDestinationTrack() == null || !car.getFinalDestinationName().equals(car.getDestinationName())) continue;
            log.debug("Car ({}) destination track ({}) has final destination track ({}) location ({})", new Object[]{car.toString(), car.getDestinationTrackName(), car.getFinalDestinationTrackName(), car.getDestinationName()});
            if (car.getKernel() != null && !car.isLead() || !car.testDestination(car.getFinalDestination(), car.getFinalDestinationTrack()).equals(Track.OKAY) || (alternate = car.getFinalDestinationTrack().getAlternateTrack()) == null || car.getDestinationTrack() != alternate || !alternate.isYard() && !alternate.isInterchange() || !this.checkDropTrainDirection(car, car.getRouteDestination(), car.getFinalDestinationTrack()) || !this.checkTrainCanDrop(car, car.getFinalDestinationTrack())) continue;
            log.debug("Car ({}) alternate track ({}) can be redirected to final destination track ({})", new Object[]{car.toString(), car.getDestinationTrackName(), car.getFinalDestinationTrackName()});
            if (car.getKernel() != null) {
                for (Car k : car.getKernel().getCars()) {
                    if (k.isLead()) continue;
                    TrainBuilderBase.addLine(this._buildReport, FIVE, MessageFormat.format(Bundle.getMessage("buildRedirectFromAlternate"), car.getFinalDestinationName(), car.getFinalDestinationTrackName(), k.toString(), car.getDestinationTrackName()));
                    k.setDestination(car.getFinalDestination(), car.getFinalDestinationTrack(), true);
                }
            }
            TrainBuilderBase.addLine(this._buildReport, FIVE, MessageFormat.format(Bundle.getMessage("buildRedirectFromAlternate"), car.getFinalDestinationName(), car.getFinalDestinationTrackName(), car.toString(), car.getDestinationTrackName()));
            car.setDestination(car.getFinalDestination(), car.getFinalDestinationTrack(), true);
            redirected = true;
        }
        return redirected;
    }

    protected void reportCarsNotMoved(RouteLocation rl) {
        if (this._carIndex < 0) {
            this._carIndex = 0;
        }
        int numberCars = 0;
        int i = this._carIndex;
        while (i < this._carList.size()) {
            if (numberCars == 100) {
                TrainBuilderBase.addLine(this._buildReport, FIVE, MessageFormat.format(Bundle.getMessage("buildOnlyFirstXXXCars"), numberCars, rl.getName()));
                break;
            }
            Car car = this._carList.get(i);
            if (car.getLocationName().equals(rl.getName()) && car.getRouteDestination() == null) {
                if (numberCars == 0) {
                    TrainBuilderBase.addLine(this._buildReport, SEVEN, MessageFormat.format(Bundle.getMessage("buildMovesCompleted"), rl.getMaxCarMoves(), rl.getName()));
                }
                TrainBuilderBase.addLine(this._buildReport, SEVEN, MessageFormat.format(Bundle.getMessage("buildCarIgnored"), car.toString(), car.getTypeName(), car.getLoadName(), car.getLocationName(), car.getTrackName()));
                ++numberCars;
            }
            ++i;
        }
        TrainBuilderBase.addLine(this._buildReport, SEVEN, " ");
    }

    protected void findNewEngine(int hpNeeded, Engine leadEngine, String model, String road) throws BuildFailedException {
        RouteLocation rl = leadEngine.getRouteLocation();
        RouteLocation rld = leadEngine.getRouteDestination();
        this.removeEngineFromTrain(leadEngine);
        this._engineList.add(0, leadEngine);
        if (hpNeeded < 50) {
            hpNeeded = 50;
        }
        int hpMax = hpNeeded;
        boolean foundLoco = false;
        block0: while (hpMax < 20000) {
            log.debug("Max hp {}", (Object)(hpMax += hpNeeded / 2));
            for (Engine engine : this._engineList) {
                if (engine.getConsist() != null && !engine.isLead() || engine.getLocation() != rl.getLocation() || !model.equals("") && !engine.getModel().equals(model) || !road.equals("") && !engine.getRoadName().equals(road) || road.equals("") && !this._train.isRoadNameAccepted(engine.getRoadName())) continue;
                int engineHp = engine.getHpInteger();
                if (engine.getConsist() != null) {
                    for (Engine e : engine.getConsist().getEngines()) {
                        if (e == engine) continue;
                        engineHp += e.getHpInteger();
                    }
                }
                if (engineHp <= hpNeeded || engineHp > hpMax) continue;
                TrainBuilderBase.addLine(this._buildReport, FIVE, MessageFormat.format(Bundle.getMessage("buildLocoHasRequiredHp"), engine.toString(), engineHp, hpNeeded));
                if (!this.setLocoDestination(engine, rl, rld)) continue;
                foundLoco = true;
                break block0;
            }
        }
        if (!foundLoco && !this._train.isBuildConsistEnabled()) {
            throw new BuildFailedException(MessageFormat.format(Bundle.getMessage("buildErrorEngHp"), rl.getLocation().getName()));
        }
    }

    protected void removeEngineFromTrain(Engine engine) {
        if (this._train.getLeadEngine() == engine) {
            this._train.setLeadEngine(null);
        }
        if (engine.getConsist() != null) {
            for (Engine e : engine.getConsist().getEngines()) {
                this.removeRollingStockFromTrain(e);
            }
        } else {
            this.removeRollingStockFromTrain(engine);
        }
    }

    private void removeRollingStockFromTrain(RollingStock rs) {
        boolean inTrain = false;
        for (RouteLocation routeLocation : this._routeList) {
            if (rs.getRouteLocation() == routeLocation) {
                inTrain = true;
            }
            if (rs.getRouteDestination() == routeLocation) break;
            if (!inTrain) continue;
            routeLocation.setTrainLength(routeLocation.getTrainLength() - rs.getTotalLength());
            routeLocation.setTrainWeight(routeLocation.getTrainWeight() - rs.getAdjustedWeightTons());
        }
        rs.reset();
    }

    protected void addLocosBasedHPT(int hpAvailable, int extraHpNeeded, RouteLocation rlNeedHp, RouteLocation rl, RouteLocation rld) throws BuildFailedException {
        if (rlNeedHp == null) {
            return;
        }
        int numberLocos = 0;
        List engines = this.engineManager.getList(this._train);
        for (Engine rs : engines) {
            if (rs.getRouteLocation() != rl) continue;
            ++numberLocos;
        }
        TrainBuilderBase.addLine(this._buildReport, ONE, " ");
        TrainBuilderBase.addLine(this._buildReport, ONE, MessageFormat.format(Bundle.getMessage("buildTrainReqExtraHp"), extraHpNeeded, rlNeedHp.getName(), rld.getName(), numberLocos));
        String model = this._train.getEngineModel();
        String road = this._train.getEngineRoad();
        if ((this._train.getSecondLegOptions() & 1) == 1 && rl == this._train.getSecondLegStartRouteLocation()) {
            model = this._train.getSecondLegEngineModel();
            road = this._train.getSecondLegEngineRoad();
        } else if ((this._train.getThirdLegOptions() & 1) == 1 && rl == this._train.getThirdLegStartRouteLocation()) {
            model = this._train.getThirdLegEngineModel();
            road = this._train.getThirdLegEngineRoad();
        }
        while (numberLocos < Setup.getMaxNumberEngines()) {
            if (!this.getEngines(ONE, model, road, rl, rld, numberLocos > 0)) {
                throw new BuildFailedException(MessageFormat.format(Bundle.getMessage("buildErrorEngines"), Bundle.getMessage("additional"), rl.getName(), rld.getName()));
            }
            ++numberLocos;
            int currentHp = this._train.getTrainHorsePower(rlNeedHp);
            if (currentHp > hpAvailable + extraHpNeeded) break;
            if (numberLocos < Setup.getMaxNumberEngines()) {
                TrainBuilderBase.addLine(this._buildReport, FIVE, " ");
                TrainBuilderBase.addLine(this._buildReport, THREE, MessageFormat.format(Bundle.getMessage("buildContinueAddLocos"), hpAvailable + extraHpNeeded - currentHp, rlNeedHp.getName(), rld.getName(), numberLocos, currentHp));
                continue;
            }
            TrainBuilderBase.addLine(this._buildReport, FIVE, MessageFormat.format(Bundle.getMessage("buildMaxNumberLocoAssigned"), Setup.getMaxNumberEngines()));
        }
    }

    protected void showCarsNotRoutable() {
        if (this._notRoutable.size() > 0) {
            ++this._warnings;
            TrainBuilderBase.addLine(this._buildReport, ONE, " ");
            TrainBuilderBase.addLine(this._buildReport, ONE, Bundle.getMessage("buildCarsNotRoutable"));
            for (Car car : this._notRoutable) {
                TrainBuilderBase.addLine(this._buildReport, ONE, MessageFormat.format(Bundle.getMessage("buildCarNotRoutable"), car.toString(), car.getLocationName(), car.getTrackName(), car.getFinalDestinationName(), car.getFinalDestinationTrackName()));
            }
            TrainBuilderBase.addLine(this._buildReport, ONE, " ");
        }
    }

    protected void removeCarsFromStaging() {
        if (this._departStageTrack == null) {
            log.error("Error, called when cars in staging not assigned to train");
            return;
        }
        for (Car car : this._carList) {
            if (car.getTrack() != this._departStageTrack || car.getTrain() != null) continue;
            if (car.getKernel() != null) {
                for (Car c : car.getKernel().getCars()) {
                    c.setLocation(car.getLocation(), null);
                }
                continue;
            }
            car.setLocation(car.getLocation(), null);
        }
    }
}

