/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.operations.trains;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import javax.swing.JOptionPane;
import jmri.jmrit.operations.locations.Location;
import jmri.jmrit.operations.locations.Track;
import jmri.jmrit.operations.locations.schedules.ScheduleItem;
import jmri.jmrit.operations.rollingstock.cars.Car;
import jmri.jmrit.operations.rollingstock.cars.CarLoad;
import jmri.jmrit.operations.rollingstock.engines.Engine;
import jmri.jmrit.operations.routes.Route;
import jmri.jmrit.operations.routes.RouteLocation;
import jmri.jmrit.operations.setup.Setup;
import jmri.jmrit.operations.trains.BuildFailedException;
import jmri.jmrit.operations.trains.Bundle;
import jmri.jmrit.operations.trains.JsonManifest;
import jmri.jmrit.operations.trains.Train;
import jmri.jmrit.operations.trains.TrainBuilderBase;
import jmri.jmrit.operations.trains.TrainCommon;
import jmri.jmrit.operations.trains.TrainCsvManifest;
import jmri.jmrit.operations.trains.TrainManifest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TrainBuilder
extends TrainBuilderBase {
    boolean _multipass = false;
    private static final boolean HOME_DIVISION = true;
    boolean _routeToTrackFound;
    private static final Logger log = LoggerFactory.getLogger(TrainBuilder.class);

    public boolean build(Train train) {
        this._train = train;
        try {
            this.build();
            return true;
        }
        catch (BuildFailedException e) {
            this.buildFailed(e);
            return false;
        }
    }

    private void build() throws BuildFailedException {
        this._startTime = new Date();
        log.debug("Building train ({})", (Object)this._train.getName());
        this._train.setStatusCode(1);
        this._train.setBuilt(false);
        this._train.setLeadEngine(null);
        this.createBuildReportFile();
        this.addBuildReportInfo();
        this.setUpRoute();
        this.showTrainBuildOptions();
        this.showSpecificTrainBuildOptions();
        this.showAndInitializeTrainRoute();
        this.showIfLocalSwitcher();
        this.showTrainRequirements();
        this.showTrainServices();
        this.getAndRemoveEnginesFromList();
        this.determineIfTrainTerminatesIntoStaging();
        this.determineIfTrainDepartsStagingAndAddEngines();
        this.addEngines();
        this.showTrainCarTypes();
        this.showTrainLoadNames();
        this.loadCarList();
        this.adjustCarsInStaging();
        this.listCarsByLocation();
        this.sortCarsOnFifoLifoTracks();
        this.addCabooseOrFredToTrain();
        this.removeCaboosesAndCarsWithFred();
        this.saveCarFinalDestinations();
        this.blockCarsFromStaging();
        this.addCarsToTrain();
        this.checkStuckCarsInStaging();
        this.showTrainBuildStatus();
        this.checkEngineHP();
        this.checkNumnberOfEnginesNeededHPT();
        this.showCarsNotRoutable();
        if (this._warnings > 0) {
            TrainBuilder.addLine(this._buildReport, "1", MessageFormat.format(Bundle.getMessage("buildWarningMsg"), this._train.getName(), this._warnings));
        }
        TrainBuilder.addLine(this._buildReport, "5", MessageFormat.format(Bundle.getMessage("buildTime"), this._train.getName(), new Date().getTime() - this._startTime.getTime()));
        this._buildReport.flush();
        this._buildReport.close();
        this.createManifests();
        for (Location location : this._modifiedLocations) {
            location.setStatus(Location.MODIFIED);
        }
        this._train.setPrinted(false);
        this._train.setSwitchListStatus("");
        this._train.setCurrentLocation(this._train.getTrainDepartsRouteLocation());
        this._train.setBuilt(true);
        this._train.moveTrainIcon(this._train.getTrainDepartsRouteLocation());
        log.debug("Done building train ({})", (Object)this._train.getName());
        this.showWarningMessage();
    }

    private void determineIfTrainTerminatesIntoStaging() throws BuildFailedException {
        this._terminateStageTrack = null;
        List<Track> stagingTracksTerminate = this._terminateLocation.getTracksByMovesList("Staging");
        if (stagingTracksTerminate.size() > 0) {
            TrainBuilder.addLine(this._buildReport, "3", " ");
            TrainBuilder.addLine(this._buildReport, "1", MessageFormat.format(Bundle.getMessage("buildTerminateStaging"), this._terminateLocation.getName(), Integer.toString(stagingTracksTerminate.size())));
            if (stagingTracksTerminate.size() > 1 && Setup.isStagingPromptToEnabled()) {
                this._terminateStageTrack = this.promptToStagingDialog();
                this._startTime = new Date();
            } else if (this._departLocation == this._terminateLocation && Setup.isBuildAggressive() && Setup.isStagingTrackImmediatelyAvail()) {
                TrainBuilder.addLine(this._buildReport, "1", MessageFormat.format(Bundle.getMessage("buildStagingReturn"), this._terminateLocation.getName()));
            } else {
                Iterator<Track> iterator = stagingTracksTerminate.iterator();
                while (iterator.hasNext()) {
                    Track track;
                    this._terminateStageTrack = track = iterator.next();
                    if (this.checkTerminateStagingTrack(this._terminateStageTrack)) {
                        TrainBuilder.addLine(this._buildReport, "1", MessageFormat.format(Bundle.getMessage("buildStagingAvail"), this._terminateStageTrack.getName(), this._terminateLocation.getName()));
                        break;
                    }
                    this._terminateStageTrack = null;
                }
            }
            if (this._terminateStageTrack == null) {
                if (this._departLocation == this._terminateLocation && Setup.isBuildAggressive() && Setup.isStagingTrackImmediatelyAvail()) {
                    log.debug("Train is returning to same track in staging");
                } else {
                    TrainBuilder.addLine(this._buildReport, "1", Bundle.getMessage("buildErrorStagingFullNote"));
                    throw new BuildFailedException(MessageFormat.format(Bundle.getMessage("buildErrorStagingFull"), this._terminateLocation.getName()));
                }
            }
        }
    }

    private void determineIfTrainDepartsStagingAndAddEngines() throws BuildFailedException {
        List<Track> stagingTracks;
        RouteLocation engineTerminatesFirstLeg = this._train.getTrainTerminatesRouteLocation();
        if ((this._train.getSecondLegOptions() & 1) == 1 && this._train.getSecondLegStartRouteLocation() != null) {
            engineTerminatesFirstLeg = this._train.getSecondLegStartRouteLocation();
        }
        if ((this._train.getThirdLegOptions() & 1) == 1 && this._train.getThirdLegStartRouteLocation() != null && (this._train.getSecondLegOptions() & 1) != 1) {
            engineTerminatesFirstLeg = this._train.getThirdLegStartRouteLocation();
        }
        if ((stagingTracks = this._departLocation.getTracksByMovesList("Staging")).size() > 0) {
            TrainBuilder.addLine(this._buildReport, "3", " ");
            TrainBuilder.addLine(this._buildReport, "1", MessageFormat.format(Bundle.getMessage("buildDepartStaging"), this._departLocation.getName(), Integer.toString(stagingTracks.size())));
            if (stagingTracks.size() > 1 && Setup.isStagingPromptFromEnabled()) {
                this.setDepartureTrack(this.promptFromStagingDialog());
                this._startTime = new Date();
                if (this._departStageTrack == null) {
                    this.showTrainRequirements();
                    throw new BuildFailedException(MessageFormat.format(Bundle.getMessage("buildErrorStagingEmpty"), this._departLocation.getName()));
                }
            } else {
                for (Track track : stagingTracks) {
                    TrainBuilder.addLine(this._buildReport, "3", MessageFormat.format(Bundle.getMessage("buildStagingHas"), track.getName(), Integer.toString(track.getNumberEngines()), Integer.toString(track.getNumberCars())));
                    if (!this.checkDepartureStagingTrack(track)) {
                        TrainBuilder.addLine(this._buildReport, "7", MessageFormat.format(Bundle.getMessage("buildStagingTrackRestriction"), track.getName(), this._train.getName()));
                        continue;
                    }
                    this.setDepartureTrack(track);
                    if (this.getEngines(this._train.getNumberEngines(), this._train.getEngineModel(), this._train.getEngineRoad(), this._train.getTrainDepartsRouteLocation(), engineTerminatesFirstLeg)) {
                        TrainBuilder.addLine(this._buildReport, "7", Bundle.getMessage("buildDoneAssignEnginesStaging"));
                        break;
                    }
                    this.setDepartureTrack(null);
                }
            }
            if (this._departStageTrack == null) {
                this.showTrainRequirements();
                throw new BuildFailedException(MessageFormat.format(Bundle.getMessage("buildErrorStagingEmpty"), this._departLocation.getName()));
            }
        }
        this._train.setTerminationTrack(this._terminateStageTrack);
        this._train.setDepartureTrack(this._departStageTrack);
    }

    private void addEngines() throws BuildFailedException {
        RouteLocation engineTerminatesFirstLeg = this._train.getTrainTerminatesRouteLocation();
        RouteLocation engineTerminatesSecondLeg = this._train.getTrainTerminatesRouteLocation();
        if ((this._train.getSecondLegOptions() & 1) == 1 && this._train.getSecondLegStartRouteLocation() != null) {
            engineTerminatesFirstLeg = this._train.getSecondLegStartRouteLocation();
        }
        if ((this._train.getThirdLegOptions() & 1) == 1 && this._train.getThirdLegStartRouteLocation() != null) {
            engineTerminatesSecondLeg = this._train.getThirdLegStartRouteLocation();
            if ((this._train.getSecondLegOptions() & 1) != 1) {
                engineTerminatesFirstLeg = this._train.getThirdLegStartRouteLocation();
            }
        }
        if (this._train.getLeadEngine() == null) {
            TrainBuilder.addLine(this._buildReport, "3", " ");
            if (this.getEngines(this._train.getNumberEngines(), this._train.getEngineModel(), this._train.getEngineRoad(), this._train.getTrainDepartsRouteLocation(), engineTerminatesFirstLeg)) {
                this._secondLeadEngine = this._lastEngine;
                this._thirdLeadEngine = this._lastEngine;
            } else if (this.getConsist(this._train.getNumberEngines(), this._train.getEngineModel(), this._train.getEngineRoad(), this._train.getTrainDepartsRouteLocation(), engineTerminatesFirstLeg)) {
                this._secondLeadEngine = this._lastEngine;
                this._thirdLeadEngine = this._lastEngine;
            } else {
                throw new BuildFailedException(MessageFormat.format(Bundle.getMessage("buildErrorEngines"), this._train.getNumberEngines(), this._train.getTrainDepartsName(), engineTerminatesFirstLeg.getName()));
            }
        }
        if ((this._train.getSecondLegOptions() & 1) == 1) {
            TrainBuilder.addLine(this._buildReport, "3", " ");
            TrainBuilder.addLine(this._buildReport, "3", MessageFormat.format(Bundle.getMessage("buildTrainEngineChange"), this._train.getSecondLegStartLocationName(), this._train.getSecondLegNumberEngines(), this._train.getSecondLegEngineModel(), this._train.getSecondLegEngineRoad()));
            if (this.getEngines(this._train.getSecondLegNumberEngines(), this._train.getSecondLegEngineModel(), this._train.getSecondLegEngineRoad(), this._train.getSecondLegStartRouteLocation(), engineTerminatesSecondLeg)) {
                this._secondLeadEngine = this._lastEngine;
                this._thirdLeadEngine = this._lastEngine;
            } else if (this.getConsist(this._train.getSecondLegNumberEngines(), this._train.getSecondLegEngineModel(), this._train.getSecondLegEngineRoad(), this._train.getSecondLegStartRouteLocation(), engineTerminatesSecondLeg)) {
                this._secondLeadEngine = this._lastEngine;
                this._thirdLeadEngine = this._lastEngine;
            } else {
                throw new BuildFailedException(MessageFormat.format(Bundle.getMessage("buildErrorEngines"), this._train.getSecondLegNumberEngines(), this._train.getSecondLegStartRouteLocation(), engineTerminatesSecondLeg));
            }
        }
        if ((this._train.getThirdLegOptions() & 1) == 1) {
            TrainBuilder.addLine(this._buildReport, "3", " ");
            TrainBuilder.addLine(this._buildReport, "3", MessageFormat.format(Bundle.getMessage("buildTrainEngineChange"), this._train.getThirdLegStartLocationName(), this._train.getThirdLegNumberEngines(), this._train.getThirdLegEngineModel(), this._train.getThirdLegEngineRoad()));
            if (this.getEngines(this._train.getThirdLegNumberEngines(), this._train.getThirdLegEngineModel(), this._train.getThirdLegEngineRoad(), this._train.getThirdLegStartRouteLocation(), this._train.getTrainTerminatesRouteLocation())) {
                this._thirdLeadEngine = this._lastEngine;
            } else if (this.getConsist(this._train.getThirdLegNumberEngines(), this._train.getThirdLegEngineModel(), this._train.getThirdLegEngineRoad(), this._train.getThirdLegStartRouteLocation(), this._train.getTrainTerminatesRouteLocation())) {
                this._thirdLeadEngine = this._lastEngine;
            } else {
                throw new BuildFailedException(MessageFormat.format(Bundle.getMessage("buildErrorEngines"), Integer.parseInt(this._train.getThirdLegNumberEngines()), this._train.getThirdLegStartRouteLocation(), this._train.getTrainTerminatesRouteLocation()));
            }
        }
        if (!(this._train.getNumberEngines().equals("0") || this._train.isBuildConsistEnabled() && Setup.getHorsePowerPerTon() != 0)) {
            TrainBuilder.addLine(this._buildReport, "7", MessageFormat.format(Bundle.getMessage("buildDoneAssingEnginesTrain"), this._train.getName()));
        }
    }

    private void addCabooseOrFredToTrain() throws BuildFailedException {
        RouteLocation cabooseOrFredTerminatesFirstLeg = this._train.getTrainTerminatesRouteLocation();
        RouteLocation cabooseOrFredTerminatesSecondLeg = this._train.getTrainTerminatesRouteLocation();
        if ((this._train.getSecondLegOptions() & 8) == 8 || (this._train.getSecondLegOptions() & 4) == 4) {
            cabooseOrFredTerminatesFirstLeg = this._train.getSecondLegStartRouteLocation();
        } else if ((this._train.getThirdLegOptions() & 8) == 8 || (this._train.getThirdLegOptions() & 4) == 4) {
            cabooseOrFredTerminatesFirstLeg = this._train.getThirdLegStartRouteLocation();
        }
        if ((this._train.getThirdLegOptions() & 8) == 8 || (this._train.getThirdLegOptions() & 4) == 4) {
            cabooseOrFredTerminatesSecondLeg = this._train.getThirdLegStartRouteLocation();
        }
        if ((this._train.getThirdLegOptions() & 4) == 4 && this._train.getThirdLegStartRouteLocation() != null && this._train.getTrainTerminatesRouteLocation() != null) {
            this.getCaboose(this._train.getThirdLegCabooseRoad(), this._thirdLeadEngine, this._train.getThirdLegStartRouteLocation(), this._train.getTrainTerminatesRouteLocation(), true);
        }
        if ((this._train.getSecondLegOptions() & 4) == 4 && this._train.getSecondLegStartRouteLocation() != null && cabooseOrFredTerminatesSecondLeg != null) {
            this.getCaboose(this._train.getSecondLegCabooseRoad(), this._secondLeadEngine, this._train.getSecondLegStartRouteLocation(), cabooseOrFredTerminatesSecondLeg, true);
        }
        this.getCaboose(this._train.getCabooseRoad(), this._train.getLeadEngine(), this._train.getTrainDepartsRouteLocation(), cabooseOrFredTerminatesFirstLeg, this._train.isCabooseNeeded());
        this.getCarWithFred(this._train.getCabooseRoad(), this._train.getTrainDepartsRouteLocation(), cabooseOrFredTerminatesFirstLeg);
    }

    /*
     * Unable to fully structure code
     */
    private void getCaboose(String roadCaboose, Engine leadEngine, RouteLocation rl, RouteLocation rld, boolean requiresCaboose) throws BuildFailedException {
        if (rl == null) {
            throw new BuildFailedException(MessageFormat.format(Bundle.getMessage("buildErrorCabooseNoLocation"), new Object[]{this._train.getName()}));
        }
        if (rld == null) {
            throw new BuildFailedException(MessageFormat.format(Bundle.getMessage("buildErrorCabooseNoDestination"), new Object[]{this._train.getName(), rl.getName()}));
        }
        departTrack = null;
        if (rl == this._train.getTrainDepartsRouteLocation()) {
            departTrack = this._departStageTrack;
        }
        if (!requiresCaboose) {
            TrainBuilder.addLine(this._buildReport, "5", MessageFormat.format(Bundle.getMessage("buildTrainNoCaboose"), new Object[]{rl.getName()}));
            if (departTrack == null) {
                return;
            }
        } else {
            TrainBuilder.addLine(this._buildReport, "1", MessageFormat.format(Bundle.getMessage("buildTrainReqCaboose"), new Object[]{this._train.getName(), roadCaboose, rl.getName(), rld.getName()}));
        }
        cabooseTip = true;
        cabooseAtDeparture = false;
        foundCaboose = false;
        this._carIndex = 0;
        while (this._carIndex < this._carList.size()) {
            block28: {
                block30: {
                    block29: {
                        car = (Car)this._carList.get(this._carIndex);
                        if (!car.isCaboose()) break block28;
                        this.showCarServiceOrder(car);
                        cabooseTip = false;
                        TrainBuilder.addLine(this._buildReport, "7", MessageFormat.format(Bundle.getMessage("buildCarIsCaboose"), new Object[]{car.toString(), car.getRoadName(), car.getLocationName(), car.getTrackName()}));
                        if (car.getTrack() != departTrack) break block29;
                        foundCaboose = false;
                        if (!this.generateCarLoadFromStaging(car, rld) && car.getTrack().isAddCustomLoadsAnyStagingTrackEnabled() && rld.getLocation() == this._terminateLocation && this._terminateStageTrack != null) {
                            this.generateLoadCarDepartingAndTerminatingIntoStaging(car, this._terminateStageTrack);
                        }
                        if (this.checkAndAddCarForDestinationAndTrack(car, rl, rld)) {
                            if (car.getTrain() == this._train) {
                                foundCaboose = true;
                            }
                        } else if (this.findDestinationAndTrack(car, rl, rld)) {
                            foundCaboose = true;
                        }
                        if (!foundCaboose) {
                            throw new BuildFailedException(MessageFormat.format(Bundle.getMessage("buildErrorCarStageDest"), new Object[]{car.toString()}));
                        }
                        break block28;
                    }
                    if (!roadCaboose.equals("") && !roadCaboose.equals(car.getRoadName()) || foundCaboose || !car.getLocationName().equals(rl.getName())) break block28;
                    if (this.checkPickUpTrainDirection(car, rl)) break block30;
                    TrainBuilder.addLine(this._buildReport, "7", MessageFormat.format(Bundle.getMessage("buildExcludeCarTypeAtLoc"), new Object[]{car.toString(), car.getTypeName(), String.valueOf(car.getLocationName()) + " " + car.getTrackName()}));
                    this._carList.remove(car);
                    --this._carIndex;
                    break block28;
                }
                if (leadEngine == null || !car.getRoadName().equals(leadEngine.getRoadName())) ** GOTO lbl-1000
                TrainBuilder.addLine(this._buildReport, "7", MessageFormat.format(Bundle.getMessage("buildCabooseRoadMatches"), new Object[]{car.toString(), car.getRoadName(), leadEngine.toString()}));
                if (this.checkAndAddCarForDestinationAndTrack(car, rl, rld)) {
                    if (car.getTrain() == this._train) {
                        foundCaboose = true;
                    }
                } else if (this.findDestinationAndTrack(car, rl, rld)) {
                    foundCaboose = true;
                }
                if (!foundCaboose) {
                    this._carList.remove(car);
                    --this._carIndex;
                } else if (foundCaboose && departTrack == null) break;
            }
            ++this._carIndex;
        }
        if (requiresCaboose && !foundCaboose && roadCaboose.equals("")) {
            TrainBuilder.log.debug("Second pass looking for caboose");
            for (Car car : this._carList) {
                if (!car.isCaboose() || !car.getLocationName().equals(rl.getName()) || leadEngine == null || !TrainCommon.splitString(car.getRoadName()).equals(TrainCommon.splitString(leadEngine.getRoadName()))) continue;
                TrainBuilder.addLine(this._buildReport, "7", MessageFormat.format(Bundle.getMessage("buildCabooseRoadMatches"), new Object[]{car.toString(), car.getRoadName(), leadEngine.toString()}));
                if (this.checkAndAddCarForDestinationAndTrack(car, rl, rld)) {
                    if (car.getTrain() != this._train) continue;
                    foundCaboose = true;
                    break;
                }
                if (!this.findDestinationAndTrack(car, rl, rld)) continue;
                foundCaboose = true;
                break;
            }
        }
        if (requiresCaboose && !foundCaboose) {
            TrainBuilder.log.debug("Third pass looking for caboose");
            for (Car car : this._carList) {
                if (!car.isCaboose() || !car.getLocationName().equals(rl.getName()) || !roadCaboose.equals("") && !roadCaboose.equals(car.getRoadName())) continue;
                cabooseAtDeparture = true;
                if (this.checkAndAddCarForDestinationAndTrack(car, rl, rld)) {
                    if (car.getTrain() != this._train) continue;
                    foundCaboose = true;
                    break;
                }
                if (!this.findDestinationAndTrack(car, rl, rld)) continue;
                foundCaboose = true;
                break;
            }
        }
        if (requiresCaboose && !foundCaboose) {
            if (cabooseTip) {
                TrainBuilder.addLine(this._buildReport, "1", Bundle.getMessage("buildNoteCaboose"));
                TrainBuilder.addLine(this._buildReport, "1", Bundle.getMessage("buildNoteCaboose2"));
            }
            if (!cabooseAtDeparture) {
                throw new BuildFailedException(MessageFormat.format(Bundle.getMessage("buildErrorReqDepature"), new Object[]{this._train.getName(), Bundle.getMessage("Caboose").toLowerCase(), rl.getName()}));
            }
            throw new BuildFailedException(MessageFormat.format(Bundle.getMessage("buildErrorReqDest"), new Object[]{this._train.getName(), Bundle.getMessage("Caboose"), rld.getName()}));
        }
    }

    private void getCarWithFred(String road, RouteLocation rl, RouteLocation rld) throws BuildFailedException {
        Track departTrack = null;
        if (rl == this._train.getTrainDepartsRouteLocation()) {
            departTrack = this._departStageTrack;
        }
        boolean foundCarWithFred = false;
        if (this._train.isFredNeeded()) {
            TrainBuilder.addLine(this._buildReport, "1", MessageFormat.format(Bundle.getMessage("buildTrainReqFred"), this._train.getName(), road, rl.getName(), rld.getName()));
        } else {
            TrainBuilder.addLine(this._buildReport, "5", Bundle.getMessage("buildTrainNoFred"));
            if (departTrack == null) {
                return;
            }
        }
        this._carIndex = 0;
        while (this._carIndex < this._carList.size()) {
            Car car = (Car)this._carList.get(this._carIndex);
            if (car.hasFred()) {
                this.showCarServiceOrder(car);
                TrainBuilder.addLine(this._buildReport, "7", MessageFormat.format(Bundle.getMessage("buildCarHasFRED"), car.toString(), car.getRoadName(), car.getLocationName()));
                if (car.getTrack() == departTrack) {
                    foundCarWithFred = false;
                    if (!this.generateCarLoadFromStaging(car, rld) && car.getTrack().isAddCustomLoadsAnyStagingTrackEnabled() && rld.getLocation() == this._terminateLocation && this._terminateStageTrack != null) {
                        this.generateLoadCarDepartingAndTerminatingIntoStaging(car, this._terminateStageTrack);
                    }
                    if (this.checkAndAddCarForDestinationAndTrack(car, rl, rld)) {
                        if (car.getTrain() == this._train) {
                            foundCarWithFred = true;
                        }
                    } else if (this.findDestinationAndTrack(car, rl, rld)) {
                        foundCarWithFred = true;
                    }
                    if (!foundCarWithFred) {
                        throw new BuildFailedException(MessageFormat.format(Bundle.getMessage("buildErrorCarStageDest"), car.toString()));
                    }
                } else if (!road.equals("") && !road.equals(car.getRoadName())) {
                    TrainBuilder.addLine(this._buildReport, "7", MessageFormat.format(Bundle.getMessage("buildExcludeCarWrongRoad"), car.toString(), car.getTypeName(), car.getRoadName()));
                    this._carList.remove(car);
                    --this._carIndex;
                } else if (!foundCarWithFred && car.getLocationName().equals(rl.getName())) {
                    if (!this.checkPickUpTrainDirection(car, rl)) {
                        TrainBuilder.addLine(this._buildReport, "7", MessageFormat.format(Bundle.getMessage("buildExcludeCarTypeAtLoc"), car.toString(), car.getTypeName(), String.valueOf(car.getLocationName()) + " " + car.getTrackName()));
                        this._carList.remove(car);
                        --this._carIndex;
                    } else {
                        if (this.checkAndAddCarForDestinationAndTrack(car, rl, rld)) {
                            if (car.getTrain() == this._train) {
                                foundCarWithFred = true;
                            }
                        } else if (this.findDestinationAndTrack(car, rl, rld)) {
                            foundCarWithFred = true;
                        }
                        if (foundCarWithFred && departTrack == null) break;
                    }
                }
            }
            ++this._carIndex;
        }
        if (this._train.isFredNeeded() && !foundCarWithFred) {
            throw new BuildFailedException(MessageFormat.format(Bundle.getMessage("buildErrorRequirements"), this._train.getName(), Bundle.getMessage("FRED"), rl.getName(), rld.getName()));
        }
    }

    private boolean checkAndAddCarForDestinationAndTrack(Car car, RouteLocation rl, RouteLocation rld) throws BuildFailedException {
        return this.checkCarForDestination(car, rl, this._routeList.indexOf(rld));
    }

    private void blockCarsFromStaging() throws BuildFailedException {
        if (this._departStageTrack == null || !this._departStageTrack.isBlockCarsEnabled()) {
            return;
        }
        TrainBuilder.addLine(this._buildReport, "3", " ");
        TrainBuilder.addLine(this._buildReport, "3", MessageFormat.format(Bundle.getMessage("blockDepartureHasBlocks"), this._departStageTrack.getName(), this._numOfBlocks.size()));
        Enumeration en = this._numOfBlocks.keys();
        while (en.hasMoreElements()) {
            String locId = (String)en.nextElement();
            int numCars = (Integer)this._numOfBlocks.get(locId);
            String locName = "";
            Location l = this.locationManager.getLocationById(locId);
            if (l != null) {
                locName = l.getName();
            }
            TrainBuilder.addLine(this._buildReport, "7", MessageFormat.format(Bundle.getMessage("blockFromHasCars"), locId, locName, numCars));
            if (this._numOfBlocks.size() >= 2) continue;
            TrainBuilder.addLine(this._buildReport, "7", Bundle.getMessage("blockUnable"));
            return;
        }
        this.blockByLocationMoves();
        TrainBuilder.addLine(this._buildReport, "7", MessageFormat.format(Bundle.getMessage("blockDone"), this._departStageTrack.getName()));
    }

    private void blockByLocationMoves() throws BuildFailedException {
        RouteLocation rld;
        String blockId;
        List<RouteLocation> blockRouteList = this._train.getRoute().getLocationsBySequenceList();
        for (RouteLocation rl : blockRouteList) {
            if (rl == this._train.getTrainDepartsRouteLocation()) continue;
            int possibleMoves = rl.getMaxCarMoves() - rl.getCarMoves();
            if (!rl.isDropAllowed() || possibleMoves <= 0) continue;
            TrainBuilder.addLine(this._buildReport, "7", MessageFormat.format(Bundle.getMessage("blockLocationHasMoves"), rl.getName(), possibleMoves));
        }
        while (!(blockId = this.getLargestBlock()).isEmpty() && (Integer)this._numOfBlocks.get(blockId) != 1 && (rld = this.getLocationWithMaximumMoves(blockRouteList, blockId)) != null) {
            if (rld.getMaxCarMoves() > (Integer)this._numOfBlocks.get(blockId)) {
                this._numOfBlocks.remove(blockId);
                if (blockId.equals("0")) continue;
                blockRouteList.remove(rld);
                Location loc = this.locationManager.getLocationById(blockId);
                Location setOutLoc = rld.getLocation();
                if (loc == null || setOutLoc == null || !this.checkDropTrainDirection(rld)) continue;
                this._carIndex = 0;
                while (this._carIndex < this._carList.size()) {
                    Car car = (Car)this._carList.get(this._carIndex);
                    if (car.getTrack() == this._departStageTrack && car.getLastLocationId().equals(blockId)) {
                        if (car.getDestination() != null) {
                            TrainBuilder.addLine(this._buildReport, "7", MessageFormat.format(Bundle.getMessage("blockNotAbleDest"), car.toString(), car.getDestinationName()));
                        } else if (car.getFinalDestination() != null) {
                            TrainBuilder.addLine(this._buildReport, "7", MessageFormat.format(Bundle.getMessage("blockNotAbleFinalDest"), car.toString(), car.getFinalDestination().getName()));
                        } else if (!car.getLoadName().equals(this.carLoads.getDefaultEmptyName()) && !car.getLoadName().equals(this.carLoads.getDefaultLoadName())) {
                            TrainBuilder.addLine(this._buildReport, "7", MessageFormat.format(Bundle.getMessage("blockNotAbleCustomLoad"), car.toString(), car.getLoadName()));
                        } else if (car.getLoadName().equals(this.carLoads.getDefaultEmptyName()) && (this._departStageTrack.isAddCustomLoadsEnabled() || this._departStageTrack.isAddCustomLoadsAnySpurEnabled() || this._departStageTrack.isAddCustomLoadsAnyStagingTrackEnabled())) {
                            TrainBuilder.addLine(this._buildReport, "7", MessageFormat.format(Bundle.getMessage("blockNotAbleCarTypeGenerate"), car.toString(), car.getLoadName()));
                        } else {
                            TrainBuilder.addLine(this._buildReport, "7", MessageFormat.format(Bundle.getMessage("blockingCar"), car.toString(), loc.getName(), rld.getName()));
                            if (!this.findDestinationAndTrack(car, this._train.getTrainDepartsRouteLocation(), rld)) {
                                TrainBuilder.addLine(this._buildReport, "7", MessageFormat.format(Bundle.getMessage("blockNotAbleCarType"), car.toString(), rld.getName(), car.getTypeName()));
                            }
                        }
                    }
                    ++this._carIndex;
                }
                continue;
            }
            TrainBuilder.addLine(this._buildReport, "7", MessageFormat.format(Bundle.getMessage("blockDestNotEnoughMoves"), rld.getName(), blockId));
            this._numOfBlocks.remove(blockId);
        }
    }

    private void addCarsToTrain() throws BuildFailedException {
        TrainBuilder.addLine(this._buildReport, "3", " ");
        TrainBuilder.addLine(this._buildReport, "3", MessageFormat.format(Bundle.getMessage("buildTrain"), this._train.getNumberCarsRequested(), this._train.getName(), this._carList.size()));
        if (Setup.isBuildAggressive() && !this._train.isBuildTrainNormalEnabled()) {
            int passes = 0;
            boolean firstPass = true;
            while (passes++ < Setup.getNumberPasses()) {
                this.placeCars(100 * passes / Setup.getNumberPasses(), firstPass);
                firstPass = false;
            }
            this.secondAttemptNormalBuild();
        } else {
            this.placeCars(100, false);
        }
    }

    private void secondAttemptNormalBuild() throws BuildFailedException {
        if (Setup.isStagingTryNormalBuildEnabled() && this.isCarStuckStaging()) {
            TrainBuilder.addLine(this._buildReport, "1", Bundle.getMessage("buildFailedTryNormalMode"));
            TrainBuilder.addLine(this._buildReport, "1", " ");
            this._train.reset();
            this._train.setStatusCode(1);
            this._train.setLeadEngine(null);
            this.showAndInitializeTrainRoute();
            this.getAndRemoveEnginesFromList();
            this.addEngines();
            this.loadCarList();
            this.adjustCarsInStaging();
            this.listCarsByLocation();
            this.addCabooseOrFredToTrain();
            this.removeCaboosesAndCarsWithFred();
            this.saveCarFinalDestinations();
            this.blockCarsFromStaging();
            this.placeCars(100, false);
        }
    }

    private void placeCars(int percent, boolean firstPass) throws BuildFailedException {
        TrainBuilder.addLine(this._buildReport, "3", " ");
        if (percent < 100) {
            TrainBuilder.addLine(this._buildReport, "3", MessageFormat.format(Bundle.getMessage("buildMultiplePass"), percent));
            this._multipass = true;
        }
        if (percent == 100 && this._multipass) {
            TrainBuilder.addLine(this._buildReport, "3", Bundle.getMessage("buildFinalPass"));
        }
        for (RouteLocation rl : this._routeList) {
            if (this._train.isLocationSkipped(rl.getId())) {
                TrainBuilder.addLine(this._buildReport, "1", MessageFormat.format(Bundle.getMessage("buildLocSkipped"), rl.getName(), rl.getId(), this._train.getName()));
                continue;
            }
            if (!rl.isPickUpAllowed()) {
                TrainBuilder.addLine(this._buildReport, "1", MessageFormat.format(Bundle.getMessage("buildLocNoPickups"), this._train.getRoute().getName(), rl.getId(), rl.getName()));
                continue;
            }
            if (rl != this._train.getTrainDepartsRouteLocation() && rl.getLocation().isStaging()) {
                TrainBuilder.addLine(this._buildReport, "1", MessageFormat.format(Bundle.getMessage("buildNoPickupsFromStaging"), rl.getName()));
                continue;
            }
            if (!this.checkPickUpTrainDirection(rl)) continue;
            this._completedMoves = 0;
            this._success = true;
            this._reqNumOfMoves = (rl.getMaxCarMoves() - rl.getCarMoves()) * percent / 99;
            int remainder = (rl.getMaxCarMoves() - rl.getCarMoves()) % (100 / percent);
            if (percent < 51 && remainder > 0) {
                ++this._reqNumOfMoves;
            }
            if (rl == this._train.getTrainDepartsRouteLocation()) {
                if (firstPass) {
                    this.makeAdjustmentsIfDepartingStaging();
                } else {
                    this.restoreCarsIfDepartingStaging();
                }
            }
            int saveReqMoves = this._reqNumOfMoves;
            TrainBuilder.addLine(this._buildReport, "1", MessageFormat.format(Bundle.getMessage("buildLocReqMoves"), rl.getName(), rl.getId(), this._reqNumOfMoves, rl.getMaxCarMoves() - rl.getCarMoves(), rl.getMaxCarMoves()));
            TrainBuilder.addLine(this._buildReport, "5", " ");
            if (rl == this._train.getTrainDepartsRouteLocation()) {
                this.showLoadGenerationOptionsStaging();
            }
            this._carIndex = 0;
            this.findDestinationsForCarsFromLocation(rl, false);
            if (Setup.isBuildAggressive() && saveReqMoves != this._reqNumOfMoves) {
                log.debug("Perform extra pass at location ({})", (Object)rl.getName());
                if (this._reqNumOfMoves < (rl.getMaxCarMoves() - rl.getCarMoves()) / 2) {
                    this._reqNumOfMoves = (rl.getMaxCarMoves() - rl.getCarMoves()) / 2;
                }
                this.findDestinationsForCarsFromLocation(rl, true);
                if (this.redirectCarsFromAlternateTrack()) {
                    TrainBuilder.addLine(this._buildReport, "7", " ");
                }
            }
            if (rl == this._train.getTrainDepartsRouteLocation() && percent == 100 && this.isCarStuckStaging()) {
                return;
            }
            TrainBuilder.addLine(this._buildReport, "1", MessageFormat.format(Bundle.getMessage("buildStatusMsg"), saveReqMoves <= this._completedMoves ? Bundle.getMessage("Success") : Bundle.getMessage("Partial"), Integer.toString(this._completedMoves), Integer.toString(saveReqMoves), rl.getName(), this._train.getName()));
            if (!this._success || percent != 100) continue;
            this.reportCarsNotMoved(rl);
        }
    }

    private void findDestinationsForCarsFromLocation(RouteLocation rl, boolean isSecondPass) throws BuildFailedException {
        if (this._reqNumOfMoves <= 0) {
            return;
        }
        boolean messageFlag = true;
        boolean foundCar = false;
        this._success = false;
        this._carIndex = 0;
        while (this._carIndex < this._carList.size()) {
            Car car = (Car)this._carList.get(this._carIndex);
            if ((!isSecondPass || car.getFinalDestinationName().equals(rl.getName())) && car.getLocationName().equals(rl.getName())) {
                foundCar = true;
                if (isSecondPass && messageFlag) {
                    messageFlag = false;
                    TrainBuilder.addLine(this._buildReport, "5", MessageFormat.format(Bundle.getMessage("buildExtraPassForLocation"), rl.getName()));
                    TrainBuilder.addLine(this._buildReport, "7", " ");
                }
                if (!this.checkPickUpTrainDirection(car, rl)) {
                    TrainBuilder.addLine(this._buildReport, "5", " ");
                } else {
                    this.showCarServiceOrder(car);
                    if (!(this.generateCarLoadFromStaging(car) || this.generateCarLoadStagingToStaging(car) || car.getTrack() != this._departStageTrack || this._departStageTrack.isLoadNameAndCarTypeShipped(car.getLoadName(), car.getTypeName()))) {
                        TrainBuilder.addLine(this._buildReport, "1", MessageFormat.format(Bundle.getMessage("buildErrorCarStageLoad"), car.toString(), car.getLoadName(), this._departStageTrack.getName()));
                        TrainBuilder.addLine(this._buildReport, "5", " ");
                    } else if (this.findDestinationsForCarsWithHomeDivision(car)) {
                        if (this.findFinalDestinationForCarLoad(car) && car.getDestination() == null && car.getTrack() != this._departStageTrack) {
                            TrainBuilder.addLine(this._buildReport, "5", MessageFormat.format(Bundle.getMessage("buildNoDestForCar"), car.toString()));
                            TrainBuilder.addLine(this._buildReport, "5", " ");
                        } else {
                            if (this.checkCarForFinalDestination(car)) {
                                log.debug("Car ({}) has a final desination that can't be serviced by train", (Object)car.toString());
                            } else if (this.checkCarForDestination(car, rl, this._routeList.indexOf(rl))) {
                                log.debug("Car ({}) has desination ({}) using train ({})", new Object[]{car.toString(), car.getDestinationName(), car.getTrainName()});
                            } else {
                                this.findDestinationAndTrack(car, rl, this._routeList.indexOf(rl), this._routeList.size());
                            }
                            if (this._success) break;
                            if (car.getTrack() == this._departStageTrack && (car.getDestination() == null || car.getDestinationTrack() == null || car.getTrain() == null)) {
                                TrainBuilder.addLine(this._buildReport, "1", MessageFormat.format(Bundle.getMessage("buildWarningCarStageDest"), car.toString()));
                                if (car.getFinalDestinationTrack() != null && car.getFinalDestinationTrack() == this._terminateStageTrack) {
                                    TrainBuilder.addLine(this._buildReport, "3", MessageFormat.format(Bundle.getMessage("buildStagingCarHasFinal"), car.toString(), car.getFinalDestinationName(), car.getFinalDestinationTrackName()));
                                    car.reset();
                                }
                                TrainBuilder.addLine(this._buildReport, "7", " ");
                            }
                        }
                    }
                }
            }
            ++this._carIndex;
        }
        if (!foundCar && !isSecondPass) {
            TrainBuilder.addLine(this._buildReport, "5", MessageFormat.format(Bundle.getMessage("buildNoCarsAtLocation"), rl.getName()));
            TrainBuilder.addLine(this._buildReport, "5", " ");
        }
    }

    private boolean generateCarLoadFromStaging(Car car) throws BuildFailedException {
        return this.generateCarLoadFromStaging(car, null);
    }

    private boolean generateCarLoadFromStaging(Car car, RouteLocation rld) throws BuildFailedException {
        if (car.getTrack() == null) {
            throw new BuildFailedException(MessageFormat.format(Bundle.getMessage("buildWarningRsNoTrack"), car.toString(), car.getLocationName()));
        }
        if (!car.getTrack().isStaging() || !car.getTrack().isAddCustomLoadsAnySpurEnabled() && !car.getTrack().isAddCustomLoadsEnabled() || !car.getLoadName().equals(this.carLoads.getDefaultEmptyName()) || car.getDestination() != null || car.getFinalDestination() != null) {
            log.debug("No load generation for car ({}) isAddLoadsAnySpurEnabled: {}, car load ({}) destination ({}) final destination ({})", new Object[]{car.toString(), car.getTrack().isAddCustomLoadsAnySpurEnabled() ? "true" : "false", car.getLoadName(), car.getDestinationName(), car.getFinalDestinationName()});
            if (car.getTrack().isStaging() && car.getTrack().isAddCustomLoadsAnySpurEnabled() && car.getLoadName().equals(this.carLoads.getDefaultEmptyName())) {
                TrainBuilder.addLine(this._buildReport, "5", MessageFormat.format(Bundle.getMessage("buildCarNoLoadGenerated"), car.toString(), car.getLoadName(), car.getDestinationName(), car.getFinalDestinationName()));
            }
            return false;
        }
        TrainBuilder.addLine(this._buildReport, "5", MessageFormat.format(Bundle.getMessage("buildSearchTrackNewLoad"), car.toString(), car.getTypeName(), car.getLoadName(), car.getLocationName(), car.getTrackName(), rld != null ? rld.getLocation().getName() : ""));
        if (this.carLoads.getNames(car.getTypeName()).size() == 2) {
            TrainBuilder.addLine(this._buildReport, "7", MessageFormat.format(Bundle.getMessage("buildCarNoCustomLoad"), car.toString(), car.getTypeName()));
            return false;
        }
        if (car.getKernel() != null) {
            TrainBuilder.addLine(this._buildReport, "7", MessageFormat.format(Bundle.getMessage("buildCarLeadKernel"), car.toString(), car.getKernelName(), car.getKernel().getSize(), car.getKernel().getTotalLength(), Setup.getLengthUnit().toLowerCase()));
        }
        List<Track> tracks = this.locationManager.getTracksByMoves("Spur");
        log.debug("Found {} spurs", (Object)tracks.size());
        ArrayList<Location> locationsNotServiced = new ArrayList<Location>();
        for (Track track : tracks) {
            ScheduleItem si;
            if (locationsNotServiced.contains(track.getLocation())) continue;
            if (rld != null && track.getLocation() != rld.getLocation()) {
                locationsNotServiced.add(track.getLocation());
                continue;
            }
            if (!car.getTrack().isDestinationAccepted(track.getLocation())) {
                TrainBuilder.addLine(this._buildReport, "7", MessageFormat.format(Bundle.getMessage("buildDestinationNotServiced"), track.getLocation().getName(), car.getTrackName()));
                locationsNotServiced.add(track.getLocation());
                continue;
            }
            if (car.getTrack().isAddCustomLoadsEnabled() && this._train.getRoute().getLastLocationByName(track.getLocation().getName()) == null || (si = this.getScheduleItem(car, track)) == null) continue;
            String oldCarLoad = car.getLoadName();
            car.setLoadName(si.getReceiveLoadName());
            String status = car.testDestination(track.getLocation(), track);
            if (!status.equals(Track.OKAY) && !status.startsWith(Track.LENGTH)) {
                TrainBuilder.addLine(this._buildReport, "7", MessageFormat.format(Bundle.getMessage("buildNoDestTrackNewLoad"), track.getLocation().getName(), track.getName(), car.toString(), si.getReceiveLoadName(), status));
                car.setLoadName(oldCarLoad);
                continue;
            }
            TrainBuilder.addLine(this._buildReport, "7", MessageFormat.format(Bundle.getMessage("buildTrySpurLoad"), track.getLocation().getName(), track.getName(), car.getLoadName()));
            if (car.getDivision() != null) {
                TrainBuilder.addLine(this._buildReport, "7", MessageFormat.format(Bundle.getMessage("buildCarHasDivisionStaging"), car.toString(), car.getTypeName(), car.getLoadType().toLowerCase(), car.getLoadName(), car.getDivisionName(), car.getLocationName(), car.getTrackName(), car.getTrack().getDivisionName()));
                if (car.getLoadType().equals(CarLoad.LOAD_TYPE_EMPTY) && car.getDivision() != track.getDivision() || car.getLoadType().equals(CarLoad.LOAD_TYPE_LOAD) && car.getTrack().getDivision() != car.getDivision() && car.getDivision() != track.getDivision()) {
                    TrainBuilder.addLine(this._buildReport, "7", MessageFormat.format(Bundle.getMessage("buildNoDivisionTrack"), track.getTrackTypeName(), track.getLocation().getName(), track.getName(), track.getDivisionName(), car.toString(), car.getLoadType().toLowerCase(), car.getLoadName()));
                    car.setLoadName(oldCarLoad);
                    continue;
                }
            }
            if (!track.isSpaceAvailable(car)) {
                TrainBuilder.addLine(this._buildReport, "7", MessageFormat.format(Bundle.getMessage("buildNoDestTrackSpace"), car.toString(), track.getLocation().getName(), track.getName(), track.getNumberOfCarsInRoute(), track.getReservedInRoute(), Setup.getLengthUnit().toLowerCase(), track.getReservationFactor()));
                car.setLoadName(oldCarLoad);
                continue;
            }
            car.setFinalDestination(track.getLocation());
            car.setFinalDestinationTrack(track);
            if (this.router.setDestination(car, this._train, this._buildReport) && car.getDestination() != null) {
                TrainBuilder.addLine(this._buildReport, "5", MessageFormat.format(Bundle.getMessage("buildCreateNewLoadForCar"), car.toString(), si.getReceiveLoadName(), track.getLocation().getName(), track.getName()));
                car.setLoadGeneratedFromStaging(true);
                car.updateKernel();
                track.bumpSchedule();
                return true;
            }
            TrainBuilder.addLine(this._buildReport, "7", MessageFormat.format(Bundle.getMessage("buildCanNotRouteCar"), car.toString(), si.getReceiveLoadName(), track.getLocation().getName(), track.getName()));
            car.setDestination(null, null);
            car.setLoadName(oldCarLoad);
            car.setFinalDestination(null);
            car.setFinalDestinationTrack(null);
        }
        TrainBuilder.addLine(this._buildReport, "7", MessageFormat.format(Bundle.getMessage("buildUnableNewLoad"), car.toString()));
        return false;
    }

    private boolean generateCarLoadStagingToStaging(Car car) throws BuildFailedException {
        if (car.getTrack() == null) {
            throw new BuildFailedException(MessageFormat.format(Bundle.getMessage("buildWarningRsNoTrack"), car.toString(), car.getLocationName()));
        }
        if (!(car.getTrack().isStaging() && car.getTrack().isAddCustomLoadsAnyStagingTrackEnabled() && car.getLoadName().equals(this.carLoads.getDefaultEmptyName()) && car.getDestination() == null && car.getFinalDestination() == null)) {
            log.debug("No load generation for car ({}) isAddCustomLoadsAnyStagingTrackEnabled: {}, car load ({}) destination ({}) final destination ({})", new Object[]{car.toString(), car.getTrack().isAddCustomLoadsAnyStagingTrackEnabled() ? "true" : "false", car.getLoadName(), car.getDestinationName(), car.getFinalDestinationName()});
            return false;
        }
        List<Track> tracks = this.locationManager.getTracks("Staging");
        TrainBuilder.addLine(this._buildReport, "5", MessageFormat.format(Bundle.getMessage("buildTryStagingToStaging"), car.toString(), tracks.size()));
        if (Setup.getRouterBuildReportLevel().equals("7")) {
            for (Track track : tracks) {
                TrainBuilder.addLine(this._buildReport, "7", MessageFormat.format(Bundle.getMessage("buildStagingLocationTrack"), track.getLocation().getName(), track.getName()));
            }
        }
        ArrayList<Location> locationsNotServiced = new ArrayList<Location>();
        if (this._terminateStageTrack != null) {
            TrainBuilder.addLine(this._buildReport, "7", MessageFormat.format(Bundle.getMessage("buildIgnoreStagingFirstPass"), this._terminateStageTrack.getLocation().getName()));
            locationsNotServiced.add(this._terminateStageTrack.getLocation());
        }
        while (tracks.size() > 0) {
            int rnd = (int)(Math.random() * (double)tracks.size());
            Track track = tracks.get(rnd);
            tracks.remove(track);
            log.debug("Try staging track ({}, {})", (Object)track.getLocation().getName(), (Object)track.getName());
            if (track.getLocation() == this._departLocation) {
                log.debug("Can't use departure location ({})", (Object)track.getLocation().getName());
                continue;
            }
            if (!this._train.isAllowThroughCarsEnabled() && track.getLocation() == this._terminateLocation) {
                log.debug("Through cars to location ({}) not allowed", (Object)track.getLocation().getName());
                continue;
            }
            if (locationsNotServiced.contains(track.getLocation())) {
                log.debug("Location ({}) not reachable", (Object)track.getLocation().getName());
                continue;
            }
            if (!car.getTrack().isDestinationAccepted(track.getLocation())) {
                TrainBuilder.addLine(this._buildReport, "7", MessageFormat.format(Bundle.getMessage("buildDestinationNotServiced"), track.getLocation().getName(), car.getTrackName()));
                locationsNotServiced.add(track.getLocation());
                continue;
            }
            if (!this.generateLoadCarDepartingAndTerminatingIntoStaging(car, track)) continue;
            if (this.router.setDestination(car, this._train, this._buildReport) && car.getDestination() != null) {
                return true;
            }
            TrainBuilder.addLine(this._buildReport, "7", MessageFormat.format(Bundle.getMessage("buildStagingTrackNotReachable"), track.getLocation().getName(), track.getName(), car.getLoadName()));
            car.setLoadName(this.carLoads.getDefaultEmptyName());
            car.setLoadGeneratedFromStaging(false);
            car.setFinalDestination(null);
            car.updateKernel();
            locationsNotServiced.add(track.getLocation());
        }
        if (this._train.isAllowThroughCarsEnabled() && this._terminateStageTrack != null && car.getTrack().isDestinationAccepted(this._terminateStageTrack.getLocation()) && this.generateLoadCarDepartingAndTerminatingIntoStaging(car, this._terminateStageTrack)) {
            return true;
        }
        TrainBuilder.addLine(this._buildReport, "7", MessageFormat.format(Bundle.getMessage("buildNoStagingForCarCustom"), car.toString()));
        return false;
    }

    private boolean findDestinationsForCarsWithHomeDivision(Car car) throws BuildFailedException {
        if (car.getDivision() == null || car.getDestination() != null || car.getFinalDestination() != null) {
            return true;
        }
        if (car.getDivision() == car.getTrack().getDivision()) {
            TrainBuilder.addLine(this._buildReport, "5", MessageFormat.format(Bundle.getMessage("buildCarDepartHomeDivision"), car.toString(), car.getTypeName(), car.getLoadType().toLowerCase(), car.getLoadName(), car.getDivisionName(), car.getLocationName(), car.getTrackName(), car.getTrack().getDivisionName()));
        } else {
            TrainBuilder.addLine(this._buildReport, "5", MessageFormat.format(Bundle.getMessage("buildCarDepartForeignDivision"), car.toString(), car.getTypeName(), car.getLoadType().toLowerCase(), car.getLoadName(), car.getDivisionName(), car.getLocationName(), car.getTrackName(), car.getTrack().getDivisionName()));
        }
        if (car.getKernel() != null) {
            TrainBuilder.addLine(this._buildReport, "7", MessageFormat.format(Bundle.getMessage("buildCarLeadKernel"), car.toString(), car.getKernelName(), car.getKernel().getSize(), car.getKernel().getTotalLength(), Setup.getLengthUnit().toLowerCase()));
        }
        if (car.getLoadType().equals(CarLoad.LOAD_TYPE_EMPTY)) {
            log.debug("Car ({}) has home division ({}) and load type empty", (Object)car.toString(), (Object)car.getDivisionName());
            if (car.getTrack().isYard() && car.getTrack().getDivision() == car.getDivision()) {
                log.debug("Car ({}) at it's home division yard", (Object)car.toString());
                if (!this.sendCarToHomeDivisionTrack(car, "Spur", true)) {
                    return this.sendCarToHomeDivisionTrack(car, "Staging", true);
                }
            } else if (!this.sendCarToHomeDivisionTrack(car, "Yard", true) && !this.sendCarToHomeDivisionTrack(car, "Staging", true)) {
                return this.sendCarToHomeDivisionTrack(car, "Spur", true);
            }
        } else {
            log.debug("Car ({}) has home division ({}) and load type load", (Object)car.toString(), (Object)car.getDivisionName());
            if (!this.sendCarToHomeDivisionTrack(car, "Spur", car.getTrack().getDivision() != car.getDivision())) {
                return this.sendCarToHomeDivisionTrack(car, "Staging", car.getTrack().getDivision() != car.getDivision());
            }
        }
        return true;
    }

    private boolean sendCarToHomeDivisionTrack(Car car, String trackType, boolean home_division) {
        ArrayList<Location> locationsNotServiced = new ArrayList<Location>();
        List<Track> tracks = this.locationManager.getTracksByMoves(trackType);
        log.debug("Found {} {} tracks", (Object)tracks.size(), (Object)trackType);
        for (Track track : tracks) {
            if (home_division && car.getDivision() != track.getDivision()) {
                TrainBuilder.addLine(this._buildReport, "7", MessageFormat.format(Bundle.getMessage("buildNoDivisionTrack"), track.getTrackTypeName(), track.getLocation().getName(), track.getName(), track.getDivisionName(), car.toString(), car.getLoadType().toLowerCase(), car.getLoadName()));
                continue;
            }
            if (locationsNotServiced.contains(track.getLocation())) continue;
            if (!car.getTrack().isDestinationAccepted(track.getLocation())) {
                TrainBuilder.addLine(this._buildReport, "7", MessageFormat.format(Bundle.getMessage("buildDestinationNotServiced"), track.getLocation().getName(), car.getTrackName()));
                locationsNotServiced.add(track.getLocation());
                continue;
            }
            if (trackType.equals("Staging") && this._terminateStageTrack != null && track.getLocation() == this._terminateLocation && track != this._terminateStageTrack || !(trackType.equals("Spur") ? this.sendCarToDestinationSpur(car, track) : this.sendCarToDestinationTrack(car, track))) continue;
            return true;
        }
        TrainBuilder.addLine(this._buildReport, "7", MessageFormat.format(Bundle.getMessage("buildCouldNotFindTrack"), trackType, car.toString(), car.getLoadName()));
        TrainBuilder.addLine(this._buildReport, "5", " ");
        return false;
    }

    private boolean findFinalDestinationForCarLoad(Car car) throws BuildFailedException {
        if (car.getLoadName().equals(this.carLoads.getDefaultEmptyName()) || car.getLoadName().equals(this.carLoads.getDefaultLoadName()) || car.getDestination() != null || car.getFinalDestination() != null) {
            return false;
        }
        TrainBuilder.addLine(this._buildReport, "5", MessageFormat.format(Bundle.getMessage("buildSearchForSpur"), car.toString(), car.getTypeName(), car.getLoadType().toLowerCase(), car.getLoadName(), car.getLocationName(), car.getTrackName()));
        if (car.getKernel() != null) {
            TrainBuilder.addLine(this._buildReport, "7", MessageFormat.format(Bundle.getMessage("buildCarLeadKernel"), car.toString(), car.getKernelName(), car.getKernel().getSize(), car.getKernel().getTotalLength(), Setup.getLengthUnit().toLowerCase()));
        }
        this._routeToTrackFound = false;
        List<Track> tracks = this.locationManager.getTracksByMoves("Spur");
        log.debug("Found {} spurs", (Object)tracks.size());
        ArrayList<Location> locationsNotServiced = new ArrayList<Location>();
        for (Track track : tracks) {
            if (car.getTrack() == track || track.getSchedule() == null || locationsNotServiced.contains(track.getLocation())) continue;
            if (!car.getTrack().isDestinationAccepted(track.getLocation())) {
                TrainBuilder.addLine(this._buildReport, "7", MessageFormat.format(Bundle.getMessage("buildDestinationNotServiced"), track.getLocation().getName(), car.getTrackName()));
                locationsNotServiced.add(track.getLocation());
                continue;
            }
            if (!this.sendCarToDestinationSpur(car, track)) continue;
            return true;
        }
        TrainBuilder.addLine(this._buildReport, "7", MessageFormat.format(Bundle.getMessage("buildCouldNotFindTrack"), Track.getTrackTypeName("Spur"), car.toString(), car.getLoadName()));
        if (this._routeToTrackFound && !this._train.isSendCarsWithCustomLoadsToStagingEnabled() && !car.getLocation().isStaging()) {
            TrainBuilder.addLine(this._buildReport, "7", MessageFormat.format(Bundle.getMessage("buildHoldCarValidRoute"), car.toString(), car.getLocationName(), car.getTrackName()));
        } else {
            TrainBuilder.addLine(this._buildReport, "5", MessageFormat.format(Bundle.getMessage("buildTrySendCarToStaging"), car.toString(), car.getLoadName()));
            tracks = this.locationManager.getTracks("Staging");
            log.debug("Found {} staging tracks", (Object)tracks.size());
            while (tracks.size() > 0) {
                int rnd = (int)(Math.random() * (double)tracks.size());
                Track track = tracks.get(rnd);
                tracks.remove(track);
                log.debug("Staging track ({}, {})", (Object)track.getLocation().getName(), (Object)track.getName());
                if (track.getLocation() == car.getLocation() || locationsNotServiced.contains(track.getLocation()) || this._terminateStageTrack != null && track.getLocation() == this._terminateLocation && track != this._terminateStageTrack) continue;
                if (!car.getTrack().isDestinationAccepted(track.getLocation())) {
                    TrainBuilder.addLine(this._buildReport, "7", MessageFormat.format(Bundle.getMessage("buildDestinationNotServiced"), track.getLocation().getName(), car.getTrackName()));
                    locationsNotServiced.add(track.getLocation());
                    continue;
                }
                String status = track.isRollingStockAccepted(car);
                if (!status.equals(Track.OKAY) && !status.startsWith(Track.LENGTH)) {
                    log.debug("Staging track ({}) can't accept car ({})", (Object)track.getName(), (Object)car.toString());
                    continue;
                }
                TrainBuilder.addLine(this._buildReport, "7", MessageFormat.format(Bundle.getMessage("buildStagingCanAcceptLoad"), track.getLocation(), track.getName(), car.getLoadName()));
                car.setFinalDestination(track.getLocation());
                if (this.router.setDestination(car, this._train, this._buildReport)) {
                    this._routeToTrackFound = true;
                }
                if (car.getDestination() != null) {
                    car.updateKernel();
                    return true;
                }
                locationsNotServiced.add(track.getLocation());
                car.setFinalDestination(null);
            }
            TrainBuilder.addLine(this._buildReport, "7", MessageFormat.format(Bundle.getMessage("buildNoStagingForCarLoad"), car.toString(), car.getLoadName()));
        }
        log.debug("routeToSpurFound is {}", (Object)this._routeToTrackFound);
        return this._routeToTrackFound;
    }

    private boolean sendCarToDestinationSpur(Car car, Track track) {
        if (!this.checkBasicMoves(car, track)) {
            return false;
        }
        String status = car.testDestination(track.getLocation(), track);
        if (!status.equals(Track.OKAY)) {
            if (track.getScheduleMode() == 0 && status.startsWith(Track.SCHEDULE)) {
                TrainBuilder.addLine(this._buildReport, "7", MessageFormat.format(Bundle.getMessage("buildTrackSequentialMode"), track.getName(), track.getLocation().getName(), status));
            }
            if (!status.startsWith(Track.LENGTH) || !track.checkSchedule(car).equals(Track.OKAY)) {
                TrainBuilder.addLine(this._buildReport, "7", MessageFormat.format(Bundle.getMessage("buildNoDestTrackNewLoad"), track.getLocation().getName(), track.getName(), car.toString(), car.getLoadName(), status));
                return false;
            }
            if (track.getAlternateTrack() == null) {
                TrainBuilder.addLine(this._buildReport, "7", MessageFormat.format(Bundle.getMessage("buildSpurFullNoAlternate"), track.getLocation().getName(), track.getName()));
                return false;
            }
            TrainBuilder.addLine(this._buildReport, "7", MessageFormat.format(Bundle.getMessage("buildTrackFullHasAlternate"), track.getLocation().getName(), track.getName(), track.getAlternateTrack().getName()));
            if (!this._train.isLocalSwitcher() && (track.getTrainDirections() & track.getAlternateTrack().getTrainDirections()) == 0) {
                TrainBuilder.addLine(this._buildReport, "7", MessageFormat.format(Bundle.getMessage("buildCanNotDropRsUsingTrain4"), track.getName(), TrainBuilder.formatStringToCommaSeparated(Setup.getDirectionStrings(track.getTrainDirections())), track.getAlternateTrack().getName(), TrainBuilder.formatStringToCommaSeparated(Setup.getDirectionStrings(track.getAlternateTrack().getTrainDirections()))));
                return false;
            }
        }
        TrainBuilder.addLine(this._buildReport, "7", MessageFormat.format(Bundle.getMessage("buildSetFinalDestination"), car.toString(), car.getLoadName(), track.getLocation().getName(), track.getName()));
        if (track.isHoldCarsWithCustomLoadsEnabled()) {
            TrainBuilder.addLine(this._buildReport, "7", MessageFormat.format(Bundle.getMessage("buildHoldCarsCustom"), track.getLocation().getName(), track.getName()));
        }
        if (!track.isSpaceAvailable(car)) {
            String id = track.getScheduleItemId();
            car.setFinalDestination(track.getLocation());
            car.setFinalDestinationTrack(track);
            if (this.router.setDestination(car, this._train, this._buildReport) && track.isHoldCarsWithCustomLoadsEnabled()) {
                this._routeToTrackFound = true;
            }
            car.setDestination(null, null);
            car.setFinalDestination(null);
            car.setFinalDestinationTrack(null);
            track.setScheduleItemId(id);
            TrainBuilder.addLine(this._buildReport, "7", MessageFormat.format(Bundle.getMessage("buildNoDestTrackSpace"), car.toString(), track.getLocation().getName(), track.getName(), track.getNumberOfCarsInRoute(), track.getReservedInRoute(), Setup.getLengthUnit().toLowerCase(), track.getReservationFactor()));
            return false;
        }
        car.setFinalDestination(track.getLocation());
        car.setFinalDestinationTrack(track);
        if (this.router.setDestination(car, this._train, this._buildReport) && track.isHoldCarsWithCustomLoadsEnabled()) {
            this._routeToTrackFound = true;
        }
        if (car.getDestination() == null) {
            TrainBuilder.addLine(this._buildReport, "7", MessageFormat.format(Bundle.getMessage("buildNotAbleToSetDestination"), car.toString(), this.router.getStatus()));
            car.setFinalDestination(null);
            car.setFinalDestinationTrack(null);
            return false;
        }
        car.updateKernel();
        if (car.getDestinationTrack() != track) {
            if (track.getSchedule() != null) {
                car.setScheduleItemId(track.getCurrentScheduleItem().getId());
                track.bumpSchedule();
            } else {
                track.setMoves(track.getMoves() + 1);
            }
        }
        return true;
    }

    private boolean sendCarToDestinationTrack(Car car, Track track) {
        if (!this.checkBasicMoves(car, track)) {
            return false;
        }
        String status = car.testDestination(track.getLocation(), track);
        if (!status.equals(Track.OKAY)) {
            TrainBuilder.addLine(this._buildReport, "7", MessageFormat.format(Bundle.getMessage("buildNoDestTrackNewLoad"), track.getLocation().getName(), track.getName(), car.toString(), car.getLoadName(), status));
            return false;
        }
        if (!track.isSpaceAvailable(car)) {
            TrainBuilder.addLine(this._buildReport, "7", MessageFormat.format(Bundle.getMessage("buildNoDestSpace"), car.toString(), track.getTrackTypeName(), track.getLocation().getName(), track.getName(), track.getNumberOfCarsInRoute(), track.getReservedInRoute(), Setup.getLengthUnit().toLowerCase()));
            return false;
        }
        TrainBuilder.addLine(this._buildReport, "7", MessageFormat.format(Bundle.getMessage("buildSetFinalDestination"), car.toString(), car.getLoadName(), track.getLocation().getName(), track.getName()));
        car.setFinalDestination(track.getLocation());
        car.setFinalDestinationTrack(track);
        if (this.router.setDestination(car, this._train, this._buildReport)) {
            log.debug("Can route car to destination ({}, {})", (Object)track.getLocation().getName(), (Object)track.getName());
        }
        if (car.getDestination() == null) {
            TrainBuilder.addLine(this._buildReport, "7", MessageFormat.format(Bundle.getMessage("buildNotAbleToSetDestination"), car.toString(), this.router.getStatus()));
            car.setFinalDestination(null);
            car.setFinalDestinationTrack(null);
            return false;
        }
        car.updateKernel();
        return true;
    }

    private boolean checkCarForFinalDestination(Car car) {
        String status;
        if (car.getFinalDestination() == null || car.getDestination() != null) {
            return false;
        }
        TrainBuilder.addLine(this._buildReport, "5", MessageFormat.format(Bundle.getMessage("buildCarRoutingBegins"), car.toString(), car.getTypeName(), car.getLoadName(), car.getLocationName(), car.getTrackName(), car.getFinalDestinationName(), car.getFinalDestinationTrackName()));
        if (!this._train.isAllowLocalMovesEnabled() && TrainBuilder.splitString(car.getLocationName()).equals(TrainBuilder.splitString(car.getFinalDestinationName())) && car.getTrack() != this._departStageTrack) {
            TrainBuilder.addLine(this._buildReport, "5", MessageFormat.format(Bundle.getMessage("buildCarHasFinalDestNoMove"), car.toString(), car.getFinalDestinationName()));
            TrainBuilder.addLine(this._buildReport, "5", " ");
            log.debug("Removing car ({}) from list", (Object)car.toString());
            this._carList.remove(car);
            --this._carIndex;
            return true;
        }
        if (!this.checkThroughCarsAllowed(car, car.getFinalDestinationName())) {
            if (car.getTrack() == this._departStageTrack) {
                TrainBuilder.addLine(this._buildReport, "1", MessageFormat.format(Bundle.getMessage("buildErrorCarStageDest"), car.toString()));
            } else {
                log.debug("Removing car ({}) from list", (Object)car.toString());
                this._carList.remove(car);
                --this._carIndex;
            }
            return true;
        }
        if (!(car.getFinalDestinationTrack() == null || car.getFinalDestinationTrack().getScheduleMode() != 1 || (status = car.testDestination(car.getFinalDestination(), car.getFinalDestinationTrack())).equals(Track.OKAY) || status.startsWith(Track.LENGTH) || status.contains(Track.CUSTOM) && status.contains(Track.LOAD))) {
            TrainBuilder.addLine(this._buildReport, "7", MessageFormat.format(Bundle.getMessage("buildNoDestTrackNewLoad"), car.getFinalDestination().getName(), car.getFinalDestinationTrack().getName(), car.toString(), car.getLoadName(), status));
            if (status.startsWith(Track.CAPACITY)) {
                TrainBuilder.addLine(this._buildReport, "7", MessageFormat.format(Bundle.getMessage("buildTrackTooShort"), car.getFinalDestination().getName(), car.getFinalDestinationTrack().getName(), car.toString()));
            }
            TrainBuilder.addLine(this._buildReport, "7", MessageFormat.format(Bundle.getMessage("buildRemovingFinalDestinaton"), car.getFinalDestination().getName(), car.getFinalDestinationTrack().getName(), car.toString()));
            car.setFinalDestination(null);
            car.setFinalDestinationTrack(null);
            return false;
        }
        if (!this.router.setDestination(car, this._train, this._buildReport)) {
            TrainBuilder.addLine(this._buildReport, "7", MessageFormat.format(Bundle.getMessage("buildNotAbleToSetDestination"), car.toString(), this.router.getStatus()));
            if (!this.router.getStatus().startsWith(Track.LENGTH) && !this._train.isServiceAllCarsWithFinalDestinationsEnabled() || car.getTrack() == this._departStageTrack) {
                if (!this._notRoutable.contains(car)) {
                    this._notRoutable.add(car);
                }
                TrainBuilder.addLine(this._buildReport, "5", " ");
                TrainBuilder.addLine(this._buildReport, "5", MessageFormat.format(Bundle.getMessage("buildWarningCarNotRoutable"), car.toString(), car.getLocationName(), car.getTrackName(), car.getFinalDestinationName(), car.getFinalDestinationTrackName()));
                TrainBuilder.addLine(this._buildReport, "5", " ");
                return false;
            }
        } else {
            if (car.getDestination() != null) {
                return false;
            }
            if (car.getTrack() == this._departStageTrack) {
                log.debug("Car ({}) departing staging with final destination ({}) and no destination", (Object)car.toString(), (Object)car.getFinalDestinationName());
                return false;
            }
        }
        TrainBuilder.addLine(this._buildReport, "5", MessageFormat.format(Bundle.getMessage("buildNoDestForCar"), car.toString()));
        TrainBuilder.addLine(this._buildReport, "5", " ");
        return true;
    }

    private boolean checkCarForDestination(Car car, RouteLocation rl, int routeIndex) throws BuildFailedException {
        if (car.getDestination() == null) {
            return false;
        }
        TrainBuilder.addLine(this._buildReport, "7", MessageFormat.format(Bundle.getMessage("buildCarHasAssignedDest"), car.toString(), car.getLoadName(), car.getDestinationName(), car.getDestinationTrackName()));
        RouteLocation rld = this._train.getRoute().getLastLocationByName(car.getDestinationName());
        if (rld == null) {
            throw new BuildFailedException(MessageFormat.format(Bundle.getMessage("buildExcludeCarDestNotPartRoute"), car.toString(), car.getDestinationName(), this._train.getRoute().getName()));
        }
        int k = routeIndex;
        while (k < this._routeList.size()) {
            block16: {
                block22: {
                    String status;
                    block20: {
                        block21: {
                            block19: {
                                block18: {
                                    block17: {
                                        rld = (RouteLocation)this._routeList.get(k);
                                        if (this.checkForLaterPickUp(car, rl, rld)) {
                                            return true;
                                        }
                                        if (!rld.getName().equals(car.getDestinationName())) break block16;
                                        if (!this.checkThroughCarsAllowed(car, car.getDestinationName())) {
                                            return true;
                                        }
                                        log.debug("Car ({}) found a destination in train's route", (Object)car.toString());
                                        if (rld.isDropAllowed()) break block17;
                                        TrainBuilder.addLine(this._buildReport, "5", MessageFormat.format(Bundle.getMessage("buildRouteNoDropLocation"), this._train.getRoute().getName(), rld.getName(), rld.getId()));
                                        break block16;
                                    }
                                    if (!this._train.isLocationSkipped(rld.getId())) break block18;
                                    TrainBuilder.addLine(this._buildReport, "5", MessageFormat.format(Bundle.getMessage("buildLocSkipped"), rld.getName(), rld.getId(), this._train.getName()));
                                    break block16;
                                }
                                if (rld.getCarMoves() < rld.getMaxCarMoves()) break block19;
                                TrainBuilder.addLine(this._buildReport, "5", MessageFormat.format(Bundle.getMessage("buildNoAvailableMovesDest"), rld.getCarMoves(), rld.getMaxCarMoves(), this._train.getRoute().getName(), rld.getId(), rld.getName()));
                                break block16;
                            }
                            if (!this.checkTrainLength(car, rl, rld)) break block16;
                            if (car.getDestinationTrack() != null) break block20;
                            TrainBuilder.addLine(this._buildReport, "5", MessageFormat.format(Bundle.getMessage("buildCarDoesNotHaveDest"), car.toString()));
                            if (rld != this._train.getTrainTerminatesRouteLocation() || this._terminateStageTrack == null) break block21;
                            status = car.testDestination(car.getDestination(), this._terminateStageTrack);
                            if (status.equals(Track.OKAY)) {
                                TrainBuilder.addLine(this._buildReport, "5", MessageFormat.format(Bundle.getMessage("buildCarAssignedToStaging"), car.toString(), this._terminateStageTrack.getName()));
                                this.addCarToTrain(car, rl, rld, this._terminateStageTrack);
                                return true;
                            }
                            TrainBuilder.addLine(this._buildReport, "7", MessageFormat.format(Bundle.getMessage("buildCanNotDropCarBecause"), car.toString(), this._terminateStageTrack.getName(), status, this._terminateStageTrack.getTrackTypeName()));
                            break block16;
                        }
                        List<Track> tracks = this.findTrackAtDestination(car, rld);
                        if (tracks.size() > 0) {
                            if (tracks.get(1) != null) {
                                car.setFinalDestination(car.getDestination());
                                car.setFinalDestinationTrack(tracks.get(1));
                                tracks.get(1).setMoves(tracks.get(1).getMoves() + 1);
                            }
                            this.addCarToTrain(car, rl, rld, tracks.get(0));
                            return true;
                        }
                        break block22;
                    }
                    log.debug("Car ({}) has a destination track ({})", (Object)car.toString(), (Object)car.getDestinationTrack().getName());
                    if (rld.equals(this._train.getTrainTerminatesRouteLocation()) && this._terminateStageTrack != null && this._terminateStageTrack != car.getDestinationTrack()) {
                        TrainBuilder.addLine(this._buildReport, "7", MessageFormat.format(Bundle.getMessage("buildCarDestinationStaging"), car.toString(), car.getDestinationName(), car.getDestinationTrackName()));
                        car.setDestination(this._terminateStageTrack.getLocation(), this._terminateStageTrack);
                    }
                    if (!rld.equals(this._train.getTrainTerminatesRouteLocation()) || this._terminateStageTrack == null || this._terminateStageTrack == car.getDestinationTrack()) {
                        if (this.checkDropTrainDirection(car, rld, car.getDestinationTrack()) && this.checkTrainCanDrop(car, car.getDestinationTrack())) {
                            status = car.testDestination(car.getDestination(), car.getDestinationTrack());
                            if (status.equals(Track.OKAY)) {
                                this.addCarToTrain(car, rl, rld, car.getDestinationTrack());
                                return true;
                            }
                            TrainBuilder.addLine(this._buildReport, "7", MessageFormat.format(Bundle.getMessage("buildCanNotDropCarBecause"), car.toString(), car.getDestinationTrackName(), status, car.getDestinationTrack().getTrackTypeName()));
                        }
                    } else {
                        throw new BuildFailedException(MessageFormat.format(Bundle.getMessage("buildCarDestinationStaging"), car.toString(), car.getDestinationName(), car.getDestinationTrackName()));
                    }
                }
                TrainBuilder.addLine(this._buildReport, "5", MessageFormat.format(Bundle.getMessage("buildCanNotDropCar"), car.toString(), car.getDestinationName(), rld.getId()));
                if (car.getDestinationTrack() == null) {
                    log.debug("Could not find a destination track for location ({})", (Object)car.getDestinationName());
                }
            }
            ++k;
        }
        log.debug("car ({}) not added to train", (Object)car.toString());
        TrainBuilder.addLine(this._buildReport, "5", MessageFormat.format(Bundle.getMessage("buildDestinationNotReachable"), car.getDestinationName(), rl.getName(), rl.getId()));
        if (car.getDestinationTrack() != null) {
            car.getDestinationTrack().setMoves(car.getDestinationTrack().getMoves() - 1);
            Track destTrack = car.getDestinationTrack();
            if (destTrack.getSchedule() != null && destTrack.getScheduleMode() == 0) {
                TrainBuilder.addLine(this._buildReport, "7", MessageFormat.format(Bundle.getMessage("buildPickupCancelled"), destTrack.getLocation().getName(), destTrack.getName()));
            }
        }
        car.setFinalDestination(car.getPreviousFinalDestination());
        car.setFinalDestinationTrack(car.getPreviousFinalDestinationTrack());
        car.setDestination(null, null);
        car.updateKernel();
        TrainBuilder.addLine(this._buildReport, "5", MessageFormat.format(Bundle.getMessage("buildNoDestForCar"), car.toString()));
        TrainBuilder.addLine(this._buildReport, "5", " ");
        return true;
    }

    private boolean findDestinationAndTrack(Car car, RouteLocation rl, RouteLocation rld) throws BuildFailedException {
        int index = this._routeList.indexOf(rld);
        if (this._train.isLocalSwitcher()) {
            return this.findDestinationAndTrack(car, rl, index, index + 1);
        }
        return this.findDestinationAndTrack(car, rl, index - 1, index + 1);
    }

    private boolean findDestinationAndTrack(Car car, RouteLocation rl, int routeIndex, int routeEnd) throws BuildFailedException {
        if (routeIndex + 1 == routeEnd) {
            log.debug("Car ({}) is at the last location in the train's route", (Object)car.toString());
        }
        TrainBuilder.addLine(this._buildReport, "5", MessageFormat.format(Bundle.getMessage("buildFindDestinationForCar"), car.toString(), car.getTypeName(), car.getLoadType().toLowerCase(), car.getLoadName(), String.valueOf(car.getLocationName()) + ", " + car.getTrackName()));
        if (car.getKernel() != null) {
            TrainBuilder.addLine(this._buildReport, "7", MessageFormat.format(Bundle.getMessage("buildCarLeadKernel"), car.toString(), car.getKernelName(), car.getKernel().getSize(), car.getKernel().getTotalLength(), Setup.getLengthUnit().toLowerCase()));
        }
        int start = routeIndex;
        RouteLocation rld = null;
        RouteLocation rldSave = null;
        Track trackSave = null;
        Track finalDestinationTrackSave = null;
        boolean multiplePickup = false;
        if (!this._train.isLocalSwitcher()) {
            ++start;
        }
        if (this._train.isSendCarsToTerminalEnabled() && !TrainBuilder.splitString(rl.getName()).equals(TrainBuilder.splitString(this._departLocation.getName())) && routeEnd == this._routeList.size()) {
            TrainBuilder.addLine(this._buildReport, "5", MessageFormat.format(Bundle.getMessage("buildSendToTerminal"), this._terminateLocation.getName()));
            start = routeEnd - 1;
            while (start > routeIndex) {
                if (!TrainBuilder.splitString(((RouteLocation)this._routeList.get(start - 1)).getName()).equals(TrainBuilder.splitString(this._terminateLocation.getName()))) break;
                --start;
            }
        }
        int k = start;
        while (k < routeEnd) {
            block24: {
                Track finalDestinationTrackTemp;
                Track trackTemp;
                block32: {
                    block31: {
                        block30: {
                            Location testDestination;
                            block29: {
                                block27: {
                                    block28: {
                                        block26: {
                                            block25: {
                                                block23: {
                                                    rld = (RouteLocation)this._routeList.get(k);
                                                    if (this.checkForLaterPickUp(car, rl, rld)) {
                                                        multiplePickup = true;
                                                    }
                                                    if (rld.isDropAllowed() || car.hasFred() || car.isCaboose()) break block23;
                                                    TrainBuilder.addLine(this._buildReport, "7", MessageFormat.format(Bundle.getMessage("buildRouteNoDropLocation"), this._train.getRoute().getName(), rld.getId(), rld.getName()));
                                                    break block24;
                                                }
                                                TrainBuilder.addLine(this._buildReport, "7", MessageFormat.format(Bundle.getMessage("buildSearchingLocation"), rld.getName(), rld.getId()));
                                                if (!this._train.isLocationSkipped(rld.getId())) break block25;
                                                TrainBuilder.addLine(this._buildReport, "5", MessageFormat.format(Bundle.getMessage("buildLocSkipped"), rld.getName(), rld.getId(), this._train.getName()));
                                                break block24;
                                            }
                                            if (rld.getCarMoves() < rld.getMaxCarMoves()) break block26;
                                            TrainBuilder.addLine(this._buildReport, "5", MessageFormat.format(Bundle.getMessage("buildNoAvailableMovesDest"), rld.getCarMoves(), rld.getMaxCarMoves(), this._train.getRoute().getName(), rld.getId(), rld.getName()));
                                            break block24;
                                        }
                                        testDestination = rld.getLocation();
                                        if (testDestination == null) {
                                            throw new BuildFailedException(MessageFormat.format(Bundle.getMessage("buildErrorRouteLoc"), this._train.getRoute().getName(), rld.getName()));
                                        }
                                        if (!TrainBuilder.splitString(rl.getName()).equals(TrainBuilder.splitString(rld.getName())) || this._train.isLocalSwitcher() || car.isPassenger() || car.isCaboose() || car.hasFred()) break block27;
                                        if ((this._train.isAllowReturnToStagingEnabled() || Setup.isStagingAllowReturnEnabled()) && testDestination.isStaging() && trackSave == null) break block28;
                                        TrainBuilder.addLine(this._buildReport, "7", MessageFormat.format(Bundle.getMessage("buildCarLocEqualDestination"), car.toString(), rld.getName()));
                                        break block24;
                                    }
                                    TrainBuilder.addLine(this._buildReport, "7", MessageFormat.format(Bundle.getMessage("buildReturnCarToStaging"), car.toString(), rld.getName()));
                                }
                                if (car.getTrack().isDestinationAccepted(testDestination)) break block29;
                                TrainBuilder.addLine(this._buildReport, "7", MessageFormat.format(Bundle.getMessage("buildDestinationNotServiced"), testDestination.getName(), car.getTrackName()));
                                break block24;
                            }
                            if (testDestination.acceptsTypeName(car.getTypeName())) break block30;
                            TrainBuilder.addLine(this._buildReport, "7", MessageFormat.format(Bundle.getMessage("buildCanNotDropLocation"), car.toString(), car.getTypeName(), testDestination.getName()));
                            break block24;
                        }
                        if (!this.checkDropTrainDirection(rld)) break block24;
                        if (!this.checkTrainLength(car, rl, rld)) break;
                        if (!this.checkThroughCarsAllowed(car, rld.getName())) break block24;
                        trackTemp = null;
                        finalDestinationTrackTemp = null;
                        if (rld != this._train.getTrainTerminatesRouteLocation() || this._terminateStageTrack == null) break block31;
                        trackTemp = this.tryStaging(car, rldSave);
                        if (trackTemp != null) break block32;
                        break block24;
                    }
                    List<Track> tracks = this.findTrackAtDestination(car, rld);
                    if (tracks.size() > 0) {
                        trackTemp = tracks.get(0);
                        finalDestinationTrackTemp = tracks.get(1);
                    }
                }
                if (trackTemp == null) {
                    TrainBuilder.addLine(this._buildReport, "5", MessageFormat.format(Bundle.getMessage("buildCouldNotFindDestForCar"), car.toString(), rld.getName()));
                } else {
                    TrainBuilder.addLine(this._buildReport, "5", MessageFormat.format(Bundle.getMessage("buildCarCanDropMoves"), car.toString(), trackTemp.getTrackTypeName(), trackTemp.getLocation().getName(), trackTemp.getName(), rld.getCarMoves(), rld.getMaxCarMoves()));
                    if (rldSave == null && multiplePickup) {
                        TrainBuilder.addLine(this._buildReport, "5", MessageFormat.format(Bundle.getMessage("buildCarHasSecond"), car.toString(), car.getLocationName()));
                        trackSave = null;
                        break;
                    }
                    if (rldSave != null) {
                        rld = this.checkForEarlierDrop(car, trackTemp, rld, start, routeEnd);
                        double saveCarMoves = rldSave.getCarMoves();
                        double saveRatio = saveCarMoves / (double)rldSave.getMaxCarMoves();
                        double nextCarMoves = rld.getCarMoves();
                        double nextRatio = nextCarMoves / (double)rld.getMaxCarMoves();
                        if (rld == this._train.getTrainTerminatesRouteLocation()) {
                            nextRatio *= nextRatio;
                            log.debug("Location ({}) is terminate location, adjusted nextRatio {}", (Object)rld.getName(), (Object)Double.toString(nextRatio));
                        } else if (!trackTemp.getScheduleId().equals("")) {
                            nextRatio *= nextRatio;
                            log.debug("Track ({}) has schedule ({}), adjusted nextRatio {}", new Object[]{trackTemp.getName(), trackTemp.getScheduleName(), Double.toString(nextRatio)});
                        }
                        if (trackSave != null && !trackSave.getScheduleId().equals("")) {
                            saveRatio *= saveRatio;
                            log.debug("Saved track ({}) has schedule ({}), adjusted nextRatio {}", new Object[]{trackSave.getName(), trackSave.getScheduleName(), Double.toString(saveRatio)});
                        }
                        log.debug("Saved {} = {}, {} = {}", new Object[]{rldSave.getName(), Double.toString(saveRatio), rld.getName(), Double.toString(nextRatio)});
                        if (saveRatio < nextRatio) {
                            rld = rldSave;
                            trackTemp = trackSave;
                            finalDestinationTrackTemp = finalDestinationTrackSave;
                        } else if (multiplePickup) {
                            TrainBuilder.addLine(this._buildReport, "5", MessageFormat.format(Bundle.getMessage("buildCarHasSecond"), car.toString(), car.getLocationName()));
                            trackSave = null;
                            break;
                        }
                    }
                    rldSave = rld;
                    trackSave = trackTemp;
                    finalDestinationTrackSave = finalDestinationTrackTemp;
                }
            }
            ++k;
        }
        if (trackSave != null) {
            if (finalDestinationTrackSave != null) {
                car.setFinalDestination(finalDestinationTrackSave.getLocation());
                car.setFinalDestinationTrack(finalDestinationTrackSave);
                if (trackSave.isAlternate()) {
                    finalDestinationTrackSave.setMoves(finalDestinationTrackSave.getMoves() + 1);
                }
            }
            this.addCarToTrain(car, rl, rldSave, trackSave);
            return true;
        }
        TrainBuilder.addLine(this._buildReport, "5", MessageFormat.format(Bundle.getMessage("buildNoDestForCar"), car.toString()));
        TrainBuilder.addLine(this._buildReport, "5", " ");
        return false;
    }

    private void showTrainBuildStatus() {
        if (this._numberCars < this._train.getNumberCarsRequested()) {
            this._train.setStatusCode(20);
            TrainBuilder.addLine(this._buildReport, "1", String.valueOf(Train.PARTIAL_BUILT) + " " + this._train.getNumberCarsWorked() + "/" + this._train.getNumberCarsRequested() + " " + Bundle.getMessage("cars"));
        } else {
            this._train.setStatusCode(16);
            TrainBuilder.addLine(this._buildReport, "1", String.valueOf(Train.BUILT) + " " + this._train.getNumberCarsWorked() + " " + Bundle.getMessage("cars"));
        }
    }

    private void checkEngineHP() throws BuildFailedException {
        if (Setup.getHorsePowerPerTon() != 0) {
            if (this._train.getNumberEngines().equals(Train.AUTO_HPT)) {
                this.checkEngineHP(this._train.getLeadEngine(), this._train.getEngineModel(), this._train.getEngineRoad());
            }
            if ((this._train.getSecondLegOptions() & 1) == 1 && this._train.getSecondLegNumberEngines().equals(Train.AUTO_HPT)) {
                this.checkEngineHP(this._secondLeadEngine, this._train.getSecondLegEngineModel(), this._train.getSecondLegEngineRoad());
            }
            if ((this._train.getThirdLegOptions() & 1) == 1 && this._train.getThirdLegNumberEngines().equals(Train.AUTO_HPT)) {
                this.checkEngineHP(this._thirdLeadEngine, this._train.getThirdLegEngineModel(), this._train.getThirdLegEngineRoad());
            }
        }
    }

    private void checkEngineHP(Engine leadEngine, String model, String road) throws BuildFailedException {
        if (leadEngine == null) {
            throw new BuildFailedException("ERROR coding issue, engine missing from checkEngineHP()");
        }
        if (leadEngine.getRouteLocation() == this._train.getTrainDepartsRouteLocation() && this._departStageTrack != null) {
            return;
        }
        TrainBuilder.addLine(this._buildReport, "1", " ");
        TrainBuilder.addLine(this._buildReport, "1", MessageFormat.format(Bundle.getMessage("buildDetermineHpNeeded"), leadEngine.toString(), leadEngine.getLocationName(), leadEngine.getDestinationName(), this._train.getTrainHorsePower(leadEngine.getRouteLocation()), Setup.getHorsePowerPerTon()));
        int hpNeeded = 0;
        int hpAvailable = 0;
        Route route = this._train.getRoute();
        if (route != null) {
            boolean helper = false;
            boolean foundStart = false;
            for (RouteLocation rl : route.getLocationsBySequenceList()) {
                if (!foundStart && rl != leadEngine.getRouteLocation()) continue;
                foundStart = true;
                if (this._train.getSecondLegOptions() == 2 && rl == this._train.getSecondLegStartRouteLocation() || this._train.getThirdLegOptions() == 2 && rl == this._train.getThirdLegStartRouteLocation()) {
                    TrainBuilder.addLine(this._buildReport, "5", MessageFormat.format(Bundle.getMessage("AddHelpersAt"), rl.getName()));
                    helper = true;
                }
                if (this._train.getSecondLegOptions() == 2 && rl == this._train.getSecondLegEndRouteLocation() || this._train.getThirdLegOptions() == 2 && rl == this._train.getThirdLegEndRouteLocation()) {
                    TrainBuilder.addLine(this._buildReport, "5", MessageFormat.format(Bundle.getMessage("RemoveHelpersAt"), rl.getName()));
                    helper = false;
                }
                if (helper) continue;
                if (rl == leadEngine.getRouteDestination()) {
                    log.debug("Remove loco ({}) at ({})", (Object)leadEngine.toString(), (Object)rl.getName());
                    break;
                }
                if (this._train.getTrainHorsePower(rl) > hpAvailable) {
                    hpAvailable = this._train.getTrainHorsePower(rl);
                }
                int weight = rl.getTrainWeight();
                int hpRequired = (int)(36.0 * rl.getGrade() / 12.0 * (double)weight);
                if (hpRequired < Setup.getHorsePowerPerTon() * weight) {
                    hpRequired = Setup.getHorsePowerPerTon() * weight;
                }
                if (hpRequired <= hpNeeded) continue;
                TrainBuilder.addLine(this._buildReport, "7", MessageFormat.format(Bundle.getMessage("buildReportTrainHpNeeds"), weight, this._train.getNumberCarsInTrain(rl), rl.getGrade(), rl.getName(), rl.getId(), hpRequired));
                hpNeeded = hpRequired;
            }
        }
        if (hpNeeded > hpAvailable) {
            TrainBuilder.addLine(this._buildReport, "1", MessageFormat.format(Bundle.getMessage("buildAssignedHpNotEnough"), leadEngine.toString(), hpAvailable, hpNeeded));
            this.findNewEngine(hpNeeded, leadEngine, model, road);
        } else if (hpAvailable > 2 * hpNeeded) {
            TrainBuilder.addLine(this._buildReport, "1", MessageFormat.format(Bundle.getMessage("buildAssignedHpTooMuch"), leadEngine.toString(), hpAvailable, hpNeeded));
            this.findNewEngine(hpNeeded, leadEngine, model, road);
        } else {
            log.debug("Keeping engine ({}) it meets the train's HP requirement", (Object)leadEngine.toString());
        }
    }

    private void checkNumnberOfEnginesNeededHPT() throws BuildFailedException {
        if (this._train.getNumberEngines().equals("0") || !this._train.isBuildConsistEnabled() || Setup.getHorsePowerPerTon() == 0) {
            return;
        }
        TrainBuilder.addLine(this._buildReport, "1", " ");
        TrainBuilder.addLine(this._buildReport, "1", MessageFormat.format(Bundle.getMessage("buildDetermineNeeds"), Setup.getHorsePowerPerTon()));
        Route route = this._train.getRoute();
        int hpAvailable = 0;
        int extraHpNeeded = 0;
        RouteLocation rlNeedHp = null;
        RouteLocation rlStart = this._train.getTrainDepartsRouteLocation();
        RouteLocation rlEnd = this._train.getTrainTerminatesRouteLocation();
        if (route != null) {
            boolean helper = false;
            for (RouteLocation rl : route.getLocationsBySequenceList()) {
                int weight;
                if (this._train.getSecondLegOptions() == 2 && rl == this._train.getSecondLegStartRouteLocation() || this._train.getThirdLegOptions() == 2 && rl == this._train.getThirdLegStartRouteLocation()) {
                    TrainBuilder.addLine(this._buildReport, "5", MessageFormat.format(Bundle.getMessage("AddHelpersAt"), rl.getName()));
                    helper = true;
                }
                if (this._train.getSecondLegOptions() == 2 && rl == this._train.getSecondLegEndRouteLocation() || this._train.getThirdLegOptions() == 2 && rl == this._train.getThirdLegEndRouteLocation()) {
                    TrainBuilder.addLine(this._buildReport, "5", MessageFormat.format(Bundle.getMessage("RemoveHelpersAt"), rl.getName()));
                    helper = false;
                }
                if (helper) continue;
                if ((this._train.getSecondLegOptions() & 1) == 1 && rl == this._train.getSecondLegStartRouteLocation() || (this._train.getThirdLegOptions() & 1) == 1 && rl == this._train.getThirdLegStartRouteLocation()) {
                    log.debug("Loco change at ({})", (Object)rl.getName());
                    this.addLocosBasedHPT(hpAvailable, extraHpNeeded, rlNeedHp, rlStart, rl);
                    TrainBuilder.addLine(this._buildReport, "3", " ");
                    rlStart = rl;
                    rlNeedHp = null;
                    extraHpNeeded = 0;
                }
                if ((weight = rl.getTrainWeight()) <= 0) continue;
                double hptMinimum = Setup.getHorsePowerPerTon();
                double hptGrade = 36.0 * rl.getGrade() / 12.0;
                int hp = this._train.getTrainHorsePower(rl);
                int hpt = hp / weight;
                if (hptGrade > hptMinimum) {
                    hptMinimum = hptGrade;
                }
                if (!(hptMinimum > (double)hpt)) continue;
                int addHp = (int)(hptMinimum * (double)weight - (double)hp);
                if (addHp > extraHpNeeded) {
                    hpAvailable = hp;
                    extraHpNeeded = addHp;
                    rlNeedHp = rl;
                }
                TrainBuilder.addLine(this._buildReport, "7", MessageFormat.format(Bundle.getMessage("buildAddLocosStatus"), weight, hp, rl.getGrade(), hpt, hptMinimum, rl.getName(), rl.getId()));
                TrainBuilder.addLine(this._buildReport, "5", MessageFormat.format(Bundle.getMessage("buildTrainRequiresAddHp"), addHp, rl.getName(), hptMinimum));
            }
        }
        this.addLocosBasedHPT(hpAvailable, extraHpNeeded, rlNeedHp, rlStart, rlEnd);
        TrainBuilder.addLine(this._buildReport, "7", MessageFormat.format(Bundle.getMessage("buildDoneAssingEnginesTrain"), this._train.getName()));
        TrainBuilder.addLine(this._buildReport, "3", " ");
    }

    private void createManifests() throws BuildFailedException {
        new TrainManifest(this._train);
        try {
            new JsonManifest(this._train).build();
        }
        catch (IOException ex) {
            log.error("Unable to create JSON manifest: {}", (Object)ex.getLocalizedMessage());
            throw new BuildFailedException(ex);
        }
        new TrainCsvManifest(this._train);
    }

    private void showWarningMessage() {
        if (this.trainManager.isBuildMessagesEnabled() && this._warnings > 0) {
            JOptionPane.showMessageDialog(null, MessageFormat.format(Bundle.getMessage("buildCheckReport"), this._train.getName(), this._train.getDescription()), MessageFormat.format(Bundle.getMessage("buildWarningMsg"), this._train.getName(), this._warnings), 2);
        }
    }

    private void buildFailed(BuildFailedException e) {
        String msg = e.getMessage();
        this._train.setBuildFailedMessage(msg);
        this._train.setStatusCode(2);
        this._train.setBuildFailed(true);
        log.debug(msg);
        if (this.trainManager.isBuildMessagesEnabled()) {
            String trainName = this._train.getName();
            String trainDescription = this._train.getDescription();
            if (e.getExceptionType().equals("normal")) {
                JOptionPane.showMessageDialog(null, msg, MessageFormat.format(Bundle.getMessage("buildErrorMsg"), trainName, trainDescription), 0);
            } else {
                Object[] options = new Object[]{Bundle.getMessage("buttonRemoveCars"), Bundle.getMessage("ButtonOK")};
                int results = JOptionPane.showOptionDialog(null, msg, MessageFormat.format(Bundle.getMessage("buildErrorMsg"), trainName, trainDescription), -1, 0, null, options, options[1]);
                if (results == 0) {
                    log.debug("User requested that cars be removed from staging track");
                    this.removeCarsFromStaging();
                }
            }
            int size = this.carManager.getList(this._train).size();
            if (size > 0) {
                if (JOptionPane.showConfirmDialog(null, MessageFormat.format(Bundle.getMessage("buildCarsResetTrain"), size, trainName), Bundle.getMessage("buildResetTrain"), 0) == 0) {
                    this._train.reset();
                }
            } else {
                size = this.engineManager.getList(this._train).size();
                if (size > 0 && JOptionPane.showConfirmDialog(null, MessageFormat.format(Bundle.getMessage("buildEnginesResetTrain"), size, trainName), Bundle.getMessage("buildResetTrain"), 0) == 0) {
                    this._train.reset();
                }
            }
        }
        if (this._buildReport != null) {
            TrainBuilder.addLine(this._buildReport, "1", msg);
            TrainBuilder.addLine(this._buildReport, "1", MessageFormat.format(Bundle.getMessage("buildFailedMsg"), this._train.getName()));
            this._buildReport.flush();
            this._buildReport.close();
        }
    }
}

