/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.operations.trains;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Locale;
import jmri.InstanceManager;
import jmri.jmrit.operations.locations.Track;
import jmri.jmrit.operations.rollingstock.cars.Car;
import jmri.jmrit.operations.rollingstock.engines.Engine;
import jmri.jmrit.operations.routes.RouteLocation;
import jmri.jmrit.operations.setup.Setup;
import jmri.jmrit.operations.trains.Train;
import jmri.jmrit.operations.trains.TrainCommon;
import jmri.jmrit.operations.trains.TrainManagerXml;
import jmri.server.json.operations.JsonUtil;
import org.apache.commons.text.StringEscapeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonManifest
extends TrainCommon {
    protected final Locale locale = Locale.getDefault();
    protected final Train train;
    private final ObjectMapper mapper = new ObjectMapper();
    private final JsonUtil utilities = new JsonUtil(this.mapper);
    private static final Logger log = LoggerFactory.getLogger(JsonManifest.class);

    public JsonManifest(Train train) {
        this.train = train;
        this.mapper.enable(SerializationFeature.INDENT_OUTPUT);
    }

    public File getFile() {
        return InstanceManager.getDefault(TrainManagerXml.class).getManifestFile(this.train.getName(), "json");
    }

    public void build() throws IOException {
        ObjectNode root = this.mapper.createObjectNode();
        if (!this.train.getRailroadName().equals("")) {
            root.put("railroad", StringEscapeUtils.escapeHtml4((String)this.train.getRailroadName()));
        } else {
            root.put("railroad", StringEscapeUtils.escapeHtml4((String)Setup.getRailroadName()));
        }
        root.put("userName", StringEscapeUtils.escapeHtml4((String)this.train.getName()));
        root.put("description", StringEscapeUtils.escapeHtml4((String)this.train.getDescription()));
        root.set("locations", (JsonNode)this.getLocations());
        if (!this.train.getManifestLogoPathName().equals("")) {
            root.put("image", this.train.getManifestLogoPathName());
        }
        root.put("date", TrainCommon.getISO8601Date(true));
        this.mapper.writeValue(InstanceManager.getDefault(TrainManagerXml.class).createManifestFile(this.train.getName(), "json"), (Object)root);
    }

    public ArrayNode getLocations() {
        List<Engine> engineList = this.engineManager.getByTrainBlockingList(this.train);
        List<Car> carList = this.carManager.getByTrainDestinationList(this.train);
        ArrayNode locations = this.mapper.createArrayNode();
        List<RouteLocation> route = this.train.getRoute().getLocationsBySequenceList();
        for (RouteLocation routeLocation : route) {
            ArrayNode options;
            String locationName = JsonManifest.splitString(routeLocation.getName());
            ObjectNode jsonLocation = this.mapper.createObjectNode();
            ObjectNode jsonCars = this.mapper.createObjectNode();
            jsonLocation.put("userName", StringEscapeUtils.escapeHtml4((String)locationName));
            jsonLocation.put("name", routeLocation.getId());
            if (routeLocation != this.train.getTrainDepartsRouteLocation()) {
                jsonLocation.put("arrivalTime", this.train.getExpectedArrivalTime(routeLocation));
            }
            if (routeLocation == this.train.getTrainDepartsRouteLocation()) {
                jsonLocation.put("departureTime", this.train.getDepartureTime());
            } else if (!routeLocation.getDepartureTime().equals("")) {
                jsonLocation.put("departureTime", routeLocation.getDepartureTime());
            } else {
                jsonLocation.put("expectedDepartureTime", this.train.getExpectedDepartureTime(routeLocation));
            }
            ObjectNode locationNode = this.mapper.createObjectNode();
            locationNode.put("comment", StringEscapeUtils.escapeHtml4((String)routeLocation.getLocation().getComment()));
            locationNode.put("name", routeLocation.getLocation().getId());
            jsonLocation.set("location", (JsonNode)locationNode);
            jsonLocation.put("comment", StringEscapeUtils.escapeHtml4((String)routeLocation.getComment()));
            if (this.train.getSecondLegOptions() != 0) {
                options = this.mapper.createArrayNode();
                if (routeLocation == this.train.getSecondLegStartRouteLocation()) {
                    if ((this.train.getSecondLegOptions() & 2) == 2) {
                        options.add("addHelpers");
                    } else if ((this.train.getSecondLegOptions() & 8) == 8 || (this.train.getSecondLegOptions() & 4) == 4) {
                        options.add("changeCaboose");
                    } else if ((this.train.getSecondLegOptions() & 1) == 1) {
                        options.add("changeEngines");
                    }
                }
                if (routeLocation == this.train.getSecondLegEndRouteLocation()) {
                    options.add("removeHelpers");
                }
                jsonLocation.set("options", (JsonNode)options);
            }
            if (this.train.getThirdLegOptions() != 0) {
                options = this.mapper.createArrayNode();
                if (routeLocation == this.train.getThirdLegStartRouteLocation()) {
                    if ((this.train.getThirdLegOptions() & 2) == 2) {
                        options.add("addHelpers");
                    } else if ((this.train.getThirdLegOptions() & 8) == 8 || (this.train.getThirdLegOptions() & 4) == 4) {
                        options.add("changeCaboose");
                    } else if ((this.train.getThirdLegOptions() & 1) == 1) {
                        options.add("changeEngines");
                    }
                }
                if (routeLocation == this.train.getThirdLegEndRouteLocation()) {
                    options.add("addHelpers");
                }
                jsonLocation.set("options", (JsonNode)options);
            }
            ObjectNode engines = this.mapper.createObjectNode();
            engines.set("add", (JsonNode)this.pickupEngines(engineList, routeLocation));
            engines.set("remove", (JsonNode)this.dropEngines(engineList, routeLocation));
            jsonLocation.set("engines", (JsonNode)engines);
            ArrayNode pickups = this.mapper.createArrayNode();
            for (RouteLocation destination : route) {
                for (Car car : carList) {
                    if (car.getRouteLocation() != routeLocation || car.getRouteDestination() != destination) continue;
                    pickups.add((JsonNode)this.utilities.getCar(car, this.locale));
                }
            }
            jsonCars.set("add", (JsonNode)pickups);
            ArrayNode setouts = this.mapper.createArrayNode();
            for (Car car3 : carList) {
                if (car3.getRouteDestination() != routeLocation) continue;
                setouts.add((JsonNode)this.utilities.getCar(car3, this.locale));
            }
            jsonCars.set("remove", (JsonNode)setouts);
            if (routeLocation != this.train.getTrainTerminatesRouteLocation()) {
                jsonLocation.set("track", (JsonNode)this.getTrackComments(routeLocation, carList));
                jsonLocation.put("trainDirection", routeLocation.getTrainDirection());
                ObjectNode length = this.mapper.createObjectNode();
                length.put("length", this.train.getTrainLength(routeLocation));
                length.put("unit", Setup.getLengthUnit());
                jsonLocation.set("length", (JsonNode)length);
                jsonLocation.put("weight", this.train.getTrainWeight(routeLocation));
                int n = this.train.getNumberCarsInTrain(routeLocation);
                int emptyCars = this.train.getNumberEmptyCarsInTrain(routeLocation);
                jsonCars.put("total", n);
                jsonCars.put("loads", n - emptyCars);
                jsonCars.put("empties", emptyCars);
            } else {
                log.debug("Train terminates in {}", (Object)locationName);
                jsonLocation.put("TrainTerminatesIn", StringEscapeUtils.escapeHtml4((String)locationName));
            }
            jsonLocation.set("cars", (JsonNode)jsonCars);
            locations.add((JsonNode)jsonLocation);
        }
        return locations;
    }

    protected ArrayNode dropEngines(List<Engine> engines, RouteLocation routeLocation) {
        ArrayNode node = this.mapper.createArrayNode();
        for (Engine engine : engines) {
            if (engine.getRouteDestination() == null || !engine.getRouteDestination().equals(routeLocation)) continue;
            node.add((JsonNode)this.utilities.getEngine(engine, this.locale));
        }
        return node;
    }

    protected ArrayNode pickupEngines(List<Engine> engines, RouteLocation routeLocation) {
        ArrayNode node = this.mapper.createArrayNode();
        for (Engine engine : engines) {
            if (engine.getRouteLocation() == null || !engine.getRouteLocation().equals(routeLocation)) continue;
            node.add((JsonNode)this.utilities.getEngine(engine, this.locale));
        }
        return node;
    }

    private ObjectNode getTrackComments(RouteLocation routeLocation, List<Car> cars) {
        ObjectNode comments = this.mapper.createObjectNode();
        if (routeLocation.getLocation() != null) {
            List<Track> tracks = routeLocation.getLocation().getTracksByNameList(null);
            for (Track track : tracks) {
                ObjectNode jsonTrack = this.mapper.createObjectNode();
                boolean pickup = false;
                boolean setout = false;
                for (Car car : cars) {
                    if (car.getRouteLocation() == routeLocation && car.getTrack() != null && car.getTrack() == track) {
                        pickup = true;
                    }
                    if (car.getRouteDestination() != routeLocation || car.getDestinationTrack() == null || car.getDestinationTrack() != track) continue;
                    setout = true;
                }
                if (pickup) {
                    jsonTrack.put("add", StringEscapeUtils.escapeHtml4((String)track.getCommentPickup()));
                }
                if (setout) {
                    jsonTrack.put("remove", StringEscapeUtils.escapeHtml4((String)track.getCommentSetout()));
                }
                if (pickup && setout) {
                    jsonTrack.put("addAndRemove", StringEscapeUtils.escapeHtml4((String)track.getCommentBoth()));
                }
                if (!pickup && !setout) continue;
                jsonTrack.put("comment", StringEscapeUtils.escapeHtml4((String)track.getComment()));
                comments.set(track.getId(), (JsonNode)jsonTrack);
            }
        }
        return comments;
    }
}

