/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.operations.setup;

import java.awt.Color;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.swing.JComboBox;
import jmri.Disposable;
import jmri.InstanceManager;
import jmri.InstanceManagerAutoDefault;
import jmri.beans.PropertyChangeSupport;
import jmri.jmris.AbstractOperationsServer;
import jmri.jmrit.operations.rollingstock.RollingStockLogger;
import jmri.jmrit.operations.setup.AutoBackup;
import jmri.jmrit.operations.setup.AutoSave;
import jmri.jmrit.operations.setup.Bundle;
import jmri.jmrit.operations.setup.Control;
import jmri.jmrit.operations.setup.OperationsSetupXml;
import jmri.jmrit.operations.trains.TrainLogger;
import jmri.jmrit.operations.trains.TrainManagerXml;
import jmri.util.ColorUtil;
import jmri.util.swing.JmriColorChooser;
import jmri.web.server.WebServerPreferences;
import org.jdom2.Attribute;
import org.jdom2.Content;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Setup
extends PropertyChangeSupport
implements InstanceManagerAutoDefault,
Disposable {
    public static final String NONE = "";
    private static final int Z_RATIO = 220;
    private static final int N_RATIO = 160;
    private static final int TT_RATIO = 120;
    private static final int OO_RATIO = 76;
    private static final int HO_RATIO = 87;
    private static final int S_RATIO = 64;
    private static final int O_RATIO = 48;
    private static final int G_RATIO = 32;
    private static final int Z_INITIAL_WEIGHT = 364;
    private static final int N_INITIAL_WEIGHT = 500;
    private static final int TT_INITIAL_WEIGHT = 750;
    private static final int HOn3_INITIAL_WEIGHT = 750;
    private static final int OO_INITIAL_WEIGHT = 750;
    private static final int HO_INITIAL_WEIGHT = 1000;
    private static final int Sn3_INITIAL_WEIGHT = 1000;
    private static final int S_INITIAL_WEIGHT = 2000;
    private static final int On3_INITIAL_WEIGHT = 1500;
    private static final int O_INITIAL_WEIGHT = 5000;
    private static final int G_INITIAL_WEIGHT = 10000;
    private static final int Z_ADD_WEIGHT = 100;
    private static final int N_ADD_WEIGHT = 150;
    private static final int TT_ADD_WEIGHT = 375;
    private static final int HOn3_ADD_WEIGHT = 375;
    private static final int OO_ADD_WEIGHT = 500;
    private static final int HO_ADD_WEIGHT = 500;
    private static final int Sn3_ADD_WEIGHT = 500;
    private static final int S_ADD_WEIGHT = 500;
    private static final int On3_ADD_WEIGHT = 750;
    private static final int O_ADD_WEIGHT = 1000;
    private static final int G_ADD_WEIGHT = 2000;
    private static final int Z_RATIO_TONS = 130;
    private static final int N_RATIO_TONS = 80;
    private static final int TT_RATIO_TONS = 36;
    private static final int HOn3_RATIO_TONS = 20;
    private static final int OO_RATIO_TONS = 20;
    private static final int HO_RATIO_TONS = 20;
    private static final int Sn3_RATIO_TONS = 16;
    private static final int S_RATIO_TONS = 14;
    private static final int On3_RATIO_TONS = 8;
    private static final int O_RATIO_TONS = 5;
    private static final int G_RATIO_TONS = 2;
    public static final int Z_SCALE = 1;
    public static final int N_SCALE = 2;
    public static final int TT_SCALE = 3;
    public static final int HOn3_SCALE = 4;
    public static final int OO_SCALE = 5;
    public static final int HO_SCALE = 6;
    public static final int Sn3_SCALE = 7;
    public static final int S_SCALE = 8;
    public static final int On3_SCALE = 9;
    public static final int O_SCALE = 10;
    public static final int G_SCALE = 11;
    public static final int EAST = 1;
    public static final int WEST = 2;
    public static final int NORTH = 4;
    public static final int SOUTH = 8;
    public static final String EAST_DIR = Bundle.getMessage("East");
    public static final String WEST_DIR = Bundle.getMessage("West");
    public static final String NORTH_DIR = Bundle.getMessage("North");
    public static final String SOUTH_DIR = Bundle.getMessage("South");
    public static final String DESCRIPTIVE = Bundle.getMessage("Descriptive");
    public static final String AAR = Bundle.getMessage("ArrCodes");
    public static final String MONOSPACED = Bundle.getMessage("Monospaced");
    public static final String STANDARD_FORMAT = Bundle.getMessage("StandardFormat");
    public static final String TWO_COLUMN_FORMAT = Bundle.getMessage("TwoColumnFormat");
    public static final String TWO_COLUMN_TRACK_FORMAT = Bundle.getMessage("TwoColumnTrackFormat");
    public static final String PORTRAIT = Bundle.getMessage("Portrait");
    public static final String LANDSCAPE = Bundle.getMessage("Landscape");
    public static final String HALFPAGE = Bundle.getMessage("HalfPage");
    public static final String HANDHELD = Bundle.getMessage("HandHeld");
    public static final String PAGE_NORMAL = Bundle.getMessage("PageNormal");
    public static final String PAGE_PER_TRAIN = Bundle.getMessage("PagePerTrain");
    public static final String PAGE_PER_VISIT = Bundle.getMessage("PagePerVisit");
    public static final String BUILD_REPORT_MINIMAL = "1";
    public static final String BUILD_REPORT_NORMAL = "3";
    public static final String BUILD_REPORT_DETAILED = "5";
    public static final String BUILD_REPORT_VERY_DETAILED = "7";
    public static final String ROAD = Bundle.getMessage("Road");
    public static final String NUMBER = Bundle.getMessage("Number");
    public static final String TYPE = Bundle.getMessage("Type");
    public static final String MODEL = Bundle.getMessage("Model");
    public static final String LENGTH = Bundle.getMessage("Length");
    public static final String WEIGHT = Bundle.getMessage("Weight");
    public static final String LOAD = Bundle.getMessage("Load");
    public static final String LOAD_TYPE = Bundle.getMessage("Load_Type");
    public static final String COLOR = Bundle.getMessage("Color");
    public static final String TRACK = Bundle.getMessage("Track");
    public static final String DESTINATION = Bundle.getMessage("Destination");
    public static final String DEST_TRACK = Bundle.getMessage("Dest&Track");
    public static final String FINAL_DEST = Bundle.getMessage("Final_Dest");
    public static final String FINAL_DEST_TRACK = Bundle.getMessage("FD&Track");
    public static final String LOCATION = Bundle.getMessage("Location");
    public static final String CONSIST = Bundle.getMessage("Consist");
    public static final String KERNEL = Bundle.getMessage("Kernel");
    public static final String KERNEL_SIZE = Bundle.getMessage("Kernel_Size");
    public static final String OWNER = Bundle.getMessage("Owner");
    public static final String RWE = Bundle.getMessage("RWE");
    public static final String COMMENT = Bundle.getMessage("Comment");
    public static final String DROP_COMMENT = Bundle.getMessage("SetOut_Msg");
    public static final String PICKUP_COMMENT = Bundle.getMessage("PickUp_Msg");
    public static final String HAZARDOUS = Bundle.getMessage("Hazardous");
    public static final String BLANK = " ";
    public static final String TAB = Bundle.getMessage("Tab");
    public static final String TAB2 = Bundle.getMessage("Tab2");
    public static final String TAB3 = Bundle.getMessage("Tab3");
    public static final String BOX = " [ ] ";
    public static final String NO_ROAD = "NO_ROAD";
    public static final String NO_NUMBER = "NO_NUMBER";
    public static final String NO_COLOR = "NO_COLOR";
    public static final String NO_DESTINATION = "NO_DESTINATION";
    public static final String NO_DEST_TRACK = "NO_DEST_TRACK";
    public static final String NO_LOCATION = "NO_LOCATION";
    public static final String NO_TRACK = "NO_TRACK";
    public static final String FEET = Bundle.getMessage("Feet");
    public static final String METER = Bundle.getMessage("Meter");
    public static final String FEET_ABV = Bundle.getMessage("FeetAbbreviation");
    public static final String METER_ABV = Bundle.getMessage("MeterAbbreviation");
    private static final String[] CAR_ATTRIBUTES = new String[]{ROAD, NUMBER, TYPE, LENGTH, WEIGHT, LOAD, LOAD_TYPE, HAZARDOUS, COLOR, KERNEL, KERNEL_SIZE, OWNER, TRACK, LOCATION, DESTINATION, DEST_TRACK, FINAL_DEST, FINAL_DEST_TRACK, COMMENT, DROP_COMMENT, PICKUP_COMMENT, RWE};
    private static final String[] ENGINE_ATTRIBUTES = new String[]{ROAD, NUMBER, TYPE, MODEL, LENGTH, WEIGHT, CONSIST, OWNER, TRACK, LOCATION, DESTINATION, COMMENT};
    private static final String[] KEYS = new String[]{"Road", "Number", "Type", "Model", "Length", "Weight", "Load", "Load_Type", "Color", "Track", "Destination", "Dest&Track", "Final_Dest", "FD&Track", "Location", "Consist", "Kernel", "Kernel_Size", "Owner", "RWE", "Comment", "SetOut_Msg", "PickUp_Msg", "Hazardous", "Tab", "Tab2", "Tab3"};
    private int scale = 6;
    private int ratio = 87;
    private int ratioTons = 20;
    private int initWeight = 1000;
    private int addWeight = 500;
    private String railroadName = "";
    private int traindir = 15;
    private int maxTrainLength = 1000;
    private int maxEngineSize = 6;
    private int horsePowerPerTon = 1;
    private int carMoves = 5;
    private String carTypes = DESCRIPTIVE;
    private String ownerName = "";
    private String fontName = MONOSPACED;
    private int manifestFontSize = 10;
    private int buildReportFontSize = 10;
    private String manifestOrientation = PORTRAIT;
    private String switchListOrientation = PORTRAIT;
    private boolean printHeader = true;
    private Color pickupColor = Color.black;
    private Color dropColor = Color.black;
    private Color localColor = Color.black;
    private String[] pickupEngineMessageFormat = new String[]{ROAD, NUMBER, " ", MODEL, " ", " ", LOCATION, COMMENT};
    private String[] dropEngineMessageFormat = new String[]{ROAD, NUMBER, " ", MODEL, " ", " ", DESTINATION, COMMENT};
    private String[] pickupManifestMessageFormat = new String[]{ROAD, NUMBER, TYPE, LENGTH, COLOR, LOAD, HAZARDOUS, LOCATION, COMMENT, PICKUP_COMMENT};
    private String[] dropManifestMessageFormat = new String[]{ROAD, NUMBER, TYPE, LENGTH, COLOR, LOAD, HAZARDOUS, DESTINATION, COMMENT, DROP_COMMENT};
    private String[] localManifestMessageFormat = new String[]{ROAD, NUMBER, TYPE, LENGTH, COLOR, LOAD, HAZARDOUS, LOCATION, DESTINATION, COMMENT};
    private String[] pickupSwitchListMessageFormat = new String[]{ROAD, NUMBER, TYPE, LENGTH, COLOR, LOAD, HAZARDOUS, LOCATION, COMMENT, PICKUP_COMMENT};
    private String[] dropSwitchListMessageFormat = new String[]{ROAD, NUMBER, TYPE, LENGTH, COLOR, LOAD, HAZARDOUS, DESTINATION, COMMENT, DROP_COMMENT};
    private String[] localSwitchListMessageFormat = new String[]{ROAD, NUMBER, TYPE, LENGTH, COLOR, LOAD, HAZARDOUS, LOCATION, DESTINATION, COMMENT};
    private String[] missingCarMessageFormat = new String[]{ROAD, NUMBER, TYPE, LENGTH, COLOR, COMMENT};
    private String pickupEnginePrefix = " [ ] " + Bundle.getMessage("PickUpPrefix");
    private String dropEnginePrefix = " [ ] " + Bundle.getMessage("SetOutPrefix");
    private String pickupCarPrefix = " [ ] " + Bundle.getMessage("PickUpPrefix");
    private String dropCarPrefix = " [ ] " + Bundle.getMessage("SetOutPrefix");
    private String localPrefix = " [ ] " + Bundle.getMessage("LocalCarPrefix");
    private String switchListPickupCarPrefix = " [ ] " + Bundle.getMessage("PickUpPrefix");
    private String switchListDropCarPrefix = " [ ] " + Bundle.getMessage("SetOutPrefix");
    private String switchListLocalPrefix = " [ ] " + Bundle.getMessage("LocalCarPrefix");
    private String miaComment = Bundle.getMessage("misplacedCars");
    private String hazardousMsg = "(" + Bundle.getMessage("Hazardous") + ")";
    private String logoURL = "";
    private String panelName = "Panel";
    private String buildReportLevel = "7";
    private String routerBuildReportLevel = "3";
    private int carSwitchTime = 3;
    private int travelTime = 4;
    private String yearModeled = "";
    private String lengthUnit = FEET;
    private String lengthUnitAbv = FEET_ABV;
    private String iconNorthColor = "";
    private String iconSouthColor = "";
    private String iconEastColor = "";
    private String iconWestColor = "";
    private String iconLocalColor = "";
    private String iconTerminateColor = "";
    private boolean tab = false;
    private int tab1CharLength = Control.max_len_string_attibute;
    private int tab2CharLength = 6;
    private int tab3CharLength = 8;
    private String manifestFormat = STANDARD_FORMAT;
    private boolean manifestEditorEnabled = false;
    private boolean switchListSameManifest = true;
    private boolean manifestTruncated = false;
    private boolean manifestDepartureTime = false;
    private boolean switchListRouteComment = true;
    private boolean trackSummary = true;
    private boolean switchListRealTime = true;
    private boolean switchListAllTrains = true;
    private String switchListPageFormat = PAGE_NORMAL;
    private boolean buildReportEditorEnabled = false;
    private boolean buildReportIndentEnabled = true;
    private boolean buildReportAlwaysPreviewEnabled = false;
    private boolean enableTrainIconXY = true;
    private boolean appendTrainIcon = false;
    private String setupComment = "";
    private boolean mainMenuEnabled = false;
    private boolean closeWindowOnSave = false;
    private boolean autoSave = true;
    private boolean autoBackup = true;
    private boolean enableValue = false;
    private String labelValue = Bundle.getMessage("Value");
    private boolean enableRfid = false;
    private String labelRfid = Bundle.getMessage("RFID");
    private boolean carRoutingEnabled = true;
    private boolean carRoutingYards = true;
    private boolean carRoutingStaging = false;
    private boolean forwardToYardEnabled = true;
    private boolean onlyActiveTrains = false;
    private boolean checkCarDestination = false;
    private boolean carLogger = false;
    private boolean engineLogger = false;
    private boolean trainLogger = false;
    private boolean saveTrainManifests = false;
    private boolean aggressiveBuild = false;
    private int numberPasses = 2;
    private boolean allowLocalInterchangeMoves = false;
    private boolean allowLocalYardMoves = false;
    private boolean allowLocalSpurMoves = false;
    private boolean trainIntoStagingCheck = true;
    private boolean trackImmediatelyAvail = false;
    private boolean allowCarsReturnStaging = false;
    private boolean promptFromStaging = false;
    private boolean promptToStaging = false;
    private boolean tryNormalModeStaging = true;
    private boolean generateCsvManifest = false;
    private boolean generateCsvSwitchList = false;
    private boolean enableVsdPhysicalLocations = false;
    private boolean printLocationComments = false;
    private boolean printRouteComments = false;
    private boolean printLoadsAndEmpties = false;
    private boolean printTrainScheduleName = false;
    private boolean use12hrFormat = false;
    private boolean printValid = true;
    private boolean sortByTrack = false;
    private boolean printHeaders = false;
    private boolean printCabooseLoad = false;
    private boolean printPassengerLoad = false;
    private boolean showTrackMoves = false;
    public static final String SWITCH_LIST_CSV_PROPERTY_CHANGE = "setupSwitchListCSVChange";
    public static final String MANIFEST_CSV_PROPERTY_CHANGE = "setupManifestCSVChange";
    public static final String REAL_TIME_PROPERTY_CHANGE = "setupSwitchListRealTime";
    public static final String SHOW_TRACK_MOVES_PROPERTY_CHANGE = "setupShowTrackMoves";
    public static final String SAVE_TRAIN_MANIFEST_PROPERTY_CHANGE = "saveTrainManifestChange";
    public static final String ALLOW_CARS_TO_RETURN_PROPERTY_CHANGE = "allowCarsToReturnChange";
    public static final String TRAIN_DIRECTION_PROPERTY_CHANGE = "setupTrainDirectionChange";
    private static final Logger log = LoggerFactory.getLogger(Setup.class);

    public static boolean isMainMenuEnabled() {
        InstanceManager.getDefault(OperationsSetupXml.class);
        return Setup.getDefault().mainMenuEnabled;
    }

    public static void setMainMenuEnabled(boolean enabled) {
        Setup.getDefault().mainMenuEnabled = enabled;
    }

    public static boolean isCloseWindowOnSaveEnabled() {
        return Setup.getDefault().closeWindowOnSave;
    }

    public static void setCloseWindowOnSaveEnabled(boolean enabled) {
        Setup.getDefault().closeWindowOnSave = enabled;
    }

    public static boolean isAutoSaveEnabled() {
        return Setup.getDefault().autoSave;
    }

    public static void setAutoSaveEnabled(boolean enabled) {
        Setup.getDefault().autoSave = enabled;
        if (enabled) {
            AutoSave.start();
        } else {
            AutoSave.stop();
        }
    }

    public static boolean isAutoBackupEnabled() {
        return Setup.getDefault().autoBackup;
    }

    public static void setAutoBackupEnabled(boolean enabled) {
        if (enabled && !Setup.getDefault().autoBackup) {
            try {
                new AutoBackup().autoBackup();
            }
            catch (IOException ex) {
                log.debug("Autobackup after setting AutoBackup flag true", (Throwable)ex);
            }
        }
        Setup.getDefault().autoBackup = enabled;
    }

    public static boolean isValueEnabled() {
        return Setup.getDefault().enableValue;
    }

    public static void setValueEnabled(boolean enabled) {
        Setup.getDefault().enableValue = enabled;
    }

    public static String getValueLabel() {
        return Setup.getDefault().labelValue;
    }

    public static void setValueLabel(String label) {
        Setup.getDefault().labelValue = label;
    }

    public static boolean isRfidEnabled() {
        return Setup.getDefault().enableRfid;
    }

    public static void setRfidEnabled(boolean enabled) {
        Setup.getDefault().enableRfid = enabled;
    }

    public static String getRfidLabel() {
        return Setup.getDefault().labelRfid;
    }

    public static void setRfidLabel(String label) {
        Setup.getDefault().labelRfid = label;
    }

    public static boolean isCarRoutingEnabled() {
        return Setup.getDefault().carRoutingEnabled;
    }

    public static void setCarRoutingEnabled(boolean enabled) {
        Setup.getDefault().carRoutingEnabled = enabled;
    }

    public static boolean isCarRoutingViaYardsEnabled() {
        return Setup.getDefault().carRoutingYards;
    }

    public static void setCarRoutingViaYardsEnabled(boolean enabled) {
        Setup.getDefault().carRoutingYards = enabled;
    }

    public static boolean isCarRoutingViaStagingEnabled() {
        return Setup.getDefault().carRoutingStaging;
    }

    public static void setCarRoutingViaStagingEnabled(boolean enabled) {
        Setup.getDefault().carRoutingStaging = enabled;
    }

    public static boolean isForwardToYardEnabled() {
        return Setup.getDefault().forwardToYardEnabled;
    }

    public static void setForwardToYardEnabled(boolean enabled) {
        Setup.getDefault().forwardToYardEnabled = enabled;
    }

    public static boolean isOnlyActiveTrainsEnabled() {
        return Setup.getDefault().onlyActiveTrains;
    }

    public static void setOnlyActiveTrainsEnabled(boolean enabled) {
        Setup.getDefault().onlyActiveTrains = enabled;
    }

    public static boolean isCheckCarDestinationEnabled() {
        return Setup.getDefault().checkCarDestination;
    }

    public static void setCheckCarDestinationEnabled(boolean enabled) {
        Setup.getDefault().checkCarDestination = enabled;
    }

    public static boolean isBuildAggressive() {
        return Setup.getDefault().aggressiveBuild;
    }

    public static void setBuildAggressive(boolean enabled) {
        Setup.getDefault().aggressiveBuild = enabled;
    }

    public static int getNumberPasses() {
        return Setup.getDefault().numberPasses;
    }

    public static void setNumberPasses(int number) {
        Setup.getDefault().numberPasses = number;
    }

    public static boolean isLocalInterchangeMovesEnabled() {
        return Setup.getDefault().allowLocalInterchangeMoves;
    }

    public static void setLocalInterchangeMovesEnabled(boolean enabled) {
        Setup.getDefault().allowLocalInterchangeMoves = enabled;
    }

    public static boolean isLocalYardMovesEnabled() {
        return Setup.getDefault().allowLocalYardMoves;
    }

    public static void setLocalYardMovesEnabled(boolean enabled) {
        Setup.getDefault().allowLocalYardMoves = enabled;
    }

    public static boolean isLocalSpurMovesEnabled() {
        return Setup.getDefault().allowLocalSpurMoves;
    }

    public static void setLocalSpurMovesEnabled(boolean enabled) {
        Setup.getDefault().allowLocalSpurMoves = enabled;
    }

    public static boolean isStagingTrainCheckEnabled() {
        return Setup.getDefault().trainIntoStagingCheck;
    }

    public static void setStagingTrainCheckEnabled(boolean enabled) {
        Setup.getDefault().trainIntoStagingCheck = enabled;
    }

    public static boolean isStagingTrackImmediatelyAvail() {
        return Setup.getDefault().trackImmediatelyAvail;
    }

    public static void setStagingTrackImmediatelyAvail(boolean enabled) {
        Setup.getDefault().trackImmediatelyAvail = enabled;
    }

    public static boolean isStagingAllowReturnEnabled() {
        return Setup.getDefault().allowCarsReturnStaging;
    }

    public static void setStagingAllowReturnEnabled(boolean enabled) {
        boolean old = Setup.getDefault().allowCarsReturnStaging;
        Setup.getDefault().allowCarsReturnStaging = enabled;
        Setup.setDirtyAndFirePropertyChange(ALLOW_CARS_TO_RETURN_PROPERTY_CHANGE, old, enabled);
    }

    public static boolean isStagingPromptFromEnabled() {
        return Setup.getDefault().promptFromStaging;
    }

    public static void setStagingPromptFromEnabled(boolean enabled) {
        Setup.getDefault().promptFromStaging = enabled;
    }

    public static boolean isStagingPromptToEnabled() {
        return Setup.getDefault().promptToStaging;
    }

    public static void setStagingPromptToEnabled(boolean enabled) {
        Setup.getDefault().promptToStaging = enabled;
    }

    public static boolean isStagingTryNormalBuildEnabled() {
        return Setup.getDefault().tryNormalModeStaging;
    }

    public static void setStagingTryNormalBuildEnabled(boolean enabled) {
        Setup.getDefault().tryNormalModeStaging = enabled;
    }

    public static boolean isGenerateCsvManifestEnabled() {
        return Setup.getDefault().generateCsvManifest;
    }

    public static void setGenerateCsvManifestEnabled(boolean enabled) {
        boolean old = Setup.getDefault().generateCsvManifest;
        Setup.getDefault().generateCsvManifest = enabled;
        if (enabled && !old) {
            InstanceManager.getDefault(TrainManagerXml.class).createDefaultCsvManifestDirectory();
        }
        Setup.setDirtyAndFirePropertyChange(MANIFEST_CSV_PROPERTY_CHANGE, old, enabled);
    }

    public static boolean isGenerateCsvSwitchListEnabled() {
        return Setup.getDefault().generateCsvSwitchList;
    }

    public static void setGenerateCsvSwitchListEnabled(boolean enabled) {
        boolean old = Setup.getDefault().generateCsvSwitchList;
        Setup.getDefault().generateCsvSwitchList = enabled;
        if (enabled && !old) {
            InstanceManager.getDefault(TrainManagerXml.class).createDefaultCsvSwitchListDirectory();
        }
        Setup.setDirtyAndFirePropertyChange(SWITCH_LIST_CSV_PROPERTY_CHANGE, old, enabled);
    }

    public static boolean isVsdPhysicalLocationEnabled() {
        return Setup.getDefault().enableVsdPhysicalLocations;
    }

    public static void setVsdPhysicalLocationEnabled(boolean enabled) {
        Setup.getDefault().enableVsdPhysicalLocations = enabled;
    }

    public static String getRailroadName() {
        if (Setup.getDefault().railroadName.isEmpty()) {
            return InstanceManager.getDefault(WebServerPreferences.class).getRailroadName();
        }
        return Setup.getDefault().railroadName;
    }

    public static void setRailroadName(String name) {
        String old = Setup.getDefault().railroadName;
        Setup.getDefault().railroadName = name;
        if (old == null || !old.equals(name)) {
            Setup.setDirtyAndFirePropertyChange("Railroad Name Change", old, name);
        }
    }

    public static String getHazardousMsg() {
        return Setup.getDefault().hazardousMsg;
    }

    public static void setHazardousMsg(String message) {
        Setup.getDefault().hazardousMsg = message;
    }

    public static String getMiaComment() {
        return Setup.getDefault().miaComment;
    }

    public static void setMiaComment(String comment) {
        Setup.getDefault().miaComment = comment;
    }

    public static void setTrainDirection(int direction) {
        int old = Setup.getDefault().traindir;
        Setup.getDefault().traindir = direction;
        if (old != direction) {
            Setup.setDirtyAndFirePropertyChange(TRAIN_DIRECTION_PROPERTY_CHANGE, old, direction);
        }
    }

    public static int getTrainDirection() {
        return Setup.getDefault().traindir;
    }

    public static void setMaxTrainLength(int length) {
        Setup.getDefault().maxTrainLength = length;
    }

    public static int getMaxTrainLength() {
        return Setup.getDefault().maxTrainLength;
    }

    public static void setMaxNumberEngines(int value) {
        Setup.getDefault().maxEngineSize = value;
    }

    public static int getMaxNumberEngines() {
        return Setup.getDefault().maxEngineSize;
    }

    public static void setHorsePowerPerTon(int value) {
        Setup.getDefault().horsePowerPerTon = value;
    }

    public static int getHorsePowerPerTon() {
        return Setup.getDefault().horsePowerPerTon;
    }

    public static void setCarMoves(int moves) {
        Setup.getDefault().carMoves = moves;
    }

    public static int getCarMoves() {
        return Setup.getDefault().carMoves;
    }

    public static String getPanelName() {
        return Setup.getDefault().panelName;
    }

    public static void setPanelName(String name) {
        Setup.getDefault().panelName = name;
    }

    public static String getLengthUnit() {
        return Setup.getDefault().lengthUnit;
    }

    public static String getLengthUnitAbv() {
        return Setup.getDefault().lengthUnitAbv;
    }

    public static void setLengthUnit(String unit) {
        Setup.getDefault().lengthUnit = unit;
        Setup.getDefault().lengthUnitAbv = unit.equals(FEET) ? FEET_ABV : METER_ABV;
    }

    public static String getYearModeled() {
        return Setup.getDefault().yearModeled;
    }

    public static void setYearModeled(String year) {
        Setup.getDefault().yearModeled = year;
    }

    public static String getCarTypes() {
        return Setup.getDefault().carTypes;
    }

    public static void setCarTypes(String types) {
        Setup.getDefault().carTypes = types;
    }

    public static void setTrainIconCordEnabled(boolean enable) {
        Setup.getDefault().enableTrainIconXY = enable;
    }

    public static boolean isTrainIconCordEnabled() {
        return Setup.getDefault().enableTrainIconXY;
    }

    public static void setTrainIconAppendEnabled(boolean enable) {
        Setup.getDefault().appendTrainIcon = enable;
    }

    public static boolean isTrainIconAppendEnabled() {
        return Setup.getDefault().appendTrainIcon;
    }

    public static void setComment(String comment) {
        Setup.getDefault().setupComment = comment;
    }

    public static String getComment() {
        return Setup.getDefault().setupComment;
    }

    public static void setBuildReportLevel(String level) {
        Setup.getDefault().buildReportLevel = level;
    }

    public static String getBuildReportLevel() {
        return Setup.getDefault().buildReportLevel;
    }

    public static void setRouterBuildReportLevel(String level) {
        Setup.getDefault().routerBuildReportLevel = level;
    }

    public static String getRouterBuildReportLevel() {
        return Setup.getDefault().routerBuildReportLevel;
    }

    public static void setManifestEditorEnabled(boolean enable) {
        Setup.getDefault().manifestEditorEnabled = enable;
    }

    public static boolean isManifestEditorEnabled() {
        return Setup.getDefault().manifestEditorEnabled;
    }

    public static void setBuildReportEditorEnabled(boolean enable) {
        Setup.getDefault().buildReportEditorEnabled = enable;
    }

    public static boolean isBuildReportEditorEnabled() {
        return Setup.getDefault().buildReportEditorEnabled;
    }

    public static void setBuildReportIndentEnabled(boolean enable) {
        Setup.getDefault().buildReportIndentEnabled = enable;
    }

    public static boolean isBuildReportIndentEnabled() {
        return Setup.getDefault().buildReportIndentEnabled;
    }

    public static void setBuildReportAlwaysPreviewEnabled(boolean enable) {
        Setup.getDefault().buildReportAlwaysPreviewEnabled = enable;
    }

    public static boolean isBuildReportAlwaysPreviewEnabled() {
        return Setup.getDefault().buildReportAlwaysPreviewEnabled;
    }

    public static void setSwitchListFormatSameAsManifest(boolean b) {
        Setup.getDefault().switchListSameManifest = b;
    }

    public static boolean isSwitchListFormatSameAsManifest() {
        return Setup.getDefault().switchListSameManifest;
    }

    public static void setPrintTrackSummaryEnabled(boolean b) {
        Setup.getDefault().trackSummary = b;
    }

    public static boolean isPrintTrackSummaryEnabled() {
        return Setup.getDefault().trackSummary;
    }

    public static void setSwitchListRouteLocationCommentEnabled(boolean b) {
        Setup.getDefault().switchListRouteComment = b;
    }

    public static boolean isSwitchListRouteLocationCommentEnabled() {
        return Setup.getDefault().switchListRouteComment;
    }

    public static void setSwitchListRealTime(boolean b) {
        boolean old = Setup.getDefault().switchListRealTime;
        Setup.getDefault().switchListRealTime = b;
        Setup.setDirtyAndFirePropertyChange(REAL_TIME_PROPERTY_CHANGE, old, b);
    }

    public static boolean isSwitchListRealTime() {
        return Setup.getDefault().switchListRealTime;
    }

    public static void setSwitchListAllTrainsEnabled(boolean b) {
        boolean old = Setup.getDefault().switchListAllTrains;
        Setup.getDefault().switchListAllTrains = b;
        Setup.setDirtyAndFirePropertyChange("Switch List All Trains", old, b);
    }

    public static boolean isSwitchListAllTrainsEnabled() {
        return Setup.getDefault().switchListAllTrains;
    }

    public static void setSwitchListPageFormat(String format) {
        Setup.getDefault().switchListPageFormat = format;
    }

    public static String getSwitchListPageFormat() {
        return Setup.getDefault().switchListPageFormat;
    }

    public static void setPrintTruncateManifestEnabled(boolean b) {
        Setup.getDefault().manifestTruncated = b;
    }

    public static boolean isPrintTruncateManifestEnabled() {
        return Setup.getDefault().manifestTruncated;
    }

    public static void setUseDepartureTimeEnabled(boolean b) {
        Setup.getDefault().manifestDepartureTime = b;
    }

    public static boolean isUseDepartureTimeEnabled() {
        return Setup.getDefault().manifestDepartureTime;
    }

    public static void setPrintLocationCommentsEnabled(boolean enable) {
        Setup.getDefault().printLocationComments = enable;
    }

    public static boolean isPrintLocationCommentsEnabled() {
        return Setup.getDefault().printLocationComments;
    }

    public static void setPrintRouteCommentsEnabled(boolean enable) {
        Setup.getDefault().printRouteComments = enable;
    }

    public static boolean isPrintRouteCommentsEnabled() {
        return Setup.getDefault().printRouteComments;
    }

    public static void setPrintLoadsAndEmptiesEnabled(boolean enable) {
        Setup.getDefault().printLoadsAndEmpties = enable;
    }

    public static boolean isPrintLoadsAndEmptiesEnabled() {
        return Setup.getDefault().printLoadsAndEmpties;
    }

    public static void setPrintTrainScheduleNameEnabled(boolean enable) {
        Setup.getDefault().printTrainScheduleName = enable;
    }

    public static boolean isPrintTrainScheduleNameEnabled() {
        return Setup.getDefault().printTrainScheduleName;
    }

    public static void set12hrFormatEnabled(boolean enable) {
        Setup.getDefault().use12hrFormat = enable;
    }

    public static boolean is12hrFormatEnabled() {
        return Setup.getDefault().use12hrFormat;
    }

    public static void setPrintValidEnabled(boolean enable) {
        Setup.getDefault().printValid = enable;
    }

    public static boolean isPrintValidEnabled() {
        return Setup.getDefault().printValid;
    }

    public static void setSortByTrackNameEnabled(boolean enable) {
        Setup.getDefault().sortByTrack = enable;
    }

    public static boolean isSortByTrackNameEnabled() {
        return Setup.getDefault().sortByTrack;
    }

    public static void setPrintHeadersEnabled(boolean enable) {
        Setup.getDefault().printHeaders = enable;
    }

    public static boolean isPrintHeadersEnabled() {
        return Setup.getDefault().printHeaders;
    }

    public static void setPrintCabooseLoadEnabled(boolean enable) {
        Setup.getDefault().printCabooseLoad = enable;
    }

    public static boolean isPrintCabooseLoadEnabled() {
        return Setup.getDefault().printCabooseLoad;
    }

    public static void setPrintPassengerLoadEnabled(boolean enable) {
        Setup.getDefault().printPassengerLoad = enable;
    }

    public static boolean isPrintPassengerLoadEnabled() {
        return Setup.getDefault().printPassengerLoad;
    }

    public static void setShowTrackMovesEnabled(boolean enable) {
        boolean old = Setup.getDefault().showTrackMoves;
        Setup.getDefault().showTrackMoves = enable;
        Setup.setDirtyAndFirePropertyChange(SHOW_TRACK_MOVES_PROPERTY_CHANGE, old, enable);
    }

    public static boolean isShowTrackMovesEnabled() {
        return Setup.getDefault().showTrackMoves;
    }

    public static void setSwitchTime(int minutes) {
        Setup.getDefault().carSwitchTime = minutes;
    }

    public static int getSwitchTime() {
        return Setup.getDefault().carSwitchTime;
    }

    public static void setTravelTime(int minutes) {
        Setup.getDefault().travelTime = minutes;
    }

    public static int getTravelTime() {
        return Setup.getDefault().travelTime;
    }

    public static void setTrainIconColorNorth(String color) {
        Setup.getDefault().iconNorthColor = color;
    }

    public static String getTrainIconColorNorth() {
        return Setup.getDefault().iconNorthColor;
    }

    public static void setTrainIconColorSouth(String color) {
        Setup.getDefault().iconSouthColor = color;
    }

    public static String getTrainIconColorSouth() {
        return Setup.getDefault().iconSouthColor;
    }

    public static void setTrainIconColorEast(String color) {
        Setup.getDefault().iconEastColor = color;
    }

    public static String getTrainIconColorEast() {
        return Setup.getDefault().iconEastColor;
    }

    public static void setTrainIconColorWest(String color) {
        Setup.getDefault().iconWestColor = color;
    }

    public static String getTrainIconColorWest() {
        return Setup.getDefault().iconWestColor;
    }

    public static void setTrainIconColorLocal(String color) {
        Setup.getDefault().iconLocalColor = color;
    }

    public static String getTrainIconColorLocal() {
        return Setup.getDefault().iconLocalColor;
    }

    public static void setTrainIconColorTerminate(String color) {
        Setup.getDefault().iconTerminateColor = color;
    }

    public static String getTrainIconColorTerminate() {
        return Setup.getDefault().iconTerminateColor;
    }

    public static String getFontName() {
        return Setup.getDefault().fontName;
    }

    public static void setFontName(String name) {
        Setup.getDefault().fontName = name;
    }

    public static int getManifestFontSize() {
        return Setup.getDefault().manifestFontSize;
    }

    public static void setManifestFontSize(int size) {
        Setup.getDefault().manifestFontSize = size;
    }

    public static boolean isPrintPageHeaderEnabled() {
        return Setup.getDefault().printHeader;
    }

    public static void setPrintPageHeaderEnabled(boolean enable) {
        Setup.getDefault().printHeader = enable;
    }

    public static int getBuildReportFontSize() {
        return Setup.getDefault().buildReportFontSize;
    }

    public static void setBuildReportFontSize(int size) {
        Setup.getDefault().buildReportFontSize = size;
    }

    public static String getManifestOrientation() {
        return Setup.getDefault().manifestOrientation;
    }

    public static void setManifestOrientation(String orientation) {
        Setup.getDefault().manifestOrientation = orientation;
    }

    public static String getSwitchListOrientation() {
        if (Setup.isSwitchListFormatSameAsManifest()) {
            return Setup.getDefault().manifestOrientation;
        }
        return Setup.getDefault().switchListOrientation;
    }

    public static void setSwitchListOrientation(String orientation) {
        Setup.getDefault().switchListOrientation = orientation;
    }

    public static boolean isTabEnabled() {
        return Setup.getDefault().tab;
    }

    public static void setTabEnabled(boolean enable) {
        Setup.getDefault().tab = enable;
    }

    public static int getTab1Length() {
        return Setup.getDefault().tab1CharLength;
    }

    public static void setTab1length(int length) {
        Setup.getDefault().tab1CharLength = length;
    }

    public static int getTab2Length() {
        return Setup.getDefault().tab2CharLength;
    }

    public static void setTab2length(int length) {
        Setup.getDefault().tab2CharLength = length;
    }

    public static int getTab3Length() {
        return Setup.getDefault().tab3CharLength;
    }

    public static void setTab3length(int length) {
        Setup.getDefault().tab3CharLength = length;
    }

    public static String getManifestFormat() {
        return Setup.getDefault().manifestFormat;
    }

    public static void setManifestFormat(String format) {
        Setup.getDefault().manifestFormat = format;
    }

    public static boolean isCarLoggerEnabled() {
        return Setup.getDefault().carLogger;
    }

    public static void setCarLoggerEnabled(boolean enable) {
        Setup.getDefault().carLogger = enable;
        InstanceManager.getDefault(RollingStockLogger.class).enableCarLogging(enable);
    }

    public static boolean isEngineLoggerEnabled() {
        return Setup.getDefault().engineLogger;
    }

    public static void setEngineLoggerEnabled(boolean enable) {
        Setup.getDefault().engineLogger = enable;
        InstanceManager.getDefault(RollingStockLogger.class).enableEngineLogging(enable);
    }

    public static boolean isTrainLoggerEnabled() {
        return Setup.getDefault().trainLogger;
    }

    public static void setTrainLoggerEnabled(boolean enable) {
        Setup.getDefault().trainLogger = enable;
        InstanceManager.getDefault(TrainLogger.class).enableTrainLogging(enable);
    }

    public static boolean isSaveTrainManifestsEnabled() {
        return Setup.getDefault().saveTrainManifests;
    }

    public static void setSaveTrainManifestsEnabled(boolean enable) {
        boolean old = Setup.getDefault().saveTrainManifests;
        Setup.getDefault().saveTrainManifests = enable;
        Setup.setDirtyAndFirePropertyChange(SAVE_TRAIN_MANIFEST_PROPERTY_CHANGE, old, enable);
    }

    public static String getPickupEnginePrefix() {
        return Setup.getDefault().pickupEnginePrefix;
    }

    public static void setPickupEnginePrefix(String prefix) {
        Setup.getDefault().pickupEnginePrefix = prefix;
    }

    public static String getDropEnginePrefix() {
        return Setup.getDefault().dropEnginePrefix;
    }

    public static void setDropEnginePrefix(String prefix) {
        Setup.getDefault().dropEnginePrefix = prefix;
    }

    public static String getPickupCarPrefix() {
        return Setup.getDefault().pickupCarPrefix;
    }

    public static void setPickupCarPrefix(String prefix) {
        Setup.getDefault().pickupCarPrefix = prefix;
    }

    public static String getDropCarPrefix() {
        return Setup.getDefault().dropCarPrefix;
    }

    public static void setDropCarPrefix(String prefix) {
        Setup.getDefault().dropCarPrefix = prefix;
    }

    public static String getLocalPrefix() {
        return Setup.getDefault().localPrefix;
    }

    public static void setLocalPrefix(String prefix) {
        Setup.getDefault().localPrefix = prefix;
    }

    public static int getManifestPrefixLength() {
        int maxLength = Setup.getPickupEnginePrefix().length();
        if (Setup.getDropEnginePrefix().length() > maxLength) {
            maxLength = Setup.getDropEnginePrefix().length();
        }
        if (Setup.getPickupCarPrefix().length() > maxLength) {
            maxLength = Setup.getPickupCarPrefix().length();
        }
        if (Setup.getDropCarPrefix().length() > maxLength) {
            maxLength = Setup.getDropCarPrefix().length();
        }
        if (Setup.getLocalPrefix().length() > maxLength) {
            maxLength = Setup.getLocalPrefix().length();
        }
        return maxLength;
    }

    public static String getSwitchListPickupCarPrefix() {
        if (Setup.isSwitchListFormatSameAsManifest()) {
            return Setup.getDefault().pickupCarPrefix;
        }
        return Setup.getDefault().switchListPickupCarPrefix;
    }

    public static void setSwitchListPickupCarPrefix(String prefix) {
        Setup.getDefault().switchListPickupCarPrefix = prefix;
    }

    public static String getSwitchListDropCarPrefix() {
        if (Setup.isSwitchListFormatSameAsManifest()) {
            return Setup.getDefault().dropCarPrefix;
        }
        return Setup.getDefault().switchListDropCarPrefix;
    }

    public static void setSwitchListDropCarPrefix(String prefix) {
        Setup.getDefault().switchListDropCarPrefix = prefix;
    }

    public static String getSwitchListLocalPrefix() {
        if (Setup.isSwitchListFormatSameAsManifest()) {
            return Setup.getDefault().localPrefix;
        }
        return Setup.getDefault().switchListLocalPrefix;
    }

    public static void setSwitchListLocalPrefix(String prefix) {
        Setup.getDefault().switchListLocalPrefix = prefix;
    }

    public static int getSwitchListPrefixLength() {
        int maxLength = Setup.getPickupEnginePrefix().length();
        if (Setup.getDropEnginePrefix().length() > maxLength) {
            maxLength = Setup.getDropEnginePrefix().length();
        }
        if (Setup.getSwitchListPickupCarPrefix().length() > maxLength) {
            maxLength = Setup.getSwitchListPickupCarPrefix().length();
        }
        if (Setup.getSwitchListDropCarPrefix().length() > maxLength) {
            maxLength = Setup.getSwitchListDropCarPrefix().length();
        }
        if (Setup.getSwitchListLocalPrefix().length() > maxLength) {
            maxLength = Setup.getSwitchListLocalPrefix().length();
        }
        return maxLength;
    }

    public static String[] getEngineAttributes() {
        return (String[])ENGINE_ATTRIBUTES.clone();
    }

    public static String[] getPickupEngineMessageFormat() {
        return (String[])Setup.getDefault().pickupEngineMessageFormat.clone();
    }

    public static void setPickupEngineMessageFormat(String[] format) {
        Setup.getDefault().pickupEngineMessageFormat = format;
    }

    public static String[] getDropEngineMessageFormat() {
        return (String[])Setup.getDefault().dropEngineMessageFormat.clone();
    }

    public static void setDropEngineMessageFormat(String[] format) {
        Setup.getDefault().dropEngineMessageFormat = format;
    }

    public static String[] getCarAttributes() {
        return (String[])CAR_ATTRIBUTES.clone();
    }

    public static String[] getPickupManifestMessageFormat() {
        return (String[])Setup.getDefault().pickupManifestMessageFormat.clone();
    }

    public static void setPickupManifestMessageFormat(String[] format) {
        Setup.getDefault().pickupManifestMessageFormat = format;
    }

    public static String[] getDropManifestMessageFormat() {
        return (String[])Setup.getDefault().dropManifestMessageFormat.clone();
    }

    public static void setDropManifestMessageFormat(String[] format) {
        Setup.getDefault().dropManifestMessageFormat = format;
    }

    public static String[] getLocalManifestMessageFormat() {
        return (String[])Setup.getDefault().localManifestMessageFormat.clone();
    }

    public static void setLocalManifestMessageFormat(String[] format) {
        Setup.getDefault().localManifestMessageFormat = format;
    }

    public static String[] getMissingCarMessageFormat() {
        return (String[])Setup.getDefault().missingCarMessageFormat.clone();
    }

    public static void setMissingCarMessageFormat(String[] format) {
        Setup.getDefault().missingCarMessageFormat = format;
    }

    public static String[] getPickupSwitchListMessageFormat() {
        if (Setup.isSwitchListFormatSameAsManifest()) {
            return (String[])Setup.getDefault().pickupManifestMessageFormat.clone();
        }
        return (String[])Setup.getDefault().pickupSwitchListMessageFormat.clone();
    }

    public static void setPickupSwitchListMessageFormat(String[] format) {
        Setup.getDefault().pickupSwitchListMessageFormat = format;
    }

    public static String[] getDropSwitchListMessageFormat() {
        if (Setup.isSwitchListFormatSameAsManifest()) {
            return (String[])Setup.getDefault().dropManifestMessageFormat.clone();
        }
        return (String[])Setup.getDefault().dropSwitchListMessageFormat.clone();
    }

    public static void setDropSwitchListMessageFormat(String[] format) {
        Setup.getDefault().dropSwitchListMessageFormat = format;
    }

    public static String[] getLocalSwitchListMessageFormat() {
        if (Setup.isSwitchListFormatSameAsManifest()) {
            return (String[])Setup.getDefault().localManifestMessageFormat.clone();
        }
        return (String[])Setup.getDefault().localSwitchListMessageFormat.clone();
    }

    public static void setLocalSwitchListMessageFormat(String[] format) {
        Setup.getDefault().localSwitchListMessageFormat = format;
    }

    public static String[] getPickupUtilityManifestMessageFormat() {
        return Setup.createUitlityCarMessageFormat(Setup.getPickupManifestMessageFormat());
    }

    public static String[] getDropUtilityManifestMessageFormat() {
        return Setup.createUitlityCarMessageFormat(Setup.getDropManifestMessageFormat());
    }

    public static String[] getLocalUtilityManifestMessageFormat() {
        return Setup.createUitlityCarMessageFormat(Setup.getLocalManifestMessageFormat());
    }

    public static String[] getPickupUtilitySwitchListMessageFormat() {
        return Setup.createUitlityCarMessageFormat(Setup.getPickupSwitchListMessageFormat());
    }

    public static String[] getDropUtilitySwitchListMessageFormat() {
        return Setup.createUitlityCarMessageFormat(Setup.getDropSwitchListMessageFormat());
    }

    public static String[] getLocalUtilitySwitchListMessageFormat() {
        return Setup.createUitlityCarMessageFormat(Setup.getLocalSwitchListMessageFormat());
    }

    private static String[] createUitlityCarMessageFormat(String[] format) {
        int i = 0;
        while (i < format.length) {
            if (format[i].equals(ROAD)) {
                format[i] = NO_ROAD;
            } else if (format[i].equals(NUMBER)) {
                format[i] = NO_NUMBER;
            } else if (format[i].equals(COLOR)) {
                format[i] = NO_COLOR;
            }
            ++i;
        }
        return format;
    }

    public static String[] getPickupTruncatedManifestMessageFormat() {
        return Setup.createTruncatedManifestMessageFormat(Setup.getPickupManifestMessageFormat());
    }

    public static String[] getDropTruncatedManifestMessageFormat() {
        return Setup.createTruncatedManifestMessageFormat(Setup.getDropManifestMessageFormat());
    }

    public static String[] createTruncatedManifestMessageFormat(String[] format) {
        int i = 0;
        while (i < format.length) {
            if (format[i].equals(DESTINATION)) {
                format[i] = NO_DESTINATION;
            } else if (format[i].equals(DEST_TRACK)) {
                format[i] = NO_DEST_TRACK;
            } else if (format[i].equals(LOCATION)) {
                format[i] = NO_LOCATION;
            } else if (format[i].equals(TRACK)) {
                format[i] = NO_TRACK;
            }
            ++i;
        }
        return format;
    }

    public static String[] getPickupTwoColumnByTrackManifestMessageFormat() {
        return Setup.createTwoColumnByTrackPickupMessageFormat(Setup.getPickupManifestMessageFormat());
    }

    public static String[] getPickupTwoColumnByTrackSwitchListMessageFormat() {
        return Setup.createTwoColumnByTrackPickupMessageFormat(Setup.getPickupSwitchListMessageFormat());
    }

    public static String[] getPickupTwoColumnByTrackUtilityManifestMessageFormat() {
        return Setup.createTwoColumnByTrackPickupMessageFormat(Setup.getPickupUtilityManifestMessageFormat());
    }

    public static String[] getPickupTwoColumnByTrackUtilitySwitchListMessageFormat() {
        return Setup.createTwoColumnByTrackPickupMessageFormat(Setup.getPickupUtilitySwitchListMessageFormat());
    }

    private static String[] createTwoColumnByTrackPickupMessageFormat(String[] format) {
        int i = 0;
        while (i < format.length) {
            if (format[i].equals(LOCATION)) {
                format[i] = BLANK;
            } else if (format[i].equals(TRACK)) {
                format[i] = BLANK;
            }
            ++i;
        }
        return format;
    }

    public static String[] getDropTwoColumnByTrackManifestMessageFormat() {
        return Setup.createTwoColumnByTrackDropMessageFormat(Setup.getDropManifestMessageFormat());
    }

    public static String[] getDropTwoColumnByTrackSwitchListMessageFormat() {
        return Setup.createTwoColumnByTrackDropMessageFormat(Setup.getDropSwitchListMessageFormat());
    }

    public static String[] getDropTwoColumnByTrackUtilityManifestMessageFormat() {
        return Setup.createTwoColumnByTrackDropMessageFormat(Setup.getDropUtilityManifestMessageFormat());
    }

    public static String[] getDropTwoColumnByTrackUtilitySwitchListMessageFormat() {
        return Setup.createTwoColumnByTrackDropMessageFormat(Setup.getDropUtilitySwitchListMessageFormat());
    }

    private static String[] createTwoColumnByTrackDropMessageFormat(String[] format) {
        int i = 0;
        while (i < format.length) {
            if (format[i].equals(DESTINATION)) {
                format[i] = BLANK;
            } else if (format[i].equals(TRACK)) {
                format[i] = BLANK;
            }
            ++i;
        }
        return format;
    }

    public static String getDropTextColor() {
        return ColorUtil.colorToColorName(Setup.getDefault().dropColor);
    }

    public static void setDropTextColor(String color) {
        Setup.setDropColor(ColorUtil.stringToColor(color));
    }

    public static void setDropColor(Color c) {
        Setup.getDefault().dropColor = c;
        JmriColorChooser.addRecentColor(c);
    }

    public static String getPickupTextColor() {
        return ColorUtil.colorToColorName(Setup.getDefault().pickupColor);
    }

    public static void setPickupTextColor(String color) {
        Setup.setPickupColor(ColorUtil.stringToColor(color));
    }

    public static void setPickupColor(Color c) {
        Setup.getDefault().pickupColor = c;
        JmriColorChooser.addRecentColor(c);
    }

    public static String getLocalTextColor() {
        return ColorUtil.colorToColorName(Setup.getDefault().localColor);
    }

    public static void setLocalTextColor(String color) {
        Setup.setLocalColor(ColorUtil.stringToColor(color));
    }

    public static void setLocalColor(Color c) {
        Setup.getDefault().localColor = c;
        JmriColorChooser.addRecentColor(c);
    }

    public static Color getPickupColor() {
        return Setup.getDefault().pickupColor;
    }

    public static Color getDropColor() {
        return Setup.getDefault().dropColor;
    }

    public static Color getLocalColor() {
        return Setup.getDefault().localColor;
    }

    public static Color getColor(String colorName) {
        return ColorUtil.stringToColor(colorName);
    }

    public static String getManifestLogoURL() {
        return Setup.getDefault().logoURL;
    }

    public static void setManifestLogoURL(String pathName) {
        Setup.getDefault().logoURL = pathName;
    }

    public static String getOwnerName() {
        return Setup.getDefault().ownerName;
    }

    public static void setOwnerName(String name) {
        Setup.getDefault().ownerName = name;
    }

    public static int getScaleRatio() {
        if (Setup.getDefault().scale == 0) {
            log.error("Scale not set");
        }
        return Setup.getDefault().ratio;
    }

    public static int getScaleTonRatio() {
        if (Setup.getDefault().scale == 0) {
            log.error("Scale not set");
        }
        return Setup.getDefault().ratioTons;
    }

    public static int getInitalWeight() {
        if (Setup.getDefault().scale == 0) {
            log.error("Scale not set");
        }
        return Setup.getDefault().initWeight;
    }

    public static int getAddWeight() {
        if (Setup.getDefault().scale == 0) {
            log.error("Scale not set");
        }
        return Setup.getDefault().addWeight;
    }

    public static int getScale() {
        return Setup.getDefault().scale;
    }

    public static void setScale(int s) {
        Setup.getDefault().scale = s;
        switch (Setup.getDefault().scale) {
            case 1: {
                Setup.getDefault().ratio = 220;
                Setup.getDefault().initWeight = 364;
                Setup.getDefault().addWeight = 100;
                Setup.getDefault().ratioTons = 130;
                break;
            }
            case 2: {
                Setup.getDefault().ratio = 160;
                Setup.getDefault().initWeight = 500;
                Setup.getDefault().addWeight = 150;
                Setup.getDefault().ratioTons = 80;
                break;
            }
            case 3: {
                Setup.getDefault().ratio = 120;
                Setup.getDefault().initWeight = 750;
                Setup.getDefault().addWeight = 375;
                Setup.getDefault().ratioTons = 36;
                break;
            }
            case 4: {
                Setup.getDefault().ratio = 87;
                Setup.getDefault().initWeight = 750;
                Setup.getDefault().addWeight = 375;
                Setup.getDefault().ratioTons = 20;
                break;
            }
            case 5: {
                Setup.getDefault().ratio = 76;
                Setup.getDefault().initWeight = 750;
                Setup.getDefault().addWeight = 500;
                Setup.getDefault().ratioTons = 20;
                break;
            }
            case 6: {
                Setup.getDefault().ratio = 87;
                Setup.getDefault().initWeight = 1000;
                Setup.getDefault().addWeight = 500;
                Setup.getDefault().ratioTons = 20;
                break;
            }
            case 7: {
                Setup.getDefault().ratio = 64;
                Setup.getDefault().initWeight = 1000;
                Setup.getDefault().addWeight = 500;
                Setup.getDefault().ratioTons = 16;
                break;
            }
            case 8: {
                Setup.getDefault().ratio = 64;
                Setup.getDefault().initWeight = 2000;
                Setup.getDefault().addWeight = 500;
                Setup.getDefault().ratioTons = 14;
                break;
            }
            case 9: {
                Setup.getDefault().ratio = 48;
                Setup.getDefault().initWeight = 1500;
                Setup.getDefault().addWeight = 750;
                Setup.getDefault().ratioTons = 8;
                break;
            }
            case 10: {
                Setup.getDefault().ratio = 48;
                Setup.getDefault().initWeight = 5000;
                Setup.getDefault().addWeight = 1000;
                Setup.getDefault().ratioTons = 5;
                break;
            }
            case 11: {
                Setup.getDefault().ratio = 32;
                Setup.getDefault().initWeight = 10000;
                Setup.getDefault().addWeight = 2000;
                Setup.getDefault().ratioTons = 2;
                break;
            }
            default: {
                log.error("Unknown scale");
            }
        }
    }

    public static JComboBox<String> getManifestFormatComboBox() {
        JComboBox<String> box = new JComboBox<String>();
        box.addItem(STANDARD_FORMAT);
        box.addItem(TWO_COLUMN_FORMAT);
        box.addItem(TWO_COLUMN_TRACK_FORMAT);
        return box;
    }

    public static JComboBox<String> getOrientationComboBox() {
        JComboBox<String> box = new JComboBox<String>();
        box.addItem(PORTRAIT);
        box.addItem(LANDSCAPE);
        box.addItem(HALFPAGE);
        box.addItem(HANDHELD);
        return box;
    }

    public static JComboBox<String> getSwitchListPageFormatComboBox() {
        JComboBox<String> box = new JComboBox<String>();
        box.addItem(PAGE_NORMAL);
        box.addItem(PAGE_PER_TRAIN);
        box.addItem(PAGE_PER_VISIT);
        return box;
    }

    public static JComboBox<String> getEngineMessageComboBox() {
        JComboBox<String> box = new JComboBox<String>();
        box.addItem(BLANK);
        String[] stringArray = Setup.getEngineAttributes();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String attribute = stringArray[n2];
            box.addItem(attribute);
            ++n2;
        }
        if (Setup.isTabEnabled()) {
            box.addItem(TAB);
            box.addItem(TAB2);
            box.addItem(TAB3);
        }
        return box;
    }

    public static JComboBox<String> getCarMessageComboBox() {
        JComboBox<String> box = new JComboBox<String>();
        box.addItem(BLANK);
        String[] stringArray = Setup.getCarAttributes();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String attribute = stringArray[n2];
            box.addItem(attribute);
            ++n2;
        }
        if (Setup.isTabEnabled()) {
            box.addItem(TAB);
            box.addItem(TAB2);
            box.addItem(TAB3);
        }
        return box;
    }

    public static JComboBox<String> getTrainDirectionComboBox() {
        JComboBox<String> box = new JComboBox<String>();
        for (String direction : Setup.getTrainDirectionList()) {
            box.addItem(direction);
        }
        return box;
    }

    public static List<String> getTrainDirectionList() {
        ArrayList<String> directions = new ArrayList<String>();
        if ((Setup.getDefault().traindir & 1) == 1) {
            directions.add(EAST_DIR);
        }
        if ((Setup.getDefault().traindir & 2) == 2) {
            directions.add(WEST_DIR);
        }
        if ((Setup.getDefault().traindir & 4) == 4) {
            directions.add(NORTH_DIR);
        }
        if ((Setup.getDefault().traindir & 8) == 8) {
            directions.add(SOUTH_DIR);
        }
        return directions;
    }

    public static String getDirectionString(int direction) {
        switch (direction) {
            case 1: {
                return EAST_DIR;
            }
            case 2: {
                return WEST_DIR;
            }
            case 4: {
                return NORTH_DIR;
            }
            case 8: {
                return SOUTH_DIR;
            }
        }
        return "unknown";
    }

    public static String[] getDirectionStrings(int directions) {
        String[] dir = new String[4];
        int i = 0;
        if ((directions & 1) == 1) {
            dir[i++] = EAST_DIR;
        }
        if ((directions & 2) == 2) {
            dir[i++] = WEST_DIR;
        }
        if ((directions & 4) == 4) {
            dir[i++] = NORTH_DIR;
        }
        if ((directions & 8) == 8) {
            dir[i++] = SOUTH_DIR;
        }
        return dir;
    }

    public static int getDirectionInt(String direction) {
        if (direction.equals(EAST_DIR)) {
            return 1;
        }
        if (direction.equals(WEST_DIR)) {
            return 2;
        }
        if (direction.equals(NORTH_DIR)) {
            return 4;
        }
        if (direction.equals(SOUTH_DIR)) {
            return 8;
        }
        return 0;
    }

    public static Element store() {
        Element values;
        Element e = new Element("operations");
        if (!InstanceManager.getDefault(WebServerPreferences.class).getRailroadName().equals(Setup.getRailroadName())) {
            values = new Element("railRoad");
            e.addContent((Content)values);
            values.setAttribute("name", Setup.getRailroadName());
        }
        values = new Element("setup");
        e.addContent((Content)values);
        values.setAttribute("comment", Setup.getComment());
        values = new Element("settings");
        e.addContent((Content)values);
        values.setAttribute("mainMenu", Setup.isMainMenuEnabled() ? "true" : "false");
        values.setAttribute("closeOnSave", Setup.isCloseWindowOnSaveEnabled() ? "true" : "false");
        values.setAttribute("autoSave", Setup.isAutoSaveEnabled() ? "true" : "false");
        values.setAttribute("autoBackup", Setup.isAutoBackupEnabled() ? "true" : "false");
        values.setAttribute("trainDirection", Integer.toString(Setup.getTrainDirection()));
        values.setAttribute("trainLength", Integer.toString(Setup.getMaxTrainLength()));
        values.setAttribute("maxEngines", Integer.toString(Setup.getMaxNumberEngines()));
        values.setAttribute("hpt", Integer.toString(Setup.getHorsePowerPerTon()));
        values.setAttribute("scale", Integer.toString(Setup.getScale()));
        values.setAttribute("carTypes", Setup.getCarTypes());
        values.setAttribute("switchTime", Integer.toString(Setup.getSwitchTime()));
        values.setAttribute("travelTime", Integer.toString(Setup.getTravelTime()));
        values.setAttribute("showValue", Setup.isValueEnabled() ? "true" : "false");
        values.setAttribute("valueLabel", Setup.getValueLabel());
        values.setAttribute("showRfid", Setup.isRfidEnabled() ? "true" : "false");
        values.setAttribute("rfidLabel", Setup.getRfidLabel());
        values.setAttribute("lengthUnit", Setup.getLengthUnit());
        values.setAttribute("yearModeled", Setup.getYearModeled());
        values = new Element("pickupEngFormat");
        e.addContent((Content)values);
        Setup.storeXmlMessageFormat(values, Setup.getPickupEnginePrefix(), Setup.getPickupEngineMessageFormat());
        values = new Element("dropEngFormat");
        e.addContent((Content)values);
        Setup.storeXmlMessageFormat(values, Setup.getDropEnginePrefix(), Setup.getDropEngineMessageFormat());
        values = new Element("pickupCarFormat");
        e.addContent((Content)values);
        Setup.storeXmlMessageFormat(values, Setup.getPickupCarPrefix(), Setup.getPickupManifestMessageFormat());
        values = new Element("dropCarFormat");
        e.addContent((Content)values);
        Setup.storeXmlMessageFormat(values, Setup.getDropCarPrefix(), Setup.getDropManifestMessageFormat());
        values = new Element("localFormat");
        e.addContent((Content)values);
        Setup.storeXmlMessageFormat(values, Setup.getLocalPrefix(), Setup.getLocalManifestMessageFormat());
        values = new Element("missingCarFormat");
        e.addContent((Content)values);
        Setup.storeXmlMessageFormat(values, NONE, Setup.getMissingCarMessageFormat());
        values = new Element("switchList");
        e.addContent((Content)values);
        values.setAttribute("sameAsManifest", Setup.isSwitchListFormatSameAsManifest() ? "true" : "false");
        values.setAttribute("realTime", Setup.isSwitchListRealTime() ? "true" : "false");
        values.setAttribute("allTrains", Setup.isSwitchListAllTrainsEnabled() ? "true" : "false");
        String format = "pageNormal";
        if (Setup.getSwitchListPageFormat().equals(PAGE_PER_TRAIN)) {
            format = "pagePerTrain";
            values.setAttribute("pageMode", "true");
        } else if (Setup.getSwitchListPageFormat().equals(PAGE_PER_VISIT)) {
            format = "pagePerVisit";
        }
        values.setAttribute("pageFormat", format);
        values.setAttribute("printRouteLocation", Setup.isSwitchListRouteLocationCommentEnabled() ? "true" : "false");
        values.setAttribute("trackSummary", Setup.isPrintTrackSummaryEnabled() ? "true" : "false");
        values = new Element("switchListPickupCarFormat");
        e.addContent((Content)values);
        Setup.storeXmlMessageFormat(values, Setup.getSwitchListPickupCarPrefix(), Setup.getPickupSwitchListMessageFormat());
        values = new Element("switchListDropCarFormat");
        e.addContent((Content)values);
        Setup.storeXmlMessageFormat(values, Setup.getSwitchListDropCarPrefix(), Setup.getDropSwitchListMessageFormat());
        values = new Element("switchListLocalFormat");
        e.addContent((Content)values);
        Setup.storeXmlMessageFormat(values, Setup.getSwitchListLocalPrefix(), Setup.getLocalSwitchListMessageFormat());
        values = new Element("panel");
        e.addContent((Content)values);
        values.setAttribute("name", Setup.getPanelName());
        values.setAttribute("trainIconXY", Setup.isTrainIconCordEnabled() ? "true" : "false");
        values.setAttribute("trainIconAppend", Setup.isTrainIconAppendEnabled() ? "true" : "false");
        values = new Element("fontName");
        e.addContent((Content)values);
        values.setAttribute("name", Setup.getFontName());
        values = new Element("fontSize");
        e.addContent((Content)values);
        values.setAttribute("size", Integer.toString(Setup.getManifestFontSize()));
        values = new Element("pageOrientation");
        e.addContent((Content)values);
        values.setAttribute("manifest", Setup.getManifestOrientation());
        values.setAttribute("switchList", Setup.getSwitchListOrientation());
        values = new Element("manifestColors");
        e.addContent((Content)values);
        values.setAttribute("dropColor", Setup.getDropTextColor());
        values.setAttribute("pickupColor", Setup.getPickupTextColor());
        values.setAttribute("localColor", Setup.getLocalTextColor());
        values = new Element("tab");
        e.addContent((Content)values);
        values.setAttribute("enabled", Setup.isTabEnabled() ? "true" : "false");
        values.setAttribute("length", Integer.toString(Setup.getTab1Length()));
        values.setAttribute("tab2Length", Integer.toString(Setup.getTab2Length()));
        values.setAttribute("tab3Length", Integer.toString(Setup.getTab3Length()));
        values = new Element("manifest");
        e.addContent((Content)values);
        values.setAttribute("printLocComments", Setup.isPrintLocationCommentsEnabled() ? "true" : "false");
        values.setAttribute("printRouteComments", Setup.isPrintRouteCommentsEnabled() ? "true" : "false");
        values.setAttribute("printLoadsEmpties", Setup.isPrintLoadsAndEmptiesEnabled() ? "true" : "false");
        values.setAttribute("printTimetable", Setup.isPrintTrainScheduleNameEnabled() ? "true" : "false");
        values.setAttribute("use12hrFormat", Setup.is12hrFormatEnabled() ? "true" : "false");
        values.setAttribute("printValid", Setup.isPrintValidEnabled() ? "true" : "false");
        values.setAttribute("sortByTrack", Setup.isSortByTrackNameEnabled() ? "true" : "false");
        values.setAttribute("printPageHeader", Setup.isPrintPageHeaderEnabled() ? "true" : "false");
        values.setAttribute("printHeaders", Setup.isPrintHeadersEnabled() ? "true" : "false");
        values.setAttribute("truncate", Setup.isPrintTruncateManifestEnabled() ? "true" : "false");
        values.setAttribute("useDepartureTime", Setup.isUseDepartureTimeEnabled() ? "true" : "false");
        values.setAttribute("useEditor", Setup.isManifestEditorEnabled() ? "true" : "false");
        values.setAttribute("printCabooseLoad", Setup.isPrintCabooseLoadEnabled() ? "true" : "false");
        values.setAttribute("printPassengerLoad", Setup.isPrintPassengerLoadEnabled() ? "true" : "false");
        values.setAttribute("hazardousMsg", Setup.getHazardousMsg());
        values = new Element("manifestFormat");
        e.addContent((Content)values);
        String value = "0";
        if (Setup.getManifestFormat().equals(TWO_COLUMN_FORMAT)) {
            value = BUILD_REPORT_MINIMAL;
        } else if (Setup.getManifestFormat().equals(TWO_COLUMN_TRACK_FORMAT)) {
            value = "2";
        }
        values.setAttribute("value", value);
        if (!Setup.getManifestLogoURL().equals(NONE)) {
            values = new Element("manifestLogo");
            values.setAttribute("name", Setup.getManifestLogoURL());
            e.addContent((Content)values);
        }
        values = new Element("manifestFileOptions");
        e.addContent((Content)values);
        values.setAttribute("manifestSave", Setup.isSaveTrainManifestsEnabled() ? "true" : "false");
        values = new Element("buildOptions");
        e.addContent((Content)values);
        values.setAttribute("aggressive", Setup.isBuildAggressive() ? "true" : "false");
        values.setAttribute("numberPasses", Integer.toString(Setup.getNumberPasses()));
        values.setAttribute("allowLocalInterchange", Setup.isLocalInterchangeMovesEnabled() ? "true" : "false");
        values.setAttribute("allowLocalSpur", Setup.isLocalSpurMovesEnabled() ? "true" : "false");
        values.setAttribute("allowLocalYard", Setup.isLocalYardMovesEnabled() ? "true" : "false");
        values.setAttribute("stagingRestrictionEnabled", Setup.isStagingTrainCheckEnabled() ? "true" : "false");
        values.setAttribute("stagingTrackAvail", Setup.isStagingTrackImmediatelyAvail() ? "true" : "false");
        values.setAttribute("allowReturnStaging", Setup.isStagingAllowReturnEnabled() ? "true" : "false");
        values.setAttribute("promptStagingEnabled", Setup.isStagingPromptFromEnabled() ? "true" : "false");
        values.setAttribute("promptToStagingEnabled", Setup.isStagingPromptToEnabled() ? "true" : "false");
        values.setAttribute("stagingTryNormal", Setup.isStagingTryNormalBuildEnabled() ? "true" : "false");
        values.setAttribute("generateCsvManifest", Setup.isGenerateCsvManifestEnabled() ? "true" : "false");
        values.setAttribute("generateCsvSwitchList", Setup.isGenerateCsvSwitchListEnabled() ? "true" : "false");
        values = new Element("buildReport");
        e.addContent((Content)values);
        values.setAttribute("level", Setup.getBuildReportLevel());
        values.setAttribute("routerLevel", Setup.getRouterBuildReportLevel());
        values.setAttribute("useEditor", Setup.isBuildReportEditorEnabled() ? "true" : "false");
        values.setAttribute("indent", Setup.isBuildReportIndentEnabled() ? "true" : "false");
        values.setAttribute("alwaysPreview", Setup.isBuildReportAlwaysPreviewEnabled() ? "true" : "false");
        values.setAttribute("fontSize", Integer.toString(Setup.getBuildReportFontSize()));
        values = new Element("router");
        e.addContent((Content)values);
        values.setAttribute("carRoutingEnabled", Setup.isCarRoutingEnabled() ? "true" : "false");
        values.setAttribute("carRoutingViaYards", Setup.isCarRoutingViaYardsEnabled() ? "true" : "false");
        values.setAttribute("carRoutingViaStaging", Setup.isCarRoutingViaStagingEnabled() ? "true" : "false");
        values.setAttribute("forwardToYard", Setup.isForwardToYardEnabled() ? "true" : "false");
        values.setAttribute("onlyActiveTrains", Setup.isOnlyActiveTrainsEnabled() ? "true" : "false");
        values.setAttribute("checkCarDestination", Setup.isCheckCarDestinationEnabled() ? "true" : "false");
        values = new Element("logger");
        e.addContent((Content)values);
        values.setAttribute("carLogger", Setup.isCarLoggerEnabled() ? "true" : "false");
        values.setAttribute("engineLogger", Setup.isEngineLoggerEnabled() ? "true" : "false");
        values.setAttribute("trainLogger", Setup.isTrainLoggerEnabled() ? "true" : "false");
        values = new Element("owner");
        e.addContent((Content)values);
        values.setAttribute("name", Setup.getOwnerName());
        values = new Element("iconColor");
        e.addContent((Content)values);
        values.setAttribute("north", Setup.getTrainIconColorNorth());
        values.setAttribute("south", Setup.getTrainIconColorSouth());
        values.setAttribute("east", Setup.getTrainIconColorEast());
        values.setAttribute("west", Setup.getTrainIconColorWest());
        values.setAttribute("local", Setup.getTrainIconColorLocal());
        values.setAttribute("terminate", Setup.getTrainIconColorTerminate());
        values = new Element("comments");
        e.addContent((Content)values);
        values.setAttribute("misplacedCars", Setup.getMiaComment());
        values = new Element("display");
        e.addContent((Content)values);
        values.setAttribute("showTrackMoves", Setup.isShowTrackMovesEnabled() ? "true" : "false");
        if (Setup.isVsdPhysicalLocationEnabled()) {
            values = new Element("vsd");
            e.addContent((Content)values);
            values.setAttribute("enablePhysicalLocations", Setup.isVsdPhysicalLocationEnabled() ? "true" : "false");
        }
        values = new Element("CATS");
        e.addContent((Content)values);
        values.setAttribute("exactLocationName", AbstractOperationsServer.isExactLoationNameEnabled() ? "true" : "false");
        return e;
    }

    private static void storeXmlMessageFormat(Element values, String prefix, String[] messageFormat) {
        values.setAttribute("prefix", prefix);
        StringBuilder buf = new StringBuilder();
        Setup.stringToTagConversion(messageFormat);
        String[] stringArray = messageFormat;
        int n = messageFormat.length;
        int n2 = 0;
        while (n2 < n) {
            String attibute = stringArray[n2];
            buf.append(attibute).append(",");
            ++n2;
        }
        values.setAttribute("setting", buf.toString());
    }

    public static void load(Element e) {
        String enable;
        Attribute a;
        Element operations;
        block216: {
            block215: {
                String enable2;
                String[] keys;
                String setting;
                block211: {
                    String b;
                    block214: {
                        block212: {
                            String b2;
                            String[] keys2;
                            String setting2;
                            if (e.getChild("operations") == null) {
                                log.debug("operation setup values missing");
                                return;
                            }
                            operations = e.getChild("operations");
                            if (operations.getChild("railRoad") != null && (a = operations.getChild("railRoad").getAttribute("name")) != null) {
                                String name = a.getValue();
                                log.debug("railroadName: {}", (Object)name);
                                if (!name.equals("useJmriRailroadName")) {
                                    Setup.getDefault().railroadName = name;
                                }
                            }
                            if (operations.getChild("setup") != null && (a = operations.getChild("setup").getAttribute("comment")) != null) {
                                String comment = a.getValue();
                                log.debug("setup comment: {}", (Object)comment);
                                Setup.getDefault().setupComment = comment;
                            }
                            if (operations.getChild("settings") != null) {
                                String label;
                                String enable3;
                                String minutes;
                                String enabled;
                                a = operations.getChild("settings").getAttribute("mainMenu");
                                if (a != null) {
                                    enabled = a.getValue();
                                    log.debug("mainMenu: {}", (Object)enabled);
                                    Setup.setMainMenuEnabled(enabled.equals("true"));
                                }
                                if ((a = operations.getChild("settings").getAttribute("closeOnSave")) != null) {
                                    enabled = a.getValue();
                                    log.debug("closeOnSave: {}", (Object)enabled);
                                    Setup.setCloseWindowOnSaveEnabled(enabled.equals("true"));
                                }
                                if ((a = operations.getChild("settings").getAttribute("trainDirection")) != null) {
                                    String dir = a.getValue();
                                    log.debug("direction: {}", (Object)dir);
                                    try {
                                        Setup.setTrainDirection(Integer.parseInt(dir));
                                    }
                                    catch (NumberFormatException numberFormatException) {
                                        log.error("Train direction ({}) isn't a valid number", (Object)a.getValue());
                                    }
                                }
                                if ((a = operations.getChild("settings").getAttribute("trainLength")) != null) {
                                    String length = a.getValue();
                                    log.debug("Max train length: {}", (Object)length);
                                    try {
                                        Setup.setMaxTrainLength(Integer.parseInt(length));
                                    }
                                    catch (NumberFormatException numberFormatException) {
                                        log.error("Train maximum length ({}) isn't a valid number", (Object)a.getValue());
                                    }
                                }
                                if ((a = operations.getChild("settings").getAttribute("maxEngines")) != null) {
                                    String size = a.getValue();
                                    log.debug("Max number of engines: {}", (Object)size);
                                    try {
                                        Setup.setMaxNumberEngines(Integer.parseInt(size));
                                    }
                                    catch (NumberFormatException numberFormatException) {
                                        log.error("Maximum number of engines ({}) isn't a valid number", (Object)a.getValue());
                                    }
                                }
                                if ((a = operations.getChild("settings").getAttribute("hpt")) != null) {
                                    String value = a.getValue();
                                    log.debug("HPT: {}", (Object)value);
                                    try {
                                        Setup.setHorsePowerPerTon(Integer.parseInt(value));
                                    }
                                    catch (NumberFormatException numberFormatException) {
                                        log.error("Train HPT ({}) isn't a valid number", (Object)a.getValue());
                                    }
                                }
                                if ((a = operations.getChild("settings").getAttribute("scale")) != null) {
                                    String scale = a.getValue();
                                    log.debug("scale: {}", (Object)scale);
                                    try {
                                        Setup.setScale(Integer.parseInt(scale));
                                    }
                                    catch (NumberFormatException numberFormatException) {
                                        log.error("Scale ({}) isn't a valid number", (Object)a.getValue());
                                    }
                                }
                                if ((a = operations.getChild("settings").getAttribute("carTypes")) != null) {
                                    String types = a.getValue();
                                    log.debug("CarTypes: {}", (Object)types);
                                    Setup.setCarTypes(types);
                                }
                                if ((a = operations.getChild("settings").getAttribute("switchTime")) != null) {
                                    minutes = a.getValue();
                                    log.debug("switchTime: {}", (Object)minutes);
                                    try {
                                        Setup.setSwitchTime(Integer.parseInt(minutes));
                                    }
                                    catch (NumberFormatException numberFormatException) {
                                        log.error("Switch time ({}) isn't a valid number", (Object)a.getValue());
                                    }
                                }
                                if ((a = operations.getChild("settings").getAttribute("travelTime")) != null) {
                                    minutes = a.getValue();
                                    log.debug("travelTime: {}", (Object)minutes);
                                    try {
                                        Setup.setTravelTime(Integer.parseInt(minutes));
                                    }
                                    catch (NumberFormatException numberFormatException) {
                                        log.error("Travel time ({}) isn't a valid number", (Object)a.getValue());
                                    }
                                }
                                if ((a = operations.getChild("settings").getAttribute("showValue")) != null) {
                                    enable3 = a.getValue();
                                    log.debug("showValue: {}", (Object)enable3);
                                    Setup.setValueEnabled(enable3.equals("true"));
                                }
                                if ((a = operations.getChild("settings").getAttribute("valueLabel")) != null) {
                                    label = a.getValue();
                                    log.debug("valueLabel: {}", (Object)label);
                                    Setup.setValueLabel(label);
                                }
                                if ((a = operations.getChild("settings").getAttribute("showRfid")) != null) {
                                    enable3 = a.getValue();
                                    log.debug("showRfid: {}", (Object)enable3);
                                    Setup.setRfidEnabled(enable3.equals("true"));
                                }
                                if ((a = operations.getChild("settings").getAttribute("rfidLabel")) != null) {
                                    label = a.getValue();
                                    log.debug("rfidLabel: {}", (Object)label);
                                    Setup.setRfidLabel(label);
                                }
                                if ((a = operations.getChild("settings").getAttribute("lengthUnit")) != null) {
                                    String unit = a.getValue();
                                    log.debug("lengthUnit: {}", (Object)unit);
                                    Setup.setLengthUnit(unit);
                                }
                                if ((a = operations.getChild("settings").getAttribute("yearModeled")) != null) {
                                    String year = a.getValue();
                                    log.debug("yearModeled: {}", (Object)year);
                                    Setup.setYearModeled(year);
                                }
                                if ((a = operations.getChild("settings").getAttribute("printLocComments")) != null) {
                                    enable3 = a.getValue();
                                    log.debug("printLocComments: {}", (Object)enable3);
                                    Setup.setPrintLocationCommentsEnabled(enable3.equals("true"));
                                }
                                if ((a = operations.getChild("settings").getAttribute("printRouteComments")) != null) {
                                    enable3 = a.getValue();
                                    log.debug("printRouteComments: {}", (Object)enable3);
                                    Setup.setPrintRouteCommentsEnabled(enable3.equals("true"));
                                }
                                if ((a = operations.getChild("settings").getAttribute("printLoadsEmpties")) != null) {
                                    enable3 = a.getValue();
                                    log.debug("printLoadsEmpties: {}", (Object)enable3);
                                    Setup.setPrintLoadsAndEmptiesEnabled(enable3.equals("true"));
                                }
                                if ((a = operations.getChild("settings").getAttribute("printTimetable")) != null) {
                                    enable3 = a.getValue();
                                    log.debug("printTrainSchedule: {}", (Object)enable3);
                                    Setup.setPrintTrainScheduleNameEnabled(enable3.equals("true"));
                                }
                                if ((a = operations.getChild("settings").getAttribute("use12hrFormat")) != null) {
                                    enable3 = a.getValue();
                                    log.debug("use12hrFormat: {}", (Object)enable3);
                                    Setup.set12hrFormatEnabled(enable3.equals("true"));
                                }
                                if ((a = operations.getChild("settings").getAttribute("printValid")) != null) {
                                    enable3 = a.getValue();
                                    log.debug("printValid: {}", (Object)enable3);
                                    Setup.setPrintValidEnabled(enable3.equals("true"));
                                }
                                if ((a = operations.getChild("settings").getAttribute("sortByTrack")) != null) {
                                    enable3 = a.getValue();
                                    log.debug("sortByTrack: {}", (Object)enable3);
                                    Setup.setSortByTrackNameEnabled(enable3.equals("true"));
                                }
                                if ((a = operations.getChild("settings").getAttribute("printHeaders")) != null) {
                                    enable3 = a.getValue();
                                    log.debug("printHeaders: {}", (Object)enable3);
                                    Setup.setPrintHeadersEnabled(enable3.equals("true"));
                                }
                            }
                            if (operations.getChild("pickupEngFormat") != null) {
                                a = operations.getChild("pickupEngFormat").getAttribute("prefix");
                                if (a != null) {
                                    Setup.setPickupEnginePrefix(a.getValue());
                                }
                                if ((a = operations.getChild("pickupEngFormat").getAttribute("setting")) != null) {
                                    setting2 = a.getValue();
                                    log.debug("pickupEngFormat: {}", (Object)setting2);
                                    keys2 = setting2.split(",");
                                    Setup.keyToStringConversion(keys2);
                                    Setup.setPickupEngineMessageFormat(keys2);
                                }
                            }
                            if (operations.getChild("dropEngFormat") != null) {
                                a = operations.getChild("dropEngFormat").getAttribute("prefix");
                                if (a != null) {
                                    Setup.setDropEnginePrefix(a.getValue());
                                }
                                if ((a = operations.getChild("dropEngFormat").getAttribute("setting")) != null) {
                                    setting2 = a.getValue();
                                    log.debug("dropEngFormat: {}", (Object)setting2);
                                    keys2 = setting2.split(",");
                                    Setup.keyToStringConversion(keys2);
                                    Setup.setDropEngineMessageFormat(keys2);
                                }
                            }
                            if (operations.getChild("pickupCarFormat") != null) {
                                a = operations.getChild("pickupCarFormat").getAttribute("prefix");
                                if (a != null) {
                                    Setup.setPickupCarPrefix(a.getValue());
                                }
                                if ((a = operations.getChild("pickupCarFormat").getAttribute("setting")) != null) {
                                    setting2 = a.getValue();
                                    log.debug("pickupCarFormat: {}", (Object)setting2);
                                    keys2 = setting2.split(",");
                                    Setup.replaceOldFormat(keys2);
                                    Setup.xmlAttributeToKeyConversion(keys2);
                                    Setup.keyToStringConversion(keys2);
                                    Setup.setPickupManifestMessageFormat(keys2);
                                }
                            }
                            if (operations.getChild("dropCarFormat") != null) {
                                a = operations.getChild("dropCarFormat").getAttribute("prefix");
                                if (a != null) {
                                    Setup.setDropCarPrefix(a.getValue());
                                }
                                if ((a = operations.getChild("dropCarFormat").getAttribute("setting")) != null) {
                                    setting2 = a.getValue();
                                    log.debug("dropCarFormat: {}", (Object)setting2);
                                    keys2 = setting2.split(",");
                                    Setup.replaceOldFormat(keys2);
                                    Setup.xmlAttributeToKeyConversion(keys2);
                                    Setup.keyToStringConversion(keys2);
                                    Setup.setDropManifestMessageFormat(keys2);
                                }
                            }
                            if (operations.getChild("localFormat") != null) {
                                a = operations.getChild("localFormat").getAttribute("prefix");
                                if (a != null) {
                                    Setup.setLocalPrefix(a.getValue());
                                }
                                if ((a = operations.getChild("localFormat").getAttribute("setting")) != null) {
                                    setting2 = a.getValue();
                                    log.debug("localFormat: {}", (Object)setting2);
                                    keys2 = setting2.split(",");
                                    Setup.replaceOldFormat(keys2);
                                    Setup.xmlAttributeToKeyConversion(keys2);
                                    Setup.keyToStringConversion(keys2);
                                    Setup.setLocalManifestMessageFormat(keys2);
                                }
                            }
                            if (operations.getChild("missingCarFormat") != null && (a = operations.getChild("missingCarFormat").getAttribute("setting")) != null) {
                                setting2 = a.getValue();
                                log.debug("missingCarFormat: {}", (Object)setting2);
                                keys2 = setting2.split(",");
                                Setup.keyToStringConversion(keys2);
                                Setup.setMissingCarMessageFormat(keys2);
                            }
                            if (operations.getChild("switchList") == null) break block211;
                            a = operations.getChild("switchList").getAttribute("sameAsManifest");
                            if (a != null) {
                                b2 = a.getValue();
                                log.debug("sameAsManifest: {}", (Object)b2);
                                Setup.setSwitchListFormatSameAsManifest(b2.equals("true"));
                            }
                            if ((a = operations.getChild("switchList").getAttribute("realTime")) != null) {
                                b2 = a.getValue();
                                log.debug("realTime: {}", (Object)b2);
                                Setup.getDefault().switchListRealTime = b2.equals("true");
                            }
                            if ((a = operations.getChild("switchList").getAttribute("allTrains")) != null) {
                                b2 = a.getValue();
                                log.debug("allTrains: {}", (Object)b2);
                                Setup.getDefault().switchListAllTrains = b2.equals("true");
                            }
                            if ((a = operations.getChild("switchList").getAttribute("pageFormat")) == null) break block212;
                            switch (a.getValue()) {
                                case "pageNormal": {
                                    Setup.getDefault().switchListPageFormat = PAGE_NORMAL;
                                    break;
                                }
                                case "pagePerTrain": {
                                    Setup.getDefault().switchListPageFormat = PAGE_PER_TRAIN;
                                    break;
                                }
                                case "pagePerVisit": {
                                    Setup.getDefault().switchListPageFormat = PAGE_PER_VISIT;
                                    break;
                                }
                                default: {
                                    log.error("Unknown switch list page format {}", (Object)a.getValue());
                                    break;
                                }
                            }
                            break block214;
                        }
                        a = operations.getChild("switchList").getAttribute("pageMode");
                        if (a != null) {
                            b = a.getValue();
                            log.debug("old style pageMode: {}", (Object)b);
                            if (b.equals("true")) {
                                Setup.getDefault().switchListPageFormat = PAGE_PER_TRAIN;
                            }
                        }
                    }
                    if ((a = operations.getChild("switchList").getAttribute("printRouteLocation")) != null) {
                        b = a.getValue();
                        log.debug("print route location comment: {}", (Object)b);
                        Setup.setSwitchListRouteLocationCommentEnabled(b.equals("true"));
                    }
                    if ((a = operations.getChild("switchList").getAttribute("trackSummary")) != null) {
                        b = a.getValue();
                        log.debug("track summary: {}", (Object)b);
                        Setup.setPrintTrackSummaryEnabled(b.equals("true"));
                    }
                }
                if (operations.getChild("switchListPickupCarFormat") != null) {
                    a = operations.getChild("switchListPickupCarFormat").getAttribute("prefix");
                    if (a != null) {
                        Setup.setSwitchListPickupCarPrefix(a.getValue());
                    }
                    if ((a = operations.getChild("switchListPickupCarFormat").getAttribute("setting")) != null) {
                        setting = a.getValue();
                        log.debug("switchListpickupCarFormat: {}", (Object)setting);
                        keys = setting.split(",");
                        Setup.replaceOldFormat(keys);
                        Setup.xmlAttributeToKeyConversion(keys);
                        Setup.keyToStringConversion(keys);
                        Setup.setPickupSwitchListMessageFormat(keys);
                    }
                }
                if (operations.getChild("switchListDropCarFormat") != null) {
                    a = operations.getChild("switchListDropCarFormat").getAttribute("prefix");
                    if (a != null) {
                        Setup.setSwitchListDropCarPrefix(a.getValue());
                    }
                    if ((a = operations.getChild("switchListDropCarFormat").getAttribute("setting")) != null) {
                        setting = a.getValue();
                        log.debug("switchListDropCarFormat: {}", (Object)setting);
                        keys = setting.split(",");
                        Setup.replaceOldFormat(keys);
                        Setup.xmlAttributeToKeyConversion(keys);
                        Setup.keyToStringConversion(keys);
                        Setup.setDropSwitchListMessageFormat(keys);
                    }
                }
                if (operations.getChild("switchListLocalFormat") != null) {
                    a = operations.getChild("switchListLocalFormat").getAttribute("prefix");
                    if (a != null) {
                        Setup.setSwitchListLocalPrefix(a.getValue());
                    }
                    if ((a = operations.getChild("switchListLocalFormat").getAttribute("setting")) != null) {
                        setting = a.getValue();
                        log.debug("switchListLocalFormat: {}", (Object)setting);
                        keys = setting.split(",");
                        Setup.replaceOldFormat(keys);
                        Setup.xmlAttributeToKeyConversion(keys);
                        Setup.keyToStringConversion(keys);
                        Setup.setLocalSwitchListMessageFormat(keys);
                    }
                }
                if (operations.getChild("panel") != null) {
                    a = operations.getChild("panel").getAttribute("name");
                    if (a != null) {
                        String panel = a.getValue();
                        log.debug("panel: {}", (Object)panel);
                        Setup.setPanelName(panel);
                    }
                    if ((a = operations.getChild("panel").getAttribute("trainIconXY")) != null) {
                        enable2 = a.getValue();
                        log.debug("TrainIconXY: {}", (Object)enable2);
                        Setup.setTrainIconCordEnabled(enable2.equals("true"));
                    }
                    if ((a = operations.getChild("panel").getAttribute("trainIconAppend")) != null) {
                        enable2 = a.getValue();
                        log.debug("TrainIconAppend: {}", (Object)enable2);
                        Setup.setTrainIconAppendEnabled(enable2.equals("true"));
                    }
                }
                if (operations.getChild("fontName") != null && (a = operations.getChild("fontName").getAttribute("name")) != null) {
                    String font = a.getValue();
                    log.debug("fontName: {}", (Object)font);
                    Setup.setFontName(font);
                }
                if (operations.getChild("fontSize") != null && (a = operations.getChild("fontSize").getAttribute("size")) != null) {
                    String size = a.getValue();
                    log.debug("fontsize: {}", (Object)size);
                    try {
                        Setup.setManifestFontSize(Integer.parseInt(size));
                    }
                    catch (NumberFormatException numberFormatException) {
                        log.error("Manifest font size ({}) isn't a valid number", (Object)a.getValue());
                    }
                }
                if (operations.getChild("pageOrientation") != null) {
                    String orientation;
                    a = operations.getChild("pageOrientation").getAttribute("manifest");
                    if (a != null) {
                        orientation = a.getValue();
                        log.debug("manifestOrientation: {}", (Object)orientation);
                        Setup.setManifestOrientation(orientation);
                    }
                    if ((a = operations.getChild("pageOrientation").getAttribute("switchList")) != null) {
                        orientation = a.getValue();
                        log.debug("switchListOrientation: {}", (Object)orientation);
                        Setup.setSwitchListOrientation(orientation);
                    }
                }
                if (operations.getChild("manifestColors") != null) {
                    a = operations.getChild("manifestColors").getAttribute("dropColor");
                    if (a != null) {
                        String dropColor = a.getValue();
                        log.debug("dropColor: {}", (Object)dropColor);
                        Setup.setDropTextColor(dropColor);
                    }
                    if ((a = operations.getChild("manifestColors").getAttribute("pickupColor")) != null) {
                        String pickupColor = a.getValue();
                        log.debug("pickupColor: {}", (Object)pickupColor);
                        Setup.setPickupTextColor(pickupColor);
                    }
                    if ((a = operations.getChild("manifestColors").getAttribute("localColor")) != null) {
                        String localColor = a.getValue();
                        log.debug("localColor: {}", (Object)localColor);
                        Setup.setLocalTextColor(localColor);
                    }
                }
                if (operations.getChild("tab") != null) {
                    String length;
                    a = operations.getChild("tab").getAttribute("enabled");
                    if (a != null) {
                        enable2 = a.getValue();
                        log.debug("tab: {}", (Object)enable2);
                        Setup.setTabEnabled(enable2.equals("true"));
                    }
                    if ((a = operations.getChild("tab").getAttribute("length")) != null) {
                        length = a.getValue();
                        log.debug("tab 1 length: {}", (Object)length);
                        try {
                            Setup.setTab1length(Integer.parseInt(length));
                        }
                        catch (NumberFormatException numberFormatException) {
                            log.error("Tab 1 length ({}) isn't a valid number", (Object)a.getValue());
                        }
                    }
                    if ((a = operations.getChild("tab").getAttribute("tab2Length")) != null) {
                        length = a.getValue();
                        log.debug("tab 2 length: {}", (Object)length);
                        try {
                            Setup.setTab2length(Integer.parseInt(length));
                        }
                        catch (NumberFormatException numberFormatException) {
                            log.error("Tab 2 length ({}) isn't a valid number", (Object)a.getValue());
                        }
                    }
                    if ((a = operations.getChild("tab").getAttribute("tab3Length")) != null) {
                        length = a.getValue();
                        log.debug("tab 3 length: {}", (Object)length);
                        try {
                            Setup.setTab3length(Integer.parseInt(length));
                        }
                        catch (NumberFormatException numberFormatException) {
                            log.error("Tab 3 length ({}) isn't a valid number", (Object)a.getValue());
                        }
                    }
                }
                if (operations.getChild("manifest") != null) {
                    a = operations.getChild("manifest").getAttribute("printLocComments");
                    if (a != null) {
                        enable2 = a.getValue();
                        log.debug("manifest printLocComments: {}", (Object)enable2);
                        Setup.setPrintLocationCommentsEnabled(enable2.equals("true"));
                    }
                    if ((a = operations.getChild("manifest").getAttribute("printRouteComments")) != null) {
                        enable2 = a.getValue();
                        log.debug("manifest printRouteComments: {}", (Object)enable2);
                        Setup.setPrintRouteCommentsEnabled(enable2.equals("true"));
                    }
                    if ((a = operations.getChild("manifest").getAttribute("printLoadsEmpties")) != null) {
                        enable2 = a.getValue();
                        log.debug("manifest printLoadsEmpties: {}", (Object)enable2);
                        Setup.setPrintLoadsAndEmptiesEnabled(enable2.equals("true"));
                    }
                    if ((a = operations.getChild("manifest").getAttribute("printTimetable")) != null) {
                        enable2 = a.getValue();
                        log.debug("manifest printTrainSchedule: {}", (Object)enable2);
                        Setup.setPrintTrainScheduleNameEnabled(enable2.equals("true"));
                    }
                    if ((a = operations.getChild("manifest").getAttribute("use12hrFormat")) != null) {
                        enable2 = a.getValue();
                        log.debug("manifest use12hrFormat: {}", (Object)enable2);
                        Setup.set12hrFormatEnabled(enable2.equals("true"));
                    }
                    if ((a = operations.getChild("manifest").getAttribute("printValid")) != null) {
                        enable2 = a.getValue();
                        log.debug("manifest printValid: {}", (Object)enable2);
                        Setup.setPrintValidEnabled(enable2.equals("true"));
                    }
                    if ((a = operations.getChild("manifest").getAttribute("sortByTrack")) != null) {
                        enable2 = a.getValue();
                        log.debug("manifest sortByTrack: {}", (Object)enable2);
                        Setup.setSortByTrackNameEnabled(enable2.equals("true"));
                    }
                    if ((a = operations.getChild("manifest").getAttribute("printPageHeader")) != null) {
                        enable2 = a.getValue();
                        log.debug("manifest printPageHeader: {}", (Object)enable2);
                        Setup.setPrintPageHeaderEnabled(enable2.equals("true"));
                    }
                    if ((a = operations.getChild("manifest").getAttribute("printHeaders")) != null) {
                        enable2 = a.getValue();
                        log.debug("manifest print headers: {}", (Object)enable2);
                        Setup.setPrintHeadersEnabled(enable2.equals("true"));
                    }
                    if ((a = operations.getChild("manifest").getAttribute("truncate")) != null) {
                        enable2 = a.getValue();
                        log.debug("manifest truncate: {}", (Object)enable2);
                        Setup.setPrintTruncateManifestEnabled(enable2.equals("true"));
                    }
                    if ((a = operations.getChild("manifest").getAttribute("useDepartureTime")) != null) {
                        enable2 = a.getValue();
                        log.debug("manifest use departure time: {}", (Object)enable2);
                        Setup.setUseDepartureTimeEnabled(enable2.equals("true"));
                    }
                    if ((a = operations.getChild("manifest").getAttribute("useEditor")) != null) {
                        enable2 = a.getValue();
                        log.debug("manifest useEditor: {}", (Object)enable2);
                        Setup.setManifestEditorEnabled(enable2.equals("true"));
                    }
                    if ((a = operations.getChild("manifest").getAttribute("printCabooseLoad")) != null) {
                        enable2 = a.getValue();
                        log.debug("manifest print caboose load: {}", (Object)enable2);
                        Setup.setPrintCabooseLoadEnabled(enable2.equals("true"));
                    }
                    if ((a = operations.getChild("manifest").getAttribute("printPassengerLoad")) != null) {
                        enable2 = a.getValue();
                        log.debug("manifest print passenger load: {}", (Object)enable2);
                        Setup.setPrintPassengerLoadEnabled(enable2.equals("true"));
                    }
                    if ((a = operations.getChild("manifest").getAttribute("hazardousMsg")) != null) {
                        String message = a.getValue();
                        log.debug("manifest hazardousMsg: {}", (Object)message);
                        Setup.setHazardousMsg(message);
                    }
                }
                if (operations.getChild("manifestFormat") == null) break block215;
                a = operations.getChild("manifestFormat").getAttribute("value");
                if (a == null) break block216;
                switch (a.getValue()) {
                    case "0": {
                        Setup.getDefault().manifestFormat = STANDARD_FORMAT;
                        break;
                    }
                    case "1": {
                        Setup.getDefault().manifestFormat = TWO_COLUMN_FORMAT;
                        break;
                    }
                    case "2": {
                        Setup.getDefault().manifestFormat = TWO_COLUMN_TRACK_FORMAT;
                        break;
                    }
                    default: {
                        log.debug("Unknown manifest format");
                        break;
                    }
                }
                break block216;
            }
            if (operations.getChild("columnFormat") != null && (a = operations.getChild("columnFormat").getAttribute("twoColumns")) != null) {
                enable = a.getValue();
                log.debug("two columns: {}", (Object)enable);
                if (enable.equals("true")) {
                    Setup.setManifestFormat(TWO_COLUMN_FORMAT);
                }
            }
        }
        if (operations.getChild("manifestLogo") != null && (a = operations.getChild("manifestLogo").getAttribute("name")) != null) {
            Setup.setManifestLogoURL(a.getValue());
        }
        if (operations.getChild("manifestFileOptions") != null && (a = operations.getChild("manifestFileOptions").getAttribute("manifestSave")) != null) {
            enable = a.getValue();
            log.debug("manifest file save option: {}", (Object)enable);
            Setup.getDefault().saveTrainManifests = enable.equals("true");
        }
        if (operations.getChild("buildOptions") != null) {
            a = operations.getChild("buildOptions").getAttribute("aggressive");
            if (a != null) {
                enable = a.getValue();
                log.debug("aggressive: {}", (Object)enable);
                Setup.setBuildAggressive(enable.equals("true"));
            }
            if ((a = operations.getChild("buildOptions").getAttribute("numberPasses")) != null) {
                String number = a.getValue();
                log.debug("number of passes: {}", (Object)number);
                try {
                    Setup.setNumberPasses(Integer.parseInt(number));
                }
                catch (NumberFormatException numberFormatException) {
                    log.debug("Number of passes isn't a number");
                }
            }
            if ((a = operations.getChild("buildOptions").getAttribute("allowLocalInterchange")) != null) {
                enable = a.getValue();
                log.debug("allowLocalInterchangeMoves: {}", (Object)enable);
                Setup.setLocalInterchangeMovesEnabled(enable.equals("true"));
            }
            if ((a = operations.getChild("buildOptions").getAttribute("allowLocalSpur")) != null) {
                enable = a.getValue();
                log.debug("allowLocalSpurMoves: {}", (Object)enable);
                Setup.setLocalSpurMovesEnabled(enable.equals("true"));
            } else {
                a = operations.getChild("buildOptions").getAttribute("allowLocalSiding");
                if (a != null) {
                    enable = a.getValue();
                    log.debug("allowLocalSidingMoves: {}", (Object)enable);
                    Setup.setLocalSpurMovesEnabled(enable.equals("true"));
                }
            }
            a = operations.getChild("buildOptions").getAttribute("allowLocalYard");
            if (a != null) {
                enable = a.getValue();
                log.debug("allowLocalYardMoves: {}", (Object)enable);
                Setup.setLocalYardMovesEnabled(enable.equals("true"));
            }
            if ((a = operations.getChild("buildOptions").getAttribute("stagingRestrictionEnabled")) != null) {
                enable = a.getValue();
                log.debug("stagingRestrictionEnabled: {}", (Object)enable);
                Setup.setStagingTrainCheckEnabled(enable.equals("true"));
            }
            if ((a = operations.getChild("buildOptions").getAttribute("stagingTrackAvail")) != null) {
                enable = a.getValue();
                log.debug("stagingTrackAvail: {}", (Object)enable);
                Setup.setStagingTrackImmediatelyAvail(enable.equals("true"));
            }
            if ((a = operations.getChild("buildOptions").getAttribute("allowReturnStaging")) != null) {
                enable = a.getValue();
                log.debug("allowReturnStaging: {}", (Object)enable);
                Setup.getDefault().allowCarsReturnStaging = enable.equals("true");
            }
            if ((a = operations.getChild("buildOptions").getAttribute("promptStagingEnabled")) != null) {
                enable = a.getValue();
                log.debug("promptStagingEnabled: {}", (Object)enable);
                Setup.setStagingPromptFromEnabled(enable.equals("true"));
            }
            if ((a = operations.getChild("buildOptions").getAttribute("promptToStagingEnabled")) != null) {
                enable = a.getValue();
                log.debug("promptToStagingEnabled: {}", (Object)enable);
                Setup.setStagingPromptToEnabled(enable.equals("true"));
            }
            if ((a = operations.getChild("buildOptions").getAttribute("stagingTryNormal")) != null) {
                enable = a.getValue();
                log.debug("stagingTryNormalEnabled: {}", (Object)enable);
                Setup.setStagingTryNormalBuildEnabled(enable.equals("true"));
            }
            if ((a = operations.getChild("buildOptions").getAttribute("generateCsvManifest")) != null) {
                enable = a.getValue();
                log.debug("generateCvsManifest: {}", (Object)enable);
                Setup.getDefault().generateCsvManifest = enable.equals("true");
            }
            if ((a = operations.getChild("buildOptions").getAttribute("generateCsvSwitchList")) != null) {
                enable = a.getValue();
                log.debug("generateCvsSwitchList: {}", (Object)enable);
                Setup.getDefault().generateCsvSwitchList = enable.equals("true");
            }
        }
        if (operations.getChild("buildReport") != null) {
            String level;
            a = operations.getChild("buildReport").getAttribute("level");
            if (a != null) {
                level = a.getValue();
                log.debug("buildReportLevel: {}", (Object)level);
                Setup.setBuildReportLevel(level);
            }
            if ((a = operations.getChild("buildReport").getAttribute("routerLevel")) != null) {
                level = a.getValue();
                log.debug("routerBuildReportLevel: {}", (Object)level);
                Setup.setRouterBuildReportLevel(level);
            }
            if ((a = operations.getChild("buildReport").getAttribute("useEditor")) != null) {
                enable = a.getValue();
                log.debug("build report useEditor: {}", (Object)enable);
                Setup.setBuildReportEditorEnabled(enable.equals("true"));
            }
            if ((a = operations.getChild("buildReport").getAttribute("indent")) != null) {
                enable = a.getValue();
                log.debug("build report indent: {}", (Object)enable);
                Setup.setBuildReportIndentEnabled(enable.equals("true"));
            }
            if ((a = operations.getChild("buildReport").getAttribute("fontSize")) != null) {
                String size = a.getValue();
                log.debug("build font size: {}", (Object)size);
                try {
                    Setup.setBuildReportFontSize(Integer.parseInt(size));
                }
                catch (NumberFormatException numberFormatException) {
                    log.error("Build report font size ({}) isn't a valid number", (Object)a.getValue());
                }
            }
            if ((a = operations.getChild("buildReport").getAttribute("alwaysPreview")) != null) {
                enable = a.getValue();
                log.debug("build report always preview: {}", (Object)enable);
                Setup.setBuildReportAlwaysPreviewEnabled(enable.equals("true"));
            }
        }
        if (operations.getChild("router") != null) {
            a = operations.getChild("router").getAttribute("carRoutingEnabled");
            if (a != null) {
                enable = a.getValue();
                log.debug("carRoutingEnabled: {}", (Object)enable);
                Setup.setCarRoutingEnabled(enable.equals("true"));
            }
            if ((a = operations.getChild("router").getAttribute("carRoutingViaYards")) != null) {
                enable = a.getValue();
                log.debug("carRoutingViaYards: {}", (Object)enable);
                Setup.setCarRoutingViaYardsEnabled(enable.equals("true"));
            }
            if ((a = operations.getChild("router").getAttribute("carRoutingViaStaging")) != null) {
                enable = a.getValue();
                log.debug("carRoutingViaStaging: {}", (Object)enable);
                Setup.setCarRoutingViaStagingEnabled(enable.equals("true"));
            }
            if ((a = operations.getChild("router").getAttribute("forwardToYard")) != null) {
                enable = a.getValue();
                log.debug("forwardToYard: {}", (Object)enable);
                Setup.setForwardToYardEnabled(enable.equals("true"));
            }
            if ((a = operations.getChild("router").getAttribute("onlyActiveTrains")) != null) {
                enable = a.getValue();
                log.debug("onlyActiveTrains: {}", (Object)enable);
                Setup.setOnlyActiveTrainsEnabled(enable.equals("true"));
            }
            if ((a = operations.getChild("router").getAttribute("checkCarDestination")) != null) {
                enable = a.getValue();
                log.debug("checkCarDestination: {}", (Object)enable);
                Setup.setCheckCarDestinationEnabled(enable.equals("true"));
            }
        } else if (operations.getChild("settings") != null) {
            a = operations.getChild("settings").getAttribute("carRoutingEnabled");
            if (a != null) {
                enable = a.getValue();
                log.debug("carRoutingEnabled: {}", (Object)enable);
                Setup.setCarRoutingEnabled(enable.equals("true"));
            }
            if ((a = operations.getChild("settings").getAttribute("carRoutingViaYards")) != null) {
                enable = a.getValue();
                log.debug("carRoutingViaYards: {}", (Object)enable);
                Setup.setCarRoutingViaYardsEnabled(enable.equals("true"));
            }
            if ((a = operations.getChild("settings").getAttribute("carRoutingViaStaging")) != null) {
                enable = a.getValue();
                log.debug("carRoutingViaStaging: {}", (Object)enable);
                Setup.setCarRoutingViaStagingEnabled(enable.equals("true"));
            }
            if ((a = operations.getChild("settings").getAttribute("forwardToYard")) != null) {
                enable = a.getValue();
                log.debug("forwardToYard: {}", (Object)enable);
                Setup.setForwardToYardEnabled(enable.equals("true"));
            }
        }
        if (operations.getChild("owner") != null && (a = operations.getChild("owner").getAttribute("name")) != null) {
            String owner = a.getValue();
            log.debug("owner: {}", (Object)owner);
            Setup.setOwnerName(owner);
        }
        if (operations.getChild("iconColor") != null) {
            String color;
            a = operations.getChild("iconColor").getAttribute("north");
            if (a != null) {
                color = a.getValue();
                log.debug("north color: {}", (Object)color);
                Setup.setTrainIconColorNorth(color);
            }
            if ((a = operations.getChild("iconColor").getAttribute("south")) != null) {
                color = a.getValue();
                log.debug("south color: {}", (Object)color);
                Setup.setTrainIconColorSouth(color);
            }
            if ((a = operations.getChild("iconColor").getAttribute("east")) != null) {
                color = a.getValue();
                log.debug("east color: {}", (Object)color);
                Setup.setTrainIconColorEast(color);
            }
            if ((a = operations.getChild("iconColor").getAttribute("west")) != null) {
                color = a.getValue();
                log.debug("west color: {}", (Object)color);
                Setup.setTrainIconColorWest(color);
            }
            if ((a = operations.getChild("iconColor").getAttribute("local")) != null) {
                color = a.getValue();
                log.debug("local color: {}", (Object)color);
                Setup.setTrainIconColorLocal(color);
            }
            if ((a = operations.getChild("iconColor").getAttribute("terminate")) != null) {
                color = a.getValue();
                log.debug("terminate color: {}", (Object)color);
                Setup.setTrainIconColorTerminate(color);
            }
        }
        if (operations.getChild("comments") != null && (a = operations.getChild("comments").getAttribute("misplacedCars")) != null) {
            String comment = a.getValue();
            log.debug("Misplaced comment: {}", (Object)comment);
            Setup.setMiaComment(comment);
        }
        if (operations.getChild("display") != null && (a = operations.getChild("display").getAttribute("showTrackMoves")) != null) {
            enable = a.getValue();
            log.debug("show track moves: {}", (Object)enable);
            Setup.getDefault().showTrackMoves = enable.equals("true");
        }
        if (operations.getChild("vsd") != null && (a = operations.getChild("vsd").getAttribute("enablePhysicalLocations")) != null) {
            enable = a.getValue();
            Setup.setVsdPhysicalLocationEnabled(enable.equals("true"));
        }
        if (operations.getChild("CATS") != null && (a = operations.getChild("CATS").getAttribute("exactLocationName")) != null) {
            enable = a.getValue();
            AbstractOperationsServer.setExactLocationName(enable.equals("true"));
        }
        if (operations.getChild("settings") != null) {
            String enabled;
            a = operations.getChild("settings").getAttribute("autoSave");
            if (a != null) {
                enabled = a.getValue();
                log.debug("autoSave: {}", (Object)enabled);
                Setup.setAutoSaveEnabled(enabled.equals("true"));
            }
            if ((a = operations.getChild("settings").getAttribute("autoBackup")) != null) {
                enabled = a.getValue();
                log.debug("autoBackup: {}", (Object)enabled);
                Setup.setAutoBackupEnabled(enabled.equals("true"));
            }
        }
        if (operations.getChild("logger") != null) {
            a = operations.getChild("logger").getAttribute("carLogger");
            if (a != null) {
                enable = a.getValue();
                log.debug("carLogger: {}", (Object)enable);
                Setup.getDefault().carLogger = enable.equals("true");
            }
            if ((a = operations.getChild("logger").getAttribute("engineLogger")) != null) {
                enable = a.getValue();
                log.debug("engineLogger: {}", (Object)enable);
                Setup.getDefault().engineLogger = enable.equals("true");
            }
            if ((a = operations.getChild("logger").getAttribute("trainLogger")) != null) {
                enable = a.getValue();
                log.debug("trainLogger: {}", (Object)enable);
                Setup.getDefault().trainLogger = enable.equals("true");
            }
        } else if (operations.getChild("settings") != null) {
            a = operations.getChild("settings").getAttribute("carLogger");
            if (a != null) {
                enable = a.getValue();
                log.debug("carLogger: {}", (Object)enable);
                Setup.getDefault().carLogger = enable.equals("true");
            }
            if ((a = operations.getChild("settings").getAttribute("engineLogger")) != null) {
                enable = a.getValue();
                log.debug("engineLogger: {}", (Object)enable);
                Setup.getDefault().engineLogger = enable.equals("true");
            }
            if ((a = operations.getChild("settings").getAttribute("trainLogger")) != null) {
                enable = a.getValue();
                log.debug("trainLogger: {}", (Object)enable);
                Setup.getDefault().trainLogger = enable.equals("true");
            }
        }
    }

    private static void replaceOldFormat(String[] format) {
        int i = 0;
        while (i < format.length) {
            if (format[i].equals("Pickup Msg")) {
                format[i] = PICKUP_COMMENT;
            } else if (format[i].equals("Drop Msg")) {
                format[i] = DROP_COMMENT;
            }
            ++i;
        }
    }

    private static void keyToStringConversion(String[] keys) {
        int i = 0;
        while (i < keys.length) {
            if (!keys[i].equals(BLANK)) {
                try {
                    keys[i] = Bundle.getMessage(keys[i]);
                }
                catch (Exception exception) {
                    log.debug("Key {}: ({}) not found", (Object)i, (Object)keys[i]);
                }
            }
            ++i;
        }
    }

    private static void stringToTagConversion(String[] strings) {
        int i = 0;
        while (i < strings.length) {
            String old = strings[i];
            if (!old.equals(BLANK)) {
                String[] stringArray = KEYS;
                int n = KEYS.length;
                int n2 = 0;
                while (n2 < n) {
                    String key = stringArray[n2];
                    if (strings[i].equals(Bundle.getMessage(key))) {
                        strings[i] = Bundle.getMessage(Locale.ROOT, key);
                        break;
                    }
                    ++n2;
                }
            }
            ++i;
        }
    }

    private static void xmlAttributeToKeyConversion(String[] format) {
        int i = 0;
        while (i < format.length) {
            String[] stringArray = KEYS;
            int n = KEYS.length;
            int n2 = 0;
            while (n2 < n) {
                String key = stringArray[n2];
                if (format[i].equals(Bundle.getMessage(Locale.ROOT, key))) {
                    format[i] = key;
                }
                ++n2;
            }
            ++i;
        }
    }

    protected static void setDirtyAndFirePropertyChange(String p, Object old, Object n) {
        InstanceManager.getDefault(OperationsSetupXml.class).setDirty(true);
        Setup.getDefault().firePropertyChange(p, old, n);
    }

    public static Setup getDefault() {
        return InstanceManager.getDefault(Setup.class);
    }

    @Override
    public void dispose() {
        AutoSave.stop();
    }
}

