/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.operations.setup;

import java.awt.event.ActionEvent;
import java.io.IOException;
import javax.swing.AbstractAction;
import javax.swing.JOptionPane;
import jmri.InstanceManager;
import jmri.ShutDownManager;
import jmri.jmrit.operations.OperationsManager;
import jmri.jmrit.operations.OperationsXml;
import jmri.jmrit.operations.setup.AutoBackup;
import jmri.jmrit.operations.setup.Bundle;
import jmri.util.swing.ExceptionDisplayFrame;
import jmri.util.swing.UnexpectedExceptionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResetAction
extends AbstractAction {
    private static final Logger log = LoggerFactory.getLogger(ResetAction.class);

    public ResetAction() {
        super(Bundle.getMessage("ResetOperations"));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int results;
        if (OperationsXml.areFilesDirty() && JOptionPane.showConfirmDialog(null, Bundle.getMessage("OperationsFilesModified"), Bundle.getMessage("SaveOperationFiles"), 0) == 0) {
            OperationsXml.save();
        }
        if ((results = JOptionPane.showConfirmDialog(null, Bundle.getMessage("AreYouSureDeleteAll"), Bundle.getMessage("ResetOperations"), 2)) != 0) {
            return;
        }
        AutoBackup backup = new AutoBackup();
        try {
            backup.autoBackup();
            backup.deleteOperationsFiles();
            InstanceManager.getDefault(OperationsManager.class).setShutDownTask(null);
            JOptionPane.showMessageDialog(null, Bundle.getMessage("YouMustRestartAfterReset"), Bundle.getMessage("ResetSuccessful"), 1);
            try {
                InstanceManager.getDefault(ShutDownManager.class).restart();
            }
            catch (Exception er) {
                log.error("Continuing after error in handleRestart", (Throwable)er);
            }
        }
        catch (IOException ex) {
            UnexpectedExceptionContext context = new UnexpectedExceptionContext(ex, "Deleting Operations files");
            new ExceptionDisplayFrame(context, null).setVisible(true);
        }
    }
}

