/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.operations.setup;

import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTextField;
import jmri.InstanceManager;
import jmri.jmrit.operations.setup.Bundle;
import jmri.jmrit.operations.setup.OperationsPreferencesPanel;
import jmri.jmrit.operations.setup.OperationsSetupXml;
import jmri.jmrit.operations.setup.Setup;
import jmri.jmrit.operations.trains.TrainManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrintMoreOptionPanel
extends OperationsPreferencesPanel {
    private static final Logger log = LoggerFactory.getLogger(PrintMoreOptionPanel.class);
    JButton saveButton = new JButton(Bundle.getMessage("ButtonSave"));
    JTextField tab1TextField = new JTextField(2);
    JTextField tab2TextField = new JTextField(2);
    JTextField tab3TextField = new JTextField(2);

    public PrintMoreOptionPanel() {
        this.setLayout(new BoxLayout(this, 1));
        JPanel p1 = new JPanel();
        p1.setLayout(new BoxLayout(p1, 1));
        JPanel pTab = new JPanel();
        pTab.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("BorderLayoutTab1")));
        pTab.add(this.tab1TextField);
        p1.add(pTab);
        JPanel pTab2 = new JPanel();
        pTab2.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("BorderLayoutTab2")));
        pTab2.add(this.tab2TextField);
        p1.add(pTab2);
        JPanel pTab3 = new JPanel();
        pTab3.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("BorderLayoutTab3")));
        pTab3.add(this.tab3TextField);
        p1.add(pTab3);
        this.tab1TextField.setText(Integer.toString(Setup.getTab1Length()));
        this.tab2TextField.setText(Integer.toString(Setup.getTab2Length()));
        this.tab3TextField.setText(Integer.toString(Setup.getTab3Length()));
        this.saveButton.setToolTipText(Bundle.getMessage("SaveToolTip"));
        JPanel pControl = new JPanel();
        pControl.setBorder(BorderFactory.createTitledBorder(""));
        pControl.setLayout(new GridBagLayout());
        this.addItem(pControl, this.saveButton, 0, 0);
        this.add(p1);
        this.add(pControl);
        this.addButtonAction(this.saveButton);
    }

    @Override
    public void buttonActionPerformed(ActionEvent ae) {
        if (ae.getSource() == this.saveButton) {
            this.savePreferences();
            if (Setup.isCloseWindowOnSaveEnabled()) {
                this.dispose();
            }
        }
    }

    @Override
    public String getTabbedPreferencesTitle() {
        return Bundle.getMessage("TitlePrintMoreOptions");
    }

    @Override
    public String getPreferencesTooltip() {
        return null;
    }

    @Override
    public void savePreferences() {
        try {
            Setup.setTab1length(Integer.parseInt(this.tab1TextField.getText()));
            Setup.setTab2length(Integer.parseInt(this.tab2TextField.getText()));
            Setup.setTab3length(Integer.parseInt(this.tab3TextField.getText()));
        }
        catch (NumberFormatException numberFormatException) {
            log.error("Tab wasn't a number");
        }
        InstanceManager.getDefault(OperationsSetupXml.class).writeOperationsFile();
        InstanceManager.getDefault(TrainManager.class).setTrainsModified();
    }

    @Override
    public boolean isDirty() {
        try {
            return Setup.getTab1Length() != Integer.parseInt(this.tab1TextField.getText()) || Setup.getTab2Length() != Integer.parseInt(this.tab2TextField.getText()) || Setup.getTab3Length() != Integer.parseInt(this.tab3TextField.getText());
        }
        catch (NumberFormatException numberFormatException) {
            log.error("Tab wasn't a number");
            return true;
        }
    }
}

