/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.operations.setup;

import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import jmri.InstanceManager;
import jmri.jmrit.operations.locations.LocationManager;
import jmri.jmrit.operations.setup.Bundle;
import jmri.jmrit.operations.setup.OperationsPreferencesPanel;
import jmri.jmrit.operations.setup.OperationsSetupXml;
import jmri.jmrit.operations.setup.Setup;
import jmri.jmrit.operations.trains.TrainManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OptionPanel
extends OperationsPreferencesPanel {
    JButton saveButton = new JButton(Bundle.getMessage("ButtonSave"));
    JRadioButton buildNormal = new JRadioButton(Bundle.getMessage("Normal"));
    JRadioButton buildAggressive = new JRadioButton(Bundle.getMessage("Aggressive"));
    JCheckBox routerCheckBox = new JCheckBox(Bundle.getMessage("EnableCarRouting"));
    JCheckBox routerYardCheckBox = new JCheckBox(Bundle.getMessage("EnableCarRoutingYard"));
    JCheckBox routerStagingCheckBox = new JCheckBox(Bundle.getMessage("EnableCarRoutingStaging"));
    JCheckBox routerAllTrainsBox = new JCheckBox(Bundle.getMessage("AllTrains"));
    JCheckBox routerRestrictBox = new JCheckBox(Bundle.getMessage("EnableTrackDestinationRestrictions"));
    JCheckBox valueCheckBox = new JCheckBox(Bundle.getMessage("EnableValue"));
    JCheckBox rfidCheckBox = new JCheckBox(Bundle.getMessage("EnableRfid"));
    JCheckBox carLoggerCheckBox = new JCheckBox(Bundle.getMessage("EnableCarLogging"));
    JCheckBox engineLoggerCheckBox = new JCheckBox(Bundle.getMessage("EnableEngineLogging"));
    JCheckBox trainLoggerCheckBox = new JCheckBox(Bundle.getMessage("EnableTrainLogging"));
    JCheckBox localInterchangeCheckBox = new JCheckBox(Bundle.getMessage("AllowLocalInterchange"));
    JCheckBox localSpurCheckBox = new JCheckBox(Bundle.getMessage("AllowLocalSpur"));
    JCheckBox localYardCheckBox = new JCheckBox(Bundle.getMessage("AllowLocalYard"));
    JCheckBox trainIntoStagingCheckBox = new JCheckBox(Bundle.getMessage("TrainIntoStaging"));
    JCheckBox stagingAvailCheckBox = new JCheckBox(Bundle.getMessage("StagingAvailable"));
    JCheckBox stagingTurnCheckBox = new JCheckBox(Bundle.getMessage("AllowCarsToReturn"));
    JCheckBox promptFromTrackStagingCheckBox = new JCheckBox(Bundle.getMessage("PromptFromStaging"));
    JCheckBox promptToTrackStagingCheckBox = new JCheckBox(Bundle.getMessage("PromptToStaging"));
    JCheckBox tryNormalStagingCheckBox = new JCheckBox(Bundle.getMessage("TryNormalStaging"));
    JCheckBox generateCvsManifestCheckBox = new JCheckBox(Bundle.getMessage("GenerateCsvManifest"));
    JCheckBox generateCvsSwitchListCheckBox = new JCheckBox(Bundle.getMessage("GenerateCsvSwitchList"));
    JCheckBox enableVsdCheckBox = new JCheckBox(Bundle.getMessage("EnableVSD"));
    JCheckBox saveTrainManifestCheckBox = new JCheckBox(Bundle.getMessage("SaveManifests"));
    JTextField rfidTextField = new JTextField(10);
    JTextField valueTextField = new JTextField(10);
    JComboBox<Integer> numberPassesComboBox = new JComboBox();
    private static final Logger log = LoggerFactory.getLogger(OptionPanel.class);

    public OptionPanel() {
        this.localInterchangeCheckBox.setSelected(Setup.isLocalInterchangeMovesEnabled());
        this.localSpurCheckBox.setSelected(Setup.isLocalSpurMovesEnabled());
        this.localYardCheckBox.setSelected(Setup.isLocalYardMovesEnabled());
        this.trainIntoStagingCheckBox.setSelected(Setup.isStagingTrainCheckEnabled());
        this.stagingAvailCheckBox.setSelected(Setup.isStagingTrackImmediatelyAvail());
        this.stagingTurnCheckBox.setSelected(Setup.isStagingAllowReturnEnabled());
        this.promptToTrackStagingCheckBox.setSelected(Setup.isStagingPromptToEnabled());
        this.promptFromTrackStagingCheckBox.setSelected(Setup.isStagingPromptFromEnabled());
        this.tryNormalStagingCheckBox.setSelected(Setup.isStagingTryNormalBuildEnabled());
        this.routerCheckBox.setSelected(Setup.isCarRoutingEnabled());
        this.routerYardCheckBox.setSelected(Setup.isCarRoutingViaYardsEnabled());
        this.routerStagingCheckBox.setSelected(Setup.isCarRoutingViaStagingEnabled());
        this.routerAllTrainsBox.setSelected(!Setup.isOnlyActiveTrainsEnabled());
        this.routerRestrictBox.setSelected(Setup.isCheckCarDestinationEnabled());
        this.carLoggerCheckBox.setSelected(Setup.isCarLoggerEnabled());
        this.engineLoggerCheckBox.setSelected(Setup.isEngineLoggerEnabled());
        this.trainLoggerCheckBox.setSelected(Setup.isTrainLoggerEnabled());
        this.saveTrainManifestCheckBox.setSelected(Setup.isSaveTrainManifestsEnabled());
        this.generateCvsManifestCheckBox.setSelected(Setup.isGenerateCsvManifestEnabled());
        this.generateCvsSwitchListCheckBox.setSelected(Setup.isGenerateCsvSwitchListEnabled());
        this.valueCheckBox.setSelected(Setup.isValueEnabled());
        this.rfidCheckBox.setSelected(Setup.isRfidEnabled());
        this.enableVsdCheckBox.setSelected(Setup.isVsdPhysicalLocationEnabled());
        this.rfidTextField.setText(Setup.getRfidLabel());
        this.valueTextField.setText(Setup.getValueLabel());
        this.saveButton.setToolTipText(Bundle.getMessage("SaveToolTip"));
        this.rfidTextField.setToolTipText(Bundle.getMessage("EnterNameRfidTip"));
        this.valueTextField.setToolTipText(Bundle.getMessage("EnterNameValueTip"));
        this.stagingTurnCheckBox.setToolTipText(Bundle.getMessage("AlsoAvailablePerTrain"));
        int x = 2;
        while (x < 5) {
            this.numberPassesComboBox.addItem(x);
            ++x;
        }
        this.numberPassesComboBox.setSelectedItem(Setup.getNumberPasses());
        this.setLayout(new BoxLayout(this, 1));
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        JScrollPane panelPane = new JScrollPane(panel);
        JPanel pBuild = new JPanel();
        pBuild.setLayout(new BoxLayout(pBuild, 1));
        pBuild.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("BorderLayoutBuildOptions")));
        JPanel pOpt = new JPanel();
        pOpt.setLayout(new GridBagLayout());
        this.addItem(pOpt, this.buildNormal, 1, 0);
        this.addItem(pOpt, this.buildAggressive, 2, 0);
        this.addItem(pBuild, pOpt, 1, 0);
        JPanel pPasses = new JPanel();
        pPasses.setLayout(new GridBagLayout());
        pPasses.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("BorderLayoutNumberPasses")));
        this.addItem(pPasses, this.numberPassesComboBox, 0, 0);
        this.addItem(pBuild, pPasses, 1, 1);
        JPanel pSwitcher = new JPanel();
        pSwitcher.setLayout(new GridBagLayout());
        pSwitcher.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("BorderLayoutSwitcherService")));
        this.addItemLeft(pSwitcher, this.localInterchangeCheckBox, 1, 1);
        this.addItemLeft(pSwitcher, this.localSpurCheckBox, 1, 2);
        this.addItemLeft(pSwitcher, this.localYardCheckBox, 1, 3);
        this.addItemLeft(pBuild, pSwitcher, 1, 2);
        JPanel pStaging = new JPanel();
        pStaging.setLayout(new GridBagLayout());
        pStaging.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("BorderLayoutStaging")));
        this.addItemLeft(pStaging, this.trainIntoStagingCheckBox, 1, 4);
        this.addItemLeft(pStaging, this.stagingAvailCheckBox, 1, 5);
        this.addItemLeft(pStaging, this.stagingTurnCheckBox, 1, 6);
        this.addItemLeft(pStaging, this.promptFromTrackStagingCheckBox, 1, 7);
        this.addItemLeft(pStaging, this.promptToTrackStagingCheckBox, 1, 8);
        this.addItemLeft(pStaging, this.tryNormalStagingCheckBox, 1, 9);
        this.addItemLeft(pBuild, pStaging, 1, 3);
        JPanel pRouter = new JPanel();
        pRouter.setLayout(new GridBagLayout());
        pRouter.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("BorderLayoutRouterOptions")));
        this.addItemLeft(pRouter, this.routerCheckBox, 1, 0);
        this.addItemLeft(pRouter, this.routerYardCheckBox, 1, 1);
        this.addItemLeft(pRouter, this.routerStagingCheckBox, 1, 2);
        this.addItemLeft(pRouter, this.routerAllTrainsBox, 1, 3);
        this.addItemLeft(pRouter, this.routerRestrictBox, 1, 4);
        JPanel pLogger = new JPanel();
        pLogger.setLayout(new GridBagLayout());
        pLogger.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("BorderLayoutLoggerOptions")));
        this.addItemLeft(pLogger, this.engineLoggerCheckBox, 1, 0);
        this.addItemLeft(pLogger, this.carLoggerCheckBox, 1, 1);
        this.addItemLeft(pLogger, this.trainLoggerCheckBox, 1, 2);
        JPanel pCustom = new JPanel();
        pCustom.setLayout(new GridBagLayout());
        pCustom.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("BorderLayoutCustomManifests")));
        this.addItemLeft(pCustom, this.generateCvsManifestCheckBox, 1, 0);
        this.addItemLeft(pCustom, this.generateCvsSwitchListCheckBox, 1, 1);
        JPanel pOption = new JPanel();
        pOption.setLayout(new GridBagLayout());
        pOption.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("BorderLayoutOptions")));
        this.addItemLeft(pOption, this.saveTrainManifestCheckBox, 1, 1);
        this.addItemLeft(pOption, this.valueCheckBox, 1, 2);
        this.addItemLeft(pOption, this.valueTextField, 2, 2);
        this.addItemLeft(pOption, this.rfidCheckBox, 1, 3);
        this.addItemLeft(pOption, this.rfidTextField, 2, 3);
        this.addItemLeft(pOption, this.enableVsdCheckBox, 1, 4);
        JPanel pControl = new JPanel();
        pControl.setLayout(new GridBagLayout());
        this.addItem(pControl, this.saveButton, 3, 9);
        panel.add(pBuild);
        panel.add(pRouter);
        panel.add(pLogger);
        panel.add(pCustom);
        panel.add(pOption);
        this.add(panelPane);
        this.add(pControl);
        this.addButtonAction(this.saveButton);
        ButtonGroup buildGroup = new ButtonGroup();
        buildGroup.add(this.buildNormal);
        buildGroup.add(this.buildAggressive);
        this.addRadioButtonAction(this.buildNormal);
        this.addRadioButtonAction(this.buildAggressive);
        this.addCheckBoxAction(this.routerCheckBox);
        this.addCheckBoxAction(this.routerRestrictBox);
        this.setRouterCheckBoxesEnabled();
        this.setBuildOption();
        this.enableComponents();
    }

    private void setBuildOption() {
        this.buildNormal.setSelected(!Setup.isBuildAggressive());
        this.buildAggressive.setSelected(Setup.isBuildAggressive());
    }

    private void enableComponents() {
        this.stagingAvailCheckBox.setEnabled(this.buildAggressive.isSelected());
        this.numberPassesComboBox.setEnabled(this.buildAggressive.isSelected());
        this.tryNormalStagingCheckBox.setEnabled(this.buildAggressive.isSelected());
    }

    @Override
    public void radioButtonActionPerformed(ActionEvent ae) {
        log.debug("radio button selected");
        if (InstanceManager.getDefault(TrainManager.class).isAnyTrainBuilt()) {
            this.setBuildOption();
            JOptionPane.showMessageDialog(this, Bundle.getMessage("CanNotChangeBuild"), Bundle.getMessage("MustTerminateOrReset"), 0);
        }
        this.enableComponents();
        if (this.buildAggressive.isSelected() != Setup.isBuildAggressive() && InstanceManager.getDefault(LocationManager.class).hasWork()) {
            InstanceManager.getDefault(TrainManager.class).resetBuildFailedTrains();
        }
    }

    @Override
    public void buttonActionPerformed(ActionEvent ae) {
        if (ae.getSource() == this.saveButton) {
            this.savePreferences();
            if (Setup.isCloseWindowOnSaveEnabled()) {
                this.dispose();
            }
        }
    }

    @Override
    protected void checkBoxActionPerformed(ActionEvent ae) {
        if (ae.getSource() == this.routerCheckBox) {
            this.setRouterCheckBoxesEnabled();
        }
        if (ae.getSource() == this.routerRestrictBox && this.routerRestrictBox.isSelected()) {
            JOptionPane.showMessageDialog(this, Bundle.getMessage("WarnExtremeTrackDest"), Bundle.getMessage("WarnExtremeTitle"), 2);
        }
    }

    private void setRouterCheckBoxesEnabled() {
        this.routerYardCheckBox.setEnabled(this.routerCheckBox.isSelected());
        this.routerStagingCheckBox.setEnabled(this.routerCheckBox.isSelected());
        this.routerAllTrainsBox.setEnabled(this.routerCheckBox.isSelected());
        this.routerRestrictBox.setEnabled(this.routerCheckBox.isSelected());
    }

    @Override
    public String getTabbedPreferencesTitle() {
        return Bundle.getMessage("TitleOptions");
    }

    @Override
    public String getPreferencesTooltip() {
        return null;
    }

    @Override
    public void savePreferences() {
        Setup.setBuildAggressive(this.buildAggressive.isSelected());
        Setup.setNumberPasses((Integer)this.numberPassesComboBox.getSelectedItem());
        Setup.setLocalInterchangeMovesEnabled(this.localInterchangeCheckBox.isSelected());
        Setup.setLocalSpurMovesEnabled(this.localSpurCheckBox.isSelected());
        Setup.setLocalYardMovesEnabled(this.localYardCheckBox.isSelected());
        Setup.setStagingTrainCheckEnabled(this.trainIntoStagingCheckBox.isSelected());
        Setup.setStagingTrackImmediatelyAvail(this.stagingAvailCheckBox.isSelected());
        Setup.setStagingAllowReturnEnabled(this.stagingTurnCheckBox.isSelected());
        Setup.setStagingPromptFromEnabled(this.promptFromTrackStagingCheckBox.isSelected());
        Setup.setStagingPromptToEnabled(this.promptToTrackStagingCheckBox.isSelected());
        Setup.setStagingTryNormalBuildEnabled(this.tryNormalStagingCheckBox.isSelected());
        Setup.setCarRoutingEnabled(this.routerCheckBox.isSelected());
        Setup.setCarRoutingViaYardsEnabled(this.routerYardCheckBox.isSelected());
        Setup.setCarRoutingViaStagingEnabled(this.routerStagingCheckBox.isSelected());
        Setup.setOnlyActiveTrainsEnabled(!this.routerAllTrainsBox.isSelected());
        Setup.setCheckCarDestinationEnabled(this.routerRestrictBox.isSelected());
        Setup.setGenerateCsvManifestEnabled(this.generateCvsManifestCheckBox.isSelected());
        Setup.setGenerateCsvSwitchListEnabled(this.generateCvsSwitchListCheckBox.isSelected());
        Setup.setSaveTrainManifestsEnabled(this.saveTrainManifestCheckBox.isSelected());
        Setup.setValueEnabled(this.valueCheckBox.isSelected());
        Setup.setValueLabel(this.valueTextField.getText());
        Setup.setRfidEnabled(this.rfidCheckBox.isSelected());
        Setup.setRfidLabel(this.rfidTextField.getText());
        Setup.setEngineLoggerEnabled(this.engineLoggerCheckBox.isSelected());
        Setup.setCarLoggerEnabled(this.carLoggerCheckBox.isSelected());
        Setup.setTrainLoggerEnabled(this.trainLoggerCheckBox.isSelected());
        Setup.setVsdPhysicalLocationEnabled(this.enableVsdCheckBox.isSelected());
        InstanceManager.getDefault(OperationsSetupXml.class).writeOperationsFile();
    }

    @Override
    public boolean isDirty() {
        return Setup.isBuildAggressive() != this.buildAggressive.isSelected() || Setup.getNumberPasses() != (Integer)this.numberPassesComboBox.getSelectedItem() || Setup.isLocalInterchangeMovesEnabled() != this.localInterchangeCheckBox.isSelected() || Setup.isLocalSpurMovesEnabled() != this.localSpurCheckBox.isSelected() || Setup.isLocalYardMovesEnabled() != this.localYardCheckBox.isSelected() || Setup.isStagingTrainCheckEnabled() != this.trainIntoStagingCheckBox.isSelected() || Setup.isStagingTrackImmediatelyAvail() != this.stagingAvailCheckBox.isSelected() || Setup.isStagingAllowReturnEnabled() != this.stagingTurnCheckBox.isSelected() || Setup.isStagingPromptFromEnabled() != this.promptFromTrackStagingCheckBox.isSelected() || Setup.isStagingPromptToEnabled() != this.promptToTrackStagingCheckBox.isSelected() || Setup.isStagingTryNormalBuildEnabled() != this.tryNormalStagingCheckBox.isSelected() || Setup.isCarRoutingEnabled() != this.routerCheckBox.isSelected() || Setup.isCarRoutingViaYardsEnabled() != this.routerYardCheckBox.isSelected() || Setup.isCarRoutingViaStagingEnabled() != this.routerStagingCheckBox.isSelected() || Setup.isOnlyActiveTrainsEnabled() != !this.routerAllTrainsBox.isSelected() || Setup.isCheckCarDestinationEnabled() != this.routerRestrictBox.isSelected() || Setup.isGenerateCsvManifestEnabled() != this.generateCvsManifestCheckBox.isSelected() || Setup.isGenerateCsvSwitchListEnabled() != this.generateCvsSwitchListCheckBox.isSelected() || Setup.isValueEnabled() != this.valueCheckBox.isSelected() || !Setup.getValueLabel().equals(this.valueTextField.getText()) || Setup.isRfidEnabled() != this.rfidCheckBox.isSelected() || !Setup.getRfidLabel().equals(this.rfidTextField.getText()) || Setup.isSaveTrainManifestsEnabled() != this.saveTrainManifestCheckBox.isSelected() || Setup.isEngineLoggerEnabled() != this.engineLoggerCheckBox.isSelected() || Setup.isCarLoggerEnabled() != this.carLoggerCheckBox.isSelected() || Setup.isTrainLoggerEnabled() != this.trainLoggerCheckBox.isSelected() || Setup.isVsdPhysicalLocationEnabled() != this.enableVsdCheckBox.isSelected();
    }
}

