/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.operations.setup;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import jmri.jmrit.operations.setup.AutoBackup;
import jmri.jmrit.operations.setup.BackupSet;
import jmri.jmrit.operations.setup.Bundle;

public class ManageBackupsDialog
extends JDialog {
    private final JPanel contentPanel = new JPanel();
    private JLabel selectBackupSetsLabel;
    private JButton selectAllButton;
    private JButton clearAllButton;
    private JScrollPane scrollPane;
    private JList<BackupSet> setList;
    private JButton deleteButton;
    private DefaultListModel<BackupSet> model;
    private AutoBackup backup = new AutoBackup();
    private Component horizontalGlue;
    private Component horizontalStrut;
    private Component horizontalStrut_1;
    private Component horizontalStrut_2;

    public ManageBackupsDialog() {
        this.initComponents();
    }

    private void initComponents() {
        this.setModalityType(Dialog.ModalityType.DOCUMENT_MODAL);
        this.setModal(true);
        this.setTitle(Bundle.getMessage("ManageBackupsDialog.manageBackupSets"));
        this.setBounds(100, 100, 461, 431);
        BorderLayout borderLayout = new BorderLayout();
        borderLayout.setVgap(5);
        borderLayout.setHgap(5);
        this.getContentPane().setLayout(borderLayout);
        this.contentPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.getContentPane().add((Component)this.contentPanel, "Center");
        GridBagLayout gbl_contentPanel = new GridBagLayout();
        gbl_contentPanel.columnWidths = new int[2];
        gbl_contentPanel.rowHeights = new int[3];
        gbl_contentPanel.columnWeights = new double[]{1.0, Double.MIN_VALUE};
        gbl_contentPanel.rowWeights = new double[]{0.0, 1.0, Double.MIN_VALUE};
        this.contentPanel.setLayout(gbl_contentPanel);
        this.selectBackupSetsLabel = new JLabel(Bundle.getMessage("ManageBackupsDialog.instructionsLabel.text"));
        GridBagConstraints gbc_selectBackupSetsLabel = new GridBagConstraints();
        gbc_selectBackupSetsLabel.anchor = 17;
        gbc_selectBackupSetsLabel.insets = new Insets(0, 0, 5, 0);
        gbc_selectBackupSetsLabel.gridx = 0;
        gbc_selectBackupSetsLabel.gridy = 0;
        this.contentPanel.add((Component)this.selectBackupSetsLabel, gbc_selectBackupSetsLabel);
        this.scrollPane = new JScrollPane();
        GridBagConstraints gbc_scrollPane = new GridBagConstraints();
        gbc_scrollPane.fill = 1;
        gbc_scrollPane.gridx = 0;
        gbc_scrollPane.gridy = 1;
        this.contentPanel.add((Component)this.scrollPane, gbc_scrollPane);
        this.setList = new JList();
        this.setList.setVisibleRowCount(20);
        this.model = new DefaultListModel();
        BackupSet[] backupSetArray = this.backup.getBackupSets();
        int n = backupSetArray.length;
        int n2 = 0;
        while (n2 < n) {
            BackupSet bs = backupSetArray[n2];
            this.model.addElement(bs);
            ++n2;
        }
        this.setList.setModel(this.model);
        this.setList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                ManageBackupsDialog.this.updateButtonStates();
            }
        });
        this.scrollPane.setViewportView(this.setList);
        JPanel buttonPane = new JPanel();
        buttonPane.setBorder(new EmptyBorder(5, 5, 5, 5));
        buttonPane.setLayout(new BoxLayout(buttonPane, 0));
        this.getContentPane().add((Component)buttonPane, "South");
        this.selectAllButton = new JButton(Bundle.getMessage("ManageBackupsDialog.selectAllButton.text"));
        this.selectAllButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ManageBackupsDialog.this.do_selectAllButton_actionPerformed(e);
            }
        });
        buttonPane.add(this.selectAllButton);
        this.horizontalStrut = Box.createHorizontalStrut(10);
        buttonPane.add(this.horizontalStrut);
        this.clearAllButton = new JButton(Bundle.getMessage("ManageBackupsDialog.clearAllButton.text"));
        this.clearAllButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ManageBackupsDialog.this.do_clearAllButton_actionPerformed(e);
            }
        });
        buttonPane.add(this.clearAllButton);
        this.horizontalGlue = Box.createHorizontalGlue();
        buttonPane.add(this.horizontalGlue);
        this.deleteButton = new JButton(Bundle.getMessage("ButtonDelete"));
        this.deleteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ManageBackupsDialog.this.do_deleteButton_actionPerformed(e);
            }
        });
        this.deleteButton.setActionCommand("");
        buttonPane.add(this.deleteButton);
        this.horizontalStrut_1 = Box.createHorizontalStrut(10);
        buttonPane.add(this.horizontalStrut_1);
        JButton closeButton = new JButton(Bundle.getMessage("ButtonCancel"));
        closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ManageBackupsDialog.this.do_cancelButton_actionPerformed(e);
            }
        });
        closeButton.setActionCommand("Cancel");
        this.getRootPane().setDefaultButton(closeButton);
        buttonPane.add(closeButton);
        this.horizontalStrut_2 = Box.createHorizontalStrut(10);
        buttonPane.add(this.horizontalStrut_2);
        this.updateButtonStates();
    }

    protected void do_cancelButton_actionPerformed(ActionEvent e) {
        this.dispose();
    }

    protected void do_clearAllButton_actionPerformed(ActionEvent e) {
        this.setList.clearSelection();
    }

    protected void do_deleteButton_actionPerformed(ActionEvent e) {
        int result;
        List<BackupSet> selectedSets = this.setList.getSelectedValuesList();
        if (selectedSets.size() > 0 && (result = JOptionPane.showConfirmDialog(this, String.format(Bundle.getMessage("ManageBackupsDialog.aboutToDelete"), selectedSets.size()), Bundle.getMessage("ManageBackupsDialog.deletingBackupSets"), 2)) == 0) {
            for (BackupSet set : selectedSets) {
                this.model.removeElement(set);
                set.delete();
            }
        }
    }

    protected void do_helpButton_actionPerformed(ActionEvent e) {
    }

    protected void do_selectAllButton_actionPerformed(ActionEvent e) {
        this.setList.setSelectionInterval(0, this.model.getSize() - 1);
    }

    private void updateButtonStates() {
        boolean notEmpty = !this.setList.isSelectionEmpty();
        this.deleteButton.setEnabled(notEmpty);
        this.clearAllButton.setEnabled(notEmpty);
        int count = this.model.size();
        this.selectAllButton.setEnabled(count > 0);
    }
}

