/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.operations.setup;

import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import javax.swing.AbstractAction;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import jmri.jmrit.operations.OperationsXml;
import jmri.jmrit.operations.setup.Bundle;
import jmri.jmrit.operations.setup.DefaultBackup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BackupFilesAction
extends AbstractAction {
    private static final Logger log = LoggerFactory.getLogger(BackupFilesAction.class);

    public BackupFilesAction() {
        super(Bundle.getMessage("Backup"));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.backUp();
    }

    private void backUp() {
        if (OperationsXml.areFilesDirty() && JOptionPane.showConfirmDialog(null, Bundle.getMessage("OperationsFilesModified"), Bundle.getMessage("SaveOperationFiles"), 0) == 0) {
            OperationsXml.save();
        }
        DefaultBackup backup = new DefaultBackup();
        JFileChooser fc = new JFileChooser(backup.getBackupRoot());
        fc.addChoosableFileFilter(new FileFilter());
        File fs = new File(backup.suggestBackupSetName());
        fc.setSelectedFile(fs);
        int retVal = fc.showSaveDialog(null);
        if (retVal != 0 || fc.getSelectedFile() == null) {
            return;
        }
        File directory = fc.getSelectedFile();
        try {
            backup.backupFilesToDirectory(directory);
        }
        catch (IOException iOException) {
            log.error("backup failed");
        }
    }

    private static class FileFilter
    extends javax.swing.filechooser.FileFilter {
        private FileFilter() {
        }

        @Override
        public boolean accept(File f) {
            if (f.isDirectory()) {
                return true;
            }
            String name = f.getName();
            return name.matches(".*\\.xml");
        }

        @Override
        public String getDescription() {
            return Bundle.getMessage("BackupFolders");
        }
    }
}

