/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.operations.setup;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import jmri.jmrit.XmlFile;
import jmri.jmrit.operations.OperationsXml;
import jmri.jmrit.operations.setup.BackupSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BackupBase {
    private static final Logger log = LoggerFactory.getLogger(BackupBase.class);
    public RuntimeException testException = null;
    protected File _operationsRoot = null;
    protected File _backupRoot;
    private final String[] _backupSetFileNames = new String[]{"Operations.xml", "OperationsCarRoster.xml", "OperationsEngineRoster.xml", "OperationsLocationRoster.xml", "OperationsRouteRoster.xml", "OperationsTrainRoster.xml"};
    private final String _demoPanelFileName = "Operations Demo Panel.xml";

    public File getOperationsRoot() {
        return this._operationsRoot;
    }

    public File getBackupRoot() {
        return this._backupRoot;
    }

    public String[] getBackupSetFileNames() {
        return (String[])this._backupSetFileNames.clone();
    }

    protected BackupBase(String rootName) {
        Boolean ok;
        if (rootName == null) {
            throw new IllegalArgumentException("Backup root name can't be null");
        }
        this._operationsRoot = new File(OperationsXml.getFileLocation(), OperationsXml.getOperationsDirectoryName());
        this._backupRoot = new File(this.getOperationsRoot(), rootName);
        if (!this.getBackupRoot().exists() && !(ok = Boolean.valueOf(this.getBackupRoot().mkdirs())).booleanValue()) {
            throw new RuntimeException("Unable to make directory: " + this.getBackupRoot().getAbsolutePath());
        }
    }

    public void backupFilesToSetName(String setName) throws IOException {
        this.validateNotNullOrEmpty(setName);
        this.copyBackupSet(this.getOperationsRoot(), new File(this.getBackupRoot(), setName));
    }

    private void validateNotNullOrEmpty(String s) {
        if (s == null || s.trim().length() == 0) {
            throw new IllegalArgumentException("string cannot be null or empty.");
        }
    }

    public void backupFilesToDirectory(File backupDirectory) throws IOException {
        this.copyBackupSet(this.getOperationsRoot(), backupDirectory);
    }

    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"}, justification="not possible")
    public String[] getBackupSetList() {
        Object[] setList = this.getBackupRoot().list();
        Arrays.sort(setList);
        return setList;
    }

    public File[] getBackupSetDirs() {
        File[] dirs = this.getBackupRoot().listFiles();
        return dirs;
    }

    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"}, justification="not possible")
    public BackupSet[] getBackupSets() {
        Object[] dirs = this.getBackupRoot().listFiles();
        Arrays.sort(dirs);
        BackupSet[] sets = new BackupSet[dirs.length];
        int i = 0;
        while (i < dirs.length) {
            sets[i] = new BackupSet((File)dirs[i]);
            ++i;
        }
        return sets;
    }

    public boolean checkIfBackupSetExists(String setName) {
        this.validateNotNullOrEmpty(setName);
        try {
            File file = new File(this.getBackupRoot(), setName);
            if (file.exists()) {
                return true;
            }
        }
        catch (Exception exception) {
            log.error("Exception during backup set directory exists check");
        }
        return false;
    }

    public void restoreFilesFromSetName(String setName) throws IOException {
        this.copyBackupSet(new File(this.getBackupRoot(), setName), this.getOperationsRoot());
    }

    public void restoreFilesFromDirectory(File directory) throws IOException {
        log.debug("restoring files from directory {}", (Object)directory.getAbsolutePath());
        this.copyBackupSet(directory, this.getOperationsRoot());
    }

    public void copyBackupSet(File sourceDir, File destDir) throws IOException {
        boolean result;
        log.debug("copying backup set from: {} to: {}", (Object)sourceDir, (Object)destDir);
        log.info("Saving copy of operations files to: {}", (Object)destDir);
        if (!sourceDir.exists()) {
            throw new IOException("Backup Set source directory: " + sourceDir.getAbsolutePath() + " does not exist");
        }
        int sourceCount = this.getSourceFileCount(sourceDir);
        if (sourceCount == 0) {
            log.debug("No source files found in {} so skipping copy.", (Object)sourceDir.getAbsolutePath());
            return;
        }
        if (sourceCount != this._backupSetFileNames.length) {
            log.warn("Only {} file(s) found in directory {}", (Object)sourceCount, (Object)sourceDir.getAbsolutePath());
        }
        if (!destDir.exists() && !(result = destDir.mkdirs())) {
            throw new IOException(String.valueOf(destDir.getAbsolutePath()) + " (Could not create all or part of the Backup Set path)");
        }
        String[] stringArray = this._backupSetFileNames;
        int n = this._backupSetFileNames.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            log.debug("copying file: {}", (Object)name);
            File src = new File(sourceDir, name);
            if (src.exists()) {
                File dst = new File(destDir, name);
                FileHelper.copy(src.getAbsolutePath(), dst.getAbsolutePath(), true);
            } else {
                log.debug("Source file: {} does not exist, and is not copied.", (Object)src.getAbsolutePath());
            }
            ++n2;
        }
        if (this.testException != null) {
            this.testException.fillInStackTrace();
            throw this.testException;
        }
    }

    public int getSourceFileCount(File sourceDir) {
        int count = 0;
        String[] stringArray = this._backupSetFileNames;
        int n = this._backupSetFileNames.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            Boolean exists = new File(sourceDir, name).exists();
            if (exists.booleanValue()) {
                ++count;
            }
            ++n2;
        }
        return count;
    }

    public void loadDemoFiles() throws IOException {
        File fromDir = new File(XmlFile.xmlDir(), "demoOperations");
        this.copyBackupSet(fromDir, this.getOperationsRoot());
        log.debug("copying file: {}", (Object)"Operations Demo Panel.xml");
        File src = new File(fromDir, "Operations Demo Panel.xml");
        File dst = new File(this.getOperationsRoot(), "Operations Demo Panel.xml");
        FileHelper.copy(src.getAbsolutePath(), dst.getAbsolutePath(), true);
    }

    public String suggestBackupSetName() {
        String baseName = this.getDate();
        String fullName = null;
        String[] dirNames = this.getBackupRoot().list();
        int i = 0;
        while (i < 99) {
            fullName = String.format("%s_%02d", baseName, i);
            boolean foundFileNameMatch = false;
            String[] stringArray = dirNames;
            int n = dirNames.length;
            int n2 = 0;
            while (n2 < n) {
                String name = stringArray[n2];
                if (name.equals(fullName)) {
                    foundFileNameMatch = true;
                    break;
                }
                ++n2;
            }
            if (!foundFileNameMatch) {
                return fullName;
            }
            log.debug("Operations backup directory: {} already exists", (Object)fullName);
            ++i;
        }
        return fullName;
    }

    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"}, justification="not possible")
    public void deleteOperationsFiles() {
        String[] operationFileNames;
        File files = this.getOperationsRoot();
        if (!files.exists()) {
            return;
        }
        String[] stringArray = operationFileNames = files.list();
        int n = operationFileNames.length;
        int n2 = 0;
        while (n2 < n) {
            String fileName = stringArray[n2];
            if (fileName.toUpperCase().endsWith(".XML")) {
                log.debug("deleting file: {}", (Object)fileName);
                File file = new File(this.getOperationsRoot() + File.separator + fileName);
                if (!file.delete()) {
                    log.debug("file not deleted");
                }
            }
            ++n2;
        }
    }

    private String getDate() {
        Date date = Calendar.getInstance().getTime();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy_MM_dd");
        return simpleDateFormat.format(date);
    }

    private static class FileHelper {
        private FileHelper() {
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @SuppressFBWarnings(value={"OBL_UNSATISFIED_OBLIGATION"})
        public static void copy(String sourceFileName, String destFileName, Boolean overwrite) throws IOException {
            block17: {
                if (!overwrite.booleanValue() && new File(destFileName).exists()) {
                    throw new IOException("Destination file exists and overwrite is false.");
                }
                try {
                    Throwable throwable = null;
                    Object var4_6 = null;
                    try {
                        FileInputStream source = new FileInputStream(sourceFileName);
                        try {
                            try (FileOutputStream dest = new FileOutputStream(destFileName);){
                                int len;
                                byte[] buffer = new byte[1024];
                                while ((len = ((InputStream)source).read(buffer)) > 0) {
                                    ((OutputStream)dest).write(buffer, 0, len);
                                }
                            }
                            if (source == null) break block17;
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            if (source == null) throw throwable;
                            ((InputStream)source).close();
                            throw throwable;
                        }
                        ((InputStream)source).close();
                    }
                    catch (Throwable throwable3) {
                        if (throwable == null) {
                            throwable = throwable3;
                            throw throwable;
                        }
                        if (throwable == throwable3) throw throwable;
                        throwable.addSuppressed(throwable3);
                        throw throwable;
                    }
                }
                catch (IOException ex) {
                    String msg = String.format("Error copying file: %s to: %s", sourceFileName, destFileName);
                    throw new IOException(msg, ex);
                }
            }
            File src = new File(sourceFileName);
            File dst = new File(destFileName);
            Boolean ok = dst.setLastModified(src.lastModified());
            if (ok != false) return;
            throw new RuntimeException("Failed to set modified time on file: " + dst.getAbsolutePath());
        }
    }
}

