/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.operations.routes.tools;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.MessageFormat;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import jmri.InstanceManager;
import jmri.jmrit.display.Editor;
import jmri.jmrit.display.EditorManager;
import jmri.jmrit.operations.OperationsFrame;
import jmri.jmrit.operations.routes.Route;
import jmri.jmrit.operations.routes.RouteLocation;
import jmri.jmrit.operations.routes.RouteManager;
import jmri.jmrit.operations.routes.RouteManagerXml;
import jmri.jmrit.operations.routes.tools.Bundle;
import jmri.jmrit.operations.setup.Setup;
import jmri.jmrit.operations.trains.TrainIcon;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SetTrainIconRouteFrame
extends OperationsFrame
implements PropertyChangeListener {
    RouteManager routeManager = InstanceManager.getDefault(RouteManager.class);
    JLabel textX = new JLabel("   X  ");
    JLabel textY = new JLabel("   Y  ");
    JLabel routeLocationName = new JLabel();
    JButton previousButton = new JButton(Bundle.getMessage("Previous"));
    JButton nextButton = new JButton(Bundle.getMessage("Next"));
    JButton placeButton = new JButton(Bundle.getMessage("PlaceTestIcon"));
    JButton applyButton = new JButton(Bundle.getMessage("ButtonApply"));
    JButton saveButton = new JButton(Bundle.getMessage("ButtonSave"));
    JSpinner spinTrainIconX = new JSpinner(new SpinnerNumberModel(0, 0, 10000, 1));
    JSpinner spinTrainIconY = new JSpinner(new SpinnerNumberModel(0, 0, 10000, 1));
    Route _route;
    RouteLocation _rl;
    int _routeIndex = 0;
    List<RouteLocation> _routeList;
    TrainIcon _tIon;
    int value = 1;
    private final int FORWARD = 1;
    private final int BACK = -1;
    private final int NONE = 0;
    private static final Logger log = LoggerFactory.getLogger(SetTrainIconRouteFrame.class);

    public SetTrainIconRouteFrame(Route route) {
        super(Bundle.getMessage("MenuSetTrainIcon"));
        if (route == null) {
            return;
        }
        this._route = route;
        this._route.addPropertyChangeListener(this);
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        this.placeButton.setToolTipText(String.valueOf(Bundle.getMessage("TipPlaceButton")) + " " + Setup.getPanelName());
        this.applyButton.setToolTipText(Bundle.getMessage("TipApplyButton"));
        this.saveButton.setToolTipText(Bundle.getMessage("TipSaveButton"));
        JPanel pRoute = new JPanel();
        pRoute.setBorder(BorderFactory.createTitledBorder(String.valueOf(Bundle.getMessage("Route")) + " " + this._route.getName()));
        pRoute.setLayout(new GridBagLayout());
        this.addItem(pRoute, this.previousButton, 0, 0);
        this.addItem(pRoute, this.routeLocationName, 1, 0);
        this.addItem(pRoute, this.nextButton, 2, 0);
        JPanel pSpin = new JPanel();
        pSpin.setLayout(new GridBagLayout());
        pSpin.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("TrainIcon")));
        this.addItem(pSpin, this.textX, 0, 0);
        this.addItem(pSpin, this.spinTrainIconX, 1, 0);
        this.addItem(pSpin, this.textY, 2, 0);
        this.addItem(pSpin, this.spinTrainIconY, 3, 0);
        JPanel pControl = new JPanel();
        pControl.setLayout(new GridBagLayout());
        pControl.setBorder(BorderFactory.createTitledBorder(""));
        this.addItem(pControl, this.placeButton, 0, 0);
        this.addItem(pControl, this.applyButton, 1, 0);
        this.addItem(pControl, this.saveButton, 2, 0);
        this.getContentPane().add(pRoute);
        this.getContentPane().add(pSpin);
        this.getContentPane().add(pControl);
        this.addHelpMenu("package.jmri.jmrit.operations.Operations_SetTrainIconCoordinates", true);
        this.addButtonAction(this.previousButton);
        this.addButtonAction(this.nextButton);
        this.addButtonAction(this.placeButton);
        this.addButtonAction(this.applyButton);
        this.addButtonAction(this.saveButton);
        this.saveButton.setEnabled(false);
        this.updateRoute();
        this.addSpinnerChangeListerner(this.spinTrainIconX);
        this.addSpinnerChangeListerner(this.spinTrainIconY);
        this.initMinimumSize(new Dimension(400, 400));
    }

    @Override
    public void buttonActionPerformed(ActionEvent ae) {
        if (ae.getSource() == this.previousButton) {
            this.updateRouteLocation(-1);
        }
        if (ae.getSource() == this.nextButton) {
            this.updateRouteLocation(1);
        }
        if (ae.getSource() == this.placeButton) {
            this.placeTestIcons();
        }
        if (ae.getSource() == this.applyButton) {
            if (this.value != 0) {
                this.value = JOptionPane.showConfirmDialog(this, MessageFormat.format(Bundle.getMessage("UpdateTrainIconRoute"), this._route.getName()), Bundle.getMessage("DoYouWantThisRoute"), 0);
            }
            if (this.value == 0) {
                this.saveButton.setEnabled(true);
            }
            this.updateTrainIconCoordinates();
        }
        if (ae.getSource() == this.saveButton) {
            InstanceManager.getDefault(RouteManagerXml.class).writeOperationsFile();
            if (Setup.isCloseWindowOnSaveEnabled()) {
                this.dispose();
            }
        }
    }

    @Override
    public void spinnerChangeEvent(ChangeEvent ae) {
        if (ae.getSource() == this.spinTrainIconX && this._tIon != null) {
            this._tIon.setLocation((Integer)this.spinTrainIconX.getValue(), this._tIon.getLocation().y);
        }
        if (ae.getSource() == this.spinTrainIconY && this._tIon != null) {
            this._tIon.setLocation(this._tIon.getLocation().x, (Integer)this.spinTrainIconY.getValue());
        }
    }

    private void loadSpinners(RouteLocation rl) {
        log.debug("Load spinners route location {}", (Object)rl.getName());
        this.spinTrainIconX.setValue(rl.getTrainIconX());
        this.spinTrainIconY.setValue(rl.getTrainIconY());
    }

    private void placeTestIcons() {
        Editor editor = InstanceManager.getDefault(EditorManager.class).getTargetFrame(Setup.getPanelName());
        if (editor == null) {
            JOptionPane.showMessageDialog(this, MessageFormat.format(Bundle.getMessage("LoadPanel"), Setup.getPanelName()), Bundle.getMessage("PanelNotFound"), 0);
        } else {
            if (this._tIon != null) {
                this._tIon.remove();
            }
            this._tIon = editor.addTrainIcon(this._rl.getName());
            this._tIon.getToolTip().setText(this._route.getName());
            this._tIon.getToolTip().setBackgroundColor(Color.white);
            this._tIon.setLocation(this._rl.getTrainIconX(), this._rl.getTrainIconY());
            this.setTrainIconNameAndColor();
            this.addIconListener(this._tIon);
        }
    }

    private void setTrainIconNameAndColor() {
        if (this._tIon == null) {
            return;
        }
        this._tIon.setText(this._rl.getName());
        if (this._rl.getTrainDirection() == 4) {
            this._tIon.setLocoColor(Setup.getTrainIconColorNorth());
        }
        if (this._rl.getTrainDirection() == 8) {
            this._tIon.setLocoColor(Setup.getTrainIconColorSouth());
        }
        if (this._rl.getTrainDirection() == 1) {
            this._tIon.setLocoColor(Setup.getTrainIconColorEast());
        }
        if (this._rl.getTrainDirection() == 2) {
            this._tIon.setLocoColor(Setup.getTrainIconColorWest());
        }
    }

    private void updateRoute() {
        log.debug("Updating route");
        this._routeList = this._route.getLocationsBySequenceList();
        this.updateRouteLocation(0);
    }

    private void updateRouteLocation(int direction) {
        if (direction == 1) {
            ++this._routeIndex;
        }
        if (direction == -1) {
            --this._routeIndex;
        }
        if (this._routeIndex > this._routeList.size() - 1) {
            this._routeIndex = this._routeList.size() - 1;
        }
        if (this._routeIndex < 0) {
            this._routeIndex = 0;
        }
        if (this._rl != null) {
            this._rl.removePropertyChangeListener(this);
        }
        if (this._routeList.size() > 0) {
            this._rl = this._routeList.get(this._routeIndex);
        }
        if (this._rl != null) {
            this._rl.addPropertyChangeListener(this);
            this.loadSpinners(this._rl);
            this.routeLocationName.setText(this._rl.getName());
        }
        this.previousButton.setEnabled(this._routeIndex != 0);
        this.nextButton.setEnabled(this._routeIndex != this._routeList.size() - 1);
        this.setTrainIconNameAndColor();
    }

    private void updateTrainIconCoordinates() {
        if (this._rl != null) {
            this._rl.removePropertyChangeListener(this);
            this._rl.setTrainIconX((Integer)this.spinTrainIconX.getValue());
            this._rl.setTrainIconY((Integer)this.spinTrainIconY.getValue());
            this._rl.addPropertyChangeListener(this);
        }
    }

    private void addIconListener(TrainIcon tI) {
        tI.addComponentListener(new ComponentListener(){

            @Override
            public void componentHidden(ComponentEvent e) {
            }

            @Override
            public void componentShown(ComponentEvent e) {
            }

            @Override
            public void componentMoved(ComponentEvent e) {
                SetTrainIconRouteFrame.this.trainIconMoved(e);
            }

            @Override
            public void componentResized(ComponentEvent e) {
            }
        });
    }

    protected void trainIconMoved(ComponentEvent ae) {
        if (ae.getSource() == this._tIon) {
            log.debug("train icon X: {} Y: {}", (Object)this._tIon.getLocation().x, (Object)this._tIon.getLocation().y);
            this.spinTrainIconX.setValue(this._tIon.getLocation().x);
            this.spinTrainIconY.setValue(this._tIon.getLocation().y);
        }
    }

    private void removeIcons() {
        if (this._tIon != null) {
            this._tIon.remove();
        }
    }

    @Override
    public void dispose() {
        this.removeIcons();
        if (this._route != null) {
            this._route.removePropertyChangeListener(this);
        }
        if (this._rl != null) {
            this._rl.removePropertyChangeListener(this);
        }
        super.dispose();
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        log.debug("Property change ({}) old: ({}) new: ({})", new Object[]{e.getPropertyName(), e.getOldValue(), e.getNewValue()});
        if (e.getSource().equals(this._route)) {
            this.updateRoute();
        }
        if (e.getSource().equals(this._rl)) {
            this.updateRouteLocation(0);
        }
    }
}

