/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.operations.routes.tools;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import jmri.jmrit.operations.routes.Route;
import jmri.jmrit.operations.routes.RouteLocation;
import jmri.jmrit.operations.routes.tools.Bundle;
import jmri.jmrit.operations.routes.tools.RouteBlockingOrderEditFrame;
import jmri.jmrit.symbolicprog.ValueEditor;
import jmri.jmrit.symbolicprog.ValueRenderer;
import jmri.util.swing.XTableColumnModel;
import jmri.util.table.ButtonEditor;
import jmri.util.table.ButtonRenderer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RouteBlockingOrderEditTableModel
extends AbstractTableModel
implements PropertyChangeListener {
    private static final int ID_COLUMN = 0;
    private static final int NAME_COLUMN = 1;
    private static final int TRAIN_DIRECTION_COLUMN = 2;
    private static final int UP_COLUMN = 3;
    private static final int DOWN_COLUMN = 4;
    private static final int HIGHEST_COLUMN = 5;
    private JTable _table;
    private Route _route;
    private RouteBlockingOrderEditFrame _frame;
    List<RouteLocation> _blockingOrderList = new ArrayList<RouteLocation>();
    private static final Logger log = LoggerFactory.getLogger(RouteBlockingOrderEditTableModel.class);

    private void updateList() {
        if (this._route == null) {
            return;
        }
        this.removePropertyChangeRouteLocations();
        this._blockingOrderList = this._route.getBlockingOrder();
        for (RouteLocation rl : this._blockingOrderList) {
            rl.addPropertyChangeListener(this);
        }
    }

    protected void initTable(RouteBlockingOrderEditFrame frame, JTable table, Route route) {
        this._frame = frame;
        this._table = table;
        this._route = route;
        if (this._route != null) {
            this._route.addPropertyChangeListener(this);
        }
        this.initTable(table);
    }

    private void initTable(JTable table) {
        XTableColumnModel tcm = new XTableColumnModel();
        this._table.setColumnModel(tcm);
        this._table.createDefaultColumnsFromModel();
        ButtonRenderer buttonRenderer = new ButtonRenderer();
        ButtonEditor buttonEditor = new ButtonEditor(new JButton());
        tcm.getColumn(3).setCellRenderer(buttonRenderer);
        tcm.getColumn(3).setCellEditor(buttonEditor);
        tcm.getColumn(4).setCellRenderer(buttonRenderer);
        tcm.getColumn(4).setCellEditor(buttonEditor);
        table.setDefaultRenderer(JComboBox.class, new ValueRenderer());
        table.setDefaultEditor(JComboBox.class, new ValueEditor());
        table.getColumnModel().getColumn(0).setPreferredWidth(40);
        table.getColumnModel().getColumn(1).setPreferredWidth(150);
        table.getColumnModel().getColumn(2).setPreferredWidth(95);
        table.getColumnModel().getColumn(3).setPreferredWidth(60);
        table.getColumnModel().getColumn(4).setPreferredWidth(70);
        this._frame.loadTableDetails(table);
        table.setRowSorter(null);
        this.updateList();
    }

    @Override
    public int getRowCount() {
        return this._blockingOrderList.size();
    }

    @Override
    public int getColumnCount() {
        return 5;
    }

    @Override
    public String getColumnName(int col) {
        switch (col) {
            case 0: {
                return Bundle.getMessage("Id");
            }
            case 1: {
                return Bundle.getMessage("Location");
            }
            case 2: {
                return Bundle.getMessage("TrainDirection");
            }
            case 3: {
                return Bundle.getMessage("Up");
            }
            case 4: {
                return Bundle.getMessage("Down");
            }
        }
        return "unknown";
    }

    @Override
    public Class<?> getColumnClass(int col) {
        switch (col) {
            case 0: 
            case 1: 
            case 2: {
                return String.class;
            }
            case 3: 
            case 4: {
                return JButton.class;
            }
        }
        return null;
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        switch (col) {
            case 3: 
            case 4: {
                return true;
            }
        }
        return false;
    }

    @Override
    public Object getValueAt(int row, int col) {
        if (row >= this.getRowCount()) {
            return "ERROR unknown " + row;
        }
        RouteLocation rl = this._blockingOrderList.get(row);
        if (rl == null) {
            return "ERROR unknown route location " + row;
        }
        switch (col) {
            case 0: {
                return rl.getId();
            }
            case 1: {
                return rl.getName();
            }
            case 2: {
                return rl.getTrainDirectionString();
            }
            case 3: {
                return Bundle.getMessage("Up");
            }
            case 4: {
                return Bundle.getMessage("Down");
            }
        }
        return "unknown " + col;
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        if (value == null) {
            log.debug("Warning route table row {} still in edit", (Object)row);
            return;
        }
        RouteLocation rl = this._blockingOrderList.get(row);
        if (rl == null) {
            log.error("ERROR unknown route location for row: {}", (Object)row);
        }
        switch (col) {
            case 3: {
                this.moveUpRouteLocation(rl);
                break;
            }
            case 4: {
                this.moveDownRouteLocation(rl);
                break;
            }
        }
    }

    private void moveUpRouteLocation(RouteLocation rl) {
        log.debug("move location up");
        this._route.setBlockingOrderUp(rl);
    }

    private void moveDownRouteLocation(RouteLocation rl) {
        log.debug("move location down");
        this._route.setBlockingOrderDown(rl);
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        RouteLocation rl;
        int row;
        if (e.getPropertyName().equals("routeBlockingChange")) {
            this.updateList();
            this.fireTableDataChanged();
        }
        if (e.getSource().getClass().equals(RouteLocation.class) && (row = this._blockingOrderList.indexOf(rl = (RouteLocation)e.getSource())) >= 0) {
            this.fireTableRowsUpdated(row, row);
        }
    }

    private void removePropertyChangeRouteLocations() {
        for (RouteLocation rl : this._blockingOrderList) {
            rl.removePropertyChangeListener(this);
        }
    }

    public void dispose() {
        this.removePropertyChangeRouteLocations();
        if (this._route != null) {
            this._route.removePropertyChangeListener(this);
        }
        this._blockingOrderList.clear();
        this.fireTableDataChanged();
    }
}

