/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.operations.routes.tools;

import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import jmri.InstanceManager;
import jmri.jmrit.operations.OperationsFrame;
import jmri.jmrit.operations.OperationsXml;
import jmri.jmrit.operations.routes.Route;
import jmri.jmrit.operations.routes.RouteManager;
import jmri.jmrit.operations.routes.tools.Bundle;
import jmri.jmrit.operations.routes.tools.RouteBlockingOrderEditTableModel;
import jmri.jmrit.operations.setup.Setup;
import jmri.jmrit.operations.trains.Train;
import jmri.swing.JTablePersistenceManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RouteBlockingOrderEditFrame
extends OperationsFrame
implements PropertyChangeListener {
    RouteBlockingOrderEditTableModel routeModel = new RouteBlockingOrderEditTableModel();
    JTable routeTable = new JTable(this.routeModel);
    JScrollPane routePane;
    RouteManager routeManager;
    Route _route = null;
    Train _train = null;
    JButton saveRouteButton = new JButton(Bundle.getMessage("SaveRoute"));
    JButton resetRouteButton = new JButton(Bundle.getMessage("ButtonReset"));
    JLabel routeName = new JLabel();
    JLabel routeComment = new JLabel();
    private static final Logger log = LoggerFactory.getLogger(RouteBlockingOrderEditFrame.class);

    public RouteBlockingOrderEditFrame(Route route) {
        super(Bundle.getMessage("MenuBlockingOrder"));
        this.initComponents(route);
    }

    private void initComponents(Route route) {
        this._route = route;
        this.routeManager = InstanceManager.getDefault(RouteManager.class);
        this.routePane = new JScrollPane(this.routeTable);
        this.routePane.setVerticalScrollBarPolicy(20);
        this.routePane.setBorder(BorderFactory.createTitledBorder(""));
        this.routeModel.initTable(this, this.routeTable, this._route);
        if (this._route != null) {
            this._route.addPropertyChangeListener(this);
            this.routeName.setText(this._route.getName());
            this.routeComment.setText(this._route.getComment());
            this.enableButtons(!route.getStatus().equals(Route.TRAIN_BUILT));
        }
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        JPanel p1 = new JPanel();
        p1.setLayout(new BoxLayout(p1, 0));
        JScrollPane p1Pane = new JScrollPane(p1);
        p1Pane.setVerticalScrollBarPolicy(21);
        p1Pane.setMaximumSize(new Dimension(2000, 200));
        p1Pane.setBorder(BorderFactory.createTitledBorder(""));
        JPanel pName = new JPanel();
        pName.setLayout(new GridBagLayout());
        pName.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("Name")));
        this.addItem(pName, this.routeName, 0, 0);
        JPanel pComment = new JPanel();
        pComment.setLayout(new GridBagLayout());
        pComment.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("Comment")));
        this.addItem(pComment, this.routeComment, 0, 0);
        p1.add(pName);
        p1.add(pComment);
        JPanel pF = new JPanel();
        this.addItem(pF, new JLabel(Bundle.getMessage("TrainFront")), 0, 0);
        JPanel pR = new JPanel();
        this.addItem(pR, new JLabel(Bundle.getMessage("TrainRear")), 0, 0);
        JPanel pB = new JPanel();
        pB.setLayout(new GridBagLayout());
        JScrollPane pBPane = new JScrollPane(pB);
        pBPane.setVerticalScrollBarPolicy(21);
        pBPane.setMaximumSize(new Dimension(2000, 200));
        pBPane.setBorder(BorderFactory.createTitledBorder(""));
        this.addItem(pB, this.resetRouteButton, 2, 0);
        this.addItem(pB, this.saveRouteButton, 3, 0);
        this.getContentPane().add(p1Pane);
        this.getContentPane().add(pF);
        this.getContentPane().add(this.routePane);
        this.getContentPane().add(pR);
        this.getContentPane().add(pBPane);
        this.addButtonAction(this.resetRouteButton);
        this.addButtonAction(this.saveRouteButton);
        JMenuBar menuBar = new JMenuBar();
        this.setJMenuBar(menuBar);
        this.addHelpMenu("package.jmri.jmrit.operations.Operations_RouteBlockingOrder", true);
        this.initMinimumSize(new Dimension(500, 400));
    }

    @Override
    public void buttonActionPerformed(ActionEvent ae) {
        if (ae.getSource() == this.saveRouteButton) {
            log.debug("route save button activated");
            this.saveRoute();
            if (Setup.isCloseWindowOnSaveEnabled()) {
                this.dispose();
            }
        }
        if (ae.getSource() == this.resetRouteButton) {
            log.debug("route reset button activated");
            if (this._route != null) {
                this._route.resetBlockingOrder();
            }
        }
    }

    private void saveRoute() {
        if (this.routeTable.isEditing()) {
            log.debug("route table edit true");
            this.routeTable.getCellEditor().stopCellEditing();
        }
        OperationsXml.save();
    }

    private void enableButtons(boolean enabled) {
        this.resetRouteButton.setEnabled(enabled);
        this.saveRouteButton.setEnabled(enabled);
        this.routeTable.setEnabled(enabled);
    }

    @Override
    public void dispose() {
        InstanceManager.getOptionalDefault(JTablePersistenceManager.class).ifPresent(tpm -> tpm.stopPersisting(this.routeTable));
        if (this._route != null) {
            this._route.removePropertyChangeListener(this);
        }
        this.routeModel.dispose();
        super.dispose();
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        if (e.getPropertyName().equals("routeStatusChange")) {
            this.enableButtons(!this._route.getStatus().equals(Route.TRAIN_BUILT));
        }
    }
}

