/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.operations.routes.tools;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.List;
import jmri.InstanceManager;
import jmri.jmrit.operations.routes.Route;
import jmri.jmrit.operations.routes.RouteManager;
import jmri.jmrit.operations.routes.tools.Bundle;
import jmri.jmrit.operations.routes.tools.PrintRouteAction;
import jmri.jmrit.operations.setup.Control;
import jmri.util.davidflanagan.HardcopyWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrintRoutesAction
extends PrintRouteAction {
    private static final char FORM_FEED = '\f';
    private static final Logger log = LoggerFactory.getLogger(PrintRoutesAction.class);

    public PrintRoutesAction(boolean preview) {
        super(preview, null);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        log.debug("Print all routes");
        HardcopyWriter writer = null;
        try {
            writer = new HardcopyWriter(new Frame(), Bundle.getMessage("TitleRoutesTable"), Control.reportFontSize, 0.5, 0.5, 0.5, 0.5, this._isPreview);
        }
        catch (HardcopyWriter.PrintCanceledException printCanceledException) {
            log.debug("Print cancelled");
            return;
        }
        try {
            writer.write(" ");
            List<Route> routes = InstanceManager.getDefault(RouteManager.class).getRoutesByNameList();
            int i = 0;
            while (i < routes.size()) {
                Route route = routes.get(i);
                writer.write(String.valueOf(route.getName()) + "\n");
                this.printRoute(writer, route);
                if (i != routes.size() - 1) {
                    writer.write(12);
                }
                ++i;
            }
        }
        catch (IOException iOException) {
            log.error("Exception in print routes");
        }
        writer.close();
    }
}

