/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.operations.routes.tools;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.List;
import javax.swing.AbstractAction;
import jmri.jmrit.operations.routes.Route;
import jmri.jmrit.operations.routes.RouteLocation;
import jmri.jmrit.operations.routes.tools.Bundle;
import jmri.jmrit.operations.setup.Control;
import jmri.util.davidflanagan.HardcopyWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrintRouteAction
extends AbstractAction {
    static final String NEW_LINE = "\n";
    static final String TAB = "\t";
    private static final int MAX_NAME_LENGTH = Control.max_len_string_location_name - 5;
    boolean _isPreview;
    Route _route;
    private static final Logger log = LoggerFactory.getLogger(PrintRouteAction.class);

    public PrintRouteAction(boolean isPreview, Route route) {
        super(isPreview ? Bundle.getMessage("MenuItemPreview") : Bundle.getMessage("MenuItemPrint"));
        this._isPreview = isPreview;
        this._route = route;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this._route == null) {
            return;
        }
        HardcopyWriter writer = null;
        try {
            writer = new HardcopyWriter(new Frame(), MessageFormat.format(Bundle.getMessage("TitleRoute"), this._route.getName()), Control.reportFontSize, 0.5, 0.5, 0.5, 0.5, this._isPreview);
        }
        catch (HardcopyWriter.PrintCanceledException printCanceledException) {
            log.debug("Print cancelled");
            return;
        }
        this.printRoute(writer, this._route);
        writer.close();
    }

    protected void printRoute(HardcopyWriter writer, Route route) {
        try {
            String name;
            writer.write(String.valueOf(route.getComment()) + NEW_LINE);
            String s = String.valueOf(Bundle.getMessage("Location")) + TAB + "    " + Bundle.getMessage("Direction") + " " + Bundle.getMessage("MaxMoves") + " " + Bundle.getMessage("Pickups") + " " + Bundle.getMessage("Drops") + " " + Bundle.getMessage("Wait") + TAB + Bundle.getMessage("Length") + TAB + Bundle.getMessage("Grade") + TAB + Bundle.getMessage("X") + "    " + Bundle.getMessage("Y") + NEW_LINE;
            writer.write(s);
            List<RouteLocation> routeList = route.getLocationsBySequenceList();
            for (RouteLocation rl : routeList) {
                name = rl.getName();
                name = this.truncate(name);
                String pad = " ";
                if (rl.getTrainIconX() < 10) {
                    pad = "    ";
                } else if (rl.getTrainIconX() < 100) {
                    pad = "   ";
                } else if (rl.getTrainIconX() < 1000) {
                    pad = "  ";
                }
                s = String.valueOf(name) + TAB + rl.getTrainDirectionString() + TAB + rl.getMaxCarMoves() + TAB + (rl.isPickUpAllowed() ? Bundle.getMessage("yes") : Bundle.getMessage("no")) + TAB + (rl.isDropAllowed() ? Bundle.getMessage("yes") : Bundle.getMessage("no")) + TAB + rl.getWait() + TAB + rl.getMaxTrainLength() + TAB + rl.getGrade() + TAB + rl.getTrainIconX() + pad + rl.getTrainIconY() + NEW_LINE;
                writer.write(s);
            }
            s = NEW_LINE + Bundle.getMessage("Location") + TAB + Bundle.getMessage("DepartTime") + TAB + Bundle.getMessage("Comment") + NEW_LINE;
            writer.write(s);
            for (RouteLocation rl : routeList) {
                name = rl.getName();
                name = this.truncate(name);
                s = String.valueOf(name) + TAB + rl.getDepartureTime() + TAB + rl.getComment() + NEW_LINE;
                writer.write(s);
            }
        }
        catch (IOException iOException) {
            log.error("Error printing route");
        }
    }

    private String truncate(String string) {
        if ((string = string.trim()).length() > MAX_NAME_LENGTH) {
            string = string.substring(0, MAX_NAME_LENGTH);
        }
        StringBuffer buf = new StringBuffer(string);
        int j = string.length();
        while (j < MAX_NAME_LENGTH) {
            buf.append(" ");
            ++j;
        }
        return buf.toString();
    }
}

