/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.operations.routes.tools;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import javax.swing.JOptionPane;
import jmri.InstanceManager;
import jmri.jmrit.XmlFile;
import jmri.jmrit.operations.routes.Route;
import jmri.jmrit.operations.routes.RouteLocation;
import jmri.jmrit.operations.routes.RouteManager;
import jmri.jmrit.operations.routes.tools.Bundle;
import jmri.jmrit.operations.setup.OperationsSetupXml;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExportRoutes
extends XmlFile {
    private static String operationsFileName = "ExportOperationsRoutes.csv";
    private static final Logger log = LoggerFactory.getLogger(ExportRoutes.class);

    public void writeOperationsRoutesFile() {
        this.makeBackupFile(ExportRoutes.defaultOperationsFilename());
        try {
            if (!this.checkFile(ExportRoutes.defaultOperationsFilename())) {
                File file = new File(ExportRoutes.defaultOperationsFilename());
                File parentDir = file.getParentFile();
                if (!parentDir.exists() && !parentDir.mkdir()) {
                    log.error("Directory wasn't created");
                }
                if (file.createNewFile()) {
                    log.debug("File created");
                }
            }
            this.writeFile(ExportRoutes.defaultOperationsFilename());
        }
        catch (IOException e) {
            log.error("Exception while writing the new CSV operations file, may not be complete: {}", (Throwable)e);
        }
    }

    public void writeFile(String name) {
        log.debug("writeFile {}", (Object)name);
        File file = this.findFile(name);
        if (file == null) {
            file = new File(name);
        }
        int count = 0;
        try {
            Throwable throwable = null;
            Object var5_6 = null;
            try (CSVPrinter fileOut = new CSVPrinter((Appendable)new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), StandardCharsets.UTF_8)), CSVFormat.DEFAULT);){
                this.loadHeader(fileOut);
                for (Route route : InstanceManager.getDefault(RouteManager.class).getRoutesByNameList()) {
                    ++count;
                    fileOut.printRecord(new Object[]{route.getName(), "", route.getComment()});
                    for (RouteLocation rl : route.getLocationsBySequenceList()) {
                        fileOut.printRecord(new Object[]{"", rl.getLocation().getName(), rl.getTrainDirectionString(), rl.getMaxCarMoves(), rl.getRandomControl(), rl.isPickUpAllowed() ? Bundle.getMessage("yes") : Bundle.getMessage("no"), rl.isDropAllowed() ? Bundle.getMessage("yes") : Bundle.getMessage("no"), rl.getWait(), rl.getFormatedDepartureTime(), rl.getMaxTrainLength(), rl.getGrade(), rl.getTrainIconX(), rl.getTrainIconY(), rl.getComment().replace("\n", "<LF>"), rl.getCommentTextColor()});
                    }
                }
                JOptionPane.showMessageDialog(null, MessageFormat.format(Bundle.getMessage("ExportedRoutesToFile"), count, ExportRoutes.defaultOperationsFilename()), Bundle.getMessage("ExportComplete"), 1);
                fileOut.flush();
                fileOut.close();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException iOException) {
            log.error("Can not open export Routes CSV file: {}", (Object)file.getName());
            JOptionPane.showMessageDialog(null, MessageFormat.format(Bundle.getMessage("ExportedRoutesToFile"), 0, ExportRoutes.defaultOperationsFilename()), Bundle.getMessage("ExportFailed"), 0);
        }
    }

    private void loadHeader(CSVPrinter fileOut) throws IOException {
        fileOut.printRecord(new Object[]{Bundle.getMessage("Route"), Bundle.getMessage("Location"), Bundle.getMessage("TrainDirection"), Bundle.getMessage("Moves"), Bundle.getMessage("Random"), Bundle.getMessage("Pickups"), Bundle.getMessage("Drops"), Bundle.getMessage("Wait"), Bundle.getMessage("DepartTime"), Bundle.getMessage("MaxLength"), Bundle.getMessage("Grade"), Bundle.getMessage("X"), Bundle.getMessage("Y"), Bundle.getMessage("Comment"), Bundle.getMessage("TextColor")});
    }

    public File getExportFile() {
        return this.findFile(ExportRoutes.defaultOperationsFilename());
    }

    public static String defaultOperationsFilename() {
        return String.valueOf(OperationsSetupXml.getFileLocation()) + OperationsSetupXml.getOperationsDirectoryName() + File.separator + ExportRoutes.getOperationsFileName();
    }

    public static void setOperationsFileName(String name) {
        operationsFileName = name;
    }

    public static String getOperationsFileName() {
        return operationsFileName;
    }
}

