/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.operations.routes;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashMap;
import jmri.InstanceManager;
import jmri.InstanceManagerAutoDefault;
import jmri.InstanceManagerAutoInitialize;
import jmri.jmrit.operations.OperationsXml;
import jmri.jmrit.operations.routes.RouteManager;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.ProcessingInstruction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RouteManagerXml
extends OperationsXml
implements InstanceManagerAutoDefault,
InstanceManagerAutoInitialize {
    private String operationsFileName = "OperationsRouteRoster.xml";
    private static final Logger log = LoggerFactory.getLogger(RouteManagerXml.class);

    @Override
    public void writeFile(String name) throws FileNotFoundException, IOException {
        log.debug("writeFile {}", (Object)name);
        File file = this.findFile(name);
        if (file == null) {
            file = new File(name);
        }
        Element root = new Element("operations-config");
        Document doc = RouteManagerXml.newDocument(root, String.valueOf(this.dtdLocation) + "operations-routes.dtd");
        HashMap<String, String> m = new HashMap<String, String>();
        m.put("type", "text/xsl");
        m.put("href", "/xml/XSLT/operations-routes.xsl");
        ProcessingInstruction p = new ProcessingInstruction("xml-stylesheet", m);
        doc.addContent(0, (Content)p);
        InstanceManager.getDefault(RouteManager.class).store(root);
        this.writeXML(file, doc);
        this.setDirty(false);
    }

    @Override
    public void readFile(String name) throws JDOMException, IOException {
        if (this.findFile(name) == null) {
            log.debug("{} file could not be found", (Object)name);
            return;
        }
        Element root = this.rootFromName(name);
        if (root == null) {
            log.debug("{} file could not be read", (Object)name);
            return;
        }
        InstanceManager.getDefault(RouteManager.class).load(root);
        this.setDirty(false);
    }

    @Override
    public void setOperationsFileName(String name) {
        this.operationsFileName = name;
    }

    @Override
    public String getOperationsFileName() {
        return this.operationsFileName;
    }

    public void dispose() {
    }

    @Override
    public void initialize() {
        this.load();
    }
}

