/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.operations.routes;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import javax.swing.JComboBox;
import jmri.InstanceManager;
import jmri.InstanceManagerAutoDefault;
import jmri.InstanceManagerAutoInitialize;
import jmri.beans.PropertyChangeSupport;
import jmri.jmrit.operations.locations.Location;
import jmri.jmrit.operations.locations.LocationManager;
import jmri.jmrit.operations.routes.Route;
import jmri.jmrit.operations.routes.RouteLocation;
import jmri.jmrit.operations.routes.RouteManagerXml;
import jmri.jmrit.operations.setup.OperationsSetupXml;
import org.jdom2.Content;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RouteManager
extends PropertyChangeSupport
implements InstanceManagerAutoDefault,
InstanceManagerAutoInitialize {
    public static final String LISTLENGTH_CHANGED_PROPERTY = "routesListLengthChanged";
    private int _id = 0;
    protected Hashtable<String, Route> _routeHashTable = new Hashtable();
    private static final Logger log = LoggerFactory.getLogger(RouteManager.class);

    public void dispose() {
        this._routeHashTable.clear();
        this._id = 0;
    }

    public Route getRouteByName(String name) {
        Enumeration<Route> en = this._routeHashTable.elements();
        while (en.hasMoreElements()) {
            Route l = en.nextElement();
            if (!l.getName().equals(name)) continue;
            return l;
        }
        return null;
    }

    public Route getRouteById(String id) {
        return this._routeHashTable.get(id);
    }

    public Route newRoute(String name) {
        Route route = this.getRouteByName(name);
        if (route == null) {
            ++this._id;
            route = new Route(Integer.toString(this._id), name);
            Integer oldSize = this._routeHashTable.size();
            this._routeHashTable.put(route.getId(), route);
            this.setDirtyAndFirePropertyChange(LISTLENGTH_CHANGED_PROPERTY, oldSize, this._routeHashTable.size());
        }
        return route;
    }

    public void register(Route route) {
        Integer oldSize = this._routeHashTable.size();
        this._routeHashTable.put(route.getId(), route);
        int id = Integer.parseInt(route.getId());
        if (id > this._id) {
            this._id = id;
        }
        this.setDirtyAndFirePropertyChange(LISTLENGTH_CHANGED_PROPERTY, oldSize, this._routeHashTable.size());
    }

    public void deregister(Route route) {
        if (route == null) {
            return;
        }
        route.dispose();
        Integer oldSize = this._routeHashTable.size();
        this._routeHashTable.remove(route.getId());
        this.setDirtyAndFirePropertyChange(LISTLENGTH_CHANGED_PROPERTY, oldSize, this._routeHashTable.size());
    }

    public List<Route> getRoutesByNameList() {
        List<Route> sortList = this.getList();
        ArrayList<Route> out = new ArrayList<Route>();
        for (Route route : sortList) {
            int j = 0;
            while (j < out.size()) {
                if (route.getName().compareToIgnoreCase(((Route)out.get(j)).getName()) < 0) {
                    out.add(j, route);
                    break;
                }
                ++j;
            }
            if (out.contains(route)) continue;
            out.add(route);
        }
        return out;
    }

    public List<Route> getRoutesByIdList() {
        List<Route> sortList = this.getList();
        ArrayList<Route> out = new ArrayList<Route>();
        for (Route route : sortList) {
            int j = 0;
            while (j < out.size()) {
                try {
                    if (Integer.parseInt(route.getId()) < Integer.parseInt(((Route)out.get(j)).getId())) {
                        out.add(j, route);
                        break;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    log.error("list id number isn't a number");
                }
                ++j;
            }
            if (out.contains(route)) continue;
            out.add(route);
        }
        return out;
    }

    private List<Route> getList() {
        ArrayList<Route> out = new ArrayList<Route>();
        Enumeration<Route> en = this._routeHashTable.elements();
        while (en.hasMoreElements()) {
            out.add(en.nextElement());
        }
        return out;
    }

    public JComboBox<Route> getComboBox() {
        JComboBox<Route> box = new JComboBox<Route>();
        box.addItem(null);
        List<Route> routes = this.getRoutesByNameList();
        for (Route route : routes) {
            box.addItem(route);
        }
        return box;
    }

    public void updateComboBox(JComboBox<Route> box) {
        box.removeAllItems();
        box.addItem(null);
        List<Route> routes = this.getRoutesByNameList();
        for (Route route : routes) {
            box.addItem(route);
        }
    }

    public Route copyRoute(Route route, String routeName, boolean invert) {
        Route newRoute = this.newRoute(routeName);
        List<RouteLocation> routeList = route.getLocationsBySequenceList();
        if (!invert) {
            for (RouteLocation rl : routeList) {
                this.copyRouteLocation(newRoute, rl, null, invert);
            }
        } else {
            int i = routeList.size() - 1;
            while (i >= 0) {
                int y = i - 1;
                if (y < 0) {
                    y = 0;
                }
                this.copyRouteLocation(newRoute, routeList.get(i), routeList.get(y), invert);
                --i;
            }
        }
        newRoute.setComment(route.getComment());
        return newRoute;
    }

    private void copyRouteLocation(Route newRoute, RouteLocation rl, RouteLocation rlNext, boolean invert) {
        Location loc = InstanceManager.getDefault(LocationManager.class).getLocationByName(rl.getName());
        RouteLocation rlNew = newRoute.addLocation(loc);
        rlNew.setMaxCarMoves(rl.getMaxCarMoves());
        rlNew.setRandomControl(rl.getRandomControl());
        rlNew.setWait(rl.getWait());
        rlNew.setDepartureTime(rl.getDepartureTime());
        rlNew.setComment(rl.getComment());
        rlNew.setCommentColor(rl.getCommentColor());
        if (!invert) {
            rlNew.setDropAllowed(rl.isDropAllowed());
            rlNew.setPickUpAllowed(rl.isPickUpAllowed());
            rlNew.setGrade(rl.getGrade());
            rlNew.setTrainDirection(rl.getTrainDirection());
            rlNew.setMaxTrainLength(rl.getMaxTrainLength());
        } else {
            rlNew.setDropAllowed(rl.isPickUpAllowed());
            rlNew.setPickUpAllowed(rl.isDropAllowed());
            int oldDirection = rl.getTrainDirection();
            if (oldDirection == 4) {
                rlNew.setTrainDirection(8);
            } else if (oldDirection == 8) {
                rlNew.setTrainDirection(4);
            } else if (oldDirection == 1) {
                rlNew.setTrainDirection(2);
            } else if (oldDirection == 2) {
                rlNew.setTrainDirection(1);
            }
            if (rlNext == null) {
                log.error("Can not copy route, rlNext is null!");
                return;
            }
            rlNew.setMaxTrainLength(rlNext.getMaxTrainLength());
        }
        rlNew.setTrainIconX(rl.getTrainIconX());
        rlNew.setTrainIconY(rl.getTrainIconY());
    }

    public int numEntries() {
        return this._routeHashTable.size();
    }

    public void load(Element root) {
        if (root.getChild("routes") != null) {
            List eRoutes = root.getChild("routes").getChildren("route");
            log.debug("readFile sees {} routes", (Object)eRoutes.size());
            for (Element eRoute : eRoutes) {
                this.register(new Route(eRoute));
            }
        }
    }

    public void store(Element root) {
        Element values = new Element("routes");
        root.addContent((Content)values);
        for (Route route : this.getRoutesByIdList()) {
            values.addContent((Content)route.store());
        }
    }

    protected void setDirtyAndFirePropertyChange(String p, Object old, Object n) {
        InstanceManager.getDefault(RouteManagerXml.class).setDirty(true);
        this.firePropertyChange(p, old, n);
    }

    @Override
    public void initialize() {
        InstanceManager.getDefault(OperationsSetupXml.class);
        InstanceManager.getDefault(RouteManagerXml.class);
    }
}

