/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.operations.routes;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import javax.swing.JComboBox;
import jmri.InstanceManager;
import jmri.beans.PropertyChangeSupport;
import jmri.jmrit.operations.locations.Location;
import jmri.jmrit.operations.routes.Bundle;
import jmri.jmrit.operations.routes.RouteLocation;
import jmri.jmrit.operations.routes.RouteManagerXml;
import jmri.jmrit.operations.setup.Setup;
import jmri.jmrit.operations.trains.Train;
import jmri.jmrit.operations.trains.TrainManager;
import org.jdom2.Attribute;
import org.jdom2.Content;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Route
extends PropertyChangeSupport
implements PropertyChangeListener {
    public static final String NONE = "";
    protected String _id = "";
    protected String _name = "";
    protected String _comment = "";
    protected Hashtable<String, RouteLocation> _routeHashTable = new Hashtable();
    protected int _IdNumber = 0;
    protected int _sequenceNum = 0;
    public static final int EAST = 1;
    public static final int WEST = 2;
    public static final int NORTH = 4;
    public static final int SOUTH = 8;
    public static final String LISTCHANGE_CHANGED_PROPERTY = "routeListChange";
    public static final String ROUTE_STATUS_CHANGED_PROPERTY = "routeStatusChange";
    public static final String ROUTE_BLOCKING_CHANGED_PROPERTY = "routeBlockingChange";
    public static final String DISPOSE = "routeDispose";
    public static final String OKAY = Bundle.getMessage("ButtonOK");
    public static final String TRAIN_BUILT = Bundle.getMessage("TrainBuilt");
    public static final String ORPHAN = Bundle.getMessage("Orphan");
    public static final String ERROR = Bundle.getMessage("ErrorTitle");
    public static final int START = 1;
    private static final Logger log = LoggerFactory.getLogger(Route.class);

    public Route(String id, String name) {
        log.debug("New route ({}) id: {}", (Object)name, (Object)id);
        this._name = name;
        this._id = id;
    }

    public String getId() {
        return this._id;
    }

    public void setName(String name) {
        String old = this._name;
        this._name = name;
        if (!old.equals(name)) {
            this.setDirtyAndFirePropertyChange("nameChange", old, name);
        }
    }

    public String toString() {
        return this._name;
    }

    public String getName() {
        return this._name;
    }

    public void setComment(String comment) {
        String old = this._comment;
        this._comment = comment;
        if (!old.equals(comment)) {
            this.setDirtyAndFirePropertyChange("commentChange", old, comment);
        }
    }

    public String getComment() {
        return this._comment;
    }

    public void dispose() {
        this.removeTrainListeners();
        this.setDirtyAndFirePropertyChange(DISPOSE, null, DISPOSE);
    }

    public RouteLocation addLocation(Location location) {
        ++this._IdNumber;
        ++this._sequenceNum;
        String id = String.valueOf(this._id) + "r" + Integer.toString(this._IdNumber);
        log.debug("adding new location to ({}) id: {}", (Object)this.getName(), (Object)id);
        RouteLocation rl = new RouteLocation(id, location);
        rl.setSequenceNumber(this._sequenceNum);
        Integer old = this._routeHashTable.size();
        this._routeHashTable.put(rl.getId(), rl);
        this.resetBlockingOrder();
        this.setDirtyAndFirePropertyChange(LISTCHANGE_CHANGED_PROPERTY, old, this._routeHashTable.size());
        rl.addPropertyChangeListener(this);
        return rl;
    }

    public RouteLocation addLocation(Location location, int sequence) {
        RouteLocation rl = this.addLocation(location);
        if (sequence < 1 || sequence > this._routeHashTable.size()) {
            return rl;
        }
        int i = 0;
        while (i < this._routeHashTable.size() - sequence) {
            this.moveLocationUp(rl);
            ++i;
        }
        return rl;
    }

    public void register(RouteLocation rl) {
        Integer old = this._routeHashTable.size();
        this._routeHashTable.put(rl.getId(), rl);
        String[] getId = rl.getId().split("r");
        int id = Integer.parseInt(getId[1]);
        if (id > this._IdNumber) {
            this._IdNumber = id;
        }
        if (rl.getSequenceNumber() > this._sequenceNum) {
            this._sequenceNum = rl.getSequenceNumber();
        }
        this.setDirtyAndFirePropertyChange(LISTCHANGE_CHANGED_PROPERTY, old, this._routeHashTable.size());
        rl.addPropertyChangeListener(this);
    }

    public void deleteLocation(RouteLocation rl) {
        if (rl != null) {
            rl.removePropertyChangeListener(this);
            String id = rl.getId();
            rl.dispose();
            Integer old = this._routeHashTable.size();
            this._routeHashTable.remove(id);
            this.resequence();
            this.resetBlockingOrder();
            this.setDirtyAndFirePropertyChange(LISTCHANGE_CHANGED_PROPERTY, old, this._routeHashTable.size());
        }
    }

    public int size() {
        return this._routeHashTable.size();
    }

    private void resequence() {
        List<RouteLocation> routeList = this.getLocationsBySequenceList();
        int i = 0;
        while (i < routeList.size()) {
            this._sequenceNum = i + 1;
            routeList.get(i).setSequenceNumber(this._sequenceNum);
            ++i;
        }
    }

    public RouteLocation getDepartsRouteLocation() {
        List<RouteLocation> list = this.getLocationsBySequenceList();
        if (list.size() > 0) {
            return list.get(0);
        }
        return null;
    }

    public String getDepartureDirection() {
        if (this.getDepartsRouteLocation() != null) {
            return this.getDepartsRouteLocation().getTrainDirectionString();
        }
        return NONE;
    }

    public RouteLocation getTerminatesRouteLocation() {
        List<RouteLocation> list = this.getLocationsBySequenceList();
        if (list.size() > 0) {
            return list.get(list.size() - 1);
        }
        return null;
    }

    public RouteLocation getNextRouteLocation(RouteLocation rl) {
        List<RouteLocation> list = this.getLocationsBySequenceList();
        int i = 0;
        while (i < list.size() - 1) {
            if (rl == list.get(i)) {
                return list.get(i + 1);
            }
            ++i;
        }
        return null;
    }

    public RouteLocation getLastLocationByName(String name) {
        List<RouteLocation> routeList = this.getLocationsBySequenceList();
        int i = routeList.size() - 1;
        while (i >= 0) {
            RouteLocation rl = routeList.get(i);
            if (rl.getName().equals(name)) {
                return rl;
            }
            --i;
        }
        return null;
    }

    public RouteLocation getLocationById(String id) {
        return this._routeHashTable.get(id);
    }

    private List<RouteLocation> getLocationsByIdList() {
        ArrayList<RouteLocation> out = new ArrayList<RouteLocation>();
        Enumeration<RouteLocation> en = this._routeHashTable.elements();
        while (en.hasMoreElements()) {
            out.add(en.nextElement());
        }
        return out;
    }

    public List<RouteLocation> getLocationsBySequenceList() {
        ArrayList<RouteLocation> out = new ArrayList<RouteLocation>();
        for (RouteLocation rl : this.getLocationsByIdList()) {
            int j = 0;
            while (j < out.size()) {
                if (rl.getSequenceNumber() < ((RouteLocation)out.get(j)).getSequenceNumber()) {
                    out.add(j, rl);
                    break;
                }
                ++j;
            }
            if (out.contains(rl)) continue;
            out.add(rl);
        }
        return out;
    }

    public List<RouteLocation> getBlockingOrder() {
        ArrayList<RouteLocation> out = new ArrayList<RouteLocation>();
        for (RouteLocation rl : this.getLocationsBySequenceList()) {
            if (rl.getBlockingOrder() == 0) {
                rl.setBlockingOrder(out.size() + 1);
            }
            int j = 0;
            while (j < out.size()) {
                if (rl.getBlockingOrder() < ((RouteLocation)out.get(j)).getBlockingOrder()) {
                    out.add(j, rl);
                    break;
                }
                ++j;
            }
            if (out.contains(rl)) continue;
            out.add(rl);
        }
        return out;
    }

    public void setBlockingOrderUp(RouteLocation rl) {
        List<RouteLocation> blockingOrder = this.getBlockingOrder();
        int order = rl.getBlockingOrder();
        if (--order < 1) {
            order = this.size();
            for (RouteLocation rlx : blockingOrder) {
                rlx.setBlockingOrder(rlx.getBlockingOrder() - 1);
            }
        } else {
            RouteLocation rlx = blockingOrder.get(order - 1);
            rlx.setBlockingOrder(order + 1);
        }
        rl.setBlockingOrder(order);
        this.setDirtyAndFirePropertyChange(ROUTE_BLOCKING_CHANGED_PROPERTY, order + 1, order);
    }

    public void setBlockingOrderDown(RouteLocation rl) {
        List<RouteLocation> blockingOrder = this.getBlockingOrder();
        int order = rl.getBlockingOrder();
        if (++order > this.size()) {
            order = 1;
            for (RouteLocation rlx : blockingOrder) {
                rlx.setBlockingOrder(rlx.getBlockingOrder() + 1);
            }
        } else {
            RouteLocation rlx = blockingOrder.get(order - 1);
            rlx.setBlockingOrder(order - 1);
        }
        rl.setBlockingOrder(order);
        this.setDirtyAndFirePropertyChange(ROUTE_BLOCKING_CHANGED_PROPERTY, order - 1, order);
    }

    public void resetBlockingOrder() {
        for (RouteLocation rl : this.getLocationsByIdList()) {
            rl.setBlockingOrder(0);
        }
        this.setDirtyAndFirePropertyChange(ROUTE_BLOCKING_CHANGED_PROPERTY, "Order", "Reset");
    }

    public void moveLocationUp(RouteLocation rl) {
        int sequenceNum = rl.getSequenceNumber();
        if (sequenceNum - 1 <= 0) {
            rl.setSequenceNumber(this._sequenceNum + 1);
            this.resequence();
        } else {
            RouteLocation replaceRl = this.getRouteLocationBySequenceNumber(sequenceNum - 1);
            if (replaceRl != null) {
                replaceRl.setSequenceNumber(sequenceNum);
                rl.setSequenceNumber(sequenceNum - 1);
            } else {
                this.resequence();
            }
        }
        this.resetBlockingOrder();
        this.setDirtyAndFirePropertyChange(LISTCHANGE_CHANGED_PROPERTY, null, Integer.toString(sequenceNum));
    }

    public void moveLocationDown(RouteLocation rl) {
        int sequenceNum = rl.getSequenceNumber();
        if (sequenceNum + 1 > this._sequenceNum) {
            rl.setSequenceNumber(0);
            this.resequence();
        } else {
            RouteLocation replaceRl = this.getRouteLocationBySequenceNumber(sequenceNum + 1);
            if (replaceRl != null) {
                replaceRl.setSequenceNumber(sequenceNum);
                rl.setSequenceNumber(sequenceNum + 1);
            } else {
                this.resequence();
            }
        }
        this.resetBlockingOrder();
        this.setDirtyAndFirePropertyChange(LISTCHANGE_CHANGED_PROPERTY, null, Integer.toString(sequenceNum));
    }

    public RouteLocation getRouteLocationBySequenceNumber(int sequence) {
        for (RouteLocation rl : this.getLocationsByIdList()) {
            if (rl.getSequenceNumber() != sequence) continue;
            return rl;
        }
        return null;
    }

    public String getStatus() {
        this.removeTrainListeners();
        this.addTrainListeners();
        List<RouteLocation> routeList = this.getLocationsByIdList();
        if (routeList.size() == 0) {
            return ERROR;
        }
        List<String> directions = Setup.getTrainDirectionList();
        for (RouteLocation rl : routeList) {
            if (rl.getName().equals(RouteLocation.DELETED)) {
                return ERROR;
            }
            if (directions.contains(rl.getTrainDirectionString())) continue;
            return ERROR;
        }
        for (Train train : InstanceManager.getDefault(TrainManager.class).getTrainsByIdList()) {
            if (train.getRoute() != this || !train.isBuilt()) continue;
            return TRAIN_BUILT;
        }
        for (Train train : InstanceManager.getDefault(TrainManager.class).getTrainsByIdList()) {
            if (train.getRoute() != this) continue;
            return OKAY;
        }
        return ORPHAN;
    }

    private void addTrainListeners() {
        for (Train train : InstanceManager.getDefault(TrainManager.class).getTrainsByIdList()) {
            if (train.getRoute() != this) continue;
            train.addPropertyChangeListener(this);
        }
    }

    private void removeTrainListeners() {
        for (Train train : InstanceManager.getDefault(TrainManager.class).getTrainsByIdList()) {
            train.removePropertyChangeListener(this);
        }
    }

    public int getRouteMinimumTrainLength() {
        int min = this.getRouteMaximumTrainLength();
        for (RouteLocation rl : this.getLocationsByIdList()) {
            if (rl.getMaxTrainLength() >= min) continue;
            min = rl.getMaxTrainLength();
        }
        return min;
    }

    public int getRouteMaximumTrainLength() {
        int max = 0;
        for (RouteLocation rl : this.getLocationsByIdList()) {
            if (rl.getMaxTrainLength() <= max) continue;
            max = rl.getMaxTrainLength();
        }
        return max;
    }

    public JComboBox<RouteLocation> getComboBox() {
        JComboBox<RouteLocation> box = new JComboBox<RouteLocation>();
        for (RouteLocation rl : this.getLocationsBySequenceList()) {
            box.addItem(rl);
        }
        return box;
    }

    public void updateComboBox(JComboBox<RouteLocation> box) {
        box.removeAllItems();
        box.addItem(null);
        for (RouteLocation rl : this.getLocationsBySequenceList()) {
            box.addItem(rl);
        }
    }

    public Route(Element e) {
        Attribute a = e.getAttribute("id");
        if (a != null) {
            this._id = a.getValue();
        } else {
            log.warn("no id attribute in route element when reading operations");
        }
        a = e.getAttribute("name");
        if (a != null) {
            this._name = a.getValue();
        }
        if ((a = e.getAttribute("comment")) != null) {
            this._comment = a.getValue();
        }
        if (e.getChildren("location") != null) {
            List eRouteLocations = e.getChildren("location");
            log.debug("route: ({}) has {} locations", (Object)this.getName(), (Object)eRouteLocations.size());
            for (Element eRouteLocation : eRouteLocations) {
                this.register(new RouteLocation(eRouteLocation));
            }
        }
    }

    public Element store() {
        Element e = new Element("route");
        e.setAttribute("id", this.getId());
        e.setAttribute("name", this.getName());
        e.setAttribute("comment", this.getComment());
        for (RouteLocation rl : this.getLocationsBySequenceList()) {
            e.addContent((Content)rl.store());
        }
        return e;
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        if (e.getPropertyName().equals("dropChange") || e.getPropertyName().equals("pickupChange") || e.getPropertyName().equals("trainDirectionChange") || e.getPropertyName().equals("maxMovesChange") || e.getPropertyName().equals("maxLengthChange")) {
            this.setDirtyAndFirePropertyChange(LISTCHANGE_CHANGED_PROPERTY, null, "RouteLocation");
        }
        if (e.getPropertyName().equals("TrainBuilt")) {
            this.firePropertyChange(ROUTE_STATUS_CHANGED_PROPERTY, true, false);
        }
    }

    protected void setDirtyAndFirePropertyChange(String p, Object old, Object n) {
        InstanceManager.getDefault(RouteManagerXml.class).setDirty(true);
        this.firePropertyChange(p, old, n);
    }
}

