/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.operations.router;

import java.io.PrintWriter;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import jmri.InstanceManager;
import jmri.InstanceManagerAutoDefault;
import jmri.jmrit.operations.locations.Location;
import jmri.jmrit.operations.locations.LocationManager;
import jmri.jmrit.operations.locations.Track;
import jmri.jmrit.operations.rollingstock.RollingStock;
import jmri.jmrit.operations.rollingstock.cars.Car;
import jmri.jmrit.operations.router.Bundle;
import jmri.jmrit.operations.setup.Setup;
import jmri.jmrit.operations.trains.Train;
import jmri.jmrit.operations.trains.TrainCommon;
import jmri.jmrit.operations.trains.TrainManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Router
extends TrainCommon
implements InstanceManagerAutoDefault {
    TrainManager tmanager = InstanceManager.getDefault(TrainManager.class);
    private final List<Track> _nextLocationTracks = new ArrayList<Track>();
    private final List<Track> _lastLocationTracks = new ArrayList<Track>();
    private final List<Track> _otherLocationTracks = new ArrayList<Track>();
    private final List<Train> _nextLocationTrains = new ArrayList<Train>();
    private final List<Train> _lastLocationTrains = new ArrayList<Train>();
    protected static final String STATUS_NOT_THIS_TRAIN = Bundle.getMessage("RouterTrain");
    protected static final String STATUS_NOT_ABLE = Bundle.getMessage("RouterNotAble");
    protected static final String STATUS_ROUTER_DISABLED = Bundle.getMessage("RouterDisabled");
    private String _status = "";
    private Train _train = null;
    PrintWriter _buildReport = null;
    private static final boolean debugFlag = false;
    private static final String SEVEN = "7";
    private boolean _addtoReport = false;
    private boolean _addtoReportVeryDetailed = false;
    private static final String NO = "no";
    private static final String YES = "yes";
    private static final String NOT_NOW = "not now";
    private static final String NO_SPECIFIED_TRAIN = "no specified train";
    private static final Logger log = LoggerFactory.getLogger(Router.class);

    public String getStatus() {
        return this._status;
    }

    public boolean isCarRouteable(Car car, Train train, Track track, PrintWriter buildReport) {
        Router.addLine(buildReport, SEVEN, MessageFormat.format(Bundle.getMessage("RouterIsCarRoutable"), car.toString(), car.getLocationName(), car.getTrackName(), car.getLoadName(), track.getLocation().getName(), track.getName()));
        Car c = car.copy();
        c.setTrack(car.getTrack());
        c.setFinalDestination(track.getLocation());
        c.setFinalDestinationTrack(track);
        boolean results = this.setDestination(c, train, buildReport);
        c.setDestination(null, null);
        c.setFinalDestinationTrack(null);
        return results;
    }

    public boolean setDestination(Car car, Train train, PrintWriter buildReport) {
        if (car.getTrack() == null || car.getFinalDestination() == null) {
            return false;
        }
        this._status = Track.OKAY;
        this._train = train;
        this._buildReport = buildReport;
        this._addtoReport = Setup.getRouterBuildReportLevel().equals("5") || Setup.getRouterBuildReportLevel().equals(SEVEN);
        this._addtoReportVeryDetailed = Setup.getRouterBuildReportLevel().equals(SEVEN);
        log.debug("Car ({}) at location ({}, {}) final destination ({}, {}) car routing begins", new Object[]{car, car.getLocationName(), car.getTrackName(), car.getFinalDestinationName(), car.getFinalDestinationTrackName()});
        if (this._train != null) {
            log.debug("Routing using train ({})", (Object)train.getName());
        }
        if (car.getKernel() != null && !car.isLead()) {
            return false;
        }
        Car clone = this.clone(car);
        this._status = clone.testDestination(clone.getDestination(), clone.getDestinationTrack());
        if (!this._status.equals(Track.OKAY)) {
            Router.addLine(this._buildReport, SEVEN, MessageFormat.format(Bundle.getMessage("RouterCanNotDeliverCar"), car.toString(), car.getFinalDestinationName(), car.getFinalDestinationTrackName(), this._status, car.getFinalDestinationTrack() == null ? Bundle.getMessage("RouterDestination") : car.getFinalDestinationTrack().getTrackTypeName()));
            return false;
        }
        if (clone.getDestination() != null && clone.getDestinationTrack() == null) {
            String status = "";
            for (Track track : clone.getDestination().getTracksList()) {
                status = track.isRollingStockAccepted(clone);
                if (!status.equals(Track.OKAY) && !status.startsWith(Track.LENGTH)) continue;
                log.debug("Track ({}) will accept car ({})", (Object)track.getName(), (Object)car);
                break;
            }
            if (!status.equals(Track.OKAY) && !status.startsWith(Track.LENGTH)) {
                this._status = MessageFormat.format(Bundle.getMessage("RouterNoTracks"), clone.getDestinationName(), car.toString());
                Router.addLine(this._buildReport, SEVEN, this._status);
                return false;
            }
        }
        if (this.checkForSingleTrain(car, clone)) {
            return true;
        }
        if (!Setup.isCarRoutingEnabled()) {
            log.debug("Car ({}) final destination ({}) is not served directly by any train", (Object)car, (Object)car.getFinalDestinationName());
            this._status = STATUS_ROUTER_DISABLED;
            car.setFinalDestination(null);
            car.setFinalDestinationTrack(null);
            return false;
        }
        log.debug("Car ({}) final destination ({}) is not served by a single train", (Object)car, (Object)car.getFinalDestinationName());
        if (car.getLocationName().equals(car.getFinalDestinationName())) {
            Router.addLine(this._buildReport, SEVEN, MessageFormat.format(Bundle.getMessage("RouterCouldNotFindTrain"), car.getLocationName(), car.getTrackName(), car.getFinalDestinationName(), car.getFinalDestinationTrackName()));
        }
        if (this._addtoReport) {
            Router.addLine(this._buildReport, SEVEN, " ");
            Router.addLine(this._buildReport, SEVEN, MessageFormat.format(Bundle.getMessage("RouterBeginTwoTrain"), car.toString(), car.getLocationName(), car.getFinalDestinationName()));
        }
        this._nextLocationTracks.clear();
        this._lastLocationTracks.clear();
        this._otherLocationTracks.clear();
        this._nextLocationTrains.clear();
        this._lastLocationTrains.clear();
        if (this.setCarDestinationTwoTrainsInterchange(car)) {
            if (car.getDestination() == null) {
                log.debug("Was able to find a route via classification/interchange track, but not using train ({}) or car destination not set, try again using yard tracks", (Object)this._train.getName());
                if (this.setCarDestinationTwoTrainsYard(car)) {
                    log.debug("Was able to find route via yard ({}, {}) for car ({})", new Object[]{car.getDestinationName(), car.getDestinationTrackName(), car});
                }
            } else {
                log.debug("Was able to find route via interchange ({}, {}) for car ({})", new Object[]{car.getDestinationName(), car.getDestinationTrackName(), car});
            }
        } else if (this.setCarDestinationTwoTrainsYard(car)) {
            log.debug("Was able to find route via yard ({}, {}) for car ({}) using two trains", new Object[]{car.getDestinationName(), car.getDestinationTrackName(), car});
        } else if (this.setCarDestinationMultipleTrains(car, false)) {
            log.debug("Was able to find multiple train route for car ({})", (Object)car);
        } else if (this.setCarDestinationTwoTrainsStaging(car)) {
            log.debug("Was able to find route via staging ({}, {}) for car ({}) using two trains", new Object[]{car.getDestinationName(), car.getDestinationTrackName(), car});
        } else if (this.setCarDestinationMultipleTrains(car, true)) {
            log.debug("Was able to find multiple train route for car ({}) through staging", (Object)car);
        } else {
            log.debug("Wasn't able to set route for car ({})", (Object)car);
            this._status = STATUS_NOT_ABLE;
            return false;
        }
        return true;
    }

    private boolean checkForSingleTrain(Car car, Car clone) {
        boolean trainServicesCar = false;
        Train testTrain = null;
        if (this._train != null) {
            trainServicesCar = this._train.isServiceable(this._buildReport, clone);
        }
        if (trainServicesCar) {
            testTrain = this._train;
            log.debug("Train ({}) can service car ({})", (Object)this._train.getName(), (Object)car.toString());
        } else if (!(car.getTrack().isStaging() || this._train == null || this._train.isServiceAllCarsWithFinalDestinationsEnabled() || this._train.getServiceStatus().equals(""))) {
            Router.addLine(this._buildReport, SEVEN, MessageFormat.format(Bundle.getMessage("RouterTrainCanNotDueTo"), this._train.getName(), car.toString(), car.getFinalDestinationName(), car.getFinalDestinationTrackName(), this._train.getServiceStatus()));
            return true;
        }
        if (car.getTrack().isStaging() && this._train != null && !trainServicesCar) {
            Router.addLine(this._buildReport, SEVEN, MessageFormat.format(Bundle.getMessage("RouterTrainCanNotStaging"), this._train.getName(), car.toString(), car.getLocationName(), clone.getDestinationName(), clone.getDestinationTrackName()));
            if (!this._train.getServiceStatus().equals("")) {
                Router.addLine(this._buildReport, SEVEN, this._train.getServiceStatus());
            }
        } else if (!trainServicesCar) {
            testTrain = this.tmanager.getTrainForCar(clone, this._train, this._buildReport);
        }
        if (testTrain != null && this._train != null && !trainServicesCar && this._train.isServiceAllCarsWithFinalDestinationsEnabled()) {
            Router.addLine(this._buildReport, SEVEN, MessageFormat.format(Bundle.getMessage("RouterOptionToCarry"), this._train.getName(), testTrain.getName(), car.toString(), clone.getDestinationName(), clone.getDestinationTrackName()));
            testTrain = null;
        }
        if (testTrain != null) {
            return this.routeUsingOneTrain(testTrain, car, clone);
        }
        return false;
    }

    private boolean routeUsingOneTrain(Train testTrain, Car car, Car clone) {
        Router.addLine(this._buildReport, SEVEN, MessageFormat.format(Bundle.getMessage("RouterTrainCanTransport"), testTrain.getName(), car.toString(), car.getTrack().getTrackTypeName(), car.getLocationName(), car.getTrackName(), clone.getDestinationName(), clone.getDestinationTrackName()));
        this.showRoute(car, new ArrayList<Train>(Arrays.asList(testTrain)), new ArrayList<Track>());
        if (this._train != null && this._train != testTrain) {
            Router.addLine(this._buildReport, SEVEN, MessageFormat.format(Bundle.getMessage("TrainDoesNotServiceCar"), this._train.getName(), car.toString(), clone.getDestinationName(), clone.getDestinationTrackName()));
            if (!this._train.getServiceStatus().equals("")) {
                Router.addLine(this._buildReport, SEVEN, this._train.getServiceStatus());
            }
            this._status = MessageFormat.format(STATUS_NOT_THIS_TRAIN, testTrain.getName());
            return true;
        }
        this._status = car.setDestination(clone.getDestination(), clone.getDestinationTrack());
        if (this._status.equals(Track.OKAY)) {
            return true;
        }
        Router.addLine(this._buildReport, SEVEN, MessageFormat.format(Bundle.getMessage("RouterCanNotDeliverCar"), car.toString(), clone.getDestinationName(), clone.getDestinationTrackName(), this._status, clone.getDestinationTrack() == null ? Bundle.getMessage("RouterDestination") : clone.getDestinationTrack().getTrackTypeName()));
        if ((this._status.startsWith(Track.LENGTH) || this._status.startsWith(Track.SCHEDULE)) && clone.getDestinationTrack() != null && clone.getDestinationTrack().getAlternateTrack() != null && clone.getDestinationTrack().getAlternateTrack() != car.getTrack()) {
            String status = car.setDestination(clone.getDestination(), clone.getDestinationTrack().getAlternateTrack());
            if (status.equals(Track.OKAY)) {
                if (this._train == null || this._train.isServiceable(car)) {
                    Router.addLine(this._buildReport, SEVEN, MessageFormat.format(Bundle.getMessage("RouterSendCarToAlternative"), car.toString(), clone.getDestinationTrack().getAlternateTrack().getName(), clone.getDestination().getName()));
                    return true;
                }
                Router.addLine(this._buildReport, SEVEN, MessageFormat.format(Bundle.getMessage("RouterNotSendCarToAlternative"), this._train.getName(), car.toString(), clone.getDestinationTrack().getAlternateTrack().getName(), clone.getDestination().getName()));
            } else {
                Router.addLine(this._buildReport, SEVEN, MessageFormat.format(Bundle.getMessage("RouterAlternateFailed"), clone.getDestinationTrack().getAlternateTrack().getName(), status));
            }
        } else if (clone.getDestinationTrack() != null && clone.getDestinationTrack().getAlternateTrack() != null && clone.getDestinationTrack().getAlternateTrack() == car.getTrack()) {
            Router.addLine(this._buildReport, SEVEN, MessageFormat.format(Bundle.getMessage("RouterAtAlternate"), car.toString(), clone.getDestinationTrack().getAlternateTrack().getName(), clone.getLocationName(), clone.getDestinationTrackName()));
        } else if (car.getLocation() == clone.getDestination()) {
            Router.addLine(this._buildReport, SEVEN, MessageFormat.format(Bundle.getMessage("RouterIgnoreAlternate"), car.toString(), car.getLocationName()));
        }
        if (Setup.isForwardToYardEnabled() && this._status.startsWith(Track.LENGTH) && car.getLocation() != clone.getDestination()) {
            Router.addLine(this._buildReport, SEVEN, MessageFormat.format(Bundle.getMessage("RouterSpurFull"), clone.getDestinationTrackName(), clone.getDestinationName()));
            Location dest = clone.getDestination();
            List<Track> yards = dest.getTracksByMovesList("Yard");
            log.debug("Found {} yard(s) at destination ({})", (Object)yards.size(), (Object)clone.getDestinationName());
            for (Track track : yards) {
                String status = car.setDestination(dest, track);
                if (status.equals(Track.OKAY)) {
                    if (this._train != null && !this._train.isServiceable(car)) {
                        log.debug("Train ({}) can not deliver car ({}) to yard ({})", new Object[]{this._train.getName(), car, track.getName()});
                        continue;
                    }
                    Router.addLine(this._buildReport, SEVEN, MessageFormat.format(Bundle.getMessage("RouterSendCarToYard"), car.toString(), track.getName(), dest.getName()));
                    return true;
                }
                Router.addLine(this._buildReport, SEVEN, MessageFormat.format(Bundle.getMessage("RouterCanNotUseYard"), track.getName(), status));
            }
            Router.addLine(this._buildReport, SEVEN, MessageFormat.format(Bundle.getMessage("RouterNoYardTracks"), dest.getName(), car.toString()));
        }
        car.setDestination(null, null);
        if (car.getTrack().isStaging()) {
            log.debug("Car ({}) departing staging, single train can't deliver car to ({}, {})", new Object[]{car, clone.getDestinationName(), clone.getDestinationTrackName()});
            return false;
        }
        return true;
    }

    private boolean setCarDestinationTwoTrainsInterchange(Car car) {
        return this.setCarDestinationTwoTrains(car, "Interchange");
    }

    private boolean setCarDestinationTwoTrainsYard(Car car) {
        if (Setup.isCarRoutingViaYardsEnabled()) {
            return this.setCarDestinationTwoTrains(car, "Yard");
        }
        return false;
    }

    private boolean setCarDestinationTwoTrainsStaging(Car car) {
        if (Setup.isCarRoutingViaStagingEnabled()) {
            Router.addLine(this._buildReport, SEVEN, MessageFormat.format(Bundle.getMessage("RouterAttemptStaging"), car.toString()));
            return this.setCarDestinationTwoTrains(car, "Staging");
        }
        return false;
    }

    private boolean setCarDestinationTwoTrains(Car car, String trackType) {
        Car testCar = this.clone(car);
        log.debug("Two train routing, find {} track for car ({}) final destination ({}, {})", new Object[]{trackType, car, testCar.getDestinationName(), testCar.getDestinationTrackName()});
        if (this._addtoReport) {
            Router.addLine(this._buildReport, SEVEN, " ");
            Router.addLine(this._buildReport, SEVEN, MessageFormat.format(Bundle.getMessage("RouterFindTrack"), Track.getTrackTypeName(trackType), car.toString(), testCar.getDestinationName(), testCar.getDestinationTrackName()));
        }
        boolean foundRoute = false;
        List<Track> tracks = InstanceManager.getDefault(LocationManager.class).getTracksByMoves(trackType);
        for (Track track : tracks) {
            if (car.getTrack() == track) continue;
            String status = track.isRollingStockAccepted(testCar);
            if (!status.equals(Track.OKAY) && !status.startsWith(Track.LENGTH)) {
                if (!this._addtoReportVeryDetailed) continue;
                Router.addLine(this._buildReport, SEVEN, " ");
                Router.addLine(this._buildReport, SEVEN, MessageFormat.format(Bundle.getMessage("RouterCanNotDeliverCar"), car.toString(), track.getLocation().getName(), track.getName(), status, track.getTrackTypeName()));
                continue;
            }
            if (this._addtoReport) {
                Router.addLine(this._buildReport, SEVEN, " ");
                Router.addLine(this._buildReport, SEVEN, MessageFormat.format(Bundle.getMessage("RouterFoundTrack"), Track.getTrackTypeName(trackType), track.getLocation().getName(), track.getName(), car.toString()));
            }
            testCar.setTrack(track);
            testCar.setDestination(car.getFinalDestination());
            testCar.setDestinationTrack(car.getFinalDestinationTrack());
            Train secondTrain = this.tmanager.getTrainForCar(testCar, this._buildReport);
            if (secondTrain == null) {
                if (!this._addtoReport) continue;
                Router.addLine(this._buildReport, SEVEN, MessageFormat.format(Bundle.getMessage("RouterNotFindTrain"), Track.getTrackTypeName(trackType), track.getLocation().getName(), track.getName(), testCar.getDestinationName(), testCar.getDestinationTrackName()));
                continue;
            }
            if (this._addtoReport) {
                Router.addLine(this._buildReport, SEVEN, MessageFormat.format(Bundle.getMessage("RouterTrainCanTransport"), secondTrain.getName(), car.toString(), Track.getTrackTypeName(trackType), testCar.getLocationName(), testCar.getTrackName(), testCar.getDestinationName(), testCar.getDestinationTrackName()));
            }
            this._lastLocationTracks.add(track);
            this._lastLocationTrains.add(secondTrain);
            testCar.setTrack(car.getTrack());
            testCar.setDestination(track.getLocation());
            testCar.setDestinationTrack(track);
            Train firstTrain = null;
            String specified = this.canSpecifiedTrainService(testCar);
            if (specified.equals(YES)) {
                firstTrain = this._train;
            } else if (specified.equals(NOT_NOW)) {
                Router.addLine(this._buildReport, SEVEN, MessageFormat.format(Bundle.getMessage("RouterTrainCanNotDueTo"), this._train.getName(), car.toString(), track.getLocation().getName(), track.getName(), this._train.getServiceStatus()));
                foundRoute = true;
            } else {
                firstTrain = this.tmanager.getTrainForCar(testCar, this._buildReport);
            }
            if (firstTrain == null && this._addtoReport) {
                Router.addLine(this._buildReport, SEVEN, MessageFormat.format(Bundle.getMessage("RouterNotFindTrain"), testCar.getTrack().getTrackTypeName(), testCar.getTrack().getLocation().getName(), testCar.getTrack().getName(), testCar.getDestinationName(), testCar.getDestinationTrackName()));
            }
            if (this._train != null && car.getTrack().isStaging() && !specified.equals(YES)) {
                if (!this._addtoReport) continue;
                Router.addLine(this._buildReport, SEVEN, MessageFormat.format(Bundle.getMessage("RouterTrainCanNot"), this._train.getName(), car.toString(), car.getLocationName(), car.getTrackName(), track.getLocation().getName(), track.getName()));
                continue;
            }
            if (firstTrain != null && this._train != null && this._train.isServiceAllCarsWithFinalDestinationsEnabled() && !specified.equals(YES)) {
                if (!this._addtoReport) continue;
                Router.addLine(this._buildReport, SEVEN, MessageFormat.format(Bundle.getMessage("RouterOptionToCarry"), this._train.getName(), firstTrain.getName(), car.toString(), track.getLocation().getName(), track.getName()));
                continue;
            }
            if (firstTrain == null) continue;
            foundRoute = true;
            ArrayList<Train> trains = new ArrayList<Train>(Arrays.asList(firstTrain, secondTrain));
            tracks = new ArrayList<Track>(Arrays.asList(track));
            this.showRoute(car, trains, tracks);
            this._status = car.testDestination(track.getLocation(), track);
            if (this._status.startsWith(Track.LENGTH)) {
                Router.addLine(this._buildReport, SEVEN, MessageFormat.format(Bundle.getMessage("RouterCanNotDeliverCar"), car.toString(), track.getLocation().getName(), track.getName(), this._status, track.getTrackTypeName()));
                continue;
            }
            if (!this._status.equals(Track.OKAY)) continue;
            if (this._train != null && this._train != firstTrain) {
                Router.addLine(this._buildReport, SEVEN, MessageFormat.format(Bundle.getMessage("TrainDoesNotServiceCar"), this._train.getName(), car.toString(), testCar.getDestinationName(), testCar.getDestinationTrackName()));
                this._status = MessageFormat.format(STATUS_NOT_THIS_TRAIN, firstTrain.getName());
                continue;
            }
            if (track.isStaging() && firstTrain.getTerminationTrack() != null && firstTrain.getTerminationTrack() != track) {
                Router.addLine(this._buildReport, SEVEN, MessageFormat.format(Bundle.getMessage("RouterTrainIntoStaging"), firstTrain.getName(), firstTrain.getTerminationTrack().getLocation().getName(), firstTrain.getTerminationTrack().getName()));
                continue;
            }
            this._status = car.setDestination(track.getLocation(), track);
            if (this._addtoReport) {
                Router.addLine(this._buildReport, SEVEN, MessageFormat.format(Bundle.getMessage("RouterTrainCanService"), firstTrain.getName(), car.toString(), car.getLocationName(), car.getTrackName(), Track.getTrackTypeName(trackType), track.getLocation().getName(), track.getName()));
            }
            return true;
        }
        if (foundRoute) {
            this._status = this._train != null ? MessageFormat.format(STATUS_NOT_THIS_TRAIN, this._train.getName()) : STATUS_NOT_ABLE;
        }
        return foundRoute;
    }

    private boolean setCarDestinationMultipleTrains(Car car, boolean useStaging) {
        boolean foundRoute;
        List<Track> tracks;
        if (useStaging && !Setup.isCarRoutingViaStagingEnabled()) {
            return false;
        }
        if (this._addtoReport) {
            Router.addLine(this._buildReport, SEVEN, " ");
        }
        if (this._lastLocationTracks.isEmpty()) {
            if (useStaging) {
                Router.addLine(this._buildReport, SEVEN, MessageFormat.format(Bundle.getMessage("RouterCouldNotFindStaging"), car.getFinalDestinationName()));
            } else {
                Router.addLine(this._buildReport, SEVEN, MessageFormat.format(Bundle.getMessage("RouterCouldNotFind"), car.getFinalDestinationName()));
            }
            return false;
        }
        Car testCar = this.clone(car);
        if (!useStaging) {
            tracks = InstanceManager.getDefault(LocationManager.class).getTracksByMoves("Interchange");
            this.loadTracks(car, testCar, tracks);
        }
        if (!useStaging && Setup.isCarRoutingViaYardsEnabled()) {
            tracks = InstanceManager.getDefault(LocationManager.class).getTracksByMoves("Yard");
            this.loadTracks(car, testCar, tracks);
        }
        if (useStaging) {
            tracks = InstanceManager.getDefault(LocationManager.class).getTracksByMoves("Staging");
            this.loadTracks(car, testCar, tracks);
        }
        if (this._nextLocationTracks.isEmpty()) {
            Router.addLine(this._buildReport, SEVEN, MessageFormat.format(Bundle.getMessage("RouterCouldNotFindLoc"), car.getLocationName()));
            return false;
        }
        if (log.isDebugEnabled()) {
            for (Track t : this._nextLocationTracks) {
                log.debug("Next location ({}, {}) can service car ({}) using train ({})", new Object[]{t.getLocation().getName(), t.getName(), car, this._nextLocationTrains.get(this._nextLocationTracks.indexOf(t))});
            }
            for (Track t : this._lastLocationTracks) {
                log.debug("Last location ({}, {}) can service car ({}) using train ({})", new Object[]{t.getLocation().getName(), t.getName(), car, this._lastLocationTrains.get(this._lastLocationTracks.indexOf(t))});
            }
            for (Track t : this._otherLocationTracks) {
                log.debug("Other location ({}, {}) may be needed to service car ({})", new Object[]{t.getLocation().getName(), t.getName(), car});
            }
            log.debug("Try to find route using 3 trains");
        }
        if (!(foundRoute = this.routeUsing3Trains(car))) {
            log.debug("Using 3 trains to route car to ({}) was unsuccessful", (Object)car.getFinalDestinationName());
            foundRoute = this.routeUsing4Trains(car);
        }
        if (!foundRoute) {
            log.debug("Using 4 trains to route car to ({}) was unsuccessful", (Object)car.getFinalDestinationName());
            foundRoute = this.routeUsing5Trains(car);
        }
        if (!foundRoute) {
            log.debug("Using 5 trains to route car to ({}) was unsuccessful", (Object)car.getFinalDestinationName());
            foundRoute = this.routeUsing6Trains(car);
        }
        return foundRoute;
    }

    private boolean routeUsing3Trains(Car car) {
        Router.addLine(this._buildReport, SEVEN, MessageFormat.format(Bundle.getMessage("RouterNTrains"), "3", car.getFinalDestinationName(), car.getFinalDestinationTrackName()));
        Car testCar = this.clone(car);
        boolean foundRoute = false;
        block0: for (Track nlt : this._nextLocationTracks) {
            for (Track llt : this._lastLocationTracks) {
                Train middleTrain = this.getTrainForCar(testCar, nlt, llt);
                if (middleTrain == null) continue;
                log.debug("Found 3 train route, setting car destination ({}, {})", (Object)nlt.getLocation().getName(), (Object)nlt.getName());
                foundRoute = true;
                ArrayList<Train> trains = new ArrayList<Train>(Arrays.asList(this._nextLocationTrains.get(this._nextLocationTracks.indexOf(nlt)), middleTrain, this._lastLocationTrains.get(this._lastLocationTracks.indexOf(llt))));
                ArrayList<Track> tracks = new ArrayList<Track>(Arrays.asList(nlt, llt));
                this.showRoute(car, trains, tracks);
                if (!this.finshSettingRouteFor(car, nlt)) continue block0;
                return true;
            }
        }
        return foundRoute;
    }

    private boolean routeUsing4Trains(Car car) {
        Router.addLine(this._buildReport, SEVEN, MessageFormat.format(Bundle.getMessage("RouterNTrains"), "4", car.getFinalDestinationName(), car.getFinalDestinationTrackName()));
        Car testCar = this.clone(car);
        boolean foundRoute = false;
        block0: for (Track nlt : this._nextLocationTracks) {
            for (Track mlt : this._otherLocationTracks) {
                Train middleTrain2 = this.getTrainForCar(testCar, nlt, mlt);
                if (middleTrain2 == null) continue;
                for (Track llt : this._lastLocationTracks) {
                    Train middleTrain3 = this.getTrainForCar(testCar, mlt, llt);
                    if (middleTrain3 == null) continue;
                    log.debug("Found 4 train route, setting car destination ({}, {})", (Object)nlt.getLocation().getName(), (Object)nlt.getName());
                    foundRoute = true;
                    ArrayList<Train> trains = new ArrayList<Train>(Arrays.asList(this._nextLocationTrains.get(this._nextLocationTracks.indexOf(nlt)), middleTrain2, middleTrain3, this._lastLocationTrains.get(this._lastLocationTracks.indexOf(llt))));
                    ArrayList<Track> tracks = new ArrayList<Track>(Arrays.asList(nlt, mlt, llt));
                    this.showRoute(car, trains, tracks);
                    if (!this.finshSettingRouteFor(car, nlt)) continue block0;
                    return true;
                }
            }
        }
        return foundRoute;
    }

    private boolean routeUsing5Trains(Car car) {
        Router.addLine(this._buildReport, SEVEN, MessageFormat.format(Bundle.getMessage("RouterNTrains"), "5", car.getFinalDestinationName(), car.getFinalDestinationTrackName()));
        Car testCar = this.clone(car);
        boolean foundRoute = false;
        block0: for (Track nlt : this._nextLocationTracks) {
            for (Track mlt1 : this._otherLocationTracks) {
                Train middleTrain2 = this.getTrainForCar(testCar, nlt, mlt1);
                if (middleTrain2 == null) continue;
                for (Track mlt2 : this._otherLocationTracks) {
                    Train middleTrain3;
                    if (mlt2 == mlt1 || (middleTrain3 = this.getTrainForCar(testCar, mlt1, mlt2)) == null) continue;
                    for (Track llt : this._lastLocationTracks) {
                        Train middleTrain4 = this.getTrainForCar(testCar, mlt2, llt);
                        if (middleTrain4 == null) continue;
                        log.debug("Found 5 train route, setting car destination ({}, {})", (Object)nlt.getLocation().getName(), (Object)nlt.getName());
                        foundRoute = true;
                        ArrayList<Train> trains = new ArrayList<Train>(Arrays.asList(this._nextLocationTrains.get(this._nextLocationTracks.indexOf(nlt)), middleTrain2, middleTrain3, middleTrain4, this._lastLocationTrains.get(this._lastLocationTracks.indexOf(llt))));
                        ArrayList<Track> tracks = new ArrayList<Track>(Arrays.asList(nlt, mlt1, mlt2, llt));
                        this.showRoute(car, trains, tracks);
                        if (!this.finshSettingRouteFor(car, nlt)) continue block0;
                        return true;
                    }
                }
            }
        }
        return foundRoute;
    }

    private boolean routeUsing6Trains(Car car) {
        Router.addLine(this._buildReport, SEVEN, MessageFormat.format(Bundle.getMessage("RouterNTrains"), "6", car.getFinalDestinationName(), car.getFinalDestinationTrackName()));
        Car testCar = this.clone(car);
        boolean foundRoute = false;
        block0: for (Track nlt : this._nextLocationTracks) {
            for (Track mlt1 : this._otherLocationTracks) {
                Train middleTrain2 = this.getTrainForCar(testCar, nlt, mlt1);
                if (middleTrain2 == null) continue;
                for (Track mlt2 : this._otherLocationTracks) {
                    Train middleTrain3;
                    if (mlt2 == mlt1 || (middleTrain3 = this.getTrainForCar(testCar, mlt1, mlt2)) == null) continue;
                    for (Track mlt3 : this._otherLocationTracks) {
                        Train middleTrain4;
                        if (mlt3 == mlt1 || mlt3 == mlt2 || (middleTrain4 = this.getTrainForCar(testCar, mlt2, mlt3)) == null) continue;
                        for (Track llt : this._lastLocationTracks) {
                            Train middleTrain5 = this.getTrainForCar(testCar, mlt3, llt);
                            if (middleTrain5 == null) continue;
                            log.debug("Found 6 train route, setting car destination ({}, {})", (Object)nlt.getLocation().getName(), (Object)nlt.getName());
                            foundRoute = true;
                            ArrayList<Train> trains = new ArrayList<Train>(Arrays.asList(this._nextLocationTrains.get(this._nextLocationTracks.indexOf(nlt)), middleTrain2, middleTrain3, middleTrain4, middleTrain5, this._lastLocationTrains.get(this._lastLocationTracks.indexOf(llt))));
                            ArrayList<Track> tracks = new ArrayList<Track>(Arrays.asList(nlt, mlt1, mlt2, mlt3, llt));
                            this.showRoute(car, trains, tracks);
                            if (!this.finshSettingRouteFor(car, nlt)) continue block0;
                            return true;
                        }
                    }
                }
            }
        }
        return foundRoute;
    }

    private Train getTrainForCar(Car testCar, Track from, Track to) {
        testCar.setTrack(from);
        testCar.setDestinationTrack(to);
        return this.tmanager.getTrainForCar(testCar, null);
    }

    private void showRoute(Car car, List<Train> trains, List<Track> tracks) {
        StringBuffer buf = new StringBuffer(MessageFormat.format(Bundle.getMessage("RouterRouteForCar"), car.toString(), car.getLocationName(), car.getTrackName()));
        for (Track track : tracks) {
            if (this._addtoReport) {
                buf.append(MessageFormat.format(Bundle.getMessage("RouterRouteTrain"), trains.get(tracks.indexOf(track)).getName()));
            }
            buf.append(MessageFormat.format(Bundle.getMessage("RouterRouteTrack"), track.getLocation().getName(), track.getName()));
        }
        if (this._addtoReport) {
            buf.append(MessageFormat.format(Bundle.getMessage("RouterRouteTrain"), trains.get(trains.size() - 1).getName()));
        }
        buf.append(MessageFormat.format(Bundle.getMessage("RouterRouteTrack"), car.getFinalDestinationName(), car.getFinalDestinationTrackName()));
        Router.addLine(this._buildReport, SEVEN, buf.toString());
    }

    private boolean finshSettingRouteFor(Car car, Track track) {
        Car ts2 = this.clone(car);
        ts2.setDestinationTrack(track);
        String specified = this.canSpecifiedTrainService(ts2);
        if (specified.equals(NO)) {
            Router.addLine(this._buildReport, SEVEN, MessageFormat.format(Bundle.getMessage("TrainDoesNotServiceCar"), this._train.getName(), car.toString(), track.getLocation().getName(), track.getName()));
            this._status = MessageFormat.format(STATUS_NOT_THIS_TRAIN, this._train.getName());
            return true;
        }
        if (specified.equals(NOT_NOW)) {
            Router.addLine(this._buildReport, SEVEN, MessageFormat.format(Bundle.getMessage("RouterTrainCanNotDueTo"), this._train.getName(), car.toString(), track.getLocation().getName(), track.getName(), this._train.getServiceStatus()));
            return true;
        }
        if (track.isStaging() && this._train != null && this._train.getTerminationTrack() != null && this._train.getTerminationTrack() != track) {
            Router.addLine(this._buildReport, SEVEN, MessageFormat.format(Bundle.getMessage("RouterTrainIntoStaging"), this._train.getName(), this._train.getTerminationTrack().getLocation().getName(), this._train.getTerminationTrack().getName()));
            return false;
        }
        this._status = car.setDestination(track.getLocation(), track);
        if (!this._status.equals(Track.OKAY)) {
            Router.addLine(this._buildReport, SEVEN, MessageFormat.format(Bundle.getMessage("RouterCanNotDeliverCar"), car.toString(), track.getLocation().getName(), track.getName(), this._status, track.getTrackTypeName()));
            if (this._status.startsWith(Track.LENGTH)) {
                return false;
            }
        }
        return true;
    }

    private Car clone(Car car) {
        Car clone = car.copy();
        if (car.getKernel() != null) {
            clone.setLength(Integer.toString(car.getKernel().getTotalLength() - RollingStock.COUPLERS));
        }
        clone.setTrack(car.getTrack());
        clone.setFinalDestination(car.getFinalDestination());
        clone.setDestination(car.getFinalDestination());
        clone.setDestinationTrack(car.getFinalDestinationTrack());
        return clone;
    }

    private void loadTracks(Car car, Car testCar, List<Track> tracks) {
        for (Track track : tracks) {
            String status;
            if (track == car.getTrack() || this._lastLocationTracks.contains(track) || !(status = track.isRollingStockAccepted(testCar)).equals(Track.OKAY) && !status.startsWith(Track.LENGTH)) continue;
            testCar.setDestinationTrack(track);
            Train train = null;
            String specified = this.canSpecifiedTrainService(testCar);
            train = specified.equals(YES) || specified.equals(NOT_NOW) ? this._train : this.tmanager.getTrainForCar(testCar, null);
            if (car.getTrack().isStaging() && !specified.equals(YES)) {
                train = null;
            }
            if (train != null && this._train != null && this._train.isServiceAllCarsWithFinalDestinationsEnabled() && !specified.equals(YES)) {
                Router.addLine(this._buildReport, SEVEN, MessageFormat.format(Bundle.getMessage("RouterOptionToCarry"), this._train.getName(), train.getName(), car.toString(), track.getLocation().getName(), track.getName()));
                train = null;
            }
            if (train != null) {
                this._nextLocationTracks.add(track);
                this._nextLocationTrains.add(train);
                continue;
            }
            this._otherLocationTracks.add(track);
        }
    }

    private String canSpecifiedTrainService(Car car) {
        if (this._train == null) {
            return NO_SPECIFIED_TRAIN;
        }
        if (this._train.isServiceable(car)) {
            return YES;
        }
        if (!this._train.getServiceStatus().equals("")) {
            return NOT_NOW;
        }
        return NO;
    }
}

