/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.operations.rollingstock.engines.tools;

import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import jmri.InstanceManager;
import jmri.jmrit.operations.OperationsFrame;
import jmri.jmrit.operations.OperationsPanel;
import jmri.jmrit.operations.rollingstock.cars.CarRoads;
import jmri.jmrit.operations.rollingstock.engines.Engine;
import jmri.jmrit.operations.rollingstock.engines.EngineManager;
import jmri.jmrit.operations.rollingstock.engines.EngineModels;
import jmri.jmrit.operations.rollingstock.engines.EngineTypes;
import jmri.jmrit.operations.rollingstock.engines.EnginesTableFrame;
import jmri.jmrit.operations.rollingstock.engines.tools.Bundle;
import jmri.jmrit.operations.setup.Control;
import jmri.jmrit.operations.setup.Setup;
import jmri.util.davidflanagan.HardcopyWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrintEngineRosterAction
extends AbstractAction {
    private int numberCharPerLine = 90;
    final int ownerMaxLen = 5;
    EngineManager manager = InstanceManager.getDefault(EngineManager.class);
    boolean _isPreview;
    EnginesTableFrame panel;
    EnginePrintOptionFrame epof = null;
    static final String NEW_LINE = "\n";
    static final String TAB = "\t";
    JComboBox<String> sortByComboBox = new JComboBox();
    JComboBox<String> manifestOrientationComboBox = new JComboBox();
    JComboBox<Integer> fontSizeComboBox = new JComboBox();
    private static final Logger log = LoggerFactory.getLogger(PrintEngineRosterAction.class);

    public PrintEngineRosterAction(boolean isPreview, EnginesTableFrame pWho) {
        super(isPreview ? Bundle.getMessage("MenuItemPreview") : Bundle.getMessage("MenuItemPrint"));
        this._isPreview = isPreview;
        this.panel = pWho;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.epof == null) {
            this.epof = new EnginePrintOptionFrame(this);
        } else {
            this.epof.setVisible(true);
        }
        this.epof.initComponents();
    }

    public void printEngines() {
        boolean landscape = false;
        if (this.manifestOrientationComboBox.getSelectedItem() != null && this.manifestOrientationComboBox.getSelectedItem() == Setup.LANDSCAPE) {
            landscape = true;
        }
        int fontSize = (Integer)this.fontSizeComboBox.getSelectedItem();
        HardcopyWriter writer = null;
        try {
            writer = new HardcopyWriter(new Frame(), Bundle.getMessage("TitleEngineRoster"), fontSize, 0.5, 0.5, 0.5, 0.5, this._isPreview, "", landscape, true, null);
        }
        catch (HardcopyWriter.PrintCanceledException printCanceledException) {
            log.debug("Print cancelled");
            return;
        }
        this.numberCharPerLine = writer.getCharactersPerLine();
        try {
            writer.write(this.createHeader());
            String train = "";
            String consist = "";
            String moves = "";
            String owner = "";
            String built = "";
            String dccAddress = "";
            String value = "";
            String rfid = "";
            String last = "";
            String location = "";
            List<Engine> engines = this.panel.enginesModel.getEngineList(this.sortByComboBox.getSelectedIndex());
            for (Engine engine : engines) {
                String s;
                String number = this.padAttribute(engine.getNumber(), Control.max_len_string_print_road_number);
                String road = this.padAttribute(engine.getRoadName(), InstanceManager.getDefault(CarRoads.class).getMaxNameLength());
                String model = this.padAttribute(engine.getModel(), InstanceManager.getDefault(EngineModels.class).getMaxNameLength());
                String type = this.padAttribute(engine.getTypeName(), InstanceManager.getDefault(EngineTypes.class).getMaxNameLength());
                String length = this.padAttribute(engine.getLength(), Control.max_len_string_length_name);
                if (this.sortByComboBox.getSelectedIndex() == this.panel.enginesModel.SORTBY_TRAIN) {
                    train = this.padAttribute(engine.getTrainName().trim(), Control.max_len_string_train_name / 2);
                } else {
                    consist = this.padAttribute(engine.getConsistName(), Control.max_len_string_attibute);
                }
                if (this.sortByComboBox.getSelectedIndex() == this.panel.enginesModel.SORTBY_OWNER) {
                    owner = this.padAttribute(engine.getOwner(), 5);
                } else if (this.sortByComboBox.getSelectedIndex() == this.panel.enginesModel.SORTBY_MOVES) {
                    moves = this.padAttribute(Integer.toString(engine.getMoves()), 5);
                } else if (this.sortByComboBox.getSelectedIndex() == this.panel.enginesModel.SORTBY_DCC_ADDRESS) {
                    dccAddress = this.padAttribute(engine.getDccAddress(), 5);
                } else if (this.sortByComboBox.getSelectedIndex() == this.panel.enginesModel.SORTBY_LAST) {
                    last = this.padAttribute(engine.getLastDate().split(" ")[0], 10);
                } else if (this.sortByComboBox.getSelectedIndex() == this.panel.enginesModel.SORTBY_VALUE) {
                    value = this.padAttribute(engine.getValue(), Control.max_len_string_attibute);
                } else if (this.sortByComboBox.getSelectedIndex() == this.panel.enginesModel.SORTBY_RFID) {
                    rfid = this.padAttribute(engine.getRfid(), Control.max_len_string_attibute);
                } else {
                    built = this.padAttribute(engine.getBuilt(), Control.max_len_string_built_name);
                }
                if (!engine.getLocationName().equals("")) {
                    location = String.valueOf(engine.getLocationName()) + " - " + engine.getTrackName();
                }
                if ((s = String.valueOf(number) + road + model + type + length + consist + train + moves + owner + value + rfid + dccAddress + built + last + location).length() > this.numberCharPerLine) {
                    s = s.substring(0, this.numberCharPerLine);
                }
                writer.write(String.valueOf(s) + NEW_LINE);
            }
        }
        catch (IOException we) {
            log.error("Error printing ConsistRosterEntry: {}", (Throwable)we);
        }
        writer.close();
    }

    private String createHeader() {
        StringBuffer header = new StringBuffer();
        header.append(String.valueOf(this.padAttribute(Bundle.getMessage("Number"), Control.max_len_string_print_road_number)) + this.padAttribute(Bundle.getMessage("Road"), InstanceManager.getDefault(CarRoads.class).getMaxNameLength()) + this.padAttribute(Bundle.getMessage("Model"), InstanceManager.getDefault(EngineModels.class).getMaxNameLength()) + this.padAttribute(Bundle.getMessage("Type"), InstanceManager.getDefault(EngineTypes.class).getMaxNameLength()) + this.padAttribute(Bundle.getMessage("Len"), Control.max_len_string_length_name));
        if (this.sortByComboBox.getSelectedIndex() == this.panel.enginesModel.SORTBY_TRAIN) {
            header.append(this.padAttribute(Bundle.getMessage("Train"), Control.max_len_string_train_name / 2));
        } else {
            header.append(this.padAttribute(Bundle.getMessage("Consist"), Control.max_len_string_attibute));
        }
        if (this.sortByComboBox.getSelectedIndex() == this.panel.enginesModel.SORTBY_OWNER) {
            header.append(this.padAttribute(Bundle.getMessage("Owner"), 5));
        } else if (this.sortByComboBox.getSelectedIndex() == this.panel.enginesModel.SORTBY_MOVES) {
            header.append(this.padAttribute(Bundle.getMessage("Moves"), 5));
        } else if (this.sortByComboBox.getSelectedIndex() == this.panel.enginesModel.SORTBY_VALUE) {
            header.append(this.padAttribute(Setup.getValueLabel(), Control.max_len_string_attibute));
        } else if (this.sortByComboBox.getSelectedIndex() == this.panel.enginesModel.SORTBY_LAST) {
            header.append(this.padAttribute(Bundle.getMessage("LastMoved"), 10));
        } else if (this.sortByComboBox.getSelectedIndex() == this.panel.enginesModel.SORTBY_RFID) {
            header.append(this.padAttribute(Setup.getRfidLabel(), Control.max_len_string_attibute));
        } else if (this.sortByComboBox.getSelectedIndex() == this.panel.enginesModel.SORTBY_DCC_ADDRESS) {
            header.append(this.padAttribute(Bundle.getMessage("DccAddress"), 5));
        } else {
            header.append(this.padAttribute(Bundle.getMessage("Built"), Control.max_len_string_built_name));
        }
        header.append(String.valueOf(Bundle.getMessage("Location")) + NEW_LINE);
        return header.toString();
    }

    private String padAttribute(String attribute, int length) {
        if ((attribute = attribute.trim()).length() > length) {
            attribute = attribute.substring(0, length);
        }
        StringBuffer buf = new StringBuffer(attribute);
        int i = attribute.length();
        while (i < length + 1) {
            buf.append(" ");
            ++i;
        }
        return buf.toString();
    }

    public class EnginePrintOptionFrame
    extends OperationsFrame {
        PrintEngineRosterAction pcr;
        JButton okayButton = new JButton(Bundle.getMessage("ButtonOK"));

        public EnginePrintOptionFrame(PrintEngineRosterAction pcr) {
            this.pcr = pcr;
            JPanel pSortBy = new JPanel();
            pSortBy.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("SortBy")));
            pSortBy.add(PrintEngineRosterAction.this.sortByComboBox);
            this.addComboBoxAction(PrintEngineRosterAction.this.sortByComboBox);
            JPanel pOrientation = new JPanel();
            pOrientation.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("BorderLayoutOrientation")));
            pOrientation.add(PrintEngineRosterAction.this.manifestOrientationComboBox);
            PrintEngineRosterAction.this.manifestOrientationComboBox.addItem(Setup.PORTRAIT);
            PrintEngineRosterAction.this.manifestOrientationComboBox.addItem(Setup.LANDSCAPE);
            JPanel pFontSize = new JPanel();
            pFontSize.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("BorderLayoutFontSize")));
            pFontSize.add(PrintEngineRosterAction.this.fontSizeComboBox);
            OperationsPanel.loadFontSizeComboBox(PrintEngineRosterAction.this.fontSizeComboBox);
            PrintEngineRosterAction.this.fontSizeComboBox.setSelectedItem(Control.reportFontSize);
            JPanel pButtons = new JPanel();
            pButtons.setLayout(new GridBagLayout());
            pButtons.add(this.okayButton);
            pButtons.setBorder(BorderFactory.createTitledBorder(""));
            this.addButtonAction(this.okayButton);
            this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
            this.getContentPane().add(pSortBy);
            this.getContentPane().add(pOrientation);
            this.getContentPane().add(pFontSize);
            this.getContentPane().add(pButtons);
            this.initMinimumSize(new Dimension(300, 250));
        }

        @Override
        public void initComponents() {
            if (PrintEngineRosterAction.this._isPreview) {
                this.setTitle(Bundle.getMessage("MenuItemPreview"));
            } else {
                this.setTitle(Bundle.getMessage("MenuItemPrint"));
            }
            this.loadSortByComboBox(PrintEngineRosterAction.this.sortByComboBox);
        }

        private void loadSortByComboBox(JComboBox<String> box) {
            box.removeAllItems();
            int i = PrintEngineRosterAction.this.panel.enginesModel.SORTBY_NUMBER;
            while (i <= PrintEngineRosterAction.this.panel.enginesModel.SORTBY_DCC_ADDRESS) {
                box.addItem(PrintEngineRosterAction.this.panel.enginesModel.getSortByName(i));
                ++i;
            }
            box.setSelectedItem(PrintEngineRosterAction.this.panel.enginesModel.getSortByName());
        }

        @Override
        public void buttonActionPerformed(ActionEvent ae) {
            this.setVisible(false);
            this.pcr.printEngines();
        }
    }
}

