/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.operations.rollingstock.engines.tools;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import javax.swing.JOptionPane;
import jmri.InstanceManager;
import jmri.jmrit.operations.locations.Location;
import jmri.jmrit.operations.locations.LocationManager;
import jmri.jmrit.operations.locations.Track;
import jmri.jmrit.operations.rollingstock.ImportRollingStock;
import jmri.jmrit.operations.rollingstock.engines.Consist;
import jmri.jmrit.operations.rollingstock.engines.ConsistManager;
import jmri.jmrit.operations.rollingstock.engines.Engine;
import jmri.jmrit.operations.rollingstock.engines.EngineManager;
import jmri.jmrit.operations.rollingstock.engines.EngineModels;
import jmri.jmrit.operations.rollingstock.engines.tools.Bundle;
import jmri.jmrit.operations.setup.Control;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImportEngines
extends ImportRollingStock {
    private static final String DEFAULT_ENGINE_TYPE = Bundle.getMessage("engineDefaultType");
    private static final String DEFAULT_ENGINE_HP = Bundle.getMessage("engineDefaultHp");
    private static final int ENG_NUMBER = 0;
    private static final int ENG_ROAD = 1;
    private static final int ENG_MODEL = 2;
    private static final int ENG_LENGTH = 3;
    private static final int ENG_OWNER = 4;
    private static final int ENG_BUILT = 5;
    private static final int ENG_LOCATION = 6;
    private static final int ENG_LOCATION_TRACK_SEPARATOR = 7;
    private static final int ENG_TRACK = 8;
    private static final int ENG_CONSIST = 9;
    private static final int ENG_HP = 13;
    private static final int ENG_WEIGHT = 14;
    private static final int ENG_TYPE = 15;
    EngineManager engineManager = InstanceManager.getDefault(EngineManager.class);
    private static final Logger log = LoggerFactory.getLogger(ImportEngines.class);

    @Override
    public void run() {
        int enginesAdded;
        boolean importOkay;
        BufferedReader in;
        block60: {
            File file = this.getFile();
            if (file == null) {
                return;
            }
            in = this.getBufferedReader(file);
            if (in == null) {
                return;
            }
            this.createStatusFrame(Bundle.getMessage("ImportEngines"));
            importOkay = false;
            boolean comma = false;
            int lineNum = 0;
            enginesAdded = 0;
            String line = " ";
            String engineOwner = "";
            String engineBuilt = "";
            String engineLocationName = "";
            String engineTrackName = "";
            String engineConsistName = "";
            String engineHp = "";
            String engineWeightTons = "";
            String engineType = "";
            if (file.getAbsolutePath().endsWith(".csv")) {
                log.info("Using comma as delimiter for import engines");
                comma = true;
            }
            while (true) {
                this.lineNumber.setText(String.valueOf(Bundle.getMessage("LineNumber")) + " " + Integer.toString(++lineNum));
                try {
                    line = in.readLine();
                }
                catch (IOException iOException) {
                    break block60;
                }
                if (line == null) {
                    importOkay = true;
                    break block60;
                }
                if (!this.fstatus.isShowing()) break block60;
                line = line.trim();
                log.debug("Import: {}", (Object)line);
                this.importLine.setText(line);
                if (line.startsWith(Bundle.getMessage("Number"))) continue;
                if (line.equalsIgnoreCase("comma")) {
                    log.info("Using comma as delimiter for import engines");
                    comma = true;
                    continue;
                }
                String[] inputLine = comma ? this.parseCommaLine(line) : line.split("\\s+");
                if (inputLine.length < 1 || line.isEmpty()) {
                    log.debug("Skipping blank line");
                    continue;
                }
                int base = 1;
                if (comma || !inputLine[0].isEmpty()) {
                    --base;
                }
                if (inputLine.length > base + 3) {
                    int results;
                    String status;
                    int results2;
                    String engineNumber = inputLine[base + 0];
                    String engineRoad = inputLine[base + 1];
                    String engineModel = inputLine[base + 2];
                    String engineLength = inputLine[base + 3];
                    engineOwner = "";
                    engineBuilt = "";
                    engineLocationName = "";
                    engineTrackName = "";
                    engineConsistName = "";
                    engineHp = "";
                    engineWeightTons = "";
                    engineType = "";
                    log.debug("Checking engine number ({}) road ({}) model ({}) length ({})", new Object[]{engineNumber, engineRoad, engineModel, engineLength});
                    if (engineNumber.trim().isEmpty()) {
                        log.info("Import line {} missing engine number", (Object)lineNum);
                        break block60;
                    }
                    if (engineRoad.trim().isEmpty()) {
                        log.info("Import line {} missing engine road", (Object)lineNum);
                        break block60;
                    }
                    if (engineModel.trim().isEmpty()) {
                        log.info("Import line {} missing engine model", (Object)lineNum);
                        break block60;
                    }
                    if (engineLength.trim().isEmpty()) {
                        log.info("Import line {} missing engine length", (Object)lineNum);
                        break block60;
                    }
                    if (engineNumber.length() > Control.max_len_string_road_number) {
                        JOptionPane.showMessageDialog(null, MessageFormat.format(Bundle.getMessage("EngineRoadNumberTooLong"), String.valueOf(engineRoad) + " " + engineNumber, engineNumber), Bundle.getMessage("RoadNumMustBeLess"), 0);
                        break block60;
                    }
                    if (engineRoad.length() > Control.max_len_string_attibute) {
                        JOptionPane.showMessageDialog(null, MessageFormat.format(Bundle.getMessage("EngineRoadNameTooLong"), String.valueOf(engineRoad) + " " + engineNumber, engineRoad), MessageFormat.format(Bundle.getMessage("engineAttribute"), Control.max_len_string_attibute), 0);
                        break block60;
                    }
                    if (engineModel.length() > Control.max_len_string_attibute) {
                        JOptionPane.showMessageDialog(null, MessageFormat.format(Bundle.getMessage("EngineModelNameTooLong"), String.valueOf(engineRoad) + " " + engineNumber, engineModel), MessageFormat.format(Bundle.getMessage("engineAttribute"), Control.max_len_string_attibute), 0);
                        break block60;
                    }
                    if (!InstanceManager.getDefault(EngineModels.class).containsName(engineModel)) {
                        int results3 = JOptionPane.showConfirmDialog(null, String.valueOf(Bundle.getMessage("Engine")) + " (" + engineRoad + " " + engineNumber + ")" + "\n" + MessageFormat.format(Bundle.getMessage("modelNameNotExist"), engineModel), Bundle.getMessage("engineAddModel"), 1);
                        if (results3 == 0) {
                            InstanceManager.getDefault(EngineModels.class).addName(engineModel);
                        } else if (results3 == 2) break block60;
                    }
                    if (engineLength.length() > Control.max_len_string_length_name) {
                        JOptionPane.showMessageDialog(null, MessageFormat.format(Bundle.getMessage("EngineLengthNameTooLong"), String.valueOf(engineRoad) + " " + engineNumber, engineLength), MessageFormat.format(Bundle.getMessage("engineAttribute"), Control.max_len_string_length_name), 0);
                        break block60;
                    }
                    try {
                        Integer.parseInt(engineLength);
                    }
                    catch (NumberFormatException numberFormatException) {
                        JOptionPane.showMessageDialog(null, MessageFormat.format(Bundle.getMessage("EngineLengthNameNotNumber"), String.valueOf(engineRoad) + " " + engineNumber, engineLength), Bundle.getMessage("EngineLengthMissing"), 0);
                        break block60;
                    }
                    Engine e = (Engine)this.engineManager.getByRoadAndNumber(engineRoad, engineNumber);
                    if (e != null) {
                        log.info("Can not add engine number ({}) road ({}) it already exists!", (Object)engineNumber, (Object)engineRoad);
                        continue;
                    }
                    if (inputLine.length > base + 4 && (engineOwner = inputLine[base + 4]).length() > Control.max_len_string_attibute) {
                        JOptionPane.showMessageDialog(null, MessageFormat.format(Bundle.getMessage("EngineOwnerNameTooLong"), String.valueOf(engineRoad) + " " + engineNumber, engineOwner), MessageFormat.format(Bundle.getMessage("engineAttribute"), Control.max_len_string_attibute), 0);
                        break block60;
                    }
                    if (inputLine.length > base + 5 && (engineBuilt = inputLine[base + 5]).length() > Control.max_len_string_built_name) {
                        JOptionPane.showMessageDialog(null, MessageFormat.format(Bundle.getMessage("EngineBuiltDateTooLong"), String.valueOf(engineRoad) + " " + engineNumber, engineBuilt), MessageFormat.format(Bundle.getMessage("engineAttribute"), Control.max_len_string_built_name), 0);
                        break block60;
                    }
                    if (inputLine.length > base + 6) {
                        engineLocationName = inputLine[base + 6];
                    }
                    if (comma && inputLine.length > base + 8) {
                        engineTrackName = inputLine[base + 8];
                    }
                    if (!comma) {
                        int j = 0;
                        StringBuffer name = new StringBuffer(engineLocationName);
                        int i = base + 7;
                        while (i < inputLine.length) {
                            if (inputLine[i].equals("-")) {
                                j = i + 1;
                                break;
                            }
                            name.append(" " + inputLine[i]);
                            ++i;
                        }
                        engineLocationName = name.toString();
                        log.debug("Engine ({} {}) has location ({})", new Object[]{engineRoad, engineNumber, engineLocationName});
                        name = new StringBuffer();
                        if (j != 0 && j < inputLine.length) {
                            name.append(inputLine[j]);
                            i = j + 1;
                            while (i < inputLine.length) {
                                name.append(" " + inputLine[i]);
                                ++i;
                            }
                            log.debug("Engine ({} {}) has track ({})", new Object[]{engineRoad, engineNumber, engineTrackName});
                        }
                        engineTrackName = name.toString();
                    }
                    if (engineLocationName.length() > Control.max_len_string_location_name) {
                        JOptionPane.showMessageDialog(null, MessageFormat.format(Bundle.getMessage("EngineLocationNameTooLong"), String.valueOf(engineRoad) + " " + engineNumber, engineLocationName), MessageFormat.format(Bundle.getMessage("engineAttribute"), Control.max_len_string_location_name), 0);
                        break block60;
                    }
                    if (engineTrackName.length() > Control.max_len_string_track_name) {
                        JOptionPane.showMessageDialog(null, MessageFormat.format(Bundle.getMessage("EngineTrackNameTooLong"), String.valueOf(engineRoad) + " " + engineNumber, engineTrackName), MessageFormat.format(Bundle.getMessage("engineAttribute"), Control.max_len_string_track_name), 0);
                        break block60;
                    }
                    Location location = InstanceManager.getDefault(LocationManager.class).getLocationByName(engineLocationName);
                    Track track = null;
                    if (location == null && !engineLocationName.isEmpty()) {
                        JOptionPane.showMessageDialog(null, MessageFormat.format(Bundle.getMessage("EngineLocationDoesNotExist"), String.valueOf(engineRoad) + " " + engineNumber, engineLocationName), Bundle.getMessage("engineLocation"), 0);
                        results2 = JOptionPane.showConfirmDialog(null, MessageFormat.format(Bundle.getMessage("DoYouWantToCreateLoc"), engineLocationName), Bundle.getMessage("engineLocation"), 0);
                        if (results2 != 0) break block60;
                        log.debug("Create location ({})", (Object)engineLocationName);
                        location = InstanceManager.getDefault(LocationManager.class).newLocation(engineLocationName);
                    }
                    if (location != null && !engineTrackName.isEmpty() && (track = location.getTrackByName(engineTrackName, null)) == null) {
                        JOptionPane.showMessageDialog(null, MessageFormat.format(Bundle.getMessage("EngineTrackDoesNotExist"), String.valueOf(engineRoad) + " " + engineNumber, engineTrackName, engineLocationName), Bundle.getMessage("engineTrack"), 0);
                        results2 = JOptionPane.showConfirmDialog(null, MessageFormat.format(Bundle.getMessage("DoYouWantToCreateTrack"), engineTrackName, engineLocationName), Bundle.getMessage("engineTrack"), 0);
                        if (results2 != 0) break block60;
                        if (!location.isStaging()) {
                            log.debug("Create 1000 foot yard track ({})", (Object)engineTrackName);
                            track = location.addTrack(engineTrackName, "Yard");
                        } else {
                            log.debug("Create 1000 foot staging track ({})", (Object)engineTrackName);
                            track = location.addTrack(engineTrackName, "Staging");
                        }
                        track.setLength(1000);
                    }
                    if (comma && inputLine.length > base + 9) {
                        engineConsistName = inputLine[9];
                        log.debug("Consist name ({})", (Object)engineConsistName);
                    }
                    if (comma && inputLine.length > base + 13) {
                        engineHp = inputLine[13];
                        log.debug("Engine HP ({})", (Object)engineHp);
                    }
                    if (comma && inputLine.length > base + 14) {
                        engineWeightTons = inputLine[14];
                        log.debug("Engine weight tons ({})", (Object)engineWeightTons);
                    }
                    if (comma && inputLine.length > base + 15) {
                        engineType = inputLine[15];
                        log.debug("Engine type ({})", (Object)engineType);
                    }
                    log.debug("Add engine ({} {}) owner ({}) built ({}) location ({}, {})", new Object[]{engineRoad, engineNumber, engineOwner, engineBuilt, engineLocationName, engineTrackName});
                    Engine engine = this.engineManager.newRS(engineRoad, engineNumber);
                    engine.setModel(engineModel);
                    engine.setLength(engineLength);
                    if (engine.getTypeName().equals("")) {
                        if (!engineType.isEmpty()) {
                            engine.setTypeName(engineType);
                        } else {
                            engine.setTypeName(DEFAULT_ENGINE_TYPE);
                        }
                    }
                    if (engine.getHp().equals("")) {
                        if (!engineHp.isEmpty()) {
                            engine.setHp(engineHp);
                        } else {
                            engine.setHp(DEFAULT_ENGINE_HP);
                        }
                    }
                    if (engine.getWeightTons().equals("")) {
                        engine.setWeightTons(engineWeightTons);
                    }
                    engine.setOwner(engineOwner);
                    engine.setBuilt(engineBuilt);
                    if (!engineConsistName.isEmpty()) {
                        Consist consist = InstanceManager.getDefault(ConsistManager.class).newConsist(engineConsistName);
                        engine.setConsist(consist);
                    }
                    ++enginesAdded;
                    if (location == null || track == null || (status = engine.setLocation(location, track)).equals(Track.OKAY)) continue;
                    log.debug("Can't set engine's location because of {}", (Object)status);
                    JOptionPane.showMessageDialog(null, MessageFormat.format(Bundle.getMessage("CanNotSetEngineAtLocation"), String.valueOf(engineRoad) + " " + engineNumber, engineModel, engineLocationName, engineTrackName, status), Bundle.getMessage("rsCanNotLoc"), 0);
                    if (status.startsWith(Track.TYPE)) {
                        results = JOptionPane.showConfirmDialog(null, MessageFormat.format(Bundle.getMessage("DoYouWantToAllowService"), engineLocationName, engineTrackName, String.valueOf(engineRoad) + " " + engineNumber, engine.getTypeName()), Bundle.getMessage("ServiceEngineType"), 0);
                        if (results != 0) break block60;
                        location.addTypeName(engine.getTypeName());
                        track.addTypeName(engine.getTypeName());
                        status = engine.setLocation(location, track);
                    }
                    if (status.startsWith(Track.LENGTH)) {
                        results = JOptionPane.showConfirmDialog(null, MessageFormat.format(Bundle.getMessage("DoYouWantIncreaseLength"), engineTrackName), Bundle.getMessage("TrackLength"), 0);
                        if (results != 0) break block60;
                        track.setLength(track.getLength() + 1000);
                        status = engine.setLocation(location, track);
                    }
                    if (status.equals(Track.OKAY)) continue;
                    results = JOptionPane.showConfirmDialog(null, MessageFormat.format(Bundle.getMessage("DoYouWantToForceEngine"), String.valueOf(engineRoad) + " " + engineNumber, engineLocationName, engineTrackName), Bundle.getMessage("OverRide"), 0);
                    if (results == 0) {
                        engine.setLocation(location, track, true);
                        continue;
                    }
                    break block60;
                }
                if (!line.isEmpty()) break;
            }
            log.info("Engine import line {} missing attributes: {}", (Object)lineNum, (Object)line);
            JOptionPane.showMessageDialog(null, MessageFormat.format(Bundle.getMessage("ImportMissingAttributes"), lineNum), Bundle.getMessage("EngineAttributeMissing"), 0);
        }
        try {
            in.close();
        }
        catch (IOException iOException) {}
        if (importOkay) {
            JOptionPane.showMessageDialog(null, MessageFormat.format(Bundle.getMessage("ImportEnginesAdded"), enginesAdded), Bundle.getMessage("SuccessfulImport"), 1);
        } else {
            JOptionPane.showMessageDialog(null, MessageFormat.format(Bundle.getMessage("ImportEnginesAdded"), enginesAdded), Bundle.getMessage("ImportFailed"), 0);
        }
        this.fstatus.dispose();
    }
}

