/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.operations.rollingstock.engines.tools;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.List;
import javax.swing.JOptionPane;
import jmri.InstanceManager;
import jmri.jmrit.XmlFile;
import jmri.jmrit.operations.rollingstock.engines.Engine;
import jmri.jmrit.operations.rollingstock.engines.EngineManager;
import jmri.jmrit.operations.rollingstock.engines.tools.Bundle;
import jmri.jmrit.operations.setup.OperationsSetupXml;
import jmri.jmrit.operations.setup.Setup;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExportEngines
extends XmlFile {
    protected static final String LOCATION_TRACK_SEPARATOR = "-";
    private static String operationsFileName = "ExportOperationsEngineRoster.csv";
    private static final Logger log = LoggerFactory.getLogger(ExportEngines.class);

    public void writeOperationsEngineFile() {
        this.makeBackupFile(ExportEngines.defaultOperationsFilename());
        try {
            if (!this.checkFile(ExportEngines.defaultOperationsFilename())) {
                File file = new File(ExportEngines.defaultOperationsFilename());
                File parentDir = file.getParentFile();
                if (!parentDir.exists() && !parentDir.mkdir()) {
                    log.error("Directory wasn't created");
                }
                if (file.createNewFile()) {
                    log.debug("File created");
                }
            }
            this.writeFile(ExportEngines.defaultOperationsFilename());
        }
        catch (IOException e) {
            log.error("Exception while writing the new CSV operations file, may not be complete: {}", (Throwable)e);
        }
    }

    public void writeFile(String name) {
        log.debug("writeFile {}", (Object)name);
        File file = this.findFile(name);
        if (file == null) {
            file = new File(name);
        }
        try {
            Throwable throwable = null;
            Object var4_5 = null;
            try (CSVPrinter fileOut = new CSVPrinter((Appendable)new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), StandardCharsets.UTF_8)), CSVFormat.DEFAULT);){
                EngineManager manager = InstanceManager.getDefault(EngineManager.class);
                List engineList = manager.getByNumberList();
                fileOut.printRecord(new Object[]{Bundle.getMessage("Number"), Bundle.getMessage("Road"), Bundle.getMessage("Model"), Bundle.getMessage("Length"), Bundle.getMessage("Owner"), Bundle.getMessage("Built"), Bundle.getMessage("Location"), LOCATION_TRACK_SEPARATOR, Bundle.getMessage("Track"), Bundle.getMessage("Consist"), Bundle.getMessage("Moves"), Bundle.getMessage("Last"), Setup.getValueLabel(), Bundle.getMessage("HP"), Bundle.getMessage("WeightTons"), Bundle.getMessage("Type"), Bundle.getMessage("Comment"), Bundle.getMessage("Miscellaneous")});
                for (Engine engine : engineList) {
                    fileOut.printRecord(new Object[]{engine.getNumber(), engine.getRoadName(), engine.getModel(), engine.getLength(), engine.getOwner(), engine.getBuilt(), engine.getLocationName(), LOCATION_TRACK_SEPARATOR, engine.getTrackName(), engine.getConsistName(), engine.getMoves(), engine.getLastDate(), engine.getValue(), engine.getHp(), engine.getWeightTons(), engine.getTypeName(), engine.getComment(), engine.isOutOfService() ? Bundle.getMessage("OutOfService") : ""});
                }
                fileOut.flush();
                fileOut.close();
                log.info("Exported {} engines to file {}", (Object)engineList.size(), (Object)ExportEngines.defaultOperationsFilename());
                JOptionPane.showMessageDialog(null, MessageFormat.format(Bundle.getMessage("ExportedEnginesToFile"), engineList.size(), ExportEngines.defaultOperationsFilename()), Bundle.getMessage("ExportComplete"), 1);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException iOException) {
            log.error("Can not open export engines CSV file: {}", (Object)file.getName());
            JOptionPane.showMessageDialog(null, MessageFormat.format(Bundle.getMessage("ExportedEnginesToFile"), 0, ExportEngines.defaultOperationsFilename()), Bundle.getMessage("ExportFailed"), 0);
        }
    }

    public static String defaultOperationsFilename() {
        return String.valueOf(OperationsSetupXml.getFileLocation()) + OperationsSetupXml.getOperationsDirectoryName() + File.separator + ExportEngines.getOperationsFileName();
    }

    public static void setOperationsFileName(String name) {
        operationsFileName = name;
    }

    public static String getOperationsFileName() {
        return operationsFileName;
    }
}

