/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.operations.rollingstock.engines;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;
import jmri.InstanceManager;
import jmri.jmrit.operations.rollingstock.RollingStock;
import jmri.jmrit.operations.rollingstock.engines.Bundle;
import jmri.jmrit.operations.rollingstock.engines.Engine;
import jmri.jmrit.operations.rollingstock.engines.EngineEditFrame;
import jmri.jmrit.operations.rollingstock.engines.EngineManager;
import jmri.jmrit.operations.rollingstock.engines.EngineSetFrame;
import jmri.jmrit.operations.rollingstock.engines.EnginesTableFrame;
import jmri.jmrit.operations.setup.Setup;
import jmri.util.swing.XTableColumnModel;
import jmri.util.table.ButtonEditor;
import jmri.util.table.ButtonRenderer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EnginesTableModel
extends AbstractTableModel
implements PropertyChangeListener {
    EngineManager engineManager = InstanceManager.getDefault(EngineManager.class);
    private static final int NUM_COLUMN = 0;
    private static final int ROAD_COLUMN = 1;
    private static final int MODEL_COLUMN = 2;
    private static final int HP_COLUMN = 3;
    private static final int TYPE_COLUMN = 4;
    private static final int LENGTH_COLUMN = 5;
    private static final int CONSIST_COLUMN = 6;
    private static final int LOCATION_COLUMN = 7;
    private static final int RFID_WHERE_LAST_SEEN_COLUMN = 8;
    private static final int RFID_WHEN_LAST_SEEN_COLUMN = 9;
    private static final int DESTINATION_COLUMN = 10;
    private static final int TRAIN_COLUMN = 11;
    private static final int MOVES_COLUMN = 12;
    private static final int BUILT_COLUMN = 13;
    private static final int OWNER_COLUMN = 14;
    private static final int VALUE_COLUMN = 15;
    private static final int RFID_COLUMN = 16;
    private static final int LAST_COLUMN = 17;
    private static final int DCC_ADDRESS_COLUMN = 18;
    private static final int SET_COLUMN = 19;
    private static final int EDIT_COLUMN = 20;
    private static final int HIGHEST_COLUMN = 21;
    public final int SORTBY_NUMBER = 0;
    public final int SORTBY_ROAD = 1;
    public final int SORTBY_MODEL = 2;
    public final int SORTBY_LOCATION = 3;
    public final int SORTBY_DESTINATION = 4;
    public final int SORTBY_TRAIN = 5;
    public final int SORTBY_MOVES = 6;
    public final int SORTBY_CONSIST = 7;
    public final int SORTBY_BUILT = 8;
    public final int SORTBY_OWNER = 9;
    public final int SORTBY_VALUE = 10;
    public final int SORTBY_RFID = 11;
    public final int SORTBY_LAST = 12;
    public final int SORTBY_HP = 13;
    public final int SORTBY_DCC_ADDRESS = 14;
    private int _sort = 0;
    String _roadNumber = "";
    int _index = 0;
    List<Engine> engineList = null;
    JTable _table;
    EnginesTableFrame _frame;
    private final int[] _enginesTableColumnWidths = new int[]{60, 60, 65, 50, 65, 35, 75, 190, 190, 140, 190, 65, 50, 50, 50, 50, 100, 130, 50, 65, 70};
    EngineEditFrame engineEditFrame = null;
    EngineSetFrame engineSetFrame = null;
    private static final Logger log = LoggerFactory.getLogger(EnginesTableModel.class);

    public EnginesTableModel() {
        this.engineManager.addPropertyChangeListener(this);
        this.updateList();
    }

    public void setSort(int sort) {
        this._sort = sort;
        this.updateList();
        if (sort == 6 || sort == 8 || sort == 9 || sort == 10 || sort == 11 || sort == 12 || sort == 14) {
            XTableColumnModel tcm = (XTableColumnModel)this._table.getColumnModel();
            tcm.setColumnVisible(tcm.getColumnByModelIndex(12), sort == 6);
            tcm.setColumnVisible(tcm.getColumnByModelIndex(13), sort == 8);
            tcm.setColumnVisible(tcm.getColumnByModelIndex(14), sort == 9);
            tcm.setColumnVisible(tcm.getColumnByModelIndex(15), sort == 10);
            tcm.setColumnVisible(tcm.getColumnByModelIndex(16), sort == 11);
            tcm.setColumnVisible(tcm.getColumnByModelIndex(9), sort == 11);
            tcm.setColumnVisible(tcm.getColumnByModelIndex(8), sort == 11);
            tcm.setColumnVisible(tcm.getColumnByModelIndex(17), sort == 12);
            tcm.setColumnVisible(tcm.getColumnByModelIndex(18), sort == 14);
        }
        this.fireTableDataChanged();
    }

    public String getSortByName() {
        return this.getSortByName(this._sort);
    }

    public String getSortByName(int sort) {
        switch (sort) {
            case 0: {
                return Bundle.getMessage("Number");
            }
            case 1: {
                return Bundle.getMessage("Road");
            }
            case 2: {
                return Bundle.getMessage("Model");
            }
            case 3: {
                return Bundle.getMessage("Location");
            }
            case 4: {
                return Bundle.getMessage("Destination");
            }
            case 5: {
                return Bundle.getMessage("Train");
            }
            case 6: {
                return Bundle.getMessage("Moves");
            }
            case 7: {
                return Bundle.getMessage("Consist");
            }
            case 8: {
                return Bundle.getMessage("Built");
            }
            case 9: {
                return Bundle.getMessage("Owner");
            }
            case 14: {
                return Bundle.getMessage("DccAddress");
            }
            case 13: {
                return Bundle.getMessage("HP");
            }
            case 10: {
                return Setup.getValueLabel();
            }
            case 11: {
                return Setup.getRfidLabel();
            }
            case 12: {
                return Bundle.getMessage("Last");
            }
        }
        return "Error";
    }

    public int findEngineByRoadNumber(String roadNumber) {
        if (this.engineList != null) {
            if (!roadNumber.equals(this._roadNumber)) {
                return this.getIndex(0, roadNumber);
            }
            int index = this.getIndex(this._index, roadNumber);
            if (index > 0) {
                return index;
            }
            return this.getIndex(0, roadNumber);
        }
        return -1;
    }

    private int getIndex(int start, String roadNumber) {
        int index = start;
        while (index < this.engineList.size()) {
            Engine e = this.engineList.get(index);
            if (e != null) {
                String rN;
                String[] number = e.getNumber().split("-");
                if (roadNumber.startsWith("*") && roadNumber.endsWith("*")) {
                    rN = roadNumber.substring(1, roadNumber.length() - 1);
                    if (e.getNumber().contains(rN)) {
                        this._roadNumber = roadNumber;
                        this._index = index + 1;
                        return index;
                    }
                } else if (roadNumber.startsWith("*")) {
                    rN = roadNumber.substring(1);
                    if (e.getNumber().endsWith(rN) || number[0].endsWith(rN)) {
                        this._roadNumber = roadNumber;
                        this._index = index + 1;
                        return index;
                    }
                } else if (roadNumber.endsWith("*")) {
                    rN = roadNumber.substring(0, roadNumber.length() - 1);
                    if (e.getNumber().startsWith(rN)) {
                        this._roadNumber = roadNumber;
                        this._index = index + 1;
                        return index;
                    }
                } else if (e.getNumber().equals(roadNumber) || number[0].equals(roadNumber)) {
                    this._roadNumber = roadNumber;
                    this._index = index + 1;
                    return index;
                }
            }
            ++index;
        }
        this._roadNumber = "";
        return -1;
    }

    private void updateList() {
        this.removePropertyChangeEngines();
        this.engineList = this.getSelectedEngineList();
        for (RollingStock rollingStock : this.engineList) {
            rollingStock.addPropertyChangeListener(this);
        }
    }

    public List<Engine> getSelectedEngineList() {
        return this.getEngineList(this._sort);
    }

    public List<Engine> getEngineList(int sort) {
        List<Engine> list;
        switch (sort) {
            case 1: {
                list = this.engineManager.getByRoadNameList();
                break;
            }
            case 2: {
                list = this.engineManager.getByModelList();
                break;
            }
            case 3: {
                list = this.engineManager.getByLocationList();
                break;
            }
            case 4: {
                list = this.engineManager.getByDestinationList();
                break;
            }
            case 5: {
                list = this.engineManager.getByTrainList();
                break;
            }
            case 6: {
                list = this.engineManager.getByMovesList();
                break;
            }
            case 7: {
                list = this.engineManager.getByConsistList();
                break;
            }
            case 9: {
                list = this.engineManager.getByOwnerList();
                break;
            }
            case 8: {
                list = this.engineManager.getByBuiltList();
                break;
            }
            case 10: {
                list = this.engineManager.getByValueList();
                break;
            }
            case 11: {
                list = this.engineManager.getByRfidList();
                break;
            }
            case 12: {
                list = this.engineManager.getByLastDateList();
                break;
            }
            default: {
                list = this.engineManager.getByNumberList();
            }
        }
        return list;
    }

    void initTable(JTable table, EnginesTableFrame frame) {
        this._table = table;
        this._frame = frame;
        this.initTable();
    }

    void initTable() {
        XTableColumnModel tcm = new XTableColumnModel();
        this._table.setColumnModel(tcm);
        this._table.createDefaultColumnsFromModel();
        ButtonRenderer buttonRenderer = new ButtonRenderer();
        tcm.getColumn(19).setCellRenderer(buttonRenderer);
        ButtonEditor buttonEditor = new ButtonEditor(new JButton());
        tcm.getColumn(19).setCellEditor(buttonEditor);
        tcm.getColumn(20).setCellRenderer(buttonRenderer);
        tcm.getColumn(20).setCellEditor(buttonEditor);
        int i = 0;
        while (i < tcm.getColumnCount()) {
            tcm.getColumn(i).setPreferredWidth(this._enginesTableColumnWidths[i]);
            ++i;
        }
        this._frame.loadTableDetails(this._table);
        tcm.setColumnVisible(tcm.getColumnByModelIndex(13), false);
        tcm.setColumnVisible(tcm.getColumnByModelIndex(14), false);
        tcm.setColumnVisible(tcm.getColumnByModelIndex(15), false);
        tcm.setColumnVisible(tcm.getColumnByModelIndex(16), false);
        tcm.setColumnVisible(tcm.getColumnByModelIndex(9), false);
        tcm.setColumnVisible(tcm.getColumnByModelIndex(8), false);
        tcm.setColumnVisible(tcm.getColumnByModelIndex(17), false);
        tcm.setColumnVisible(tcm.getColumnByModelIndex(18), false);
        tcm.setColumnVisible(tcm.getColumnByModelIndex(12), true);
    }

    @Override
    public int getRowCount() {
        return this.engineList.size();
    }

    @Override
    public int getColumnCount() {
        return 21;
    }

    @Override
    public String getColumnName(int col) {
        switch (col) {
            case 0: {
                return Bundle.getMessage("Number");
            }
            case 1: {
                return Bundle.getMessage("Road");
            }
            case 2: {
                return Bundle.getMessage("Model");
            }
            case 3: {
                return Bundle.getMessage("HP");
            }
            case 4: {
                return Bundle.getMessage("Type");
            }
            case 5: {
                return Bundle.getMessage("Len");
            }
            case 6: {
                return Bundle.getMessage("Consist");
            }
            case 7: {
                return Bundle.getMessage("Location");
            }
            case 8: {
                return Bundle.getMessage("WhereLastSeen");
            }
            case 9: {
                return Bundle.getMessage("WhenLastSeen");
            }
            case 10: {
                return Bundle.getMessage("Destination");
            }
            case 11: {
                return Bundle.getMessage("Train");
            }
            case 12: {
                return Bundle.getMessage("Moves");
            }
            case 13: {
                return Bundle.getMessage("Built");
            }
            case 14: {
                return Bundle.getMessage("Owner");
            }
            case 15: {
                return Setup.getValueLabel();
            }
            case 16: {
                return Setup.getRfidLabel();
            }
            case 17: {
                return Bundle.getMessage("LastMoved");
            }
            case 18: {
                return Bundle.getMessage("DccAddress");
            }
            case 19: {
                return Bundle.getMessage("Set");
            }
            case 20: {
                return Bundle.getMessage("ButtonEdit");
            }
        }
        return "unknown";
    }

    @Override
    public Class<?> getColumnClass(int col) {
        switch (col) {
            case 19: 
            case 20: {
                return JButton.class;
            }
            case 5: 
            case 12: {
                return Integer.class;
            }
        }
        return String.class;
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        switch (col) {
            case 12: 
            case 15: 
            case 16: 
            case 19: 
            case 20: {
                return true;
            }
        }
        return false;
    }

    @Override
    public Object getValueAt(int row, int col) {
        if (row >= this.getRowCount()) {
            return "ERROR row " + row;
        }
        Engine eng = this.engineList.get(row);
        if (eng == null) {
            return "ERROR engine unknown " + row;
        }
        switch (col) {
            case 0: {
                return eng.getNumber();
            }
            case 1: {
                return eng.getRoadName();
            }
            case 5: {
                return eng.getLengthInteger();
            }
            case 2: {
                return eng.getModel();
            }
            case 3: {
                return eng.getHp();
            }
            case 4: {
                if (eng.isBunit()) {
                    return String.valueOf(eng.getTypeName()) + " " + Bundle.getMessage("(B)");
                }
                return eng.getTypeName();
            }
            case 6: {
                if (eng.isLead()) {
                    return String.valueOf(eng.getConsistName()) + "*";
                }
                return eng.getConsistName();
            }
            case 7: {
                String s = eng.getStatus();
                if (!eng.getLocationName().equals("")) {
                    s = String.valueOf(eng.getStatus()) + eng.getLocationName() + " (" + eng.getTrackName() + ")";
                }
                return s;
            }
            case 8: {
                return String.valueOf(eng.getWhereLastSeenName()) + (eng.getTrackLastSeenName().equals("") ? "" : " (" + eng.getTrackLastSeenName() + ")");
            }
            case 9: {
                return eng.getWhenLastSeenDate();
            }
            case 10: {
                String s = "";
                if (!eng.getDestinationName().equals("")) {
                    s = String.valueOf(eng.getDestinationName()) + " (" + eng.getDestinationTrackName() + ")";
                }
                return s;
            }
            case 11: {
                if (eng.getTrain() != null && eng.getRouteLocation() == null) {
                    return String.valueOf(eng.getTrainName()) + "*";
                }
                return eng.getTrainName();
            }
            case 12: {
                return eng.getMoves();
            }
            case 13: {
                return eng.getBuilt();
            }
            case 14: {
                return eng.getOwner();
            }
            case 15: {
                return eng.getValue();
            }
            case 16: {
                return eng.getRfid();
            }
            case 17: {
                return eng.getLastDate();
            }
            case 18: {
                return eng.getDccAddress();
            }
            case 19: {
                return Bundle.getMessage("Set");
            }
            case 20: {
                return Bundle.getMessage("ButtonEdit");
            }
        }
        return "unknown " + col;
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        Engine engine = this.engineList.get(row);
        switch (col) {
            case 12: {
                try {
                    engine.setMoves(Integer.parseInt(value.toString()));
                }
                catch (NumberFormatException numberFormatException) {
                    log.error("move count must be a number");
                }
                break;
            }
            case 13: {
                engine.setBuilt(value.toString());
                break;
            }
            case 14: {
                engine.setOwner(value.toString());
                break;
            }
            case 15: {
                engine.setValue(value.toString());
                break;
            }
            case 16: {
                engine.setRfid(value.toString());
                break;
            }
            case 19: {
                log.debug("Set engine location");
                if (this.engineSetFrame != null) {
                    this.engineSetFrame.dispose();
                }
                SwingUtilities.invokeLater(() -> {
                    this.engineSetFrame = new EngineSetFrame();
                    this.engineSetFrame.initComponents();
                    this.engineSetFrame.loadEngine(engine);
                });
                break;
            }
            case 20: {
                log.debug("Edit engine");
                if (this.engineEditFrame != null) {
                    this.engineEditFrame.dispose();
                }
                SwingUtilities.invokeLater(() -> {
                    this.engineEditFrame = new EngineEditFrame();
                    this.engineEditFrame.initComponents();
                    this.engineEditFrame.load(engine);
                });
                break;
            }
        }
    }

    public void dispose() {
        log.debug("dispose EngineTableModel");
        this.engineManager.removePropertyChangeListener(this);
        this.removePropertyChangeEngines();
        if (this.engineSetFrame != null) {
            this.engineSetFrame.dispose();
        }
        if (this.engineEditFrame != null) {
            this.engineEditFrame.dispose();
        }
    }

    private void removePropertyChangeEngines() {
        if (this.engineList != null) {
            for (RollingStock rollingStock : this.engineList) {
                rollingStock.removePropertyChangeListener(this);
            }
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        Engine engine;
        int row;
        if (e.getPropertyName().equals("RollingStockListLength") || e.getPropertyName().equals("GroupListLengthChanged")) {
            this.updateList();
            this.fireTableDataChanged();
        } else if (e.getPropertyName().equals("rolling stock length") || e.getPropertyName().equals("rolling stock type") || e.getPropertyName().equals("hp")) {
            this.fireTableDataChanged();
        } else if (e.getSource().getClass().equals(Engine.class) && (row = this.engineList.indexOf(engine = (Engine)e.getSource())) >= 0) {
            this.fireTableRowsUpdated(row, row);
        }
    }
}

