/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.operations.rollingstock.engines;

import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.MessageFormat;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.TableColumnModel;
import jmri.InstanceManager;
import jmri.jmrit.operations.OperationsFrame;
import jmri.jmrit.operations.OperationsMenu;
import jmri.jmrit.operations.OperationsXml;
import jmri.jmrit.operations.rollingstock.engines.Bundle;
import jmri.jmrit.operations.rollingstock.engines.Engine;
import jmri.jmrit.operations.rollingstock.engines.EngineEditFrame;
import jmri.jmrit.operations.rollingstock.engines.EngineManager;
import jmri.jmrit.operations.rollingstock.engines.EngineRosterMenu;
import jmri.jmrit.operations.rollingstock.engines.EnginesTableModel;
import jmri.jmrit.operations.rollingstock.engines.tools.NceConsistEngineAction;
import jmri.jmrit.operations.setup.Setup;
import jmri.swing.JTablePersistenceManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EnginesTableFrame
extends OperationsFrame
implements PropertyChangeListener {
    public EnginesTableModel enginesModel;
    JTable enginesTable;
    JScrollPane enginesPane;
    EngineManager engineManager = InstanceManager.getDefault(EngineManager.class);
    JLabel numEngines = new JLabel();
    JLabel textEngines = new JLabel();
    JLabel textSep1 = new JLabel("          ");
    JRadioButton sortByNumber = new JRadioButton(Bundle.getMessage("Number"));
    JRadioButton sortByRoad = new JRadioButton(Bundle.getMessage("Road"));
    JRadioButton sortByModel = new JRadioButton(Bundle.getMessage("Model"));
    public JRadioButton sortByConsist = new JRadioButton(Bundle.getMessage("Consist"));
    JRadioButton sortByLocation = new JRadioButton(Bundle.getMessage("Location"));
    JRadioButton sortByDestination = new JRadioButton(Bundle.getMessage("Destination"));
    JRadioButton sortByTrain = new JRadioButton(Bundle.getMessage("Train"));
    JRadioButton sortByMoves = new JRadioButton(Bundle.getMessage("Moves"));
    JRadioButton sortByBuilt = new JRadioButton(Bundle.getMessage("Built"));
    JRadioButton sortByOwner = new JRadioButton(Bundle.getMessage("Owner"));
    public JRadioButton sortByValue = new JRadioButton(Setup.getValueLabel());
    public JRadioButton sortByRfid = new JRadioButton(Setup.getRfidLabel());
    JRadioButton sortByDcc = new JRadioButton(Bundle.getMessage("DccAddress"));
    JRadioButton sortByLast = new JRadioButton(Bundle.getMessage("Last"));
    ButtonGroup group = new ButtonGroup();
    JButton addButton = new JButton(Bundle.getMessage("ButtonAdd"));
    JButton findButton = new JButton(Bundle.getMessage("Find"));
    JButton saveButton = new JButton(Bundle.getMessage("ButtonSave"));
    JTextField findEngineTextBox = new JTextField(6);
    EngineEditFrame engineEditFrame = null;
    private static final Logger log = LoggerFactory.getLogger(EnginesTableFrame.class);

    public EnginesTableFrame() {
        super(Bundle.getMessage("TitleEnginesTable"));
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        this.enginesModel = new EnginesTableModel();
        this.enginesTable = new JTable(this.enginesModel);
        this.enginesPane = new JScrollPane(this.enginesTable);
        this.enginesPane.setVerticalScrollBarPolicy(20);
        this.enginesModel.initTable(this.enginesTable, this);
        this.numEngines.setText(Integer.toString(this.engineManager.getNumEntries()));
        this.engineManager.addPropertyChangeListener(this);
        this.textEngines.setText(Bundle.getMessage("engines"));
        JPanel cp1 = new JPanel();
        cp1.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("SortBy")));
        cp1.add(this.sortByNumber);
        cp1.add(this.sortByRoad);
        cp1.add(this.sortByModel);
        cp1.add(this.sortByConsist);
        cp1.add(this.sortByLocation);
        cp1.add(this.sortByDestination);
        cp1.add(this.sortByTrain);
        JPanel movep = new JPanel();
        movep.setBorder(BorderFactory.createTitledBorder(""));
        movep.add(this.sortByMoves);
        movep.add(this.sortByBuilt);
        movep.add(this.sortByOwner);
        if (Setup.isValueEnabled()) {
            movep.add(this.sortByValue);
        }
        if (Setup.isRfidEnabled()) {
            movep.add(this.sortByRfid);
        }
        movep.add(this.sortByDcc);
        movep.add(this.sortByLast);
        cp1.add(movep);
        JPanel cp2 = new JPanel();
        cp2.setLayout(new BoxLayout(cp2, 0));
        JPanel cp2Add = new JPanel();
        cp2Add.setBorder(BorderFactory.createTitledBorder(""));
        cp2Add.add(this.numEngines);
        cp2Add.add(this.textEngines);
        cp2Add.add(this.textSep1);
        cp2Add.add(this.addButton);
        cp2.add(cp2Add);
        JPanel cp2Find = new JPanel();
        cp2Find.setBorder(BorderFactory.createTitledBorder(""));
        this.findButton.setToolTipText(Bundle.getMessage("findEngine"));
        this.findEngineTextBox.setToolTipText(Bundle.getMessage("findEngine"));
        cp2Find.add(this.findButton);
        cp2Find.add(this.findEngineTextBox);
        cp2.add(cp2Find);
        JPanel cp2Save = new JPanel();
        cp2Save.setBorder(BorderFactory.createTitledBorder(""));
        cp2Save.add(this.saveButton);
        cp2.add(cp2Save);
        JPanel controlPanel = new JPanel();
        controlPanel.setLayout(new BoxLayout(controlPanel, 1));
        controlPanel.add(cp1);
        controlPanel.add(cp2);
        this.sortByLast.setToolTipText(Bundle.getMessage("TipLastMoved"));
        JScrollPane controlPane = new JScrollPane(controlPanel);
        this.getContentPane().add(this.enginesPane);
        this.getContentPane().add(controlPane);
        this.addButtonAction(this.addButton);
        this.addButtonAction(this.findButton);
        this.addButtonAction(this.saveButton);
        this.sortByNumber.setSelected(true);
        this.addRadioButtonAction(this.sortByNumber);
        this.addRadioButtonAction(this.sortByRoad);
        this.addRadioButtonAction(this.sortByModel);
        this.addRadioButtonAction(this.sortByConsist);
        this.addRadioButtonAction(this.sortByLocation);
        this.addRadioButtonAction(this.sortByDestination);
        this.addRadioButtonAction(this.sortByTrain);
        this.addRadioButtonAction(this.sortByMoves);
        this.addRadioButtonAction(this.sortByBuilt);
        this.addRadioButtonAction(this.sortByOwner);
        this.addRadioButtonAction(this.sortByValue);
        this.addRadioButtonAction(this.sortByRfid);
        this.addRadioButtonAction(this.sortByDcc);
        this.addRadioButtonAction(this.sortByLast);
        this.group.add(this.sortByNumber);
        this.group.add(this.sortByRoad);
        this.group.add(this.sortByModel);
        this.group.add(this.sortByConsist);
        this.group.add(this.sortByLocation);
        this.group.add(this.sortByDestination);
        this.group.add(this.sortByTrain);
        this.group.add(this.sortByMoves);
        this.group.add(this.sortByBuilt);
        this.group.add(this.sortByOwner);
        this.group.add(this.sortByValue);
        this.group.add(this.sortByRfid);
        this.group.add(this.sortByDcc);
        this.group.add(this.sortByLast);
        this.sortByDcc.setToolTipText(Bundle.getMessage("TipDccAddressFromRoster"));
        JMenuBar menuBar = new JMenuBar();
        JMenu toolMenu = new JMenu(Bundle.getMessage("MenuTools"));
        toolMenu.add(new EngineRosterMenu(Bundle.getMessage("TitleEngineRoster"), 1, this));
        toolMenu.add(new NceConsistEngineAction());
        menuBar.add(toolMenu);
        menuBar.add(new OperationsMenu());
        this.setJMenuBar(menuBar);
        this.addHelpMenu("package.jmri.jmrit.operations.Operations_Locomotives", true);
        this.initMinimumSize();
        this.addHorizontalScrollBarKludgeFix(controlPane, controlPanel);
        this.createShutDownTask();
    }

    @Override
    public void radioButtonActionPerformed(ActionEvent ae) {
        log.debug("radio button activated");
        this.clearTableSort(this.enginesTable);
        if (ae.getSource() == this.sortByNumber) {
            this.enginesModel.setSort(this.enginesModel.SORTBY_NUMBER);
        }
        if (ae.getSource() == this.sortByRoad) {
            this.enginesModel.setSort(this.enginesModel.SORTBY_ROAD);
        }
        if (ae.getSource() == this.sortByModel) {
            this.enginesModel.setSort(this.enginesModel.SORTBY_MODEL);
        }
        if (ae.getSource() == this.sortByConsist) {
            this.enginesModel.setSort(this.enginesModel.SORTBY_CONSIST);
        }
        if (ae.getSource() == this.sortByLocation) {
            this.enginesModel.setSort(this.enginesModel.SORTBY_LOCATION);
        }
        if (ae.getSource() == this.sortByDestination) {
            this.enginesModel.setSort(this.enginesModel.SORTBY_DESTINATION);
        }
        if (ae.getSource() == this.sortByTrain) {
            this.enginesModel.setSort(this.enginesModel.SORTBY_TRAIN);
        }
        if (ae.getSource() == this.sortByMoves) {
            this.enginesModel.setSort(this.enginesModel.SORTBY_MOVES);
        }
        if (ae.getSource() == this.sortByBuilt) {
            this.enginesModel.setSort(this.enginesModel.SORTBY_BUILT);
        }
        if (ae.getSource() == this.sortByOwner) {
            this.enginesModel.setSort(this.enginesModel.SORTBY_OWNER);
        }
        if (ae.getSource() == this.sortByValue) {
            this.enginesModel.setSort(this.enginesModel.SORTBY_VALUE);
        }
        if (ae.getSource() == this.sortByRfid) {
            this.enginesModel.setSort(this.enginesModel.SORTBY_RFID);
        }
        if (ae.getSource() == this.sortByLast) {
            this.enginesModel.setSort(this.enginesModel.SORTBY_LAST);
        }
        if (ae.getSource() == this.sortByDcc) {
            this.enginesModel.setSort(this.enginesModel.SORTBY_DCC_ADDRESS);
        }
    }

    public List<Engine> getSortByList() {
        return this.enginesModel.getSelectedEngineList();
    }

    @Override
    public void buttonActionPerformed(ActionEvent ae) {
        if (ae.getSource() == this.findButton) {
            int rowindex = this.enginesModel.findEngineByRoadNumber(this.findEngineTextBox.getText());
            if (rowindex < 0) {
                JOptionPane.showMessageDialog(this, MessageFormat.format(Bundle.getMessage("engineWithRoadNumNotFound"), this.findEngineTextBox.getText()), Bundle.getMessage("engineCouldNotFind"), 1);
                return;
            }
            this.clearTableSort(this.enginesTable);
            this.enginesTable.changeSelection(rowindex, 0, false, false);
            return;
        }
        if (ae.getSource() == this.addButton) {
            if (this.engineEditFrame != null) {
                this.engineEditFrame.dispose();
            }
            this.engineEditFrame = new EngineEditFrame();
            this.engineEditFrame.initComponents();
        }
        if (ae.getSource() == this.saveButton) {
            if (this.enginesTable.isEditing()) {
                log.debug("locomotives table edit true");
                this.enginesTable.getCellEditor().stopCellEditing();
            }
            OperationsXml.save();
            if (Setup.isCloseWindowOnSaveEnabled()) {
                this.dispose();
            }
        }
    }

    protected int[] getCurrentTableColumnWidths() {
        TableColumnModel tcm = this.enginesTable.getColumnModel();
        int[] widths = new int[tcm.getColumnCount()];
        int i = 0;
        while (i < tcm.getColumnCount()) {
            widths[i] = tcm.getColumn(i).getWidth();
            ++i;
        }
        return widths;
    }

    @Override
    public void dispose() {
        this.engineManager.removePropertyChangeListener(this);
        this.enginesModel.dispose();
        if (this.engineEditFrame != null) {
            this.engineEditFrame.dispose();
        }
        InstanceManager.getOptionalDefault(JTablePersistenceManager.class).ifPresent(tpm -> tpm.stopPersisting(this.enginesTable));
        super.dispose();
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        if (e.getPropertyName().equals("RollingStockListLength")) {
            this.numEngines.setText(Integer.toString(this.engineManager.getNumEntries()));
        }
    }
}

