/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.operations.rollingstock.engines;

import java.util.Hashtable;
import java.util.Set;
import jmri.InstanceManager;
import jmri.implementation.AbstractInstanceInitializer;
import jmri.jmrit.operations.rollingstock.RollingStockAttribute;
import jmri.jmrit.operations.rollingstock.engines.Bundle;
import jmri.jmrit.operations.rollingstock.engines.EngineManagerXml;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EngineModels
extends RollingStockAttribute {
    private static final String MODELS = Bundle.getMessage("engineDefaultModels");
    private static final String HORSEPOWER = Bundle.getMessage("engineModelHorsepowers");
    private static final String ENGINELENGTHS = Bundle.getMessage("engineModelLengths");
    private static final String ENGINETYPES = Bundle.getMessage("engineModelTypes");
    private static final String ENGINEWEIGHTS = Bundle.getMessage("engineModelWeights");
    public static final String ENGINEMODELS_CHANGED_PROPERTY = "EngineModels";
    public static final String ENGINEMODELS_NAME_CHANGED_PROPERTY = "EngineModelsName";
    protected Hashtable<String, String> _engineHorsepowerHashTable = new Hashtable();
    protected Hashtable<String, String> _engineLengthHashTable = new Hashtable();
    protected Hashtable<String, String> _engineTypeHashTable = new Hashtable();
    protected Hashtable<String, String> _engineWeightHashTable = new Hashtable();
    protected Hashtable<String, Boolean> _engineBunitHashTable = new Hashtable();
    private static final Logger log = LoggerFactory.getLogger(EngineModels.class);

    @Override
    protected String getDefaultNames() {
        return MODELS;
    }

    @Override
    public void dispose() {
        this._engineHorsepowerHashTable.clear();
        this._engineLengthHashTable.clear();
        this._engineTypeHashTable.clear();
        this._engineWeightHashTable.clear();
        this._engineBunitHashTable.clear();
        super.dispose();
    }

    @Override
    public void addName(String model) {
        super.addName(model);
        this.setDirtyAndFirePropertyChange(ENGINEMODELS_CHANGED_PROPERTY, null, model);
    }

    @Override
    public void deleteName(String model) {
        super.deleteName(model);
        this.setDirtyAndFirePropertyChange(ENGINEMODELS_CHANGED_PROPERTY, model, null);
    }

    public void replaceName(String oldName, String newName) {
        super.addName(newName);
        this.setDirtyAndFirePropertyChange(ENGINEMODELS_NAME_CHANGED_PROPERTY, oldName, newName);
        super.deleteName(oldName);
    }

    public void setModelHorsepower(String model, String horsepower) {
        this._engineHorsepowerHashTable.put(model, horsepower);
    }

    public String getModelHorsepower(String model) {
        return this._engineHorsepowerHashTable.get(model);
    }

    public void setModelLength(String model, String horsepower) {
        this._engineLengthHashTable.put(model, horsepower);
    }

    public String getModelLength(String model) {
        return this._engineLengthHashTable.get(model);
    }

    public void setModelType(String model, String type) {
        this._engineTypeHashTable.put(model, type);
    }

    public String getModelType(String model) {
        return this._engineTypeHashTable.get(model);
    }

    public void setModelBunit(String model, boolean bUnit) {
        this._engineBunitHashTable.put(model, bUnit);
    }

    public boolean isModelBunit(String model) {
        if (this._engineBunitHashTable.containsKey(model)) {
            return this._engineBunitHashTable.get(model);
        }
        return false;
    }

    public void setModelWeight(String model, String type) {
        this._engineWeightHashTable.put(model, type);
    }

    public String getModelWeight(String model) {
        return this._engineWeightHashTable.get(model);
    }

    private void loadDefaults() {
        String[] models = MODELS.split(",");
        String[] hps = HORSEPOWER.split(",");
        String[] lengths = ENGINELENGTHS.split(",");
        String[] types = ENGINETYPES.split(",");
        String[] weights = ENGINEWEIGHTS.split(",");
        if (models.length != hps.length || models.length != lengths.length || models.length != types.length || models.length != weights.length) {
            log.error("Defaults do not have the right number of items, models={} hps={} lengths={} types={}", new Object[]{models.length, hps.length, lengths.length, types.length});
            return;
        }
        int i = 0;
        while (i < models.length) {
            this.setModelHorsepower(models[i], hps[i]);
            this.setModelLength(models[i], lengths[i]);
            this.setModelType(models[i], types[i]);
            this.setModelWeight(models[i], weights[i]);
            this.setModelBunit(models[i], false);
            ++i;
        }
    }

    public void store(Element root) {
        this.store(root, "models", "model");
    }

    public void load(Element root) {
        this.load(root, "models", "model", "engineModels");
    }

    protected void setDirtyAndFirePropertyChange(String p, Object old, Object n) {
        InstanceManager.getDefault(EngineManagerXml.class).setDirty(true);
        super.firePropertyChange(p, old, n);
    }

    public static class Initializer
    extends AbstractInstanceInitializer {
        @Override
        public <T> Object getDefault(Class<T> type) {
            if (type.equals(EngineModels.class)) {
                EngineModels instance = new EngineModels();
                instance.loadDefaults();
                return instance;
            }
            return super.getDefault(type);
        }

        @Override
        public Set<Class<?>> getInitalizes() {
            Set<Class<?>> set = super.getInitalizes();
            set.add(EngineModels.class);
            return set;
        }
    }
}

