/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.operations.rollingstock.engines;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashMap;
import jmri.InstanceManager;
import jmri.InstanceManagerAutoDefault;
import jmri.InstanceManagerAutoInitialize;
import jmri.jmrit.operations.OperationsXml;
import jmri.jmrit.operations.locations.LocationManagerXml;
import jmri.jmrit.operations.rollingstock.RollingStockLogger;
import jmri.jmrit.operations.rollingstock.engines.ConsistManager;
import jmri.jmrit.operations.rollingstock.engines.EngineLengths;
import jmri.jmrit.operations.rollingstock.engines.EngineManager;
import jmri.jmrit.operations.rollingstock.engines.EngineModels;
import jmri.jmrit.operations.rollingstock.engines.EngineTypes;
import jmri.jmrit.operations.setup.Setup;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.ProcessingInstruction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EngineManagerXml
extends OperationsXml
implements InstanceManagerAutoDefault,
InstanceManagerAutoInitialize {
    private String operationsFileName = "OperationsEngineRoster.xml";
    private static final Logger log = LoggerFactory.getLogger(EngineManagerXml.class);

    @Override
    public void writeFile(String name) throws FileNotFoundException, IOException {
        log.debug("writeFile {}", (Object)name);
        File file = this.findFile(name);
        if (file == null) {
            file = new File(name);
        }
        Element root = new Element("operations-config");
        Document doc = EngineManagerXml.newDocument(root, String.valueOf(this.dtdLocation) + "operations-engines.dtd");
        HashMap<String, String> m = new HashMap<String, String>();
        m.put("type", "text/xsl");
        m.put("href", "/xml/XSLT/operations-engines.xsl");
        ProcessingInstruction p = new ProcessingInstruction("xml-stylesheet", m);
        doc.addContent(0, (Content)p);
        InstanceManager.getDefault(EngineModels.class).store(root);
        InstanceManager.getDefault(EngineTypes.class).store(root);
        InstanceManager.getDefault(EngineLengths.class).store(root);
        InstanceManager.getDefault(ConsistManager.class).store(root);
        InstanceManager.getDefault(EngineManager.class).store(root);
        this.writeXML(file, doc);
        this.setDirty(false);
    }

    @Override
    public void readFile(String name) throws JDOMException, IOException {
        if (this.findFile(name) == null) {
            log.debug("{} file could not be found", (Object)name);
            return;
        }
        Element root = this.rootFromName(name);
        if (root == null) {
            log.debug("{} file could not be read", (Object)name);
            return;
        }
        InstanceManager.getDefault(EngineModels.class).load(root);
        InstanceManager.getDefault(EngineTypes.class).load(root);
        InstanceManager.getDefault(EngineLengths.class).load(root);
        InstanceManager.getDefault(ConsistManager.class).load(root);
        InstanceManager.getDefault(EngineManager.class).load(root);
        log.debug("Engines have been loaded!");
        InstanceManager.getDefault(RollingStockLogger.class).enableEngineLogging(Setup.isEngineLoggerEnabled());
        this.setDirty(false);
        InstanceManager.getDefault(LocationManagerXml.class).setDirty(false);
    }

    @Override
    public void setOperationsFileName(String name) {
        this.operationsFileName = name;
    }

    @Override
    public String getOperationsFileName() {
        return this.operationsFileName;
    }

    public void dispose() {
    }

    @Override
    public void initialize() {
        this.load();
    }
}

