/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.operations.rollingstock.engines;

import java.beans.PropertyChangeEvent;
import java.util.List;
import jmri.InstanceManager;
import jmri.jmrit.operations.locations.Location;
import jmri.jmrit.operations.locations.Track;
import jmri.jmrit.operations.rollingstock.RollingStock;
import jmri.jmrit.operations.rollingstock.engines.Consist;
import jmri.jmrit.operations.rollingstock.engines.ConsistManager;
import jmri.jmrit.operations.rollingstock.engines.EngineLengths;
import jmri.jmrit.operations.rollingstock.engines.EngineManagerXml;
import jmri.jmrit.operations.rollingstock.engines.EngineModels;
import jmri.jmrit.operations.rollingstock.engines.EngineTypes;
import jmri.jmrit.operations.routes.RouteLocation;
import jmri.jmrit.roster.Roster;
import jmri.jmrit.roster.RosterEntry;
import org.jdom2.Attribute;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Engine
extends RollingStock {
    public static final int NCE_REAR_BLOCK_NUMBER = 8;
    public static final int B_UNIT_BLOCKING = 10;
    public static final String HP_CHANGED_PROPERTY = "hp";
    private Consist _consist = null;
    private String _model = "";
    EngineModels engineModels = InstanceManager.getDefault(EngineModels.class);
    boolean verboseStore = false;
    private static final Logger log = LoggerFactory.getLogger(Engine.class);

    public Engine(String road, String number) {
        super(road, number);
        log.debug("New engine ({} {})", (Object)road, (Object)number);
        this.addPropertyChangeListeners();
    }

    public void setModel(String model) {
        String old = this._model;
        this._model = model;
        if (!old.equals(model)) {
            this.setDirtyAndFirePropertyChange("engine model", old, model);
        }
    }

    public String getModel() {
        return this._model;
    }

    @Override
    public void setTypeName(String type) {
        if (this.getModel() == null || this.getModel().equals("")) {
            return;
        }
        String old = this.getTypeName();
        this.engineModels.setModelType(this.getModel(), type);
        if (!old.equals(type)) {
            this.setDirtyAndFirePropertyChange("rolling stock type", old, type);
        }
    }

    @Override
    public String getTypeName() {
        String type = this.engineModels.getModelType(this.getModel());
        if (type == null) {
            type = super.getTypeName();
        }
        return type;
    }

    public void setHp(String hp) {
        if (this.getModel().equals("")) {
            return;
        }
        String old = this.getHp();
        this.engineModels.setModelHorsepower(this.getModel(), hp);
        if (!old.equals(hp)) {
            this.setDirtyAndFirePropertyChange(HP_CHANGED_PROPERTY, old, hp);
        }
    }

    public String getHp() {
        String hp = this.engineModels.getModelHorsepower(this.getModel());
        if (hp == null) {
            hp = "";
        }
        return hp;
    }

    public int getHpInteger() {
        try {
            return Integer.parseInt(this.getHp());
        }
        catch (NumberFormatException numberFormatException) {
            log.debug("Locomotive ({}) horsepower ({}) isn't a number", (Object)this.toString(), (Object)this.getHp());
            return 0;
        }
    }

    @Override
    public void setLength(String length) {
        super.setLength(length);
        try {
            if (this.getModel().equals("")) {
                return;
            }
            this.engineModels.setModelLength(this.getModel(), length);
        }
        catch (NullPointerException nullPointerException) {
            log.debug("NPE setting length for Engine ({})", (Object)this.toString());
        }
    }

    @Override
    public String getLength() {
        try {
            String length = super.getLength();
            if (this.getModel() != null && !this.getModel().equals("")) {
                length = this.engineModels.getModelLength(this.getModel());
            }
            if (length == null) {
                length = "";
            }
            if (!length.equals(this._length)) {
                if (this._lengthChange) {
                    return this._length;
                }
                log.debug("Loco ({}) length ({}) has been modified from ({})", new Object[]{this.toString(), length, this._length});
                super.setLength(length);
            }
            return length;
        }
        catch (NullPointerException nullPointerException) {
            log.debug("NPE setting length for Engine ({})", (Object)this.toString());
            return "";
        }
    }

    @Override
    public void setWeightTons(String weight) {
        try {
            if (this.getModel().equals("")) {
                return;
            }
            String old = this.getWeightTons();
            super.setWeightTons(weight);
            this.engineModels.setModelWeight(this.getModel(), weight);
            if (!old.equals(weight)) {
                this.setDirtyAndFirePropertyChange("Engine Weight Tons", old, weight);
            }
        }
        catch (NullPointerException nullPointerException) {
            log.debug("NPE setting Weight Tons for Engine ({})", (Object)this.toString());
        }
    }

    @Override
    public String getWeightTons() {
        String weight = null;
        try {
            weight = this.engineModels.getModelWeight(this.getModel());
            if (weight == null) {
                weight = "";
            }
        }
        catch (NullPointerException nullPointerException) {
            log.debug("NPE getting Weight Tons for Engine ({})", (Object)this.toString());
            weight = "";
        }
        return weight;
    }

    public void setBunit(boolean bUnit) {
        if (this.getModel().equals("")) {
            return;
        }
        boolean old = this.isBunit();
        this.engineModels.setModelBunit(this.getModel(), bUnit);
        if (old != bUnit) {
            this.setDirtyAndFirePropertyChange("rolling stock type", old, bUnit);
        }
    }

    public boolean isBunit() {
        try {
            return this.engineModels.isModelBunit(this.getModel());
        }
        catch (NullPointerException nullPointerException) {
            log.debug("NPE getting is B unit for Engine ({})", (Object)this.toString());
            return false;
        }
    }

    public void setConsist(Consist consist) {
        if (this._consist == consist) {
            return;
        }
        String old = "";
        if (this._consist != null) {
            old = this._consist.getName();
            this._consist.delete(this);
        }
        this._consist = consist;
        String newName = "";
        if (this._consist != null) {
            this._consist.add(this);
            newName = this._consist.getName();
        }
        if (!old.equals(newName)) {
            this.setDirtyAndFirePropertyChange("consist", old, newName);
        }
    }

    public Consist getConsist() {
        return this._consist;
    }

    public String getConsistName() {
        if (this._consist != null) {
            return this._consist.getName();
        }
        return "";
    }

    @Override
    public int getBlocking() {
        if (this.isBunit() && this.getConsist() == null) {
            return 10;
        }
        return super.getBlocking();
    }

    public boolean isLead() {
        if (this.getConsist() != null) {
            return this.getConsist().isLead(this);
        }
        return false;
    }

    public String getDccAddress() {
        RosterEntry re = this.getRosterEntry();
        if (re != null) {
            return re.getDccAddress();
        }
        return "";
    }

    public RosterEntry getRosterEntry() {
        RosterEntry rosterEntry = null;
        List<RosterEntry> list = Roster.getDefault().matchingList(this.getRoadName(), this.getNumber(), null, null, null, null, null);
        if (list.size() > 0) {
            rosterEntry = list.get(0);
            log.debug("Roster Loco found by road and number: {}", (Object)rosterEntry.getDccAddress());
        } else if (!this.getNumber().equals("") && (list = Roster.getDefault().matchingList(null, this.getNumber(), null, null, null, null, null)).size() > 0) {
            rosterEntry = list.get(0);
            log.debug("Roster Loco found by number: {}", (Object)rosterEntry.getDccAddress());
        }
        if (rosterEntry == null && (list = Roster.getDefault().matchingList(null, null, this.getNumber(), null, null, null, null)).size() > 0) {
            rosterEntry = list.get(0);
            log.debug("Roster Loco found by dccAddress: {}", (Object)rosterEntry.getDccAddress());
        }
        if (rosterEntry == null && (list = Roster.getDefault().matchingList(null, null, null, null, null, null, this.getNumber())).size() > 0) {
            rosterEntry = list.get(0);
            log.debug("Roster Loco found by roster id: {}", (Object)rosterEntry.getDccAddress());
        }
        return rosterEntry;
    }

    @Override
    public String testDestination(Location destination, Track track) {
        return super.testDestination(destination, track);
    }

    @Override
    protected void moveRollingStock(RouteLocation current, RouteLocation next) {
        if (current == this.getRouteLocation() && (this.getConsist() == null || this.isLead()) && this.getRouteLocation() != this.getRouteDestination() && this.getTrain() != null && !this.isBunit() && this.getTrain().getLeadEngine() != this && (this.getTrain().getSecondLegStartRouteLocation() == current && (this.getTrain().getSecondLegOptions() & 1) == 1 || this.getTrain().getThirdLegStartRouteLocation() == current && (this.getTrain().getThirdLegOptions() & 1) == 1)) {
            log.debug("New lead locomotive ({}) for train ({})", (Object)this.toString(), (Object)this.getTrain().getName());
            this.getTrain().setLeadEngine(this);
            this.getTrain().createTrainIcon(current);
        }
        super.moveRollingStock(current, next);
    }

    @Override
    public void dispose() {
        this.setConsist(null);
        InstanceManager.getDefault(EngineTypes.class).removePropertyChangeListener(this);
        InstanceManager.getDefault(EngineLengths.class).removePropertyChangeListener(this);
        super.dispose();
    }

    public Engine(Element e) {
        super(e);
        Attribute a = e.getAttribute("model");
        if (a != null) {
            this._model = a.getValue();
        }
        if ((a = e.getAttribute(HP_CHANGED_PROPERTY)) != null) {
            this.setHp(a.getValue());
        }
        if ((a = e.getAttribute("length")) != null) {
            this.setLength(a.getValue());
        }
        if ((a = e.getAttribute("type")) != null) {
            this.setTypeName(a.getValue());
        }
        if ((a = e.getAttribute("weightTons")) != null) {
            this.setWeightTons(a.getValue());
        }
        if ((a = e.getAttribute("bUnit")) != null) {
            this.setBunit(a.getValue().equals("true"));
        }
        if ((a = e.getAttribute("consist")) != null) {
            Consist c = InstanceManager.getDefault(ConsistManager.class).getConsistByName(a.getValue());
            if (c != null) {
                this.setConsist(c);
                a = e.getAttribute("leadConsist");
                if (a != null && a.getValue().equals("true")) {
                    this._consist.setLead(this);
                }
                if ((a = e.getAttribute("consistNum")) != null) {
                    this._consist.setConsistNumber(Integer.parseInt(a.getValue()));
                }
            } else {
                log.error("Consist {} does not exist", (Object)a.getValue());
            }
        }
        this.addPropertyChangeListeners();
    }

    public Element store() {
        Element e = new Element("engine");
        super.store(e);
        e.setAttribute("model", this.getModel());
        e.setAttribute(HP_CHANGED_PROPERTY, this.getHp());
        e.setAttribute("bUnit", this.isBunit() ? "true" : "false");
        if (this.getConsist() != null) {
            e.setAttribute("consist", this.getConsistName());
            if (this.isLead()) {
                e.setAttribute("leadConsist", "true");
                if (this.getConsist().getConsistNumber() > 0) {
                    e.setAttribute("consistNum", Integer.toString(this.getConsist().getConsistNumber()));
                }
            }
        }
        return e;
    }

    @Override
    protected void setDirtyAndFirePropertyChange(String p, Object old, Object n) {
        InstanceManager.getDefault(EngineManagerXml.class).setDirty(true);
        super.setDirtyAndFirePropertyChange(p, old, n);
    }

    private void addPropertyChangeListeners() {
        InstanceManager.getDefault(EngineTypes.class).addPropertyChangeListener(this);
        InstanceManager.getDefault(EngineLengths.class).addPropertyChangeListener(this);
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        super.propertyChange(e);
        if (e.getPropertyName().equals("EngineTypesName") && e.getOldValue().equals(this.getTypeName())) {
            log.debug("Loco ({} {}) sees type name change old: ({}) new: ({})", new Object[]{this.toString(), e.getOldValue(), e.getNewValue()});
            this.setTypeName((String)e.getNewValue());
        }
        if (e.getPropertyName().equals("EngineLengthsName") && e.getOldValue().equals(this.getLength())) {
            log.debug("Loco ({}) sees length name change old: {} new: {}", new Object[]{this.toString(), e.getOldValue(), e.getNewValue()});
            this.setLength((String)e.getNewValue());
        }
    }
}

