/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.operations.rollingstock.cars.tools;

import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import jmri.InstanceManager;
import jmri.jmrit.operations.OperationsFrame;
import jmri.jmrit.operations.OperationsPanel;
import jmri.jmrit.operations.locations.LocationManager;
import jmri.jmrit.operations.rollingstock.cars.Car;
import jmri.jmrit.operations.rollingstock.cars.CarColors;
import jmri.jmrit.operations.rollingstock.cars.CarLoads;
import jmri.jmrit.operations.rollingstock.cars.CarOwners;
import jmri.jmrit.operations.rollingstock.cars.CarRoads;
import jmri.jmrit.operations.rollingstock.cars.CarTypes;
import jmri.jmrit.operations.rollingstock.cars.CarsTableFrame;
import jmri.jmrit.operations.rollingstock.cars.tools.Bundle;
import jmri.jmrit.operations.setup.Control;
import jmri.jmrit.operations.setup.Setup;
import jmri.util.davidflanagan.HardcopyWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrintCarRosterAction
extends AbstractAction {
    boolean _isPreview;
    CarsTableFrame panel;
    CarPrintOptionFrame cpof = null;
    int numberCharPerLine;
    JComboBox<String> sortByComboBox = new JComboBox();
    JComboBox<String> manifestOrientationComboBox = new JComboBox();
    JComboBox<Integer> fontSizeComboBox = new JComboBox();
    JCheckBox printCarsWithLocation = new JCheckBox(Bundle.getMessage("PrintCarsWithLocation"));
    JCheckBox printCarLength = new JCheckBox(Bundle.getMessage("PrintCarLength"));
    JCheckBox printCarWeight = new JCheckBox(Bundle.getMessage("PrintCarWeight"));
    JCheckBox printCarColor = new JCheckBox(Bundle.getMessage("PrintCarColor"));
    JCheckBox printCarOwner = new JCheckBox(Bundle.getMessage("PrintCarOwner"));
    JCheckBox printCarBuilt = new JCheckBox(Bundle.getMessage("PrintCarBuilt"));
    JCheckBox printCarLoad = new JCheckBox(Bundle.getMessage("PrintCarLoad"));
    JCheckBox printCarKernel = new JCheckBox(Bundle.getMessage("PrintKernel"));
    JCheckBox printCarValue = new JCheckBox(MessageFormat.format(Bundle.getMessage("PrintCar"), Setup.getValueLabel()));
    JCheckBox printCarRfid = new JCheckBox(MessageFormat.format(Bundle.getMessage("PrintCar"), Setup.getRfidLabel()));
    JCheckBox printCarLast = new JCheckBox(Bundle.getMessage("PrintCarLastMoved"));
    JCheckBox printCarWait = new JCheckBox(Bundle.getMessage("PrintCarWait"));
    JCheckBox printCarPickup = new JCheckBox(Bundle.getMessage("PrintCarPickup"));
    JCheckBox printCarLocation = new JCheckBox(Bundle.getMessage("PrintCarLocation"));
    JCheckBox printCarTrain = new JCheckBox(Bundle.getMessage("PrintCarTrain"));
    JCheckBox printCarDestination = new JCheckBox(Bundle.getMessage("PrintCarDestination"));
    JCheckBox printCarFinalDestination = new JCheckBox(Bundle.getMessage("PrintCarFinalDestination"));
    JCheckBox printCarRWE = new JCheckBox(Bundle.getMessage("PrintCarReturnWhenEmpty"));
    JCheckBox printCarRWL = new JCheckBox(Bundle.getMessage("PrintCarReturnWhenLoaded"));
    JCheckBox printDivision = new JCheckBox(Bundle.getMessage("PrintCarDivision"));
    JCheckBox printCarStatus = new JCheckBox(Bundle.getMessage("PrintCarStatus"));
    JCheckBox printCarComment = new JCheckBox(Bundle.getMessage("PrintCarComment"));
    JCheckBox printSpace = new JCheckBox(Bundle.getMessage("PrintSpace"));
    JCheckBox printPage = new JCheckBox(Bundle.getMessage("PrintPage"));
    static final String NEW_LINE = "\n";
    private static final Logger log = LoggerFactory.getLogger(PrintCarRosterAction.class);

    public PrintCarRosterAction(boolean isPreview, CarsTableFrame pWho) {
        super(isPreview ? Bundle.getMessage("MenuItemPreview") : Bundle.getMessage("MenuItemPrint"));
        this._isPreview = isPreview;
        this.panel = pWho;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.cpof == null) {
            this.cpof = new CarPrintOptionFrame(this);
        } else {
            this.cpof.setVisible(true);
        }
        this.cpof.initComponents();
    }

    private void printCars() {
        boolean landscape = false;
        if (this.manifestOrientationComboBox.getSelectedItem() != null && this.manifestOrientationComboBox.getSelectedItem() == Setup.LANDSCAPE) {
            landscape = true;
        }
        int fontSize = (Integer)this.fontSizeComboBox.getSelectedItem();
        HardcopyWriter writer = null;
        try {
            writer = new HardcopyWriter(new Frame(), Bundle.getMessage("TitleCarRoster"), fontSize, 0.5, 0.5, 0.5, 0.5, this._isPreview, "", landscape, true, null);
        }
        catch (HardcopyWriter.PrintCanceledException printCanceledException) {
            log.debug("Print cancelled");
            return;
        }
        this.numberCharPerLine = writer.getCharactersPerLine();
        String location = "";
        String length = "";
        String weight = "";
        String color = "";
        String owner = "";
        String built = "";
        String load = "";
        String kernel = "";
        String train = "";
        String destination = "";
        String finalDestination = "";
        String returnWhenEmpty = "";
        String returnWhenLoaded = "";
        String division = "";
        String value = "";
        String rfid = "";
        String last = "";
        String wait = "";
        String schedule = "";
        String status = "";
        String comment = "";
        try {
            this.printTitleLine(writer);
            String previousLocation = null;
            List<Car> cars = this.panel.carsTableModel.getCarList(this.sortByComboBox.getSelectedIndex());
            for (Car car : cars) {
                String s;
                if (this.printCarsWithLocation.isSelected() && car.getLocation() == null) continue;
                location = "";
                destination = "";
                finalDestination = "";
                returnWhenEmpty = "";
                returnWhenLoaded = "";
                if (this.printCarLocation.isSelected()) {
                    if (car.getLocation() != null) {
                        location = String.valueOf(car.getLocationName().trim()) + " - " + car.getTrackName().trim();
                    }
                    location = this.padAttribute(location, InstanceManager.getDefault(LocationManager.class).getMaxLocationAndTrackNameLength() + 3);
                }
                if (previousLocation != null && !car.getLocationName().trim().equals(previousLocation) && this.printPage.isSelected()) {
                    writer.pageBreak();
                    this.printTitleLine(writer);
                } else if (previousLocation != null && !car.getLocationName().trim().equals(previousLocation) && this.printSpace.isSelected()) {
                    writer.write(NEW_LINE);
                }
                previousLocation = car.getLocationName().trim();
                String number = this.padAttribute(car.getNumber().trim(), Control.max_len_string_print_road_number);
                String road = this.padAttribute(car.getRoadName().trim(), InstanceManager.getDefault(CarRoads.class).getMaxNameLength());
                String type = this.padAttribute(car.getTypeName().trim(), InstanceManager.getDefault(CarTypes.class).getMaxFullNameLength());
                if (this.printCarLength.isSelected()) {
                    length = this.padAttribute(car.getLength().trim(), Control.max_len_string_length_name);
                }
                if (this.printCarWeight.isSelected()) {
                    weight = this.padAttribute(car.getWeight().trim(), Control.max_len_string_weight_name);
                }
                if (this.printCarColor.isSelected()) {
                    color = this.padAttribute(car.getColor().trim(), InstanceManager.getDefault(CarColors.class).getMaxNameLength());
                }
                if (this.printCarLoad.isSelected()) {
                    load = this.padAttribute(car.getLoadName().trim(), InstanceManager.getDefault(CarLoads.class).getMaxNameLength());
                }
                if (this.printCarKernel.isSelected()) {
                    kernel = this.padAttribute(car.getKernelName().trim(), Control.max_len_string_attibute);
                }
                if (this.printCarOwner.isSelected()) {
                    owner = this.padAttribute(car.getOwner().trim(), InstanceManager.getDefault(CarOwners.class).getMaxNameLength());
                }
                if (this.printCarBuilt.isSelected()) {
                    built = this.padAttribute(car.getBuilt().trim(), Control.max_len_string_built_name);
                }
                if (this.printCarLast.isSelected()) {
                    last = this.padAttribute(car.getLastDate().split(" ")[0], 10);
                }
                if (this.printCarWait.isSelected()) {
                    wait = this.padAttribute(Integer.toString(car.getWait()), 4);
                }
                if (this.printCarPickup.isSelected()) {
                    schedule = this.padAttribute(car.getPickupScheduleName(), 10);
                }
                if (this.printCarValue.isSelected()) {
                    value = this.padAttribute(car.getValue().trim(), Control.max_len_string_attibute);
                }
                if (this.printCarRfid.isSelected()) {
                    rfid = this.padAttribute(car.getRfid().trim(), Control.max_len_string_attibute);
                }
                if (this.printCarTrain.isSelected()) {
                    train = this.padAttribute(car.getTrainName().trim(), Control.max_len_string_train_name / 2);
                }
                if (this.printCarDestination.isSelected()) {
                    if (car.getDestination() != null) {
                        destination = String.valueOf(car.getDestinationName().trim()) + " - " + car.getDestinationTrackName().trim();
                    }
                    destination = this.padAttribute(destination, InstanceManager.getDefault(LocationManager.class).getMaxLocationAndTrackNameLength() + 3);
                }
                if (this.printCarFinalDestination.isSelected()) {
                    if (car.getFinalDestination() != null) {
                        finalDestination = String.valueOf(car.getFinalDestinationName().trim()) + " - " + car.getFinalDestinationTrackName().trim();
                    }
                    finalDestination = this.padAttribute(finalDestination, InstanceManager.getDefault(LocationManager.class).getMaxLocationAndTrackNameLength() + 3);
                }
                if (this.printCarRWE.isSelected()) {
                    if (car.getReturnWhenEmptyDestination() != null) {
                        returnWhenEmpty = String.valueOf(car.getReturnWhenEmptyDestinationName().trim()) + " - " + car.getReturnWhenEmptyDestTrackName().trim();
                    }
                    returnWhenEmpty = this.padAttribute(returnWhenEmpty, InstanceManager.getDefault(LocationManager.class).getMaxLocationAndTrackNameLength() + 3);
                }
                if (this.printCarRWL.isSelected()) {
                    if (car.getReturnWhenLoadedDestination() != null) {
                        returnWhenLoaded = String.valueOf(car.getReturnWhenLoadedDestinationName().trim()) + " - " + car.getReturnWhenLoadedDestTrackName().trim();
                    }
                    returnWhenLoaded = this.padAttribute(returnWhenLoaded, InstanceManager.getDefault(LocationManager.class).getMaxLocationAndTrackNameLength() + 3);
                }
                if (this.printDivision.isSelected()) {
                    division = this.padAttribute(car.getDivisionName(), Bundle.getMessage("HomeDivision").length());
                }
                if (this.printCarStatus.isSelected()) {
                    status = this.padAttribute(car.getStatus(), Bundle.getMessage("Status").length());
                }
                if (this.printCarComment.isSelected()) {
                    comment = car.getComment().trim();
                }
                if ((s = String.valueOf(number) + road + type + length + weight + color + load + kernel + owner + built + last + wait + schedule + value + rfid + location + train + destination + finalDestination + returnWhenEmpty + returnWhenLoaded + division + status + comment).length() > this.numberCharPerLine) {
                    s = s.substring(0, this.numberCharPerLine);
                }
                writer.write(String.valueOf(s) + NEW_LINE);
            }
            writer.close();
        }
        catch (IOException iOException) {
            log.error("Error printing car roster");
        }
    }

    private void printTitleLine(HardcopyWriter writer) throws IOException {
        String s = String.valueOf(this.padAttribute(Bundle.getMessage("Number"), Control.max_len_string_print_road_number)) + this.padAttribute(Bundle.getMessage("Road"), InstanceManager.getDefault(CarRoads.class).getMaxNameLength()) + this.padAttribute(Bundle.getMessage("Type"), InstanceManager.getDefault(CarTypes.class).getMaxFullNameLength()) + (this.printCarLength.isSelected() ? String.valueOf(Bundle.getMessage("Len")) + "  " : "") + (this.printCarWeight.isSelected() ? "     " : "") + (this.printCarColor.isSelected() ? this.padAttribute(Bundle.getMessage("Color"), InstanceManager.getDefault(CarColors.class).getMaxNameLength()) : "") + (this.printCarLoad.isSelected() ? this.padAttribute(Bundle.getMessage("Load"), InstanceManager.getDefault(CarLoads.class).getMaxNameLength()) : "") + (this.printCarKernel.isSelected() ? this.padAttribute("Kernel", Control.max_len_string_attibute) : "") + (this.printCarOwner.isSelected() ? this.padAttribute(Bundle.getMessage("Owner"), InstanceManager.getDefault(CarOwners.class).getMaxNameLength()) : "") + (this.printCarBuilt.isSelected() ? String.valueOf(Bundle.getMessage("Built")) + " " : "") + (this.printCarLast.isSelected() ? String.valueOf(Bundle.getMessage("LastMoved")) + " " : "") + (this.printCarWait.isSelected() ? String.valueOf(Bundle.getMessage("Wait")) + " " : "") + (this.printCarPickup.isSelected() ? this.padAttribute(Bundle.getMessage("Pickup"), 10) : "") + (this.printCarValue.isSelected() ? this.padAttribute(Setup.getValueLabel(), Control.max_len_string_attibute) : "") + (this.printCarRfid.isSelected() ? this.padAttribute(Setup.getRfidLabel(), Control.max_len_string_attibute) : "") + (this.printCarLocation.isSelected() ? this.padAttribute(Bundle.getMessage("Location"), InstanceManager.getDefault(LocationManager.class).getMaxLocationAndTrackNameLength() + 3) : "") + (this.printCarTrain.isSelected() ? this.padAttribute(Bundle.getMessage("Train"), Control.max_len_string_train_name / 2) : "") + (this.printCarDestination.isSelected() ? this.padAttribute(Bundle.getMessage("Destination"), InstanceManager.getDefault(LocationManager.class).getMaxLocationAndTrackNameLength() + 3) : "") + (this.printCarFinalDestination.isSelected() ? this.padAttribute(Bundle.getMessage("FinalDestination"), InstanceManager.getDefault(LocationManager.class).getMaxLocationAndTrackNameLength() + 3) : "") + (this.printCarRWE.isSelected() ? this.padAttribute(Bundle.getMessage("ReturnWhenEmpty"), InstanceManager.getDefault(LocationManager.class).getMaxLocationAndTrackNameLength() + 3) : "") + (this.printCarRWL.isSelected() ? this.padAttribute(Bundle.getMessage("ReturnWhenLoaded"), InstanceManager.getDefault(LocationManager.class).getMaxLocationAndTrackNameLength() + 3) : "") + (this.printDivision.isSelected() ? String.valueOf(Bundle.getMessage("HomeDivision")) + " " : "") + (this.printCarStatus.isSelected() ? String.valueOf(Bundle.getMessage("Status")) + " " : "") + (this.printCarComment.isSelected() ? Bundle.getMessage("Comment") : "");
        if (s.length() > this.numberCharPerLine) {
            s = s.substring(0, this.numberCharPerLine);
        }
        writer.write(String.valueOf(s) + NEW_LINE);
    }

    private String padAttribute(String attribute, int length) {
        if (attribute.length() > length) {
            attribute = attribute.substring(0, length);
        }
        StringBuffer buf = new StringBuffer(attribute);
        int i = attribute.length();
        while (i < length + 1) {
            buf.append(" ");
            ++i;
        }
        return buf.toString();
    }

    public class CarPrintOptionFrame
    extends OperationsFrame {
        PrintCarRosterAction pcr;
        JButton okayButton = new JButton(Bundle.getMessage("ButtonOK"));

        public CarPrintOptionFrame(PrintCarRosterAction pcr) {
            this.pcr = pcr;
            JPanel pSortBy = new JPanel();
            pSortBy.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("SortBy")));
            pSortBy.add(PrintCarRosterAction.this.sortByComboBox);
            this.addComboBoxAction(PrintCarRosterAction.this.sortByComboBox);
            JPanel pOrientation = new JPanel();
            pOrientation.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("BorderLayoutOrientation")));
            pOrientation.add(PrintCarRosterAction.this.manifestOrientationComboBox);
            PrintCarRosterAction.this.manifestOrientationComboBox.addItem(Setup.PORTRAIT);
            PrintCarRosterAction.this.manifestOrientationComboBox.addItem(Setup.LANDSCAPE);
            JPanel pFontSize = new JPanel();
            pFontSize.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("BorderLayoutFontSize")));
            pFontSize.add(PrintCarRosterAction.this.fontSizeComboBox);
            OperationsPanel.loadFontSizeComboBox(PrintCarRosterAction.this.fontSizeComboBox);
            PrintCarRosterAction.this.fontSizeComboBox.setSelectedItem(Control.reportFontSize);
            JPanel pPanel = new JPanel();
            pPanel.setLayout(new GridBagLayout());
            JScrollPane panePanel = new JScrollPane(pPanel);
            panePanel.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("PrintOptions")));
            this.addItemLeft(pPanel, PrintCarRosterAction.this.printCarsWithLocation, 0, 0);
            this.addItemLeft(pPanel, PrintCarRosterAction.this.printCarLength, 0, 1);
            this.addItemLeft(pPanel, PrintCarRosterAction.this.printCarWeight, 0, 2);
            this.addItemLeft(pPanel, PrintCarRosterAction.this.printCarColor, 0, 3);
            this.addItemLeft(pPanel, PrintCarRosterAction.this.printCarLoad, 0, 4);
            this.addItemLeft(pPanel, PrintCarRosterAction.this.printCarKernel, 0, 5);
            this.addItemLeft(pPanel, PrintCarRosterAction.this.printCarOwner, 0, 6);
            this.addItemLeft(pPanel, PrintCarRosterAction.this.printCarBuilt, 0, 7);
            this.addItemLeft(pPanel, PrintCarRosterAction.this.printCarLast, 0, 8);
            this.addItemLeft(pPanel, PrintCarRosterAction.this.printCarWait, 0, 9);
            this.addItemLeft(pPanel, PrintCarRosterAction.this.printCarPickup, 0, 10);
            if (Setup.isValueEnabled()) {
                this.addItemLeft(pPanel, PrintCarRosterAction.this.printCarValue, 0, 11);
            }
            if (Setup.isRfidEnabled()) {
                this.addItemLeft(pPanel, PrintCarRosterAction.this.printCarRfid, 0, 12);
            }
            this.addItemLeft(pPanel, PrintCarRosterAction.this.printCarLocation, 0, 13);
            this.addItemLeft(pPanel, PrintCarRosterAction.this.printCarTrain, 0, 14);
            this.addItemLeft(pPanel, PrintCarRosterAction.this.printCarDestination, 0, 15);
            this.addItemLeft(pPanel, PrintCarRosterAction.this.printCarFinalDestination, 0, 16);
            this.addItemLeft(pPanel, PrintCarRosterAction.this.printCarRWE, 0, 17);
            this.addItemLeft(pPanel, PrintCarRosterAction.this.printCarRWL, 0, 18);
            this.addItemLeft(pPanel, PrintCarRosterAction.this.printDivision, 0, 19);
            this.addItemLeft(pPanel, PrintCarRosterAction.this.printCarStatus, 0, 20);
            this.addItemLeft(pPanel, PrintCarRosterAction.this.printCarComment, 0, 21);
            this.addItemLeft(pPanel, PrintCarRosterAction.this.printSpace, 0, 22);
            this.addItemLeft(pPanel, PrintCarRosterAction.this.printPage, 0, 23);
            PrintCarRosterAction.this.printCarsWithLocation.setSelected(false);
            PrintCarRosterAction.this.printCarLength.setSelected(true);
            PrintCarRosterAction.this.printCarWeight.setSelected(false);
            PrintCarRosterAction.this.printCarColor.setSelected(true);
            PrintCarRosterAction.this.printCarLoad.setSelected(false);
            PrintCarRosterAction.this.printCarKernel.setSelected(false);
            PrintCarRosterAction.this.printCarOwner.setSelected(false);
            PrintCarRosterAction.this.printCarBuilt.setSelected(false);
            PrintCarRosterAction.this.printCarLast.setSelected(false);
            PrintCarRosterAction.this.printCarWait.setSelected(false);
            PrintCarRosterAction.this.printCarPickup.setSelected(false);
            PrintCarRosterAction.this.printCarValue.setSelected(false);
            PrintCarRosterAction.this.printCarRfid.setSelected(false);
            PrintCarRosterAction.this.printCarLocation.setSelected(true);
            PrintCarRosterAction.this.printCarTrain.setSelected(false);
            PrintCarRosterAction.this.printCarDestination.setSelected(false);
            PrintCarRosterAction.this.printCarFinalDestination.setSelected(false);
            PrintCarRosterAction.this.printCarRWE.setSelected(false);
            PrintCarRosterAction.this.printCarRWL.setSelected(false);
            PrintCarRosterAction.this.printDivision.setSelected(false);
            PrintCarRosterAction.this.printCarStatus.setSelected(false);
            PrintCarRosterAction.this.printCarComment.setSelected(false);
            PrintCarRosterAction.this.printSpace.setSelected(false);
            PrintCarRosterAction.this.printPage.setSelected(false);
            PrintCarRosterAction.this.printSpace.setToolTipText(Bundle.getMessage("TipSelectSortByLoc"));
            PrintCarRosterAction.this.printPage.setToolTipText(Bundle.getMessage("TipSelectSortByLoc"));
            JPanel pButtons = new JPanel();
            pButtons.setLayout(new GridBagLayout());
            pButtons.add(this.okayButton);
            pButtons.setBorder(BorderFactory.createTitledBorder(""));
            this.addButtonAction(this.okayButton);
            this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
            this.getContentPane().add(pSortBy);
            this.getContentPane().add(pOrientation);
            this.getContentPane().add(pFontSize);
            this.getContentPane().add(panePanel);
            this.getContentPane().add(pButtons);
            this.initMinimumSize(new Dimension(300, 500));
        }

        @Override
        public void initComponents() {
            if (PrintCarRosterAction.this._isPreview) {
                this.setTitle(Bundle.getMessage("MenuItemPreview"));
            } else {
                this.setTitle(Bundle.getMessage("MenuItemPrint"));
            }
            this.loadSortByComboBox(PrintCarRosterAction.this.sortByComboBox);
            this.updateLocationCheckboxes();
        }

        private void loadSortByComboBox(JComboBox<String> box) {
            box.removeAllItems();
            int i = PrintCarRosterAction.this.panel.carsTableModel.SORTBY_NUMBER;
            while (i <= PrintCarRosterAction.this.panel.carsTableModel.SORTBY_LAST) {
                box.addItem(PrintCarRosterAction.this.panel.carsTableModel.getSortByName(i));
                ++i;
            }
            box.setSelectedItem(PrintCarRosterAction.this.panel.carsTableModel.getSortByName());
        }

        @Override
        public void buttonActionPerformed(ActionEvent ae) {
            this.setVisible(false);
            this.pcr.printCars();
        }

        @Override
        public void comboBoxActionPerformed(ActionEvent ae) {
            this.updateLocationCheckboxes();
        }

        private void updateLocationCheckboxes() {
            if (PrintCarRosterAction.this.sortByComboBox.getSelectedItem() != null && PrintCarRosterAction.this.sortByComboBox.getSelectedItem().equals(PrintCarRosterAction.this.panel.carsTableModel.getSortByName(PrintCarRosterAction.this.panel.carsTableModel.SORTBY_LOCATION))) {
                PrintCarRosterAction.this.printSpace.setEnabled(true);
                PrintCarRosterAction.this.printPage.setEnabled(true);
            } else {
                PrintCarRosterAction.this.printSpace.setEnabled(false);
                PrintCarRosterAction.this.printPage.setEnabled(false);
                PrintCarRosterAction.this.printSpace.setSelected(false);
                PrintCarRosterAction.this.printPage.setSelected(false);
            }
        }
    }
}

