/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.operations.rollingstock.cars.tools;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import javax.swing.JOptionPane;
import jmri.IdTagManager;
import jmri.InstanceManager;
import jmri.jmrit.operations.locations.Location;
import jmri.jmrit.operations.locations.LocationManager;
import jmri.jmrit.operations.locations.Track;
import jmri.jmrit.operations.rollingstock.ImportRollingStock;
import jmri.jmrit.operations.rollingstock.cars.Car;
import jmri.jmrit.operations.rollingstock.cars.CarColors;
import jmri.jmrit.operations.rollingstock.cars.CarLengths;
import jmri.jmrit.operations.rollingstock.cars.CarLoads;
import jmri.jmrit.operations.rollingstock.cars.CarManager;
import jmri.jmrit.operations.rollingstock.cars.CarOwners;
import jmri.jmrit.operations.rollingstock.cars.CarRoads;
import jmri.jmrit.operations.rollingstock.cars.CarTypes;
import jmri.jmrit.operations.rollingstock.cars.Kernel;
import jmri.jmrit.operations.rollingstock.cars.KernelManager;
import jmri.jmrit.operations.rollingstock.cars.tools.Bundle;
import jmri.jmrit.operations.setup.Control;
import jmri.jmrit.operations.setup.Setup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImportCars
extends ImportRollingStock {
    CarManager carManager = InstanceManager.getDefault(CarManager.class);
    private int weightResults = 1;
    private boolean autoCalculate = true;
    private boolean askAutoCreateTypes = true;
    private boolean askAutoCreateLocations = true;
    private boolean askAutoCreateTracks = true;
    private boolean askAutoLocationType = true;
    private boolean askAutoIncreaseTrackLength = true;
    private boolean askAutoForceCar = true;
    private boolean autoCreateTypes = false;
    private boolean autoCreateLocations = false;
    private boolean autoCreateTracks = false;
    private boolean autoAdjustLocationType = false;
    private boolean autoAdjustTrackLength = false;
    private boolean autoForceCar = false;
    private final boolean autoCreateRoads = true;
    private final boolean autoCreateLengths = true;
    private final boolean autoCreateColors = true;
    private final boolean autoCreateOwners = true;
    private static final int CAR_NUMBER = 0;
    private static final int CAR_ROAD = 1;
    private static final int CAR_TYPE = 2;
    private static final int CAR_LENGTH = 3;
    private static final int CAR_WEIGHT = 4;
    private static final int CAR_COLOR = 5;
    private static final int CAR_OWNER = 6;
    private static final int CAR_BUILT = 7;
    private static final int CAR_LOCATION = 8;
    private static final int CAR_LOCATION_TRACK_SEPARATOR = 9;
    private static final int CAR_TRACK = 10;
    private static final int CAR_LOAD = 11;
    private static final int CAR_KERNEL = 12;
    private static final int CAR_MOVES = 13;
    private static final int CAR_VALUE = 14;
    private static final int CAR_COMMENT = 15;
    private static final int CAR_MISCELLANEOUS = 16;
    private static final int CAR_EXTENSIONS = 17;
    private static final int CAR_RFID_TAG = 37;
    private static final Logger log = LoggerFactory.getLogger(ImportCars.class);

    @Override
    public void run() {
        int carsAdded;
        boolean importOkay;
        BufferedReader in;
        block108: {
            File file = this.getFile();
            if (file == null) {
                return;
            }
            in = this.getBufferedReader(file);
            if (in == null) {
                return;
            }
            this.createStatusFrame(Bundle.getMessage("ImportCars"));
            importOkay = false;
            boolean comma = false;
            boolean importKernel = false;
            int lineNum = 0;
            carsAdded = 0;
            String line = " ";
            String carColor = "";
            String carOwner = "";
            String carBuilt = "";
            String carLocationName = "";
            String carTrackName = "";
            String carLoadName = "";
            String carKernelName = "";
            int carMoves = 0;
            String carValue = "";
            String carComment = "";
            if (file.getAbsolutePath().endsWith(".csv")) {
                log.info("Using comma as delimiter for import cars");
                comma = true;
            }
            while (true) {
                String carRoad;
                String carNumber;
                this.lineNumber.setText(String.valueOf(Bundle.getMessage("LineNumber")) + " " + Integer.toString(++lineNum));
                try {
                    line = in.readLine();
                }
                catch (IOException iOException) {
                    break block108;
                }
                if (line == null) {
                    importOkay = true;
                    break block108;
                }
                if (!this.fstatus.isShowing()) break block108;
                line = line.trim();
                log.debug("Import: {}", (Object)line);
                this.importLine.setText(line);
                if (line.startsWith(Bundle.getMessage("Number"))) continue;
                if (line.equalsIgnoreCase("kernel")) {
                    log.info("Importing kernel names");
                    importKernel = true;
                    continue;
                }
                if (line.equalsIgnoreCase("comma")) {
                    log.info("Using comma as delimiter for import cars");
                    comma = true;
                    continue;
                }
                String[] inputLine = comma ? this.parseCommaLine(line) : line.split("\\s+");
                if (inputLine.length < 1 || line.isEmpty()) {
                    log.debug("Skipping blank line");
                    continue;
                }
                int base = 1;
                if (comma || !inputLine[0].isEmpty()) {
                    --base;
                }
                if (inputLine.length > base + 3) {
                    String status;
                    String newTag;
                    int results;
                    Car existingCar;
                    carNumber = inputLine[base + 0];
                    carRoad = inputLine[base + 1];
                    String carType = inputLine[base + 2];
                    String carLength = inputLine[base + 3];
                    String carWeight = "0";
                    carColor = "";
                    carOwner = "";
                    carBuilt = "";
                    carLocationName = "";
                    carTrackName = "";
                    carLoadName = InstanceManager.getDefault(CarLoads.class).getDefaultEmptyName();
                    carKernelName = "";
                    carMoves = 0;
                    carValue = "";
                    carComment = "";
                    if (inputLine.length > base + 4) {
                        carWeight = inputLine[base + 4];
                    }
                    if (inputLine.length > base + 5) {
                        carColor = inputLine[base + 5];
                    }
                    log.debug("Checking car number ({}) road ({}) type ({}) length ({}) weight ({}) color ({})", new Object[]{carNumber, carRoad, carType, carLength, carWeight, carColor});
                    if (carNumber.trim().isEmpty()) {
                        log.info("Import line {} missing car number", (Object)lineNum);
                        break block108;
                    }
                    if (carRoad.trim().isEmpty()) {
                        log.info("Import line {} missing car road", (Object)lineNum);
                        break block108;
                    }
                    if (carType.trim().isEmpty()) {
                        log.info("Import line {} missing car type", (Object)lineNum);
                        break block108;
                    }
                    if (carLength.trim().isEmpty()) {
                        log.info("Import line {} missing car length", (Object)lineNum);
                        break block108;
                    }
                    if (carNumber.length() > Control.max_len_string_road_number) {
                        JOptionPane.showMessageDialog(null, MessageFormat.format(Bundle.getMessage("CarRoadNumberTooLong"), String.valueOf(carRoad) + " " + carNumber, carNumber), MessageFormat.format(Bundle.getMessage("RoadNumMustBeLess"), Control.max_len_string_road_number + 1), 0);
                        break block108;
                    }
                    if (carRoad.length() > Control.max_len_string_attibute) {
                        JOptionPane.showMessageDialog(null, MessageFormat.format(Bundle.getMessage("CarRoadNameTooLong"), String.valueOf(carRoad) + " " + carNumber, carRoad), MessageFormat.format(Bundle.getMessage("carAttribute"), Control.max_len_string_attibute), 0);
                        break block108;
                    }
                    if (carType.length() > Control.max_len_string_attibute) {
                        JOptionPane.showMessageDialog(null, MessageFormat.format(Bundle.getMessage("CarTypeNameTooLong"), String.valueOf(carRoad) + " " + carNumber, carType), MessageFormat.format(Bundle.getMessage("carAttribute"), Control.max_len_string_attibute), 0);
                        break block108;
                    }
                    if (!InstanceManager.getDefault(CarTypes.class).containsName(carType)) {
                        if (this.autoCreateTypes) {
                            log.debug("Adding car type ({})", (Object)carType);
                            InstanceManager.getDefault(CarTypes.class).addName(carType);
                        } else {
                            int results2 = JOptionPane.showConfirmDialog(null, String.valueOf(Bundle.getMessage("Car")) + " (" + carRoad + " " + carNumber + ")" + "\n" + MessageFormat.format(Bundle.getMessage("typeNameNotExist"), carType), Bundle.getMessage("carAddType"), 1);
                            if (results2 == 0) {
                                InstanceManager.getDefault(CarTypes.class).addName(carType);
                                if (this.askAutoCreateTypes && (results2 = JOptionPane.showConfirmDialog(null, Bundle.getMessage("DoYouWantToAutoAddCarTypes"), Bundle.getMessage("OnlyAskedOnce"), 0)) == 0) {
                                    this.autoCreateTypes = true;
                                }
                                this.askAutoCreateTypes = false;
                            } else if (results2 == 2) break block108;
                        }
                    }
                    if (carLength.length() > Control.max_len_string_length_name) {
                        JOptionPane.showMessageDialog(null, MessageFormat.format(Bundle.getMessage("CarLengthNameTooLong"), String.valueOf(carRoad) + " " + carNumber, carLength), MessageFormat.format(Bundle.getMessage("carAttribute"), Control.max_len_string_length_name), 0);
                        break block108;
                    }
                    if (carLength.isEmpty()) {
                        log.debug("Car ({} {}) length not specified", (Object)carRoad, (Object)carNumber);
                        JOptionPane.showMessageDialog(null, MessageFormat.format(Bundle.getMessage("CarLengthNotSpecified"), String.valueOf(carRoad) + " " + carNumber), Bundle.getMessage("CarLengthMissing"), 0);
                        break block108;
                    }
                    try {
                        Integer.parseInt(carLength);
                    }
                    catch (NumberFormatException numberFormatException) {
                        JOptionPane.showMessageDialog(null, MessageFormat.format(Bundle.getMessage("CarLengthNameNotNumber"), String.valueOf(carRoad) + " " + carNumber, carLength), Bundle.getMessage("CarLengthMissing"), 0);
                        break block108;
                    }
                    if (carWeight.length() > Control.max_len_string_weight_name) {
                        JOptionPane.showMessageDialog(null, MessageFormat.format(Bundle.getMessage("CarWeightNameTooLong"), String.valueOf(carRoad) + " " + carNumber, carWeight), MessageFormat.format(Bundle.getMessage("carAttribute"), Control.max_len_string_weight_name), 0);
                        break block108;
                    }
                    if (carColor.length() > Control.max_len_string_attibute) {
                        JOptionPane.showMessageDialog(null, MessageFormat.format(Bundle.getMessage("CarColorNameTooLong"), String.valueOf(carRoad) + " " + carNumber, carColor), MessageFormat.format(Bundle.getMessage("carAttribute"), Control.max_len_string_attibute), 0);
                        break block108;
                    }
                    if (carWeight.equals("0")) {
                        try {
                            carWeight = CarManager.calculateCarWeight(carLength);
                        }
                        catch (NumberFormatException numberFormatException) {
                            JOptionPane.showMessageDialog(null, Bundle.getMessage("carLengthMustBe"), Bundle.getMessage("carWeigthCanNot"), 0);
                        }
                    }
                    if ((existingCar = (Car)this.carManager.getByRoadAndNumber(carRoad, carNumber)) != null) {
                        log.info("Can not add, car number ({}) road ({}) already exists!", (Object)carNumber, (Object)carRoad);
                        continue;
                    }
                    if (inputLine.length > base + 6 && (carOwner = inputLine[base + 6]).length() > Control.max_len_string_attibute) {
                        JOptionPane.showMessageDialog(null, MessageFormat.format(Bundle.getMessage("CarOwnerNameTooLong"), String.valueOf(carRoad) + " " + carNumber, carOwner), MessageFormat.format(Bundle.getMessage("carAttribute"), Control.max_len_string_attibute), 0);
                        break block108;
                    }
                    if (inputLine.length > base + 7 && (carBuilt = inputLine[base + 7]).length() > Control.max_len_string_built_name) {
                        JOptionPane.showMessageDialog(null, MessageFormat.format(Bundle.getMessage("CarBuiltNameTooLong"), String.valueOf(carRoad) + " " + carNumber, carBuilt), MessageFormat.format(Bundle.getMessage("carAttribute"), Control.max_len_string_built_name), 0);
                        break block108;
                    }
                    if (inputLine.length > base + 8) {
                        carLocationName = inputLine[base + 8];
                    }
                    if (comma && inputLine.length > base + 10) {
                        carTrackName = inputLine[base + 10];
                    }
                    if (!comma) {
                        int j = 0;
                        StringBuffer name = new StringBuffer(carLocationName);
                        int i = base + 9;
                        while (i < inputLine.length) {
                            if (inputLine[i].equals("-")) {
                                j = i + 1;
                                break;
                            }
                            name.append(" " + inputLine[i]);
                            ++i;
                        }
                        carLocationName = name.toString();
                        log.debug("Car ({} {}) has location ({})", new Object[]{carRoad, carNumber, carLocationName});
                        name = new StringBuffer();
                        if (j != 0 && j < inputLine.length) {
                            name.append(inputLine[j]);
                            i = j + 1;
                            while (i < inputLine.length) {
                                name.append(" " + inputLine[i]);
                                ++i;
                            }
                            log.debug("Car ({} {}) has track ({})", new Object[]{carRoad, carNumber, carTrackName});
                        }
                        carTrackName = name.toString();
                    }
                    if (comma && inputLine.length > base + 11) {
                        carLoadName = inputLine[11];
                        log.debug("Car ({} {}) has load ({})", new Object[]{carRoad, carNumber, carLoadName});
                    }
                    if (comma && inputLine.length > base + 12) {
                        carKernelName = inputLine[12];
                        log.debug("Car ({} {}) has kernel name ({})", new Object[]{carRoad, carNumber, carKernelName});
                    }
                    if (comma && inputLine.length > base + 13 && !inputLine[13].trim().isEmpty()) {
                        try {
                            carMoves = Integer.parseInt(inputLine[13]);
                            log.debug("Car ({} {}) has move count ({})", new Object[]{carRoad, carNumber, carMoves});
                        }
                        catch (NumberFormatException numberFormatException) {
                            log.error("Car ({} {}) has move count ({}) not a number", new Object[]{carRoad, carNumber, carMoves});
                        }
                    }
                    if (comma && inputLine.length > base + 14) {
                        carValue = inputLine[14];
                    }
                    if (comma && inputLine.length > base + 15) {
                        carComment = inputLine[15];
                    }
                    if (carLocationName.length() > Control.max_len_string_location_name) {
                        JOptionPane.showMessageDialog(null, MessageFormat.format(Bundle.getMessage("CarLocationNameTooLong"), String.valueOf(carRoad) + " " + carNumber, carLocationName), MessageFormat.format(Bundle.getMessage("carAttribute"), Control.max_len_string_location_name), 0);
                        break block108;
                    }
                    if (carTrackName.length() > Control.max_len_string_track_name) {
                        JOptionPane.showMessageDialog(null, MessageFormat.format(Bundle.getMessage("CarTrackNameTooLong"), String.valueOf(carRoad) + " " + carNumber, carTrackName), MessageFormat.format(Bundle.getMessage("carAttribute"), Control.max_len_string_track_name), 0);
                        break block108;
                    }
                    Location location = InstanceManager.getDefault(LocationManager.class).getLocationByName(carLocationName);
                    Track track = null;
                    if (location == null && !carLocationName.isEmpty()) {
                        if (this.autoCreateLocations) {
                            log.debug("Create location ({})", (Object)carLocationName);
                            location = InstanceManager.getDefault(LocationManager.class).newLocation(carLocationName);
                        } else {
                            JOptionPane.showMessageDialog(null, MessageFormat.format(Bundle.getMessage("CarLocationDoesNotExist"), String.valueOf(carRoad) + " " + carNumber, carLocationName), Bundle.getMessage("carLocation"), 0);
                            results = JOptionPane.showConfirmDialog(null, MessageFormat.format(Bundle.getMessage("DoYouWantToCreateLoc"), carLocationName), Bundle.getMessage("carLocation"), 0);
                            if (results != 0) break block108;
                            log.debug("Create location ({})", (Object)carLocationName);
                            location = InstanceManager.getDefault(LocationManager.class).newLocation(carLocationName);
                            if (this.askAutoCreateLocations && (results = JOptionPane.showConfirmDialog(null, Bundle.getMessage("DoYouWantToAutoCreateLoc"), Bundle.getMessage("OnlyAskedOnce"), 0)) == 0) {
                                this.autoCreateLocations = true;
                            }
                            this.askAutoCreateLocations = false;
                        }
                    }
                    if (location != null && !carTrackName.isEmpty() && (track = location.getTrackByName(carTrackName, null)) == null) {
                        if (this.autoCreateTracks) {
                            if (!location.isStaging()) {
                                log.debug("Create 1000 foot yard track ({})", (Object)carTrackName);
                                track = location.addTrack(carTrackName, "Yard");
                            } else {
                                log.debug("Create 1000 foot staging track ({})", (Object)carTrackName);
                                track = location.addTrack(carTrackName, "Staging");
                            }
                            track.setLength(1000);
                        } else {
                            JOptionPane.showMessageDialog(null, MessageFormat.format(Bundle.getMessage("CarTrackDoesNotExist"), String.valueOf(carRoad) + " " + carNumber, carTrackName, carLocationName), Bundle.getMessage("carTrack"), 0);
                            results = JOptionPane.showConfirmDialog(null, MessageFormat.format(Bundle.getMessage("DoYouWantToCreateTrack"), carTrackName, carLocationName), Bundle.getMessage("carTrack"), 0);
                            if (results != 0) break block108;
                            if (!location.isStaging()) {
                                log.debug("Create 1000 foot yard track ({})", (Object)carTrackName);
                                track = location.addTrack(carTrackName, "Yard");
                            } else {
                                log.debug("Create 1000 foot staging track ({})", (Object)carTrackName);
                                track = location.addTrack(carTrackName, "Staging");
                            }
                            track.setLength(1000);
                            if (this.askAutoCreateTracks) {
                                results = JOptionPane.showConfirmDialog(null, Bundle.getMessage("DoYouWantToAutoCreateTrack"), Bundle.getMessage("OnlyAskedOnce"), 0);
                                if (results == 0) {
                                    this.autoCreateTracks = true;
                                }
                                this.askAutoCreateTracks = false;
                            }
                        }
                    }
                    log.debug("Add car ({} {}) owner ({}) built ({}) location ({}, {})", new Object[]{carRoad, carNumber, carOwner, carBuilt, carLocationName, carTrackName});
                    Car car = this.carManager.newRS(carRoad, carNumber);
                    car.setTypeName(carType);
                    car.setLength(carLength);
                    car.setWeight(carWeight);
                    car.setColor(carColor);
                    car.setOwner(carOwner);
                    car.setBuilt(carBuilt);
                    car.setLoadName(carLoadName);
                    car.setKernel(InstanceManager.getDefault(KernelManager.class).newKernel(carKernelName));
                    car.setMoves(carMoves);
                    car.setValue(carValue);
                    car.setComment(carComment);
                    ++carsAdded;
                    if (comma && inputLine.length > base + 16) {
                        car.setOutOfService(inputLine[16].equals(Bundle.getMessage("OutOfService")));
                    }
                    car.setCaboose(carType.equals("Caboose"));
                    if (comma && inputLine.length > base + 17) {
                        String extensions = inputLine[17];
                        log.debug("Car ({}) has extension ({})", (Object)car.toString(), (Object)extensions);
                        String[] ext = extensions.split(" ");
                        int i = 0;
                        while (i < ext.length) {
                            if (ext[i].equals(Car.CABOOSE_EXTENSION)) {
                                car.setCaboose(true);
                            }
                            if (ext[i].equals(Car.FRED_EXTENSION)) {
                                car.setFred(true);
                            }
                            if (ext[i].equals(Car.PASSENGER_EXTENSION)) {
                                car.setPassenger(true);
                                car.setBlocking(Integer.parseInt(ext[i + 1]));
                            }
                            if (ext[i].equals(Car.UTILITY_EXTENSION)) {
                                car.setUtility(true);
                            }
                            if (ext[i].equals(Car.HAZARDOUS_EXTENSION)) {
                                car.setHazardous(true);
                            }
                            ++i;
                        }
                    }
                    if (comma && inputLine.length > base + 37 && !(newTag = inputLine[37]).trim().isEmpty()) {
                        InstanceManager.getDefault(IdTagManager.class).provideIdTag(newTag);
                        log.debug("New ID tag added - {}", (Object)newTag);
                        car.setRfid(newTag);
                    }
                    if (!InstanceManager.getDefault(CarRoads.class).containsName(carRoad)) {
                        log.debug("add car road {}", (Object)carRoad);
                        InstanceManager.getDefault(CarRoads.class).addName(carRoad);
                    }
                    if (!InstanceManager.getDefault(CarLengths.class).containsName(carLength)) {
                        log.debug("add car length {}", (Object)carLength);
                        InstanceManager.getDefault(CarLengths.class).addName(carLength);
                    }
                    if (!InstanceManager.getDefault(CarColors.class).containsName(carColor)) {
                        log.debug("add car color {}", (Object)carColor);
                        InstanceManager.getDefault(CarColors.class).addName(carColor);
                    }
                    if (!InstanceManager.getDefault(CarOwners.class).containsName(carOwner)) {
                        log.debug("add car owner {}", (Object)carOwner);
                        InstanceManager.getDefault(CarOwners.class).addName(carOwner);
                    }
                    if (car.getWeight().isEmpty()) {
                        log.debug("Car ({}) weight not specified", (Object)car.toString());
                        if (this.weightResults != 2) {
                            this.weightResults = JOptionPane.showOptionDialog(null, MessageFormat.format(Bundle.getMessage("CarWeightNotFound"), car.toString()), Bundle.getMessage("CarWeightMissing"), 1, 1, null, new Object[]{Bundle.getMessage("ButtonYes"), Bundle.getMessage("ButtonNo"), Bundle.getMessage("ButtonDontShow")}, this.autoCalculate ? Bundle.getMessage("ButtonYes") : Bundle.getMessage("ButtonNo"));
                        }
                        if (this.weightResults == 1) {
                            this.autoCalculate = false;
                        }
                        if (this.weightResults == 0 || this.autoCalculate && this.weightResults == 2) {
                            this.autoCalculate = true;
                            try {
                                carWeight = CarManager.calculateCarWeight(carLength);
                                car.setWeight(carWeight);
                                int tons = (int)(Double.parseDouble(carWeight) * (double)Setup.getScaleTonRatio());
                                if (car.isCaboose() || car.isPassenger()) {
                                    tons = (int)(Double.parseDouble(car.getLength()) * 0.9);
                                }
                                car.setWeightTons(Integer.toString(tons));
                            }
                            catch (NumberFormatException numberFormatException) {
                                JOptionPane.showMessageDialog(null, Bundle.getMessage("carLengthMustBe"), Bundle.getMessage("carWeigthCanNot"), 0);
                            }
                        }
                    }
                    if (location == null || track == null || (status = car.setLocation(location, track)).equals(Track.OKAY)) continue;
                    log.debug("Can't set car's location because of {}", (Object)status);
                    if (status.startsWith(Track.TYPE)) {
                        if (this.autoAdjustLocationType) {
                            location.addTypeName(carType);
                            track.addTypeName(carType);
                            status = car.setLocation(location, track);
                        } else {
                            JOptionPane.showMessageDialog(null, MessageFormat.format(Bundle.getMessage("CanNotSetCarAtLocation"), car.toString(), carType, carLocationName, carTrackName, status), Bundle.getMessage("rsCanNotLoc"), 0);
                            int results3 = JOptionPane.showConfirmDialog(null, MessageFormat.format(Bundle.getMessage("DoYouWantToAllowService"), carLocationName, carTrackName, car.toString(), carType), Bundle.getMessage("ServiceCarType"), 0);
                            if (results3 != 0) break block108;
                            location.addTypeName(carType);
                            track.addTypeName(carType);
                            status = car.setLocation(location, track);
                            log.debug("Set car's location status: {}", (Object)status);
                            if (this.askAutoLocationType) {
                                results3 = JOptionPane.showConfirmDialog(null, Bundle.getMessage("DoYouWantToAutoAdjustLocations"), Bundle.getMessage("OnlyAskedOnce"), 0);
                                if (results3 == 0) {
                                    this.autoAdjustLocationType = true;
                                }
                                this.askAutoLocationType = false;
                            }
                        }
                    }
                    if (status.startsWith(Track.LENGTH)) {
                        if (this.autoAdjustTrackLength) {
                            track.setLength(track.getLength() + 1000);
                            status = car.setLocation(location, track);
                            log.debug("Set track length status: {}", (Object)status);
                        } else {
                            JOptionPane.showMessageDialog(null, MessageFormat.format(Bundle.getMessage("CanNotSetCarAtLocation"), car.toString(), carType, carLocationName, carTrackName, status), Bundle.getMessage("rsCanNotLoc"), 0);
                            int results4 = JOptionPane.showConfirmDialog(null, MessageFormat.format(Bundle.getMessage("DoYouWantIncreaseLength"), carTrackName), Bundle.getMessage("TrackLength"), 0);
                            if (results4 != 0) break block108;
                            track.setLength(track.getLength() + 1000);
                            status = car.setLocation(location, track);
                            log.debug("Set track length status: {}", (Object)status);
                            if (this.askAutoIncreaseTrackLength) {
                                results4 = JOptionPane.showConfirmDialog(null, Bundle.getMessage("DoYouWantToAutoAdjustTrackLength"), Bundle.getMessage("OnlyAskedOnce"), 0);
                                if (results4 == 0) {
                                    this.autoAdjustTrackLength = true;
                                }
                                this.askAutoIncreaseTrackLength = false;
                            }
                        }
                    }
                    if (status.equals(Track.OKAY)) continue;
                    if (this.autoForceCar) {
                        car.setLocation(location, track, true);
                        continue;
                    }
                    JOptionPane.showMessageDialog(null, MessageFormat.format(Bundle.getMessage("CanNotSetCarAtLocation"), car.toString(), carType, carLocationName, carTrackName, status), Bundle.getMessage("rsCanNotLoc"), 0);
                    int results5 = JOptionPane.showConfirmDialog(null, MessageFormat.format(Bundle.getMessage("DoYouWantToForceCar"), car.toString(), carLocationName, carTrackName), Bundle.getMessage("OverRide"), 0);
                    if (results5 == 0) {
                        car.setLocation(location, track, true);
                        if (!this.askAutoForceCar) continue;
                        results5 = JOptionPane.showConfirmDialog(null, Bundle.getMessage("DoYouWantToAutoForceCar"), Bundle.getMessage("OnlyAskedOnce"), 0);
                        if (results5 == 0) {
                            this.autoForceCar = true;
                        }
                        this.askAutoForceCar = false;
                        continue;
                    }
                    break block108;
                }
                if (importKernel && inputLine.length == base + 3) {
                    carNumber = inputLine[base + 0];
                    carRoad = inputLine[base + 1];
                    String kernelName = inputLine[base + 2];
                    Car car = (Car)this.carManager.getByRoadAndNumber(carRoad, carNumber);
                    if (car != null) {
                        Kernel kernel = InstanceManager.getDefault(KernelManager.class).newKernel(kernelName);
                        car.setKernel(kernel);
                        ++carsAdded;
                        continue;
                    }
                    log.info("Car number ({}) road ({}) does not exist!", (Object)carNumber, (Object)carRoad);
                    break block108;
                }
                if (!line.isEmpty()) break;
            }
            log.info("Car import line {} missing attributes: {}", (Object)lineNum, (Object)line);
            JOptionPane.showMessageDialog(null, String.valueOf(MessageFormat.format(Bundle.getMessage("ImportMissingAttributes"), lineNum)) + "\n" + line + "\n" + Bundle.getMessage("ImportMissingAttributes2"), Bundle.getMessage("CarAttributeMissing"), 0);
        }
        try {
            in.close();
        }
        catch (IOException iOException) {}
        if (importOkay) {
            JOptionPane.showMessageDialog(null, MessageFormat.format(Bundle.getMessage("ImportCarsAdded"), carsAdded), Bundle.getMessage("SuccessfulImport"), 1);
        } else {
            JOptionPane.showMessageDialog(null, MessageFormat.format(Bundle.getMessage("ImportCarsAdded"), carsAdded), Bundle.getMessage("ImportFailed"), 0);
        }
        this.fstatus.dispose();
    }
}

