/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.operations.rollingstock.cars.tools;

import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.MessageFormat;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import jmri.InstanceManager;
import jmri.jmrit.operations.OperationsFrame;
import jmri.jmrit.operations.OperationsXml;
import jmri.jmrit.operations.locations.LocationManager;
import jmri.jmrit.operations.locations.schedules.ScheduleManager;
import jmri.jmrit.operations.rollingstock.cars.Car;
import jmri.jmrit.operations.rollingstock.cars.CarLoads;
import jmri.jmrit.operations.rollingstock.cars.CarManager;
import jmri.jmrit.operations.rollingstock.cars.CarTypes;
import jmri.jmrit.operations.rollingstock.cars.tools.Bundle;
import jmri.jmrit.operations.rollingstock.cars.tools.CarLoadAttributeAction;
import jmri.jmrit.operations.rollingstock.cars.tools.PrintCarLoadsAction;
import jmri.jmrit.operations.setup.Control;
import jmri.jmrit.operations.setup.Setup;
import jmri.jmrit.operations.trains.TrainManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CarLoadEditFrame
extends OperationsFrame
implements PropertyChangeListener {
    public static final String NONE = "";
    CarLoads carLoads = InstanceManager.getDefault(CarLoads.class);
    JLabel textSep = new JLabel();
    JLabel quanity = new JLabel("0");
    JButton addButton = new JButton(Bundle.getMessage("Add"));
    JButton deleteButton = new JButton(Bundle.getMessage("ButtonDelete"));
    JButton replaceButton = new JButton(Bundle.getMessage("Replace"));
    JButton saveButton = new JButton(Bundle.getMessage("ButtonSave"));
    JComboBox<String> loadComboBox;
    JComboBox<String> priorityComboBox;
    JComboBox<String> loadTypeComboBox = this.carLoads.getLoadTypesComboBox();
    JTextField addTextBox = new JTextField(10);
    JTextField pickupCommentTextField = new JTextField(35);
    JTextField dropCommentTextField = new JTextField(35);
    String _type;
    boolean menuActive = false;
    boolean showQuanity = false;
    private static final Logger log = LoggerFactory.getLogger(CarLoadEditFrame.class);

    public void initComponents(String type, String selectedItem) {
        this.getContentPane().removeAll();
        this.setTitle(MessageFormat.format(Bundle.getMessage("TitleCarEditLoad"), type));
        this._type = type;
        this.loadComboboxes();
        this.loadComboBox.setSelectedItem(selectedItem);
        this.updateLoadType();
        this.updatePriority();
        this.quanity.setVisible(this.showQuanity);
        JPanel pLoad = new JPanel();
        pLoad.setLayout(new GridBagLayout());
        pLoad.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("Load")));
        this.addItem(pLoad, this.addTextBox, 2, 2);
        this.addItem(pLoad, this.addButton, 3, 2);
        this.addItem(pLoad, this.quanity, 1, 3);
        this.addItem(pLoad, this.loadComboBox, 2, 3);
        this.addItem(pLoad, this.deleteButton, 3, 3);
        this.addItem(pLoad, this.replaceButton, 3, 4);
        this.deleteButton.setToolTipText(MessageFormat.format(Bundle.getMessage("TipDeleteAttributeName"), Bundle.getMessage("Load")));
        this.addButton.setToolTipText(MessageFormat.format(Bundle.getMessage("TipAddAttributeName"), Bundle.getMessage("Load")));
        this.replaceButton.setToolTipText(MessageFormat.format(Bundle.getMessage("TipReplaceAttributeName"), Bundle.getMessage("Load")));
        JPanel pLoadType = new JPanel();
        pLoadType.setLayout(new BoxLayout(pLoadType, 1));
        pLoadType.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("BorderLayoutLoadType")));
        this.addItem(pLoadType, this.loadTypeComboBox, 0, 0);
        JPanel pPriority = new JPanel();
        pPriority.setLayout(new BoxLayout(pPriority, 1));
        pPriority.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("BorderLayoutPriority")));
        this.addItem(pPriority, this.priorityComboBox, 0, 0);
        JPanel pOptionalPickup = new JPanel();
        pOptionalPickup.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("BorderLayoutOptionalPickup")));
        this.addItem(pOptionalPickup, this.pickupCommentTextField, 0, 0);
        JPanel pOptionalDrop = new JPanel();
        pOptionalDrop.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("BorderLayoutOptionalDrop")));
        this.addItem(pOptionalDrop, this.dropCommentTextField, 0, 0);
        JPanel pControl = new JPanel();
        pControl.setLayout(new BoxLayout(pControl, 1));
        this.addItem(pControl, this.saveButton, 0, 0);
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        this.getContentPane().add(pLoad);
        this.getContentPane().add(pLoadType);
        this.getContentPane().add(pPriority);
        this.getContentPane().add(pOptionalPickup);
        this.getContentPane().add(pOptionalDrop);
        this.getContentPane().add(pControl);
        this.addButtonAction(this.addButton);
        this.addButtonAction(this.deleteButton);
        this.addButtonAction(this.replaceButton);
        this.addButtonAction(this.saveButton);
        this.addComboBoxAction(this.loadComboBox);
        this.updateCarCommentFields();
        JMenuBar menuBar = new JMenuBar();
        JMenu toolMenu = new JMenu(Bundle.getMessage("MenuTools"));
        toolMenu.add(new CarLoadAttributeAction(this));
        toolMenu.add(new PrintCarLoadsAction(true));
        toolMenu.add(new PrintCarLoadsAction(false));
        menuBar.add(toolMenu);
        this.setJMenuBar(menuBar);
        this.addHelpMenu("package.jmri.jmrit.operations.Operations_EditCarLoads", true);
        this.initMinimumSize(new Dimension(300, 500));
    }

    @Override
    public void buttonActionPerformed(ActionEvent ae) {
        String loadName = this.addTextBox.getText().trim();
        if (ae.getSource() == this.addButton || ae.getSource() == this.replaceButton) {
            if (loadName.equals(NONE)) {
                return;
            }
            if (loadName.length() > Control.max_len_string_attibute) {
                JOptionPane.showMessageDialog(this, MessageFormat.format(Bundle.getMessage("carAttribute"), Control.max_len_string_attibute), Bundle.getMessage("canNotUseLoadName"), 0);
                return;
            }
            if (loadName.contains(" & ")) {
                JOptionPane.showMessageDialog(this, MessageFormat.format(Bundle.getMessage("carNameNoAndChar"), " & "), Bundle.getMessage("canNotUseLoadName"), 0);
                return;
            }
        }
        if (ae.getSource() == this.addButton) {
            this.carLoads.addName(this._type, loadName);
        }
        if (ae.getSource() == this.deleteButton) {
            String deleteLoad = (String)this.loadComboBox.getSelectedItem();
            if (deleteLoad.equals(this.carLoads.getDefaultEmptyName()) || deleteLoad.equals(this.carLoads.getDefaultLoadName())) {
                JOptionPane.showMessageDialog(this, Bundle.getMessage("carLoadDefault"), MessageFormat.format(Bundle.getMessage("canNotDelete"), Bundle.getMessage("Load")), 0);
                return;
            }
            this.replaceLoad(this._type, deleteLoad, null);
            this.carLoads.deleteName(this._type, deleteLoad);
        }
        if (ae.getSource() == this.replaceButton) {
            String oldLoadName = (String)this.loadComboBox.getSelectedItem();
            if (oldLoadName.equals(this.carLoads.getDefaultEmptyName())) {
                if (JOptionPane.showConfirmDialog(this, MessageFormat.format(Bundle.getMessage("replaceDefaultEmpty"), oldLoadName, loadName), Bundle.getMessage("replaceAll"), 0) != 0) {
                    return;
                }
                if (loadName.equals(this.carLoads.getDefaultEmptyName()) || loadName.equals(this.carLoads.getDefaultLoadName())) {
                    JOptionPane.showMessageDialog(this, Bundle.getMessage("carDefault"), MessageFormat.format(Bundle.getMessage("canNotReplace"), Bundle.getMessage("Load")), 0);
                    return;
                }
                this.carLoads.setDefaultEmptyName(loadName);
                this.replaceAllLoads(oldLoadName, loadName);
                return;
            }
            if (oldLoadName.equals(this.carLoads.getDefaultLoadName())) {
                if (JOptionPane.showConfirmDialog(this, MessageFormat.format(Bundle.getMessage("replaceDefaultLoad"), oldLoadName, loadName), Bundle.getMessage("replaceAll"), 0) != 0) {
                    return;
                }
                if (loadName.equals(this.carLoads.getDefaultEmptyName()) || loadName.equals(this.carLoads.getDefaultLoadName())) {
                    JOptionPane.showMessageDialog(this, Bundle.getMessage("carDefault"), MessageFormat.format(Bundle.getMessage("canNotReplace"), Bundle.getMessage("Load")), 0);
                    return;
                }
                this.carLoads.setDefaultLoadName(loadName);
                this.replaceAllLoads(oldLoadName, loadName);
                return;
            }
            if (JOptionPane.showConfirmDialog(this, MessageFormat.format(Bundle.getMessage("replaceMsg"), oldLoadName, loadName), Bundle.getMessage("replaceAll"), 0) != 0) {
                return;
            }
            String loadType = this.carLoads.getLoadType(this._type, oldLoadName);
            String loadPriority = this.carLoads.getPriority(this._type, oldLoadName);
            String pickupComment = this.carLoads.getPickupComment(this._type, oldLoadName);
            String dropComment = this.carLoads.getDropComment(this._type, oldLoadName);
            this.carLoads.addName(this._type, loadName);
            this.carLoads.setLoadType(this._type, loadName, loadType);
            this.carLoads.setPriority(this._type, loadName, loadPriority);
            this.carLoads.setPickupComment(this._type, loadName, pickupComment);
            this.carLoads.setDropComment(this._type, loadName, dropComment);
            this.replaceLoad(this._type, oldLoadName, loadName);
            this.carLoads.deleteName(this._type, oldLoadName);
        }
        if (ae.getSource() == this.saveButton) {
            this.carLoads.setLoadType(this._type, (String)this.loadComboBox.getSelectedItem(), (String)this.loadTypeComboBox.getSelectedItem());
            this.carLoads.setPriority(this._type, (String)this.loadComboBox.getSelectedItem(), (String)this.priorityComboBox.getSelectedItem());
            this.carLoads.setPickupComment(this._type, (String)this.loadComboBox.getSelectedItem(), this.pickupCommentTextField.getText());
            this.carLoads.setDropComment(this._type, (String)this.loadComboBox.getSelectedItem(), this.dropCommentTextField.getText());
            OperationsXml.save();
            if (Setup.isCloseWindowOnSaveEnabled()) {
                this.dispose();
            }
        }
    }

    @Override
    protected void comboBoxActionPerformed(ActionEvent ae) {
        log.debug("Combo box action");
        this.updateCarQuanity();
        this.updateLoadType();
        this.updatePriority();
        this.updateCarCommentFields();
    }

    private void replaceAllLoads(String oldLoad, String newLoad) {
        String[] stringArray = InstanceManager.getDefault(CarTypes.class).getNames();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String type = stringArray[n2];
            this.carLoads.addName(type, newLoad);
            this.replaceLoad(type, oldLoad, newLoad);
            this.carLoads.deleteName(type, oldLoad);
            ++n2;
        }
    }

    private void replaceLoad(String type, String oldLoad, String newLoad) {
        InstanceManager.getDefault(CarManager.class).replaceLoad(type, oldLoad, newLoad);
        InstanceManager.getDefault(ScheduleManager.class).replaceLoad(type, oldLoad, newLoad);
        InstanceManager.getDefault(TrainManager.class).replaceLoad(type, oldLoad, newLoad);
        InstanceManager.getDefault(LocationManager.class).replaceLoad(type, oldLoad, newLoad);
    }

    private void loadComboboxes() {
        this.loadComboBox = this.carLoads.getComboBox(this._type);
        this.carLoads.addPropertyChangeListener(this);
        this.priorityComboBox = this.carLoads.getPriorityComboBox();
    }

    public void toggleShowQuanity() {
        this.showQuanity = !this.showQuanity;
        this.quanity.setVisible(this.showQuanity);
        this.updateCarQuanity();
    }

    private void updateCarQuanity() {
        if (!this.showQuanity) {
            return;
        }
        int number = 0;
        String item = (String)this.loadComboBox.getSelectedItem();
        for (Car car : InstanceManager.getDefault(CarManager.class).getList()) {
            if (!car.getLoadName().equals(item)) continue;
            ++number;
        }
        this.quanity.setText(Integer.toString(number));
    }

    private void updateLoadType() {
        String loadName = (String)this.loadComboBox.getSelectedItem();
        this.loadTypeComboBox.setSelectedItem(this.carLoads.getLoadType(this._type, loadName));
        if (loadName != null && (loadName.equals(InstanceManager.getDefault(CarLoads.class).getDefaultEmptyName()) || loadName.equals(InstanceManager.getDefault(CarLoads.class).getDefaultLoadName()))) {
            this.loadTypeComboBox.setEnabled(false);
        } else {
            this.loadTypeComboBox.setEnabled(true);
        }
    }

    private void updatePriority() {
        this.priorityComboBox.setSelectedItem(this.carLoads.getPriority(this._type, (String)this.loadComboBox.getSelectedItem()));
    }

    private void updateCarCommentFields() {
        this.pickupCommentTextField.setText(this.carLoads.getPickupComment(this._type, (String)this.loadComboBox.getSelectedItem()));
        this.dropCommentTextField.setText(this.carLoads.getDropComment(this._type, (String)this.loadComboBox.getSelectedItem()));
    }

    @Override
    public void dispose() {
        this.carLoads.removePropertyChangeListener(this);
        super.dispose();
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        if (e.getPropertyName().equals("CarLoads_Load")) {
            this.carLoads.updateComboBox(this._type, this.loadComboBox);
            this.loadComboBox.setSelectedItem(this.addTextBox.getText().trim());
        }
    }
}

