/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.operations.rollingstock.cars;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;
import jmri.InstanceManager;
import jmri.jmrit.operations.rollingstock.cars.Bundle;
import jmri.jmrit.operations.rollingstock.cars.Car;
import jmri.jmrit.operations.rollingstock.cars.CarEditFrame;
import jmri.jmrit.operations.rollingstock.cars.CarLoad;
import jmri.jmrit.operations.rollingstock.cars.CarManager;
import jmri.jmrit.operations.rollingstock.cars.CarSetFrame;
import jmri.jmrit.operations.rollingstock.cars.CarsTableFrame;
import jmri.jmrit.operations.setup.Setup;
import jmri.util.swing.XTableColumnModel;
import jmri.util.table.ButtonEditor;
import jmri.util.table.ButtonRenderer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CarsTableModel
extends AbstractTableModel
implements PropertyChangeListener {
    CarManager carManager = InstanceManager.getDefault(CarManager.class);
    private static final int SELECT_COLUMN = 0;
    private static final int NUMBER_COLUMN = 1;
    private static final int ROAD_COLUMN = 2;
    private static final int TYPE_COLUMN = 3;
    private static final int LENGTH_COLUMN = 4;
    private static final int LOAD_COLUMN = 5;
    private static final int RWE_LOAD_COLUMN = 6;
    private static final int RWL_LOAD_COLUMN = 7;
    private static final int COLOR_COLUMN = 8;
    private static final int KERNEL_COLUMN = 9;
    private static final int LOCATION_COLUMN = 10;
    private static final int RFID_WHERE_LAST_SEEN_COLUMN = 11;
    private static final int RFID_WHEN_LAST_SEEN_COLUMN = 12;
    private static final int DESTINATION_COLUMN = 13;
    private static final int FINAL_DESTINATION_COLUMN = 14;
    private static final int RWE_DESTINATION_COLUMN = 15;
    private static final int RWL_DESTINATION_COLUMN = 16;
    private static final int DIVISION_COLUMN = 17;
    private static final int TRAIN_COLUMN = 18;
    private static final int MOVES_COLUMN = 19;
    private static final int BUILT_COLUMN = 20;
    private static final int OWNER_COLUMN = 21;
    private static final int VALUE_COLUMN = 22;
    private static final int RFID_COLUMN = 23;
    private static final int WAIT_COLUMN = 24;
    private static final int PICKUP_COLUMN = 25;
    private static final int LAST_COLUMN = 26;
    private static final int SET_COLUMN = 27;
    private static final int EDIT_COLUMN = 28;
    private static final int HIGHESTCOLUMN = 29;
    public final int SORTBY_NUMBER = 0;
    public final int SORTBY_ROAD = 1;
    public final int SORTBY_TYPE = 2;
    public final int SORTBY_LOCATION = 3;
    public final int SORTBY_DESTINATION = 4;
    public final int SORTBY_TRAIN = 5;
    public final int SORTBY_MOVES = 6;
    public final int SORTBY_KERNEL = 7;
    public final int SORTBY_LOAD = 8;
    public final int SORTBY_COLOR = 9;
    public final int SORTBY_BUILT = 10;
    public final int SORTBY_OWNER = 11;
    public final int SORTBY_RFID = 12;
    public final int SORTBY_RWE = 13;
    public final int SORTBY_RWL = 14;
    public final int SORTBY_DIVISION = 15;
    public final int SORTBY_FINALDESTINATION = 16;
    public final int SORTBY_VALUE = 17;
    public final int SORTBY_WAIT = 18;
    public final int SORTBY_PICKUP = 19;
    public final int SORTBY_LAST = 20;
    private int _sort = 0;
    List<Car> carList = null;
    boolean showAllCars = true;
    String locationName = null;
    public String trackName = null;
    JTable _table;
    CarsTableFrame _frame;
    String _roadNumber = "";
    int _index = 0;
    private final int[] tableColumnWidths = new int[]{60, 60, 60, 65, 35, 75, 75, 75, 75, 65, 190, 190, 140, 190, 190, 190, 190, 190, 65, 50, 50, 50, 50, 100, 50, 100, 100, 65, 70};
    CarEditFrame cef = null;
    CarSetFrame csf = null;
    private static final Logger log = LoggerFactory.getLogger(CarsTableModel.class);

    public CarsTableModel(boolean showAllCars, String locationName, String trackName) {
        this.showAllCars = showAllCars;
        this.locationName = locationName;
        this.trackName = trackName;
        this.carManager.addPropertyChangeListener(this);
        this.updateList();
    }

    public void setSort(int sort) {
        this._sort = sort;
        this.updateList();
        XTableColumnModel tcm = (XTableColumnModel)this._table.getColumnModel();
        if (sort == 9 || sort == 8 || sort == 13 || sort == 14) {
            tcm.setColumnVisible(tcm.getColumnByModelIndex(5), sort == 8);
            tcm.setColumnVisible(tcm.getColumnByModelIndex(8), sort == 9);
            tcm.setColumnVisible(tcm.getColumnByModelIndex(6), sort == 13);
            tcm.setColumnVisible(tcm.getColumnByModelIndex(7), sort == 14);
        }
        if (sort == 4 || sort == 16 || sort == 13 || sort == 14 || sort == 15) {
            tcm.setColumnVisible(tcm.getColumnByModelIndex(13), sort == 4);
            tcm.setColumnVisible(tcm.getColumnByModelIndex(14), sort == 16);
            tcm.setColumnVisible(tcm.getColumnByModelIndex(15), sort == 13);
            tcm.setColumnVisible(tcm.getColumnByModelIndex(16), sort == 14);
            tcm.setColumnVisible(tcm.getColumnByModelIndex(6), sort == 13);
            tcm.setColumnVisible(tcm.getColumnByModelIndex(7), sort == 14);
            tcm.setColumnVisible(tcm.getColumnByModelIndex(17), sort == 15);
            tcm.setColumnVisible(tcm.getColumnByModelIndex(5), sort != 13 && sort != 14 && !tcm.isColumnVisible(tcm.getColumnByModelIndex(8)));
        } else if (sort == 6 || sort == 10 || sort == 11 || sort == 17 || sort == 12 || sort == 18 || sort == 19 || sort == 20) {
            tcm.setColumnVisible(tcm.getColumnByModelIndex(19), sort == 6);
            tcm.setColumnVisible(tcm.getColumnByModelIndex(20), sort == 10);
            tcm.setColumnVisible(tcm.getColumnByModelIndex(21), sort == 11);
            tcm.setColumnVisible(tcm.getColumnByModelIndex(22), sort == 17);
            tcm.setColumnVisible(tcm.getColumnByModelIndex(23), sort == 12);
            tcm.setColumnVisible(tcm.getColumnByModelIndex(12), sort == 12);
            tcm.setColumnVisible(tcm.getColumnByModelIndex(11), sort == 12);
            tcm.setColumnVisible(tcm.getColumnByModelIndex(24), sort == 18);
            tcm.setColumnVisible(tcm.getColumnByModelIndex(25), sort == 19);
            tcm.setColumnVisible(tcm.getColumnByModelIndex(26), sort == 20);
        }
        this.fireTableDataChanged();
    }

    public String getSortByName() {
        return this.getSortByName(this._sort);
    }

    public String getSortByName(int sort) {
        switch (sort) {
            case 0: {
                return Bundle.getMessage("Number");
            }
            case 1: {
                return Bundle.getMessage("Road");
            }
            case 2: {
                return Bundle.getMessage("Type");
            }
            case 9: {
                return Bundle.getMessage("Color");
            }
            case 8: {
                return Bundle.getMessage("Load");
            }
            case 7: {
                return Bundle.getMessage("Kernel");
            }
            case 3: {
                return Bundle.getMessage("Location");
            }
            case 4: {
                return Bundle.getMessage("Destination");
            }
            case 15: {
                return Bundle.getMessage("HomeDivision");
            }
            case 5: {
                return Bundle.getMessage("Train");
            }
            case 16: {
                return Bundle.getMessage("FinalDestination");
            }
            case 13: {
                return Bundle.getMessage("ReturnWhenEmpty");
            }
            case 14: {
                return Bundle.getMessage("ReturnWhenLoaded");
            }
            case 6: {
                return Bundle.getMessage("Moves");
            }
            case 10: {
                return Bundle.getMessage("Built");
            }
            case 11: {
                return Bundle.getMessage("Owner");
            }
            case 17: {
                return Setup.getValueLabel();
            }
            case 12: {
                return Setup.getRfidLabel();
            }
            case 18: {
                return Bundle.getMessage("Wait");
            }
            case 19: {
                return Bundle.getMessage("Pickup");
            }
            case 20: {
                return Bundle.getMessage("Last");
            }
        }
        return "Error";
    }

    public void toggleSelectVisible() {
        XTableColumnModel tcm = (XTableColumnModel)this._table.getColumnModel();
        tcm.setColumnVisible(tcm.getColumnByModelIndex(0), !tcm.isColumnVisible(tcm.getColumnByModelIndex(0)));
    }

    public void resetCheckboxes() {
        for (Car car : this.carList) {
            car.setSelected(false);
        }
    }

    public int findCarByRoadNumber(String roadNumber) {
        if (this.carList != null) {
            if (!roadNumber.equals(this._roadNumber)) {
                return this.getIndex(0, roadNumber);
            }
            int index = this.getIndex(this._index, roadNumber);
            if (index > 0) {
                return index;
            }
            return this.getIndex(0, roadNumber);
        }
        return -1;
    }

    private int getIndex(int start, String roadNumber) {
        int index = start;
        while (index < this.carList.size()) {
            Car car = this.carList.get(index);
            if (car != null) {
                String rN;
                String[] number = car.getNumber().split("-");
                if (roadNumber.startsWith("*") && roadNumber.endsWith("*")) {
                    rN = roadNumber.substring(1, roadNumber.length() - 1);
                    if (car.getNumber().contains(rN)) {
                        this._roadNumber = roadNumber;
                        this._index = index + 1;
                        return index;
                    }
                } else if (roadNumber.startsWith("*")) {
                    rN = roadNumber.substring(1);
                    if (car.getNumber().endsWith(rN) || number[0].endsWith(rN)) {
                        this._roadNumber = roadNumber;
                        this._index = index + 1;
                        return index;
                    }
                } else if (roadNumber.endsWith("*")) {
                    rN = roadNumber.substring(0, roadNumber.length() - 1);
                    if (car.getNumber().startsWith(rN)) {
                        this._roadNumber = roadNumber;
                        this._index = index + 1;
                        return index;
                    }
                } else if (car.getNumber().equals(roadNumber) || number[0].equals(roadNumber)) {
                    this._roadNumber = roadNumber;
                    this._index = index + 1;
                    return index;
                }
            }
            ++index;
        }
        this._roadNumber = "";
        return -1;
    }

    public Car getCarAtIndex(int index) {
        return this.carList.get(index);
    }

    private void updateList() {
        this.removePropertyChangeCars();
        this.carList = this.getSelectedCarList();
        this.addPropertyChangeCars();
    }

    public List<Car> getSelectedCarList() {
        return this.getCarList(this._sort);
    }

    @SuppressFBWarnings(value={"DB_DUPLICATE_SWITCH_CLAUSES"}, justification="default case is sort by number")
    public List<Car> getCarList(int sort) {
        List<Car> list;
        switch (sort) {
            case 0: {
                list = this.carManager.getByNumberList();
                break;
            }
            case 1: {
                list = this.carManager.getByRoadNameList();
                break;
            }
            case 2: {
                list = this.carManager.getByTypeList();
                break;
            }
            case 9: {
                list = this.carManager.getByColorList();
                break;
            }
            case 8: {
                list = this.carManager.getByLoadList();
                break;
            }
            case 7: {
                list = this.carManager.getByKernelList();
                break;
            }
            case 3: {
                list = this.carManager.getByLocationList();
                break;
            }
            case 4: {
                list = this.carManager.getByDestinationList();
                break;
            }
            case 5: {
                list = this.carManager.getByTrainList();
                break;
            }
            case 16: {
                list = this.carManager.getByFinalDestinationList();
                break;
            }
            case 13: {
                list = this.carManager.getByRweList();
                break;
            }
            case 14: {
                list = this.carManager.getByRwlList();
                break;
            }
            case 15: {
                list = this.carManager.getByDivisionList();
                break;
            }
            case 6: {
                list = this.carManager.getByMovesList();
                break;
            }
            case 10: {
                list = this.carManager.getByBuiltList();
                break;
            }
            case 11: {
                list = this.carManager.getByOwnerList();
                break;
            }
            case 17: {
                list = this.carManager.getByValueList();
                break;
            }
            case 12: {
                list = this.carManager.getByRfidList();
                break;
            }
            case 18: {
                list = this.carManager.getByWaitList();
                break;
            }
            case 19: {
                list = this.carManager.getByPickupList();
                break;
            }
            case 20: {
                list = this.carManager.getByLastDateList();
                break;
            }
            default: {
                list = this.carManager.getByNumberList();
            }
        }
        this.filterList(list);
        return list;
    }

    private void filterList(List<Car> list) {
        if (this.showAllCars) {
            return;
        }
        int i = 0;
        while (i < list.size()) {
            Car car = list.get(i);
            if (car.getLocation() == null) {
                list.remove(i--);
            } else if (this.locationName != null) {
                if (!car.getLocationName().equals(this.locationName)) {
                    list.remove(i--);
                } else if (this.trackName != null && !car.getTrackName().equals(this.trackName)) {
                    list.remove(i--);
                }
            }
            ++i;
        }
    }

    void initTable(JTable table, CarsTableFrame frame) {
        this._table = table;
        this._frame = frame;
        this.initTable();
    }

    void initTable() {
        XTableColumnModel tcm = new XTableColumnModel();
        this._table.setColumnModel(tcm);
        this._table.createDefaultColumnsFromModel();
        ButtonRenderer buttonRenderer = new ButtonRenderer();
        tcm.getColumn(27).setCellRenderer(buttonRenderer);
        ButtonEditor buttonEditor = new ButtonEditor(new JButton());
        tcm.getColumn(27).setCellEditor(buttonEditor);
        tcm.getColumn(28).setCellRenderer(buttonRenderer);
        tcm.getColumn(28).setCellEditor(buttonEditor);
        int i = 0;
        while (i < tcm.getColumnCount()) {
            tcm.getColumn(i).setPreferredWidth(this.tableColumnWidths[i]);
            ++i;
        }
        this._frame.loadTableDetails(this._table);
        tcm.setColumnVisible(tcm.getColumnByModelIndex(8), false);
        tcm.setColumnVisible(tcm.getColumnByModelIndex(14), false);
        tcm.setColumnVisible(tcm.getColumnByModelIndex(15), false);
        tcm.setColumnVisible(tcm.getColumnByModelIndex(6), false);
        tcm.setColumnVisible(tcm.getColumnByModelIndex(16), false);
        tcm.setColumnVisible(tcm.getColumnByModelIndex(7), false);
        tcm.setColumnVisible(tcm.getColumnByModelIndex(17), false);
        tcm.setColumnVisible(tcm.getColumnByModelIndex(20), false);
        tcm.setColumnVisible(tcm.getColumnByModelIndex(21), false);
        tcm.setColumnVisible(tcm.getColumnByModelIndex(22), false);
        tcm.setColumnVisible(tcm.getColumnByModelIndex(23), false);
        tcm.setColumnVisible(tcm.getColumnByModelIndex(12), false);
        tcm.setColumnVisible(tcm.getColumnByModelIndex(11), false);
        tcm.setColumnVisible(tcm.getColumnByModelIndex(24), false);
        tcm.setColumnVisible(tcm.getColumnByModelIndex(25), false);
        tcm.setColumnVisible(tcm.getColumnByModelIndex(26), false);
        tcm.setColumnVisible(tcm.getColumnByModelIndex(5), true);
        tcm.setColumnVisible(tcm.getColumnByModelIndex(13), true);
        tcm.setColumnVisible(tcm.getColumnByModelIndex(19), true);
    }

    @Override
    public int getRowCount() {
        return this.carList.size();
    }

    @Override
    public int getColumnCount() {
        return 29;
    }

    @Override
    public String getColumnName(int col) {
        switch (col) {
            case 0: {
                return Bundle.getMessage("ButtonSelect");
            }
            case 1: {
                return Bundle.getMessage("Number");
            }
            case 2: {
                return Bundle.getMessage("Road");
            }
            case 5: {
                return Bundle.getMessage("Load");
            }
            case 8: {
                return Bundle.getMessage("Color");
            }
            case 3: {
                return Bundle.getMessage("Type");
            }
            case 4: {
                return Bundle.getMessage("Len");
            }
            case 9: {
                return Bundle.getMessage("Kernel");
            }
            case 10: {
                return Bundle.getMessage("Location");
            }
            case 11: {
                return Bundle.getMessage("WhereLastSeen");
            }
            case 12: {
                return Bundle.getMessage("WhenLastSeen");
            }
            case 13: {
                return Bundle.getMessage("Destination");
            }
            case 14: {
                return Bundle.getMessage("FinalDestination");
            }
            case 15: {
                return Bundle.getMessage("RWELocation");
            }
            case 6: {
                return Bundle.getMessage("RWELoad");
            }
            case 16: {
                return Bundle.getMessage("RWLLocation");
            }
            case 7: {
                return Bundle.getMessage("RWLLoad");
            }
            case 17: {
                return Bundle.getMessage("HomeDivision");
            }
            case 18: {
                return Bundle.getMessage("Train");
            }
            case 19: {
                return Bundle.getMessage("Moves");
            }
            case 20: {
                return Bundle.getMessage("Built");
            }
            case 21: {
                return Bundle.getMessage("Owner");
            }
            case 22: {
                return Setup.getValueLabel();
            }
            case 23: {
                return Setup.getRfidLabel();
            }
            case 24: {
                return Bundle.getMessage("Wait");
            }
            case 25: {
                return Bundle.getMessage("Pickup");
            }
            case 26: {
                return Bundle.getMessage("LastMoved");
            }
            case 27: {
                return Bundle.getMessage("Set");
            }
            case 28: {
                return Bundle.getMessage("ButtonEdit");
            }
        }
        return "unknown";
    }

    @Override
    public Class<?> getColumnClass(int col) {
        switch (col) {
            case 0: {
                return Boolean.class;
            }
            case 27: 
            case 28: {
                return JButton.class;
            }
            case 4: 
            case 19: 
            case 24: {
                return Integer.class;
            }
        }
        return String.class;
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        switch (col) {
            case 0: 
            case 19: 
            case 22: 
            case 23: 
            case 24: 
            case 27: 
            case 28: {
                return true;
            }
        }
        return false;
    }

    @Override
    public Object getValueAt(int row, int col) {
        if (row >= this.getRowCount()) {
            return "ERROR row " + row;
        }
        Car car = this.carList.get(row);
        if (car == null) {
            return "ERROR car unknown " + row;
        }
        switch (col) {
            case 0: {
                return car.isSelected();
            }
            case 1: {
                return car.getNumber();
            }
            case 2: {
                return car.getRoadName();
            }
            case 5: {
                if (car.getLoadPriority().equals(CarLoad.PRIORITY_HIGH)) {
                    return String.valueOf(car.getLoadName()) + " " + Bundle.getMessage("(P)");
                }
                if (car.getLoadPriority().equals(CarLoad.PRIORITY_MEDIUM)) {
                    return String.valueOf(car.getLoadName()) + " " + Bundle.getMessage("(M)");
                }
                return car.getLoadName();
            }
            case 8: {
                return car.getColor();
            }
            case 4: {
                return car.getLengthInteger();
            }
            case 3: {
                return String.valueOf(car.getTypeName()) + car.getTypeExtensions();
            }
            case 9: {
                if (car.isLead()) {
                    return String.valueOf(car.getKernelName()) + "*";
                }
                return car.getKernelName();
            }
            case 10: {
                if (car.getLocation() != null) {
                    return String.valueOf(car.getStatus()) + car.getLocationName() + " (" + car.getTrackName() + ")";
                }
                return car.getStatus();
            }
            case 11: {
                return String.valueOf(car.getWhereLastSeenName()) + (car.getTrackLastSeenName().equals("") ? "" : " (" + car.getTrackLastSeenName() + ")");
            }
            case 12: {
                return car.getWhenLastSeenDate();
            }
            case 13: 
            case 14: {
                String s = "";
                if (car.getDestination() != null) {
                    s = String.valueOf(car.getDestinationName()) + " (" + car.getDestinationTrackName() + ")";
                }
                if (car.getFinalDestination() != null) {
                    s = String.valueOf(s) + "->" + car.getFinalDestinationName();
                }
                if (car.getFinalDestinationTrack() != null) {
                    s = String.valueOf(s) + " (" + car.getFinalDestinationTrackName() + ")";
                }
                if (log.isDebugEnabled() && car.getFinalDestinationTrack() != null && car.getFinalDestinationTrack().getSchedule() != null) {
                    s = String.valueOf(s) + " " + car.getScheduleItemId();
                }
                return s;
            }
            case 15: {
                return car.getReturnWhenEmptyDestName();
            }
            case 6: {
                return car.getReturnWhenEmptyLoadName();
            }
            case 16: {
                return car.getReturnWhenLoadedDestName();
            }
            case 7: {
                return car.getReturnWhenLoadedLoadName();
            }
            case 17: {
                return car.getDivisionName();
            }
            case 18: {
                if (car.getTrain() != null && car.getRouteLocation() == null) {
                    return String.valueOf(car.getTrainName()) + "*";
                }
                return car.getTrainName();
            }
            case 19: {
                return car.getMoves();
            }
            case 20: {
                return car.getBuilt();
            }
            case 21: {
                return car.getOwner();
            }
            case 22: {
                return car.getValue();
            }
            case 23: {
                return car.getRfid();
            }
            case 24: {
                return car.getWait();
            }
            case 25: {
                return car.getPickupScheduleName();
            }
            case 26: {
                return car.getLastDate();
            }
            case 27: {
                return Bundle.getMessage("Set");
            }
            case 28: {
                return Bundle.getMessage("ButtonEdit");
            }
        }
        return "unknown " + col;
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        Car car = this.carList.get(row);
        switch (col) {
            case 0: {
                car.setSelected((Boolean)value);
                break;
            }
            case 27: {
                log.debug("Set car");
                if (this.csf != null) {
                    this.csf.dispose();
                }
                SwingUtilities.invokeLater(() -> {
                    this.csf = new CarSetFrame();
                    this.csf.initComponents();
                    this.csf.loadCar(car);
                });
                break;
            }
            case 28: {
                log.debug("Edit car");
                if (this.cef != null) {
                    this.cef.dispose();
                }
                SwingUtilities.invokeLater(() -> {
                    this.cef = new CarEditFrame();
                    this.cef.initComponents();
                    this.cef.load(car);
                });
                break;
            }
            case 19: {
                try {
                    car.setMoves(Integer.parseInt(value.toString()));
                }
                catch (NumberFormatException numberFormatException) {
                    log.error("move count must be a number");
                }
                break;
            }
            case 22: {
                car.setValue(value.toString());
                break;
            }
            case 23: {
                car.setRfid(value.toString());
                break;
            }
            case 24: {
                try {
                    car.setWait(Integer.parseInt(value.toString()));
                }
                catch (NumberFormatException numberFormatException) {
                    log.error("wait count must be a number");
                }
                break;
            }
        }
    }

    public void dispose() {
        this.carManager.removePropertyChangeListener(this);
        this.removePropertyChangeCars();
        if (this.csf != null) {
            this.csf.dispose();
        }
        if (this.cef != null) {
            this.cef.dispose();
        }
    }

    private void addPropertyChangeCars() {
        for (Car car : this.carManager.getList()) {
            car.addPropertyChangeListener(this);
        }
    }

    private void removePropertyChangeCars() {
        for (Car car : this.carManager.getList()) {
            car.removePropertyChangeListener(this);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        if (e.getPropertyName().equals("RollingStockListLength")) {
            this.updateList();
            this.fireTableDataChanged();
        } else if (e.getSource().getClass().equals(Car.class)) {
            Car car = (Car)e.getSource();
            int row = this.carList.indexOf(car);
            if (row >= 0) {
                this.fireTableRowsUpdated(row, row);
            } else if (e.getPropertyName().equals("rolling stock track location")) {
                this.updateList();
                this.fireTableDataChanged();
            }
        }
    }
}

