/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.operations.rollingstock.cars;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import java.util.ArrayList;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import jmri.jmrit.operations.rollingstock.cars.Bundle;
import jmri.jmrit.operations.rollingstock.cars.Car;
import jmri.jmrit.operations.rollingstock.cars.CarSetFrame;
import jmri.jmrit.operations.rollingstock.cars.CarsTableModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CarsSetFrame
extends CarSetFrame {
    CarsTableModel _carsTableModel;
    JTable _carsTable;
    private static boolean ignoreStatusCheckBoxSelected = false;
    private static boolean ignoreLocationCheckBoxSelected = false;
    private static boolean ignoreDivisionCheckBoxSelected = false;
    private static boolean ignoreRWECheckBoxSelected = false;
    private static boolean ignoreRWLCheckBoxSelected = false;
    private static boolean ignoreLoadCheckBoxSelected = false;
    private static boolean ignoreKernelCheckBoxSelected = false;
    private static boolean ignoreDestinationCheckBoxSelected = false;
    private static boolean ignoreFinalDestinationCheckBoxSelected = false;
    private static boolean ignoreTrainCheckBoxSelected = false;
    boolean toggle = true;
    private static final Logger log = LoggerFactory.getLogger(CarsSetFrame.class);

    public void initComponents(JTable carsTable) {
        this._carsTable = carsTable;
        this._carsTableModel = (CarsTableModel)carsTable.getModel();
        super.initComponents();
        this.setTitle(Bundle.getMessage("TitleSetCars"));
        this.addHelpMenu("package.jmri.jmrit.operations.Operations_SetCars", true);
        this.saveButton.setText(Bundle.getMessage("ButtonApply"));
        this.editLoadButton.setEnabled(false);
        this.ignoreStatusCheckBox.setVisible(true);
        this.ignoreLocationCheckBox.setVisible(true);
        this.ignoreDivisionCheckBox.setVisible(true);
        this.ignoreRWECheckBox.setVisible(true);
        this.ignoreRWLCheckBox.setVisible(true);
        this.ignoreLoadCheckBox.setVisible(true);
        this.ignoreKernelCheckBox.setVisible(true);
        this.ignoreDestinationCheckBox.setVisible(true);
        this.ignoreFinalDestinationCheckBox.setVisible(true);
        this.ignoreTrainCheckBox.setVisible(true);
        this.ignoreAllButton.setVisible(true);
        this.ignoreStatusCheckBox.setSelected(ignoreStatusCheckBoxSelected);
        this.ignoreLocationCheckBox.setSelected(ignoreLocationCheckBoxSelected);
        this.ignoreDivisionCheckBox.setSelected(ignoreDivisionCheckBoxSelected);
        this.ignoreRWECheckBox.setSelected(ignoreRWECheckBoxSelected);
        this.ignoreRWLCheckBox.setSelected(ignoreRWLCheckBoxSelected);
        this.ignoreLoadCheckBox.setSelected(ignoreLoadCheckBoxSelected);
        this.ignoreKernelCheckBox.setSelected(ignoreKernelCheckBoxSelected);
        this.ignoreDestinationCheckBox.setSelected(ignoreDestinationCheckBoxSelected);
        this.ignoreFinalDestinationCheckBox.setSelected(ignoreFinalDestinationCheckBoxSelected);
        this.ignoreTrainCheckBox.setSelected(ignoreTrainCheckBoxSelected);
        int[] rows = this._carsTable.getSelectedRows();
        if (rows.length > 0) {
            Car car = this._carsTableModel.getCarAtIndex(this._carsTable.convertRowIndexToModel(rows[0]));
            super.loadCar(car);
        }
    }

    @Override
    public void buttonActionPerformed(ActionEvent ae) {
        super.buttonActionPerformed(ae);
        if (ae.getSource() == this.ignoreAllButton) {
            this.ignoreAll(this.toggle);
        }
    }

    protected void ignoreAll(boolean b) {
        this.ignoreStatusCheckBox.setSelected(!this.locationUnknownCheckBox.isSelected() & b);
        this.ignoreLocationCheckBox.setSelected(b);
        this.ignoreDivisionCheckBox.setSelected(b);
        this.ignoreRWECheckBox.setSelected(b);
        this.ignoreRWLCheckBox.setSelected(b);
        this.ignoreLoadCheckBox.setSelected(b);
        this.ignoreKernelCheckBox.setSelected(b);
        this.ignoreDestinationCheckBox.setSelected(b);
        this.ignoreFinalDestinationCheckBox.setSelected(b);
        this.ignoreTrainCheckBox.setSelected(b);
        this.enableComponents(!this.locationUnknownCheckBox.isSelected());
        this.toggle = !b;
    }

    @Override
    @SuppressFBWarnings(value={"ST_WRITE_TO_STATIC_FROM_INSTANCE_METHOD"}, justification="GUI ease of use")
    protected boolean save() {
        int[] rows;
        ignoreStatusCheckBoxSelected = this.ignoreStatusCheckBox.isSelected();
        ignoreLocationCheckBoxSelected = this.ignoreLocationCheckBox.isSelected();
        ignoreDivisionCheckBoxSelected = this.ignoreDivisionCheckBox.isSelected();
        ignoreRWECheckBoxSelected = this.ignoreRWECheckBox.isSelected();
        ignoreRWLCheckBoxSelected = this.ignoreRWLCheckBox.isSelected();
        ignoreLoadCheckBoxSelected = this.ignoreLoadCheckBox.isSelected();
        ignoreKernelCheckBoxSelected = this.ignoreKernelCheckBox.isSelected();
        ignoreDestinationCheckBoxSelected = this.ignoreKernelCheckBox.isSelected();
        ignoreFinalDestinationCheckBoxSelected = this.ignoreFinalDestinationCheckBox.isSelected();
        ignoreTrainCheckBoxSelected = this.ignoreTrainCheckBox.isSelected();
        ArrayList<Car> cars = new ArrayList<Car>();
        int[] nArray = rows = this._carsTable.getSelectedRows();
        int n = rows.length;
        int n2 = 0;
        while (n2 < n) {
            int row = nArray[n2];
            Car car = this._carsTableModel.getCarAtIndex(this._carsTable.convertRowIndexToModel(row));
            log.debug("Adding selected car {} to change list", (Object)car.toString());
            cars.add(car);
            ++n2;
        }
        if (rows.length == 0) {
            JOptionPane.showMessageDialog(this, Bundle.getMessage("selectCars"), Bundle.getMessage("carNoneSelected"), 2);
            return false;
        }
        if (cars.get(0) != this._car) {
            log.debug("Default car isn't the first one selected");
            if (JOptionPane.showConfirmDialog(this, MessageFormat.format(Bundle.getMessage("doYouWantToChange"), ((Car)cars.get(0)).toString()), Bundle.getMessage("changeDefaultCar"), 0) == 0) {
                super.loadCar((Car)cars.get(0));
                return false;
            }
        }
        this.askKernelChange = true;
        for (Car car : cars) {
            if (!super.change(car)) {
                return false;
            }
            if (car.getKernel() == null || this.ignoreKernelCheckBox.isSelected()) continue;
            this.askKernelChange = false;
        }
        return true;
    }
}

