/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.operations.rollingstock.cars;

import jmri.InstanceManager;
import jmri.InstanceManagerAutoDefault;
import jmri.jmrit.operations.rollingstock.RollingStockAttribute;
import jmri.jmrit.operations.rollingstock.cars.Bundle;
import jmri.jmrit.operations.rollingstock.cars.CarManagerXml;
import jmri.jmrit.operations.setup.Setup;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CarTypes
extends RollingStockAttribute
implements InstanceManagerAutoDefault {
    private static final String TYPES = Bundle.getMessage("carTypeNames");
    private static final String CONVERT_TYPES = Bundle.getMessage("carTypeConvert");
    private static final String ARR_TYPES = Bundle.getMessage("carTypeARR");
    public static final String CARTYPES_CHANGED_PROPERTY = "CarTypes Length";
    public static final String CARTYPES_NAME_CHANGED_PROPERTY = "CarTypes Name";
    private static final Logger log = LoggerFactory.getLogger(CarTypes.class);

    @Override
    protected String getDefaultNames() {
        if (Setup.getCarTypes().equals(Setup.AAR)) {
            return ARR_TYPES;
        }
        return TYPES;
    }

    public void changeDefaultNames(String type) {
        String[] types;
        String[] convert = CONVERT_TYPES.split(",");
        if (convert.length != (types = TYPES.split(",")).length) {
            log.warn("Properties file doesn't have equal length conversion strings, carTypeNames {}, carTypeConvert {}", (Object)types.length, (Object)convert.length);
            return;
        }
        if (type.equals(Setup.DESCRIPTIVE)) {
            int i = 0;
            while (i < convert.length) {
                this.replaceName(convert[i], types[i]);
                ++i;
            }
            String[] aarTypes = ARR_TYPES.split(",");
            int i2 = 0;
            while (i2 < aarTypes.length) {
                this.list.remove(aarTypes[i2]);
                ++i2;
            }
            i2 = 0;
            while (i2 < types.length) {
                if (!this.list.contains(types[i2])) {
                    this.list.add(types[i2]);
                }
                ++i2;
            }
        } else {
            int i = 0;
            while (i < convert.length) {
                this.replaceName(types[i], convert[i]);
                ++i;
            }
            i = 0;
            while (i < types.length) {
                this.list.remove(types[i]);
                ++i;
            }
            types = ARR_TYPES.split(",");
            i = 0;
            while (i < types.length) {
                if (!this.list.contains(types[i])) {
                    this.list.add(types[i]);
                }
                ++i;
            }
        }
    }

    @Override
    public void addName(String type) {
        super.addName(type);
        this.setDirtyAndFirePropertyChange(CARTYPES_CHANGED_PROPERTY, null, type);
    }

    @Override
    public void deleteName(String type) {
        super.deleteName(type);
        this.setDirtyAndFirePropertyChange(CARTYPES_CHANGED_PROPERTY, type, null);
    }

    public void replaceName(String oldName, String newName) {
        super.addName(newName);
        this.setDirtyAndFirePropertyChange(CARTYPES_NAME_CHANGED_PROPERTY, oldName, newName);
        super.deleteName(oldName);
    }

    @Override
    public int getMaxNameLength() {
        if (this.maxNameSubStringLength == 0) {
            super.getMaxNameSubStringLength();
            log.info("Max car type name ({}) length {}", (Object)this.maxName, (Object)this.maxNameSubStringLength);
        }
        return this.maxNameSubStringLength;
    }

    public int getMaxFullNameLength() {
        return super.getMaxNameLength();
    }

    public void store(Element root) {
        this.store(root, "types", "type");
    }

    public void load(Element root) {
        this.load(root, "types", "type", "carTypes");
    }

    protected void setDirtyAndFirePropertyChange(String p, Object old, Object n) {
        InstanceManager.getDefault(CarManagerXml.class).setDirty(true);
        super.firePropertyChange(p, old, n);
    }
}

