/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.operations.rollingstock.cars;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.text.MessageFormat;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import jmri.InstanceManager;
import jmri.jmrit.operations.OperationsXml;
import jmri.jmrit.operations.locations.Location;
import jmri.jmrit.operations.locations.LocationManager;
import jmri.jmrit.operations.locations.Track;
import jmri.jmrit.operations.locations.divisions.Division;
import jmri.jmrit.operations.locations.divisions.DivisionEditFrame;
import jmri.jmrit.operations.locations.divisions.DivisionManager;
import jmri.jmrit.operations.rollingstock.RollingStock;
import jmri.jmrit.operations.rollingstock.RollingStockSetFrame;
import jmri.jmrit.operations.rollingstock.cars.Bundle;
import jmri.jmrit.operations.rollingstock.cars.Car;
import jmri.jmrit.operations.rollingstock.cars.CarLoads;
import jmri.jmrit.operations.rollingstock.cars.CarManager;
import jmri.jmrit.operations.rollingstock.cars.KernelManager;
import jmri.jmrit.operations.rollingstock.cars.tools.CarAttributeEditFrame;
import jmri.jmrit.operations.rollingstock.cars.tools.CarLoadEditFrame;
import jmri.jmrit.operations.rollingstock.cars.tools.EnableDestinationAction;
import jmri.jmrit.operations.setup.Setup;
import jmri.jmrit.operations.trains.Train;
import jmri.jmrit.operations.trains.tools.TrainByCarTypeFrame;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CarSetFrame
extends RollingStockSetFrame<Car> {
    protected static final ResourceBundle rb = ResourceBundle.getBundle("jmri.jmrit.operations.rollingstock.cars.JmritOperationsCarsBundle");
    private static final String IGNORE = "Ignore";
    private static final String KERNEL = "Kernel";
    private static final String TIP_IGNORE = "TipIgnore";
    CarManager carManager = InstanceManager.getDefault(CarManager.class);
    CarLoads carLoads = InstanceManager.getDefault(CarLoads.class);
    Car _car;
    protected JComboBox<Division> divisionComboBox = InstanceManager.getDefault(DivisionManager.class).getComboBox();
    protected JComboBox<Location> destReturnWhenEmptyBox = InstanceManager.getDefault(LocationManager.class).getComboBox();
    protected JComboBox<Track> trackReturnWhenEmptyBox = new JComboBox();
    protected JComboBox<String> loadReturnWhenEmptyBox = this.carLoads.getComboBox(null);
    protected JComboBox<Location> destReturnWhenLoadedBox = InstanceManager.getDefault(LocationManager.class).getComboBox();
    protected JComboBox<Track> trackReturnWhenLoadedBox = new JComboBox();
    protected JComboBox<String> loadReturnWhenLoadedBox = this.carLoads.getComboBox(null);
    JComboBox<String> loadComboBox = this.carLoads.getComboBox(null);
    JComboBox<String> kernelComboBox = InstanceManager.getDefault(KernelManager.class).getComboBox();
    JButton editDivisionButton = new JButton(Bundle.getMessage("ButtonEdit"));
    JButton editLoadButton = new JButton(Bundle.getMessage("ButtonEdit"));
    JButton editKernelButton = new JButton(Bundle.getMessage("ButtonEdit"));
    protected JCheckBox ignoreDivisionCheckBox = new JCheckBox(Bundle.getMessage("Ignore"));
    protected JCheckBox ignoreRWECheckBox = new JCheckBox(Bundle.getMessage("Ignore"));
    protected JCheckBox autoReturnWhenEmptyTrackCheckBox = new JCheckBox(Bundle.getMessage("Auto"));
    protected JCheckBox ignoreRWLCheckBox = new JCheckBox(Bundle.getMessage("Ignore"));
    protected JCheckBox autoReturnWhenLoadedTrackCheckBox = new JCheckBox(Bundle.getMessage("Auto"));
    protected JCheckBox ignoreLoadCheckBox = new JCheckBox(Bundle.getMessage("Ignore"));
    protected JCheckBox ignoreKernelCheckBox = new JCheckBox(Bundle.getMessage("Ignore"));
    private static boolean autoReturnWhenEmptyTrackCheckBoxSelected = false;
    private static boolean autoReturnWhenLoadedTrackCheckBoxSelected = false;
    CarLoadEditFrame lef = null;
    DivisionEditFrame def = null;
    private static boolean enableDestination = false;
    CarAttributeEditFrame f;
    TrainByCarTypeFrame tctf = null;
    protected boolean askKernelChange = true;
    private static final Logger log = LoggerFactory.getLogger(CarSetFrame.class);

    public CarSetFrame() {
        super(Bundle.getMessage("TitleCarSet"));
    }

    @Override
    public void initComponents() {
        super.initComponents();
        JMenuBar menuBar = new JMenuBar();
        JMenu toolMenu = new JMenu(Bundle.getMessage("MenuTools"));
        toolMenu.add(new EnableDestinationAction(this));
        menuBar.add(toolMenu);
        this.setJMenuBar(menuBar);
        this.addHelpMenu("package.jmri.jmrit.operations.Operations_CarsSet", true);
        this.editLoadButton.setToolTipText(MessageFormat.format(Bundle.getMessage("TipAddDeleteReplace"), Bundle.getMessage("load")));
        this.editKernelButton.setToolTipText(MessageFormat.format(Bundle.getMessage("TipAddDeleteReplace"), Bundle.getMessage(KERNEL).toLowerCase()));
        this.paneOptional.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("BorderLayoutOptional")));
        this.pOptional.setLayout(new BoxLayout(this.pOptional, 1));
        JPanel pLoad = new JPanel();
        pLoad.setLayout(new GridBagLayout());
        pLoad.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("Load")));
        this.addItemLeft(pLoad, this.ignoreLoadCheckBox, 1, 0);
        this.addItem(pLoad, this.loadComboBox, 2, 0);
        this.addItem(pLoad, this.editLoadButton, 3, 0);
        this.pOptional.add(pLoad);
        JPanel pReturnWhenEmpty = new JPanel();
        pReturnWhenEmpty.setLayout(new GridBagLayout());
        pReturnWhenEmpty.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("BorderLayoutReturnWhenEmpty")));
        this.addItem(pReturnWhenEmpty, new JLabel(Bundle.getMessage("Location")), 1, 0);
        this.addItem(pReturnWhenEmpty, new JLabel(Bundle.getMessage("Track")), 2, 0);
        this.addItem(pReturnWhenEmpty, new JLabel(Bundle.getMessage("Load")), 3, 0);
        this.addItemLeft(pReturnWhenEmpty, this.ignoreRWECheckBox, 0, 1);
        this.addItem(pReturnWhenEmpty, this.destReturnWhenEmptyBox, 1, 1);
        this.addItem(pReturnWhenEmpty, this.trackReturnWhenEmptyBox, 2, 1);
        this.addItem(pReturnWhenEmpty, this.loadReturnWhenEmptyBox, 3, 1);
        this.addItem(pReturnWhenEmpty, this.autoReturnWhenEmptyTrackCheckBox, 4, 1);
        this.pOptional.add(pReturnWhenEmpty);
        JPanel pReturnWhenLoaded = new JPanel();
        pReturnWhenLoaded.setLayout(new GridBagLayout());
        pReturnWhenLoaded.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("BorderLayoutReturnWhenLoaded")));
        this.addItem(pReturnWhenLoaded, new JLabel(Bundle.getMessage("Location")), 1, 0);
        this.addItem(pReturnWhenLoaded, new JLabel(Bundle.getMessage("Track")), 2, 0);
        this.addItem(pReturnWhenLoaded, new JLabel(Bundle.getMessage("Load")), 3, 0);
        this.addItemLeft(pReturnWhenLoaded, this.ignoreRWLCheckBox, 0, 1);
        this.addItem(pReturnWhenLoaded, this.destReturnWhenLoadedBox, 1, 1);
        this.addItem(pReturnWhenLoaded, this.trackReturnWhenLoadedBox, 2, 1);
        this.addItem(pReturnWhenLoaded, this.loadReturnWhenLoadedBox, 3, 1);
        this.addItem(pReturnWhenLoaded, this.autoReturnWhenLoadedTrackCheckBox, 4, 1);
        this.pOptional.add(pReturnWhenLoaded);
        JPanel pDivision = new JPanel();
        pDivision.setLayout(new GridBagLayout());
        pDivision.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("HomeDivision")));
        this.addItemLeft(pDivision, this.ignoreDivisionCheckBox, 1, 0);
        this.addItem(pDivision, this.divisionComboBox, 2, 0);
        this.addItem(pDivision, this.editDivisionButton, 3, 0);
        this.pOptional.add(pDivision);
        JPanel pKernel = new JPanel();
        pKernel.setLayout(new GridBagLayout());
        pKernel.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage(KERNEL)));
        this.addItemLeft(pKernel, this.ignoreKernelCheckBox, 1, 0);
        this.addItem(pKernel, this.kernelComboBox, 2, 0);
        this.addItem(pKernel, this.editKernelButton, 3, 0);
        this.pOptional.add(pKernel);
        this.ignoreDivisionCheckBox.setVisible(false);
        this.ignoreRWECheckBox.setVisible(false);
        this.ignoreRWLCheckBox.setVisible(false);
        this.ignoreLoadCheckBox.setVisible(false);
        this.ignoreKernelCheckBox.setVisible(false);
        this.autoReturnWhenEmptyTrackCheckBox.setSelected(autoReturnWhenEmptyTrackCheckBoxSelected);
        this.autoReturnWhenLoadedTrackCheckBox.setSelected(autoReturnWhenLoadedTrackCheckBoxSelected);
        this.addComboBoxAction(this.destReturnWhenEmptyBox);
        this.addComboBoxAction(this.destReturnWhenLoadedBox);
        this.addComboBoxAction(this.loadComboBox);
        this.addComboBoxAction(this.divisionComboBox);
        this.addButtonAction(this.editLoadButton);
        this.addButtonAction(this.editDivisionButton);
        this.addButtonAction(this.editKernelButton);
        this.addCheckBoxAction(this.ignoreRWECheckBox);
        this.addCheckBoxAction(this.ignoreRWLCheckBox);
        this.addCheckBoxAction(this.autoReturnWhenEmptyTrackCheckBox);
        this.addCheckBoxAction(this.autoReturnWhenLoadedTrackCheckBox);
        this.addCheckBoxAction(this.ignoreLoadCheckBox);
        this.addCheckBoxAction(this.ignoreDivisionCheckBox);
        this.addCheckBoxAction(this.ignoreKernelCheckBox);
        this.ignoreRWECheckBox.setToolTipText(Bundle.getMessage(TIP_IGNORE));
        this.ignoreRWLCheckBox.setToolTipText(Bundle.getMessage(TIP_IGNORE));
        this.ignoreLoadCheckBox.setToolTipText(Bundle.getMessage(TIP_IGNORE));
        this.ignoreDivisionCheckBox.setToolTipText(Bundle.getMessage(TIP_IGNORE));
        this.ignoreKernelCheckBox.setToolTipText(Bundle.getMessage(TIP_IGNORE));
        this.outOfServiceCheckBox.setToolTipText(Bundle.getMessage("TipCarOutOfService"));
        this.autoReturnWhenEmptyTrackCheckBox.setToolTipText(Bundle.getMessage("rsTipAutoTrack"));
        this.carLoads.addPropertyChangeListener(this);
        this.carManager.addPropertyChangeListener(this);
        InstanceManager.getDefault(KernelManager.class).addPropertyChangeListener(this);
        InstanceManager.getDefault(DivisionManager.class).addPropertyChangeListener(this);
        this.packFrame();
    }

    public void loadCar(Car car) {
        this._car = car;
        this.load(car);
        this.updateLoadComboBox();
        this.updateRweLoadComboBox();
        this.updateRwlLoadComboBox();
        this.updateDivisionComboBox();
        this.updateKernelComboBox();
    }

    @Override
    protected ResourceBundle getRb() {
        return rb;
    }

    @Override
    protected void updateComboBoxes() {
        super.updateComboBoxes();
        this.locationManager.updateComboBox(this.destReturnWhenEmptyBox);
        this.locationManager.updateComboBox(this.destReturnWhenLoadedBox);
        this.updateFinalDestinationComboBoxes();
        this.updateReturnWhenEmptyComboBoxes();
        this.updateReturnWhenLoadedComboBoxes();
    }

    @Override
    protected void enableComponents(boolean enabled) {
        if (!Setup.isCarRoutingEnabled()) {
            this.ignoreRWECheckBox.setSelected(true);
            this.ignoreRWLCheckBox.setSelected(true);
            this.ignoreFinalDestinationCheckBox.setSelected(true);
        }
        super.enableComponents(enabled);
        this.ignoreRWECheckBox.setEnabled(Setup.isCarRoutingEnabled() && enabled);
        this.destReturnWhenEmptyBox.setEnabled(!this.ignoreRWECheckBox.isSelected() && enabled);
        this.trackReturnWhenEmptyBox.setEnabled(!this.ignoreRWECheckBox.isSelected() && enabled);
        this.loadReturnWhenEmptyBox.setEnabled(!this.ignoreRWECheckBox.isSelected() && enabled);
        this.autoReturnWhenEmptyTrackCheckBox.setEnabled(!this.ignoreRWECheckBox.isSelected() && enabled);
        this.ignoreRWLCheckBox.setEnabled(Setup.isCarRoutingEnabled() && enabled);
        this.destReturnWhenLoadedBox.setEnabled(!this.ignoreRWLCheckBox.isSelected() && enabled);
        this.trackReturnWhenLoadedBox.setEnabled(!this.ignoreRWLCheckBox.isSelected() && enabled);
        this.loadReturnWhenLoadedBox.setEnabled(!this.ignoreRWLCheckBox.isSelected() && enabled);
        this.autoReturnWhenLoadedTrackCheckBox.setEnabled(!this.ignoreRWLCheckBox.isSelected() && enabled);
        this.ignoreLoadCheckBox.setEnabled(enabled);
        this.loadComboBox.setEnabled(!this.ignoreLoadCheckBox.isSelected() && enabled);
        this.editLoadButton.setEnabled(!this.ignoreLoadCheckBox.isSelected() && enabled && this._car != null);
        this.ignoreDivisionCheckBox.setEnabled(enabled);
        this.divisionComboBox.setEnabled(!this.ignoreDivisionCheckBox.isSelected() && enabled);
        this.editDivisionButton.setEnabled(!this.ignoreDivisionCheckBox.isSelected() && enabled && this._car != null);
        this.ignoreKernelCheckBox.setEnabled(enabled);
        this.kernelComboBox.setEnabled(!this.ignoreKernelCheckBox.isSelected() && enabled);
        this.editKernelButton.setEnabled(!this.ignoreKernelCheckBox.isSelected() && enabled && this._car != null);
        this.enableDestinationFields(enabled);
    }

    private void enableDestinationFields(boolean enabled) {
        boolean enableDest = enableDestination || this.destinationBox.getSelectedItem() != null || this._car != null && this._car.getTrain() != null && this._car.getTrain().isBuilt();
        this.destinationBox.setEnabled(!this.ignoreDestinationCheckBox.isSelected() && enableDest && enabled);
        this.trackDestinationBox.setEnabled(!this.ignoreDestinationCheckBox.isSelected() && enableDest && enabled);
        this.autoDestinationTrackCheckBox.setEnabled(!this.ignoreDestinationCheckBox.isSelected() && enableDest && enabled);
    }

    @Override
    public void comboBoxActionPerformed(ActionEvent ae) {
        super.comboBoxActionPerformed(ae);
        if (ae.getSource() == this.finalDestinationBox) {
            this.updateFinalDestination();
        }
        if (ae.getSource() == this.destReturnWhenEmptyBox) {
            this.updateReturnWhenEmpty();
        }
        if (ae.getSource() == this.destReturnWhenLoadedBox) {
            this.updateReturnWhenLoaded();
        }
    }

    @Override
    public void buttonActionPerformed(ActionEvent ae) {
        super.buttonActionPerformed(ae);
        if (ae.getSource() == this.editLoadButton && this._car != null) {
            if (this.lef != null) {
                this.lef.dispose();
            }
            this.lef = new CarLoadEditFrame();
            this.lef.setLocationRelativeTo(this);
            this.lef.initComponents(this._car.getTypeName(), (String)this.loadComboBox.getSelectedItem());
        }
        if (ae.getSource() == this.editKernelButton) {
            if (this.f != null) {
                this.f.dispose();
            }
            this.f = new CarAttributeEditFrame();
            this.f.setLocationRelativeTo(this);
            this.f.addPropertyChangeListener(this);
            this.f.initComponents(KERNEL, (String)this.kernelComboBox.getSelectedItem());
        }
        if (ae.getSource() == this.editDivisionButton) {
            if (this.def != null) {
                this.def.dispose();
            }
            this.def = new DivisionEditFrame((Division)this.divisionComboBox.getSelectedItem());
        }
    }

    @Override
    protected boolean save() {
        if (this.change(this._car)) {
            OperationsXml.save();
            return true;
        }
        return false;
    }

    @SuppressFBWarnings(value={"ST_WRITE_TO_STATIC_FROM_INSTANCE_METHOD"}, justification="GUI ease of use")
    protected boolean change(Car car) {
        List<Car> list;
        Track track;
        String status;
        autoReturnWhenEmptyTrackCheckBoxSelected = this.autoReturnWhenEmptyTrackCheckBox.isSelected();
        autoReturnWhenLoadedTrackCheckBoxSelected = this.autoReturnWhenLoadedTrackCheckBox.isSelected();
        if (!this.ignoreLoadCheckBox.isSelected() && this.loadComboBox.getSelectedItem() != null) {
            String load = (String)this.loadComboBox.getSelectedItem();
            if (!car.getLoadName().equals(load)) {
                if (this.carLoads.containsName(car.getTypeName(), load)) {
                    car.setLoadName(load);
                    this.updateComboBoxesLoadChange();
                } else {
                    JOptionPane.showMessageDialog(this, MessageFormat.format(Bundle.getMessage("carLoadNotValid"), load, car.getTypeName()), Bundle.getMessage("carCanNotChangeLoad"), 2);
                }
            }
        }
        if (!this.ignoreFinalDestinationCheckBox.isSelected()) {
            if (this.finalDestinationBox.getSelectedItem() == null) {
                car.setFinalDestination(null);
                car.setFinalDestinationTrack(null);
            } else {
                Track finalDestTrack = null;
                if (this.finalDestTrackBox.getSelectedItem() != null) {
                    finalDestTrack = (Track)this.finalDestTrackBox.getSelectedItem();
                }
                if (finalDestTrack != null && car.getFinalDestinationTrack() != finalDestTrack && finalDestTrack.isStaging()) {
                    log.debug("Destination track ({}) is staging", (Object)finalDestTrack.getName());
                    JOptionPane.showMessageDialog(this, Bundle.getMessage("rsDoNotSelectStaging"), Bundle.getMessage("rsCanNotFinal"), 0);
                    return false;
                }
                car.setFinalDestination((Location)this.finalDestinationBox.getSelectedItem());
                car.setFinalDestinationTrack(finalDestTrack);
                String status2 = car.testDestination((Location)this.finalDestinationBox.getSelectedItem(), finalDestTrack);
                if (!status2.equals(Track.OKAY)) {
                    JOptionPane.showMessageDialog(this, MessageFormat.format(Bundle.getMessage("rsCanNotFinalMsg"), car.toString(), status2), Bundle.getMessage("rsCanNotFinal"), 2);
                }
            }
        }
        if (!this.ignoreDivisionCheckBox.isSelected()) {
            car.setDivision((Division)this.divisionComboBox.getSelectedItem());
        }
        if (!this.ignoreKernelCheckBox.isSelected() && this.kernelComboBox.getSelectedItem() != null) {
            if (this.kernelComboBox.getSelectedItem().equals("")) {
                car.setKernel(null);
            } else if (!car.getKernelName().equals(this.kernelComboBox.getSelectedItem())) {
                car.setKernel(InstanceManager.getDefault(KernelManager.class).getKernelByName((String)this.kernelComboBox.getSelectedItem()));
                if (car.hasFred() || car.isCaboose()) {
                    car.getKernel().setLead(car);
                }
                car.setBlocking(car.getKernel().getSize());
            }
        }
        Track saveTrack = car.getTrack();
        if (!super.change(car)) {
            return false;
        }
        if (!this.ignoreRWECheckBox.isSelected()) {
            if (this.carLoads.getNames(car.getTypeName()).contains(this.loadReturnWhenEmptyBox.getSelectedItem())) {
                car.setReturnWhenEmptyLoadName((String)this.loadReturnWhenEmptyBox.getSelectedItem());
            } else {
                log.debug("Car ({}) type ({}) doesn't support RWE load ({})", new Object[]{car, car.getTypeName(), this.loadReturnWhenEmptyBox.getSelectedItem()});
                JOptionPane.showMessageDialog(this, MessageFormat.format(Bundle.getMessage("carLoadNotValid"), this.loadReturnWhenEmptyBox.getSelectedItem(), car.getTypeName()), Bundle.getMessage("carCanNotChangeRweLoad"), 2);
            }
            if (this.destReturnWhenEmptyBox.getSelectedItem() == null) {
                car.setReturnWhenEmptyDestination(null);
                car.setReturnWhenEmptyDestTrack(null);
            } else {
                Location locationRWE = (Location)this.destReturnWhenEmptyBox.getSelectedItem();
                if (this.trackReturnWhenEmptyBox.getSelectedItem() != null) {
                    Track trackRWE = (Track)this.trackReturnWhenEmptyBox.getSelectedItem();
                    if (trackRWE != null && trackRWE.isStaging()) {
                        log.debug("Return when empty track ({}) is staging", (Object)trackRWE.getName());
                        JOptionPane.showMessageDialog(this, Bundle.getMessage("rsDoNotSelectStaging"), Bundle.getMessage("carCanNotRWE"), 0);
                        return false;
                    }
                    status = this.getTestCar(car, car.getReturnWhenEmptyLoadName()).testDestination(locationRWE, trackRWE);
                    if (!status.equals(Track.OKAY)) {
                        JOptionPane.showMessageDialog(this, MessageFormat.format(Bundle.getMessage("carCanNotRWEMsg"), car.toString(), status), Bundle.getMessage("carCanNotRWE"), 2);
                    }
                    car.setReturnWhenEmptyDestTrack(trackRWE);
                } else {
                    car.setReturnWhenEmptyDestTrack(null);
                }
                car.setReturnWhenEmptyDestination(locationRWE);
            }
        }
        if (!this.ignoreRWLCheckBox.isSelected()) {
            if (this.carLoads.getNames(car.getTypeName()).contains(this.loadReturnWhenLoadedBox.getSelectedItem())) {
                car.setReturnWhenLoadedLoadName((String)this.loadReturnWhenLoadedBox.getSelectedItem());
            } else {
                log.debug("Car ({}) type ({}) doesn't support RWL load ({})", new Object[]{car, car.getTypeName(), this.loadReturnWhenLoadedBox.getSelectedItem()});
                JOptionPane.showMessageDialog(this, MessageFormat.format(Bundle.getMessage("carLoadNotValid"), this.loadReturnWhenEmptyBox.getSelectedItem(), car.getTypeName()), Bundle.getMessage("carCanNotChangeRwlLoad"), 2);
            }
            if (this.destReturnWhenLoadedBox.getSelectedItem() == null) {
                car.setReturnWhenLoadedDestination(null);
                car.setReturnWhenLoadedDestTrack(null);
            } else {
                Location locationRWL = (Location)this.destReturnWhenLoadedBox.getSelectedItem();
                if (this.trackReturnWhenLoadedBox.getSelectedItem() != null) {
                    Track trackRWL = (Track)this.trackReturnWhenLoadedBox.getSelectedItem();
                    if (trackRWL != null && trackRWL.isStaging()) {
                        log.debug("Return when loaded track ({}) is staging", (Object)trackRWL.getName());
                        JOptionPane.showMessageDialog(this, Bundle.getMessage("rsDoNotSelectStaging"), Bundle.getMessage("carCanNotRWL"), 0);
                        return false;
                    }
                    status = this.getTestCar(car, car.getReturnWhenLoadedLoadName()).testDestination(locationRWL, trackRWL);
                    if (!status.equals(Track.OKAY)) {
                        JOptionPane.showMessageDialog(this, MessageFormat.format(Bundle.getMessage("carCanNotRWLMsg"), car.toString(), status), Bundle.getMessage("carCanNotRWL"), 2);
                    }
                    car.setReturnWhenLoadedDestTrack(trackRWL);
                } else {
                    car.setReturnWhenLoadedDestTrack(null);
                }
                car.setReturnWhenLoadedDestination(locationRWL);
            }
        }
        if (!this.ignoreLocationCheckBox.isSelected() && this.trackLocationBox.getSelectedItem() != null && saveTrack != this.trackLocationBox.getSelectedItem() && (track = (Track)this.trackLocationBox.getSelectedItem()).getSchedule() != null && JOptionPane.showConfirmDialog(this, MessageFormat.format(Bundle.getMessage("rsDoYouWantSchedule"), car.toString()), MessageFormat.format(Bundle.getMessage("rsSpurHasSchedule"), track.getName(), track.getScheduleName()), 0) == 0) {
            String results = track.checkSchedule(car);
            if (!results.equals(Track.OKAY)) {
                JOptionPane.showMessageDialog(this, MessageFormat.format(Bundle.getMessage("rsNotAbleToApplySchedule"), results), Bundle.getMessage("rsApplyingScheduleFailed"), 0);
                if (saveTrack != null) {
                    car.setLocation(saveTrack.getLocation(), saveTrack);
                } else {
                    car.setLocation(null, null);
                }
                return false;
            }
            track.scheduleNext(car);
            car.loadNext(track);
        }
        if (car.getTrain() != null) {
            Train train = car.getTrain();
            if (!train.isLoadNameAccepted(car.getLoadName(), car.getTypeName())) {
                JOptionPane.showMessageDialog(this, MessageFormat.format(Bundle.getMessage("carTrainNotServLoad"), car.getLoadName(), train.getName()), Bundle.getMessage("rsNotMove"), 0);
                this.setRouteLocationAndDestination(car, train, null, null);
                return false;
            }
            if (car.getLocation() != null && car.getDestination() != null && !train.isServiceable(car)) {
                JOptionPane.showMessageDialog(this, MessageFormat.format(Bundle.getMessage("carTrainNotService"), car.toString(), train.getName()), Bundle.getMessage("rsNotMove"), 0);
                if (this.tctf != null) {
                    this.tctf.dispose();
                }
                this.tctf = new TrainByCarTypeFrame(car);
                this.setRouteLocationAndDestination(car, train, null, null);
                return false;
            }
        }
        this.checkTrain(car);
        if (this.askKernelChange && car.getKernel() != null && (list = car.getKernel().getCars()).size() > 1) {
            if (JOptionPane.showConfirmDialog(this, MessageFormat.format(Bundle.getMessage("carInKernel"), car.toString()), MessageFormat.format(Bundle.getMessage("carPartKernel"), car.getKernelName()), 0) == 0) {
                if (!this.updateGroup(list)) {
                    return false;
                }
            } else if (this.outOfServiceCheckBox.isSelected()) {
                car.setKernel(null);
            }
        }
        return true;
    }

    protected void updateComboBoxesLoadChange() {
        if (this.autoTrackCheckBox.isSelected()) {
            this.updateLocationTrackComboBox();
        }
        if (this.autoDestinationTrackCheckBox.isSelected()) {
            this.updateDestinationTrackComboBox();
        }
        if (this.autoFinalDestTrackCheckBox.isSelected()) {
            this.updateFinalDestination();
        }
    }

    @Override
    protected boolean updateGroup(List<Car> list) {
        for (Car car : list) {
            if (car == this._car) continue;
            if (!this.ignoreRWECheckBox.isSelected()) {
                car.setReturnWhenEmptyDestination(this._car.getReturnWhenEmptyDestination());
                car.setReturnWhenEmptyDestTrack(this._car.getReturnWhenEmptyDestTrack());
            }
            if (!this.ignoreRWLCheckBox.isSelected()) {
                car.setReturnWhenLoadedDestination(this._car.getReturnWhenLoadedDestination());
                car.setReturnWhenLoadedDestTrack(this._car.getReturnWhenLoadedDestTrack());
            }
            if (!this.ignoreFinalDestinationCheckBox.isSelected()) {
                car.setFinalDestination(this._car.getFinalDestination());
                car.setFinalDestinationTrack(this._car.getFinalDestinationTrack());
            }
            if (!this.ignoreLoadCheckBox.isSelected() && this.carLoads.containsName(car.getTypeName(), this._car.getLoadName())) {
                car.setLoadName(this._car.getLoadName());
            }
            if (!this.ignoreKernelCheckBox.isSelected()) {
                car.setKernel(this._car.getKernel());
            }
            if (this.ignoreDivisionCheckBox.isSelected()) continue;
            car.setDivision(this._car.getDivision());
        }
        return super.updateGroup(list);
    }

    @Override
    public void checkBoxActionPerformed(ActionEvent ae) {
        super.checkBoxActionPerformed(ae);
        if (ae.getSource() == this.autoFinalDestTrackCheckBox) {
            this.updateFinalDestination();
        }
        if (ae.getSource() == this.autoReturnWhenEmptyTrackCheckBox) {
            this.updateReturnWhenEmpty();
        }
        if (ae.getSource() == this.autoReturnWhenLoadedTrackCheckBox) {
            this.updateReturnWhenLoaded();
        }
        if (ae.getSource() == this.autoTrainCheckBox) {
            this.updateTrainComboBox();
        }
        if (ae.getSource() == this.ignoreDestinationCheckBox) {
            this.divisionComboBox.setEnabled(!this.ignoreDestinationCheckBox.isSelected());
        }
        if (ae.getSource() == this.ignoreRWECheckBox) {
            this.destReturnWhenEmptyBox.setEnabled(!this.ignoreRWECheckBox.isSelected());
            this.trackReturnWhenEmptyBox.setEnabled(!this.ignoreRWECheckBox.isSelected());
            this.loadReturnWhenEmptyBox.setEnabled(!this.ignoreRWECheckBox.isSelected());
            this.autoReturnWhenEmptyTrackCheckBox.setEnabled(!this.ignoreRWECheckBox.isSelected());
        }
        if (ae.getSource() == this.ignoreRWLCheckBox) {
            this.destReturnWhenLoadedBox.setEnabled(!this.ignoreRWLCheckBox.isSelected());
            this.trackReturnWhenLoadedBox.setEnabled(!this.ignoreRWLCheckBox.isSelected());
            this.loadReturnWhenLoadedBox.setEnabled(!this.ignoreRWLCheckBox.isSelected());
            this.autoReturnWhenLoadedTrackCheckBox.setEnabled(!this.ignoreRWLCheckBox.isSelected());
        }
        if (ae.getSource() == this.ignoreLoadCheckBox) {
            this.loadComboBox.setEnabled(!this.ignoreLoadCheckBox.isSelected());
            this.editLoadButton.setEnabled(!this.ignoreLoadCheckBox.isSelected() && this._car != null);
        }
        if (ae.getSource() == this.ignoreDivisionCheckBox) {
            this.divisionComboBox.setEnabled(!this.ignoreDivisionCheckBox.isSelected());
            this.editDivisionButton.setEnabled(!this.ignoreDivisionCheckBox.isSelected());
        }
        if (ae.getSource() == this.ignoreKernelCheckBox) {
            this.kernelComboBox.setEnabled(!this.ignoreKernelCheckBox.isSelected());
            this.editKernelButton.setEnabled(!this.ignoreKernelCheckBox.isSelected());
        }
    }

    protected void updateReturnWhenEmptyComboBoxes() {
        if (this._car != null) {
            log.debug("Updating return when empty for car ({})", (Object)this._car);
            this.destReturnWhenEmptyBox.setSelectedItem(this._car.getReturnWhenEmptyDestination());
        }
        this.updateReturnWhenEmpty();
    }

    protected void updateReturnWhenEmpty() {
        if (this.destReturnWhenEmptyBox.getSelectedItem() == null) {
            this.trackReturnWhenEmptyBox.removeAllItems();
        } else {
            log.debug("CarSetFrame sees return when empty: {}", this.destReturnWhenEmptyBox.getSelectedItem());
            Location loc = (Location)this.destReturnWhenEmptyBox.getSelectedItem();
            loc.updateComboBox(this.trackReturnWhenEmptyBox, this.getTestCar(this._car, this._car.getReturnWhenEmptyLoadName()), this.autoReturnWhenEmptyTrackCheckBox.isSelected(), true);
            if (this._car != null && this._car.getReturnWhenEmptyDestination() != null && this._car.getReturnWhenEmptyDestination().equals(loc) && this._car.getReturnWhenEmptyDestTrack() != null) {
                this.trackReturnWhenEmptyBox.setSelectedItem(this._car.getReturnWhenEmptyDestTrack());
            }
        }
    }

    protected void updateReturnWhenLoadedComboBoxes() {
        if (this._car != null) {
            log.debug("Updating return when loaded for car ({})", (Object)this._car);
            this.destReturnWhenLoadedBox.setSelectedItem(this._car.getReturnWhenLoadedDestination());
        }
        this.updateReturnWhenLoaded();
    }

    protected void updateReturnWhenLoaded() {
        if (this.destReturnWhenLoadedBox.getSelectedItem() == null) {
            this.trackReturnWhenLoadedBox.removeAllItems();
        } else {
            log.debug("CarSetFrame sees return when empty: {}", this.destReturnWhenLoadedBox.getSelectedItem());
            Location loc = (Location)this.destReturnWhenLoadedBox.getSelectedItem();
            loc.updateComboBox(this.trackReturnWhenLoadedBox, this.getTestCar(this._car, this._car.getReturnWhenLoadedLoadName()), this.autoReturnWhenLoadedTrackCheckBox.isSelected(), true);
            if (this._car != null && this._car.getReturnWhenLoadedDestination() != null && this._car.getReturnWhenLoadedDestination().equals(loc) && this._car.getReturnWhenLoadedDestTrack() != null) {
                this.trackReturnWhenLoadedBox.setSelectedItem(this._car.getReturnWhenLoadedDestTrack());
            }
        }
    }

    protected void updateFinalDestinationComboBoxes() {
        if (this._car != null) {
            log.debug("Updating final destinations for car ({})", (Object)this._car);
            this.finalDestinationBox.setSelectedItem(this._car.getFinalDestination());
        }
        this.updateFinalDestination();
    }

    protected void updateFinalDestination() {
        if (this.finalDestinationBox.getSelectedItem() == null) {
            this.finalDestTrackBox.removeAllItems();
        } else {
            log.debug("CarSetFrame sees final destination: {}", this.finalDestinationBox.getSelectedItem());
            Location l = (Location)this.finalDestinationBox.getSelectedItem();
            l.updateComboBox(this.finalDestTrackBox, this._car, this.autoFinalDestTrackCheckBox.isSelected(), true);
            if (this._car != null && this._car.getFinalDestination() != null && this._car.getFinalDestination().equals(l) && this._car.getFinalDestinationTrack() != null) {
                this.finalDestTrackBox.setSelectedItem(this._car.getFinalDestinationTrack());
            }
        }
    }

    protected void updateLoadComboBox() {
        if (this._car != null) {
            log.debug("Updating load box for car ({})", (Object)this._car);
            this.carLoads.updateComboBox(this._car.getTypeName(), this.loadComboBox);
            this.loadComboBox.setSelectedItem(this._car.getLoadName());
        }
    }

    protected void updateRweLoadComboBox() {
        if (this._car != null) {
            log.debug("Updating RWE load box for car ({})", (Object)this._car);
            this.carLoads.updateRweComboBox(this._car.getTypeName(), this.loadReturnWhenEmptyBox);
            this.loadReturnWhenEmptyBox.setSelectedItem(this._car.getReturnWhenEmptyLoadName());
        }
    }

    protected void updateRwlLoadComboBox() {
        if (this._car != null) {
            log.debug("Updating RWL load box for car ({})", (Object)this._car);
            this.carLoads.updateRwlComboBox(this._car.getTypeName(), this.loadReturnWhenLoadedBox);
            this.loadReturnWhenLoadedBox.setSelectedItem(this._car.getReturnWhenLoadedLoadName());
        }
    }

    protected void updateKernelComboBox() {
        InstanceManager.getDefault(KernelManager.class).updateComboBox(this.kernelComboBox);
        if (this._car != null) {
            this.kernelComboBox.setSelectedItem(this._car.getKernelName());
        }
    }

    protected void updateDivisionComboBox() {
        InstanceManager.getDefault(DivisionManager.class).updateComboBox(this.divisionComboBox);
        if (this._car != null) {
            this.divisionComboBox.setSelectedItem(this._car.getDivision());
        }
    }

    @Override
    protected void updateTrainComboBox() {
        log.debug("update train combo box");
        if (this._car != null && this.autoTrainCheckBox.isSelected()) {
            log.debug("Updating train box for car ({})", (Object)this._car);
            this.trainManager.updateTrainComboBox(this.trainBox, this._car);
        } else {
            this.trainManager.updateTrainComboBox(this.trainBox);
        }
        if (this._car != null) {
            this.trainBox.setSelectedItem(this._car.getTrain());
        }
    }

    private Car getTestCar(Car car, String loadName) {
        Car c = car;
        if (car != null) {
            c = car.copy();
            c.setLoadName(loadName);
            c.setLength(Integer.toString(-RollingStock.COUPLERS));
        }
        return c;
    }

    @SuppressFBWarnings(value={"ST_WRITE_TO_STATIC_FROM_INSTANCE_METHOD"}, justification="GUI ease of use")
    public void setDestinationEnabled(boolean enable) {
        enableDestination = !enableDestination;
        this.enableDestinationFields(!this.locationUnknownCheckBox.isSelected());
    }

    @Override
    public void dispose() {
        InstanceManager.getDefault(CarLoads.class).removePropertyChangeListener(this);
        InstanceManager.getDefault(KernelManager.class).removePropertyChangeListener(this);
        InstanceManager.getDefault(DivisionManager.class).removePropertyChangeListener(this);
        this.carManager.removePropertyChangeListener(this);
        super.dispose();
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        log.debug("PropertyChange ({}) new ({})", (Object)e.getPropertyName(), e.getNewValue());
        super.propertyChange(e);
        if (e.getPropertyName().equals("Car final destination changed") || e.getPropertyName().equals("Car final destination track changed")) {
            this.updateFinalDestinationComboBoxes();
        }
        if (e.getPropertyName().equals("CarLoads_Load") || e.getPropertyName().equals("Car load changed")) {
            this.updateLoadComboBox();
        }
        if (e.getPropertyName().equals("CarLoads_Load") || e.getPropertyName().equals("CarLoads_Load_Type") || e.getPropertyName().equals("Car RWE load changed")) {
            this.updateRweLoadComboBox();
        }
        if (e.getPropertyName().equals("CarLoads_Load") || e.getPropertyName().equals("CarLoads_Load_Type") || e.getPropertyName().equals("Car RWL load changed")) {
            this.updateRwlLoadComboBox();
        }
        if (e.getPropertyName().equals("Car return when empty changed")) {
            this.updateReturnWhenEmptyComboBoxes();
        }
        if (e.getPropertyName().equals("Car return when loaded changed")) {
            this.updateReturnWhenLoadedComboBoxes();
        }
        if (e.getPropertyName().equals("GroupListLengthChanged") || e.getPropertyName().equals("kernel name changed")) {
            this.updateKernelComboBox();
        }
        if (e.getPropertyName().equals("divisionsListLength")) {
            this.updateDivisionComboBox();
        }
        if (e.getPropertyName().equals("rolling stock train")) {
            this.enableDestinationFields(!this.locationUnknownCheckBox.isSelected());
        }
        if (e.getPropertyName().equals("dispose")) {
            this.f = null;
        }
    }
}

