/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.operations.rollingstock.cars;

import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import jmri.InstanceManager;
import jmri.InstanceManagerAutoDefault;
import jmri.InstanceManagerAutoInitialize;
import jmri.jmrit.operations.rollingstock.RollingStockManager;
import jmri.jmrit.operations.rollingstock.cars.Car;
import jmri.jmrit.operations.rollingstock.cars.CarLoad;
import jmri.jmrit.operations.rollingstock.cars.CarLoads;
import jmri.jmrit.operations.rollingstock.cars.CarManagerXml;
import jmri.jmrit.operations.rollingstock.cars.Kernel;
import jmri.jmrit.operations.routes.Route;
import jmri.jmrit.operations.routes.RouteLocation;
import jmri.jmrit.operations.setup.OperationsSetupXml;
import jmri.jmrit.operations.setup.Setup;
import jmri.jmrit.operations.trains.Train;
import org.jdom2.Content;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CarManager
extends RollingStockManager<Car>
implements InstanceManagerAutoDefault,
InstanceManagerAutoInitialize {
    protected Hashtable<String, Kernel> _kernelHashTable = new Hashtable();
    private static final int BY_LOAD = 4;
    private static final int BY_KERNEL = 5;
    private static final int BY_RWE = 13;
    private static final int BY_FINAL_DEST = 14;
    private static final int BY_WAIT = 16;
    private static final int BY_PICKUP = 19;
    private static final int BY_HAZARD = 21;
    private static final int BY_RWL = 22;
    private static final int BY_DIVISION = 23;
    private static final Logger log = LoggerFactory.getLogger(CarManager.class);

    @Override
    public Car newRS(String road, String number) {
        Car car = (Car)this.getByRoadAndNumber(road, number);
        if (car == null) {
            car = new Car(road, number);
            this.register(car);
        }
        return car;
    }

    @Override
    public void deregister(Car car) {
        super.deregister(car);
        InstanceManager.getDefault(CarManagerXml.class).setDirty(true);
    }

    @Override
    public List<Car> getByLocationList() {
        return this.getByList(this.getByKernelList(), 6);
    }

    public List<Car> getByKernelList() {
        return this.getByList(this.getByList(this.getByNumberList(), 18), 5);
    }

    public List<Car> getByLoadList() {
        return this.getByList(this.getByLocationList(), 4);
    }

    public List<Car> getByRweList() {
        return this.getByList(this.getByLocationList(), 13);
    }

    public List<Car> getByRwlList() {
        return this.getByList(this.getByLocationList(), 22);
    }

    public List<Car> getByDivisionList() {
        return this.getByList(this.getByLocationList(), 23);
    }

    public List<Car> getByFinalDestinationList() {
        return this.getByList(this.getByDestinationList(), 14);
    }

    public List<Car> getByWaitList() {
        return this.getByList(this.getByIdList(), 16);
    }

    public List<Car> getByPickupList() {
        return this.getByList(this.getByIdList(), 19);
    }

    @Override
    protected Comparator<Car> getComparator(int attribute) {
        switch (attribute) {
            case 4: {
                return (c1, c2) -> c1.getLoadName().compareToIgnoreCase(c2.getLoadName());
            }
            case 5: {
                return (c1, c2) -> c1.getKernelName().compareToIgnoreCase(c2.getKernelName());
            }
            case 13: {
                return (c1, c2) -> c1.getReturnWhenEmptyDestName().compareToIgnoreCase(c2.getReturnWhenEmptyDestName());
            }
            case 22: {
                return (c1, c2) -> c1.getReturnWhenLoadedDestName().compareToIgnoreCase(c2.getReturnWhenLoadedDestName());
            }
            case 14: {
                return (c1, c2) -> c1.getFinalDestinationName().compareToIgnoreCase(c2.getFinalDestinationName());
            }
            case 23: {
                return (c1, c2) -> c1.getDivisionName().compareToIgnoreCase(c2.getDivisionName());
            }
            case 16: {
                return (c1, c2) -> c1.getWait() - c2.getWait();
            }
            case 19: {
                return (c1, c2) -> c1.getPickupScheduleName().compareToIgnoreCase(c2.getPickupScheduleName());
            }
            case 21: {
                return (c1, c2) -> (c1.isHazardous() ? 1 : 0) - (c2.isHazardous() ? 1 : 0);
            }
        }
        return super.getComparator(attribute);
    }

    public List<Car> getAvailableTrainList(Train train) {
        ArrayList<Car> out = new ArrayList<Car>();
        Route route = train.getRoute();
        if (route == null) {
            return out;
        }
        List<RouteLocation> routeList = route.getLocationsBySequenceList();
        RouteLocation destination = null;
        if (routeList.size() > 1) {
            destination = routeList.get(routeList.size() - 1);
            int i = 0;
            while (i < routeList.size() - 1) {
                if (destination.getName().equals(routeList.get(i).getName())) {
                    destination = null;
                    break;
                }
                ++i;
            }
            if (destination != null && destination.isPickUpAllowed() && destination.getLocation() != null && !destination.getLocation().isStaging()) {
                destination = null;
            }
        }
        List<Car> sortByPriority = this.sortByPriority(this.getByMovesList());
        for (Car car : sortByPriority) {
            RouteLocation rl;
            if (car.getLocation() == null || (rl = route.getLastLocationByName(car.getLocationName())) == null || rl == destination || car.getTrain() != null && !train.equals(car.getTrain())) continue;
            out.add(car);
        }
        return out;
    }

    protected List<Car> sortByPriority(List<Car> list) {
        ArrayList<Car> out = new ArrayList<Car>();
        for (Car car : list) {
            if (!car.getLoadPriority().equals(CarLoad.PRIORITY_HIGH)) continue;
            out.add(car);
        }
        for (Car car : list) {
            if (!car.getLoadPriority().equals(CarLoad.PRIORITY_MEDIUM)) continue;
            out.add(car);
        }
        for (Car car : list) {
            if (out.contains(car)) continue;
            out.add(car);
        }
        return out;
    }

    public List<Car> getByTrainDestinationList(Train train) {
        List byHazard = this.getByList(this.getList(train), 21);
        List byFinal = this.getByList(byHazard, 14);
        List byLocation = this.getByList(byFinal, 6);
        List byDestination = this.getByList(byLocation, 7);
        ArrayList<Car> out = new ArrayList<Car>();
        int lastCarsIndex = 0;
        for (Car car : byDestination) {
            int index;
            if (car.getKernel() != null && !car.isLead()) continue;
            if (!(car.isCaboose() || car.hasFred() || car.isPassenger())) {
                if (car.getDestinationTrack() != null && car.getDestinationTrack().getBlockingOrder() > 0) {
                    int j = 0;
                    while (j < out.size()) {
                        if (((Car)out.get(j)).getDestinationTrack() != null) {
                            if (car.getRouteDestination() != null && (car.getRouteDestination().getTrainDirectionString().equals(RouteLocation.WEST_DIR) || car.getRouteDestination().getTrainDirectionString().equals(RouteLocation.NORTH_DIR))) {
                                if (car.getDestinationTrack().getBlockingOrder() < ((Car)out.get(j)).getDestinationTrack().getBlockingOrder()) {
                                    out.add(j, car);
                                    break;
                                }
                            } else if (car.getDestinationTrack().getBlockingOrder() > ((Car)out.get(j)).getDestinationTrack().getBlockingOrder()) {
                                out.add(j, car);
                                break;
                            }
                        }
                        ++j;
                    }
                }
                if (!out.contains(car)) {
                    out.add(out.size() - lastCarsIndex, car);
                }
            } else if (car.isCaboose() || car.hasFred()) {
                out.add(car);
                ++lastCarsIndex;
            } else if (car.isPassenger()) {
                index = 0;
                while (index < lastCarsIndex) {
                    Car carTest = (Car)out.get(out.size() - 1 - index);
                    log.debug("Car ({}) has blocking number: {}", (Object)carTest.toString(), (Object)carTest.getBlocking());
                    if (carTest.isPassenger() && !carTest.isCaboose() && !carTest.hasFred() && carTest.getBlocking() < car.getBlocking()) break;
                    ++index;
                }
                out.add(out.size() - index, car);
                ++lastCarsIndex;
            }
            if (!car.isLead()) continue;
            index = out.indexOf(car);
            int numberOfCars = 1;
            for (Car kcar : car.getKernel().getCars()) {
                if (car == kcar) continue;
                int j = 0;
                while (j < numberOfCars) {
                    if (kcar.getBlocking() < ((Car)out.get(index + j)).getBlocking()) {
                        out.add(index + j, kcar);
                        break;
                    }
                    ++j;
                }
                if (!out.contains(kcar)) {
                    out.add(index + numberOfCars, kcar);
                }
                ++numberOfCars;
                if (!car.hasFred() && !car.isCaboose() && !car.isPassenger()) continue;
                ++lastCarsIndex;
            }
        }
        return out;
    }

    public List<String> getCabooseRoadNames() {
        ArrayList<String> names = new ArrayList<String>();
        Enumeration en = this._hashTable.keys();
        while (en.hasMoreElements()) {
            Car car = (Car)this.getById((String)en.nextElement());
            if (!car.isCaboose() || names.contains(car.getRoadName())) continue;
            names.add(car.getRoadName());
        }
        Collections.sort(names);
        return names;
    }

    public List<String> getFredRoadNames() {
        ArrayList<String> names = new ArrayList<String>();
        Enumeration en = this._hashTable.keys();
        while (en.hasMoreElements()) {
            Car car = (Car)this.getById((String)en.nextElement());
            if (!car.hasFred() || names.contains(car.getRoadName())) continue;
            names.add(car.getRoadName());
        }
        Collections.sort(names);
        return names;
    }

    public void replaceLoad(String type, String oldLoadName, String newLoadName) {
        List cars = this.getList();
        for (Car car : cars) {
            if (car.getTypeName().equals(type) && car.getLoadName().equals(oldLoadName)) {
                if (newLoadName != null) {
                    car.setLoadName(newLoadName);
                } else {
                    car.setLoadName(InstanceManager.getDefault(CarLoads.class).getDefaultEmptyName());
                }
            }
            if (car.getTypeName().equals(type) && car.getReturnWhenEmptyLoadName().equals(oldLoadName)) {
                if (newLoadName != null) {
                    car.setReturnWhenEmptyLoadName(newLoadName);
                } else {
                    car.setReturnWhenEmptyLoadName(InstanceManager.getDefault(CarLoads.class).getDefaultEmptyName());
                }
            }
            if (!car.getTypeName().equals(type) || !car.getReturnWhenLoadedLoadName().equals(oldLoadName)) continue;
            if (newLoadName != null) {
                car.setReturnWhenLoadedLoadName(newLoadName);
                continue;
            }
            car.setReturnWhenLoadedLoadName(InstanceManager.getDefault(CarLoads.class).getDefaultLoadName());
        }
    }

    public List<Car> getCarsLocationUnknown() {
        ArrayList<Car> mias = new ArrayList<Car>();
        List cars = this.getByIdList();
        for (Car rs : cars) {
            Car car = rs;
            if (!car.isLocationUnknown()) continue;
            mias.add(car);
        }
        return mias;
    }

    public static String calculateCarWeight(String carLength) throws NumberFormatException {
        double doubleCarLength = Double.parseDouble(carLength) * 12.0 / (double)Setup.getScaleRatio();
        double doubleCarWeight = ((double)Setup.getInitalWeight() + doubleCarLength * (double)Setup.getAddWeight()) / 1000.0;
        NumberFormat nf = NumberFormat.getNumberInstance();
        nf.setMaximumFractionDigits(1);
        return nf.format(doubleCarWeight);
    }

    public void load(Element root) {
        if (root.getChild("cars") != null) {
            List eCars = root.getChild("cars").getChildren("car");
            log.debug("readFile sees {} cars", (Object)eCars.size());
            for (Element eCar : eCars) {
                this.register(new Car(eCar));
            }
        }
    }

    public void store(Element root) {
        root.addContent((Content)new Element("options"));
        Element values = new Element("cars");
        root.addContent((Content)values);
        List carList = this.getByIdList();
        Iterator iterator = carList.iterator();
        while (iterator.hasNext()) {
            Car rs;
            Car car = rs = (Car)iterator.next();
            values.addContent((Content)car.store());
        }
    }

    protected void setDirtyAndFirePropertyChange(String p, Object old, Object n) {
        InstanceManager.getDefault(CarManagerXml.class).setDirty(true);
        super.firePropertyChange(p, old, n);
    }

    @Override
    public void initialize() {
        InstanceManager.getDefault(OperationsSetupXml.class);
        InstanceManager.getDefault(CarManagerXml.class);
    }
}

