/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.operations.rollingstock.cars;

import java.util.Comparator;
import jmri.InstanceManager;
import jmri.InstanceManagerAutoDefault;
import jmri.jmrit.operations.rollingstock.RollingStockAttribute;
import jmri.jmrit.operations.rollingstock.cars.Bundle;
import jmri.jmrit.operations.rollingstock.cars.CarManagerXml;
import jmri.jmrit.operations.setup.Control;
import org.jdom2.Element;

public class CarLengths
extends RollingStockAttribute
implements InstanceManagerAutoDefault {
    private static final String LENGTHS = Bundle.getMessage("carLengths");
    public static final String CARLENGTHS_CHANGED_PROPERTY = "CarLengths";
    public static final String CARLENGTHS_NAME_CHANGED_PROPERTY = "CarLengthsName";
    protected static final int MIN_NAME_LENGTH = Control.max_len_string_length_name;

    @Override
    protected String getDefaultNames() {
        return LENGTHS;
    }

    @Override
    public void setNames(String[] lengths) {
        this.setValues(lengths);
    }

    @Override
    public void addName(String length) {
        super.addName(length);
        this.setDirtyAndFirePropertyChange(CARLENGTHS_CHANGED_PROPERTY, null, length);
    }

    @Override
    public void deleteName(String length) {
        super.deleteName(length);
        this.setDirtyAndFirePropertyChange(CARLENGTHS_CHANGED_PROPERTY, length, null);
    }

    public void replaceName(String oldName, String newName) {
        super.addName(newName);
        this.setDirtyAndFirePropertyChange(CARLENGTHS_NAME_CHANGED_PROPERTY, oldName, newName);
        super.deleteName(oldName);
    }

    @Override
    public void sort() {
        this.list.sort(Comparator.comparingInt(Integer::parseInt));
    }

    @Override
    protected int getMinNameLength() {
        return MIN_NAME_LENGTH;
    }

    public void store(Element root) {
        this.store(root, "lengths", "length");
    }

    public void load(Element root) {
        this.load(root, "lengths", "length", "carLengths");
    }

    protected void setDirtyAndFirePropertyChange(String p, Object old, Object n) {
        InstanceManager.getDefault(CarManagerXml.class).setDirty(true);
        super.firePropertyChange(p, old, n);
    }
}

