/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.operations.rollingstock.cars;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import jmri.InstanceManager;
import jmri.jmrit.operations.rollingstock.RollingStock;
import jmri.jmrit.operations.rollingstock.RollingStockAttribute;
import jmri.jmrit.operations.rollingstock.RollingStockEditFrame;
import jmri.jmrit.operations.rollingstock.cars.Bundle;
import jmri.jmrit.operations.rollingstock.cars.Car;
import jmri.jmrit.operations.rollingstock.cars.CarColors;
import jmri.jmrit.operations.rollingstock.cars.CarLengths;
import jmri.jmrit.operations.rollingstock.cars.CarLoads;
import jmri.jmrit.operations.rollingstock.cars.CarManager;
import jmri.jmrit.operations.rollingstock.cars.CarManagerXml;
import jmri.jmrit.operations.rollingstock.cars.CarTypes;
import jmri.jmrit.operations.rollingstock.cars.KernelManager;
import jmri.jmrit.operations.rollingstock.cars.tools.CarAttributeEditFrame;
import jmri.jmrit.operations.rollingstock.cars.tools.CarLoadEditFrame;
import jmri.jmrit.operations.setup.Setup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CarEditFrame
extends RollingStockEditFrame {
    protected static final ResourceBundle rb = ResourceBundle.getBundle("jmri.jmrit.operations.rollingstock.cars.JmritOperationsCarsBundle");
    CarManager carManager = InstanceManager.getDefault(CarManager.class);
    CarManagerXml managerXml = InstanceManager.getDefault(CarManagerXml.class);
    JLabel textWeightOz = new JLabel(Bundle.getMessage("WeightOz"));
    JButton editColorButton = new JButton(Bundle.getMessage("ButtonEdit"));
    JButton editLoadButton = new JButton(Bundle.getMessage("ButtonEdit"));
    JButton fillWeightButton = new JButton(Bundle.getMessage("Calculate"));
    JCheckBox passengerCheckBox = new JCheckBox(Bundle.getMessage("Passenger"));
    JCheckBox cabooseCheckBox = new JCheckBox(Bundle.getMessage("Caboose"));
    JCheckBox fredCheckBox = new JCheckBox(Bundle.getMessage("Fred"));
    JCheckBox utilityCheckBox = new JCheckBox(Bundle.getMessage("Utility"));
    JCheckBox hazardousCheckBox = new JCheckBox(Bundle.getMessage("Hazardous"));
    JCheckBox autoWeightCheckBox = new JCheckBox(Bundle.getMessage("Auto"));
    JComboBox<String> colorComboBox = InstanceManager.getDefault(CarColors.class).getComboBox();
    JComboBox<String> loadComboBox = InstanceManager.getDefault(CarLoads.class).getComboBox(null);
    CarLoadEditFrame carLoadEditFrame;
    CarAttributeEditFrame carAttributeEditFrame;
    private static final Logger log = LoggerFactory.getLogger(CarEditFrame.class);

    public CarEditFrame() {
        super(Bundle.getMessage("TitleCarAdd"));
    }

    @Override
    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"}, justification="Checks for null")
    public void initComponents() {
        this.groupComboBox = InstanceManager.getDefault(KernelManager.class).getComboBox();
        super.initComponents();
        this.addButton.setText(Bundle.getMessage("TitleCarAdd"));
        this.addItem(this.pTypeOptions, this.passengerCheckBox, 0, 1);
        this.addItem(this.pTypeOptions, this.cabooseCheckBox, 1, 1);
        this.addItem(this.pTypeOptions, this.fredCheckBox, 2, 1);
        this.addItem(this.pTypeOptions, this.utilityCheckBox, 3, 1);
        this.addItem(this.pTypeOptions, this.hazardousCheckBox, 4, 1);
        this.autoWeightCheckBox.setSelected(true);
        this.weightTextField.setToolTipText(Bundle.getMessage("TipCarWeightOz"));
        this.weightTonsTextField.setToolTipText(Bundle.getMessage("TipCarWeightTons"));
        this.autoWeightCheckBox.setToolTipText(Bundle.getMessage("TipCarAutoCalculate"));
        this.passengerCheckBox.setToolTipText(Bundle.getMessage("TipCarPassenger"));
        this.cabooseCheckBox.setToolTipText(Bundle.getMessage("TipCarCaboose"));
        this.fredCheckBox.setToolTipText(Bundle.getMessage("TipCarFred"));
        this.utilityCheckBox.setToolTipText(Bundle.getMessage("TipCarUtility"));
        this.hazardousCheckBox.setToolTipText(Bundle.getMessage("TipCarHazardous"));
        this.blockingTextField.setToolTipText(Bundle.getMessage("TipPassengerCarBlocking"));
        this.fillWeightButton.setToolTipText(Bundle.getMessage("TipCalculateCarWeight"));
        this.builtTextField.setToolTipText(Bundle.getMessage("TipBuildDate"));
        this.valueTextArea.setToolTipText(Bundle.getMessage("TipValue"));
        this.editColorButton.setToolTipText(MessageFormat.format(Bundle.getMessage("TipAddDeleteReplace"), Bundle.getMessage("Color").toLowerCase()));
        this.editLoadButton.setToolTipText(MessageFormat.format(Bundle.getMessage("TipAddDeleteReplace"), Bundle.getMessage("load")));
        this.editGroupButton.setToolTipText(MessageFormat.format(Bundle.getMessage("TipAddDeleteReplace"), Bundle.getMessage("Kernel").toLowerCase()));
        this.deleteButton.setToolTipText(Bundle.getMessage("TipDeleteButton"));
        this.addButton.setToolTipText(Bundle.getMessage("TipAddButton"));
        this.saveButton.setToolTipText(Bundle.getMessage("TipSaveButton"));
        this.pWeightOz.setLayout(new GridBagLayout());
        this.addItem(this.pWeightOz, this.textWeightOz, 0, 0);
        this.addItem(this.pWeightOz, this.weightTextField, 1, 0);
        this.addItem(this.pWeightOz, this.fillWeightButton, 2, 0);
        this.addItem(this.pWeightOz, this.autoWeightCheckBox, 3, 0);
        this.pColor.setLayout(new GridBagLayout());
        this.pColor.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("Color")));
        this.addItem(this.pColor, this.colorComboBox, 1, 0);
        this.addItem(this.pColor, this.editColorButton, 2, 0);
        this.pColor.setVisible(true);
        this.pLoad.setLayout(new GridBagLayout());
        this.pLoad.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("Load")));
        this.addItem(this.pLoad, this.loadComboBox, 1, 0);
        this.addItem(this.pLoad, this.editLoadButton, 2, 0);
        this.pLoad.setVisible(true);
        this.typeComboBox.setSelectedIndex(0);
        this.pGroup.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("Kernel")));
        this.addEditButtonAction(this.editColorButton);
        this.addButtonAction(this.fillWeightButton);
        this.addButtonAction(this.editLoadButton);
        this.addCheckBoxAction(this.cabooseCheckBox);
        this.addCheckBoxAction(this.fredCheckBox);
        this.addCheckBoxAction(this.passengerCheckBox);
        this.addHelpMenu("package.jmri.jmrit.operations.Operations_CarsEdit", true);
    }

    @Override
    protected ResourceBundle getRb() {
        return rb;
    }

    @Override
    protected RollingStockAttribute getTypeManager() {
        return InstanceManager.getDefault(CarTypes.class);
    }

    @Override
    protected RollingStockAttribute getLengthManager() {
        return InstanceManager.getDefault(CarLengths.class);
    }

    public void load(Car car) {
        this.setTitle(Bundle.getMessage("TitleCarEdit"));
        super.load(car);
        this.passengerCheckBox.setSelected(car.isPassenger());
        this.cabooseCheckBox.setSelected(car.isCaboose());
        this.utilityCheckBox.setSelected(car.isUtility());
        this.fredCheckBox.setSelected(car.hasFred());
        this.hazardousCheckBox.setSelected(car.isHazardous());
        this.pBlocking.setVisible(car.isPassenger() || car.getKernel() != null);
        if (!InstanceManager.getDefault(CarLoads.class).containsName(car.getTypeName(), car.getLoadName()) && JOptionPane.showConfirmDialog(this, MessageFormat.format(Bundle.getMessage("loadNameNotExist"), car.getLoadName()), Bundle.getMessage("addLoad"), 0) == 0) {
            InstanceManager.getDefault(CarLoads.class).addName(car.getTypeName(), car.getLoadName());
        }
        InstanceManager.getDefault(CarLoads.class).updateComboBox(car.getTypeName(), this.loadComboBox);
        this.loadComboBox.setSelectedItem(car.getLoadName());
        car.addPropertyChangeListener(this);
        if (!InstanceManager.getDefault(CarColors.class).containsName(car.getColor()) && JOptionPane.showConfirmDialog(this, MessageFormat.format(Bundle.getMessage("colorNameNotExist"), car.getColor()), Bundle.getMessage("carAddColor"), 0) == 0) {
            InstanceManager.getDefault(CarColors.class).addName(car.getColor());
        }
        this.colorComboBox.setSelectedItem(car.getColor());
        this.groupComboBox.setSelectedItem(car.getKernelName());
    }

    @Override
    public void comboBoxActionPerformed(ActionEvent ae) {
        if (ae.getSource() == this.typeComboBox && this.typeComboBox.getSelectedItem() != null) {
            log.debug("Type comboBox sees change, update car loads");
            InstanceManager.getDefault(CarLoads.class).updateComboBox((String)this.typeComboBox.getSelectedItem(), this.loadComboBox);
            if (this._rs != null) {
                this.loadComboBox.setSelectedItem(((Car)this._rs).getLoadName());
            }
        }
        if (ae.getSource() == this.lengthComboBox && this.autoWeightCheckBox.isSelected()) {
            this.calculateWeight();
        }
        super.comboBoxActionPerformed(ae);
    }

    @Override
    public void checkBoxActionPerformed(ActionEvent ae) {
        if (ae.getSource() == this.cabooseCheckBox && this.cabooseCheckBox.isSelected()) {
            this.fredCheckBox.setSelected(false);
        }
        if (ae.getSource() == this.fredCheckBox && this.fredCheckBox.isSelected()) {
            this.cabooseCheckBox.setSelected(false);
        }
        if (ae.getSource() == this.passengerCheckBox) {
            this.pBlocking.setVisible(this.passengerCheckBox.isSelected() || this._rs != null && ((Car)this._rs).getKernel() != null);
        }
        super.checkBoxActionPerformed(ae);
    }

    @Override
    public void buttonActionPerformed(ActionEvent ae) {
        super.buttonActionPerformed(ae);
        if (ae.getSource() == this.fillWeightButton) {
            this.calculateWeight();
        }
        if (ae.getSource() == this.editLoadButton) {
            if (this.carLoadEditFrame != null) {
                this.carLoadEditFrame.dispose();
            }
            this.carLoadEditFrame = new CarLoadEditFrame();
            this.carLoadEditFrame.setLocationRelativeTo(this);
            this.carLoadEditFrame.initComponents((String)this.typeComboBox.getSelectedItem(), (String)this.loadComboBox.getSelectedItem());
        }
    }

    @Override
    protected boolean check(RollingStock car) {
        Car existingCar = (Car)this.carManager.getByRoadAndNumber((String)this.roadComboBox.getSelectedItem(), this.roadNumberTextField.getText());
        if (existingCar != null) {
            if (car == null) {
                JOptionPane.showMessageDialog(this, Bundle.getMessage("carRoadExists"), Bundle.getMessage("carCanNotAdd"), 0);
                return false;
            }
            if (!existingCar.getId().equals(car.getId())) {
                JOptionPane.showMessageDialog(this, Bundle.getMessage("carRoadExists"), Bundle.getMessage("carCanNotUpdate"), 0);
                return false;
            }
        }
        try {
            Number number = NumberFormat.getNumberInstance().parse(this.weightTextField.getText());
            log.debug("Car weight in oz: {}", (Object)number);
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this, Bundle.getMessage("carWeightFormat"), Bundle.getMessage("carActualWeight"), 0);
            return false;
        }
        return super.check(car);
    }

    private void calculateWeight() {
        if (this.lengthComboBox.getSelectedItem() != null) {
            String length = (String)this.lengthComboBox.getSelectedItem();
            try {
                String carWeight = CarManager.calculateCarWeight(length);
                this.weightTextField.setText(carWeight);
                int tons = (int)(NumberFormat.getNumberInstance().parse(carWeight).doubleValue() * (double)Setup.getScaleTonRatio());
                if (this.cabooseCheckBox.isSelected() || this.passengerCheckBox.isSelected()) {
                    tons = (int)(Double.parseDouble(length) * 0.9);
                }
                this.weightTonsTextField.setText(Integer.toString(tons));
            }
            catch (NumberFormatException numberFormatException) {
                JOptionPane.showMessageDialog(this, Bundle.getMessage("carLengthMustBe"), Bundle.getMessage("carWeigthCanNot"), 0);
            }
            catch (ParseException parseException) {
                JOptionPane.showMessageDialog(this, Bundle.getMessage("carWeightFormat"), Bundle.getMessage("carWeigthCanNot"), 0);
            }
        }
    }

    @Override
    protected void save(boolean isSave) {
        List<Car> cars;
        if (this.roadComboBox.getSelectedItem() == null) {
            return;
        }
        super.save(this.carManager, isSave);
        Car car = (Car)this._rs;
        if (this.colorComboBox.getSelectedItem() != null) {
            car.setColor((String)this.colorComboBox.getSelectedItem());
        }
        if (isSave && car.isPassenger() ^ this.passengerCheckBox.isSelected() && JOptionPane.showConfirmDialog(this, MessageFormat.format(this.passengerCheckBox.isSelected() ? Bundle.getMessage("carModifyTypePassenger") : Bundle.getMessage("carRemoveTypePassenger"), car.getTypeName()), MessageFormat.format(Bundle.getMessage("carModifyAllType"), car.getTypeName()), 0) == 0) {
            for (Car c : this.carManager.getList()) {
                if (!c.getTypeName().equals(car.getTypeName())) continue;
                c.setPassenger(this.passengerCheckBox.isSelected());
            }
        }
        car.setPassenger(this.passengerCheckBox.isSelected());
        int blocking = Integer.parseInt(this.blockingTextField.getText());
        if (isSave && car.getKernel() == null && this.passengerCheckBox.isSelected() && car.getBlocking() != blocking && JOptionPane.showConfirmDialog(this, MessageFormat.format(Bundle.getMessage("carChangeBlocking"), blocking, car.getTypeName()), MessageFormat.format(Bundle.getMessage("carModifyAllType"), car.getTypeName()), 0) == 0) {
            for (Car c : this.carManager.getList()) {
                if (!c.isPassenger() || !c.getTypeName().equals(car.getTypeName())) continue;
                c.setBlocking(blocking);
            }
        }
        car.setBlocking(blocking);
        if (isSave && car.isCaboose() ^ this.cabooseCheckBox.isSelected() && JOptionPane.showConfirmDialog(this, MessageFormat.format(this.cabooseCheckBox.isSelected() ? Bundle.getMessage("carModifyTypeCaboose") : Bundle.getMessage("carRemoveTypeCaboose"), car.getTypeName()), MessageFormat.format(Bundle.getMessage("carModifyAllType"), car.getTypeName()), 0) == 0) {
            for (Car c : this.carManager.getList()) {
                if (!c.getTypeName().equals(car.getTypeName())) continue;
                c.setCaboose(this.cabooseCheckBox.isSelected());
            }
        }
        car.setCaboose(this.cabooseCheckBox.isSelected());
        if (isSave && car.isUtility() ^ this.utilityCheckBox.isSelected() && JOptionPane.showConfirmDialog(this, MessageFormat.format(this.utilityCheckBox.isSelected() ? Bundle.getMessage("carModifyTypeUtility") : Bundle.getMessage("carRemoveTypeUtility"), car.getTypeName()), MessageFormat.format(Bundle.getMessage("carModifyAllType"), car.getTypeName()), 0) == 0) {
            for (Car c : this.carManager.getList()) {
                if (!c.getTypeName().equals(car.getTypeName())) continue;
                c.setUtility(this.utilityCheckBox.isSelected());
            }
        }
        car.setUtility(this.utilityCheckBox.isSelected());
        if (isSave && car.isHazardous() ^ this.hazardousCheckBox.isSelected() && JOptionPane.showConfirmDialog(this, MessageFormat.format(this.hazardousCheckBox.isSelected() ? Bundle.getMessage("carModifyTypeHazardous") : Bundle.getMessage("carRemoveTypeHazardous"), car.getTypeName()), MessageFormat.format(Bundle.getMessage("carModifyAllType"), car.getTypeName()), 0) == 0) {
            for (Car c : this.carManager.getList()) {
                if (!c.getTypeName().equals(car.getTypeName())) continue;
                c.setHazardous(this.hazardousCheckBox.isSelected());
            }
        }
        car.setHazardous(this.hazardousCheckBox.isSelected());
        car.setFred(this.fredCheckBox.isSelected());
        if (this.groupComboBox.getSelectedItem() != null) {
            if (this.groupComboBox.getSelectedItem().equals("")) {
                car.setKernel(null);
            } else if (!car.getKernelName().equals(this.groupComboBox.getSelectedItem())) {
                car.setKernel(InstanceManager.getDefault(KernelManager.class).getKernelByName((String)this.groupComboBox.getSelectedItem()));
                if (car.hasFred() || car.isCaboose()) {
                    car.getKernel().setLead(car);
                }
                car.setBlocking(car.getKernel().getSize());
            }
        }
        if (this.loadComboBox.getSelectedItem() != null && !car.getLoadName().equals(this.loadComboBox.getSelectedItem())) {
            car.setLoadName((String)this.loadComboBox.getSelectedItem());
            if (car.getKernel() != null && (cars = car.getKernel().getCars()).size() > 1 && JOptionPane.showConfirmDialog(this, MessageFormat.format(Bundle.getMessage("carInKernelLoad"), car.toString(), car.getLoadName()), MessageFormat.format(Bundle.getMessage("carPartKernel"), car.getKernelName()), 0) == 0) {
                for (Car c : cars) {
                    if (!InstanceManager.getDefault(CarLoads.class).containsName(c.getTypeName(), car.getLoadName())) continue;
                    c.setLoadName(car.getLoadName());
                }
            }
        }
        this.pBlocking.setVisible(this.passengerCheckBox.isSelected() || car.getKernel() != null);
        this.blockingTextField.setText(Integer.toString(car.getBlocking()));
        if (car.getKernel() != null && (cars = car.getKernel().getCars()).size() > 1) {
            for (Car kcar : cars) {
                if (kcar == car || kcar.getLocation() == car.getLocation() && kcar.getTrack() == car.getTrack()) continue;
                int results = JOptionPane.showConfirmDialog(this, MessageFormat.format(Bundle.getMessage("carInKernelLocation"), car.toString(), car.getLocationName(), car.getTrackName()), MessageFormat.format(Bundle.getMessage("carPartKernel"), car.getKernelName()), 0);
                if (results == 1) break;
                for (Car kcar2 : cars) {
                    if (kcar2 == car) continue;
                    this.setLocationAndTrack(kcar2);
                }
            }
        }
    }

    @Override
    protected void delete() {
        Car car = (Car)this.carManager.getByRoadAndNumber((String)this.roadComboBox.getSelectedItem(), this.roadNumberTextField.getText());
        if (car != null) {
            this.carManager.deregister(car);
        }
    }

    @Override
    public void buttonEditActionPerformed(ActionEvent ae) {
        if (this.carAttributeEditFrame != null) {
            this.carAttributeEditFrame.dispose();
        }
        this.carAttributeEditFrame = new CarAttributeEditFrame();
        this.carAttributeEditFrame.setLocationRelativeTo(this);
        this.carAttributeEditFrame.addPropertyChangeListener(this);
        if (ae.getSource() == this.editRoadButton) {
            this.carAttributeEditFrame.initComponents("Road", (String)this.roadComboBox.getSelectedItem());
        }
        if (ae.getSource() == this.editTypeButton) {
            this.carAttributeEditFrame.initComponents("Type", (String)this.typeComboBox.getSelectedItem());
        }
        if (ae.getSource() == this.editColorButton) {
            this.carAttributeEditFrame.initComponents("Color", (String)this.colorComboBox.getSelectedItem());
        }
        if (ae.getSource() == this.editLengthButton) {
            this.carAttributeEditFrame.initComponents("Length", (String)this.lengthComboBox.getSelectedItem());
        }
        if (ae.getSource() == this.editOwnerButton) {
            this.carAttributeEditFrame.initComponents("Owner", (String)this.ownerComboBox.getSelectedItem());
        }
        if (ae.getSource() == this.editGroupButton) {
            this.carAttributeEditFrame.initComponents("Kernel", (String)this.groupComboBox.getSelectedItem());
        }
    }

    @Override
    protected void addPropertyChangeListeners() {
        InstanceManager.getDefault(CarLoads.class).addPropertyChangeListener(this);
        InstanceManager.getDefault(CarColors.class).addPropertyChangeListener(this);
        InstanceManager.getDefault(KernelManager.class).addPropertyChangeListener(this);
        this.carManager.addPropertyChangeListener(this);
        super.addPropertyChangeListeners();
    }

    @Override
    protected void removePropertyChangeListeners() {
        InstanceManager.getDefault(CarLoads.class).removePropertyChangeListener(this);
        InstanceManager.getDefault(CarColors.class).removePropertyChangeListener(this);
        InstanceManager.getDefault(KernelManager.class).removePropertyChangeListener(this);
        this.carManager.removePropertyChangeListener(this);
        if (this._rs != null) {
            this._rs.removePropertyChangeListener(this);
        }
        super.removePropertyChangeListeners();
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        log.debug("Property change: ({}) old: ({}) new: ({})", new Object[]{e.getPropertyName(), e.getOldValue(), e.getNewValue()});
        super.propertyChange(e);
        if (e.getPropertyName().equals("CarLengths")) {
            InstanceManager.getDefault(CarLengths.class).updateComboBox(this.lengthComboBox);
            if (this._rs != null) {
                this.lengthComboBox.setSelectedItem(this._rs.getLength());
            }
        }
        if (e.getPropertyName().equals("CarColors")) {
            InstanceManager.getDefault(CarColors.class).updateComboBox(this.colorComboBox);
            if (this._rs != null) {
                this.colorComboBox.setSelectedItem(this._rs.getColor());
            }
        }
        if (e.getPropertyName().equals("GroupListLengthChanged") || e.getPropertyName().equals("kernel name changed")) {
            InstanceManager.getDefault(KernelManager.class).updateComboBox(this.groupComboBox);
            if (this._rs != null) {
                this.groupComboBox.setSelectedItem(((Car)this._rs).getKernelName());
            }
        }
        if (e.getPropertyName().equals("CarLoads_Load")) {
            InstanceManager.getDefault(CarLoads.class).updateComboBox((String)this.typeComboBox.getSelectedItem(), this.loadComboBox);
        }
        if ((e.getPropertyName().equals("Car load changed") || e.getPropertyName().equals("CarLoads_Load")) && this._rs != null) {
            this.loadComboBox.setSelectedItem(((Car)this._rs).getLoadName());
        }
        if (e.getPropertyName().equals("dispose")) {
            this.carAttributeEditFrame = null;
        }
    }
}

