/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.operations.rollingstock.cars;

import jmri.InstanceManager;
import jmri.InstanceManagerAutoDefault;
import jmri.jmrit.operations.rollingstock.RollingStockAttribute;
import jmri.jmrit.operations.rollingstock.cars.Bundle;
import jmri.jmrit.operations.rollingstock.cars.CarManagerXml;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CarColors
extends RollingStockAttribute
implements InstanceManagerAutoDefault {
    private static final String COLORS = Bundle.getMessage("carColors");
    public static final String CARCOLORS_CHANGED_PROPERTY = "CarColors";
    public static final String CARCOLORS_NAME_CHANGED_PROPERTY = "CarColorsName";
    private static final Logger log = LoggerFactory.getLogger(CarColors.class);

    @Override
    protected String getDefaultNames() {
        return COLORS;
    }

    @Override
    public void addName(String color) {
        super.addName(color);
        this.setDirtyAndFirePropertyChange(CARCOLORS_CHANGED_PROPERTY, null, color);
    }

    @Override
    public void deleteName(String color) {
        super.deleteName(color);
        this.setDirtyAndFirePropertyChange(CARCOLORS_CHANGED_PROPERTY, color, null);
    }

    public void replaceName(String oldName, String newName) {
        super.addName(newName);
        this.setDirtyAndFirePropertyChange(CARCOLORS_NAME_CHANGED_PROPERTY, oldName, newName);
        super.deleteName(oldName);
    }

    @Override
    public int getMaxNameLength() {
        if (this.maxNameLength == 0) {
            super.getMaxNameLength();
            log.info("Max color name ({}) length {}", (Object)this.maxName, (Object)this.maxNameLength);
        }
        return this.maxNameLength;
    }

    public void store(Element root) {
        this.store(root, "colors", "color");
    }

    public void load(Element root) {
        this.load(root, "colors", "color", "carColors");
    }

    protected void setDirtyAndFirePropertyChange(String p, Object old, Object n) {
        InstanceManager.getDefault(CarManagerXml.class).setDirty(true);
        super.firePropertyChange(p, old, n);
    }
}

