/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.operations.rollingstock.cars;

import java.beans.PropertyChangeEvent;
import jmri.InstanceManager;
import jmri.jmrit.operations.locations.Location;
import jmri.jmrit.operations.locations.LocationManager;
import jmri.jmrit.operations.locations.Track;
import jmri.jmrit.operations.rollingstock.RollingStock;
import jmri.jmrit.operations.rollingstock.cars.Bundle;
import jmri.jmrit.operations.rollingstock.cars.CarLengths;
import jmri.jmrit.operations.rollingstock.cars.CarLoad;
import jmri.jmrit.operations.rollingstock.cars.CarLoads;
import jmri.jmrit.operations.rollingstock.cars.CarManagerXml;
import jmri.jmrit.operations.rollingstock.cars.CarTypes;
import jmri.jmrit.operations.rollingstock.cars.Kernel;
import jmri.jmrit.operations.rollingstock.cars.KernelManager;
import jmri.jmrit.operations.routes.RouteLocation;
import jmri.jmrit.operations.trains.TrainCommon;
import jmri.jmrit.operations.trains.schedules.TrainSchedule;
import jmri.jmrit.operations.trains.schedules.TrainScheduleManager;
import org.jdom2.Attribute;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Car
extends RollingStock {
    CarLoads carLoads = InstanceManager.getDefault(CarLoads.class);
    protected boolean _passenger = false;
    protected boolean _hazardous = false;
    protected boolean _caboose = false;
    protected boolean _fred = false;
    protected boolean _utility = false;
    protected boolean _loadGeneratedByStaging = false;
    protected Kernel _kernel = null;
    protected String _loadName = this.carLoads.getDefaultEmptyName();
    protected int _wait = 0;
    protected Location _rweDestination = null;
    protected Track _rweDestTrack = null;
    protected String _rweLoadName = this.carLoads.getDefaultEmptyName();
    protected Location _rwlDestination = null;
    protected Track _rwlDestTrack = null;
    protected String _rwlLoadName = this.carLoads.getDefaultLoadName();
    protected String _scheduleId = "";
    protected String _nextLoadName = "";
    protected int _nextWait = 0;
    protected Location _finalDestination = null;
    protected Track _finalDestTrack = null;
    protected Location _previousFinalDestination = null;
    protected Track _previousFinalDestTrack = null;
    protected String _previousScheduleId = "";
    protected String _pickupScheduleId = "";
    protected String _nextPickupScheduleId = "";
    public static final String EXTENSION_REGEX = " ";
    public static final String CABOOSE_EXTENSION = Bundle.getMessage("(C)");
    public static final String FRED_EXTENSION = Bundle.getMessage("(F)");
    public static final String PASSENGER_EXTENSION = Bundle.getMessage("(P)");
    public static final String UTILITY_EXTENSION = Bundle.getMessage("(U)");
    public static final String HAZARDOUS_EXTENSION = Bundle.getMessage("(H)");
    public static final String LOAD_CHANGED_PROPERTY = "Car load changed";
    public static final String RWE_LOAD_CHANGED_PROPERTY = "Car RWE load changed";
    public static final String RWL_LOAD_CHANGED_PROPERTY = "Car RWL load changed";
    public static final String WAIT_CHANGED_PROPERTY = "Car wait changed";
    public static final String NEXT_WAIT_CHANGED_PROPERTY = "Car next wait changed";
    public static final String FINAL_DESTINATION_CHANGED_PROPERTY = "Car final destination changed";
    public static final String FINAL_DESTINATION_TRACK_CHANGED_PROPERTY = "Car final destination track changed";
    public static final String RETURN_WHEN_EMPTY_CHANGED_PROPERTY = "Car return when empty changed";
    public static final String RETURN_WHEN_LOADED_CHANGED_PROPERTY = "Car return when loaded changed";
    public static final String SCHEDULE_ID_CHANGED_PROPERTY = "car schedule id changed";
    public static final String KERNEL_NAME_CHANGED_PROPERTY = "kernel name changed";
    private boolean loaded = true;
    private static final Logger log = LoggerFactory.getLogger(Car.class);

    public Car() {
    }

    public Car(String road, String number) {
        super(road, number);
        log.debug("New car ({} {})", (Object)road, (Object)number);
        this.addPropertyChangeListeners();
    }

    public Car copy() {
        Car car = new Car();
        car.setBuilt(this.getBuilt());
        car.setColor(this.getColor());
        car.setLength(this.getLength());
        car.setLoadName(this.getLoadName());
        car.setReturnWhenEmptyLoadName(this.getReturnWhenEmptyLoadName());
        car.setReturnWhenLoadedLoadName(this.getReturnWhenLoadedLoadName());
        car.setNumber(this.getNumber());
        car.setOwner(this.getOwner());
        car.setRoadName(this.getRoadName());
        car.setTypeName(this.getTypeName());
        car.setCaboose(this.isCaboose());
        car.setFred(this.hasFred());
        car.setPassenger(this.isPassenger());
        car.loaded = true;
        return car;
    }

    public void setHazardous(boolean hazardous) {
        boolean old = this._hazardous;
        this._hazardous = hazardous;
        if (!old == hazardous) {
            this.setDirtyAndFirePropertyChange("car hazardous", old ? "true" : "false", hazardous ? "true" : "false");
        }
    }

    public boolean isHazardous() {
        return this._hazardous;
    }

    public void setPassenger(boolean passenger) {
        boolean old = this._passenger;
        this._passenger = passenger;
        if (!old == passenger) {
            this.setDirtyAndFirePropertyChange("car passenger", old ? "true" : "false", passenger ? "true" : "false");
        }
    }

    public boolean isPassenger() {
        return this._passenger;
    }

    public void setFred(boolean fred) {
        boolean old = this._fred;
        this._fred = fred;
        if (!old == fred) {
            this.setDirtyAndFirePropertyChange("car has fred", old ? "true" : "false", fred ? "true" : "false");
        }
    }

    public boolean hasFred() {
        return this._fred;
    }

    public void setLoadName(String load) {
        String old = this._loadName;
        this._loadName = load;
        if (!old.equals(load)) {
            this.setDirtyAndFirePropertyChange(LOAD_CHANGED_PROPERTY, old, load);
        }
    }

    public String getLoadName() {
        return this._loadName;
    }

    public void setReturnWhenEmptyLoadName(String load) {
        String old = this._rweLoadName;
        this._rweLoadName = load;
        if (!old.equals(load)) {
            this.setDirtyAndFirePropertyChange(RWE_LOAD_CHANGED_PROPERTY, old, load);
        }
    }

    public String getReturnWhenEmptyLoadName() {
        return this._rweLoadName;
    }

    public void setReturnWhenLoadedLoadName(String load) {
        String old = this._rwlLoadName;
        this._rwlLoadName = load;
        if (!old.equals(load)) {
            this.setDirtyAndFirePropertyChange(RWL_LOAD_CHANGED_PROPERTY, old, load);
        }
    }

    public String getReturnWhenLoadedLoadName() {
        return this._rwlLoadName;
    }

    public String getLoadPriority() {
        return this.carLoads.getPriority(this.getTypeName(), this.getLoadName());
    }

    public String getLoadType() {
        return this.carLoads.getLoadType(this.getTypeName(), this.getLoadName());
    }

    public String getPickupComment() {
        return this.carLoads.getPickupComment(this.getTypeName(), this.getLoadName());
    }

    public String getDropComment() {
        return this.carLoads.getDropComment(this.getTypeName(), this.getLoadName());
    }

    public void setLoadGeneratedFromStaging(boolean fromStaging) {
        this._loadGeneratedByStaging = fromStaging;
    }

    public boolean isLoadGeneratedFromStaging() {
        return this._loadGeneratedByStaging;
    }

    public void setScheduleItemId(String id) {
        log.debug("Set schedule item id ({}) for car ({})", (Object)id, (Object)this.toString());
        String old = this._scheduleId;
        this._scheduleId = id;
        if (!old.equals(id)) {
            this.setDirtyAndFirePropertyChange(SCHEDULE_ID_CHANGED_PROPERTY, old, id);
        }
    }

    public String getScheduleItemId() {
        return this._scheduleId;
    }

    public void setNextLoadName(String load) {
        String old = this._nextLoadName;
        this._nextLoadName = load;
        if (!old.equals(load)) {
            this.setDirtyAndFirePropertyChange(LOAD_CHANGED_PROPERTY, old, load);
        }
    }

    public String getNextLoadName() {
        return this._nextLoadName;
    }

    @Override
    public String getWeightTons() {
        String weight = super.getWeightTons();
        if (!this._weightTons.equals("0")) {
            return weight;
        }
        if (!this.isCaboose() && !this.isPassenger()) {
            return weight;
        }
        try {
            weight = Integer.toString((int)(Double.parseDouble(this.getLength()) * 0.9));
        }
        catch (Exception exception) {
            log.debug("Car ({}) length not set for caboose or passenger car", (Object)this.toString());
        }
        return weight;
    }

    @Override
    public int getAdjustedWeightTons() {
        int weightTons = 0;
        try {
            weightTons = Integer.parseInt(this.getWeightTons());
            if (!this.isCaboose() && !this.isPassenger() && this.getLoadType().equals(CarLoad.LOAD_TYPE_EMPTY)) {
                weightTons /= 3;
            }
        }
        catch (NumberFormatException numberFormatException) {
            log.debug("Car ({}) weight not set", (Object)this.toString());
        }
        return weightTons;
    }

    public void setWait(int count) {
        int old = this._wait;
        this._wait = count;
        if (old != count) {
            this.setDirtyAndFirePropertyChange(NEXT_WAIT_CHANGED_PROPERTY, old, count);
        }
    }

    public int getWait() {
        return this._wait;
    }

    public void setNextWait(int count) {
        int old = this._nextWait;
        this._nextWait = count;
        if (old != count) {
            this.setDirtyAndFirePropertyChange(NEXT_WAIT_CHANGED_PROPERTY, old, count);
        }
    }

    public int getNextWait() {
        return this._nextWait;
    }

    public void setPickupScheduleId(String id) {
        String old = this._pickupScheduleId;
        this._pickupScheduleId = id;
        if (!old.equals(id)) {
            this.setDirtyAndFirePropertyChange("car pickup schedule changes", old, id);
        }
    }

    public String getPickupScheduleId() {
        return this._pickupScheduleId;
    }

    public void setNextPickupScheduleId(String id) {
        String old = this._nextPickupScheduleId;
        this._nextPickupScheduleId = id;
        if (!old.equals(id)) {
            this.setDirtyAndFirePropertyChange("next car pickup schedule changes", old, id);
        }
    }

    public String getNextPickupScheduleId() {
        return this._nextPickupScheduleId;
    }

    public String getPickupScheduleName() {
        TrainSchedule sch = InstanceManager.getDefault(TrainScheduleManager.class).getScheduleById(this.getPickupScheduleId());
        String name = "";
        if (sch != null) {
            name = sch.getName();
        }
        return name;
    }

    public void setFinalDestination(Location destination) {
        Location old = this._finalDestination;
        if (old != null) {
            old.removePropertyChangeListener(this);
        }
        this._finalDestination = destination;
        if (this._finalDestination != null) {
            this._finalDestination.addPropertyChangeListener(this);
        }
        if (old != null && !old.equals(destination) || destination != null && !destination.equals(old)) {
            this.setDirtyAndFirePropertyChange(FINAL_DESTINATION_CHANGED_PROPERTY, old, destination);
        }
    }

    public Location getFinalDestination() {
        return this._finalDestination;
    }

    public String getFinalDestinationName() {
        if (this._finalDestination != null) {
            return this._finalDestination.getName();
        }
        return "";
    }

    public void setFinalDestinationTrack(Track track) {
        Track old = this._finalDestTrack;
        this._finalDestTrack = track;
        if (track == null) {
            this.setScheduleItemId("");
        }
        if (old != null && !old.equals(track) || track != null && !track.equals(old)) {
            if (old != null) {
                old.removePropertyChangeListener(this);
                old.deleteReservedInRoute(this);
            }
            if (this._finalDestTrack != null) {
                this._finalDestTrack.addReservedInRoute(this);
                this._finalDestTrack.addPropertyChangeListener(this);
            }
            this.setDirtyAndFirePropertyChange(FINAL_DESTINATION_TRACK_CHANGED_PROPERTY, old, track);
        }
    }

    public Track getFinalDestinationTrack() {
        return this._finalDestTrack;
    }

    public String getFinalDestinationTrackName() {
        if (this._finalDestTrack != null) {
            return this._finalDestTrack.getName();
        }
        return "";
    }

    public void setPreviousFinalDestination(Location location) {
        this._previousFinalDestination = location;
    }

    public Location getPreviousFinalDestination() {
        return this._previousFinalDestination;
    }

    public void setPreviousFinalDestinationTrack(Track track) {
        this._previousFinalDestTrack = track;
    }

    public Track getPreviousFinalDestinationTrack() {
        return this._previousFinalDestTrack;
    }

    public void setPreviousScheduleId(String id) {
        this._previousScheduleId = id;
    }

    public String getPreviousScheduleId() {
        return this._previousScheduleId;
    }

    public void setReturnWhenEmptyDestination(Location destination) {
        Location old = this._rweDestination;
        this._rweDestination = destination;
        if (old != null && !old.equals(destination) || destination != null && !destination.equals(old)) {
            this.setDirtyAndFirePropertyChange(RETURN_WHEN_EMPTY_CHANGED_PROPERTY, null, null);
        }
    }

    public Location getReturnWhenEmptyDestination() {
        return this._rweDestination;
    }

    public String getReturnWhenEmptyDestinationName() {
        if (this.getReturnWhenEmptyDestination() != null) {
            return this.getReturnWhenEmptyDestination().getName();
        }
        return "";
    }

    public void setReturnWhenEmptyDestTrack(Track track) {
        Track old = this._rweDestTrack;
        this._rweDestTrack = track;
        if (old != null && !old.equals(track) || track != null && !track.equals(old)) {
            this.setDirtyAndFirePropertyChange(RETURN_WHEN_EMPTY_CHANGED_PROPERTY, null, null);
        }
    }

    public Track getReturnWhenEmptyDestTrack() {
        return this._rweDestTrack;
    }

    public String getReturnWhenEmptyDestTrackName() {
        if (this.getReturnWhenEmptyDestTrack() != null) {
            return this.getReturnWhenEmptyDestTrack().getName();
        }
        return "";
    }

    public String getReturnWhenEmptyDestName() {
        if (this.getReturnWhenEmptyDestination() != null) {
            return String.valueOf(this.getReturnWhenEmptyDestinationName()) + "(" + this.getReturnWhenEmptyDestTrackName() + ")";
        }
        return "";
    }

    public void setReturnWhenLoadedDestination(Location destination) {
        Location old = this._rwlDestination;
        this._rwlDestination = destination;
        if (old != null && !old.equals(destination) || destination != null && !destination.equals(old)) {
            this.setDirtyAndFirePropertyChange(RETURN_WHEN_LOADED_CHANGED_PROPERTY, null, null);
        }
    }

    public Location getReturnWhenLoadedDestination() {
        return this._rwlDestination;
    }

    public String getReturnWhenLoadedDestinationName() {
        if (this.getReturnWhenLoadedDestination() != null) {
            return this.getReturnWhenLoadedDestination().getName();
        }
        return "";
    }

    public void setReturnWhenLoadedDestTrack(Track track) {
        Track old = this._rwlDestTrack;
        this._rwlDestTrack = track;
        if (old != null && !old.equals(track) || track != null && !track.equals(old)) {
            this.setDirtyAndFirePropertyChange(RETURN_WHEN_LOADED_CHANGED_PROPERTY, null, null);
        }
    }

    public Track getReturnWhenLoadedDestTrack() {
        return this._rwlDestTrack;
    }

    public String getReturnWhenLoadedDestTrackName() {
        if (this.getReturnWhenLoadedDestTrack() != null) {
            return this.getReturnWhenLoadedDestTrack().getName();
        }
        return "";
    }

    public String getReturnWhenLoadedDestName() {
        if (this.getReturnWhenLoadedDestination() != null) {
            return String.valueOf(this.getReturnWhenLoadedDestinationName()) + "(" + this.getReturnWhenLoadedDestTrackName() + ")";
        }
        return "";
    }

    protected boolean isRwlEnabled() {
        return !this.getReturnWhenLoadedLoadName().equals(this.carLoads.getDefaultLoadName()) || !this.getReturnWhenLoadedDestName().equals("");
    }

    public void setCaboose(boolean caboose) {
        boolean old = this._caboose;
        this._caboose = caboose;
        if (!old == caboose) {
            this.setDirtyAndFirePropertyChange("car is caboose", old ? "true" : "false", caboose ? "true" : "false");
        }
    }

    public boolean isCaboose() {
        return this._caboose;
    }

    public void setUtility(boolean utility) {
        boolean old = this._utility;
        this._utility = utility;
        if (!old == utility) {
            this.setDirtyAndFirePropertyChange("car is utility", old ? "true" : "false", utility ? "true" : "false");
        }
    }

    public boolean isUtility() {
        return this._utility;
    }

    public boolean isLocalMove() {
        if (this.getRouteLocation() == null || this.getRouteDestination() == null) {
            return false;
        }
        if (this.getRouteLocation().equals(this.getRouteDestination()) && this.getTrack() != null) {
            return true;
        }
        if (this.getTrain() == null) {
            return false;
        }
        if (this.getTrain().isLocalSwitcher() && TrainCommon.splitString(this.getRouteLocation().getName()).equals(TrainCommon.splitString(this.getRouteDestination().getName())) && this.getTrack() != null) {
            return true;
        }
        if (TrainCommon.splitString(this.getRouteLocation().getName()).equals(TrainCommon.splitString(this.getRouteDestination().getName())) && this.getTrain().getRoute() != null) {
            boolean foundRl = false;
            for (RouteLocation rl : this.getTrain().getRoute().getLocationsBySequenceList()) {
                if (foundRl) {
                    if (TrainCommon.splitString(this.getRouteDestination().getName()).equals(TrainCommon.splitString(rl.getName()))) {
                        if (this.getRouteDestination() != rl) continue;
                        return true;
                    }
                    return false;
                }
                if (!this.getRouteLocation().equals(rl)) continue;
                foundRl = true;
            }
        }
        return false;
    }

    public void setKernel(Kernel kernel) {
        if (this._kernel == kernel) {
            return;
        }
        String old = "";
        if (this._kernel != null) {
            old = this._kernel.getName();
            this._kernel.delete(this);
        }
        this._kernel = kernel;
        String newName = "";
        if (this._kernel != null) {
            this._kernel.add(this);
            newName = this._kernel.getName();
        }
        if (!old.equals(newName)) {
            this.setDirtyAndFirePropertyChange(KERNEL_NAME_CHANGED_PROPERTY, old, newName);
        }
    }

    public Kernel getKernel() {
        return this._kernel;
    }

    public String getKernelName() {
        if (this._kernel != null) {
            return this._kernel.getName();
        }
        return "";
    }

    public boolean isLead() {
        if (this.getKernel() != null) {
            return this.getKernel().isLead(this);
        }
        return false;
    }

    public void updateKernel() {
        if (this.isLead()) {
            for (Car car : this.getKernel().getCars()) {
                car.setFinalDestination(this.getFinalDestination());
                car.setFinalDestinationTrack(this.getFinalDestinationTrack());
                car.setLoadGeneratedFromStaging(this.isLoadGeneratedFromStaging());
                if (InstanceManager.getDefault(CarLoads.class).containsName(car.getTypeName(), this.getLoadName())) {
                    car.setLoadName(this.getLoadName());
                }
                if (!InstanceManager.getDefault(CarLoads.class).containsName(car.getTypeName(), this.getNextLoadName())) continue;
                car.setNextLoadName(this.getNextLoadName());
            }
        }
    }

    @Override
    public String testDestination(Location destination, Track track) {
        String status = super.testDestination(destination, track);
        if (!status.equals(Track.OKAY)) {
            return status;
        }
        if (track == null) {
            return status;
        }
        return track.checkSchedule(this);
    }

    @Override
    public String setDestination(Location destination, Track track) {
        return this.setDestination(destination, track, false);
    }

    @Override
    public String setDestination(Location destination, Track track, boolean force) {
        String destinationName = this.getDestinationName();
        Track destinationTrack = this.getDestinationTrack();
        String status = super.setDestination(destination, track, force);
        if (!status.equals(Track.OKAY)) {
            return status;
        }
        if (track != null && destinationTrack != track && this.loaded && !(status = track.scheduleNext(this)).equals(Track.OKAY)) {
            return status;
        }
        if (destinationName.equals("") || destination != null || this.getTrain() == null) {
            return status;
        }
        this.loadNext(destinationTrack);
        return status;
    }

    public void loadNext(Track destTrack) {
        this.setLoadGeneratedFromStaging(false);
        this.setWait(this.getNextWait());
        this.setNextWait(0);
        this.setPickupScheduleId(this.getNextPickupScheduleId());
        this.setNextPickupScheduleId("");
        if (destTrack != null) {
            if (destTrack.isSpur()) {
                this.updateLoad();
            } else if (destTrack.isStaging()) {
                if (destTrack.isLoadSwapEnabled() && this.getLoadName().equals(this.carLoads.getDefaultEmptyName())) {
                    this.setLoadLoaded();
                } else if ((destTrack.isLoadSwapEnabled() || destTrack.isLoadEmptyEnabled()) && this.getLoadName().equals(this.carLoads.getDefaultLoadName())) {
                    this.setLoadEmpty();
                } else if (destTrack.isRemoveCustomLoadsEnabled() && !this.getLoadName().equals(this.carLoads.getDefaultEmptyName()) && !this.getLoadName().equals(this.carLoads.getDefaultLoadName())) {
                    this.setFinalDestination(null);
                    this.setFinalDestinationTrack(null);
                    if (this.getLoadType().equals(CarLoad.LOAD_TYPE_EMPTY) && this.isRwlEnabled()) {
                        this.setLoadLoaded();
                    } else if (this.getLoadName().equals(this.getReturnWhenEmptyLoadName())) {
                        this.setLoadName(this.carLoads.getDefaultEmptyName());
                    } else {
                        this.setLoadEmpty();
                    }
                }
            }
        }
    }

    public void updateLoad() {
        if (this.getWait() > 0) {
            return;
        }
        if (!this.getNextLoadName().equals("")) {
            this.setLoadName(this.getNextLoadName());
            this.setNextLoadName("");
            if (this.getLoadName().equals(this.getReturnWhenEmptyLoadName()) && this.getFinalDestination() == null) {
                this.setReturnWhenEmpty();
            } else if (this.getLoadName().equals(this.getReturnWhenLoadedLoadName()) && this.getFinalDestination() == null) {
                this.setReturnWhenLoaded();
            }
        } else if (this.getLoadType().equals(CarLoad.LOAD_TYPE_EMPTY)) {
            this.setLoadLoaded();
        } else {
            this.setLoadEmpty();
        }
    }

    private void setLoadEmpty() {
        if (!this.getLoadName().equals(this.getReturnWhenEmptyLoadName())) {
            this.setLoadName(this.getReturnWhenEmptyLoadName());
            this.setReturnWhenEmpty();
        }
    }

    private void setReturnWhenEmpty() {
        if (this.getReturnWhenEmptyDestination() != null && (this.getLocation() != this.getReturnWhenEmptyDestination() || !this.getReturnWhenEmptyDestination().isStaging() && this.getTrack() != this.getReturnWhenEmptyDestTrack())) {
            this.setFinalDestination(this.getReturnWhenEmptyDestination());
            if (this.getReturnWhenEmptyDestTrack() != null) {
                this.setFinalDestinationTrack(this.getReturnWhenEmptyDestTrack());
            }
            log.debug("Car ({}) has return when empty destination ({}, {}) load {}", new Object[]{this.toString(), this.getFinalDestinationName(), this.getFinalDestinationTrackName(), this.getLoadName()});
        }
    }

    private void setLoadLoaded() {
        if (!this.getLoadName().equals(this.getReturnWhenLoadedLoadName())) {
            this.setLoadName(this.getReturnWhenLoadedLoadName());
            this.setReturnWhenLoaded();
        }
    }

    private void setReturnWhenLoaded() {
        if (this.getReturnWhenLoadedDestination() != null && (this.getLocation() != this.getReturnWhenLoadedDestination() || !this.getReturnWhenLoadedDestination().isStaging() && this.getTrack() != this.getReturnWhenLoadedDestTrack())) {
            this.setFinalDestination(this.getReturnWhenLoadedDestination());
            if (this.getReturnWhenLoadedDestTrack() != null) {
                this.setFinalDestinationTrack(this.getReturnWhenLoadedDestTrack());
            }
            log.debug("Car ({}) has return when loaded destination ({}, {}) load {}", new Object[]{this.toString(), this.getFinalDestinationName(), this.getFinalDestinationTrackName(), this.getLoadName()});
        }
    }

    public String getTypeExtensions() {
        StringBuffer buf = new StringBuffer();
        if (this.isCaboose()) {
            buf.append(EXTENSION_REGEX + CABOOSE_EXTENSION);
        }
        if (this.hasFred()) {
            buf.append(EXTENSION_REGEX + FRED_EXTENSION);
        }
        if (this.isPassenger()) {
            buf.append(EXTENSION_REGEX + PASSENGER_EXTENSION + EXTENSION_REGEX + this.getBlocking());
        }
        if (this.isUtility()) {
            buf.append(EXTENSION_REGEX + UTILITY_EXTENSION);
        }
        if (this.isHazardous()) {
            buf.append(EXTENSION_REGEX + HAZARDOUS_EXTENSION);
        }
        return buf.toString();
    }

    @Override
    public void reset() {
        this.setScheduleItemId(this.getPreviousScheduleId());
        this.setNextLoadName("");
        this.setNextWait(0);
        this.setFinalDestination(this.getPreviousFinalDestination());
        this.setFinalDestinationTrack(this.getPreviousFinalDestinationTrack());
        if (this.isLoadGeneratedFromStaging()) {
            this.setLoadGeneratedFromStaging(false);
            this.setLoadName(InstanceManager.getDefault(CarLoads.class).getDefaultEmptyName());
        }
        super.reset();
    }

    @Override
    public void dispose() {
        this.setKernel(null);
        this.setFinalDestination(null);
        this.setFinalDestinationTrack(null);
        InstanceManager.getDefault(CarTypes.class).removePropertyChangeListener(this);
        InstanceManager.getDefault(CarLengths.class).removePropertyChangeListener(this);
        super.dispose();
    }

    public Car(Element e) {
        super(e);
        Attribute a = e.getAttribute("passenger");
        if (a != null) {
            this._passenger = a.getValue().equals("true");
        }
        if ((a = e.getAttribute("hazardous")) != null) {
            this._hazardous = a.getValue().equals("true");
        }
        if ((a = e.getAttribute("caboose")) != null) {
            this._caboose = a.getValue().equals("true");
        }
        if ((a = e.getAttribute("fred")) != null) {
            this._fred = a.getValue().equals("true");
        }
        if ((a = e.getAttribute("utility")) != null) {
            this._utility = a.getValue().equals("true");
        }
        if ((a = e.getAttribute("kernel")) != null) {
            Kernel k = InstanceManager.getDefault(KernelManager.class).getKernelByName(a.getValue());
            if (k != null) {
                this.setKernel(k);
                a = e.getAttribute("leadKernel");
                if (a != null && a.getValue().equals("true")) {
                    this._kernel.setLead(this);
                }
            } else {
                log.error("Kernel {} does not exist", (Object)a.getValue());
            }
        }
        if ((a = e.getAttribute("load")) != null) {
            this._loadName = a.getValue();
        }
        if ((a = e.getAttribute("loadFromStaging")) != null && a.getValue().equals("true")) {
            this.setLoadGeneratedFromStaging(true);
        }
        if ((a = e.getAttribute("wait")) != null) {
            try {
                this._wait = Integer.parseInt(a.getValue());
            }
            catch (NumberFormatException numberFormatException) {
                log.error("Wait count ({}) for car ({}) isn't a valid number!", (Object)a.getValue(), (Object)this.toString());
            }
        }
        if ((a = e.getAttribute("pickupId")) != null) {
            this._pickupScheduleId = a.getValue();
        }
        if ((a = e.getAttribute("scheduleId")) != null) {
            this._scheduleId = a.getValue();
        }
        if ((a = e.getAttribute("nextLoad")) != null) {
            this._nextLoadName = a.getValue();
        }
        if ((a = e.getAttribute("nextWait")) != null) {
            try {
                this._nextWait = Integer.parseInt(a.getValue());
            }
            catch (NumberFormatException numberFormatException) {
                log.error("Next wait count ({}) for car ({}) isn't a valid number!", (Object)a.getValue(), (Object)this.toString());
            }
        }
        if ((a = e.getAttribute("nextPickupId")) != null) {
            this._nextPickupScheduleId = a.getValue();
        }
        if ((a = e.getAttribute("nextDestId")) != null) {
            this.setFinalDestination(InstanceManager.getDefault(LocationManager.class).getLocationById(a.getValue()));
        }
        if (this.getFinalDestination() != null && (a = e.getAttribute("nextDestTrackId")) != null) {
            this.setFinalDestinationTrack(this.getFinalDestination().getTrackById(a.getValue()));
        }
        if ((a = e.getAttribute("previousNextDestId")) != null) {
            this.setPreviousFinalDestination(InstanceManager.getDefault(LocationManager.class).getLocationById(a.getValue()));
        }
        if (this.getPreviousFinalDestination() != null && (a = e.getAttribute("previousNextDestTrackId")) != null) {
            this.setPreviousFinalDestinationTrack(this.getPreviousFinalDestination().getTrackById(a.getValue()));
        }
        if ((a = e.getAttribute("previousScheduleId")) != null) {
            this.setPreviousScheduleId(a.getValue());
        }
        if ((a = e.getAttribute("rweDestId")) != null) {
            this._rweDestination = InstanceManager.getDefault(LocationManager.class).getLocationById(a.getValue());
        }
        if (this._rweDestination != null && (a = e.getAttribute("rweDestTrackId")) != null) {
            this._rweDestTrack = this._rweDestination.getTrackById(a.getValue());
        }
        if ((a = e.getAttribute("rweLoad")) != null) {
            this._rweLoadName = a.getValue();
        }
        if ((a = e.getAttribute("rwlDestId")) != null) {
            this._rwlDestination = InstanceManager.getDefault(LocationManager.class).getLocationById(a.getValue());
        }
        if (this._rwlDestination != null && (a = e.getAttribute("rwlDestTrackId")) != null) {
            this._rwlDestTrack = this._rwlDestination.getTrackById(a.getValue());
        }
        if ((a = e.getAttribute("rwlLoad")) != null) {
            this._rwlLoadName = a.getValue();
        }
        this.addPropertyChangeListeners();
    }

    public Element store() {
        Element e = new Element("car");
        super.store(e);
        if (this.isPassenger()) {
            e.setAttribute("passenger", this.isPassenger() ? "true" : "false");
        }
        if (this.isHazardous()) {
            e.setAttribute("hazardous", this.isHazardous() ? "true" : "false");
        }
        if (this.isCaboose()) {
            e.setAttribute("caboose", this.isCaboose() ? "true" : "false");
        }
        if (this.hasFred()) {
            e.setAttribute("fred", this.hasFred() ? "true" : "false");
        }
        if (this.isUtility()) {
            e.setAttribute("utility", this.isUtility() ? "true" : "false");
        }
        if (this.getKernel() != null) {
            e.setAttribute("kernel", this.getKernelName());
            if (this.isLead()) {
                e.setAttribute("leadKernel", "true");
            }
        }
        e.setAttribute("load", this.getLoadName());
        if (this.isLoadGeneratedFromStaging()) {
            e.setAttribute("loadFromStaging", "true");
        }
        if (this.getWait() != 0) {
            e.setAttribute("wait", Integer.toString(this.getWait()));
        }
        if (!this.getPickupScheduleId().equals("")) {
            e.setAttribute("pickupId", this.getPickupScheduleId());
        }
        if (!this.getScheduleItemId().equals("")) {
            e.setAttribute("scheduleId", this.getScheduleItemId());
        }
        if (!this.getNextLoadName().equals("")) {
            e.setAttribute("nextLoad", this.getNextLoadName());
        }
        if (this.getNextWait() != 0) {
            e.setAttribute("nextWait", Integer.toString(this.getNextWait()));
        }
        if (!this.getNextPickupScheduleId().equals("")) {
            e.setAttribute("nextPickupId", this.getNextPickupScheduleId());
        }
        if (this.getFinalDestination() != null) {
            e.setAttribute("nextDestId", this.getFinalDestination().getId());
            if (this.getFinalDestinationTrack() != null) {
                e.setAttribute("nextDestTrackId", this.getFinalDestinationTrack().getId());
            }
        }
        if (this.getPreviousFinalDestination() != null) {
            e.setAttribute("previousNextDestId", this.getPreviousFinalDestination().getId());
            if (this.getPreviousFinalDestinationTrack() != null) {
                e.setAttribute("previousNextDestTrackId", this.getPreviousFinalDestinationTrack().getId());
            }
        }
        if (!this.getPreviousScheduleId().equals("")) {
            e.setAttribute("previousScheduleId", this.getPreviousScheduleId());
        }
        if (this.getReturnWhenEmptyDestination() != null) {
            e.setAttribute("rweDestId", this.getReturnWhenEmptyDestination().getId());
            if (this.getReturnWhenEmptyDestTrack() != null) {
                e.setAttribute("rweDestTrackId", this.getReturnWhenEmptyDestTrack().getId());
            }
        }
        if (!this.getReturnWhenEmptyLoadName().equals(this.carLoads.getDefaultEmptyName())) {
            e.setAttribute("rweLoad", this.getReturnWhenEmptyLoadName());
        }
        if (this.getReturnWhenLoadedDestination() != null) {
            e.setAttribute("rwlDestId", this.getReturnWhenLoadedDestination().getId());
            if (this.getReturnWhenLoadedDestTrack() != null) {
                e.setAttribute("rwlDestTrackId", this.getReturnWhenLoadedDestTrack().getId());
            }
        }
        if (!this.getReturnWhenLoadedLoadName().equals(this.carLoads.getDefaultLoadName())) {
            e.setAttribute("rwlLoad", this.getReturnWhenLoadedLoadName());
        }
        return e;
    }

    @Override
    protected void setDirtyAndFirePropertyChange(String p, Object old, Object n) {
        InstanceManager.getDefault(CarManagerXml.class).setDirty(true);
        super.setDirtyAndFirePropertyChange(p, old, n);
    }

    private void addPropertyChangeListeners() {
        InstanceManager.getDefault(CarTypes.class).addPropertyChangeListener(this);
        InstanceManager.getDefault(CarLengths.class).addPropertyChangeListener(this);
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        super.propertyChange(e);
        if (e.getPropertyName().equals("CarTypes Name") && e.getOldValue().equals(this.getTypeName())) {
            log.debug("Car ({}) sees type name change old: ({}) new: ({})", new Object[]{this.toString(), e.getOldValue(), e.getNewValue()});
            this.setTypeName((String)e.getNewValue());
        }
        if (e.getPropertyName().equals("CarLengthsName") && e.getOldValue().equals(this.getLength())) {
            log.debug("Car ({}) sees length name change old: ({}) new: ({})", new Object[]{this.toString(), e.getOldValue(), e.getNewValue()});
            this.setLength((String)e.getNewValue());
        }
        if (e.getPropertyName().equals("locationDispose") && e.getSource() == this._finalDestination) {
            log.debug("delete final destination for car: ({})", (Object)this.toString());
            this.setFinalDestination(null);
        }
        if (e.getPropertyName().equals("trackDispose") && e.getSource() == this._finalDestTrack) {
            log.debug("delete final destination for car: ({})", (Object)this.toString());
            this.setFinalDestinationTrack(null);
        }
    }
}

