/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.operations.rollingstock;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.MessageFormat;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import jmri.InstanceManager;
import jmri.jmrit.operations.OperationsFrame;
import jmri.jmrit.operations.locations.Location;
import jmri.jmrit.operations.locations.LocationManager;
import jmri.jmrit.operations.locations.Track;
import jmri.jmrit.operations.rollingstock.Bundle;
import jmri.jmrit.operations.rollingstock.RollingStock;
import jmri.jmrit.operations.rollingstock.cars.CarsSetFrame;
import jmri.jmrit.operations.routes.Route;
import jmri.jmrit.operations.routes.RouteLocation;
import jmri.jmrit.operations.setup.Setup;
import jmri.jmrit.operations.trains.Train;
import jmri.jmrit.operations.trains.TrainManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RollingStockSetFrame<T extends RollingStock>
extends OperationsFrame
implements PropertyChangeListener {
    protected LocationManager locationManager = InstanceManager.getDefault(LocationManager.class);
    protected TrainManager trainManager = InstanceManager.getDefault(TrainManager.class);
    RollingStock _rs;
    JLabel textRoad = new JLabel();
    JLabel textType = new JLabel();
    public JButton saveButton = new JButton(Bundle.getMessage("ButtonSave"));
    protected JButton ignoreAllButton = new JButton(Bundle.getMessage("IgnoreAll"));
    protected JComboBox<Location> locationBox = this.locationManager.getComboBox();
    protected JComboBox<Track> trackLocationBox = new JComboBox();
    protected JComboBox<Location> destinationBox = this.locationManager.getComboBox();
    protected JComboBox<Track> trackDestinationBox = new JComboBox();
    protected JComboBox<Location> finalDestinationBox = this.locationManager.getComboBox();
    protected JComboBox<Track> finalDestTrackBox = new JComboBox();
    protected JComboBox<Train> trainBox = this.trainManager.getTrainComboBox();
    protected JCheckBox autoTrackCheckBox = new JCheckBox(Bundle.getMessage("Auto"));
    protected JCheckBox autoDestinationTrackCheckBox = new JCheckBox(Bundle.getMessage("Auto"));
    protected JCheckBox autoFinalDestTrackCheckBox = new JCheckBox(Bundle.getMessage("Auto"));
    protected JCheckBox autoTrainCheckBox = new JCheckBox(Bundle.getMessage("Auto"));
    public JCheckBox locationUnknownCheckBox = new JCheckBox(Bundle.getMessage("LocationUnknown"));
    public JCheckBox outOfServiceCheckBox = new JCheckBox(Bundle.getMessage("OutOfService"));
    protected JCheckBox ignoreStatusCheckBox = new JCheckBox(Bundle.getMessage("Ignore"));
    protected JCheckBox ignoreLocationCheckBox = new JCheckBox(Bundle.getMessage("Ignore"));
    protected JCheckBox ignoreDestinationCheckBox = new JCheckBox(Bundle.getMessage("Ignore"));
    protected JCheckBox ignoreFinalDestinationCheckBox = new JCheckBox(Bundle.getMessage("Ignore"));
    protected JCheckBox ignoreTrainCheckBox = new JCheckBox(Bundle.getMessage("Ignore"));
    protected JPanel pOptional = new JPanel();
    protected JScrollPane paneOptional = new JScrollPane(this.pOptional);
    protected JPanel pFinalDestination = new JPanel();
    private static boolean autoTrackCheckBoxSelected = false;
    private static boolean autoDestinationTrackCheckBoxSelected = false;
    private static boolean autoFinalDestTrackCheckBoxSelected = false;
    private static boolean autoTrainCheckBoxSelected = false;
    RouteLocation rl;
    RouteLocation rd;
    private static final Logger log = LoggerFactory.getLogger(RollingStockSetFrame.class);

    public RollingStockSetFrame(String title) {
        super(title);
    }

    @Override
    public void initComponents() {
        JPanel pPanel = new JPanel();
        pPanel.setLayout(new BoxLayout(pPanel, 1));
        JPanel pRow1 = new JPanel();
        pRow1.setLayout(new BoxLayout(pRow1, 0));
        JPanel pRs = new JPanel();
        pRs.setLayout(new GridBagLayout());
        pRs.setBorder(BorderFactory.createTitledBorder(this.getRb().getString("rsType")));
        this.addItem(pRs, this.textRoad, 1, 0);
        pRow1.add(pRs);
        JPanel pType = new JPanel();
        pType.setLayout(new GridBagLayout());
        pType.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("Type")));
        this.addItem(pType, this.textType, 1, 0);
        pRow1.add(pType);
        JPanel pStatus = new JPanel();
        pStatus.setLayout(new GridBagLayout());
        pStatus.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("Status")));
        this.addItemLeft(pStatus, this.ignoreStatusCheckBox, 0, 0);
        this.addItemLeft(pStatus, this.locationUnknownCheckBox, 1, 1);
        this.addItemLeft(pStatus, this.outOfServiceCheckBox, 1, 0);
        pRow1.add(pStatus);
        pPanel.add(pRow1);
        JPanel pLocation = new JPanel();
        pLocation.setLayout(new GridBagLayout());
        pLocation.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("LocationAndTrack")));
        this.addItemLeft(pLocation, this.ignoreLocationCheckBox, 0, 1);
        this.addItem(pLocation, this.locationBox, 1, 1);
        this.addItem(pLocation, this.trackLocationBox, 2, 1);
        this.addItem(pLocation, this.autoTrackCheckBox, 3, 1);
        pPanel.add(pLocation);
        JPanel pOptional2 = new JPanel();
        JScrollPane paneOptional2 = new JScrollPane(pOptional2);
        pOptional2.setLayout(new BoxLayout(pOptional2, 1));
        paneOptional2.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("BorderLayoutOptionalProgram")));
        JPanel pDestination = new JPanel();
        pDestination.setLayout(new GridBagLayout());
        pDestination.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("DestinationAndTrack")));
        this.addItemLeft(pDestination, this.ignoreDestinationCheckBox, 0, 1);
        this.addItem(pDestination, this.destinationBox, 1, 1);
        this.addItem(pDestination, this.trackDestinationBox, 2, 1);
        this.addItem(pDestination, this.autoDestinationTrackCheckBox, 3, 1);
        pOptional2.add(pDestination);
        this.pFinalDestination.setLayout(new GridBagLayout());
        this.pFinalDestination.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("FinalDestinationAndTrack")));
        this.addItemLeft(this.pFinalDestination, this.ignoreFinalDestinationCheckBox, 0, 1);
        this.addItem(this.pFinalDestination, this.finalDestinationBox, 1, 1);
        this.addItem(this.pFinalDestination, this.finalDestTrackBox, 2, 1);
        this.addItem(this.pFinalDestination, this.autoFinalDestTrackCheckBox, 3, 1);
        pOptional2.add(this.pFinalDestination);
        JPanel pTrain = new JPanel();
        pTrain.setLayout(new GridBagLayout());
        pTrain.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("Train")));
        this.addItemLeft(pTrain, this.ignoreTrainCheckBox, 0, 0);
        this.addItem(pTrain, this.trainBox, 1, 0);
        this.addItem(pTrain, this.autoTrainCheckBox, 2, 0);
        pOptional2.add(pTrain);
        JPanel pButtons = new JPanel();
        pButtons.setLayout(new GridBagLayout());
        this.addItem(pButtons, this.ignoreAllButton, 1, 0);
        this.addItem(pButtons, this.saveButton, 2, 0);
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        this.getContentPane().add(pPanel);
        this.getContentPane().add(this.paneOptional);
        this.getContentPane().add(paneOptional2);
        this.getContentPane().add(pButtons);
        this.ignoreStatusCheckBox.setVisible(false);
        this.ignoreLocationCheckBox.setVisible(false);
        this.ignoreDestinationCheckBox.setVisible(false);
        this.ignoreFinalDestinationCheckBox.setVisible(false);
        this.ignoreTrainCheckBox.setVisible(false);
        this.ignoreAllButton.setVisible(false);
        this.addButtonAction(this.ignoreAllButton);
        this.addButtonAction(this.saveButton);
        this.addComboBoxAction(this.locationBox);
        this.addComboBoxAction(this.destinationBox);
        this.addComboBoxAction(this.finalDestinationBox);
        this.addComboBoxAction(this.trainBox);
        this.addCheckBoxAction(this.locationUnknownCheckBox);
        this.addCheckBoxAction(this.outOfServiceCheckBox);
        this.addCheckBoxAction(this.autoTrackCheckBox);
        this.addCheckBoxAction(this.autoDestinationTrackCheckBox);
        this.addCheckBoxAction(this.autoFinalDestTrackCheckBox);
        this.addCheckBoxAction(this.autoTrainCheckBox);
        this.addCheckBoxAction(this.ignoreStatusCheckBox);
        this.addCheckBoxAction(this.ignoreLocationCheckBox);
        this.addCheckBoxAction(this.ignoreDestinationCheckBox);
        this.addCheckBoxAction(this.ignoreFinalDestinationCheckBox);
        this.addCheckBoxAction(this.ignoreTrainCheckBox);
        this.autoTrackCheckBox.setSelected(autoTrackCheckBoxSelected);
        this.autoDestinationTrackCheckBox.setSelected(autoDestinationTrackCheckBoxSelected);
        this.autoFinalDestTrackCheckBox.setSelected(autoFinalDestTrackCheckBoxSelected);
        this.autoTrainCheckBox.setSelected(autoTrainCheckBoxSelected);
        this.autoTrackCheckBox.setToolTipText(this.getRb().getString("rsTipAutoTrack"));
        this.autoDestinationTrackCheckBox.setToolTipText(this.getRb().getString("rsTipAutoTrack"));
        this.autoFinalDestTrackCheckBox.setToolTipText(this.getRb().getString("rsTipAutoTrack"));
        this.autoTrainCheckBox.setToolTipText(Bundle.getMessage("rsTipAutoTrain"));
        this.locationUnknownCheckBox.setToolTipText(Bundle.getMessage("TipLocationUnknown"));
        this.ignoreStatusCheckBox.setToolTipText(Bundle.getMessage("TipIgnore"));
        this.ignoreLocationCheckBox.setToolTipText(Bundle.getMessage("TipIgnore"));
        this.ignoreDestinationCheckBox.setToolTipText(Bundle.getMessage("TipIgnore"));
        this.ignoreFinalDestinationCheckBox.setToolTipText(Bundle.getMessage("TipIgnore"));
        this.ignoreTrainCheckBox.setToolTipText(Bundle.getMessage("TipIgnore"));
        this.locationManager.addPropertyChangeListener(this);
        this.trainManager.addPropertyChangeListener(this);
        this.setMinimumSize(new Dimension(500, 500));
    }

    public void load(RollingStock rs) {
        this._rs = rs;
        this.textRoad.setText(String.valueOf(this._rs.getRoadName()) + " " + this._rs.getNumber());
        this.textType.setText(this._rs.getTypeName());
        this.locationUnknownCheckBox.setSelected(this._rs.isLocationUnknown());
        this.outOfServiceCheckBox.setSelected(this._rs.isOutOfService());
        this.updateComboBoxes();
        this.updateTrainComboBox();
        this.enableComponents(!this.locationUnknownCheckBox.isSelected());
        if (this._rs.getRouteLocation() != null || this._rs.getRouteDestination() != null) {
            if (this._rs.getRouteLocation() != null) {
                log.debug("rs ({}) has a pick up location ({})", (Object)this._rs.toString(), (Object)this._rs.getRouteLocation().getName());
            }
            if (this._rs.getRouteDestination() != null) {
                log.debug("rs ({}) has a destination ({})", (Object)this._rs.toString(), (Object)this._rs.getRouteDestination().getName());
            }
            if (this.getClass() == CarsSetFrame.class) {
                JOptionPane.showMessageDialog(this, this.getRb().getString("rsPressChangeWill"), this.getRb().getString("rsInRoute"), 2);
            } else {
                JOptionPane.showMessageDialog(this, this.getRb().getString("rsPressSaveWill"), this.getRb().getString("rsInRoute"), 2);
            }
        }
        this._rs.addPropertyChangeListener(this);
    }

    @Override
    public void buttonActionPerformed(ActionEvent ae) {
        if (ae.getSource() == this.saveButton) {
            this.save();
            if (Setup.isCloseWindowOnSaveEnabled()) {
                this.dispose();
            }
        }
    }

    protected abstract ResourceBundle getRb();

    protected boolean save() {
        return this.change(this._rs);
    }

    @SuppressFBWarnings(value={"ST_WRITE_TO_STATIC_FROM_INSTANCE_METHOD"}, justification="GUI ease of use")
    protected boolean change(RollingStock rs) {
        Train train;
        log.debug("Change button action for rs ({})", (Object)rs.toString());
        autoTrackCheckBoxSelected = this.autoTrackCheckBox.isSelected();
        autoDestinationTrackCheckBoxSelected = this.autoDestinationTrackCheckBox.isSelected();
        autoFinalDestTrackCheckBoxSelected = this.autoFinalDestTrackCheckBox.isSelected();
        autoTrainCheckBoxSelected = this.autoTrainCheckBox.isSelected();
        if (!this.ignoreStatusCheckBox.isSelected()) {
            rs.setLocationUnknown(this.locationUnknownCheckBox.isSelected());
            rs.setOutOfService(this.outOfServiceCheckBox.isSelected());
        }
        if (!this.changeLocation(rs)) {
            return false;
        }
        if (this.outOfServiceCheckBox.isSelected() && rs.getTrack() != null && rs.getTrack().isStaging()) {
            JOptionPane.showMessageDialog(this, this.getRb().getString("rsNeedToRemoveStaging"), this.getRb().getString("rsInStaging"), 2);
            rs.setLocation(null, null);
        }
        this.loadTrain(rs);
        if (!this.changeDestination(rs)) {
            return false;
        }
        this.updateTrainComboBox();
        if (!this.ignoreTrainCheckBox.isSelected() && (train = rs.getTrain()) != null) {
            if (!train.isTypeNameAccepted(rs.getTypeName())) {
                JOptionPane.showMessageDialog(this, MessageFormat.format(this.getRb().getString("rsTrainNotServType"), rs.getTypeName(), train.getName()), this.getRb().getString("rsNotMove"), 0);
                this.setRouteLocationAndDestination(rs, train, null, null);
                return false;
            }
            if (!train.isRoadNameAccepted(rs.getRoadName())) {
                JOptionPane.showMessageDialog(this, MessageFormat.format(this.getRb().getString("rsTrainNotServRoad"), rs.getRoadName(), train.getName()), this.getRb().getString("rsNotMove"), 0);
                this.setRouteLocationAndDestination(rs, train, null, null);
                return false;
            }
            if (!train.isBuiltDateAccepted(rs.getBuilt())) {
                JOptionPane.showMessageDialog(this, MessageFormat.format(this.getRb().getString("rsTrainNotServBuilt"), rs.getBuilt(), train.getName()), this.getRb().getString("rsNotMove"), 0);
                this.setRouteLocationAndDestination(rs, train, null, null);
                return false;
            }
            if (!train.isOwnerNameAccepted(rs.getOwner())) {
                JOptionPane.showMessageDialog(this, MessageFormat.format(this.getRb().getString("rsTrainNotServOwner"), rs.getOwner(), train.getName()), this.getRb().getString("rsNotMove"), 0);
                this.setRouteLocationAndDestination(rs, train, null, null);
                return false;
            }
            this.rl = null;
            this.rd = null;
            if (rs.getLocation() != null) {
                Route route = train.getRoute();
                if (route != null) {
                    this.rl = route.getLastLocationByName(rs.getLocationName());
                    this.rd = route.getLastLocationByName(rs.getDestinationName());
                }
                if (this.rl == null) {
                    JOptionPane.showMessageDialog(this, MessageFormat.format(this.getRb().getString("rsLocNotServ"), rs.getLocationName(), train.getName()), this.getRb().getString("rsNotMove"), 0);
                    this.setRouteLocationAndDestination(rs, train, null, null);
                    return false;
                }
                if (this.rd == null && !rs.getDestinationName().equals("")) {
                    JOptionPane.showMessageDialog(this, MessageFormat.format(this.getRb().getString("rsDestNotServ"), rs.getDestinationName(), train.getName()), this.getRb().getString("rsNotMove"), 0);
                    this.setRouteLocationAndDestination(rs, train, null, null);
                    return false;
                }
                if (this.rd != null && route != null) {
                    List<RouteLocation> routeSequence = route.getLocationsBySequenceList();
                    boolean foundTrainLoc = false;
                    boolean foundLoc = false;
                    boolean foundDes = false;
                    for (RouteLocation rlocation : routeSequence) {
                        if (train.isTrainEnRoute() && !foundTrainLoc) {
                            if (train.getCurrentRouteLocation() != rlocation) continue;
                            foundTrainLoc = true;
                        }
                        if (rs.getLocationName().equals(rlocation.getName())) {
                            this.rl = rlocation;
                            foundLoc = true;
                        }
                        if (!rs.getDestinationName().equals(rlocation.getName()) || !foundLoc) continue;
                        this.rd = rlocation;
                        foundDes = true;
                        if (rs.getDestinationTrack() == null || (rlocation.getTrainDirection() & rs.getDestinationTrack().getTrainDirections()) != 0) break;
                    }
                    if (!foundLoc) {
                        JOptionPane.showMessageDialog(this, MessageFormat.format(this.getRb().getString("rsTrainEnRoute"), rs.toString(), train.getName(), rs.getLocationName()), this.getRb().getString("rsNotMove"), 0);
                        this.setRouteLocationAndDestination(rs, train, null, null);
                        return false;
                    }
                    if (!foundDes) {
                        JOptionPane.showMessageDialog(this, MessageFormat.format(this.getRb().getString("rsLocOrder"), rs.getDestinationName(), rs.getLocationName(), train.getName()), this.getRb().getString("rsNotMove"), 0);
                        this.setRouteLocationAndDestination(rs, train, null, null);
                        return false;
                    }
                }
            }
        }
        return true;
    }

    private boolean changeLocation(RollingStock rs) {
        if (!this.ignoreLocationCheckBox.isSelected()) {
            if (this.locationBox.getSelectedItem() == null) {
                rs.setLocation(null, null);
            } else {
                if (this.trackLocationBox.getSelectedItem() == null) {
                    JOptionPane.showMessageDialog(this, this.getRb().getString("rsFullySelect"), this.getRb().getString("rsCanNotLoc"), 0);
                    return false;
                }
                if (rs.getLocation() == null || !rs.getLocation().equals(this.locationBox.getSelectedItem()) || rs.getTrack() == null || !rs.getTrack().equals(this.trackLocationBox.getSelectedItem())) {
                    String status = rs.setLocation((Location)this.locationBox.getSelectedItem(), (Track)this.trackLocationBox.getSelectedItem());
                    rs.setLastRouteId("");
                    if (!status.equals(Track.OKAY)) {
                        log.debug("Can't set rs's location because of {}", (Object)status);
                        JOptionPane.showMessageDialog(this, MessageFormat.format(this.getRb().getString("rsCanNotLocMsg"), rs.toString(), status), this.getRb().getString("rsCanNotLoc"), 0);
                        int results = JOptionPane.showOptionDialog(this, MessageFormat.format(this.getRb().getString("rsForce"), rs.toString(), (Track)this.trackLocationBox.getSelectedItem()), MessageFormat.format(this.getRb().getString("rsOverride"), status), 0, 3, null, null, null);
                        if (results == 0) {
                            log.debug("Force rolling stock to track");
                            rs.setLocation((Location)this.locationBox.getSelectedItem(), (Track)this.trackLocationBox.getSelectedItem(), true);
                        } else {
                            return false;
                        }
                    }
                }
            }
        }
        return true;
    }

    private void loadTrain(RollingStock rs) {
        if (!this.ignoreTrainCheckBox.isSelected()) {
            if (this.trainBox.getSelectedItem() == null) {
                if (rs.getTrain() != null) {
                    this.setRouteLocationAndDestination(rs, rs.getTrain(), null, null);
                }
                rs.setTrain(null);
            } else {
                Train train = (Train)this.trainBox.getSelectedItem();
                if (rs.getTrain() != null && !rs.getTrain().equals(train)) {
                    this.setRouteLocationAndDestination(rs, rs.getTrain(), null, null);
                }
                rs.setTrain(train);
            }
        }
    }

    private boolean changeDestination(RollingStock rs) {
        if (!this.ignoreDestinationCheckBox.isSelected()) {
            if (this.destinationBox.getSelectedItem() == null) {
                rs.setDestination(null, null);
            } else {
                String status;
                Track destTrack = null;
                if (this.trackDestinationBox.getSelectedItem() != null) {
                    destTrack = (Track)this.trackDestinationBox.getSelectedItem();
                }
                log.debug("changeDestination: {}, ({})", this.destinationBox.getSelectedItem(), (Object)destTrack);
                if (destTrack != null && rs.getDestinationTrack() != destTrack && destTrack.isStaging() && (rs.getTrain() == null || !rs.getTrain().isBuilt())) {
                    log.debug("Destination track ({}) is staging", (Object)destTrack.getName());
                    JOptionPane.showMessageDialog(this, this.getRb().getString("rsDoNotSelectStaging"), this.getRb().getString("rsCanNotDest"), 0);
                    return false;
                }
                if (destTrack != null && rs.getDestinationTrack() != destTrack && rs.getTrain() != null && rs.getTrain().isBuilt() && rs.getRouteLocation() != null) {
                    log.debug("Rolling stock ({}) has new track destination in built train ({})", (Object)rs.toString(), (Object)rs.getTrainName());
                    rs.getTrain().setModified(true);
                }
                if (!(status = rs.setDestination((Location)this.destinationBox.getSelectedItem(), destTrack)).equals(Track.OKAY)) {
                    log.debug("Can't set rs's destination because of {}", (Object)status);
                    JOptionPane.showMessageDialog(this, MessageFormat.format(this.getRb().getString("rsCanNotDestMsg"), rs.toString(), status), this.getRb().getString("rsCanNotDest"), 0);
                    return false;
                }
            }
        }
        return true;
    }

    protected void checkTrain(RollingStock rs) {
        Train train = rs.getTrain();
        if (train != null && train.isBuilt()) {
            if (!(rs.getRouteLocation() == null || rs.getRouteDestination() == null || this.rl == null || this.rd == null || rs.getRouteLocation().getName().equals(this.rl.getName()) && rs.getRouteDestination().getName().equals(this.rd.getName()) && rs.getDestinationTrack() != null)) {
                this.setRouteLocationAndDestination(rs, train, null, null);
            }
            if (rs.getRouteLocation() != null || rs.getRouteDestination() != null) {
                if (JOptionPane.showConfirmDialog(this, MessageFormat.format(this.getRb().getString("rsRemoveRsFromTrain"), rs.toString(), train.getName()), this.getRb().getString("rsInRoute"), 0) == 0) {
                    this.setRouteLocationAndDestination(rs, train, null, null);
                }
            } else if (this.rl != null && this.rd != null && rs.getDestinationTrack() != null) {
                if (rs.getDestinationTrack().getLocation().isStaging() && !rs.getDestinationTrack().equals(train.getTerminationTrack())) {
                    log.debug("Rolling stock destination track is staging and not the same as train");
                    JOptionPane.showMessageDialog(this, MessageFormat.format(Bundle.getMessage("rsMustSelectSameTrack"), train.getTerminationTrack().getName()), Bundle.getMessage("rsStagingTrackError"), 0);
                } else if (JOptionPane.showConfirmDialog(this, MessageFormat.format(this.getRb().getString("rsAddRsToTrain"), rs.toString(), train.getName()), this.getRb().getString("rsAddManuallyToTrain"), 0) == 0) {
                    this.setRouteLocationAndDestination(rs, train, this.rl, this.rd);
                    log.debug("Add rolling stock ({}) to train ({}) route pick up {} drop {}", new Object[]{rs.toString(), train.getName(), this.rl.getId(), this.rd.getId()});
                }
            }
        }
    }

    protected void setRouteLocationAndDestination(RollingStock rs, Train train, RouteLocation rl, RouteLocation rd) {
        if (rs.getRouteLocation() != null || rl != null) {
            train.setModified(true);
        }
        if (rl == null && rd == null && rs.getDestinationTrack() != null && rs.getDestinationTrack().getLocation().isStaging()) {
            log.debug("Rolling stock destination track is staging");
            rs.setDestination(null, null);
        }
        rs.setRouteLocation(rl);
        rs.setRouteDestination(rd);
    }

    protected void updateComboBoxes() {
        log.debug("update combo boxes");
        this.locationManager.updateComboBox(this.locationBox);
        this.locationManager.updateComboBox(this.destinationBox);
        this.locationManager.updateComboBox(this.finalDestinationBox);
        this.updateLocationComboBoxes();
        this.updateDestinationComboBoxes();
    }

    protected boolean updateGroup(List<T> list) {
        for (RollingStock rs : list) {
            if (rs == this._rs) continue;
            if (!this.ignoreStatusCheckBox.isSelected()) {
                rs.setLocationUnknown(this.locationUnknownCheckBox.isSelected());
                rs.setOutOfService(this.outOfServiceCheckBox.isSelected());
            }
            if (!this.changeLocation(rs)) {
                return false;
            }
            if (!this.changeDestination(rs)) {
                return false;
            }
            if (!this.ignoreTrainCheckBox.isSelected()) {
                if (this.trainBox.getSelectedItem() == null) {
                    rs.setTrain(null);
                } else {
                    rs.setTrain((Train)this.trainBox.getSelectedItem());
                }
            }
            rs.setRouteLocation(this._rs.getRouteLocation());
            rs.setRouteDestination(this._rs.getRouteDestination());
        }
        return true;
    }

    @Override
    public void checkBoxActionPerformed(ActionEvent ae) {
        log.debug("checkbox action ");
        if (ae.getSource() == this.locationUnknownCheckBox) {
            this.outOfServiceCheckBox.setSelected(this.locationUnknownCheckBox.isSelected());
            this.enableComponents(!this.locationUnknownCheckBox.isSelected());
        }
        if (ae.getSource() == this.autoTrackCheckBox) {
            this.updateLocationTrackComboBox();
        }
        if (ae.getSource() == this.autoDestinationTrackCheckBox) {
            this.updateDestinationTrackComboBox();
        }
        if (ae.getSource() == this.ignoreStatusCheckBox) {
            this.locationUnknownCheckBox.setEnabled(!this.ignoreStatusCheckBox.isSelected());
            this.outOfServiceCheckBox.setEnabled(!this.ignoreStatusCheckBox.isSelected());
        }
        if (ae.getSource() == this.ignoreLocationCheckBox) {
            this.locationBox.setEnabled(!this.ignoreLocationCheckBox.isSelected());
            this.trackLocationBox.setEnabled(!this.ignoreLocationCheckBox.isSelected());
            this.autoTrackCheckBox.setEnabled(!this.ignoreLocationCheckBox.isSelected());
        }
        if (ae.getSource() == this.ignoreDestinationCheckBox) {
            this.destinationBox.setEnabled(!this.ignoreDestinationCheckBox.isSelected());
            this.trackDestinationBox.setEnabled(!this.ignoreDestinationCheckBox.isSelected());
            this.autoDestinationTrackCheckBox.setEnabled(!this.ignoreDestinationCheckBox.isSelected());
        }
        if (ae.getSource() == this.ignoreFinalDestinationCheckBox) {
            this.finalDestinationBox.setEnabled(!this.ignoreFinalDestinationCheckBox.isSelected());
            this.finalDestTrackBox.setEnabled(!this.ignoreFinalDestinationCheckBox.isSelected());
            this.autoFinalDestTrackCheckBox.setEnabled(!this.ignoreFinalDestinationCheckBox.isSelected());
        }
        if (ae.getSource() == this.ignoreTrainCheckBox) {
            this.trainBox.setEnabled(!this.ignoreTrainCheckBox.isSelected());
            this.autoTrainCheckBox.setEnabled(!this.ignoreTrainCheckBox.isSelected());
        }
    }

    protected void enableComponents(boolean enabled) {
        this.locationBox.setEnabled(!this.ignoreLocationCheckBox.isSelected() & enabled);
        this.trackLocationBox.setEnabled(!this.ignoreLocationCheckBox.isSelected() & enabled);
        this.destinationBox.setEnabled(!this.ignoreDestinationCheckBox.isSelected() & enabled);
        this.trackDestinationBox.setEnabled(!this.ignoreDestinationCheckBox.isSelected() & enabled);
        this.finalDestinationBox.setEnabled(!this.ignoreFinalDestinationCheckBox.isSelected() & enabled);
        this.finalDestTrackBox.setEnabled(!this.ignoreFinalDestinationCheckBox.isSelected() & enabled);
        this.trainBox.setEnabled(!this.ignoreTrainCheckBox.isSelected() & enabled);
        this.autoTrackCheckBox.setEnabled(!this.ignoreLocationCheckBox.isSelected() & enabled);
        this.autoDestinationTrackCheckBox.setEnabled(!this.ignoreDestinationCheckBox.isSelected() & enabled);
        this.autoFinalDestTrackCheckBox.setEnabled(!this.ignoreFinalDestinationCheckBox.isSelected() & enabled);
        this.autoTrainCheckBox.setEnabled(!this.ignoreTrainCheckBox.isSelected() & enabled);
        this.locationUnknownCheckBox.setEnabled(!this.ignoreStatusCheckBox.isSelected());
        this.outOfServiceCheckBox.setEnabled(!this.ignoreStatusCheckBox.isSelected() & enabled);
        this.ignoreStatusCheckBox.setEnabled(enabled);
        this.ignoreLocationCheckBox.setEnabled(enabled);
        this.ignoreDestinationCheckBox.setEnabled(enabled);
        this.ignoreFinalDestinationCheckBox.setEnabled(Setup.isCarRoutingEnabled() & enabled);
        this.ignoreTrainCheckBox.setEnabled(enabled);
    }

    @Override
    public void comboBoxActionPerformed(ActionEvent ae) {
        if (ae.getSource() == this.locationBox) {
            this.updateLocationTrackComboBox();
        }
        if (ae.getSource() == this.destinationBox || ae.getSource() == this.trainBox) {
            this.updateDestinationTrackComboBox();
        }
    }

    protected void updateLocationComboBoxes() {
        log.debug("update location combo boxes");
        if (this._rs != null) {
            this.locationBox.setSelectedItem(this._rs.getLocation());
        }
        this.updateLocationTrackComboBox();
    }

    protected void updateLocationTrackComboBox() {
        log.debug("update location track combobox");
        if (this.locationBox.getSelectedItem() == null) {
            this.trackLocationBox.removeAllItems();
        } else {
            log.debug("RollingStockFrame sees location: {}", this.locationBox.getSelectedItem());
            Location l = (Location)this.locationBox.getSelectedItem();
            l.updateComboBox(this.trackLocationBox, this._rs, this.autoTrackCheckBox.isSelected(), false);
            if (this._rs != null && this._rs.getLocation() != null && this._rs.getLocation().equals(l) && this._rs.getTrack() != null) {
                this.trackLocationBox.setSelectedItem(this._rs.getTrack());
            }
        }
    }

    protected void updateDestinationComboBoxes() {
        log.debug("update destination combo boxes");
        if (this._rs != null) {
            this.destinationBox.setSelectedItem(this._rs.getDestination());
        }
        this.updateDestinationTrackComboBox();
    }

    protected void updateDestinationTrackComboBox() {
        log.debug("update destination track combobox");
        if (this.destinationBox.getSelectedItem() == null) {
            this.trackDestinationBox.removeAllItems();
        } else {
            Train train;
            log.debug("updateDestinationTrackComboBox destination: {}, ({})", this.destinationBox.getSelectedItem(), this.trackDestinationBox.getSelectedItem());
            Location destination = (Location)this.destinationBox.getSelectedItem();
            Track track = null;
            if (this.trackDestinationBox.getSelectedItem() != null) {
                track = (Track)this.trackDestinationBox.getSelectedItem();
            }
            destination.updateComboBox(this.trackDestinationBox, this._rs, this.autoDestinationTrackCheckBox.isSelected(), true);
            if (this.autoDestinationTrackCheckBox.isSelected() && this.trainBox.getSelectedItem() != null && (train = (Train)this.trainBox.getSelectedItem()).isBuilt() && train.getTerminationTrack() != null && train.getTerminationTrack().getLocation() == destination) {
                this.trackDestinationBox.addItem(train.getTerminationTrack());
                this.trackDestinationBox.setSelectedItem(track);
            }
            if (this._rs != null && this._rs.getDestination() != null && this._rs.getDestination().equals(destination) && this._rs.getDestinationTrack() != null) {
                this.trackDestinationBox.setSelectedItem(this._rs.getDestinationTrack());
            } else if (track != null) {
                this.trackDestinationBox.setSelectedItem(track);
            }
        }
    }

    protected void updateTrainComboBox() {
        log.debug("update train combo box");
        this.trainManager.updateTrainComboBox(this.trainBox);
        if (this._rs != null) {
            this.trainBox.setSelectedItem(this._rs.getTrain());
        }
    }

    protected void packFrame() {
        this.pack();
        this.setVisible(true);
    }

    @Override
    public void dispose() {
        if (this._rs != null) {
            this._rs.removePropertyChangeListener(this);
        }
        this.locationManager.removePropertyChangeListener(this);
        this.trainManager.removePropertyChangeListener(this);
        super.dispose();
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        log.debug("PropertyChange ({}) new: ({})", (Object)e.getPropertyName(), e.getNewValue());
        if (e.getPropertyName().equals("locationsListLength")) {
            this.updateComboBoxes();
        }
        if (e.getPropertyName().equals("TrainsListLength")) {
            this.updateTrainComboBox();
        }
        if (e.getPropertyName().equals("rolling stock track location")) {
            this.updateLocationComboBoxes();
        }
        if (e.getPropertyName().equals("rolling stock track destination")) {
            this.updateDestinationComboBoxes();
        }
        if (e.getPropertyName().equals("rolling stock train") && this._rs != null) {
            this.trainBox.setSelectedItem(this._rs.getTrain());
        }
    }
}

