/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.operations.rollingstock;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import jmri.InstanceManager;
import jmri.InstanceManagerAutoDefault;
import jmri.jmrit.XmlFile;
import jmri.jmrit.operations.OperationsXml;
import jmri.jmrit.operations.rollingstock.Bundle;
import jmri.jmrit.operations.rollingstock.RollingStock;
import jmri.jmrit.operations.rollingstock.cars.Car;
import jmri.jmrit.operations.rollingstock.cars.CarManager;
import jmri.jmrit.operations.rollingstock.engines.Engine;
import jmri.jmrit.operations.rollingstock.engines.EngineManager;
import jmri.jmrit.operations.setup.OperationsSetupXml;
import jmri.jmrit.operations.setup.Setup;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RollingStockLogger
extends XmlFile
implements InstanceManagerAutoDefault,
PropertyChangeListener {
    private boolean engLog = false;
    private boolean carLog = false;
    private boolean mustHaveTrack = true;
    private String operationsDirectory = String.valueOf(OperationsSetupXml.getFileLocation()) + OperationsSetupXml.getOperationsDirectoryName();
    private String loggingDirectory = String.valueOf(this.operationsDirectory) + File.separator + "logger";
    private String fileName;
    private static final Logger log = LoggerFactory.getLogger(RollingStockLogger.class);

    public void enableCarLogging(boolean enable) {
        if (enable) {
            this.addCarListeners();
        } else {
            this.removeCarListeners();
        }
    }

    public void enableEngineLogging(boolean enable) {
        if (enable) {
            this.addEngineListeners();
        } else {
            this.removeEngineListeners();
        }
    }

    private void store(RollingStock rs) {
        if (rs.getTrack() == null && this.mustHaveTrack) {
            return;
        }
        String carLoad = " ";
        String carFinalDest = " ";
        String carFinalDestTrack = " ";
        if (rs.getClass().equals(Car.class)) {
            Car car = (Car)rs;
            carLoad = car.getLoadName();
            carFinalDest = car.getFinalDestinationName();
            carFinalDestTrack = car.getFinalDestinationTrackName();
        }
        List<Object> line = Arrays.asList(rs.getNumber(), rs.getRoadName(), rs.getTypeName(), carLoad, rs.getLocationName(), rs.getTrackName(), carFinalDest, carFinalDestTrack, rs.getTrainName(), rs.getMoves(), this.getTime());
        this.fileOut(line);
        this.fileOut(line, rs);
    }

    private void fileOut(List<Object> line) {
        this.fileOut(line, this.getFile());
    }

    private void fileOut(List<Object> line, RollingStock rs) {
        this.fileOut(line, this.getFile(rs));
    }

    private void fileOut(List<Object> line, File file) {
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (CSVPrinter fileOut = new CSVPrinter((Appendable)new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file, true), StandardCharsets.UTF_8)), CSVFormat.DEFAULT);){
                log.debug("Log: {}", line);
                fileOut.printRecord(line);
                fileOut.flush();
                fileOut.close();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            log.error("Exception while opening log file: {}", (Object)e.getMessage());
        }
    }

    private File getFile() {
        File fileLogger = null;
        if (Setup.isEngineLoggerEnabled() || Setup.isCarLoggerEnabled()) {
            try {
                if (!this.checkFile(this.getFullLoggerFileName())) {
                    fileLogger = new File(this.getFullLoggerFileName());
                    File parentDir = fileLogger.getParentFile();
                    if (!parentDir.exists() && !parentDir.mkdirs()) {
                        log.error("logger directory not created");
                    }
                    if (fileLogger.createNewFile()) {
                        log.debug("new file created");
                        this.fileOut(this.getHeader());
                    }
                } else {
                    fileLogger = new File(this.getFullLoggerFileName());
                }
            }
            catch (IOException e) {
                log.error("Exception while making logging directory: {}", (Object)e.getMessage());
            }
        }
        return fileLogger;
    }

    private List<Object> getHeader() {
        return Arrays.asList(Bundle.getMessage("Number"), Bundle.getMessage("Road"), Bundle.getMessage("Type"), Bundle.getMessage("Load"), Bundle.getMessage("Location"), Bundle.getMessage("Track"), Bundle.getMessage("FinalDestination"), Bundle.getMessage("Track"), Bundle.getMessage("Train"), Bundle.getMessage("Moves"), Bundle.getMessage("DateAndTime"));
    }

    private File getFile(RollingStock rs) {
        File file = null;
        if (Setup.isEngineLoggerEnabled() || Setup.isCarLoggerEnabled()) {
            try {
                if (!this.checkFile(this.getFullLoggerFileName(rs))) {
                    file = new File(this.getFullLoggerFileName(rs));
                    File parentDir = file.getParentFile();
                    if (!parentDir.exists() && !parentDir.mkdirs()) {
                        log.error("logger directory not created");
                    }
                    if (file.createNewFile()) {
                        log.debug("new file created");
                        this.fileOut(this.getHeader(), rs);
                    }
                } else {
                    file = new File(this.getFullLoggerFileName(rs));
                }
            }
            catch (IOException e) {
                log.error("Exception while making logging directory: {}", (Object)e.getMessage());
            }
        }
        return file;
    }

    public String getFullLoggerFileName() {
        return String.valueOf(this.loggingDirectory) + File.separator + this.getFileName();
    }

    public String getDirectoryName() {
        return this.loggingDirectory;
    }

    public void setDirectoryName(String name) {
        this.loggingDirectory = name;
    }

    public String getFileName() {
        if (this.fileName == null) {
            this.fileName = String.valueOf(this.getDate()) + ".csv";
        }
        return this.fileName;
    }

    public String getFullLoggerFileName(RollingStock rs) {
        if (!OperationsXml.checkFileName(rs.toString())) {
            log.error("Rolling stock name ({}) must not contain reserved characters", (Object)rs);
            return String.valueOf(this.loggingDirectory) + File.separator + "rollingStock" + File.separator + "ERROR" + ".csv";
        }
        return String.valueOf(this.loggingDirectory) + File.separator + "rollingStock" + File.separator + rs.toString() + ".csv";
    }

    private String getDate() {
        Date date = Calendar.getInstance().getTime();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy_MM_dd");
        return simpleDateFormat.format(date);
    }

    private String getTime() {
        String time = Calendar.getInstance().getTime().toString();
        SimpleDateFormat dt = new SimpleDateFormat("EEE MMM dd HH:mm:ss z yyyy");
        SimpleDateFormat dtout = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
        try {
            return dtout.format(dt.parse(time));
        }
        catch (ParseException parseException) {
            return time;
        }
    }

    private void addCarListeners() {
        if (Setup.isCarLoggerEnabled() && !this.carLog) {
            log.debug("Rolling Stock Logger adding car listerners");
            this.carLog = true;
            List<Car> cars = InstanceManager.getDefault(CarManager.class).getList();
            cars.forEach(car -> car.addPropertyChangeListener(this));
            InstanceManager.getDefault(CarManager.class).addPropertyChangeListener(this);
        }
    }

    private void addEngineListeners() {
        if (Setup.isEngineLoggerEnabled() && !this.engLog) {
            this.engLog = true;
            log.debug("Rolling Stock Logger adding engine listerners");
            List<Engine> engines = InstanceManager.getDefault(EngineManager.class).getList();
            engines.forEach(engine -> engine.addPropertyChangeListener(this));
            InstanceManager.getDefault(EngineManager.class).addPropertyChangeListener(this);
        }
    }

    private void removeCarListeners() {
        if (this.carLog) {
            log.debug("Rolling Stock Logger removing car listerners");
            List<Car> cars = InstanceManager.getDefault(CarManager.class).getList();
            cars.forEach(car -> car.removePropertyChangeListener(this));
            InstanceManager.getDefault(CarManager.class).removePropertyChangeListener(this);
        }
        this.carLog = false;
    }

    private void removeEngineListeners() {
        if (this.engLog) {
            log.debug("Rolling Stock Logger removing engine listerners");
            List<Engine> engines = InstanceManager.getDefault(EngineManager.class).getList();
            engines.forEach(engine -> engine.removePropertyChangeListener(this));
            InstanceManager.getDefault(EngineManager.class).removePropertyChangeListener(this);
        }
        this.engLog = false;
    }

    public void dispose() {
        this.removeCarListeners();
        this.removeEngineListeners();
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        if (e.getPropertyName().equals("rolling stock track location")) {
            this.store((RollingStock)e.getSource());
        }
        if (e.getPropertyName().equals("RollingStockListLength") && (Integer)e.getNewValue() > (Integer)e.getOldValue()) {
            if (e.getSource().getClass().equals(CarManager.class)) {
                this.removeCarListeners();
                this.addCarListeners();
            } else if (e.getSource().getClass().equals(EngineManager.class)) {
                this.removeEngineListeners();
                this.addEngineListeners();
            }
        }
    }
}

