/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.operations.rollingstock;

import java.util.ArrayList;
import java.util.List;
import jmri.beans.PropertyChangeSupport;
import jmri.jmrit.operations.rollingstock.RollingStock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RollingStockGroup<T extends RollingStock>
extends PropertyChangeSupport {
    protected String _name = "";
    protected T _lead = null;
    protected List<T> _group = new ArrayList<T>();
    private static final Logger log = LoggerFactory.getLogger(RollingStockGroup.class);

    public RollingStockGroup(String name) {
        this._name = name;
    }

    public String getName() {
        return this._name;
    }

    public String toString() {
        return this._name;
    }

    public void add(T rs) {
        if (this._group.contains(rs)) {
            log.debug("rs ({}) already part of group ({})", (Object)((RollingStock)rs).toString(), (Object)this.getName());
            return;
        }
        if (this._group.size() <= 0) {
            this._lead = rs;
        }
        int oldSize = this._group.size();
        this._group.add(rs);
        this.firePropertyChange("grouplistLength", oldSize, this._group.size());
    }

    public void delete(T rs) {
        if (!this._group.contains(rs)) {
            log.debug("rs ({}) not part of group ({})", (Object)((RollingStock)rs).getId(), (Object)this.getName());
            return;
        }
        int oldSize = this._group.size();
        this._group.remove(rs);
        this.removeLead(rs);
        this.firePropertyChange("grouplistLength", oldSize, this._group.size());
    }

    public List<T> getGroup() {
        return this._group;
    }

    public int getTotalLength() {
        int length = 0;
        for (RollingStock rs : this._group) {
            length += rs.getTotalLength();
        }
        return length;
    }

    public int getAdjustedWeightTons() {
        int weightTons = 0;
        for (RollingStock rs : this._group) {
            weightTons += rs.getAdjustedWeightTons();
        }
        return weightTons;
    }

    public boolean isLead(T rs) {
        return rs == this._lead;
    }

    public T getLead() {
        return this._lead;
    }

    public int getSize() {
        return this._group.size();
    }

    public void setLead(T rs) {
        if (this._group.contains(rs)) {
            this._lead = rs;
        }
    }

    public void removeLead(T rs) {
        if (this.isLead(rs) && this._group.size() > 0) {
            this.setLead((RollingStock)this._group.get(0));
        }
    }

    public void dispose() {
    }
}

