/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.operations.rollingstock;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import jmri.IdTag;
import jmri.IdTagManager;
import jmri.InstanceManager;
import jmri.jmrit.operations.OperationsFrame;
import jmri.jmrit.operations.OperationsXml;
import jmri.jmrit.operations.locations.Location;
import jmri.jmrit.operations.locations.LocationManager;
import jmri.jmrit.operations.locations.Track;
import jmri.jmrit.operations.rollingstock.Bundle;
import jmri.jmrit.operations.rollingstock.RollingStock;
import jmri.jmrit.operations.rollingstock.RollingStockAttribute;
import jmri.jmrit.operations.rollingstock.RollingStockManager;
import jmri.jmrit.operations.rollingstock.cars.CarOwners;
import jmri.jmrit.operations.rollingstock.cars.CarRoads;
import jmri.jmrit.operations.rollingstock.engines.Engine;
import jmri.jmrit.operations.setup.Control;
import jmri.jmrit.operations.setup.Setup;
import jmri.swing.NamedBeanComboBox;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RollingStockEditFrame
extends OperationsFrame
implements PropertyChangeListener {
    protected static final boolean IS_SAVE = true;
    protected RollingStock _rs;
    protected LocationManager locationManager = InstanceManager.getDefault(LocationManager.class);
    JLabel textWeightTons = new JLabel(Bundle.getMessage("WeightTons"));
    JLabel textRfidSystemName = new JLabel();
    public JButton editRoadButton = new JButton(Bundle.getMessage("ButtonEdit"));
    public JButton clearRoadNumberButton = new JButton(Bundle.getMessage("ButtonClear"));
    public JButton editTypeButton = new JButton(Bundle.getMessage("ButtonEdit"));
    public JButton editLengthButton = new JButton(Bundle.getMessage("ButtonEdit"));
    public JButton editGroupButton = new JButton(Bundle.getMessage("ButtonEdit"));
    public JButton editOwnerButton = new JButton(Bundle.getMessage("ButtonEdit"));
    public JButton saveButton = new JButton(Bundle.getMessage("ButtonSave"));
    public JButton deleteButton = new JButton(Bundle.getMessage("ButtonDelete"));
    public JButton addButton = new JButton(Bundle.getMessage("ButtonAdd"));
    public JCheckBox autoTrackCheckBox = new JCheckBox(Bundle.getMessage("Auto"));
    public JTextField roadNumberTextField = new JTextField(Control.max_len_string_road_number);
    public JTextField builtTextField = new JTextField(Control.max_len_string_built_name + 3);
    public JTextField blockingTextField = new JTextField(4);
    public JTextField weightTextField = new JTextField(Control.max_len_string_weight_name);
    public JTextField weightTonsTextField = new JTextField(Control.max_len_string_weight_name);
    public JTextField commentTextField = new JTextField(35);
    public JTextArea valueTextArea = new JTextArea(3, 35);
    JScrollPane valueScroller = new JScrollPane(this.valueTextArea, 20, 30);
    public JComboBox<String> roadComboBox = InstanceManager.getDefault(CarRoads.class).getComboBox();
    public JComboBox<String> typeComboBox = this.getTypeManager().getComboBox();
    public JComboBox<String> lengthComboBox = this.getLengthManager().getComboBox();
    public JComboBox<String> ownerComboBox = InstanceManager.getDefault(CarOwners.class).getComboBox();
    public JComboBox<String> groupComboBox;
    public JComboBox<String> modelComboBox;
    public JComboBox<Location> locationBox = this.locationManager.getComboBox();
    public JComboBox<Track> trackLocationBox = new JComboBox();
    public NamedBeanComboBox<IdTag> rfidComboBox;
    public JPanel pTypeOptions = new JPanel();
    public JPanel pGroup = new JPanel();
    public JPanel pBlocking = new JPanel();
    public JPanel pColor = new JPanel();
    public JPanel pLoad = new JPanel();
    public JPanel pWeightOz = new JPanel();
    public JPanel pModel = new JPanel();
    public JPanel pPower = new JPanel();
    private static final Logger log = LoggerFactory.getLogger(RollingStockEditFrame.class);

    public RollingStockEditFrame(String title) {
        super(title);
    }

    protected abstract RollingStockAttribute getTypeManager();

    protected abstract RollingStockAttribute getLengthManager();

    protected abstract void buttonEditActionPerformed(ActionEvent var1);

    protected abstract ResourceBundle getRb();

    protected abstract void save(boolean var1);

    protected abstract void delete();

    @Override
    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"}, justification="Checks for null")
    public void initComponents() {
        this.deleteButton.setEnabled(false);
        this.saveButton.setEnabled(false);
        this.editRoadButton.setToolTipText(MessageFormat.format(Bundle.getMessage("TipAddDeleteReplace"), Bundle.getMessage("road")));
        this.editTypeButton.setToolTipText(MessageFormat.format(Bundle.getMessage("TipAddDeleteReplace"), Bundle.getMessage("type")));
        this.editLengthButton.setToolTipText(MessageFormat.format(Bundle.getMessage("TipAddDeleteReplace"), Bundle.getMessage("length")));
        this.editOwnerButton.setToolTipText(MessageFormat.format(Bundle.getMessage("TipAddDeleteReplace"), Bundle.getMessage("Owner").toLowerCase()));
        this.autoTrackCheckBox.setToolTipText(this.getRb().getString("rsTipAutoTrack"));
        JPanel pPanel = new JPanel();
        pPanel.setLayout(new BoxLayout(pPanel, 1));
        JPanel pRoad = new JPanel();
        pRoad.setLayout(new GridBagLayout());
        pRoad.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("Road")));
        this.addItem(pRoad, this.roadComboBox, 1, 0);
        this.addItem(pRoad, this.editRoadButton, 2, 0);
        pPanel.add(pRoad);
        JPanel pRoadNumber = new JPanel();
        pRoadNumber.setLayout(new GridBagLayout());
        pRoadNumber.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("RoadNumber")));
        this.addItem(pRoadNumber, this.roadNumberTextField, 1, 0);
        this.addItem(pRoadNumber, this.clearRoadNumberButton, 2, 0);
        pPanel.add(pRoadNumber);
        pPanel.add(this.pModel);
        this.pModel.setVisible(false);
        JPanel pType = new JPanel();
        pType.setLayout(new GridBagLayout());
        pType.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("Type")));
        this.addItem(pType, this.typeComboBox, 0, 0);
        this.addItem(pType, this.editTypeButton, 1, 0);
        this.addItemWidth(pType, this.pTypeOptions, 3, 0, 1);
        pPanel.add(pType);
        this.pBlocking.setLayout(new GridBagLayout());
        this.pBlocking.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("BorderLayoutBlockingOrder")));
        this.addItem(this.pBlocking, this.blockingTextField, 0, 0);
        this.blockingTextField.setText("0");
        pPanel.add(this.pBlocking);
        this.pBlocking.setVisible(false);
        JPanel pLength = new JPanel();
        pLength.setLayout(new GridBagLayout());
        pLength.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("Length")));
        this.addItem(pLength, this.lengthComboBox, 1, 0);
        this.addItem(pLength, this.editLengthButton, 2, 0);
        pPanel.add(pLength);
        JPanel pLocation = new JPanel();
        pLocation.setLayout(new GridBagLayout());
        pLocation.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("LocationAndTrack")));
        this.addItem(pLocation, this.locationBox, 1, 0);
        this.addItem(pLocation, this.trackLocationBox, 2, 0);
        this.addItem(pLocation, this.autoTrackCheckBox, 3, 0);
        pPanel.add(pLocation);
        JPanel pOptional = new JPanel();
        pOptional.setLayout(new BoxLayout(pOptional, 1));
        JScrollPane optionPane = new JScrollPane(pOptional);
        optionPane.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("BorderLayoutOptional")));
        JPanel pWeight = new JPanel();
        pWeight.setLayout(new BoxLayout(pWeight, 1));
        pWeight.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("Weight")));
        pWeight.add(this.pWeightOz);
        JPanel pWeightTons = new JPanel();
        pWeightTons.setLayout(new GridBagLayout());
        this.addItem(pWeightTons, this.textWeightTons, 0, 0);
        this.addItem(pWeightTons, this.weightTonsTextField, 1, 0);
        this.addItem(pWeightTons, new JLabel(), 2, 0);
        this.addItem(pWeightTons, new JLabel(), 3, 0);
        this.addItem(pWeightTons, new JLabel(), 4, 0);
        pWeight.add(pWeightTons);
        pOptional.add(pWeight);
        pOptional.add(this.pColor);
        this.pColor.setVisible(false);
        pOptional.add(this.pLoad);
        this.pLoad.setVisible(false);
        pOptional.add(this.pPower);
        this.pPower.setVisible(false);
        this.pGroup.setLayout(new GridBagLayout());
        this.addItem(this.pGroup, this.groupComboBox, 1, 0);
        this.addItem(this.pGroup, this.editGroupButton, 2, 0);
        pOptional.add(this.pGroup);
        JPanel pBuilt = new JPanel();
        pBuilt.setLayout(new GridBagLayout());
        pBuilt.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("Built")));
        this.addItem(pBuilt, this.builtTextField, 1, 0);
        pOptional.add(pBuilt);
        JPanel pOwner = new JPanel();
        pOwner.setLayout(new GridBagLayout());
        pOwner.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("Owner")));
        this.addItem(pOwner, this.ownerComboBox, 1, 0);
        this.addItem(pOwner, this.editOwnerButton, 2, 0);
        pOptional.add(pOwner);
        if (Setup.isValueEnabled()) {
            JPanel pValue = new JPanel();
            pValue.setLayout(new GridBagLayout());
            pValue.setBorder(BorderFactory.createTitledBorder(Setup.getValueLabel()));
            this.addItem(pValue, this.valueScroller, 1, 0);
            pOptional.add(pValue);
            this.adjustTextAreaColumnWidth(this.valueScroller, this.valueTextArea);
        }
        IdTagManager tagManager = InstanceManager.getNullableDefault(IdTagManager.class);
        if (Setup.isRfidEnabled() && tagManager != null) {
            JPanel pRfid = new JPanel();
            pRfid.setLayout(new GridBagLayout());
            pRfid.setBorder(BorderFactory.createTitledBorder(Setup.getRfidLabel()));
            this.rfidComboBox = new NamedBeanComboBox<IdTag>(tagManager);
            this.rfidComboBox.setAllowNull(true);
            this.rfidComboBox.setToolTipText(Bundle.getMessage("TipIdTag"));
            this.addItem(pRfid, this.rfidComboBox, 0, 0);
            this.addItem(pRfid, this.textRfidSystemName, 1, 0);
            pOptional.add(pRfid);
        }
        JPanel pComment = new JPanel();
        pComment.setLayout(new GridBagLayout());
        pComment.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("Comment")));
        this.addItem(pComment, this.commentTextField, 1, 0);
        pOptional.add(pComment);
        JPanel pButtons = new JPanel();
        pButtons.setLayout(new GridBagLayout());
        this.addItem(pButtons, this.deleteButton, 0, 25);
        this.addItem(pButtons, this.addButton, 1, 25);
        this.addItem(pButtons, this.saveButton, 3, 25);
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        this.getContentPane().add(pPanel);
        this.getContentPane().add(optionPane);
        this.getContentPane().add(pButtons);
        this.addEditButtonAction(this.editRoadButton);
        this.addEditButtonAction(this.editTypeButton);
        this.addEditButtonAction(this.editLengthButton);
        this.addEditButtonAction(this.editGroupButton);
        this.addEditButtonAction(this.editOwnerButton);
        this.addButtonAction(this.clearRoadNumberButton);
        this.addButtonAction(this.deleteButton);
        this.addButtonAction(this.addButton);
        this.addButtonAction(this.saveButton);
        this.addComboBoxAction(this.typeComboBox);
        this.addComboBoxAction(this.lengthComboBox);
        this.addComboBoxAction(this.locationBox);
        this.addCheckBoxAction(this.autoTrackCheckBox);
        this.autoTrackCheckBox.setEnabled(false);
        this.addPropertyChangeListeners();
        this.initMinimumSize(new Dimension(500, 500));
    }

    protected void load(RollingStock rs) {
        this._rs = rs;
        if (!InstanceManager.getDefault(CarRoads.class).containsName(rs.getRoadName()) && JOptionPane.showConfirmDialog(this, MessageFormat.format(Bundle.getMessage("roadNameNotExist"), rs.getRoadName()), Bundle.getMessage("addRoad"), 0) == 0) {
            InstanceManager.getDefault(CarRoads.class).addName(rs.getRoadName());
        }
        this.roadComboBox.setSelectedItem(rs.getRoadName());
        this.roadNumberTextField.setText(rs.getNumber());
        if (!this.getTypeManager().containsName(rs.getTypeName()) && JOptionPane.showConfirmDialog(this, MessageFormat.format(Bundle.getMessage("typeNameNotExist"), rs.getTypeName()), Bundle.getMessage("addType"), 0) == 0) {
            this.getTypeManager().addName(rs.getTypeName());
        }
        this.typeComboBox.setSelectedItem(rs.getTypeName());
        this.blockingTextField.setText(Integer.toString(rs.getBlocking()));
        if (!this.getLengthManager().containsName(rs.getLength()) && JOptionPane.showConfirmDialog(this, MessageFormat.format(Bundle.getMessage("lengthNameNotExist"), rs.getLength()), Bundle.getMessage("addLength"), 0) == 0) {
            this.getLengthManager().addName(rs.getLength());
        }
        this.lengthComboBox.setSelectedItem(rs.getLength());
        this.weightTextField.setText(rs.getWeight());
        this.weightTonsTextField.setText(rs.getWeightTons());
        this.locationBox.setSelectedItem(rs.getLocation());
        this.updateTrackLocationBox();
        this.builtTextField.setText(rs.getBuilt());
        if (!InstanceManager.getDefault(CarOwners.class).containsName(rs.getOwner()) && JOptionPane.showConfirmDialog(this, MessageFormat.format(Bundle.getMessage("ownerNameNotExist"), rs.getOwner()), Bundle.getMessage("addOwner"), 0) == 0) {
            InstanceManager.getDefault(CarOwners.class).addName(rs.getOwner());
        }
        this.ownerComboBox.setSelectedItem(rs.getOwner());
        this.commentTextField.setText(rs.getComment());
        this.valueTextArea.setText(rs.getValue());
        if (this.rfidComboBox != null) {
            this.rfidComboBox.setSelectedItem(rs.getIdTag());
            this.textRfidSystemName.setText(rs.getRfid());
        }
        this.deleteButton.setEnabled(true);
        this.saveButton.setEnabled(true);
        this.autoTrackCheckBox.setEnabled(true);
    }

    @Override
    public void comboBoxActionPerformed(ActionEvent ae) {
        if (ae.getSource() == this.typeComboBox && this.typeComboBox.getSelectedItem() != null) {
            this.autoTrackCheckBox.setSelected(false);
            this.autoTrackCheckBox.setEnabled(false);
            this.updateTrackLocationBox();
        }
        if (ae.getSource() == this.locationBox) {
            this.updateTrackLocationBox();
        }
    }

    @Override
    public void checkBoxActionPerformed(ActionEvent ae) {
        if (ae.getSource() == this.autoTrackCheckBox) {
            this.updateTrackLocationBox();
        }
    }

    @Override
    public void buttonActionPerformed(ActionEvent ae) {
        if (ae.getSource() == this.saveButton) {
            if (!this.check(this._rs)) {
                return;
            }
            this.save(true);
            OperationsXml.save();
            if (Setup.isCloseWindowOnSaveEnabled()) {
                this.dispose();
            }
        }
        if (ae.getSource() == this.addButton) {
            if (!this.check(null)) {
                return;
            }
            this.deleteButton.setEnabled(true);
            this.saveButton.setEnabled(true);
            this.save(false);
            OperationsXml.save();
        }
        if (ae.getSource() == this.deleteButton) {
            log.debug("rolling stock delete button activated");
            this.deleteButton.setEnabled(false);
            this.saveButton.setEnabled(false);
            if (this._rs != null) {
                this._rs.removePropertyChangeListener(this);
            }
            this.delete();
            this._rs = null;
            OperationsXml.save();
        }
        if (ae.getSource() == this.clearRoadNumberButton) {
            this.roadNumberTextField.setText("");
            this.roadNumberTextField.requestFocus();
        }
    }

    protected void updateTrackLocationBox() {
        if (this.locationBox.getSelectedItem() == null) {
            this.trackLocationBox.removeAllItems();
        } else {
            log.debug("Update tracks for location: {}", this.locationBox.getSelectedItem());
            Location loc = (Location)this.locationBox.getSelectedItem();
            loc.updateComboBox(this.trackLocationBox, this._rs, this.autoTrackCheckBox.isSelected(), false);
            if (this._rs != null && this._rs.getLocation() == loc) {
                this.trackLocationBox.setSelectedItem(this._rs.getTrack());
            }
        }
    }

    protected boolean check(RollingStock rs) {
        String[] s;
        String roadNum = this.roadNumberTextField.getText();
        if (roadNum.contains("-") && (s = roadNum.split("-")).length == 0) {
            JOptionPane.showMessageDialog(this, Bundle.getMessage("HyphenFeature"), Bundle.getMessage("roadNumNG"), 0);
            return false;
        }
        if (!OperationsXml.checkFileName(roadNum)) {
            JOptionPane.showMessageDialog(this, String.valueOf(Bundle.getMessage("NameResChar")) + "\n" + Bundle.getMessage("ReservedChar"), Bundle.getMessage("roadNumNG"), 0);
            return false;
        }
        if (roadNum.length() > Control.max_len_string_road_number) {
            JOptionPane.showMessageDialog(this, MessageFormat.format(this.getRb().getString("RoadNumMustBeLess"), Control.max_len_string_road_number + 1), this.getRb().getString("RoadNumTooLong"), 0);
            return false;
        }
        if (!this.weightTonsTextField.getText().trim().isEmpty()) {
            try {
                Integer.parseInt(this.weightTonsTextField.getText());
            }
            catch (Exception exception) {
                JOptionPane.showMessageDialog(this, this.getRb().getString("WeightFormatTon"), this.getRb().getString("WeightTonError"), 0);
                return false;
            }
        }
        return true;
    }

    protected <T extends RollingStock> void save(RollingStockManager<T> manager, boolean isSave) {
        if (!(!isSave || this._rs == null || this._rs.getRoadName().equals(this.roadComboBox.getSelectedItem()) && this._rs.getNumber().equals(this.roadNumberTextField.getText()))) {
            String road = (String)this.roadComboBox.getSelectedItem();
            String number = this.roadNumberTextField.getText();
            this._rs.setRoadName(road);
            this._rs.setNumber(number);
        }
        if (this._rs == null || !this._rs.getRoadName().equals(this.roadComboBox.getSelectedItem()) || !this._rs.getNumber().equals(this.roadNumberTextField.getText())) {
            this._rs = manager.newRS((String)this.roadComboBox.getSelectedItem(), this.roadNumberTextField.getText());
            this._rs.addPropertyChangeListener(this);
        }
        if (Engine.class.isInstance(this._rs) && this.modelComboBox.getSelectedItem() != null) {
            ((Engine)this._rs).setModel((String)this.modelComboBox.getSelectedItem());
        }
        if (this.typeComboBox.getSelectedItem() != null) {
            this._rs.setTypeName((String)this.typeComboBox.getSelectedItem());
        }
        int blocking = 0;
        try {
            blocking = Integer.parseInt(this.blockingTextField.getText());
            if (blocking < -100 || blocking > 100) {
                blocking = 0;
            }
        }
        catch (Exception exception) {
            log.warn("Blocking must be a number between -{} and {}", (Object)100, (Object)100);
        }
        this.blockingTextField.setText(Integer.toString(blocking));
        if (this.lengthComboBox.getSelectedItem() != null) {
            this._rs.setLength((String)this.lengthComboBox.getSelectedItem());
        }
        try {
            this._rs.setWeight(NumberFormat.getNumberInstance().parse(this.weightTextField.getText()).toString());
        }
        catch (ParseException parseException) {
            log.debug("Weight not a number");
        }
        this._rs.setWeightTons(this.weightTonsTextField.getText());
        this._rs.setBuilt(this.builtTextField.getText());
        if (this.ownerComboBox.getSelectedItem() != null) {
            this._rs.setOwner((String)this.ownerComboBox.getSelectedItem());
        }
        this._rs.setComment(this.commentTextField.getText());
        this._rs.setValue(this.valueTextArea.getText());
        if (this.rfidComboBox != null) {
            this._rs.setIdTag((IdTag)this.rfidComboBox.getSelectedItem());
            this.textRfidSystemName.setText(this._rs.getRfid());
        }
        this.autoTrackCheckBox.setEnabled(true);
        if (this.locationBox.getSelectedItem() != null && this.trackLocationBox.getSelectedItem() == null) {
            JOptionPane.showMessageDialog(this, this.getRb().getString("rsFullySelect"), this.getRb().getString("rsCanNotLoc"), 0);
        } else if (this._rs.getLocation() == null || !this._rs.getLocation().equals(this.locationBox.getSelectedItem()) || this._rs.getTrack() == null || !this._rs.getTrack().equals(this.trackLocationBox.getSelectedItem())) {
            this.setLocationAndTrack(this._rs);
        }
    }

    protected void setLocationAndTrack(RollingStock rs) {
        if (this.locationBox.getSelectedItem() == null) {
            rs.setLocation(null, null);
        } else {
            rs.setLastRouteId("");
            String status = rs.setLocation((Location)this.locationBox.getSelectedItem(), (Track)this.trackLocationBox.getSelectedItem());
            if (!status.equals(Track.OKAY)) {
                log.debug("Can't set rolling stock's location because of {}", (Object)status);
                JOptionPane.showMessageDialog(this, MessageFormat.format(this.getRb().getString("rsCanNotLocMsg"), rs.toString(), status), this.getRb().getString("rsCanNotLoc"), 0);
                int results = JOptionPane.showOptionDialog(this, MessageFormat.format(this.getRb().getString("rsForce"), rs.toString(), (Track)this.trackLocationBox.getSelectedItem()), MessageFormat.format(this.getRb().getString("rsOverride"), status), 0, 3, null, null, null);
                if (results == 0) {
                    log.debug("Force rolling stock to track");
                    rs.setLocation((Location)this.locationBox.getSelectedItem(), (Track)this.trackLocationBox.getSelectedItem(), true);
                }
            }
        }
    }

    protected void addEditButtonAction(JButton b) {
        b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RollingStockEditFrame.this.buttonEditActionPerformed(e);
            }
        });
    }

    @Override
    public void dispose() {
        this.removePropertyChangeListeners();
        super.dispose();
    }

    protected void addPropertyChangeListeners() {
        InstanceManager.getDefault(CarRoads.class).addPropertyChangeListener(this);
        this.getTypeManager().addPropertyChangeListener(this);
        this.getLengthManager().addPropertyChangeListener(this);
        InstanceManager.getDefault(CarOwners.class).addPropertyChangeListener(this);
        this.locationManager.addPropertyChangeListener(this);
    }

    protected void removePropertyChangeListeners() {
        InstanceManager.getDefault(CarRoads.class).removePropertyChangeListener(this);
        this.getTypeManager().removePropertyChangeListener(this);
        this.getLengthManager().removePropertyChangeListener(this);
        InstanceManager.getDefault(CarOwners.class).removePropertyChangeListener(this);
        this.locationManager.removePropertyChangeListener(this);
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        if (e.getPropertyName().equals("CarRoads Length")) {
            InstanceManager.getDefault(CarRoads.class).updateComboBox(this.roadComboBox);
            if (this._rs != null) {
                this.roadComboBox.setSelectedItem(this._rs.getRoadName());
            }
        }
        if (e.getPropertyName().equals("CarTypes Length") || e.getPropertyName().equals("EngineTypesLength")) {
            this.getTypeManager().updateComboBox(this.typeComboBox);
            if (this._rs != null) {
                this.typeComboBox.setSelectedItem(this._rs.getTypeName());
            }
        }
        if (e.getPropertyName().equals("CarOwners Length")) {
            InstanceManager.getDefault(CarOwners.class).updateComboBox(this.ownerComboBox);
            if (this._rs != null) {
                this.ownerComboBox.setSelectedItem(this._rs.getOwner());
            }
        }
        if (e.getPropertyName().equals("locationsListLength") || e.getPropertyName().equals("rolling stock track location")) {
            InstanceManager.getDefault(LocationManager.class).updateComboBox(this.locationBox);
            this.updateTrackLocationBox();
            if (this._rs != null && this._rs.getLocation() != null) {
                this.locationBox.setSelectedItem(this._rs.getLocation());
            }
        }
    }
}

