/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.operations.rollingstock;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.swing.JComboBox;
import jmri.beans.PropertyChangeSupport;
import jmri.util.StringUtil;
import org.jdom2.Attribute;
import org.jdom2.Content;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RollingStockAttribute
extends PropertyChangeSupport {
    protected static final int MIN_NAME_LENGTH = 1;
    protected List<String> list = new ArrayList<String>();
    protected String maxName = "";
    protected int maxNameLength = 0;
    protected int maxNameSubStringLength = 0;
    private static final Logger log = LoggerFactory.getLogger(RollingStockAttribute.class);

    public void dispose() {
        this.list.clear();
    }

    public String[] getNames() {
        if (this.list.isEmpty()) {
            this.list.addAll(Arrays.asList(this.getDefaultNames().split(",")));
        }
        return this.list.toArray(new String[0]);
    }

    protected String getDefaultNames() {
        return "Error";
    }

    public void setNames(String[] names) {
        if (names.length > 0) {
            Arrays.sort(names);
            String[] stringArray = names;
            int n = names.length;
            int n2 = 0;
            while (n2 < n) {
                String name = stringArray[n2];
                if (!this.list.contains(name)) {
                    this.list.add(name);
                }
                ++n2;
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    public void setValues(String[] lengths) {
        block8: {
            if (lengths.length == 0) {
                return;
            }
            try {
                StringUtil.numberSort(lengths);
                break block8;
            }
            catch (NumberFormatException v0) {
                RollingStockAttribute.log.error("lengths are not all numeric, list:");
                i = 0;
                ** while (i < lengths.length)
            }
lbl-1000:
            // 1 sources

            {
                try {
                    Integer.parseInt(lengths[i]);
                    RollingStockAttribute.log.error("length {} = {}", (Object)i, (Object)lengths[i]);
                }
                catch (NumberFormatException v1) {
                    RollingStockAttribute.log.error("length {} = {} is not a valid number!", (Object)i, (Object)lengths[i]);
                }
                ++i;
                continue;
            }
        }
        var5_4 = lengths;
        var4_5 = lengths.length;
        var3_6 = 0;
        while (var3_6 < var4_5) {
            length = var5_4[var3_6];
            if (!this.list.contains(length)) {
                this.list.add(length);
            }
            ++var3_6;
        }
    }

    public void sort() {
        Collections.sort(this.list);
    }

    public void addName(String name) {
        if (name == null) {
            return;
        }
        if (this.list.contains(name)) {
            return;
        }
        this.list.add(name);
        this.sort();
        this.maxNameLength = 0;
        this.maxNameSubStringLength = 0;
    }

    public void deleteName(String name) {
        this.list.remove(name);
        this.maxNameLength = 0;
        this.maxNameSubStringLength = 0;
    }

    public boolean containsName(String name) {
        return this.list.contains(name);
    }

    public JComboBox<String> getComboBox() {
        JComboBox<String> box = new JComboBox<String>();
        this.updateComboBox(box);
        return box;
    }

    public void updateComboBox(JComboBox<String> box) {
        box.removeAllItems();
        String[] stringArray = this.getNames();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            box.addItem(name);
            ++n2;
        }
    }

    public int getMaxNameLength() {
        if (this.maxNameLength == 0) {
            this.maxName = "";
            this.maxNameLength = this.getMinNameLength();
            String[] stringArray = this.getNames();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String name = stringArray[n2];
                if (name.length() > this.maxNameLength) {
                    this.maxName = name;
                    this.maxNameLength = name.length();
                }
                ++n2;
            }
        }
        return this.maxNameLength;
    }

    public int getMaxNameSubStringLength() {
        if (this.maxNameSubStringLength == 0) {
            this.maxName = "";
            this.maxNameSubStringLength = this.getMinNameLength();
            String[] stringArray = this.getNames();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String name = stringArray[n2];
                String[] subString = name.split("-");
                if (subString.length > 0 && subString[0].length() > this.maxNameSubStringLength) {
                    this.maxName = name;
                    this.maxNameSubStringLength = subString[0].length();
                }
                ++n2;
            }
        }
        return this.maxNameSubStringLength;
    }

    protected int getMinNameLength() {
        return 1;
    }

    public void store(Element root, String eNames, String eName) {
        Element names = new Element(eNames);
        String[] stringArray = this.getNames();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            Element e = new Element(eName);
            if (eName.equals("length")) {
                e.setAttribute(new Attribute("value", name));
            } else {
                e.setAttribute(new Attribute("name", name));
            }
            names.addContent((Content)e);
            ++n2;
        }
        root.addContent((Content)names);
    }

    public void load(Element root, String eNames, String eName, String oldName) {
        if (root.getChild(eNames) != null) {
            List l = root.getChild(eNames).getChildren(eName);
            String[] names = new String[l.size()];
            int i = 0;
            while (i < l.size()) {
                Element name = (Element)l.get(i);
                Attribute a = name.getAttribute("name");
                if (a != null) {
                    names[i] = a.getValue();
                }
                if ((a = name.getAttribute("value")) != null) {
                    names[i] = a.getValue();
                }
                ++i;
            }
            this.setNames(names);
        } else if (root.getChild(oldName) != null) {
            String[] names = root.getChildText(oldName).split("%%");
            this.setNames(names);
        }
    }
}

