/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.operations.rollingstock;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import javax.swing.BoxLayout;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.filechooser.FileNameExtensionFilter;
import jmri.jmrit.operations.OperationsXml;
import jmri.jmrit.operations.rollingstock.Bundle;
import jmri.util.JmriJFrame;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ImportRollingStock
extends Thread {
    protected static final String NEW_LINE = "\n";
    protected JLabel lineNumber = new JLabel();
    protected JLabel importLine = new JLabel();
    protected static final String LOCATION_TRACK_SEPARATOR = "-";
    protected JmriJFrame fstatus;
    private static final Logger log = LoggerFactory.getLogger(ImportRollingStock.class);

    protected File getFile() {
        JFileChooser fc = new JFileChooser(OperationsXml.getFileLocation());
        fc.setFileFilter(new FileNameExtensionFilter(Bundle.getMessage("Text&CSV"), "txt", "csv"));
        int retVal = fc.showOpenDialog(null);
        if (retVal != 0) {
            return null;
        }
        log.info("Importing from file: {}", (Object)fc.getSelectedFile());
        return fc.getSelectedFile();
    }

    protected BufferedReader getBufferedReader(File file) {
        try {
            return new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), StandardCharsets.UTF_8));
        }
        catch (FileNotFoundException fileNotFoundException) {
            return null;
        }
    }

    protected void createStatusFrame(String title) {
        JPanel ps = new JPanel();
        ps.setLayout(new BoxLayout(ps, 1));
        this.fstatus = new JmriJFrame(title);
        this.fstatus.setLocation(10, 10);
        this.fstatus.setSize(700, 100);
        ps.add(this.lineNumber);
        ps.add(this.importLine);
        this.fstatus.getContentPane().add(ps);
        this.fstatus.setVisible(true);
    }

    protected String[] parseCommaLine(String line) {
        Object[] outLine = new String[]{};
        try {
            CSVRecord record = (CSVRecord)CSVParser.parse((String)line, (CSVFormat)CSVFormat.DEFAULT).getRecords().get(0);
            outLine = new String[record.size()];
            int i = 0;
            while (i < outLine.length) {
                outLine[i] = record.get(i);
                ++i;
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
        }
        catch (IOException ex) {
            log.error("Error parsing CSV: {}", (Object)line, (Object)ex);
            Arrays.fill(outLine, "");
        }
        return outLine;
    }
}

